import type { IconProps } from "./types";

export const Cloud_line = ({
  size = 16,
  className,
  style,
  onClick,
}: IconProps) => (
  <svg
    className={className}
    style={style}
    width={size}
    height={size}
    onClick={onClick}
    xmlns="http://www.w3.org/2000/svg"
    viewBox="0 0 24 24"
  >
    <g stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
      <g>
        <path
          d="M24,0 L24,24 L0,24 L0,0 L24,0 Z M12.5934901,23.257841 L12.5819402,23.2595131 L12.5108777,23.2950439 L12.4918791,23.2987469 L12.4918791,23.2987469 L12.4767152,23.2950439 L12.4056548,23.2595131 C12.3958229,23.2563662 12.3870493,23.2590235 12.3821421,23.2649074 L12.3780323,23.275831 L12.360941,23.7031097 L12.3658947,23.7234994 L12.3769048,23.7357139 L12.4804777,23.8096931 L12.4953491,23.8136134 L12.4953491,23.8136134 L12.5071152,23.8096931 L12.6106902,23.7357139 L12.6232938,23.7196733 L12.6232938,23.7196733 L12.6266527,23.7031097 L12.609561,23.275831 C12.6075724,23.2657013 12.6010112,23.2592993 12.5934901,23.257841 L12.5934901,23.257841 Z M12.8583906,23.1452862 L12.8445485,23.1473072 L12.6598443,23.2396597 L12.6498822,23.2499052 L12.6498822,23.2499052 L12.6471943,23.2611114 L12.6650943,23.6906389 L12.6699349,23.7034178 L12.6699349,23.7034178 L12.678386,23.7104931 L12.8793402,23.8032389 C12.8914285,23.8068999 12.9022333,23.8029875 12.9078286,23.7952264 L12.9118235,23.7811639 L12.8776777,23.1665331 C12.8752882,23.1545897 12.8674102,23.1470016 12.8583906,23.1452862 L12.8583906,23.1452862 Z M12.1430473,23.1473072 C12.1332178,23.1423925 12.1221763,23.1452606 12.1156365,23.1525954 L12.1099173,23.1665331 L12.0757714,23.7811639 C12.0751323,23.7926639 12.0828099,23.8018602 12.0926481,23.8045676 L12.108256,23.8032389 L12.3092106,23.7104931 L12.3186497,23.7024347 L12.3186497,23.7024347 L12.3225043,23.6906389 L12.340401,23.2611114 L12.337245,23.2485176 L12.337245,23.2485176 L12.3277531,23.2396597 L12.1430473,23.1473072 Z"
          fillRule="nonzero"
        ></path>
        <path
          d="M5.00053,10.4161 C5.04543,6.86494 7.93814,4 11.5,4 C14.2856,4 16.66,5.75154 17.5856,8.21198 C20.13,8.90766 22,11.2346 22,14 C22,17.3137 19.3137,20 16,20 L7,20 C4.23858,20 2,17.7614 2,15 C2,12.9486 3.23468,11.1875 5.00053,10.4161 Z M11.5,6 C9.01472,6 7,8.01472 7,10.5 C7,10.6691 7.00928,10.8356 7.02729,10.9992 C7.08294,11.5047 6.75512,11.9678 6.26851,12.0896 C4.96468,12.4159 4,13.5965 4,15 C4,16.6569 5.34315,18 7,18 L16,18 C18.2091,18 20,16.2091 20,14 C20,12.0145 18.5524,10.3652 16.6552,10.0532 C16.2654,9.98915 15.9477,9.70337 15.8441,9.32051 C15.326,7.40663 13.576,6 11.5,6 Z"
          fill="currentColor"
        ></path>
      </g>
    </g>
  </svg>
);
