# 国际化文件书写规范

### 文件内容

每个语言文件由element-ui的国际化内容和自定义国际化内容组成，以zh_CN.js为例：

```js
import el from "element-ui/lib/locale/lang/zh-CN";

const message = {
  ...
}

export default {
  ...el, // element-ui的国际化内容
  ...message // 自定义内容
};
```

### 自定义内容

自定义部分按照业务模块划分，通用的写在commons内，例如

```js
const message = {
  commons: { // 通用
    ...
  },
  login: { // 登录
    ...
  },
  ... // 其他模块
}

```

### 层级结构

按照业务模块划分后，仍然可以按照子业务或功能再进行划分，但每个业务模块下不要超过3层，例如：

```js
const message = {
  user_manager: {
    user_list: { // 用户列表
      name: "姓名",
      search: {
        ... // 用户列表查询
      },
      ... // 用户列表
    },
    user_edit: {
      ... // 编辑用户
    }
  },
  ... // 其他模块
}

```

### Key命名

所有Key的命名必须采用英文单词的方式命名，多个单词之间用下划线( _ )连接，尽量让人一看就知道这个key代表的意思， 例如：user_list

```js
const message = {
  user_manager: {
    user_list: {
      ...
    },
    user_edit: {}
  },
}

```
