 {
 *
 *  libzplay - windows ( WIN32 ) multimedia library
 *
 *  ver: 2.00
 *  date: 22. April, 2010.
 *
 *  Copyright (C) 2003-2010 Zoran Cindori
 *
 *  Author: Zoran Cindori
 *  Web: http://libzplay.sourceforge.net/
 *  Email: zcindori@inet.hr
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 *
 * Supported by:
 *
 * ============================================================================
 * libmad - MPEG audio decoder library
 * Copyright (C) 2000-2004 Underbit Technologies, Inc. <support@underbit.com>
 * http://www.underbit.com/products/mad/
 * GNU General Public License ( GPL.TXT )
 * ============================================================================
 * THE OggVorbis SOURCE CODE IS (C) COPYRIGHT 1994-2002 
 * by the Xiph.Org Foundation http://www.xiph.org/
 * BSD-STYLE SOURCE LICENSE  ( XIPH.TXT )
 * ============================================================================
 * LIBA52
 * free library for decoding ATSC A/52 streams.
 * It is released under the terms of the GPL license.
 * ============================================================================
 * FLAC - Free Lossless Audio Codec
 * Copyright (C) 2001,2002,2003,2004,2005,2006,2007  Josh Coalson
 * http://flac.sourceforge.net/
 *
 * This file is part the FLAC project.  FLAC is comprised of several
 * components distributed under difference licenses.  The codec libraries
 * are distributed under Xiph.Org's BSD-like license (see the file
 * XIPH.TXT in this distribution).  All other programs, libraries, and
 * plugins are distributed under the LGPL or GPL (see LGPL.TXT and
 * GPL.TXT).  The documentation is distributed under the Gnu FDL (see
 * FDL.TXT).  Each file in the FLAC distribution contains at the top the
 * terms under which it may be distributed.
 *
 * Since this particular file is relevant to all components of FLAC,
 * it may be distributed under the Xiph.Org license, which is the least
 * restrictive of those mentioned above.  See the file XIPH.TXT in this
 * distribution.
 * ============================================================================
 * FAAD2 - Freeware Advanced Audio (AAC) Decoder including SBR decoding
 * Copyright (C) 2003-2005 M. Bakker, Nero AG, http://www.nero.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Any non-GPL usage of this software or parts of this software is strictly
 * forbidden.
 *
 * The "appropriate copyright message" mentioned in section 2c of the GPLv2
 * must read: "Code from FAAD2 is copyright (c) Nero AG, www.nero.com"
 *
 * Commercial non-GPL licensing of this software is possible.
 * For more info contact Nero AG through Mpeg4AAClicense@nero.com.
 *
 * ============================================================================
 * FAAC - Freeware Advanced Audio Coder Copyright (C) 2001 M. Bakker
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. 
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details. 
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *
 * ============================================================================
 * libmp3lame encoder
 * LAME 3.xx LAME Ain't an MP3 Encoder http://www.mp3dev.org March 2001 
 * 
 * Originally developed by Mike Cheng (www.uq.net.au/~zzmcheng).
 * Now maintained by Mark Taylor (www.mp3dev.org). 
 *
 * This code is distributed under the GNU LESSER PUBLIC LICENSE (LGPL, see www.gnu.org)
 * with the following modification: 
 * 
 * If you determine that distribution of LAME requires a patent license,
 * and you obtain a patent license, you may distribute LAME even though redistribution
 * of LAME may also require a patent license. 
 *
 * You agree not to enforce any patent claims for any aspect of MPEG audio compression,
 * or any other techniques contained in the LAME source code. 
 *
 * Copyrights (c) 1999-1007 by The LAME Project Copyrights (c) 1999,2000,2001
 * by Mark Taylor Copyrights (c) 1999,2000,2001 by Mark Taylor Copyrights
 * (c) 1998 by Michael Cheng Copyrights (c) 1995,1996,1997 by Michael Hipp: mpglib
 *
 * ============================================================================
 * SoundTouch library Copyright (c) Olli Parviainen 2002-2009 
 * http://www.surina.net/soundtouch
 * GNU Lesser General Public License vesrion 2.1 (LGPL.TXT )
 * ============================================================================
 * Center Cut DSP Plugin for Winamp 2.x 
 * Copyright (C) 2004  Moitah (moitah@yahoo.com)
 * GNU General Public License ( GPL.TXT )
 * ============================================================================
 * Shibatch Super Equalizer ver 0.03 for winamp
 * written by Naoki Shibata  shibatch@users.sourceforge.net
 * http://shibatch.sourceforge.net/
 *
 * Shibatch Super Equalizer (except FFT part) is distributed under LGPL.
 * See LGPL.txt for details.
 * FFT part is a routine made by Mr.Ooura. This routine is a freeware.
 * Contact Mr.Ooura for details of distributing licenses.
 * http://momonga.t.u-tokyo.ac.jp/~ooura/fft.html
 * ============================================================================
 * The Independent JPEG Group's JPEG software
 * JPEG decoding library
 * Copyright (C) 1991-2010, Thomas G. Lane, Guido Vollbeding.
 * www.ijg.org
 * ============================================================================
 * ZLIB DATA COMPRESSION LIBRARY
 * (C) 1995-2010 Jean-loup Gailly and Mark Adler
 * http://zlib.net/ 
 * ============================================================================
 * libpng library
 * PNG picture decoding library
 * Copyright (c) 2004, 2006-2007 Glenn Randers-Pehrson
 * http://www.libpng.org/
 * ============================================================================
*

}


unit libZPlay;
{$I ..\..\KaM_Remake.inc}
interface

uses
  Windows, SysUtils, Classes
  {$IFDEF WDC}, VCL.Graphics {$ENDIF}
  {$IFDEF FPC}, Graphics {$ENDIF}
  ;


type  TSettingID = (
        sidWaveBufferSize = 1,
        sidAccurateLength = 2,
        sidAccurateSeek = 3,
        sidSamplerate = 4,
        sidChannelNumber = 5,
        sidBitPerSample = 6,
        sidBigEndian = 7
);

type  TFFTGraphSize = (FFTGraphMinWidth = 100, FFTGraphMinHeight = 60);

const TWaveOutMapper: Integer = -1;
const TWaveInMapper: Integer = -1;

        
type TStreamFormat = (sfUnknown = 0,
                        sfMp3 = 1,
                        sfOgg = 2,
                        sfWav = 3,
                        sfPCM = 4,
                        sfFLAC = 5,
                        sfFLACOgg = 6,
		                    sfAC3 = 7,
		                    sfAacADTS = 8,
                        sfWaveIn = 9,
		                    sfAutodetect = 1000
);

type TBPMDetectionMethod = (
        dmPeaks = 0,
        dmAutoCorrelation = 1
);

type TFFTGraphParamID = (
        gpFFTPoints = 1,
        gpGraphType = 2,
        gpWindow = 3,
        gpHorizontalScale = 4,
        gpSubgrid = 5,
        gpTransparency = 6 ,
        gpFrequencyScaleVisible,
	    gpDecibelScaleVisible,
	    gpFrequencyGridVisible,
	    gpDecibelGridVisible,
	    gpBgBitmapVisible,
	    gpBgBitmapHandle,
	    gpColor1,
	    gpColor2,
	    gpColor3,
	    gpColor4,
	    gpColor5,
	    gpColor6,
	    gpColor7,
	    gpColor8,
	    gpColor9,
	    gpColor10,
	    gpColor11,
	    gpColor12,
	    gpColor13,
	    gpColor14,
	    gpColor15,
	    gpColor16
);

type TFFTGraphType = (
        gtLinesLeftOnTop = 0,
        gtLinesRightOnTop  = 1,
        gtAreaLeftOnTop = 2,
        gtAreaRightOnTop = 3,
        gtBarsLeftOnTop = 4,
        gtBarsRightOnTop = 5 ,
        gtSpectrum = 6
);

type TTimeFormat = (
        tfMillisecond = 1,
        tfSecond = 2,
        tfHMS = 4,
        tfSamples = 8
);

type TFFTWindow = (
        fwRectangular = 1,
        fwHamming = 2,
        fwHann = 3,
        fwCosine = 4,
        fwLanczos = 5,
        fwBartlett = 6,
        fwTriangular = 7,
        fwGauss = 8,
        fwBartlettHann = 9,
        fwBLackman = 10,
        fwNuttall = 11,
        fwBlackManHarris = 12,
        fwBlackmanNuttall = 13,
        fwFlatTop = 14
);


type TSeekMethod = (
        smFromBeginning = 1,
        smFromEnd = 2,
        smFromCurrentForward = 4,
        smFromCurrentBackward = 8
);


type TID3Version = (
        id3Version1 = 1,
        id3Version2 = 2
);



type
  TStreamLoadInfo = record
	  NumberOfBuffers: Cardinal;
	  NumberOfBytes: Cardinal;
end;



type TWaveOutFormat = (
format_invalid = 0,
format_11khz_8bit_mono = 1,
format_11khz_8bit_stereo = 2,
format_11khz_16bit_mono = 4,
format_11khz_16bit_stereo = 8,

format_22khz_8bit_mono = 16,
format_22khz_8bit_stereo = 32,
format_22khz_16bit_mono = 64,
format_22khz_16bit_stereo = 128,

format_44khz_8bit_mono = 256,
format_44khz_8bit_stereo = 512,
format_44khz_16bit_mono = 1024,
format_44khz_16bit_stereo = 2048
);

type TWaveOutFunctionality = (
supportPitchControl = 1,
supportPlaybackRateControl = 2,
supportVolumeControl = 4,
supportSeparateLeftRightVolume = 8,
supportSync = 16,
supportSampleAccuratePosition = 32,
supportDirectSound = 64
);


type
  TWaveOutInfo = record
    ManufacturerID: Cardinal;
    ProductID: Cardinal;
    DriverVersion: Cardinal;
    Formats: Cardinal;
    Channels: Cardinal;
    Support: Cardinal;
    ProductName: AnsiString;
end;

type
  TWaveOutInfoW = record
    ManufacturerID: Cardinal;
    ProductID: Cardinal;
    DriverVersion: Cardinal;
    Formats: Cardinal;
    Channels: Cardinal;
    Support: Cardinal;
    ProductName: WideString;
end;



type
  TWaveInInfo = record
    ManufacturerID: Cardinal;
    ProductID: Cardinal;
    DriverVersion: Cardinal;
    Formats: Cardinal;
    Channels: Cardinal;
    ProductName: AnsiString;
end;

type
  TWaveInInfoW = record
    ManufacturerID: Cardinal;
    ProductID: Cardinal;
    DriverVersion: Cardinal;
    Formats: Cardinal;
    Channels: Cardinal;
    ProductName: WideString;
end;


type
  TStreamHMSTime = record
    hour: Cardinal;
    minute: Cardinal;
    second: Cardinal;
    millisecond: Cardinal;
end;

type
  TStreamTime = record
	  sec: Cardinal;
	  ms: Cardinal;
    samples: Cardinal;
    hms: TStreamHMSTime
end;



type
  TID3Info = record
    Title: AnsiString;
    Artist: AnsiString;
    Album: AnsiString;
    Year: AnsiString;
    Comment: AnsiString;
    Track: AnsiString;
    Genre: AnsiString;
end;

type
  TID3InfoW = record
    Title: WideString;
    Artist: WideString;
    Album: WideString;
    Year: WideString;
    Comment: WideString;
    Track: WideString;
    Genre: WideString;
end;

type
  TID3Picture = record
	PicturePresent: Boolean;
	PictureType: Integer;
	Description: AnsiString;
  Bitmap: TPicture;
end;

type
  TID3PictureW = record
	PicturePresent: Boolean;
	PictureType: Integer;
	Description: WideString;
  Bitmap: TPicture;
end;


type
  TID3InfoExW = record
	Title: WideString;
	Artist: WideString;
	Album: WideString;
	Year: WideString;
	Comment: WideString;
	Track: WideString;
  Genre: WideString;
	AlbumArtist: WideString;
	Composer: WideString;
	OriginalArtist: WideString;
	Copyright: WideString;
	URL: WideString;
	Encoder: WideString;
	Publisher: WideString;
	BPM: Cardinal;
	Picture: TID3PictureW;
end;


type
  TID3InfoEx = record
	Title: AnsiString;
	Artist: AnsiString;
	Album: AnsiString;
	Year: AnsiString;
	Comment: AnsiString;
	Track: AnsiString;
  Genre: AnsiString;
	AlbumArtist: AnsiString;
	Composer: AnsiString;
	OriginalArtist: AnsiString;
	Copyright: AnsiString;
	URL: AnsiString;
	Encoder: AnsiString;
	Publisher: AnsiString;
	BPM: Cardinal;
	Picture: TID3Picture;
end;

type
  TStreamInfo = record
	  SamplingRate: Cardinal;
	  ChannelNumber: Cardinal;
    VBR: Boolean;
    Bitrate: Cardinal;
    Length: TStreamTime;
	  Description: AnsiString;
end;

type
  TStreamInfoW = record
 	  SamplingRate: Cardinal;
	  ChannelNumber: Cardinal;
    VBR: Boolean;
    Bitrate: Cardinal;
    Length: TStreamTime;
	  Description: WideString;
end;

// ===================================================================
// STREAM STATUS
type
  TStreamStatus = record
    fPlay: Boolean;
    fPause: Boolean;
    fEcho: Boolean;
    fEqualizer: Boolean;
    fVocalCut: Boolean;
    fSideCut: Boolean;
    fChannelMix: Boolean;
    fSlideVolume: Boolean;
    nLoop: Integer;
    fReverse: Boolean;
    nSongIndex: Integer;
	  nSongsInQueue: Integer;
end;


// ======================================================================

type
  TEchoEffect = record
    LeftDelay: Integer;
    LeftSrcVolume: Integer;
    LeftEchoVolume: Integer;
    RightDelay: Integer;
    RightSrcVolume: Integer;
    RightEchoVolume: Integer;
end;


type TDynamicEchoEffectArray = array of TEchoEffect;
type TDynamicIntegerArray = array of Integer;



type TFFTGraphHorizontalScale = ( gsLogarithmic = 0, gsLinear = 1);

type TCallbackMessage = (
MsgStopAsync = 1,
MsgPlayAsync = 2,
MsgEnterLoopAsync = 4,
MsgExitLoopAsync = 8,
MsgEnterVolumeSlideAsync = 16,
MsgExitVolumeSlideAsync = 32,
MsgStreamBufferDoneAsync = 64,
MsgStreamNeedMoreDataAsync = 128,
MsgNextSongAsync = 256,
MsgStop = 65536,
MsgPlay = 131072,
MsgEnterLoop = 262144,
MsgExitLoop = 524288,
MsgEnterVolumeSlide = 1048576,
MsgExitVolumeSlide = 2097152,
MsgStreamBufferDone = 4194304,
MsgStreamNeedMoreData = 8388608,
MsgNextSong = 16777216,
MsgWaveBuffer = 33554432,
MsgAll = -1,
MsgAllAsync = 65535,
MsgAllSync = -65536);


// =======================================================================

type TCallbackFunc = function(objptr: Pointer; user_data: Integer; msg: TCallbackMessage; param1: Cardinal; param2: Cardinal): Integer; stdcall;



// ===========================
 type ZPlay = class
  private
    { Private declarations }


    error_msg: AnsiString;
    error_msgW: WideString;
    objptr: Pointer;

    bitmap1: TPicture;
    bitmap2: TPicture;

  protected
    { Protected declarations }
  public
    { Public declarations }




    constructor Create;
    destructor Destroy; override;

    Function SetSettings(SettingID: TSettingID; Value: Integer): Integer;
    Function GetSettings(SettingID: TSettingID; Value: Integer): Integer;
    Function GetVersion(): Integer; stdcall;
    Function EnumerateWaveOut(): Integer;
    Function GetWaveOutInfo(Index: Cardinal; out WaveOutInfo: TWaveOutInfo): Integer;
    Function GetWaveOutInfoW(Index: Cardinal; out WaveOutInfo: TWaveOutInfoW): Integer;
    Function SetWaveOutDevice(Index: Cardinal): Integer;

    Function EnumerateWaveIn(): Integer;
    Function GetWaveInInfo(Index: Cardinal; out WaveInInfo: TWaveInInfo): Integer;
    Function GetWaveInInfoW(Index: Cardinal; out WaveInInfo: TWaveInInfoW): Integer;
    Function SetWaveInDevice(Index: Cardinal): Integer;

    Function GetError(): AnsiString;
    Function GetErrorW(): WideString;
    Function GetFileFormat(const FileName: AnsiString): TStreamFormat;
    Function GetFileFormatW(const FileName: WideString): TStreamFormat;
  
    Function SetCallbackFunc(CallbackFunc: TCallbackFunc; Messages: TCallbackMessage; UserData: Integer): Boolean;

    Procedure GetStreamInfo(out Info: TStreamInfo);
    Procedure GetStreamInfoW(out Info: TStreamInfoW);
    Function OpenFile(const FileName: AnsiString; Format: TStreamFormat): Boolean; overload;
    Function OpenFileW(const FileName: WideString; Format: TStreamFormat): Boolean; overload;

    Function SetWaveOutFile(const FileName: AnsiString; Format: TStreamFormat; fOutputToSoundcard: Boolean): Boolean; overload;
    Function SetWaveOutFileW(const FileName: WideString; Format: TStreamFormat; fOutputToSoundcard: Boolean): Boolean; overload;

    Function AddFile(const FileName: AnsiString; Format: TStreamFormat): Boolean; overload;
    Function AddFileW(const FileName: WideString; Format: TStreamFormat): Boolean; overload;



    Function OpenStream(Buffered: Integer;	Managed: Integer;  MemStream: Pointer; StreamSize: Cardinal; Format: TStreamFormat): Boolean;
    Function PushDataToStream(const MemNewData: Pointer; NewDataize: Cardinal): Boolean;
    Function IsStreamDataFree(const MemNewData: Pointer): Boolean;
    Procedure GetDynamicStreamLoad(out Load: TStreamLoadInfo);
    Function Close(): Boolean;
    Function LoadID3(Id3Version: TID3Version; out Info: TID3Info): Boolean;
    Function LoadID3W(Id3Version: TID3Version; out Info: TID3InfoW): Boolean;
    Function LoadID3Ex(out Info: TID3InfoEx; fDecodeEmbededPicture: Boolean): Boolean;
    Function LoadID3ExW(out Info: TID3InfoExW; fDecodeEmbededPicture: Boolean): Boolean;

    Function LoadFileID3(FileName: AnsiString; Format: TStreamFormat; Id3Version: TID3Version; out Info: TID3Info): Boolean;
    Function LoadFileID3W(FileName: WideString; Format: TStreamFormat; Id3Version: TID3Version; out Info: TID3InfoW): Boolean;

    Function LoadFileID3Ex(FileName: AnsiString; Format: TStreamFormat;  out Info: TID3InfoEx; fDecodeEmbededPicture: Boolean): Boolean;
    Function LoadFileID3ExW(FileName: WideString; Format: TStreamFormat;  out Info: TID3InfoExW; fDecodeEmbededPicture: Boolean): Boolean;


    Procedure GetStatus(out Status: TStreamStatus);
    Procedure GetPosition(out Position: TStreamTime);
    Function StartPlayback(): Boolean;
    Function StopPlayback(): Boolean;
    Function PausePlayback(): Boolean;
    Function ResumePlayback(): Boolean;
    Function Seek(TimeFormat: TTimeFormat; var Position: TStreamTime; MoveMethod: TSeekMethod): Boolean;
    Function PlayLoop(TimeFormatStart: TTimeFormat; var StartPosition: TStreamTime; TimeFormatEnd: TTimeFormat; var EndPosition: TStreamTime; NumOfCycles: Cardinal; ContinuePlaying: Cardinal): Boolean;
    Function ReverseMode(Enable: Boolean): Boolean;
    Function SlideVolume(TimeFormatStart: TTimeFormat;
                          TimeStart: TStreamTime;
                          StartVolumeLeft: Cardinal;
                          StartVolumeRight: Cardinal;
                          TimeFormatEnd: TTimeFormat;
                          TimeEnd: TStreamTime;
                          EndVolumeLeft: Cardinal;
                          EndVolumeRight: Cardinal): Boolean;

    Function SetMasterVolume(LeftVolume: Cardinal; RightVolume: Cardinal): Boolean;
    Function SetPlayerVolume(LeftVolume: Cardinal; RightVolume: Cardinal): Boolean;
    Procedure GetMasterVolume(out LeftVolume: Integer; out RightVolume: Integer);
    Procedure GetPlayerVolume(out LeftVolume: Integer; out RightVolume: Integer);
    Procedure GetVUData(out LeftChannel: Cardinal; out RightChannel: Cardinal);
    Function GetBitrate(Average: Boolean): Integer;
    Function EnableEcho(Enable: Boolean): Boolean;
    Function SetEchoParam(var EchoEffectArray: array of TEchoEffect; NumberOfEffects: Integer): Boolean;
    Function GetEchoParam(out EchoEffectArray: TDynamicEchoEffectArray): Integer;
    Function EnableEqualizer(Enable: Boolean): Boolean;
    Function SetEqualizerPoints(var FreqPointArray: array of Integer; NumberOfPoints: Integer): Boolean;
    Function GetEqualizerPoints(out FreqPointArray: TDynamicIntegerArray): Integer;
    Function SetEqualizerParam(PreAmpGain: Integer; var BandGain: array of Integer; NumberOfBands:Integer): Boolean;
    Function GetEqualizerParam(out PreAmpGain: Integer; out BandGain: TDynamicIntegerArray): Integer;
    Function SetEqualizerPreampGain(Gain: Integer): Boolean;
    Function GetEqualizerPreampGain(): Integer;
    Function SetEqualizerBandGain(BandIndex: Integer; Gain: Integer): Boolean;
    Function GetEqualizerBandGain(BandIndex: Integer): Integer;
    Function StereoCut(Enable: Boolean; OutputCenter: Boolean; BassToSides: Boolean):Boolean;
    Function MixChannels(Enable: Boolean; LeftPercent: Cardinal; RightPercent: Cardinal): Boolean;
    Function SetRate(Rate: Cardinal): Boolean;
    Function GetRate(): Cardinal;
    Function SetPitch(Pitch: Cardinal): Boolean;
    Function GetPitch(): Cardinal;
    Function SetTempo(Tempo: Cardinal): Boolean;
    Function GetTempo(): Cardinal;
    Function GetFFTData(FFTPoints: Integer; FFTWindow: TFFTWindow; out HarmonicNumber: Integer;
                         HarmonicFreq: TDynamicIntegerArray;  LeftAmplitude: TDynamicIntegerArray;
                          RightAmplitude: TDynamicIntegerArray;
                           LeftPhase: TDynamicIntegerArray;  RightPhase : TDynamicIntegerArray): Boolean;


    Function DrawFFTGraphOnHDC(hdc: HDC; X: Integer; Y: Integer; Width: Integer; Height: Integer): Boolean;
    Function DrawFFTGraphOnHWND(hwnd: HWND; X: Integer; Y: Integer; Width: Integer; Height: Integer): Boolean;
    Function SetFFTGraphParam(ParamID: TFFTGraphParamID; ParamValue: Integer): Boolean;
    Function GetFFTGraphParam(ParamID: TFFTGraphParamID): Integer;


    Function DetectBPM(Method: TBPMDetectionMethod): Integer;
    Function DetectFileBPM(const FileName: AnsiString; Format: TStreamFormat; Method: TBPMDetectionMethod): Integer;
    Function DetectFileBPMW(const FileName: WideString; Format: TStreamFormat; Method: TBPMDetectionMethod): Integer;
  end;


implementation

type PSTREAM_LOAD_INFO = ^TStreamLoadInfo;


type
  ID3_PICTURE = record
	PicturePresent: Cardinal;
	CanDrawPicture: Cardinal;
	MIMEType: PAnsiChar;
	PictureType: Integer;
	Description: PAnsiChar;
	PictureData: Pointer;
	PictureDataSize: Integer;
	hBitmap: HBITMAP;
	Width: Cardinal;
	Height: Cardinal;
	reserved: array[0..128] of Char;
end;

type
  ID3_PICTUREW = record
	PicturePresent: Cardinal;
	CanDrawPicture: Cardinal;
	MIMEType: PWideChar;
	PictureType: Integer;
	Description: PWideChar;
	PictureData: Pointer;
	PictureDataSize: Integer;
	hBitmap: HBITMAP;
	Width: Cardinal;
	Height: Cardinal;
	reserved: array[0..128] of Char;
end;

type
    ID3_INFO = record
      Title: PAnsiChar;
      Artist: PAnsiChar;
      Album: PAnsiChar;
      Year: PAnsiChar;
      Comment: PAnsiChar;
      TrackNum: PAnsiChar;
      Genre: PAnsiChar;
end;

type
    ID3_INFOW = record
      Title: PWideChar;
      Artist: PWideChar;
      Album: PWideChar;
      Year: PWideChar;
      Comment: PWideChar;
      TrackNum: PWideChar;
      Genre: PWideChar;
end;





type
  ID3_INFOEX = record
	Title: PAnsiChar;
	Artist: PAnsiChar;
	Album: PAnsiChar;
	Year: PAnsiChar;
	Comment: PAnsiChar;
	TrackNum: PAnsiChar;
  Genre: PAnsiChar;
	AlbumArtist: PAnsiChar;
	Composer: PAnsiChar;
	OriginalArtist: PAnsiChar;
	Copyright: PAnsiChar;
	URL: PAnsiChar;
	Encoder: PAnsiChar;
	Publisher: PAnsiChar;
	BPM: Cardinal;
	Picture: ID3_PICTURE;
	reserved: array[0 .. 128] of Char;
end;

type
  ID3_INFOEXW = record
	Title: PWideChar;
	Artist: PWideChar;
	Album: PWideChar;
	Year: PWideChar;
	Comment: PWideChar;
	TrackNum: PWideChar;
  Genre: PWideChar;
	AlbumArtist: PWideChar;
	Composer: PWideChar;
	OriginalArtist: PWideChar;
	Copyright: PWideChar;
	URL: PWideChar;
	Encoder: PWideChar;
	Publisher: PWideChar;
	BPM: Cardinal;
	Picture: ID3_PICTUREW;
	reserved: array[0 .. 128] of Char;
end;

type PID3_INFOEX = ^ID3_INFOEX;
type PID3_INFOEXW = ^ID3_INFOEXW;
type PID3_PICTURE = ^ID3_PICTURE;
type PID3_PICTUREW = ^ID3_PICTUREW;
type PECHO_EFFECT = ^TEchoEffect;
type PID3_INFO = ^ID3_INFO;
type PID3_INFOW = ^ID3_INFOW;

type PSTREAM_TIME = ^TStreamTime;


type
  STREAM_INFO = record
    nSamplingRate: Cardinal;
    nChannelNumber: Cardinal;
    fVBR: Cardinal;
    nBitrate: Cardinal;
    timeLength: TStreamTime;
    pchDescription: PAnsiChar
end;

type PSTREAM_INFO = ^STREAM_INFO;

type
  STREAM_INFOW = record
	  nSamplingRate: Cardinal;
	  nChannelNumber: Cardinal;
    fVBR: Cardinal;
    nBitrate: Cardinal;
    timeLength: TStreamTime;
	  pchDescription: PWideChar;
end;

type PSTREAM_INFOW = ^STREAM_INFOW;

type PSTREAM_STATUS = ^TStreamStatus;


type
  WMP3_STREAM_STATUS = record
    fPlay: Integer;
    fPause: Integer;
    fEcho: Integer;
    fEqualizer: Integer;
    fVocalCut: Integer;
    fSideCut: Integer;
    fChannelMix: Integer;
    fFade: Integer;
    nLoop: Integer;
    fReverse: Integer;
   	nSongIndex: Integer;
	nSongsInQueue: Integer;
end;



type
  WAVEOUT_INFO = record
    ManufacturerID: Cardinal;
    ProductID: Cardinal;
    DriverVersion: Cardinal;
    Formats: Cardinal;
    Channels: Cardinal;
    Support: Cardinal;
    ProductName: PAnsiChar;
end;

type PWAVEOUT_INFO = ^WAVEOUT_INFO;

type
  WAVEOUT_INFOW = record
    ManufacturerID: Cardinal;
    ProductID: Cardinal;
    DriverVersion: Cardinal;
    Formats: Cardinal;
    Channels: Cardinal;
    Support: Cardinal;
    ProductName: PWideChar;
end;

type PWAVEOUT_INFOW = ^WAVEOUT_INFOW;




type
  WAVEIN_INFO = record
    ManufacturerID: Cardinal;
    ProductID: Cardinal;
    DriverVersion: Cardinal;
    Formats: Cardinal;
    Channels: Cardinal;
    ProductName: PAnsiChar;
end;

type PWAVEIN_INFO = ^WAVEIN_INFO;

type
  WAVEIN_INFOW = record
    ManufacturerID: Cardinal;
    ProductID: Cardinal;
    DriverVersion: Cardinal;
    Formats: Cardinal;
    Channels: Cardinal;
    ProductName: PWideChar;
end;

type PWAVEIN_INFOW = ^WAVEIN_INFOW;


Function zplay_SetSettings(objptr: Pointer; nSettingID: Integer; nValue: Integer): Integer; stdcall; external 'libzplay.dll';
Function zplay_GetSettings(objptr: Pointer; nSettingID: Integer): Integer; stdcall; external 'libzplay.dll';

Function zplay_CreateZPlay(): Pointer; stdcall; external 'libzplay.dll';
Function zplay_DestroyZPlay(objptr: Pointer): Integer; stdcall; external 'libzplay.dll';
Function zplay_GetVersion(objptr: Pointer): Integer; stdcall; external 'libzplay.dll';
Function zplay_EnumerateWaveOut(objptr: Pointer): Integer; stdcall; external 'libzplay.dll';
Function zplay_GetWaveOutInfo(objptr: Pointer; nIndex: Cardinal; pWaveOutInfo: PWAVEOUT_INFO): Integer; stdcall; external 'libzplay.dll';
Function zplay_GetWaveOutInfoW(objptr: Pointer; nIndex: Cardinal; pWaveOutInfo: PWAVEOUT_INFOW): Integer; stdcall; external 'libzplay.dll';
Function zplay_SetWaveOutDevice(objptr: Pointer; nIndex: Cardinal): Integer; stdcall; external 'libzplay.dll';


Function zplay_EnumerateWaveIn(objptr: Pointer): Integer; stdcall; external 'libzplay.dll';
Function zplay_GetWaveInInfo(objptr: Pointer; nIndex: Cardinal; pWaveInInfo: PWAVEIN_INFO): Integer; stdcall; external 'libzplay.dll';
Function zplay_GetWaveInInfoW(objptr: Pointer; nIndex: Cardinal; pWaveInInfo: PWAVEIN_INFOW): Integer; stdcall; external 'libzplay.dll';
Function zplay_SetWaveInDevice(objptr: Pointer; nIndex: Cardinal): Integer; stdcall; external 'libzplay.dll';



Function zplay_GetFileFormat(objptr: Pointer; const pchFileName: PAnsiChar): Integer; stdcall; external 'libzplay.dll';
Function zplay_GetFileFormatW(objptr: Pointer; const pchFileName: PWideChar): Integer; stdcall; external 'libzplay.dll';
Function zplay_SetCallbackFunc(objptr: Pointer; pCallbackFunc: TCallbackFunc; nMessage: TCallbackMessage; user_data: Integer): Integer; stdcall; external 'libzplay.dll';

Function zplay_PushDataToStream(objptr: Pointer; const sMemNewData: Pointer; nNewDataize: Cardinal): Integer; stdcall; external 'libzplay.dll';
Function zplay_IsStreamDataFree(objptr: Pointer; const sMemNewData: Pointer): Integer; stdcall; external 'libzplay.dll';
Procedure zplay_GetDynamicStreamLoad(objptr: Pointer;  pStreamLoadInfo: PSTREAM_LOAD_INFO); stdcall; external 'libzplay.dll';

Function zplay_OpenFile(objptr: Pointer; const sFileName: PAnsiChar;  nFormat: Integer): Integer; stdcall; external 'libzplay.dll';
Function zplay_OpenFileW(objptr: Pointer; const sFileName: PWideChar; nFormat: Integer): Integer; stdcall; external 'libzplay.dll';
Function zplay_AddFile(objptr: Pointer; const sFileName: PAnsiChar;  nFormat: Integer): Integer; stdcall; external 'libzplay.dll';
Function zplay_AddFileW(objptr: Pointer; const sFileName: PWideChar; nFormat: Integer): Integer; stdcall; external 'libzplay.dll';


Function zplay_SetWaveOutFile(objptr: Pointer; const sFileName: PAnsiChar;  nFormat: Integer; fOutputToSoundcard: Integer): Integer; stdcall; external 'libzplay.dll';
Function zplay_SetWaveOutFileW(objptr: Pointer; const sFileName: PWideChar; nFormat: Integer; fOutputToSoundcard: Integer): Integer; stdcall; external 'libzplay.dll';


Function zplay_OpenStream(objptr: Pointer; fBuffered: Integer;	fManaged: Integer; const sMemStream: Pointer; nStreamSize: Cardinal; nFormat: Integer): Integer; stdcall; external 'libzplay.dll';


Function zplay_Close(objptr: Pointer): Integer; stdcall; external 'libzplay.dll';

Procedure zplay_GetStreamInfo(objptr: Pointer; pInfo: PSTREAM_INFO); stdcall; external 'libzplay.dll';
Procedure zplay_GetStreamInfoW(objptr: Pointer; pInfo: PSTREAM_INFOW); stdcall; external 'libzplay.dll';

Function zplay_LoadID3(objptr: Pointer; nId3Version: Integer; pId3Info: PID3_INFO): Integer; stdcall; external 'libzplay.dll';
Function zplay_LoadID3W(objptr: Pointer; nId3Version: Integer; pId3Info: PID3_INFOW): Integer; stdcall; external 'libzplay.dll';


Function zplay_LoadID3Ex(objptr: Pointer; pId3Info: PID3_INFOEX; fDecodeEmbededPicture: Cardinal): Integer; stdcall; external 'libzplay.dll';
Function zplay_LoadID3ExW(objptr: Pointer;  pId3Info: PID3_INFOEXW; fDecodeEmbededPicture: Cardinal): Integer; stdcall; external 'libzplay.dll';

Function zplay_LoadFileID3(objptr: Pointer; const pchFileName: PAnsiChar; nFormat: Integer; nId3Version: Integer; pId3Info: PID3_INFO): Integer; stdcall; external 'libzplay.dll';
Function zplay_LoadFileID3W(objptr: Pointer; const pchFileName: PWideChar; nFormat: Integer;  nId3Version: Integer; pId3Info: PID3_INFOW): Integer; stdcall; external 'libzplay.dll';

Function zplay_LoadFileID3Ex(objptr: Pointer; const pchFileName: PAnsiChar; nFormat: Integer;  pId3Info: PID3_INFOEX; fDecodeEmbededPicture: Cardinal): Integer; stdcall; external 'libzplay.dll';
Function zplay_LoadFileID3ExW(objptr: Pointer; const pchFileName: PWideChar; nFormat: Integer; pId3Info: PID3_INFOEXW; fDecodeEmbededPicture: Cardinal): Integer; stdcall; external 'libzplay.dll';


Function zplay_Play(objptr: Pointer): Integer; stdcall; external 'libzplay.dll';
Function zplay_Stop(objptr: Pointer): Integer; stdcall; external 'libzplay.dll';
Function zplay_Pause(objptr: Pointer): Integer; stdcall; external 'libzplay.dll';
Function zplay_Resume(objptr: Pointer): Integer; stdcall; external 'libzplay.dll';

Function zplay_PlayLoop(objptr: Pointer; fFormatStartTime: Integer; pStartTime: PSTREAM_TIME; fFormatEndTime: Integer; pEndTime: PSTREAM_TIME; nNumOfCycles: Cardinal; fContinuePlaying: Cardinal): Integer; stdcall; external 'libzplay.dll';
Function zplay_ReverseMode(objptr: Pointer; fEnable: Integer): Integer; stdcall; external 'libzplay.dll';


Procedure zplay_GetPosition(objptr: Pointer; pTime: PSTREAM_TIME); stdcall; external 'libzplay.dll';
Function zplay_Seek(objptr: Pointer; fFormat: Integer; pTime: PSTREAM_TIME; nMoveMethod: Integer): Integer; stdcall; external 'libzplay.dll';

Procedure zplay_GetStatus(objptr: Pointer; pStatus: PSTREAM_STATUS); stdcall; external 'libzplay.dll';
Function zplay_GetBitrate(objptr: Pointer; fAverage: Integer): Integer; stdcall; external 'libzplay.dll';

Function zplay_GetError(objptr: Pointer): PAnsiChar; stdcall; external 'libzplay.dll';
Function zplay_GetErrorW(objptr: Pointer): PWideChar; stdcall; external 'libzplay.dll';

Function zplay_StereoCut(objptr: Pointer; fEnable: Integer; fOutputCenter: Integer; fBassToSides: Integer): Integer; stdcall; external 'libzplay.dll';

Function zplay_MixChannels(objptr: Pointer; fEnable: Integer; nLeftPercent: Cardinal; nRightPercent: Cardinal): Integer; stdcall; external 'libzplay.dll';

Function zplay_SetMasterVolume(objptr: Pointer; nLeftVolume: Cardinal; nRightVolume: Cardinal): Integer; stdcall; external 'libzplay.dll';
Function zplay_SetPlayerVolume(objptr: Pointer; nLeftVolume: Cardinal; nRightVolume: Cardinal): Integer; stdcall; external 'libzplay.dll';
procedure zplay_GetMasterVolume(objptr: Pointer; nLeftVolume: PCardinal; nRightVolume: PCardinal); stdcall; external 'libzplay.dll';
procedure zplay_GetPlayerVolume(objptr: Pointer; nLeftVolume: PCardinal; nRightVolume: PCardinal); stdcall; external 'libzplay.dll';

procedure zplay_GetVUData(objptr: Pointer; pnLeftChannel: PCardinal; pnRightChannel: PCardinal); stdcall; external 'libzplay.dll';


Function zplay_GetFFTData(objptr: Pointer;
                            nFFTPoints: Integer;
                            nFFTWindow: Integer;
                            pnHarmonicNumber: PInteger;
                            pnHarmonicFreq: PInteger;
                            pnLeftAmplitude: PInteger;
                            pnRightAmplitude: PInteger;
                            pnLeftPhase: PInteger;
                            pnRightPhase: PInteger): Integer; stdcall; external 'libzplay.dll';


Function zplay_SlideVolume(objptr: Pointer;
                          fFormatStart: Integer;
                          pTimeStart: PSTREAM_TIME;
                          nStartVolumeLeft: Cardinal;
                          nStartVolumeRight: Cardinal;
                          fFormatEnd: Integer;
                          pTimeEnd: PSTREAM_TIME;
                          nEndVolumeLeft: Cardinal;
                          nEndVolumeRight: Cardinal): Integer; stdcall; external 'libzplay.dll';

// =============================
// echo
Function zplay_EnableEcho(objptr: Pointer; fEnable: Integer): Integer; stdcall; external 'libzplay.dll';



Function zplay_SetEchoParam(objptr: Pointer;  pEchoEffect: PECHO_EFFECT; nNumberOfEffects: Integer): Integer; stdcall; external 'libzplay.dll';


Function zplay_GetEchoParam(objptr: Pointer; pEchoEffect: PECHO_EFFECT; nNumberOfEffects: Integer): Integer; stdcall; external 'libzplay.dll';
        
// =============================
// equalizer
Function zplay_EnableEqualizer(objptr: Pointer; fEnable: Integer): Integer; stdcall; external 'libzplay.dll';
Function zplay_SetEqualizerPoints(objptr: Pointer; pnFreqPoint: PInteger; nNumOfPoints: Integer): Integer; stdcall; external 'libzplay.dll';
Function zplay_GetEqualizerPoints(objptr: Pointer; pnFreqPoint: PInteger; nNumOfPoints: Integer): Integer; stdcall; external 'libzplay.dll';
Function zplay_SetEqualizerParam(objptr: Pointer; nPreAmpGain: Integer; pnBandGain: PInteger; nNumberOfBands: Integer): Integer; stdcall; external 'libzplay.dll';
Function zplay_GetEqualizerParam(objptr: Pointer; pnPreAmpGain: PInteger; pnBandGain: Pinteger; nNumberOfBands: Integer): Integer; stdcall; external 'libzplay.dll';

Function  zplay_SetEqualizerPreampGain(objptr: Pointer; nGain: Integer): Integer; stdcall; external 'libzplay.dll';
Function  zplay_GetEqualizerPreampGain(objptr: Pointer): Integer; stdcall; external 'libzplay.dll';
Function  zplay_SetEqualizerBandGain(objptr: Pointer;  nBandIndex: Integer; nGain: Integer): Integer; stdcall; external 'libzplay.dll';
Function  zplay_GetEqualizerBandGain(objptr: Pointer;  nBandIndex: Integer): Integer; stdcall; external 'libzplay.dll';



// =============================

Function zplay_SetRate(objptr: Pointer; nRate: Cardinal): Integer; stdcall; external 'libzplay.dll';
Function zplay_GetRate(objptr: Pointer): Cardinal; stdcall; external 'libzplay.dll';

Function zplay_SetPitch(objptr: Pointer; nPitch: Cardinal): Integer; stdcall; external 'libzplay.dll';
Function zplay_GetPitch(objptr: Pointer): Cardinal; stdcall; external 'libzplay.dll';

Function zplay_SetTempo(objptr: Pointer; nTempo: Cardinal): Integer; stdcall; external 'libzplay.dll';
Function zplay_GetTempo(objptr: Pointer): Cardinal; stdcall; external 'libzplay.dll';

Function zplay_DrawFFTGraphOnHDC(objptr: Pointer; Handle: Cardinal ; nX: Integer; nY: Integer; nWidth: Integer; nHeight: Integer): Integer; stdcall; external 'libzplay.dll';
Function zplay_DrawFFTGraphOnHWND(objptr: Pointer; Handle: Cardinal ; nX: Integer; nY: Integer; nWidth: Integer; nHeight: Integer): Integer; stdcall; external 'libzplay.dll';
Function zplay_SetFFTGraphParam(objptr: Pointer; nParamID: Integer; nParamValue: Integer): Integer; stdcall; external 'libzplay.dll';
Function zplay_GetFFTGraphParam(objptr: Pointer; nParamID: Integer): Integer; stdcall; external 'libzplay.dll';


// =============================


Function  zplay_DetectBPM(Wobjptr: Pointer; nMethod: Integer): Integer; stdcall; external 'libzplay.dll';
Function  zplay_DetectFileBPM(objptr: Pointer; pchFileName: PAnsiChar; nFormat: Integer; nMethod: Integer): Integer; stdcall; external 'libzplay.dll';
Function  zplay_DetectFileBPMW(objptr: Pointer; pchFileName: PWideChar; nFormat: Integer; nMethod: Integer): Integer; stdcall; external 'libzplay.dll';





Function ZPlay.DetectBPM(Method: TBPMDetectionMethod): Integer;
begin
  Result := zplay_DetectBPM(objptr, Integer(Method));
end;

Function ZPlay.DetectFileBPM(const FileName: AnsiString; Format: TStreamFormat; Method: TBPMDetectionMethod): Integer;
begin
  Result := zplay_DetectFileBPM(objptr, PAnsiChar(FileName), Integer(Format), Integer(Method));
end;

Function ZPlay.DetectFileBPMW(const FileName: WideString; Format: TStreamFormat; Method: TBPMDetectionMethod): Integer;
begin
  Result := zplay_DetectFileBPMW(objptr, PWideChar(FileName), Integer(Format), Integer(Method));
end;


Function ZPlay.SetFFTGraphParam(ParamID: TFFTGraphParamID; ParamValue: Integer): Boolean;
begin
  Result := zplay_SetFFTGraphParam(objptr, Integer(ParamID), ParamValue) = 1;
end;

Function ZPlay.GetFFTGraphParam(ParamID: TFFTGraphParamID): Integer;
begin
  Result := zplay_GetFFTGraphParam(objptr, Integer(ParamID));
end;



Function ZPlay.SetEqualizerPreampGain(Gain: Integer): Boolean;
begin
  Result := zplay_SetEqualizerPreampGain(objptr, Gain) = 1;
end;

Function ZPlay.GetEqualizerPreampGain(): Integer;
begin
  Result := zplay_GetEqualizerPreampGain(objptr);
end;

Function ZPlay.SetEqualizerBandGain(BandIndex: Integer; Gain: Integer): Boolean;
begin
  Result := zplay_SetEqualizerBandGain(objptr, BandIndex, Gain) = 1;
end;

Function ZPlay.GetEqualizerBandGain(BandIndex: Integer): Integer;
begin
  Result := zplay_GetEqualizerBandGain(objptr, BandIndex);
end;




Function ZPlay.DrawFFTGraphOnHDC(hdc: HDC ; X: Integer; Y: Integer; Width: Integer; Height: Integer): Boolean;
begin
  Result := zplay_DrawFFTGraphOnHDC(objptr, hdc, X, Y, Width, Height) = 1;
end;

Function ZPlay.DrawFFTGraphOnHWND(hwnd: HWND; X: Integer; Y: Integer; Width: Integer; Height: Integer): Boolean;
begin
  Result := zplay_DrawFFTGraphOnHWND(objptr, hwnd, X, Y, Width, Height) = 1;
end;



Function ZPlay.SetRate(Rate: Cardinal): Boolean;
begin
  Result := zplay_SetRate(objptr, Rate) = 1;
end;

Function ZPlay.GetRate(): Cardinal;
begin
  Result := zplay_GetRate(objptr);
end;


Function ZPlay.SetPitch(Pitch: Cardinal): Boolean;
begin
  Result := zplay_SetPitch(objptr, Pitch) = 1;
end;

Function ZPlay.GetPitch(): Cardinal;
begin
  Result := zplay_GetPitch(objptr);
end;


Function ZPlay.SetTempo(Tempo: Cardinal): Boolean;
begin
  Result := zplay_SetTempo(objptr, Tempo) = 1;
end;

Function ZPlay.GetTempo(): Cardinal;
begin
  Result := zplay_GetTempo(objptr);
end;


Function ZPlay.GetFFTData(FFTPoints: Integer; FFTWindow: TFFTWindow; out HarmonicNumber: Integer;
                         HarmonicFreq: TDynamicIntegerArray;  LeftAmplitude: TDynamicIntegerArray;
                          RightAmplitude: TDynamicIntegerArray;
                           LeftPhase: TDynamicIntegerArray;  RightPhase : TDynamicIntegerArray): Boolean;



begin

Result := zplay_GetFFTData(objptr, FFTPoints, Integer(FFTWindow),
    Addr(HarmonicNumber),
    Addr(HarmonicFreq[0]),
    Addr(LeftAmplitude[0]),
    Addr(RightAmplitude[0]),
    Addr(LeftPhase[0]),
    Addr(RightPhase[0])) = 1



end;




Function ZPlay.LoadFileID3(FileName: AnsiString; Format: TStreamFormat; Id3Version: TID3Version; out Info: TID3Info): Boolean;
var
  myInfo: ID3_INFO;
begin
    if zplay_LoadFileID3(objptr, PAnsiChar(FileName), Integer(Format), Integer(Id3Version), Addr(myInfo)) <> 0 then
    begin
      Info.Title := myInfo.Title;
      Info.Artist := myInfo.Artist;
      Info.Album := myInfo.Album;
      Info.Year := myInfo.Year;
      Info.Comment := myInfo.Comment;
      Info.Track := myInfo.TrackNum;
      Info.Genre := myInfo.Genre;
      Result := true;
    end
    else
    begin
      Info.Title := '';
      Info.Artist := '';
      Info.Album := '';
      Info.Year := '';
      Info.Comment := '';
      Info.Track := '';
      Info.Genre := '';
      Result := false;
    end;
end;


Function ZPlay.LoadFileID3W(FileName: WideString; Format: TStreamFormat; Id3Version: TID3Version; out Info: TID3InfoW): Boolean;
var
  myInfo: ID3_INFOW;
begin
    if zplay_LoadFileID3W(objptr, PWideChar(FileName), Integer(Format), Integer(Id3Version), Addr(myInfo)) <> 0 then
    begin
      Info.Title := myInfo.Title;
      Info.Artist := myInfo.Artist;
      Info.Album := myInfo.Album;
      Info.Year := myInfo.Year;
      Info.Comment := myInfo.Comment;
      Info.Track := myInfo.TrackNum;
      Info.Genre := myInfo.Genre;
      Result := true;
    end
    else
    begin
      Info.Title := '';
      Info.Artist := '';
      Info.Album := '';
      Info.Year := '';
      Info.Comment := '';
      Info.Track := '';
      Info.Genre := '';
      Result := false;
    end;
end;



Function ZPlay.SlideVolume(TimeFormatStart: TTimeFormat;
                          TimeStart: TStreamTime;
                          StartVolumeLeft: Cardinal;
                          StartVolumeRight: Cardinal;
                          TimeFormatEnd: TTimeFormat;
                          TimeEnd: TStreamTime;
                          EndVolumeLeft: Cardinal;
                          EndVolumeRight: Cardinal): Boolean;
begin
  Result := zplay_SlideVolume(objptr, Integer(TimeFormatStart), Addr(TimeStart), StartVolumeLeft, StartVolumeRight, Integer(TimeFormatEnd), Addr(TimeEnd), EndVolumeLeft, EndVolumeRight) = 1;
end;



Procedure ZPlay.GetVUData(out LeftChannel: Cardinal; out RightChannel: Cardinal);
begin
  zplay_GetVUData(objptr, Addr(LeftChannel), Addr(RightChannel));
end;



Function ZPlay.SetMasterVolume(LeftVolume: Cardinal; RightVolume: Cardinal): Boolean;
begin
  Result := zplay_SetMasterVolume(objptr, LeftVolume, RightVolume) = 1;
end;

Function ZPlay.SetPlayerVolume(LeftVolume: Cardinal; RightVolume: Cardinal): Boolean;
begin
  Result := zplay_SetPlayerVolume(objptr, LeftVolume, RightVolume) = 1;
end;

Procedure ZPlay.GetMasterVolume(out LeftVolume: Integer; out RightVolume: Integer);
begin
  zplay_GetMasterVolume(objptr, Addr(LeftVolume), Addr(RightVolume));
end;

Procedure ZPlay.GetPlayerVolume(out LeftVolume: Integer; out RightVolume: Integer);
begin
  zplay_GetPlayerVolume(objptr, Addr(LeftVolume), Addr(RightVolume));
end;


Function ZPlay.ReverseMode(Enable: Boolean): Boolean;
begin
  if Enable then
    Result := zplay_ReverseMode(objptr, 1) = 1
  else
    Result := zplay_ReverseMode(objptr, 0) = 1;
end;


Function ZPlay.PlayLoop(TimeFormatStart: TTimeFormat; var StartPosition: TStreamTime; TimeFormatEnd: TTimeFormat; var EndPosition: TStreamTime; NumOfCycles: Cardinal; ContinuePlaying: Cardinal): Boolean;
begin
  Result := zplay_PlayLoop(objptr, Integer(TimeFormatStart), Addr(StartPosition), Integer(TimeFormatEnd), Addr(EndPosition), NumOfCycles, ContinuePlaying) = 1;
end;

Procedure ZPlay.GetDynamicStreamLoad(out Load: TStreamLoadInfo);
begin
  zplay_GetDynamicStreamLoad(objptr, Addr(Load));
end;


Function ZPlay.EnumerateWaveOut(): Integer;
begin
  Result := zplay_EnumerateWaveOut(objptr);
end;

Function ZPlay.GetWaveOutInfo(Index: Cardinal; out WaveOutInfo: TWaveOutInfo): Integer;
var
  Info: WAVEOUT_INFO;
begin
  if zplay_GetWaveOutInfo(objptr, Index, Addr(Info)) <> 0 then
  begin
    WaveOutInfo.ManufacturerID := Info.ManufacturerID;
    WaveOutInfo.ProductID := Info.ProductID;
    WaveOutInfo.DriverVersion := Info.DriverVersion;
    WaveOutInfo.Formats := Info.Formats;
    WaveOutInfo.Channels := Info.Channels;
    WaveOutInfo.Support := Info.Support;
    WaveOutInfo.ProductName := Info.ProductName;
    Result := 1;
  end
  else
  begin
  WaveOutInfo.ManufacturerID := 0;
    WaveOutInfo.ProductID := 0;
    WaveOutInfo.DriverVersion := 0;
    WaveOutInfo.Formats := 0;
    WaveOutInfo.Channels := 0;
    WaveOutInfo.Support := 0;
    WaveOutInfo.ProductName := '';
    Result := 0;
  end;
end;


Function ZPlay.GetWaveOutInfoW(Index: Cardinal; out WaveOutInfo: TWaveOutInfoW): Integer;
var
  Info: WAVEOUT_INFOW;
begin
  if zplay_GetWaveOutInfoW(objptr, Index, Addr(Info)) <> 0 then
  begin
    WaveOutInfo.ManufacturerID := Info.ManufacturerID;
    WaveOutInfo.ProductID := Info.ProductID;
    WaveOutInfo.DriverVersion := Info.DriverVersion;
    WaveOutInfo.Formats := Info.Formats;
    WaveOutInfo.Channels := Info.Channels;
    WaveOutInfo.Support := Info.Support;
    WaveOutInfo.ProductName := Info.ProductName;
    Result := 1;
  end
  else
  begin
  WaveOutInfo.ManufacturerID := 0;
    WaveOutInfo.ProductID := 0;
    WaveOutInfo.DriverVersion := 0;
    WaveOutInfo.Formats := 0;
    WaveOutInfo.Channels := 0;
    WaveOutInfo.Support := 0;
    WaveOutInfo.ProductName := '';
    Result := 0;
  end;
end;

Function ZPlay.SetWaveOutDevice(Index: Cardinal): Integer;
begin
  Result := zplay_SetWaveOutDevice(objptr, Index);
end;




Function ZPlay.EnumerateWaveIn(): Integer;
begin
  Result := zplay_EnumerateWaveIn(objptr);
end;

Function ZPlay.GetWaveInInfo(Index: Cardinal; out WaveInInfo: TWaveInInfo): Integer;
var
  Info: WAVEIN_INFO;
begin
  if zplay_GetWaveInInfo(objptr, Index, Addr(Info)) <> 0 then
  begin
    WaveInInfo.ManufacturerID := Info.ManufacturerID;
    WaveInInfo.ProductID := Info.ProductID;
    WaveInInfo.DriverVersion := Info.DriverVersion;
    WaveInInfo.Formats := Info.Formats;
    WaveInInfo.Channels := Info.Channels;
    WaveInInfo.ProductName := Info.ProductName;
    Result := 1;
  end
  else
  begin
  WaveInInfo.ManufacturerID := 0;
    WaveInInfo.ProductID := 0;
    WaveInInfo.DriverVersion := 0;
    WaveInInfo.Formats := 0;
    WaveInInfo.Channels := 0;
    WaveInInfo.ProductName := '';
    Result := 0;
  end;
end;


Function ZPlay.GetWaveInInfoW(Index: Cardinal; out WaveInInfo: TWaveInInfoW): Integer;
var
  Info: WAVEIN_INFOW;
begin
  if zplay_GetWaveInInfoW(objptr, Index, Addr(Info)) <> 0 then
  begin
    WaveInInfo.ManufacturerID := Info.ManufacturerID;
    WaveInInfo.ProductID := Info.ProductID;
    WaveInInfo.DriverVersion := Info.DriverVersion;
    WaveInInfo.Formats := Info.Formats;
    WaveInInfo.Channels := Info.Channels;
    WaveInInfo.ProductName := Info.ProductName;
    Result := 1;
  end
  else
  begin
  WaveInInfo.ManufacturerID := 0;
    WaveInInfo.ProductID := 0;
    WaveInInfo.DriverVersion := 0;
    WaveInInfo.Formats := 0;
    WaveInInfo.Channels := 0;
    WaveInInfo.ProductName := '';
    Result := 0;
  end;
end;

Function ZPlay.SetWaveInDevice(Index: Cardinal): Integer;
begin
  Result := zplay_SetWaveInDevice(objptr, Index);
end;




Function ZPlay.GetVersion(): Integer; stdcall;
begin
  Result := zplay_GetVersion(objptr);
end;

Function ZPlay.IsStreamDataFree(const MemNewData: Pointer): Boolean;
begin
  Result := zplay_IsStreamDataFree(objptr, MemNewData) = 1;
end;

Function ZPlay.MixChannels(Enable: Boolean; LeftPercent: Cardinal; RightPercent: Cardinal): Boolean;
begin
  if Enable then
        Result := zplay_MixChannels(objptr, 1, LeftPercent, RightPercent) = 1
  else
        Result := zplay_MixChannels(objptr, 0, LeftPercent, RightPercent) = 1
end;

Function ZPlay.SetEchoParam(var EchoEffectArray: array of TEchoEffect; NumberOfEffects: Integer): Boolean;
begin
  Result := zplay_SetEchoParam(objptr, Addr(EchoEffectArray[0]), NumberOfEffects) = 1;
end;

Function ZPlay.SetEqualizerPoints(var FreqPointArray: array of Integer; NumberOfPoints: Integer): Boolean;
begin
  Result := zplay_SetEqualizerPoints(objptr, Addr(FreqPointArray[0]), NumberOfPoints) = 1;
end;

Function ZPlay.GetEqualizerPoints(out FreqPointArray: TDynamicIntegerArray): Integer;
var
  Size: Integer;
begin
  Size := zplay_GetEqualizerPoints(objptr, nil, 0);
  if Size = 0 then
  begin
    Result := 0;
    Exit;
  end;

  SetLength(FreqPointArray, Size);
  Result := zplay_GetEqualizerPoints(objptr, Addr(FreqPointArray[0]), Size);
end;

Function ZPlay.GetEchoParam(out EchoEffectArray: TDynamicEchoEffectArray): Integer;
var
  Size: Integer;
begin
  Size := zplay_GetEchoParam(objptr, nil, 0);
  if Size = 0 then
  begin
    Result := 0;
    Exit;
  end;

  SetLength(EchoEffectArray, Size);
  Result := zplay_GetEchoParam(objptr, Addr(EchoEffectArray[0]), Size);
end;

Function ZPlay.GetEqualizerParam(out PreAmpGain: Integer; out BandGain: TDynamicIntegerArray): Integer;
var
  Size: Integer;
begin
  Size := zplay_GetEqualizerParam(objptr, nil, nil, 0);
  if Size = 0 then
  begin
    Result := 0;
    Exit;
  end;

  SetLength(BandGain, Size);
  Result := zplay_GetEqualizerParam(objptr, Addr(PreAmpGain), Addr(BandGain[0]), Size);
end;

Function ZPlay.SetEqualizerParam(PreAmpGain: Integer; var BandGain: array of Integer; NumberOfBands: Integer): Boolean;
begin
  Result := zplay_SetEqualizerParam(objptr, PreAmpGain, Addr(BandGain[0]), NumberOfBands) = 1;
end;




Procedure ZPlay.GetStatus(out Status: TStreamStatus);
var
  StatusInternal: WMP3_STREAM_STATUS;
begin
  zplay_GetStatus(objptr, Addr(StatusInternal));

    Status.fPlay :=  StatusInternal.fPlay = 1;
    Status.fPause  := StatusInternal.fPause = 1;
    Status.fEcho  := StatusInternal.fEcho = 1;
    Status.fEqualizer  := StatusInternal.fEqualizer = 1;
    Status.fVocalCut  := StatusInternal.fVocalCut = 1;
    Status.fSideCut  := StatusInternal.fSideCut = 1;
    Status.fChannelMix  := StatusInternal.fChannelMix = 1;
    Status.fSlideVolume  := StatusInternal.fFade = 1;
    Status.nLoop  := StatusInternal.nLoop ;
    Status.fReverse  := StatusInternal.fReverse = 1;
    Status.nSongIndex := StatusInternal.nSongIndex;
    Status.nSongsInQueue :=  StatusInternal.nSongsInQueue;
end;





Function ZPlay.GetBitrate(Average: Boolean): Integer;
begin
  if Average then
    Result := zplay_GetBitrate(objptr, 1)
  else
    Result := zplay_GetBitrate(objptr, 0);
end;



Function ZPlay.EnableEcho(Enable: Boolean): Boolean;
begin
  if Enable then
    Result := zplay_EnableEcho(objptr, 1) = 1
  else
    Result := zplay_EnableEcho(objptr, 0) = 1
end;

Function ZPlay.EnableEqualizer(Enable: Boolean):Boolean;
begin
  if Enable then
    Result := zplay_EnableEqualizer(objptr, 1) = 1
  else
    Result := zplay_EnableEqualizer(objptr, 0) = 1;
end;





Procedure ZPlay.GetPosition(out Position: TStreamTime);
begin
  zplay_GetPosition(objptr, Addr(Position));
end;




constructor ZPlay.Create;
begin
  inherited;

  objptr :=  zplay_CreateZPlay();
  if objptr = nil then
    raise Exception.Create('Can''t create libZPlay interface.') at @ZPlay.Create;

  if GetVersion() < 190 then
    raise Exception.Create('Need libZPlay.dll version 1.90 and above.') at @ZPlay.Create;

  bitmap1 := TPicture.Create;
  bitmap2 := TPicture.Create;

end;


Function ZPlay.Seek(TimeFormat: TTimeFormat; var Position: TStreamTime; MoveMethod: TSeekMethod): Boolean;
begin
  Result := zplay_Seek(objptr, Integer(TimeFormat), Addr(Position), Integer(MoveMethod)) = 1;
end;


destructor ZPlay.Destroy;
begin
  if objptr <> nil then
    zplay_DestroyZPlay(objptr);

  objptr := nil;
  bitmap1.Free;
  bitmap2.Free;
  inherited;

end;

Function ZPlay.GetError():AnsiString;
begin
  error_msg :=  zplay_GetError(objptr);
  Result := error_msg;
end;

Function ZPlay.GetErrorW():WideString;
begin
  error_msgW := zplay_GetErrorW(objptr);
  Result := error_msgW;
end;



Function ZPlay.StereoCut(Enable: Boolean; OutputCenter: Boolean; BassToSides: Boolean):Boolean;
var
  oc: Integer;
  bts: Integer;
begin
  oc := 0;
  bts := 0;
  if OutputCenter then oc := 1;
  if BassToSides then bts := 1;
    if Enable then
        Result := zplay_StereoCut(objptr, 1, oc, bts) = 1
    else
        Result := zplay_StereoCut(objptr, 0, oc, bts) = 1
end;

Function ZPlay.GetFileFormat(const FileName: AnsiString): TStreamFormat;
begin
  Result := TStreamFormat(zplay_GetFileFormat(objptr, PAnsiChar(FileName)));
end;


Function ZPlay.GetFileFormatW(const FileName: WideString):TStreamFormat;
begin
  Result := TStreamFormat(zplay_GetFileFormatW(objptr, PWideChar(FileName)));
end;


Function ZPlay.SetCallbackFunc(CallbackFunc: TCallbackFunc; Messages: TCallbackMessage; UserData: Integer):Boolean;
begin
  Result := zplay_SetCallbackFunc(objptr, CallbackFunc, Messages, UserData) = 1;
end;

Function ZPlay.OpenFile(const FileName : AnsiString; Format: TStreamFormat):Boolean;
begin
  if zplay_OpenFile(objptr, PAnsiChar(FileName), Integer(Format)) <> 0 then
  begin
    Result := true;
  end
  else
    Result := false;
end;

Function ZPlay.OpenFileW(const FileName : WideString; Format: TStreamFormat):Boolean;
begin
  if zplay_OpenFileW(objptr, PWideChar(FileName), Integer(Format)) <> 0 then
  begin
    Result := true;
  end
  else
    Result := false;
end;




Function ZPlay.SetWaveOutFile(const FileName : AnsiString; Format: TStreamFormat; fOutputToSoundcard: Boolean):Boolean;
var
  s: Integer;
begin
  s := 0;
  if fOutputToSoundcard then
    s := 1;
    
  if zplay_SetWaveOutFile(objptr, PAnsiChar(FileName), Integer(Format), s) <> 0 then
  begin
    Result := true;
  end
  else
    Result := false;
end;

Function ZPlay.SetWaveOutFileW(const FileName : WideString; Format: TStreamFormat; fOutputToSoundcard: Boolean):Boolean;
var
  s: Integer;
begin
  s := 0;
  if fOutputToSoundcard then
    s := 1;
    
  if zplay_SetWaveOutFileW(objptr, PWideChar(FileName), Integer(Format),s ) <> 0 then
  begin
    Result := true;
  end
  else
    Result := false;
end;

Function ZPlay.AddFile(const FileName : AnsiString; Format: TStreamFormat):Boolean;
begin
  if zplay_AddFile(objptr, PAnsiChar(FileName), Integer(Format)) <> 0 then
  begin
    Result := true;
  end
  else
    Result := false;
end;

Function ZPlay.AddFileW(const FileName : WideString; Format: TStreamFormat):Boolean;
begin
  if zplay_AddFileW(objptr, PWideChar(FileName), Integer(Format)) <> 0 then
  begin
    Result := true;
  end
  else
    Result := false;
end;



Function ZPlay.OpenStream(Buffered: Integer;	Managed: Integer;  MemStream: Pointer; StreamSize: Cardinal; Format: TStreamFormat):Boolean;
begin
  if zplay_OpenStream(objptr, Buffered,	Managed, MemStream, StreamSize, Integer(Format)) <> 0 then
  begin
    Result := true;
  end
  else
    Result := false;
end;

Function ZPlay.PushDataToStream(const MemNewData: Pointer; NewDataize: Cardinal):Boolean;
begin
  Result := zplay_PushDataToStream(objptr, MemNewData, NewDataize) = 1;
end;

Function ZPlay.Close():Boolean;
begin
  Result := zplay_Close(objptr) = 1;
end;


Function ZPlay.LoadID3(Id3Version: TID3Version; out Info: TID3Info): Boolean;
var
  myInfo: ID3_INFO;
begin
    if zplay_LoadID3(objptr, Integer(Id3Version), Addr(myInfo)) <> 0 then
    begin
      Info.Title := myInfo.Title;
      Info.Artist := myInfo.Artist;
      Info.Album := myInfo.Album;
      Info.Year := myInfo.Year;
      Info.Comment := myInfo.Comment;
      Info.Track := myInfo.TrackNum;
      Info.Genre := myInfo.Genre;
      Result := true;
    end
    else
    begin
      Info.Title := '';
      Info.Artist := '';
      Info.Album := '';
      Info.Year := '';
      Info.Comment := '';
      Info.Track := '';
      Info.Genre := '';
      Result := false;
    end;
end;


Function ZPlay.LoadFileID3ExW(FileName: WideString; Format: TStreamFormat;  out Info: TID3InfoExW; fDecodeEmbededPicture: Boolean): Boolean;
var
  myInfo: ID3_INFOEXW;
  decode_picture: Cardinal;
begin
    if fDecodeEmbededPicture then
        decode_picture := 1
    else
      decode_picture := 0;


    if zplay_LoadFileID3ExW(objptr , PWideChar(FileName), Integer(Format), Addr(myInfo), decode_picture) <> 0 then
    begin
      Info.Title := myInfo.Title;
      Info.Artist := myInfo.Artist;
      Info.Album := myInfo.Album;
      Info.Year := myInfo.Year;
      Info.Comment := myInfo.Comment;
      Info.Track := myInfo.TrackNum;
      Info.Genre := myInfo.Genre;
      Info.AlbumArtist := myInfo.AlbumArtist;
      Info.Composer := myInfo.Composer;
      Info.OriginalArtist := myInfo.OriginalArtist;
      Info.Copyright := myInfo.Copyright;
      Info.URL := myInfo.URL;
      Info.Encoder := myInfo.Encoder;
      Info.Publisher := myInfo.Publisher;
      Info.BPM := myInfo.BPM;

      Info.Picture.PicturePresent := False;
      if myInfo.Picture.CanDrawPicture = 1 then
      begin
        Info.Picture.Description := myInfo.Picture.Description;
        Info.Picture.PictureType := myInfo.Picture.PictureType;
        bitmap1.Bitmap.Handle := myInfo.Picture.hBitmap;
        Info.Picture.Bitmap := bitmap1;
        Info.Picture.PicturePresent := True;
      end;

      Result := true;
    end
    else
    begin
      Result := false;
    end;
end;


Function ZPlay.LoadFileID3Ex(FileName: AnsiString; Format: TStreamFormat;  out Info: TID3InfoEx; fDecodeEmbededPicture: Boolean): Boolean;
var
  myInfo: ID3_INFOEX;
  decode_picture: Cardinal;
begin
    if fDecodeEmbededPicture then
        decode_picture := 1
    else
      decode_picture := 0;


    if zplay_LoadFileID3Ex(objptr , PAnsiChar(FileName), Integer(Format), Addr(myInfo), decode_picture) <> 0 then
    begin
      Info.Title := myInfo.Title;
      Info.Artist := myInfo.Artist;
      Info.Album := myInfo.Album;
      Info.Year := myInfo.Year;
      Info.Comment := myInfo.Comment;
      Info.Track := myInfo.TrackNum;
      Info.Genre := myInfo.Genre;
      Info.AlbumArtist := myInfo.AlbumArtist;
      Info.Composer := myInfo.Composer;
      Info.OriginalArtist := myInfo.OriginalArtist;
      Info.Copyright := myInfo.Copyright;
      Info.URL := myInfo.URL;
      Info.Encoder := myInfo.Encoder;
      Info.Publisher := myInfo.Publisher;
      Info.BPM := myInfo.BPM;

      Info.Picture.PicturePresent := False;
      if myInfo.Picture.CanDrawPicture = 1 then
      begin
        Info.Picture.Description := myInfo.Picture.Description;
        Info.Picture.PictureType := myInfo.Picture.PictureType;
        bitmap1.Bitmap.Handle := myInfo.Picture.hBitmap;
        Info.Picture.Bitmap := bitmap1;
        Info.Picture.PicturePresent := True;
      end;

      Result := true;
    end
    else
    begin
      Info.Title := '';
      Info.Artist := '';
      Info.Album := '';
      Info.Year := '';
      Info.Comment := '';
      Info.Track := '';
      Info.Genre := '';
      Info.AlbumArtist :=  '';
      Info.Composer :=  '';
      Info.OriginalArtist :=  '';
      Info.Copyright :=  '';
      Info.URL :=  '';
      Info.Encoder :=  '';
      Info.Publisher :=  '';
      Info.BPM := 0;
      Result := false;
    end;
end;


Function ZPlay.LoadID3ExW(out Info: TID3InfoExW; fDecodeEmbededPicture: Boolean): Boolean;
var
  myInfo: ID3_INFOEXW;
  decode_picture: Cardinal;
begin
    if fDecodeEmbededPicture then
        decode_picture := 1
    else
      decode_picture := 0;


    if zplay_LoadID3ExW(objptr , Addr(myInfo), decode_picture) <> 0 then
    begin
      Info.Title := myInfo.Title;
      Info.Artist := myInfo.Artist;
      Info.Album := myInfo.Album;
      Info.Year := myInfo.Year;
      Info.Comment := myInfo.Comment;
      Info.Track := myInfo.TrackNum;
      Info.Genre := myInfo.Genre;
      Info.AlbumArtist := myInfo.AlbumArtist;
      Info.Composer := myInfo.Composer;
      Info.OriginalArtist := myInfo.OriginalArtist;
      Info.Copyright := myInfo.Copyright;
      Info.URL := myInfo.URL;
      Info.Encoder := myInfo.Encoder;
      Info.Publisher := myInfo.Publisher;
      Info.BPM := myInfo.BPM;

      Info.Picture.PicturePresent := False;
      if myInfo.Picture.CanDrawPicture = 1 then
      begin
        Info.Picture.Description := myInfo.Picture.Description;
        Info.Picture.PictureType := myInfo.Picture.PictureType;
        bitmap1.Bitmap.Handle := myInfo.Picture.hBitmap;
        Info.Picture.Bitmap := bitmap1;
        Info.Picture.PicturePresent := True;
      end;
      Result := true;
    end
    else
    begin
      Result := false;
    end;
end;

Function ZPlay.LoadID3Ex(out Info: TID3InfoEx; fDecodeEmbededPicture: Boolean): Boolean;
var
  myInfo: ID3_INFOEX;
  decode_picture: Cardinal;
begin
    if fDecodeEmbededPicture then
        decode_picture := 1
    else
      decode_picture := 0;


    if zplay_LoadID3Ex(objptr , Addr(myInfo), decode_picture) <> 0 then
    begin
      Info.Title := myInfo.Title;
      Info.Artist := myInfo.Artist;
      Info.Album := myInfo.Album;
      Info.Year := myInfo.Year;
      Info.Comment := myInfo.Comment;
      Info.Track := myInfo.TrackNum;
      Info.Genre := myInfo.Genre;
      Info.AlbumArtist := myInfo.AlbumArtist;
      Info.Composer := myInfo.Composer;
      Info.OriginalArtist := myInfo.OriginalArtist;
      Info.Copyright := myInfo.Copyright;
      Info.URL := myInfo.URL;
      Info.Encoder := myInfo.Encoder;
      Info.Publisher := myInfo.Publisher;
      Info.BPM := myInfo.BPM;

     Info.Picture.PicturePresent := False;

      if myInfo.Picture.CanDrawPicture = 1 then
      begin
        Info.Picture.Description := myInfo.Picture.Description;
        Info.Picture.PictureType := myInfo.Picture.PictureType;
        bitmap1.Bitmap.Handle := myInfo.Picture.hBitmap;
        Info.Picture.Bitmap := bitmap1;
        Info.Picture.PicturePresent := True;
      end;

      Result := true;
    end
    else
    begin
      Info.Title := '';
      Info.Artist := '';
      Info.Album := '';
      Info.Year := '';
      Info.Comment := '';
      Info.Track := '';
      Info.Genre := '';
      Info.AlbumArtist :=  '';
      Info.Composer :=  '';
      Info.OriginalArtist :=  '';
      Info.Copyright :=  '';
      Info.URL :=  '';
      Info.Encoder :=  '';
      Info.Publisher :=  '';
      Info.BPM := 0;
      Result := false;
    end;
end;

Function ZPlay.LoadID3W(Id3Version: TID3Version; out Info: TID3InfoW): Boolean;
var
  myInfo: ID3_INFOW;
begin
    if zplay_LoadID3W(objptr, Integer(Id3Version), Addr(myInfo)) <> 0 then
    begin
      Info.Title := myInfo.Title;
      Info.Artist := myInfo.Artist;
      Info.Album := myInfo.Album;
      Info.Year := myInfo.Year;
      Info.Comment := myInfo.Comment;
      Info.Track := myInfo.TrackNum;
      Info.Genre := myInfo.Genre;
      Result := true;
    end
    else
    begin
      Info.Title := '';
      Info.Artist := '';
      Info.Album := '';
      Info.Year := '';
      Info.Comment := '';
      Info.Track := '';
      Info.Genre := '';
      Result := false;
    end;
end;




Function ZPlay.StartPlayback():Boolean;
begin
  Result := zplay_Play(objptr) = 1;
end;

Function ZPlay.StopPlayback():Boolean;
begin
  Result := zplay_Stop(objptr) = 1;
end;

Function ZPlay.PausePlayback():Boolean;
begin
  Result := zplay_Pause(objptr) = 1;
end;

Function ZPlay.ResumePlayback():Boolean;
begin
  Result := zplay_Resume(objptr) = 1;
end;

Procedure ZPlay.GetStreamInfo(out Info: TStreamInfo);
var
  Info1: STREAM_INFO;
begin
    zplay_GetStreamInfo(objptr, Addr(Info1));
    Info.SamplingRate := Info1.nSamplingRate;
    Info.ChannelNumber := Info1.nChannelNumber;
    Info.VBR := Info1.fVBR = 1;
    Info.Bitrate := Info1.nBitrate;
    Info.Length := Info1.timeLength;
    Info.Description := Info1.pchDescription;
end;

Procedure ZPlay.GetStreamInfoW(out Info: TStreamInfoW);
var
  Info1: STREAM_INFOW;
begin
    zplay_GetStreamInfo(objptr, Addr(Info1));
    Info.SamplingRate := Info1.nSamplingRate;
    Info.ChannelNumber := Info1.nChannelNumber;
    Info.VBR := Info1.fVBR = 1;
    Info.Bitrate := Info1.nBitrate;
    Info.Length := Info1.timeLength;
    Info.Description := Info1.pchDescription;
end;

Function ZPlay.SetSettings(SettingID: TSettingID; Value: Integer): Integer;
begin
  Result := zplay_SetSettings(objptr, Integer(SettingID), Value);
end;

Function ZPlay.GetSettings(SettingID: TSettingID; Value: Integer): Integer;
begin
   Result := zplay_GetSettings(objptr, Integer(SettingID));
end;

end.
