return {
  --[[
  Version: 1 (0x0)
  Issuer: C = US, ST = California, L = San Francisco, O = Kong, OU = Core, CN = ssl-example.com
  Validity
      Not Before: Apr 24 14:36:29 2020 GMT
      Not After : Feb  7 14:36:29 2294 GMT

  Note: Version 1 was accomplished by using a openssl.cnf file
  with the x509_extensions line commented out.
  See https://stackoverflow.com/questions/26788244/how-to-create-a-legacy-v1-or-v2-x-509-cert-for-testing
  and this line's commit message for more info
  --]]
  cert = [[-----BEGIN CERTIFICATE-----
MIIFbTCCA1UCFGjFyapVZYpvpKuYDJbLA1YJip++MA0GCSqGSIb3DQEBCwUAMHIx
CzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpDYWxpZm9ybmlhMRYwFAYDVQQHEw1TYW4g
RnJhbmNpc2NvMQ0wCwYDVQQKEwRLb25nMQ0wCwYDVQQLEwRDb3JlMRgwFgYDVQQD
Ew9zc2wtZXhhbXBsZS5jb20wIBcNMjAwNDI0MTQzNjI5WhgPMjI5NDAyMDcxNDM2
MjlaMHIxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpDYWxpZm9ybmlhMRYwFAYDVQQH
Ew1TYW4gRnJhbmNpc2NvMQ0wCwYDVQQKEwRLb25nMQ0wCwYDVQQLEwRDb3JlMRgw
FgYDVQQDEw9zc2wtZXhhbXBsZS5jb20wggIiMA0GCSqGSIb3DQEBAQUAA4ICDwAw
ggIKAoICAQDDd3IZRGgdL34RY1MiAE2ItnJNbZGPQD9XE32D/I1cDCAXjI/MQrvn
iSJhnnc/8F2y7/tzJ2GZIk0C8Fz7MRWDXHCBt9byOHU0Jhppj/cRyWqlI7GrvyZy
QAiyOh/97ZN52xwXqiFDRXCd43PIgPhie6rcJkdYbppg8ETwMbjZcslcX6EUJzLU
q/I0BscqbqfiAa8viJ0a1bSWINABKWYr5KqpiRfLWsTJmMthWgh5kaLtMZS3m/AM
IrrKJJY2klvyO6TeXkHuZwm1day4NxhInxZl5H8NNbLgHz+W/8g6vgo2Oafy0crA
hS7iK0oJZMgK25p7VDbi8BXf9kqZeq17Vcj9uB8JxC4oTjy6XT9HGTAJ3yJ0TtLP
p8dayJt6fbNgcuHKkiZJAJfg6ecl2jXxYW7aO9oqcIA3btsl1TJbnzpMK8zeQK1H
Aw7ryQ8qdhKboZUe09iwcyjxyzxieymS387/O6Stnu3UXoPnig9exx8zOgkcZfFa
yhrtEbS74lwcyWwnSmjq/tUw1+QbzoTEJDeMyFnZjOJT5GbauFadF7o/GSbCurWb
yh2G/s5S6v+xa7zw7xdO8ECEUKXws4IiGSui3raZWt+B57uBFQqUefDV6H6MevPk
8aMTC3f9fhp28lbbjfZBI3JiwtaVSV11kJfwmzOcj198nmZlRHotMQIDAQABMA0G
CSqGSIb3DQEBCwUAA4ICAQC51hH6cZrn+n8LiHlDaT/JFys3kKOQ4OpdpCUyUYzI
VYFnG/espH8LKzAiui4/LQjwygTkmNdp12GzIUsZItvpia2J4hsi7xNm/uKOhHwG
B1FViDF8FKOEihyMsZVAHIBj54RjuQ+WLbuQCjajX4PrK2La6lhWMn4cyvFWXCYB
A28Vrz/jXgXCXEct4+b2gZApOJ2H8qAyJv8JtFOptbB5mUZz3u3PW8/bTwG901/L
P9rWLq4AXT+UyPwBNs/lG4XXGc5uBfQjHkvamNKQP3usZuxAygdOEz6vJh9i0nyX
2b/+F/GLi8ZZwllapmp8c3WdsJkycBJ22VLS/LFNNvkz4sbT1dw5w1A7XJhiVDDZ
Dt9HMqK5qb4GAbaWwS+HPC63vrP6Ltw4QiAhC5x3bRujJ9CscRTVHXxMNw9b1TkQ
8AGgEFZKtbhirmv2/MQv+T57LQgnFPWNJWwv3YjJOIzDLEOeOxHMFV3Po5R5B2eP
qhLqmwYS6tQ/ih5BnlbZPBrArdVvsVCWLjQRy9qgetBlh+c65cL4HUAe/BxpXQSK
OoNpTQYMpSXlERwqm2/LN8rJl3XFlGtSH2xHucX8V3eN1bPURegkfplgPI+HDZDp
LAhXzHSQgW+cvcEL9Jafm5e5kRqDei4VSJteBfo+X/eTp0WnGJOYv0uJqwUJheNe
IQ==
-----END CERTIFICATE-----]],
  key = [[-----BEGIN RSA PRIVATE KEY-----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-----END RSA PRIVATE KEY-----]],

  --[[
  Signature Algorithm: ecdsa-with-SHA256
  Issuer: C = US, ST = California, L = San Francisco, O = Kong, OU = Core, CN = ssl-example.com
  Validity
       Not Before: Nov 18 16:17:30 2020 GMT
       Not After : Sep  3 16:17:30 2294 GMT
  --]]
  cert_ecdsa = [[-----BEGIN CERTIFICATE-----
MIICPDCCAeGgAwIBAgIUOIK1sCtPyUL5h7vHdxpN5PhpukMwCgYIKoZIzj0EAwIw
cjELMAkGA1UEBhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExFjAUBgNVBAcMDVNh
biBGcmFuY2lzY28xDTALBgNVBAoMBEtvbmcxDTALBgNVBAsMBENvcmUxGDAWBgNV
BAMMD3NzbC1leGFtcGxlLmNvbTAgFw0yMDExMTgxNjE3MzBaGA8yMjk0MDkwMzE2
MTczMFowcjELMAkGA1UEBhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExFjAUBgNV
BAcMDVNhbiBGcmFuY2lzY28xDTALBgNVBAoMBEtvbmcxDTALBgNVBAsMBENvcmUx
GDAWBgNVBAMMD3NzbC1leGFtcGxlLmNvbTBZMBMGByqGSM49AgEGCCqGSM49AwEH
A0IABDFm7D+CfVzbkRyRTR/2DI4o1sOxDCdc1UEdbQkA5e6j5b4smyuW4xlZjVwV
CXeADYvtpBaykzZ+NC5Zlf3EAkWjUzBRMB0GA1UdDgQWBBQcXSBVifOMnYaC632X
NzdazHkuEjAfBgNVHSMEGDAWgBQcXSBVifOMnYaC632XNzdazHkuEjAPBgNVHRMB
Af8EBTADAQH/MAoGCCqGSM49BAMCA0kAMEYCIQDbSwXZ15UJ0hX/7KTKxd/mER7b
s5oBurNijw1iPMyi+wIhALixa/LN3i+AykB4Jxj89scpXilIH+6q5fJI9exuaLtv
-----END CERTIFICATE-----]],
  key_ecdsa = [[-----BEGIN EC PRIVATE KEY-----
MHcCAQEEIDCpckzH9Z6YpE48cmSIqcNXDZ29peoeMkFP2NqZb/MUoAoGCCqGSM49
AwEHoUQDQgAEMWbsP4J9XNuRHJFNH/YMjijWw7EMJ1zVQR1tCQDl7qPlviybK5bj
GVmNXBUJd4ANi+2kFrKTNn40LlmV/cQCRQ==
-----END EC PRIVATE KEY-----]],

  --[[
  Issuer: C = US, ST = California, O = Kong Testing, CN = Kong Testing Intermidiate CA
      Validity
          Not Before: May  2 20:03:11 2019 GMT
          Not After : Apr 28 20:03:11 2029 GMT
      Subject: C = US, ST = California, O = Kong Testing, CN = foo@example.com
  X509v3 Key Usage: critical
      Digital Signature, Non Repudiation, Key Encipherment
  X509v3 Extended Key Usage:
      TLS Web Client Authentication, E-mail Protection
  X509v3 Subject Alternative Name:
      email:foo@example.com, email:bar@example.com
  --]]
  cert_client = [[-----BEGIN CERTIFICATE-----
MIIFIjCCAwqgAwIBAgICIAEwDQYJKoZIhvcNAQELBQAwYDELMAkGA1UEBhMCVVMx
EzARBgNVBAgMCkNhbGlmb3JuaWExFTATBgNVBAoMDEtvbmcgVGVzdGluZzElMCMG
A1UEAwwcS29uZyBUZXN0aW5nIEludGVybWlkaWF0ZSBDQTAeFw0xOTA1MDIyMDAz
MTFaFw0yOTA0MjgyMDAzMTFaMFMxCzAJBgNVBAYTAlVTMRMwEQYDVQQIDApDYWxp
Zm9ybmlhMRUwEwYDVQQKDAxLb25nIFRlc3RpbmcxGDAWBgNVBAMMD2Zvb0BleGFt
cGxlLmNvbTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAJldMxsZHDxA
RpbSXdIFZiTf8D0dYgsPnsmx5tVjA/zrVBSVBPO9KunaXNm4Z6JWmUwenzFGbzWP
NLfbLn4khuoczzqSru5XfbyH1HrD0cd5lkf44Dw1/otfIFDBleiR/OWEiAxwS4zi
xIajNyvLr3gC5dv+F+JuWpW1yVQxybIDQWoI25xpd3+ZkXO+OLkToo+YpuwIDlUj
6Rkm5kbqoxDpaDihA2bsAqjNG7G+SHthaNyACsQsU/t6BHSWzHumScN0CxJ+TeVH
fTZklelItZ6YP0B0RQjzvSGA423UgALzqJglGPe8UDjm3BMlg2xhTfnfy1J6Vmbt
5jx6FOXUARsCAwEAAaOB8jCB7zAJBgNVHRMEAjAAMBEGCWCGSAGG+EIBAQQEAwIF
oDAzBglghkgBhvhCAQ0EJhYkT3BlblNTTCBHZW5lcmF0ZWQgQ2xpZW50IENlcnRp
ZmljYXRlMB0GA1UdDgQWBBRTzNOmhGRXaZamxVfnlKXarIOEmDAfBgNVHSMEGDAW
gBQLDgQOl/htYk8k8DvGb9IKO40RETAOBgNVHQ8BAf8EBAMCBeAwHQYDVR0lBBYw
FAYIKwYBBQUHAwIGCCsGAQUFBwMEMCsGA1UdEQQkMCKBD2Zvb0BleGFtcGxlLmNv
bYEPYmFyQGV4YW1wbGUuY29tMA0GCSqGSIb3DQEBCwUAA4ICAQBziDuVjU0I1CwO
b1Cx2TJpzi3l5FD/ozrMZT6F3EpkJFGZWgXrsXHz/0qKTrsbB2m3/fcyd0lwQ5Lh
fz8X1HPrwXa3BqZskNu1vOUNiqAYWvQ5gtbpweJ96LzMSYVGLK78NigYTtK+Rgq3
As5CVfLXDBburrQNGyRTsilCQDNBvIpib0eqg/HJCNDFMPrBzTMPpUutyatfpFH2
UwTiVBfA14YYDxZaetYWeksy28XH6Uj0ylyz67VHND+gBMmQNLXQHJTIDh8JuIf2
ec6o4HrtyyuRE3urNQmcPMAokacm4NKw2+og6Rg1VS/pckaSPOlSEmNnKFiXStv+
AVd77NGriUWDFCmnrFNOPOIS019W0oOk6YMwTUDSa86Ii6skCtBLHmp/cingkTWg
7KEbdT1uVVPgseC2AFpQ1BWJOjjtyW3GWuxERIhuab9/ckTz6BuIiuK7mfsvPBrn
BqjZyt9WAx8uaWMS/ZrmIj3fUXefaPtl27jMSsiU5oi2vzFu0xiXJb6Jr7RQxD3O
XRnycL/chWnp7eVV1TQS+XzZ3ZZQIjckDWX4E+zGo4o9pD1YC0eytbIlSuqYVr/t
dZmD2gqju3Io9EXPDlRDP2VIX9q1euF9caz1vpLCfV+F8wVPtZe5p6JbNugdgjix
nDZ2sD2xGXy6/fNG75oHveYo6MREFw==
-----END CERTIFICATE-----
-----BEGIN CERTIFICATE-----
MIIFmjCCA4KgAwIBAgICEAAwDQYJKoZIhvcNAQELBQAwWDELMAkGA1UEBhMCVVMx
EzARBgNVBAgMCkNhbGlmb3JuaWExFTATBgNVBAoMDEtvbmcgVGVzdGluZzEdMBsG
A1UEAwwUS29uZyBUZXN0aW5nIFJvb3QgQ0EwHhcNMTkwNTAyMTk0MDQ4WhcNMjkw
NDI5MTk0MDQ4WjBgMQswCQYDVQQGEwJVUzETMBEGA1UECAwKQ2FsaWZvcm5pYTEV
MBMGA1UECgwMS29uZyBUZXN0aW5nMSUwIwYDVQQDDBxLb25nIFRlc3RpbmcgSW50
ZXJtaWRpYXRlIENBMIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEA0dnj
oHlJmNM94vQnK2FIIQJm9OAVvyMtAAkBKL7Cxt8G062GHDhq6gjQ9enuNQE0l3Vv
mSAh7N9gNlma6YbRB9VeG54BCuRQwCxveOBiwQvC2qrTzYI34kF/AeflrDOdzuLb
zj5cLADKXGCbGDtrSPKUwdlkuLs3pRr/YAyIQr7zJtlLz+E0GBYp0GWnLs0FiLSP
qSBWllC9u8gt2MiKyNlXw+kZ8lofOehCJzfFr6qagVklPw+8IpU6OGmRLFQVwVhp
zdAJmAGmSo/AGNKGqDdjzC4N2l4uYGH6n2KmY2yxsLBGZgwtLDst3fK4a3Wa5Tj7
cUwCcGLGtfVTaIXZYbqQ0nGsaYUd/mhx3B3Jk1p3ILZ72nVYowhpj22ipPGal5hp
ABh1MX3s/B+2ybWyDTtSaspcyhsRQsS6axB3DwLOLRy5Xp/kqEdConCtGCsjgm+U
FzdupubXK+KIAmTKXDx8OM7Af/K7kLDfFTre40sEB6fwrWwH8yFojeqkA/Uqhn5S
CzB0o4F3ON0xajsw2dRCziiq7pSe6ALLXetKpBr+xnVbUswH6BANUoDvh9thVPPx
1trkv+OuoJalkruZaT+38+iV9xwdqxnR7PUawqSyvrEAxjqUo7dDPsEuOpx1DJjO
XwRJCUjd7Ux913Iks24BqpPhEQz/rZzJLBApRVsCAwEAAaNmMGQwHQYDVR0OBBYE
FAsOBA6X+G1iTyTwO8Zv0go7jRERMB8GA1UdIwQYMBaAFAdP8giF4QLaR0HEj9N8
apTFYnD3MBIGA1UdEwEB/wQIMAYBAf8CAQAwDgYDVR0PAQH/BAQDAgGGMA0GCSqG
SIb3DQEBCwUAA4ICAQAWzIvIVM32iurqM451Amz0HNDG9j84cORnnaRR5opFTr3P
EqI3QkgCyP6YOs9t0QSbA4ur9WUzd3c9Ktj3qRRgTE+98JBOPO0rv+Kjj48aANDV
5tcbI9TZ9ap6g0jYr4XNT+KOO7E8QYlpY/wtokudCUDJE9vrsp1on4Bal2gjvCdh
SU0C1lnj6q6kBdQSYHrcjiEIGJH21ayVoNaBVP/fxyCHz472w1xN220dxUI/GqB6
pjcuy9cHjJHJKJbrkdt2eDRAFP5cILXc3mzUoGUDHY2JA1gtOHV0p4ix9R9AfI9x
snBEFiD8oIpcQay8MJH/z3NLEPLoBW+JaAAs89P+jcppea5N9vbiAkrPi687BFTP
PWPdstyttw6KrvtPQR1+FsVFcGeTjo32/UrckJixdiOEZgHk+deXpp7JoRdcsgzD
+okrsG79/LgS4icLmzNEp0IV36QckEq0+ALKDu6BXvWTkb5DB/FUrovZKJgkYeWj
GKogyrPIXrYi725Ff306124kLbxiA+6iBbKUtCutQnvut78puC6iP+a2SrfsbUJ4
qpvBFOY29Mlww88oWNGTA8QeW84Y1EJbRkHavzSsMFB73sxidQW0cHNC5t9RCKAQ
uibeZgK1Yk7YQKXdvbZvXwrgTcAjCdbppw2L6e0Uy+OGgNjnIps8K460SdaIiA==
-----END CERTIFICATE-----]],
  key_client = [[-----BEGIN RSA PRIVATE KEY-----
MIIEpgIBAAKCAQEAmV0zGxkcPEBGltJd0gVmJN/wPR1iCw+eybHm1WMD/OtUFJUE
870q6dpc2bhnolaZTB6fMUZvNY80t9sufiSG6hzPOpKu7ld9vIfUesPRx3mWR/jg
PDX+i18gUMGV6JH85YSIDHBLjOLEhqM3K8uveALl2/4X4m5albXJVDHJsgNBagjb
nGl3f5mRc744uROij5im7AgOVSPpGSbmRuqjEOloOKEDZuwCqM0bsb5Ie2Fo3IAK
xCxT+3oEdJbMe6ZJw3QLEn5N5Ud9NmSV6Ui1npg/QHRFCPO9IYDjbdSAAvOomCUY
97xQOObcEyWDbGFN+d/LUnpWZu3mPHoU5dQBGwIDAQABAoIBAQCLqQzeM3q7/4iI
1l+r31DKacgbz4M2MW5XnJNqZTX/f8pcx+vvjqfiuADwH/b4JcaKRCSSOeMSMiw+
9fGb2+WkksHARE3bLH+LTWKYvXRvI/FP73s8Oato/iKuh+vdE/zqgktmkGisjuGK
/l1Cm8VaE8GBGh5kDDyfsyD5dDGJ0fYzJkfQqygd5B5TSaWflQsB//AXvHzkNy+G
RHbrMl7t9rDCTtwnefSEJIEwAZerGKV0p+VlRy23mQLwxTxJ5jEjVvcFIMalnD4R
nKaZYb3LgkCCTQ5Lw/xrkdAEJwfafhdu1CmvKelv1qpcz1vJdrFSfX5NOYS/93jI
aKJT8Nm5AoGBAMmOOUTvbUd9nlbZXYGLTsoy+qA+OhLkB59krddH4mFoRvbggD6U
Y/h7O/fA4spqtts+aVoEh/jyuwGTxMn0NPLjD0G8YZr1A4GUx1hgEQ1NIWvRlXrX
s1bgIlaOc14hOpKf0to3mIovyhRm8PaDbQfHWfyl4yKtFgKiO4OCMK0/AoGBAMLK
e9C5sedDKt8ESycaXnui1hA4WQkeMdXFflnabuhE29dkC7kDFEVurlmsQb3zFa0V
dF40niT7xYqzdEJIbaZ3JZIrSFhnPSSBna+B1FjMhTVb/5sjPJS87BvjVYiZd5GY
5Az4RgSlU3PlsaiuR95NH1vDxHXb5GcMs/EfnEklAoGBAIVFe2yve+yXjUkT9RYh
TPm596pZOwEeskOcyK3epDuQPcwj6eh3Khs1MRPDALKjGUGi5PpWoKnlpe2HDcoT
pacsp/vpWgiiFa1q+NzguKW46G5oaJSPZ8/75/ifvHzzL82fzEXqGPzWWKJg5te5
UzCfikraTXOySyl2qC9uuEz1AoGBAILH8eNMmb48YW9EcbS6Ro9Z38EaI+U0SZ9O
LqvjNS1q9fMiL6CzCYwoaJS6S5VdvMLtsaiCSV9pTtL182uBN2VZf3co6jS4c9ur
zpQEZe6Mui7+KpodSVJPmXKL6mSBLT8q2IpAsrnxyhr5L5OiF4yQWSqCQMgkr6/k
XnfYklSlAoGBAKBePjIdBGLy3ckdlTfbuTeO3kp2eZFBDtGzxP515+LcoRfOjd8T
ZDX/porUMcgbtIF/B4SNso+8D/aHTCg3QAo6nDjFFjUBHhftgy+GP3BFfMvjqou6
utJFRkc3FvrrkkeWHnyDQrPmAHjar94/xq1k1Vo+KQHQVQOrvtQt6KXK
-----END RSA PRIVATE KEY-----]],

  --[[
  Issuer: C = US, ST = California, O = Kong Testing, CN = Kong Testing Root CA
  Validity
      Not Before: Apr 13 23:48:41 2020 GMT
      Not After : Apr 11 23:48:41 2030 GMT
  Subject: C = US, ST = CA, O = Kong Testing, CN = example2.com
  --]]
  cert_client2 = [[-----BEGIN CERTIFICATE-----
MIIEJzCCAg8CFAQ6oTnLBUHbumx1bxyY9kV0W21BMA0GCSqGSIb3DQEBCwUAMFgx
CzAJBgNVBAYTAlVTMRMwEQYDVQQIDApDYWxpZm9ybmlhMRUwEwYDVQQKDAxLb25n
IFRlc3RpbmcxHTAbBgNVBAMMFEtvbmcgVGVzdGluZyBSb290IENBMB4XDTIwMDQx
MzIzNDg0MVoXDTMwMDQxMTIzNDg0MVowSDELMAkGA1UEBhMCVVMxCzAJBgNVBAgM
AkNBMRUwEwYDVQQKDAxLb25nIFRlc3RpbmcxFTATBgNVBAMMDGV4YW1wbGUyLmNv
bTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAK+kZhxdN8PA3SW9cXiv
xgtANq57PIWNnSDsg9Yxn0/+JKR45pSU+SKYtZUJJJuOdkv4IIJLm6uG6LbOPUDO
g9EaV0Zw7RQtbY6EDFDFzeyq0/Mwl9wLJtXf0fPsXGyFIdeelBjzoSVsGGJKPWbP
rlUtSHCrpFX53NTPnNVUJz9V6CdzZJgbyoiWP7ggKJeRPq6jCW5pt+cd+sR4+EPh
daBmEVWeifLEKCbBvsQaOGfU1aVG1AlX0RpLBkTxOOFIIk/3dgWOsrek2ofjku4F
g0MeWmD8oXOHUX2JxO77/BbLDQt0lzD27y/EkDoqy6mMAH85/LTYrU+P0WsEyexg
CHcCAwEAATANBgkqhkiG9w0BAQsFAAOCAgEAwWAxQjQOoGxU5LQu4ZmsCkps9y0B
kNj8MUpLcFmK+02VIUh3hM4vuB6Gct2Ph+6zqCge3oqTXltU0Bs2MTwAKs/scsxq
Mtanz4W00UlmG3QdgHaEs196tYQ8cKIaGZsNBv15VgBBduUG478pKqYE8bJKBbw7
1Ym390hSPo0dNe7jLFXx6AaJvlEYh09P4FgfkXuY5VVTGXfN7XgJI073pLRY6iGH
Qd+Egymh86AQtnoNpmqSCMNcjRVAyR8Ti3qnyro8ruZCnNYHieGeh/ZsZvhGDeWX
v4YXjW2NDQ5+Ok6Gtvhf/l6RSrnXLbZtv8NStqwQJ+ydu05BJglZ/7Sb0uQYVNq2
H8V+MtApFT6fG6ANM6hadNFG+p8Hwz6k4BLrc9ZxeWYKWIIusqExR9JIlGzEjvFJ
6NmNjm3eZE9Ue4YgURj1KTr53wAso4LbJpz/zuZS+m9PMz7n8fRL25/Z5b/92L3a
w0vsxUJyTDeMvYf8oT6OkxNVJ0zBRZNtEg5AJKdP6nU53V998jHP9vUisrU2ALhu
Jw3QiWiDKnRtx8PiiRx7dWo+Xwn9+xVypytqNz3w/XJlOjMwOg73q399w+vMiFTl
qdr7eYvaQBGOZVc3OdiP8afyVxlhHBowUoi8G+iPbgOsARHv/j4UeMVyIThzxv73
a2EQ5BzyOzQ81H4=
-----END CERTIFICATE-----]],
  key_client2 = [[-----BEGIN RSA PRIVATE KEY-----
MIIEpAIBAAKCAQEAr6RmHF03w8DdJb1xeK/GC0A2rns8hY2dIOyD1jGfT/4kpHjm
lJT5Ipi1lQkkm452S/gggkubq4bots49QM6D0RpXRnDtFC1tjoQMUMXN7KrT8zCX
3Asm1d/R8+xcbIUh156UGPOhJWwYYko9Zs+uVS1IcKukVfnc1M+c1VQnP1XoJ3Nk
mBvKiJY/uCAol5E+rqMJbmm35x36xHj4Q+F1oGYRVZ6J8sQoJsG+xBo4Z9TVpUbU
CVfRGksGRPE44UgiT/d2BY6yt6Tah+OS7gWDQx5aYPyhc4dRfYnE7vv8FssNC3SX
MPbvL8SQOirLqYwAfzn8tNitT4/RawTJ7GAIdwIDAQABAoIBAHMJzgdN1rRToYSS
a7uMBL5htG7bMGyYsA1cW4zyu1F9NyqyNPOkDvjl5ChU8LEhwcFIJqKwOqlBlzIE
KoJDwHo4MmlklSLeDh+FxTsyEwmraV6iuRPaCfmSusR0TqSVHfFHX+Bn0WfdQKs/
zK+F3rzTB9sj0GKvYD/SKvpeP8Zuu9EBqo4N7PU3VHwDq5t32Ut/+M5XWtulsQcs
qXr2R3agj/DnODANT6Dn/mJboTrYOSV18S/Yw/+OnWBcLzlT5sj0aLgrtXvIputv
9caux4HklAQr29+lKB8nBTfjhXnBntMaEgqCVJ3ri83MuEfVDhmjwo6PnX22/J0h
2XbCyUECgYEA2v8m+CTBTjdAqOuje34+UiWRzT2P9OFONV8nYgzEcQW5JkUoFCun
KgQQIvjCsX4jY6/8w/IPF1ieTconZYJUWSyMZFtBBDCVif1GZRiiM2C4Zcero1KV
U0V3wZcnYkzafzIHkqFUYZwamvdKWVI4c6F5MhSEKCgcbgKKI52TEokCgYEAzVHr
KjQt+dqNkbipYoGH2ywLdcogDwKoyUFbgcvz/q625gu4am025wF25yRKExm7Dyjx
eCQC+KOsBfJSc78fG5R6KPIDK1JrpUEGSCeqFICiqGv9kUzPf5zeGZVf9cU4tyPT
5wYUEM7NX8VRoasZ4OUvYyYBw1Cx8vMdvQn/gv8CgYAIhxcFYqkEWrJx4XskO+5B
VKUw0MziREO/YE0wTD76B7cF/ntpDaocwLvAIN+z+a13HEtDdhGQXysK7GxMT57p
OgrdfZAykZHBJdOv7B2k0odbr0LHwVd/Pp1DNJecBFId0dzpoM6gXmvKzQZgJAt+
tTL6+EGNLsKspfyrFl+7wQKBgQDAt2VuJbAJ1xQOdS+4IDCujfbrxp60uCBJVylW
+WK56LAP2WxtqLlhtsQuTKeiqgIkRp/vzo1jZ+0tX7f4oKnIL2NCT3aeESys3g3R
aDmCKQOD5mkJGvmgpFLr3INHoqiLbfuV2uS2qgWnIQRwJLOTnksOWzxIYdPFYGDH
cTz9bQKBgQDGv929DUinrKXe/uKJHLAcq+MjmF/+kZU9yn+svq6SSdplqp7xbXX4
3T5HCWqD4Sy+PVzGaDg5YfXC8yaFPPfY0/35T2FoQEiCAPQO+07Smg6RqJ3yVpIm
LTsbLleJTc8CX0bI4SukQ7MVQsiHimzyEzx3eyLt1S8aBdJuRFZ2mg==
-----END RSA PRIVATE KEY-----]],

  --[[
  Issuer: C=US, ST=California, L=San Francisco, O=Mashape, OU=Kong, CN=ssl-alt.com
  Validity
      Not Before: May 24 23:46:58 2017 GMT
      Not After : Jun 23 23:46:58 2017 GMT
  Subject: C=US, ST=California, L=San Francisco, O=Mashape, OU=Kong, CN=ssl-alt.com
  Subject Public Key Info:
      Public Key Algorithm: rsaEncryption
          Public-Key: (4096 bit)
  --]]
  cert_alt = [[-----BEGIN CERTIFICATE-----
MIIFXjCCA0YCCQCsb6B5OWdHXDANBgkqhkiG9w0BAQsFADBxMQswCQYDVQQGEwJV
UzETMBEGA1UECAwKQ2FsaWZvcm5pYTEWMBQGA1UEBwwNU2FuIEZyYW5jaXNjbzEQ
MA4GA1UECgwHTWFzaGFwZTENMAsGA1UECwwES29uZzEUMBIGA1UEAwwLc3NsLWFs
dC5jb20wHhcNMTcwNTI0MjM0NjU4WhcNMTcwNjIzMjM0NjU4WjBxMQswCQYDVQQG
EwJVUzETMBEGA1UECAwKQ2FsaWZvcm5pYTEWMBQGA1UEBwwNU2FuIEZyYW5jaXNj
bzEQMA4GA1UECgwHTWFzaGFwZTENMAsGA1UECwwES29uZzEUMBIGA1UEAwwLc3Ns
LWFsdC5jb20wggIiMA0GCSqGSIb3DQEBAQUAA4ICDwAwggIKAoICAQC4SEsrn5zj
f2w/mT9zxw9RZJxIo325HPHUV27U1gX5YFnCGdA6znvzd+GzUwohJMFhH7X7k3+g
NhXZlUaxJ01N98QBmNH6GfzAoZexny+QGRU7/jkziQMH1A94yXBxQa5cfg3WA4ti
JaIDZHRTVLDTvONm4a1GUuU6p6aUarZznCzzvkCqPzSBamHMu2jMWmozdVwPQufH
mzJLbNLa7TVjVnalKgAdnXz8Rdnivb8pRVj8ASJU+iGQBCaXRAtRm4Hd0PAdJPXH
6ObregxF0uhwDlHr2FbmdYjWKf6WB5xz18LVreWF07VN5AHsa+H/wMYOpuInmiYt
9Xzl3h8dt8KiFwaMf4jYyNRRyLZhJEM8F7pSAuTLXTcluK79hWhliwO7DFKGbrJY
YDQoLQFX6E0xyfYXXnaNTVuiu9503wwX2+IoomUEFXQ0TJ1+9gBg855Jx6Xw5/Zb
njQS9ayYl5HlGzWKR+Dul13JgDDMYSqvI69tTmL1JOdufopmFUr50C0TPdp2cQlP
gHXhqMbAua+EcpPiBSk9mQ0jY2CpRczos5Ais4TV8r71VEqJgaTVd39tG63/q/ig
XFvoPRzi53/tBWy3cVroEvsajNzObuQcwW7b70AULnp0VFDhrRuAsQ9ULXOi6gMP
K0hyONTdXijtHk6ndEFH9qpYMXQOmpCYtQIDAQABMA0GCSqGSIb3DQEBCwUAA4IC
AQCvuEsqWpgRqLgvfJXgoLRpoeADG3OlY0ikuOaW+dPapbC9WC02Sa0f7Iy6gED7
8UFGUorZVYKKTuR8SJk27Q/vVKV7Ljtj9mkIRcBPWpePr08qzVBd3xrSONPVwRgU
cORI2xNFaz0NwtKOHZ7MIQ8SJbvlqCHYUrl165eIJIiUF2hyzMv4Ymg8Vb0gwGtG
DEibtQweiMZ17STlZ/q1qW5q9nlEvIUNHb8uno77r+l7LdBNWfSwwme+TQHXfR8q
UzMzLvgKJQzkayaNQI9BD+Ztm0BcYzC72MrHfpTyM3PndbL5Kkws40XZ5bmwgbYn
JsIUW1cGxBUc3+lVVQUO4zpihO5oQXwV5LcMkIfYEc1VA1LfqmveXB8/5bGTsHVX
HVWGNNB6Eb5t+jlGRWE61KU79kw3jBuhG/MXSsjeR3rPX6mqoVMNtPzMuG7V9f+a
bbsKp5oLfDPw1D7x7HgBDH7wlbovXavbF/7gqApdssYqtPqVC9MekYAOhC63tuuP
oBthw0f9wa7vQc50VLSIOAUZbgg3Qpic+abkUpLLqPH2nIp0ffBAZ054+u7GkMwQ
daRqH/ssQmfPQxd1l4x8mynx876bgWrg2y6EJoM1N5zCoA2C1hloDL4EApJHCmP2
OoLwADN8ov3ctgXUAv9wgYkJHkQ7TO1dRpvuIzXc/oJA1w==
-----END CERTIFICATE-----]],

  key_alt = [[-----BEGIN RSA PRIVATE KEY-----
MIIJKAIBAAKCAgEAuEhLK5+c439sP5k/c8cPUWScSKN9uRzx1Fdu1NYF+WBZwhnQ
Os5783fhs1MKISTBYR+1+5N/oDYV2ZVGsSdNTffEAZjR+hn8wKGXsZ8vkBkVO/45
M4kDB9QPeMlwcUGuXH4N1gOLYiWiA2R0U1Sw07zjZuGtRlLlOqemlGq2c5ws875A
qj80gWphzLtozFpqM3VcD0Lnx5syS2zS2u01Y1Z2pSoAHZ18/EXZ4r2/KUVY/AEi
VPohkAQml0QLUZuB3dDwHST1x+jm63oMRdLocA5R69hW5nWI1in+lgecc9fC1a3l
hdO1TeQB7Gvh/8DGDqbiJ5omLfV85d4fHbfCohcGjH+I2MjUUci2YSRDPBe6UgLk
y103Jbiu/YVoZYsDuwxShm6yWGA0KC0BV+hNMcn2F152jU1borvedN8MF9viKKJl
BBV0NEydfvYAYPOeScel8Of2W540EvWsmJeR5Rs1ikfg7pddyYAwzGEqryOvbU5i
9STnbn6KZhVK+dAtEz3adnEJT4B14ajGwLmvhHKT4gUpPZkNI2NgqUXM6LOQIrOE
1fK+9VRKiYGk1Xd/bRut/6v4oFxb6D0c4ud/7QVst3Fa6BL7Gozczm7kHMFu2+9A
FC56dFRQ4a0bgLEPVC1zouoDDytIcjjU3V4o7R5Op3RBR/aqWDF0DpqQmLUCAwEA
AQKCAgBn/HtWaWHJSdzWYm5YsYnmPuSlZIQMEdYwIQosVXzXhFQB4DkNBfkRoKMe
YoxDuY7ZdGBnTork58AaoE5cprXLejUDRa2u+D0UodqMYywentjJmqHCf9zS7Qmx
+dFWR17RWFwMWMGtJ1ktmuC9KPwC7wJOyqfRF/O7zmCEPVcpE4aWH9QzfSjuog3/
zfzL23U0BlRlVDaf/uY5g3XUDahjnqWie3nHPFgLrorNlI6rBjO5OBacZuzLbFwu
XToZ2atFdKIZgAKkxLqRQ7RrLiD1Ik99yvz2XHpThyzekfrpr2WE1/S9OIKFKlUf
iJzliWz5VZgmCqjipDTPLTDXvxq3EJDGbOlsD3eLXGeIufbQY4SqV73rth+0gER4
m0S7cGjUuUASvtoX0pyxFwlZ3/DISMDKvGDGvx3FlYhDs/8D54C9nuuYXpCflw/g
8+C6uIF4zIcQ4JNI9RKQDlUYCTKiz8klCzXQxVy4HVyPVYWQxXfNYVkyQjf7PxQi
Xr1TwgE2snGjxqfWbuEnqTz2LADGUjtTwwZcOkur3CAAKqd86Keka6ZUaAe8IM+D
xuUDH/v3cH8qb5PDZ2OIoVTJk3DDr2NZ3JOX55UV7AutWFYTCRhX3qNY9aQ8iol7
AjfMIRzB6uupMgbpCuuAYlvDtSxNK2hPFWlO24ybqh15F8NkoQKCAQEA6UWA5Lgc
E4+b7Yr9vqFqoTlpWmPBvPR1F4GolOOxs2R3pL45Uqc8afgQPXSB/vGH9o4asF6X
8XfqRNyObTzSvbwuOMw1G1lTMPiWVHY2MNs4fZwEoCdVJJSYJorEJlyPRxsZ86xD
ltGsa7RiLUk2IoYrocgrMz6MN03eNET5mVu1eLb59fMSwEoer6CY2n8kE56SvsaK
3ulwaJeKBUWWXsoZ+e7NWx55sPQ/95F2exk9aCGdRUsFMM+vjunIq+7jq5DyL/O0
Jqe9g4QTGLTT9DydKZhjvPlnW51Ehl42nwoQNSpCwHmR9qfV/lqjU21tnwJ0lAEd
AuVaRyMfyLE/3QKCAQEAyjzalPsVBNL+/9Tl4dabR0VpP00oTl1g8fguke8sE+ay
BKwipAQHoCvFufB/wmTR/H2U7ogGhwUWxkjeJIk44BAqI2wbq4HdKE1Yo2k2QB6m
VkWOqdf47OKupTOhxIeNrRapCQ5r44LVjK7jgvMvbOJ9OGZm+/5IgkoYgRK4jOYk
h89iM3g5bEQ4zgugQP85ghQQ9pwwAy3d/06V2auCJo4pitjluKctB5HtXubTJSMl
axRpVQ8fhtlC8MUpDx1v8OZRkxQIa82VR9v8cUM0Zlw8t1vOz/W8ECzyfJtsFMUC
ykMTTBmpt9+sAXaCR0Mwo3GJABrsSn2z5vGmiKEauQKCAQBoxisKkBcsQgiLPS6T
fPTjzWGgk8XlFPeywy3xEgQyyyFiAX7FvQ/JmP3SXI428E1dVJ5wMUyVzIKQw2/F
aNhPGEK6iB4iVpCjIkSDU0Ur1IsfAACj3obDk2pzhUhs4o4IJggWBn2lNC/5gF/I
b2W9Q/49ACdHMQTRokv3tjNVyndL7QOAkNkPPTtjLwL4wLp3hXXr8klVrgwrLkVz
8LmFgckBFV1vW9TUwiApFlDdIY0PRGnbQcLnFaGI00Cq2PWxjbz6BMAZzKW2eJAL
PM0mmkMM98F0k6D06UJqB88IyABXoM+ym+gPnXrkb9mEE1Z1YSjzgTyCnHlcEk6o
WdSRAoIBACg1bSgNu6IX6UcoJwR9zKWg8Un6pzbdbfbt5yRwrwzN4zr2lnSRsIpx
6YAMhvo5XV6cAU5jkRirNFn8Bt6wwbQawqYESoQQ782hgywKMRUSgvPIJJM0M3O1
pg+GcnVGli6BwN3iFiVHz/mGlAlnHFjDty3NflA/wF7XKIQRGsw4va6a1uVw08no
znp46UXC+MYaAz1k1E7tgaPPFhAO/3N29F98vD+4TUWiB9XEgtpxYHEnv8F/nj8L
VznTmVQ+ABGfWTyq0PnOCA4feNN0DykC0beK81V5gAifRx7rL9P5T5KzP1T0DUBX
ojUwQLq2aycz3Y89yxkMYQZbqUak8VECggEBAMj0qzxSPrboxNOwKRcpGGhRFscJ
K/4iNG165/q2btZiDZ9BiUO8WZGR8Ww50fZb21fIJBaU+znLaDiY6b4UDc0H4d0H
vt9bkm9BmNkdbHlDR++7XcRIuq1w4EDtgvDqT8oCuW8mWOt+oqnQof3MOO0Z0AbI
Ksbcnvk0qf75vZUVPoPCoIAuex23PxWhewb3BM9ifeRr4EUjWWH9+iJ0ucnGHndq
MRz5bk6HBaxa2Twpa6yra+pobyWhRyU/X40wV7nUs3wd1vZNMjn0i8vXwnT6zdNv
11htsJRdoyo2gXnVNMWN1D+8QTozSXFTTyM2LG4k06Dw3dAl5KHQjKWX+ac=
-----END RSA PRIVATE KEY-----]],

  --[[
  Signature Algorithm: ecdsa-with-SHA256
  Issuer: C = US, ST = California, L = San Francisco, O = Kong, OU = Core, CN = ssl-example.com
  Validity
      Not Before: Nov 18 16:49:53 2020 GMT
      Not After : Sep  3 16:49:53 2294 GMT
  --]]
  cert_alt_ecdsa =  [[-----BEGIN CERTIFICATE-----
MIICOjCCAeGgAwIBAgIUbsAIMsTeD3F1oNLKOyRabSN6O9EwCgYIKoZIzj0EAwIw
cjELMAkGA1UEBhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExFjAUBgNVBAcMDVNh
biBGcmFuY2lzY28xDTALBgNVBAoMBEtvbmcxDTALBgNVBAsMBENvcmUxGDAWBgNV
BAMMD3NzbC1leGFtcGxlLmNvbTAgFw0yMDExMTgxNjQ5NTNaGA8yMjk0MDkwMzE2
NDk1M1owcjELMAkGA1UEBhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExFjAUBgNV
BAcMDVNhbiBGcmFuY2lzY28xDTALBgNVBAoMBEtvbmcxDTALBgNVBAsMBENvcmUx
GDAWBgNVBAMMD3NzbC1leGFtcGxlLmNvbTBZMBMGByqGSM49AgEGCCqGSM49AwEH
A0IABCwjAZ7WZIwBJQOER5LB6g554ecpBVUnHKjYq8xiWU2+giX5pg4ros6rf3tv
MMkc3aPYz87B7bwQlZ0Z2NC7iUujUzBRMB0GA1UdDgQWBBQzR6or+QaEVZxXrX5/
BhgA7y5mjTAfBgNVHSMEGDAWgBQzR6or+QaEVZxXrX5/BhgA7y5mjTAPBgNVHRMB
Af8EBTADAQH/MAoGCCqGSM49BAMCA0cAMEQCIEDzO105JmNu3RLib3DyIZ4TqDTF
/iEr+t+W6+rZqiHuAiBvhIxGlLfkypQa9p4iNKRLmFcEk/S/shQ4d0hzd9SDbg==
-----END CERTIFICATE-----]],
  key_alt_ecdsa = [[-----BEGIN EC PRIVATE KEY-----
MHcCAQEEIECo5oNJH83ZUFUm3SfjRHyPyRU5pJ5D1V0zk4KtrlNZoAoGCCqGSM49
AwEHoUQDQgAELCMBntZkjAElA4RHksHqDnnh5ykFVSccqNirzGJZTb6CJfmmDiui
zqt/e28wyRzdo9jPzsHtvBCVnRnY0LuJSw==
-----END EC PRIVATE KEY-----]],

  --[[
  Issuer: C = US, ST = California, L = San Francico, O = Kong Inc., CN = ssl-alt-alt.com
  Validity
      Not Before: Nov 18 07:28:56 2018 GMT
      Not After : Dec 18 07:28:56 2018 GMT
  Subject: C = US, ST = California, L = San Francico, O = Kong Inc., CN = ssl-alt-alt.com
  Subject Public Key Info:
      Public Key Algorithm: rsaEncryption
          Public-Key: (2048 bit)
  --]]
  cert_alt_alt = [[-----BEGIN CERTIFICATE-----
MIIDpDCCAoygAwIBAgIJAIAQMZH+2V26MA0GCSqGSIb3DQEBCwUAMGcxCzAJBgNV
BAYTAlVTMRMwEQYDVQQIDApDYWxpZm9ybmlhMRUwEwYDVQQHDAxTYW4gRnJhbmNp
Y28xEjAQBgNVBAoMCUtvbmcgSW5jLjEYMBYGA1UEAwwPc3NsLWFsdC1hbHQuY29t
MB4XDTE4MTExODA3Mjg1NloXDTE4MTIxODA3Mjg1NlowZzELMAkGA1UEBhMCVVMx
EzARBgNVBAgMCkNhbGlmb3JuaWExFTATBgNVBAcMDFNhbiBGcmFuY2ljbzESMBAG
A1UECgwJS29uZyBJbmMuMRgwFgYDVQQDDA9zc2wtYWx0LWFsdC5jb20wggEiMA0G
CSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDCngZ5grKAV5bR/FRSkIiR9Y54OWMt
endztlp3scp4vTVci4mMOhsSMkTJSpxOieOWACCKpHksux8kUJjOgJ12p9FrWII4
SYj3+5R+I8ujD3zmx3IDol8UIFsCuibVhN9FKDcVHySPtNGwIM0NnjuVm2fl79hU
ILNmtOq/GoUbScecaMnKzFZy+VUPXRIdQtHOUUteVdppFrx2EPP+Az9l2CN75CRi
VjwxTA8REkYm9C2okVdj38JodiBnkO1z0aEIlQD8qKgG86C+YF7qTlSzUtoOHvkt
Km+PoKoMlDvcZ/ItXz7b2I+x3jhsnVETGTXV8jHIRncl+o7jKV5H/gxDAgMBAAGj
UzBRMB0GA1UdDgQWBBR2h+rYF8B91WE7tUpeCST8TOQrUjAfBgNVHSMEGDAWgBR2
h+rYF8B91WE7tUpeCST8TOQrUjAPBgNVHRMBAf8EBTADAQH/MA0GCSqGSIb3DQEB
CwUAA4IBAQARP3bVbTHYlB/V6Ws0jvjJtRGs6RkIB8Hvwcn9hltoKpgdRcrkpkCI
50jmipO2ssP5uEhhBuS3D53K3GEYWJJh35MW7iAzJw1+Yn+/00/1nwhoaYvjbxv+
k5rtGHIR8oj8Uf0ijh+ah508cavls/jotQXqkGkkg3QNDJ/2H+QmxMtAM5VJ/dU9
66IeVk1e/y4wBMFyCzMQQ/HluLmOXlrhttEgwpcCfm4/dksRPav5nPi75OqabI0V
bpTBKoI0Llp45GWNeQyF9kPV3wTDF0UmzZnkD95hoe4CHZV7dsUGS8YfM9Wv6Cvh
wcqsNL5LjIUJiNuykV2pruOsf5IoCKlG
-----END CERTIFICATE-----]],

  key_alt_alt = [[-----BEGIN PRIVATE KEY-----
MIIEvwIBADANBgkqhkiG9w0BAQEFAASCBKkwggSlAgEAAoIBAQDCngZ5grKAV5bR
/FRSkIiR9Y54OWMtendztlp3scp4vTVci4mMOhsSMkTJSpxOieOWACCKpHksux8k
UJjOgJ12p9FrWII4SYj3+5R+I8ujD3zmx3IDol8UIFsCuibVhN9FKDcVHySPtNGw
IM0NnjuVm2fl79hUILNmtOq/GoUbScecaMnKzFZy+VUPXRIdQtHOUUteVdppFrx2
EPP+Az9l2CN75CRiVjwxTA8REkYm9C2okVdj38JodiBnkO1z0aEIlQD8qKgG86C+
YF7qTlSzUtoOHvktKm+PoKoMlDvcZ/ItXz7b2I+x3jhsnVETGTXV8jHIRncl+o7j
KV5H/gxDAgMBAAECggEBAJhVXTgLZ3EyHimrWs1tuJiXHrdYJBta+tkl6VY7YgJ0
B6qyxi1u5fWuR01QC10mbW/iFZav+vFaXpvsQk+ROK/B2BgwJW2tkXqZ/7dkiWbP
HrL9dm8Fz2pPkS1nTDJhWOom+kacI+AgZul4I0j/jCAkjoTa4fenyQUho4WGWp3q
GIVcawNfprrXObMUgs+31eps3A/iza7w3eBuH4aR2npW6DtBr3KPwH9H1yBLpOqq
E7vY/oyfndKyMMdJGk9Ql8AN5SA4B/r2t5nw+liRUUxIj+yWf5q5pj2FftBo2Ldn
0JGWKXDUTdniLzK+akynRv5o1GFR0SeK7TLRzASfavECgYEA+nojt54CTglUOPCY
rpoM898SypItYJOhlvE/HlfmsLmRMpkCAIYo7yCtCTdRC9gd9FPxEJIAC/P3MzTa
KlVfwXqlFIC+oflfIkF8I5Zw4JsqqF+aqEY4b2xTLfxnfK5gMID2rRstUVQO1BiE
Jb6KzB/67e1yokGgKLIeGsOkqdcCgYEAxuiTVt1RZzqOKTvKYLd8tANzm+lwD6Dd
kpVl3xZcHEVd/nWfdtR8VZ+V+mbe71Hn7ZX/UBBktLeB6djd0cdd8jIOCkvhW/aw
vLm2VAM7J6H5Up92q9Jtpid+993fbd07d7peO+boMYzPW0f7wqU0PL+ZK9R9FdS2
cHaTcFvrW3UCgYEA6DRa8FqXoGidn7vMj/FYmKzw6sLhNmsmnpw/+41Z2/PsW4/l
fz7gq+8K+0RA6k4MVvmKveXcDTi6rsoMhrpm7yMX7w37rIVWYJd80jEhq9etkDIx
Wlbe8szlv/gCqF+v5Mdp58kOFhtrM80WlTczzVDIe9JpN2rHY3Lc3csJ2DkCgYEA
hCAHhyLaKNT3i6JAyz/24OiOCdnlaywzImSE18xVgR3+0sE1HM0GjiXEjSF6IsRo
aCREBN3u1zAyZrB8oBVrbS8crnA7EUhrm+FMoL/IsongQKbWQEo2NbF0oJdMDAFx
uBUe9XFreUaMkpjdPi1Y5qVqzHeIY1D5ovjQ9UjJrOUCgYA/GJPhcZbEz4MgokqE
CCWCLF6Ia5fehznO6VrbKZUUklURFIaw6Uc+DIbGpJZZwVt9l7R3x2pJlF1NlaCJ
IqGzqSWne1tW86drBcfSip714wsZOoF8PT6iUCa0LC1sum1P4vS2cnRw8jXwIL6g
gEuhDrQHJ5V1U/Qc1HrqWYH4cA==
-----END PRIVATE KEY-----]],

  --[[
  Signature Algorithm: ecdsa-with-SHA256
  Issuer: C = US, ST = California, L = San Francisco, O = Kong, OU = Core, CN = ssl-alt-alt.com
  Validity
      Not Before: Nov 25 14:47:53 2020 GMT
      Not After : Sep 10 14:47:53 2294 GMT
  Subject: C = US, ST = California, L = San Francisco, O = Kong, OU = Core, CN = ssl-alt-alt.com
  --]]
  cert_alt_alt_ecdsa = [[-----BEGIN CERTIFICATE-----
MIICPDCCAeGgAwIBAgIUUN+dYLgQkk8az6KLufNic5LFKrYwCgYIKoZIzj0EAwIw
cjELMAkGA1UEBhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExFjAUBgNVBAcMDVNh
biBGcmFuY2lzY28xDTALBgNVBAoMBEtvbmcxDTALBgNVBAsMBENvcmUxGDAWBgNV
BAMMD3NzbC1hbHQtYWx0LmNvbTAgFw0yMDExMjUxNDQ3NTNaGA8yMjk0MDkxMDE0
NDc1M1owcjELMAkGA1UEBhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExFjAUBgNV
BAcMDVNhbiBGcmFuY2lzY28xDTALBgNVBAoMBEtvbmcxDTALBgNVBAsMBENvcmUx
GDAWBgNVBAMMD3NzbC1hbHQtYWx0LmNvbTBZMBMGByqGSM49AgEGCCqGSM49AwEH
A0IABKnmBOy/odm9rUNVTz2vMzGtXVnodngWFY7wf2W99aLcDLz32WNg10oYdGKW
MuPCtO6vwWGgOi+/mYSToEU7U0qjUzBRMB0GA1UdDgQWBBQtbY0EZpt9Nlf2spRC
IfphGjYmijAfBgNVHSMEGDAWgBQtbY0EZpt9Nlf2spRCIfphGjYmijAPBgNVHRMB
Af8EBTADAQH/MAoGCCqGSM49BAMCA0kAMEYCIQC7MFmBMdan3DIsgzLDDwTOLkOI
+Vj2qMdBL4XRWt9c6gIhAMAbZ8M3kMTxPuI+bjZ31Zuu+bGg0Quo4EgU8yMmhJLt
-----END CERTIFICATE-----]],

  key_alt_alt_ecdsa = [[-----BEGIN EC PRIVATE KEY-----
MHcCAQEEILefTUI90Vsu3JV1WZVrYgl82HbAICC/9/sMIL6j1RThoAoGCCqGSM49
AwEHoUQDQgAEqeYE7L+h2b2tQ1VPPa8zMa1dWeh2eBYVjvB/Zb31otwMvPfZY2DX
Shh0YpYy48K07q/BYaA6L7+ZhJOgRTtTSg==
-----END EC PRIVATE KEY-----]],

  --[[
  Issuer: C = US, ST = California, O = Kong Testing, CN = Kong Testing Root CA
  Validity
      Not Before: May  2 19:34:42 2019 GMT
      Not After : Apr 27 19:34:42 2039 GMT
  Subject: C = US, ST = California, O = Kong Testing, CN = Kong Testing Root CA
  X509v3 Basic Constraints: critical
      CA:TRUE
  X509v3 Key Usage: critical
      Digital Signature, Certificate Sign, CRL Sign
  --]]
  cert_ca = [[-----BEGIN CERTIFICATE-----
MIIFoTCCA4mgAwIBAgIUQDBLwIychoRbVRO44IzBBk9R4oYwDQYJKoZIhvcNAQEL
BQAwWDELMAkGA1UEBhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExFTATBgNVBAoM
DEtvbmcgVGVzdGluZzEdMBsGA1UEAwwUS29uZyBUZXN0aW5nIFJvb3QgQ0EwHhcN
MTkwNTAyMTkzNDQyWhcNMzkwNDI3MTkzNDQyWjBYMQswCQYDVQQGEwJVUzETMBEG
A1UECAwKQ2FsaWZvcm5pYTEVMBMGA1UECgwMS29uZyBUZXN0aW5nMR0wGwYDVQQD
DBRLb25nIFRlc3RpbmcgUm9vdCBDQTCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCC
AgoCggIBAMp6IggUp3aSNRbLAac8oOkrbUnFuxtlKGYgg8vfA2UU71qTktigdwO6
Kod0/M+daO3RDqJJXQL2rD14NDO3MaextICanoQSEe+nYyMFUIk+QplXLD3fbshU
nHoJcMS2w0x4cm1os4ebxR2Evndo6luz39ivcjau+BL+9iBAYL1g6+eGOjcSy7ft
1nAMvbxcQ7dmbAH2KP6OmF8cok+eQWVqXEjqtVx5GDMDlj1BjX6Kulmh/vhNi3Hr
NEi+kPrw/YtRgnqnN0sv3NnAyKnantxy7w0TDicFjiBsSIhjB5aUfWYErBR+Nj/m
uumwc/kRJcHWklqDzxrZKCIyOyWcE5Dyjjr46cnF8HxhYwgZcwkmgTtaXOLpBMlo
XUTgOQrWpm9HYg2vOJMMA/ZPUJ2tJ34/4RgiA00EJ5xG8r24suZmT775l+XFLFzp
Ihxvs3BMbrWsXlcZkI5neNk7Q/1jLoBhWeTYjMpUS7bJ/49YVGQZFs3xu2IcLqeD
5WsB1i+EqBAI0jm4vWEynsyX+kS2BqAiDtCsS6WYT2q00DTeP5eIHh/vHsm75jJ+
yUEb1xFxGnNevLKNTcHUeXxPUnowdC6wqFnaJm7l09qVGDom7tLX9i6MCojgpAP0
hMpBxzh8jLxHh+zZQdiORSFdYxNnlnWwbic2GUJruiQVLuhpseenAgMBAAGjYzBh
MB0GA1UdDgQWBBQHT/IIheEC2kdBxI/TfGqUxWJw9zAfBgNVHSMEGDAWgBQHT/II
heEC2kdBxI/TfGqUxWJw9zAPBgNVHRMBAf8EBTADAQH/MA4GA1UdDwEB/wQEAwIB
hjANBgkqhkiG9w0BAQsFAAOCAgEAqXZjy4EltJCRtBmN0ohAHPWqH4ZJQCI2HrM3
wHB6c4oPWcJ+M2PfmYPUJo9VMjvn4S3sZuAysyoHduvRdGDnElW4wglL1xxpoUOx
FqoZUoYWV8hDFmUTWM5b4CtJxOPdTAd8VgypulM3iUEzBQrjR6tnMOdkiFMOmVag
0/Nnr+Tcfk/crMCx3xsVnisYjJoQBFBH4UY+gWE/V/MS1Sya4/qTbuuCUq+Qym5P
r8TkWAJlg7iVVLbZ2j94VUdpiQPWJEGMtJck/NEmOTruhhQlT7c1u/lqXCGj7uci
LmhLsBVmdtWT9AWS8Rl7Qo5GXbjxKIaP3IM9axhDLm8WHwPRLx7DuIFEc+OBxJhz
wkr0g0yLS0AMZpaC6UGbWX01ed10U01mQ/qPU5uZiB0GvruwsYWZsyL1QXUeqLz3
/KKrx3XsXjtBu3ZG4LAnwuxfeZCNw9ofg8CqF9c20ko+7tZAv6DCu9UL+2oZnEyQ
CboRDwpnAlQ7qJVSp2xMgunO3xxVMlhD5LZpEJz1lRT0nQV3uuLpMYNM4FS9OW/X
MZSzwHhDdCTDWtc/iRszimOnYYV8Y0ubJcb59uhwcsHmdfnwL9DVO6X5xyzb8wsf
wWaPbub8SN2jKnT0g6ZWuca4VwEo1fRaBkzSZDqXwhkBDWP8UBqLXMXWHdZaT8NK
0NEO74c=
-----END CERTIFICATE-----]],

  key_ca = [[-----BEGIN RSA PRIVATE KEY-----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-----END RSA PRIVATE KEY-----]],

  dhparam = [[-----BEGIN DH PARAMETERS-----
MIIBDAKCAQEA//////////+t+FRYortKmq/cViAnPTzx2LnFg84tNpWp4TZBFGQz
+8yTnc4kmz75fS/jY2MMddj2gbICrsRhetPfHtXV/WVhJDP1H18GbtCFY2VVPe0a
87VXE15/V8k1mE8McODmi3fipona8+/och3xWKE2rec1MKzKT0g6eXq8CrGCsyT7
YdEIqUuyyOP7uWrat2DX9GgdT0Kj3jlN9K5W7edjcrsZCwenyO4KbXCeAvzhzffi
7MA0BM0oNC9hkXL+nOmFg/+OTxIy7vKBg8P+OxtMb61zO7X8vC7CIAXFjvGDfRaD
ssbzSibBsu/6iGtCOGEoXJf//////////wIBAgICAOE=
-----END DH PARAMETERS-----]],
}
