local helpers = require "spec.helpers"

describe("kong check", function()
  it("validates a conf", function()
    local _, _, stdout = assert(helpers.kong_exec("check " .. helpers.test_conf_path))
    assert.matches("configuration at .- is valid", stdout)
  end)
  it("reports invalid conf", function()
    local _, stderr = helpers.kong_exec("check spec/fixtures/invalid.conf")
    assert.matches("[error] untrusted_lua has an invalid value", stderr, nil, true)
  end)
  it("doesn't like invalid files", function()
    local _, stderr = helpers.kong_exec("check inexistent.conf")
    assert.matches("[error] no file at: inexistent.conf", stderr, nil, true)
  end)
end)
