# Crate Locks

This directory contains the lock files for the Rust dependencies.

* `xxx.Cargo.lock`: This file is generated by `cargo`, but we generate it with `bazel` to make the `rules_rust` happy.
* `xxx.lock`: This file is generated by `bazel` and is used by `rules_rust` for reproducibility.

## Repin

For more information on how to repin the dependencies,
please check out the [rules_rust](https://github.com/bazelbuild/rules_rust).

### Bash

```bash
crates="atc_router_crate_index"
CARGO_BAZEL_REPIN=1 CARGO_BAZEL_REPIN_ONLY=$scrates bazel sync --only=$crates
unset crates
```

### Fish

```fish
set -l crates \
    atc_router_crate_index
CARGO_BAZEL_REPIN=1 CARGO_BAZEL_REPIN_ONLY=$(string join ',' $crates) bazel sync --only=$(string join ',' $crates)
set -e crates
```
