## Kong


### Performance
#### Performance

- Fixed an inefficiency issue in the Luajit hashing algorithm
 [#13240](https://github.com/Kong/kong/issues/13240)
 [KAG-4646](https://konghq.atlassian.net/browse/KAG-4646)
#### Core

- Removed unnecessary DNS client initialization
 [#13479](https://github.com/Kong/kong/issues/13479)
 [KAG-5059](https://konghq.atlassian.net/browse/KAG-5059)

- Improved latency performance when gzipping/gunzipping large data (such as CP/DP config data).
 [#13338](https://github.com/Kong/kong/issues/13338)
 [KAG-4878](https://konghq.atlassian.net/browse/KAG-4878)


### Deprecations
#### Default

- Debian 10, CentOS 7, and RHEL 7 reached their End of Life (EOL) dates on June 30, 2024. As of version 3.8.0.0 onward, Kong is not building installation packages or Docker images for these operating systems. Kong is no longer providing official support for any Kong version running on these systems.
 [#13468](https://github.com/Kong/kong/issues/13468)
 [KAG-4847](https://konghq.atlassian.net/browse/KAG-4847)
 [FTI-6054](https://konghq.atlassian.net/browse/FTI-6054)
 [KAG-4549](https://konghq.atlassian.net/browse/KAG-4549)
 [KAG-5122](https://konghq.atlassian.net/browse/KAG-5122)

### Dependencies
#### Core

- Bumped lua-resty-acme to 0.15.0 to support username/password auth with redis.
 [#12909](https://github.com/Kong/kong/issues/12909)
 [KAG-4330](https://konghq.atlassian.net/browse/KAG-4330)

- Bumped lua-resty-aws to 1.5.3 to fix a bug related to STS regional endpoint.
 [#12846](https://github.com/Kong/kong/issues/12846)
 [KAG-3424](https://konghq.atlassian.net/browse/KAG-3424) [FTI-5732](https://konghq.atlassian.net/browse/FTI-5732)

- Bumped lua-resty-healthcheck from 3.0.1 to 3.1.0 to fix an issue that was causing high memory usage
 [#13038](https://github.com/Kong/kong/issues/13038)
 [FTI-5847](https://konghq.atlassian.net/browse/FTI-5847)

- Bumped lua-resty-lmdb to 1.4.3 to get fixes from the upstream (lmdb 0.9.33), which resolved numerous race conditions and fixed a cursor issue.
 [#12786](https://github.com/Kong/kong/issues/12786)


- Bumped lua-resty-openssl to 1.5.1 to fix some issues including a potential use-after-free issue.
 [#12665](https://github.com/Kong/kong/issues/12665)


- Bumped OpenResty to 1.25.3.2 to improve the performance of the LuaJIT hash computation.
 [#12327](https://github.com/Kong/kong/issues/12327)
 [KAG-3515](https://konghq.atlassian.net/browse/KAG-3515) [KAG-3570](https://konghq.atlassian.net/browse/KAG-3570) [KAG-3571](https://konghq.atlassian.net/browse/KAG-3571) [JIT-2](https://konghq.atlassian.net/browse/JIT-2)

- Bumped PCRE2 to 10.44 to fix some bugs and tidy-up the release (nothing important)
 [#12366](https://github.com/Kong/kong/issues/12366)
 [KAG-3571](https://konghq.atlassian.net/browse/KAG-3571)
 [KAG-3521](https://konghq.atlassian.net/browse/KAG-3521)
 [KAG-2025](https://konghq.atlassian.net/browse/KAG-2025)

- Introduced a yieldable JSON library `lua-resty-simdjson`,
which would improve the latency significantly.
 [#13421](https://github.com/Kong/kong/issues/13421)
 [KAG-3647](https://konghq.atlassian.net/browse/KAG-3647)
#### Default

- Bumped lua-protobuf 0.5.2
 [#12834](https://github.com/Kong/kong/issues/12834)


- Bumped LuaRocks from 3.11.0 to 3.11.1
 [#12662](https://github.com/Kong/kong/issues/12662)
 [KAG-3883](https://konghq.atlassian.net/browse/KAG-3883)

- Bumped `ngx_wasm_module` to `96b4e27e10c63b07ed40ea88a91c22f23981db35`
 [#12011](https://github.com/Kong/kong/issues/12011)


- Bumped `Wasmtime` version to `23.0.2`
 [#13567](https://github.com/Kong/kong/pull/13567)
 [KAG-5263](https://konghq.atlassian.net/browse/KAG-5263)


- Made the RPM package relocatable with the default prefix set to `/`.
 [#13468](https://github.com/Kong/kong/issues/13468)
 [KAG-4847](https://konghq.atlassian.net/browse/KAG-4847) [FTI-6054](https://konghq.atlassian.net/browse/FTI-6054) [KAG-4549](https://konghq.atlassian.net/browse/KAG-4549) [KAG-5122](https://konghq.atlassian.net/browse/KAG-5122)

### Features
#### Configuration

- Configure Wasmtime module cache when Wasm is enabled
 [#12930](https://github.com/Kong/kong/issues/12930)
 [KAG-4372](https://konghq.atlassian.net/browse/KAG-4372)
#### Core

- **prometheus**: Added `ai_requests_total`, `ai_cost_total` and `ai_tokens_total` metrics in the Prometheus plugin to start counting AI usage.
 [#13148](https://github.com/Kong/kong/issues/13148)

- Added a new configuration `concurrency_limit`(integer, default to 1) for Queue to specify the number of delivery timers.
Note that setting `concurrency_limit` to `-1` means no limit at all, and each HTTP log entry would create an individual timer for sending.
 [#13332](https://github.com/Kong/kong/issues/13332)
 [FTI-6022](https://konghq.atlassian.net/browse/FTI-6022)

- Append gateway info to upstream `Via` header like `1.1 kong/3.8.0`, and optionally to
response `Via` header if it is present in the `headers` config of "kong.conf", like `2 kong/3.8.0`,
according to `RFC7230` and `RFC9110`.
 [#12733](https://github.com/Kong/kong/issues/12733)
 [FTI-5807](https://konghq.atlassian.net/browse/FTI-5807)

- Starting from this version, a new DNS client library has been implemented and added into Kong, which is disabled by default. The new DNS client library has the following changes - Introduced global caching for DNS records across workers, significantly reducing the query load on DNS servers. - Introduced observable statistics for the new DNS client, and a new Status API `/status/dns` to retrieve them. - Simplified the logic and make it more standardized
 [#12305](https://github.com/Kong/kong/issues/12305)
 [KAG-3220](https://konghq.atlassian.net/browse/KAG-3220)
#### PDK

- Added `0` to support unlimited body size. When parameter `max_allowed_file_size` is `0`, `get_raw_body` will return the entire body, but the size of this body will still be limited by Nginx's `client_max_body_size`.
 [#13431](https://github.com/Kong/kong/issues/13431)
 [KAG-4698](https://konghq.atlassian.net/browse/KAG-4698)

- Extend kong.request.get_body and kong.request.get_raw_body to read from buffered file
 [#13158](https://github.com/Kong/kong/issues/13158)

- Added a new PDK module `kong.telemetry` and function: `kong.telemetry.log`
to generate log entries to be reported via the OpenTelemetry plugin.
 [#13329](https://github.com/Kong/kong/issues/13329)
 [KAG-4848](https://konghq.atlassian.net/browse/KAG-4848)
#### Plugin

- **acl:** Added a new config `always_use_authenticated_groups` to support using authenticated groups even when an authenticated consumer already exists.
 [#13184](https://github.com/Kong/kong/issues/13184)
 [FTI-5945](https://konghq.atlassian.net/browse/FTI-5945)

- AI plugins: retrieved latency data and pushed it to logs and metrics.
 [#13428](https://github.com/Kong/kong/issues/13428)

- Allow AI plugin to read request from buffered file
 [#13158](https://github.com/Kong/kong/pull/13158)

- **AI-proxy-plugin**: Add `allow_override` option to allow overriding the upstream model auth parameter or header from the caller's request.
 [#13158](https://github.com/Kong/kong/issues/13158)


- **AI-proxy-plugin**: Replace the lib and use cycle_aware_deep_copy for the `request_table` object.
 [#13582](https://github.com/Kong/kong/issues/13582)


- Kong AI Gateway (AI Proxy and associated plugin family) now supports 
all AWS Bedrock "Converse API" models.
 [#12948](https://github.com/Kong/kong/issues/12948)


- Kong AI Gateway (AI Proxy and associated plugin family) now supports 
the Google Gemini "chat" (generateContent) interface.
 [#12948](https://github.com/Kong/kong/issues/12948)


- **ai-proxy**: Allowed mistral provider to use mistral.ai managed service by omitting upstream_url
 [#13481](https://github.com/Kong/kong/issues/13481)

- **ai-proxy**: Added a new response header X-Kong-LLM-Model that displays the name of the language model used in the AI-Proxy plugin.
 [#13472](https://github.com/Kong/kong/issues/13472)

- **AI-Prompt-Guard**: add `match_all_roles` option to allow match all roles in addition to `user`.
 [#13183](https://github.com/Kong/kong/issues/13183)

- "**AWS-Lambda**: Added support for a configurable STS endpoint with the new configuration field `aws_sts_endpoint_url`.
 [#13388](https://github.com/Kong/kong/issues/13388)
 [KAG-4599](https://konghq.atlassian.net/browse/KAG-4599)

- **AWS-Lambda**: A new configuration field `empty_arrays_mode` is now added to control whether Kong should send `[]` empty arrays (returned by Lambda function) as `[]` empty arrays or `{}` empty objects in JSON responses.`
 [#13084](https://github.com/Kong/kong/issues/13084)
 [FTI-5937](https://konghq.atlassian.net/browse/FTI-5937)
 [KAG-4622](https://konghq.atlassian.net/browse/KAG-4622)
 [KAG-4615](https://konghq.atlassian.net/browse/KAG-4615)

- Added support for json_body rename in response-transformer plugin
 [#13131](https://github.com/Kong/kong/issues/13131)
 [KAG-4664](https://konghq.atlassian.net/browse/KAG-4664)

- **OpenTelemetry:** Added support for OpenTelemetry formatted logs.
 [#13291](https://github.com/Kong/kong/issues/13291)
 [KAG-4712](https://konghq.atlassian.net/browse/KAG-4712)

- **standard-webhooks**: Added standard webhooks plugin.
 [#12757](https://github.com/Kong/kong/issues/12757)

- **Request-Transformer**: Fixed an issue where renamed query parameters, url-encoded body parameters, and json body parameters were not handled properly when target name is the same as the source name in the request.
 [#13358](https://github.com/Kong/kong/issues/13358)
 [KAG-4915](https://konghq.atlassian.net/browse/KAG-4915)
#### Admin API

- Added support for brackets syntax for map fields configuration via the Admin API
 [#13313](https://github.com/Kong/kong/issues/13313)
 [KAG-4827](https://konghq.atlassian.net/browse/KAG-4827)

### Fixes
#### CLI Command

- Fixed an issue where some debug level error logs were not being displayed by the CLI.
 [#13143](https://github.com/Kong/kong/issues/13143)
 [FTI-5995](https://konghq.atlassian.net/browse/FTI-5995)
#### Configuration

- Re-enabled the Lua DNS resolver from proxy-wasm by default.
 [#13424](https://github.com/Kong/kong/issues/13424)
 [KAG-4671](https://konghq.atlassian.net/browse/KAG-4671)
#### Core

- Fixed an issue where luarocks-admin was not available in /usr/local/bin.
 [#13372](https://github.com/Kong/kong/issues/13372)
 [KAG-911](https://konghq.atlassian.net/browse/KAG-911)

- Fixed an issue where 'read' was not always passed to Postgres read-only database operations.
 [#13530](https://github.com/Kong/kong/issues/13530)
 [KAG-5196](https://konghq.atlassian.net/browse/KAG-5196)

- Deprecated shorthand fields don't take precedence over replacement fields when both are specified.
 [#13486](https://github.com/Kong/kong/issues/13486)
 [KAG-5134](https://konghq.atlassian.net/browse/KAG-5134)

- Fixed an issue where `lua-nginx-module` context was cleared when `ngx.send_header()` triggered `filter_finalize` [openresty/lua-nginx-module#2323](https://github.com/openresty/lua-nginx-module/pull/2323).
 [#13316](https://github.com/Kong/kong/issues/13316)
 [FTI-6005](https://konghq.atlassian.net/browse/FTI-6005)

- Changed the way deprecated shorthand fields are used with new fields.
If the new field contains null it allows for deprecated field to overwrite it if both are present in the request.
 [#13592](https://github.com/Kong/kong/issues/13592)
 [KAG-5287](https://konghq.atlassian.net/browse/KAG-5287)

- Fixed an issue where unnecessary uninitialized variable error log is reported when 400 bad requests were received.
 [#13201](https://github.com/Kong/kong/issues/13201)
 [FTI-6025](https://konghq.atlassian.net/browse/FTI-6025)

- Fixed an issue where the URI captures are unavailable when the first capture group is absent.
 [#13024](https://github.com/Kong/kong/issues/13024)
 [KAG-4474](https://konghq.atlassian.net/browse/KAG-4474)

- Fixed an issue where the priority field can be set in a traditional mode route
When 'router_flavor' is configured as 'expressions'.
 [#13142](https://github.com/Kong/kong/issues/13142)
 [KAG-4411](https://konghq.atlassian.net/browse/KAG-4411)

- Fixed an issue where setting `tls_verify` to `false` didn't override the global level `proxy_ssl_verify`.
 [#13470](https://github.com/Kong/kong/issues/13470)
 [FTI-6095](https://konghq.atlassian.net/browse/FTI-6095)

- Fixed an issue where the sni cache isn't invalidated when a sni is updated.
 [#13165](https://github.com/Kong/kong/issues/13165)
 [FTI-6009](https://konghq.atlassian.net/browse/FTI-6009)

- The kong.logrotate configuration file will no longer be overwritten during upgrade.
When upgrading, set the environment variable `DEBIAN_FRONTEND=noninteractive` on Debian/Ubuntu to avoid any interactive prompts and enable fully automatic upgrades.
 [#13348](https://github.com/Kong/kong/issues/13348)
 [FTI-6079](https://konghq.atlassian.net/browse/FTI-6079)

- Fixed an issue where the Vault secret cache got refreshed during `resurrect_ttl` time and could not be fetched by other workers.
 [#13561](https://github.com/Kong/kong/issues/13561)
 [FTI-6137](https://konghq.atlassian.net/browse/FTI-6137)

- Error logs during Vault secret rotation are now logged at the `notice` level instead of `warn`.
 [#13540](https://github.com/Kong/kong/issues/13540)
 [FTI-5775](https://konghq.atlassian.net/browse/FTI-5775)

- Fix a bug that the `host_header` attribute of upstream entity can not be set correctly in requests to upstream as Host header when retries to upstream happen.
 [#13135](https://github.com/Kong/kong/issues/13135)
 [FTI-5987](https://konghq.atlassian.net/browse/FTI-5987)

- Moved internal Unix sockets to a subdirectory (`sockets`) of the Kong prefix.
 [#13409](https://github.com/Kong/kong/issues/13409)
 [KAG-4947](https://konghq.atlassian.net/browse/KAG-4947)

- Changed the behaviour of shorthand fields that are used to describe deprecated fields. If
both fields are sent in the request and their values mismatch - the request will be rejected.
 [#13594](https://github.com/Kong/kong/issues/13594)
 [KAG-5262](https://konghq.atlassian.net/browse/KAG-5262)

- Reverted DNS client to original behaviour of ignoring ADDITIONAL SECTION in DNS responses.
 [#13278](https://github.com/Kong/kong/issues/13278)
 [FTI-6039](https://konghq.atlassian.net/browse/FTI-6039)

- Shortened names of internal Unix sockets to avoid exceeding the socket name limit.
 [#13571](https://github.com/Kong/kong/issues/13571)
 [KAG-5136](https://konghq.atlassian.net/browse/KAG-5136)
#### PDK

- **PDK**: Fixed a bug that log serializer will log `upstream_status` as nil in the requests that contains subrequest
 [#12953](https://github.com/Kong/kong/issues/12953)
 [FTI-5844](https://konghq.atlassian.net/browse/FTI-5844)

- **Vault**: Reference ending with slash when parsed should not return a key.
 [#13538](https://github.com/Kong/kong/issues/13538)
 [KAG-5181](https://konghq.atlassian.net/browse/KAG-5181)

- Fixed an issue that pdk.log.serialize() will throw an error when JSON entity set by serialize_value contains json.null
 [#13376](https://github.com/Kong/kong/issues/13376)
 [FTI-6096](https://konghq.atlassian.net/browse/FTI-6096)
#### Plugin

- **AI-proxy-plugin**: Fixed a bug where certain Azure models would return partial tokens/words 
when in response-streaming mode.
 [#13000](https://github.com/Kong/kong/issues/13000)
 [KAG-4596](https://konghq.atlassian.net/browse/KAG-4596)

- **AI-Transformer-Plugins**: Fixed a bug where cloud identity authentication 
was not used in `ai-request-transformer` and `ai-response-transformer` plugins.
 [#13487](https://github.com/Kong/kong/issues/13487)


- **AI-proxy-plugin**: Fixed a bug where Cohere and Anthropic providers don't read the `model` parameter properly 
from the caller's request body.
 [#13000](https://github.com/Kong/kong/issues/13000)
 [KAG-4596](https://konghq.atlassian.net/browse/KAG-4596)

- **AI-proxy-plugin**: Fixed a bug where using "OpenAI Function" inference requests would log a 
request error, and then hang until timeout.
 [#13000](https://github.com/Kong/kong/issues/13000)
 [KAG-4596](https://konghq.atlassian.net/browse/KAG-4596)

- **AI-proxy-plugin**: Fixed a bug where AI Proxy would still allow callers to specify their own model,  
ignoring the plugin-configured model name.
 [#13000](https://github.com/Kong/kong/issues/13000)
 [KAG-4596](https://konghq.atlassian.net/browse/KAG-4596)

- **AI-proxy-plugin**: Fixed a bug where AI Proxy would not take precedence of the 
plugin's configured model tuning options, over those in the user's LLM request.
 [#13000](https://github.com/Kong/kong/issues/13000)
 [KAG-4596](https://konghq.atlassian.net/browse/KAG-4596)

- **AI-proxy-plugin**: Fixed a bug where setting OpenAI SDK model parameter "null" caused analytics 
to not be written to the logging plugin(s).
 [#13000](https://github.com/Kong/kong/issues/13000)
 [KAG-4596](https://konghq.atlassian.net/browse/KAG-4596)

- **ACME**: Fixed an issue of DP reporting that deprecated config fields are used when configuration from CP is pushed
 [#13069](https://github.com/Kong/kong/issues/13069)
 [KAG-4515](https://konghq.atlassian.net/browse/KAG-4515)

- **ACME**: Fixed an issue where username and password were not accepted as valid authentication methods.
 [#13496](https://github.com/Kong/kong/issues/13496)
 [FTI-6143](https://konghq.atlassian.net/browse/FTI-6143)

- **AI-Proxy**: Fixed issue when response is gzipped even if client doesn't accept.
 [#13155](https://github.com/Kong/kong/issues/13155)

- **Prometheus**: Fixed an issue where CP/DP compatibility check was missing for the new configuration field `ai_metrics`.
 [#13417](https://github.com/Kong/kong/issues/13417)
 [KAG-4934](https://konghq.atlassian.net/browse/KAG-4934)

- Fixed certain AI plugins cannot be applied per consumer or per service.
 [#13209](https://github.com/Kong/kong/issues/13209)

- **AI-Prompt-Guard**: Fixed an issue when `allow_all_conversation_history` is set to false, the first user request is selected instead of the last one.
 [#13183](https://github.com/Kong/kong/issues/13183)

- **AI-Proxy**: Resolved a bug where the object constructor would set data on the class instead of the instance
 [#13028](https://github.com/Kong/kong/issues/13028)

- **AWS-Lambda**: Fixed an issue that the plugin does not work with multiValueHeaders defined in proxy integration and legacy empty_arrays_mode.
 [#12971](https://github.com/Kong/kong/issues/12971)

- **AWS-Lambda**: Fixed an issue that the `version` field is not set in the request payload when `awsgateway_compatible` is enabled.
 [#13018](https://github.com/Kong/kong/issues/13018)
 [FTI-5949](https://konghq.atlassian.net/browse/FTI-5949)

- **correlation-id**: Fixed an issue where the plugin would not work if we explicitly set the `generator` to `null`.
 [#13439](https://github.com/Kong/kong/issues/13439)
 [FTI-6134](https://konghq.atlassian.net/browse/FTI-6134)

- **CORS**: Fixed an issue where the `Access-Control-Allow-Origin` header was not sent when `conf.origins` has multiple entries but includes `*`.
 [#13334](https://github.com/Kong/kong/issues/13334)
 [FTI-6062](https://konghq.atlassian.net/browse/FTI-6062)

- **grpc-gateway**: When there is a JSON decoding error, respond with status 400 and error information in the body instead of status 500.
 [#12971](https://github.com/Kong/kong/issues/12971)


- **HTTP-Log**: Fix an issue where the plugin doesn't include port information in the HTTP host header when sending requests to the log server.
 [#13116](https://github.com/Kong/kong/issues/13116)

- **AI Plugins**: Fixed an issue for multi-modal inputs are not properly validated and calculated.
 [#13445](https://github.com/Kong/kong/issues/13445)

- **OpenTelemetry:** Fixed an issue where migration fails when upgrading from below version 3.3 to 3.7.
 [#13391](https://github.com/Kong/kong/issues/13391)
 [FTI-6109](https://konghq.atlassian.net/browse/FTI-6109)

- **OpenTelemetry / Zipkin**: remove redundant deprecation warnings
 [#13220](https://github.com/Kong/kong/issues/13220)
 [KAG-4744](https://konghq.atlassian.net/browse/KAG-4744)

- **Basic-Auth**: Fix an issue of realm field not recognized for older kong versions (before 3.6)
 [#13042](https://github.com/Kong/kong/issues/13042)
 [KAG-4516](https://konghq.atlassian.net/browse/KAG-4516)

- **Key-Auth**: Fix an issue of realm field not recognized for older kong versions (before 3.7)
 [#13042](https://github.com/Kong/kong/issues/13042)
 [KAG-4516](https://konghq.atlassian.net/browse/KAG-4516)

- **Request Size Limiting**: Fixed an issue where the body size doesn't get checked when the request body is buffered to a temporary file.
 [#13303](https://github.com/Kong/kong/issues/13303)
 [FTI-6034](https://konghq.atlassian.net/browse/FTI-6034)

- **Response-RateLimiting**: Fixed an issue of DP reporting that deprecated config fields are used when configuration from CP is pushed
 [#13069](https://github.com/Kong/kong/issues/13069)
 [KAG-4515](https://konghq.atlassian.net/browse/KAG-4515)

- **Rate-Limiting**: Fixed an issue of DP reporting that deprecated config fields are used when configuration from CP is pushed
 [#13069](https://github.com/Kong/kong/issues/13069)
 [KAG-4515](https://konghq.atlassian.net/browse/KAG-4515)

- **OpenTelemetry:** Improved accuracy of sampling decisions.
 [#13275](https://github.com/Kong/kong/issues/13275)
 [KAG-4785](https://konghq.atlassian.net/browse/KAG-4785)

- **hmac-auth**: Add WWW-Authenticate headers to 401 responses.
 [#11791](https://github.com/Kong/kong/issues/11791)
 [KAG-321](https://konghq.atlassian.net/browse/KAG-321)

- **Prometheus**: Improved error logging when having inconsistent labels count.
 [#13020](https://github.com/Kong/kong/issues/13020)


- **jwt**: Add WWW-Authenticate headers to 401 responses.
 [#11792](https://github.com/Kong/kong/issues/11792)
 [KAG-321](https://konghq.atlassian.net/browse/KAG-321)

- **ldap-auth**: Add WWW-Authenticate headers to all 401 responses.
 [#11820](https://github.com/Kong/kong/issues/11820)
 [KAG-321](https://konghq.atlassian.net/browse/KAG-321)

- **OAuth2**: Add WWW-Authenticate headers to all 401 responses and realm option.
 [#11833](https://github.com/Kong/kong/issues/11833)
 [KAG-321](https://konghq.atlassian.net/browse/KAG-321)

- **proxy-cache**: Fixed an issue where the Age header was not being updated correctly when serving cached responses.
 [#13387](https://github.com/Kong/kong/issues/13387)


- Fixed an bug that AI semantic cache can't use request provided models
 [#13633](https://github.com/Kong/kong/issues/13633)

#### Admin API

- Fixed an issue where validation of the certificate schema failed if the `snis` field was present in the request body.
 [#13357](https://github.com/Kong/kong/issues/13357)

#### Clustering

- Fixed an issue where hybrid mode not working if the forward proxy password contains special character(#). Note that the `proxy_server` configuration parameter still needs to be url-encoded.
 [#13457](https://github.com/Kong/kong/issues/13457)
 [FTI-6145](https://konghq.atlassian.net/browse/FTI-6145)
#### Default

- **AI-proxy**: A configuration validation is added to prevent from enabling `log_statistics` upon
providers not supporting statistics. Accordingly, the default of `log_statistics` is changed from
`true` to `false`, and a database migration is added as well for disabling `log_statistics` if it
has already been enabled upon unsupported providers.
 [#12860](https://github.com/Kong/kong/issues/12860)

## Kong-Manager






### Features
#### Default

- Improved accessibility in Kong Manager.
 [#13522](https://github.com/Kong/kong-manager/issues/13522)


- Enhanced entity lists so that you can resize or hide list columns.
 [#13522](https://github.com/Kong/kong-manager/issues/13522)


- Added an SNIs field to the certificate form.
 [#264](https://github.com/Kong/kong-manager/issues/264)


### Fixes
#### Default

- Improved the user experience in Kong Manager by fixing various UI-related issues.
 [#232](https://github.com/Kong/kong-manager/issues/232) [#233](https://github.com/Kong/kong-manager/issues/233) [#234](https://github.com/Kong/kong-manager/issues/234) [#237](https://github.com/Kong/kong-manager/issues/237) [#238](https://github.com/Kong/kong-manager/issues/238) [#240](https://github.com/Kong/kong-manager/issues/240) [#244](https://github.com/Kong/kong-manager/issues/244) [#250](https://github.com/Kong/kong-manager/issues/250) [#252](https://github.com/Kong/kong-manager/issues/252) [#255](https://github.com/Kong/kong-manager/issues/255) [#257](https://github.com/Kong/kong-manager/issues/257) [#263](https://github.com/Kong/kong-manager/issues/263) [#264](https://github.com/Kong/kong-manager/issues/264) [#267](https://github.com/Kong/kong-manager/issues/267) [#272](https://github.com/Kong/kong-manager/issues/272)

