## Kong


### Performance
#### Performance

- Improved proxy performance by refactoring internal hooking mechanism.
 [#12784](https://github.com/Kong/kong/issues/12784)
 [KAG-3653](https://konghq.atlassian.net/browse/KAG-3653)

- Sped up the router matching when the `router_flavor` is `traditional_compatible` or `expressions`.
 [#12467](https://github.com/Kong/kong/issues/12467)
 [KAG-3653](https://konghq.atlassian.net/browse/KAG-3653)
#### Plugin

- **Opentelemetry**: Increased queue max batch size to 200.
 [#12488](https://github.com/Kong/kong/issues/12488)
 [KAG-3173](https://konghq.atlassian.net/browse/KAG-3173)

### Breaking Changes
#### Plugin

- **AI Proxy**: To support the new messages API of `Anthropic`, the upstream path of the `Anthropic` for `llm/v1/chat` route type has changed from `/v1/complete` to `/v1/messages`.
 [#12699](https://github.com/Kong/kong/issues/12699)
 [FTI-5770](https://konghq.atlassian.net/browse/FTI-5770)


### Dependencies
#### Core

- Bumped atc-router from v1.6.0 to v1.6.2
 [#12231](https://github.com/Kong/kong/issues/12231)
 [KAG-3403](https://konghq.atlassian.net/browse/KAG-3403)

- Bumped libexpat to 2.6.2
 [#12910](https://github.com/Kong/kong/issues/12910)
 [CVE-2023](https://konghq.atlassian.net/browse/CVE-2023) [CVE-2013](https://konghq.atlassian.net/browse/CVE-2013) [CVE-2024](https://konghq.atlassian.net/browse/CVE-2024) [KAG-4331](https://konghq.atlassian.net/browse/KAG-4331)

- Bumped lua-kong-nginx-module from 0.8.0 to 0.11.0
 [#12752](https://github.com/Kong/kong/issues/12752)
 [KAG-4050](https://konghq.atlassian.net/browse/KAG-4050)

- Bumped lua-protobuf to 0.5.1
 [#12834](https://github.com/Kong/kong/issues/12834)


- Bumped lua-resty-acme to 0.13.0
 [#12909](https://github.com/Kong/kong/issues/12909)
 [KAG-4330](https://konghq.atlassian.net/browse/KAG-4330)

- Bumped lua-resty-aws from 1.3.6 to 1.4.1
 [#12846](https://github.com/Kong/kong/issues/12846)
 [KAG-3424](https://konghq.atlassian.net/browse/KAG-3424) [FTI-5732](https://konghq.atlassian.net/browse/FTI-5732)

- Bumped lua-resty-lmdb from 1.4.1 to 1.4.2
 [#12786](https://github.com/Kong/kong/issues/12786)


- Bumped lua-resty-openssl from 1.2.0 to 1.3.1
 [#12665](https://github.com/Kong/kong/issues/12665)


- Bumped lua-resty-timer-ng to 0.2.7
 [#12756](https://github.com/Kong/kong/issues/12756)
 [KAG-3653](https://konghq.atlassian.net/browse/KAG-3653)

- Bumped PCRE from the legacy libpcre 8.45 to libpcre2 10.43
 [#12366](https://github.com/Kong/kong/issues/12366)
 [KAG-3571](https://konghq.atlassian.net/browse/KAG-3571) [KAG-3521](https://konghq.atlassian.net/browse/KAG-3521) [KAG-2025](https://konghq.atlassian.net/browse/KAG-2025)

- Bumped penlight to 1.14.0
 [#12862](https://github.com/Kong/kong/issues/12862)

#### Default

- Added package `tzdata` to DEB Docker image for convenient timezone setting.
 [#12609](https://github.com/Kong/kong/issues/12609)
 [FTI-5698](https://konghq.atlassian.net/browse/FTI-5698)

- Bumped lua-resty-http to 0.17.2.
 [#12908](https://github.com/Kong/kong/issues/12908)


- Bumped LuaRocks from 3.9.2 to 3.11.0
 [#12662](https://github.com/Kong/kong/issues/12662)
 [KAG-3883](https://konghq.atlassian.net/browse/KAG-3883)

- Bumped `ngx_wasm_module` to `91d447ffd0e9bb08f11cc69d1aa9128ec36b4526`
 [#12011](https://github.com/Kong/kong/issues/12011)


- Bumped `V8` version to `12.0.267.17`
 [#12704](https://github.com/Kong/kong/issues/12704)


- Bumped `Wasmtime` version to `19.0.0`
 [#12011](https://github.com/Kong/kong/issues/12011)


- Improved the robustness of lua-cjson when handling unexpected input.
 [#12904](https://github.com/Kong/kong/issues/12904)
 [KAG-4275](https://konghq.atlassian.net/browse/KAG-4275)

### Features
#### Configuration

- TLSv1.1 and lower versions are disabled by default in OpenSSL 3.x.
 [#12420](https://github.com/Kong/kong/issues/12420)
 [KAG-3259](https://konghq.atlassian.net/browse/KAG-3259)

- Introduced `nginx_wasm_main_shm_kv` configuration parameter, which enables
Wasm filters to use the Proxy-Wasm operations `get_shared_data` and
`set_shared_data` without namespaced keys.
 [#12663](https://github.com/Kong/kong/issues/12663)


- **Schema**: Added a deprecation field attribute to identify deprecated fields
 [#12686](https://github.com/Kong/kong/issues/12686)
 [KAG-3915](https://konghq.atlassian.net/browse/KAG-3915)

- Added the `wasm_filters` configuration parameter for enabling individual filters
 [#12843](https://github.com/Kong/kong/issues/12843)
 [KAG-4211](https://konghq.atlassian.net/browse/KAG-4211)
#### Core

- Added `events:ai:response_tokens`, `events:ai:prompt_tokens` and `events:ai:requests` to the anonymous report to start counting AI usage
 [#12924](https://github.com/Kong/kong/issues/12924)


- Improved config handling when the CP runs with the router set to the `expressions` flavor:
  - If mixed config is detected and a lower DP is attached to the CP, no config will be sent at all
  - If the expression is invalid on the CP, no config will be sent at all
  - If the expression is invalid on a lower DP, it will be sent to the DP and DP validation will catch this and communicate back to the CP (this could result in partial config application)
 [#12967](https://github.com/Kong/kong/issues/12967)
 [KAG-3806](https://konghq.atlassian.net/browse/KAG-3806)

- The route entity now supports the following fields when the
`router_flavor` is `expressions`: `methods`, `hosts`, `paths`, `headers`,
`snis`, `sources`, `destinations`, and `regex_priority`.
The meaning of these fields are consistent with the traditional route entity.
 [#12667](https://github.com/Kong/kong/issues/12667)
 [KAG-3805](https://konghq.atlassian.net/browse/KAG-3805) [KAG-3807](https://konghq.atlassian.net/browse/KAG-3807)
#### PDK

- Added the `latencies.receive` property to the log serializer
 [#12730](https://github.com/Kong/kong/issues/12730)
 [KAG-3798](https://konghq.atlassian.net/browse/KAG-3798)
#### Plugin

- AI Proxy now reads most prompt tuning parameters from the client,
while the plugin config parameters under `model_options` are now just defaults.
This fixes support for using the respective provider's native SDK.
 [#12903](https://github.com/Kong/kong/issues/12903)
 [KAG-4126](https://konghq.atlassian.net/browse/KAG-4126)

- AI Proxy now has a `preserve` option for `route_type`, where the requests and responses
are passed directly to the upstream LLM. This is to enable compatibility with any
and all models and SDKs that may be used when calling the AI services.
 [#12903](https://github.com/Kong/kong/issues/12903)
 [KAG-4126](https://konghq.atlassian.net/browse/KAG-4126)

- **Prometheus**: Added workspace label to Prometheus plugin metrics.
 [#12836](https://github.com/Kong/kong/issues/12836)
 [FTI-5573](https://konghq.atlassian.net/browse/FTI-5573)

- **AI Proxy**: Added support for streaming event-by-event responses back to the client on supported providers.
 [#12792](https://github.com/Kong/kong/issues/12792)
 [KAG-4124](https://konghq.atlassian.net/browse/KAG-4124)

- **AI Prompt Guard**: Increased the maximum length of regex expressions to 500 for the allow and deny parameters.
 [#12731](https://github.com/Kong/kong/issues/12731)
 [FTI-5767](https://konghq.atlassian.net/browse/FTI-5767)

- Addded support for EdDSA algorithms in JWT plugin
 [#12726](https://github.com/Kong/kong/issues/12726)


- Added support for ES512, PS256, PS384, PS512 algorithms in JWT plugin
 [#12638](https://github.com/Kong/kong/issues/12638)
 [KAG-3821](https://konghq.atlassian.net/browse/KAG-3821)

- **OpenTelemetry, Zipkin**: The propagation module has been reworked. The new
options allow better control over the configuration of tracing headers propagation.
 [#12670](https://github.com/Kong/kong/issues/12670)
 [KAG-1886](https://konghq.atlassian.net/browse/KAG-1886) [KAG-1887](https://konghq.atlassian.net/browse/KAG-1887)
#### Default

- Added support for debugging with EmmyLuaDebugger.  This feature is a
tech preview and not officially supported by Kong Inc. for now.
 [#12899](https://github.com/Kong/kong/issues/12899)
 [KAG-4316](https://konghq.atlassian.net/browse/KAG-4316)

### Fixes
#### CLI Command

- Fixed an issue where the `pg_timeout` was overridden to `60s` even if `--db-timeout`
was not explicitly passed in CLI arguments.
 [#12981](https://github.com/Kong/kong/issues/12981)
 [KAG-4416](https://konghq.atlassian.net/browse/KAG-4416)
#### Configuration

- Fixed the default value in kong.conf.default documentation from 1000 to 10000
for the `upstream_keepalive_max_requests` option.
 [#12643](https://github.com/Kong/kong/issues/12643)
 [KAG-3360](https://konghq.atlassian.net/browse/KAG-3360)

- Fixed an issue where an external plugin (Go, Javascript, or Python) would fail to
apply a change to the plugin config via the Admin API.
 [#12718](https://github.com/Kong/kong/issues/12718)
 [KAG-3949](https://konghq.atlassian.net/browse/KAG-3949)

- Disabled usage of the Lua DNS resolver from proxy-wasm by default.
 [#12825](https://github.com/Kong/kong/issues/12825)
 [KAG-4277](https://konghq.atlassian.net/browse/KAG-4277)

- Set security level of gRPC's TLS to 0 when `ssl_cipher_suite` is set to `old`.
 [#12613](https://github.com/Kong/kong/issues/12613)
 [KAG-3259](https://konghq.atlassian.net/browse/KAG-3259)
#### Core

- Fixed an issue where `POST /config?flatten_errors=1` could not return a proper response if the input included duplicate upstream targets.
 [#12797](https://github.com/Kong/kong/issues/12797)
 [KAG-4144](https://konghq.atlassian.net/browse/KAG-4144)

- **DNS Client**: Ignore a non-positive values on resolv.conf for options timeout, and use a default value of 2 seconds instead.
 [#12640](https://github.com/Kong/kong/issues/12640)
 [FTI-5791](https://konghq.atlassian.net/browse/FTI-5791)

- Updated the file permission of `kong.logrotate` to 644.
 [#12629](https://github.com/Kong/kong/issues/12629)
 [FTI-5756](https://konghq.atlassian.net/browse/FTI-5756)

- Fixed a problem on hybrid mode DPs, where a certificate entity configured with a vault reference may not get refreshed on time.
 [#12868](https://github.com/Kong/kong/issues/12868)
 [FTI-5881](https://konghq.atlassian.net/browse/FTI-5881)

- Fixed the missing router section for the output of the request-debugging.
 [#12234](https://github.com/Kong/kong/issues/12234)
 [KAG-3438](https://konghq.atlassian.net/browse/KAG-3438)

- Fixed an issue in the internal caching logic where mutexes could get never unlocked.
 [#12743](https://github.com/Kong/kong/issues/12743)


- Fixed an issue where the router didn't work correctly
when the route's configuration changed.
 [#12654](https://github.com/Kong/kong/issues/12654)
 [KAG-3857](https://konghq.atlassian.net/browse/KAG-3857)

- Fixed an issue where SNI-based routing didn't work
using `tls_passthrough` and the `traditional_compatible` router flavor.
 [#12681](https://github.com/Kong/kong/issues/12681)
 [KAG-3922](https://konghq.atlassian.net/browse/KAG-3922) [FTI-5781](https://konghq.atlassian.net/browse/FTI-5781)

- Fixed a bug that `X-Kong-Upstream-Status` didn't appear in the response headers even if it was set in the `headers` parameter in the `kong.conf` file when the response was hit and returned by the Proxy Cache plugin.
 [#12744](https://github.com/Kong/kong/issues/12744)
 [FTI-5827](https://konghq.atlassian.net/browse/FTI-5827)

- Fixed vault initialization by postponing vault reference resolving on init_worker
 [#12554](https://github.com/Kong/kong/issues/12554)
 [KAG-2907](https://konghq.atlassian.net/browse/KAG-2907)

- Fixed a bug that allowed vault secrets to refresh even when they had no TTL set.
 [#12877](https://github.com/Kong/kong/issues/12877)
 [FTI-5906](https://konghq.atlassian.net/browse/FTI-5906) [FTI-5916](https://konghq.atlassian.net/browse/FTI-5916)

- **Vault**: do not use incorrect (default) workspace identifier when retrieving vault entity by prefix
 [#12572](https://github.com/Kong/kong/issues/12572)
 [FTI-5762](https://konghq.atlassian.net/browse/FTI-5762)

- **Core**: Fixed unexpected table nil panic in the balancer's stop_healthchecks function
 [#12865](https://github.com/Kong/kong/issues/12865)


- Use `-1` as the worker ID of privileged agent to avoid access issues.
 [#12385](https://github.com/Kong/kong/issues/12385)
 [FTI-5707](https://konghq.atlassian.net/browse/FTI-5707)

- **Plugin Server**: Fixed an issue where Kong failed to properly restart MessagePack-based pluginservers (used in Python and Javascript plugins, for example).
 [#12582](https://github.com/Kong/kong/issues/12582)
 [KAG-3765](https://konghq.atlassian.net/browse/KAG-3765)

- Reverted the hard-coded limitation of the `ngx.read_body()` API in OpenResty upstreams' new versions when downstream connections are in HTTP/2 or HTTP/3 stream modes.
 [#12658](https://github.com/Kong/kong/issues/12658)
 [FTI-5766](https://konghq.atlassian.net/browse/FTI-5766) [FTI-5795](https://konghq.atlassian.net/browse/FTI-5795)

- Each Kong cache instance now utilizes its own cluster event channel. This approach isolates cache invalidation events and reducing the generation of unnecessary worker events.
 [#12321](https://github.com/Kong/kong/issues/12321)
 [FTI-5559](https://konghq.atlassian.net/browse/FTI-5559)

- Updated telemetry collection for AI Plugins to allow multiple plugins data to be set for the same request.
 [#12583](https://github.com/Kong/kong/issues/12583)
 [KAG-3759](https://konghq.atlassian.net/browse/KAG-3759) [KAG-4124](https://konghq.atlassian.net/browse/KAG-4124)
#### PDK

- **PDK:** Fixed `kong.request.get_forwarded_port` to always return a number,
which was caused by an incorrectly stored string value in `ngx.ctx.host_port`.
 [#12806](https://github.com/Kong/kong/issues/12806)
 [KAG-4158](https://konghq.atlassian.net/browse/KAG-4158)

- The value of `latencies.kong` in the log serializer payload no longer includes
the response receive time, so it now has the same value as the
`X-Kong-Proxy-Latency` response header. Response receive time is recorded in
the new `latencies.receive` metric, so if desired, the old value can be
calculated as `latencies.kong + latencies.receive`. **Note:** this also
affects payloads from all logging plugins that use the log serializer:
`file-log`, `tcp-log`, `udp-log`,`http-log`, `syslog`, and `loggly`, e.g.
[descriptions of JSON objects for the HTTP Log Plugin's log format](https://docs.konghq.com/hub/kong-inc/http-log/log-format/#json-object-descriptions).
 [#12795](https://github.com/Kong/kong/issues/12795)
 [KAG-3798](https://konghq.atlassian.net/browse/KAG-3798)

- **Tracing**: enhanced robustness of trace ID parsing
 [#12848](https://github.com/Kong/kong/issues/12848)
 [KAG-4218](https://konghq.atlassian.net/browse/KAG-4218)
#### Plugin

- **AI-proxy-plugin**: Fixed the bug that the `route_type` `/llm/v1/chat` didn't include the analytics in the responses.
 [#12781](https://github.com/Kong/kong/issues/12781)
 [FTI-5769](https://konghq.atlassian.net/browse/FTI-5769)

- **ACME**: Fixed an issue where the certificate was not successfully renewed during ACME renewal.
 [#12773](https://github.com/Kong/kong/issues/12773)
 [KAG-4008](https://konghq.atlassian.net/browse/KAG-4008)

- **AWS-Lambda**: Fixed an issue where the latency attributed to AWS Lambda API requests was counted as part of the latency in Kong.
 [#12835](https://github.com/Kong/kong/issues/12835)
 [FTI-5261](https://konghq.atlassian.net/browse/FTI-5261)

- **Jwt**: Fixed an issue where the plugin would fail when using invalid public keys for ES384 and ES512 algorithms.
 [#12724](https://github.com/Kong/kong/issues/12724)


- Added WWW-Authenticate headers to all 401 responses in the Key Auth plugin.
 [#11794](https://github.com/Kong/kong/issues/11794)
 [KAG-321](https://konghq.atlassian.net/browse/KAG-321)

- **Opentelemetry**: Fixed an OTEL sampling mode Lua panic bug, which happened when the `http_response_header_for_traceid` option was enabled.
 [#12544](https://github.com/Kong/kong/issues/12544)
 [FTI-5742](https://konghq.atlassian.net/browse/FTI-5742)

- Improve error handling in AI plugins.
 [#12991](https://github.com/Kong/kong/issues/12991)
 [KAG-4311](https://konghq.atlassian.net/browse/KAG-4311)

- **ACME**: Fixed migration of redis configuration.
 [#12989](https://github.com/Kong/kong/issues/12989)
 [KAG-4419](https://konghq.atlassian.net/browse/KAG-4419)

- **Response-RateLimiting**: Fixed migration of redis configuration.
 [#12989](https://github.com/Kong/kong/issues/12989)
 [KAG-4419](https://konghq.atlassian.net/browse/KAG-4419)

- **Rate-Limiting**: Fixed migration of redis configuration.
 [#12989](https://github.com/Kong/kong/issues/12989)
 [KAG-4419](https://konghq.atlassian.net/browse/KAG-4419)
#### Admin API

- **Admin API**: fixed an issue where calling the endpoint `POST /schemas/vaults/validate` was conflicting with the endpoint `/schemas/vaults/:name` which only has GET implemented, hence resulting in a 405.
 [#12607](https://github.com/Kong/kong/issues/12607)
 [KAG-3699](https://konghq.atlassian.net/browse/KAG-3699)
#### Default

- Fixed a bug where, if the the ulimit setting (open files) was low, Kong would fail to start as the `lua-resty-timer-ng` exhausted the available `worker_connections`. Decreased the concurrency range of the `lua-resty-timer-ng` library from `[512, 2048]` to `[256, 1024]` to fix this bug.
 [#12606](https://github.com/Kong/kong/issues/12606)
 [KAG-3779](https://konghq.atlassian.net/browse/KAG-3779) [FTI-5780](https://konghq.atlassian.net/browse/FTI-5780)

- Fix an issue where external plugins using the protobuf-based protocol would fail to call the `kong.Service.SetUpstream` method with an error `bad argument #2 to 'encode' (table expected, got boolean)`.
 [#12727](https://github.com/Kong/kong/issues/12727)

## Kong-Manager






### Features
#### Default

- Kong Manager now supports creating and editing Expressions routes with an interactive in-browser editor with syntax highlighting and autocompletion features for Kong's Expressions language.
 [#217](https://github.com/Kong/kong-manager/issues/217)


- Kong Manager now groups the parameters to provide a better user experience while configuring plugins. Meanwhile, several issues with the plugin form page were fixed.
 [#195](https://github.com/Kong/kong-manager/issues/195) [#199](https://github.com/Kong/kong-manager/issues/199) [#201](https://github.com/Kong/kong-manager/issues/201) [#202](https://github.com/Kong/kong-manager/issues/202) [#207](https://github.com/Kong/kong-manager/issues/207) [#208](https://github.com/Kong/kong-manager/issues/208) [#209](https://github.com/Kong/kong-manager/issues/209) [#213](https://github.com/Kong/kong-manager/issues/213) [#216](https://github.com/Kong/kong-manager/issues/216)


### Fixes
#### Default

- Improved the user experience in Kong Manager by fixing various UI-related issues.
 [#185](https://github.com/Kong/kong-manager/issues/185) [#188](https://github.com/Kong/kong-manager/issues/188) [#190](https://github.com/Kong/kong-manager/issues/190) [#195](https://github.com/Kong/kong-manager/issues/195) [#199](https://github.com/Kong/kong-manager/issues/199) [#201](https://github.com/Kong/kong-manager/issues/201) [#202](https://github.com/Kong/kong-manager/issues/202) [#207](https://github.com/Kong/kong-manager/issues/207) [#208](https://github.com/Kong/kong-manager/issues/208) [#209](https://github.com/Kong/kong-manager/issues/209) [#213](https://github.com/Kong/kong-manager/issues/213) [#216](https://github.com/Kong/kong-manager/issues/216)

