## Kong


### Performance
#### Performance

- Bumped the concurrency range of the lua-resty-timer-ng library from [32, 256] to [512, 2048].
 [#12275](https://github.com/Kong/kong/issues/12275)
 [KAG-2932](https://konghq.atlassian.net/browse/KAG-2932) [KAG-3452](https://konghq.atlassian.net/browse/KAG-3452)

- Cooperatively yield when building statistics of routes to reduce the impact to proxy path latency.
 [#12013](https://github.com/Kong/kong/issues/12013)

#### Configuration

- Bump `dns_stale_ttl` default to 1 hour so stale DNS record can be used for longer time in case of resolver downtime.
 [#12087](https://github.com/Kong/kong/issues/12087)
 [KAG-3080](https://konghq.atlassian.net/browse/KAG-3080)

- Bumped default values of `nginx_http_keepalive_requests` and `upstream_keepalive_max_requests` to `10000`. These changes are optimized to work better in systems with high throughput. In a low-throughput setting, these new settings may have visible effects in loadbalancing - it can take more requests to start using all the upstreams than before.
 [#12223](https://github.com/Kong/kong/issues/12223)
 [KAG-3360](https://konghq.atlassian.net/browse/KAG-3360)
#### Core

- Reuse match context between requests to avoid frequent memory allocation/deallocation
 [#12258](https://github.com/Kong/kong/issues/12258)
 [KAG-3448](https://konghq.atlassian.net/browse/KAG-3448)
#### PDK

- Performance optimization to avoid unnecessary creations and garbage-collections of spans
 [#12080](https://github.com/Kong/kong/issues/12080)
 [KAG-3169](https://konghq.atlassian.net/browse/KAG-3169)

### Breaking Changes
#### Core

- **BREAKING:** To avoid ambiguity with other Wasm-related nginx.conf directives, the prefix for Wasm `shm_kv` nginx.conf directives was changed from `nginx_wasm_shm_` to `nginx_wasm_shm_kv_`
 [#11919](https://github.com/Kong/kong/issues/11919)
 [KAG-2355](https://konghq.atlassian.net/browse/KAG-2355)

- In OpenSSL 3.2, the default SSL/TLS security level has been changed from 1 to 2.
  Which means security level set to 112 bits of security. As a result
  RSA, DSA and DH keys shorter than 2048 bits and ECC keys shorter than
  224 bits are prohibited. In addition to the level 1 exclusions any cipher
  suite using RC4 is also prohibited. SSL version 3 is also not allowed.
  Compression is disabled.
  [#7714](https://github.com/Kong/kong/issues/7714)
  [KAG-3459](https://konghq.atlassian.net/browse/KAG-3459)

#### Plugin

- **azure-functions**: azure-functions plugin now eliminates upstream/request URI and only use `routeprefix` configuration field to construct request path when requesting Azure API
 [#11850](https://github.com/Kong/kong/issues/11850)
 [KAG-2841](https://konghq.atlassian.net/browse/KAG-2841)

### Deprecations
#### Plugin

- **ACME**: Standardize redis configuration across plugins. The redis configuration right now follows common schema that is shared across other plugins.
 [#12300](https://github.com/Kong/kong/issues/12300)
 [KAG-3388](https://konghq.atlassian.net/browse/KAG-3388)

- **Rate Limiting**: Standardize redis configuration across plugins. The redis configuration right now follows common schema that is shared across other plugins.
 [#12301](https://github.com/Kong/kong/issues/12301)
 [KAG-3388](https://konghq.atlassian.net/browse/KAG-3388)

- **Response-RateLimiting**: Standardize redis configuration across plugins. The redis configuration right now follows common schema that is shared across other plugins.
 [#12301](https://github.com/Kong/kong/issues/12301)
 [KAG-3388](https://konghq.atlassian.net/browse/KAG-3388)

### Dependencies
#### Core

- Bumped atc-router from 1.2.0 to 1.6.0
 [#12231](https://github.com/Kong/kong/issues/12231)
 [KAG-3403](https://konghq.atlassian.net/browse/KAG-3403)

- Bumped kong-lapis from 1.14.0.3 to 1.16.0.1
 [#12064](https://github.com/Kong/kong/issues/12064)


- Bumped LPEG from 1.0.2 to 1.1.0
 [#11955](https://github.com/Kong/kong/issues/11955)
 [UTF-8](https://konghq.atlassian.net/browse/UTF-8)

- Bumped lua-messagepack from 0.5.2 to 0.5.3
 [#11956](https://github.com/Kong/kong/issues/11956)


- Bumped lua-messagepack from 0.5.3 to 0.5.4
 [#12076](https://github.com/Kong/kong/issues/12076)


- Bumped lua-resty-aws from 1.3.5 to 1.3.6
 [#12439](https://github.com/Kong/kong/issues/12439)


- Bumped lua-resty-healthcheck from 3.0.0 to 3.0.1
 [#12237](https://github.com/Kong/kong/issues/12237)
 [FTI-5478](https://konghq.atlassian.net/browse/FTI-5478)

- Bumped lua-resty-lmdb from 1.3.0 to 1.4.1
 [#12026](https://github.com/Kong/kong/issues/12026)
 [KAG-3093](https://konghq.atlassian.net/browse/KAG-3093)

- Bumped lua-resty-timer-ng from 0.2.5 to 0.2.6
 [#12275](https://github.com/Kong/kong/issues/12275)
 [KAG-2932](https://konghq.atlassian.net/browse/KAG-2932) [KAG-3452](https://konghq.atlassian.net/browse/KAG-3452)

- Bumped OpenResty from 1.21.4.2 to 1.25.3.1
 [#12327](https://github.com/Kong/kong/issues/12327)
 [KAG-3515](https://konghq.atlassian.net/browse/KAG-3515) [KAG-3570](https://konghq.atlassian.net/browse/KAG-3570) [KAG-3571](https://konghq.atlassian.net/browse/KAG-3571) [JIT-2](https://konghq.atlassian.net/browse/JIT-2)

- Bumped OpenSSL from 3.1.4 to 3.2.1
 [#12264](https://github.com/Kong/kong/issues/12264)
 [KAG-3459](https://konghq.atlassian.net/browse/KAG-3459)

- Bump resty-openssl from 0.8.25 to 1.2.0
 [#12265](https://github.com/Kong/kong/issues/12265)


- Bumped ngx_brotli to master branch, and disabled it on rhel7 rhel9-arm64 and amazonlinux-2023-arm64 due to toolchain issues
 [#12444](https://github.com/Kong/kong/issues/12444)
 [FTI-5706](https://konghq.atlassian.net/browse/FTI-5706)

- Bumped lua-resty-healthcheck from 1.6.3 to 3.0.0
 [#11834](https://github.com/Kong/kong/issues/11834)
 [KAG-2704](https://konghq.atlassian.net/browse/KAG-2704)
#### Default

- Bump `ngx_wasm_module` to `a7087a37f0d423707366a694630f1e09f4c21728`
 [#12011](https://github.com/Kong/kong/issues/12011)


- Bump `Wasmtime` version to `14.0.3`
 [#12011](https://github.com/Kong/kong/issues/12011)


### Features
#### Configuration

- display a warning message when Kong Manager is enabled but the Admin API is not enabled
 [#12071](https://github.com/Kong/kong/issues/12071)
 [KAG-3158](https://konghq.atlassian.net/browse/KAG-3158)

- add DHE-RSA-CHACHA20-POLY1305 cipher to the intermediate configuration
 [#12133](https://github.com/Kong/kong/issues/12133)
 [KAG-3257](https://konghq.atlassian.net/browse/KAG-3257)

- The default value of `dns_no_sync` option has been changed to `off`
 [#11869](https://github.com/Kong/kong/issues/11869)
 [FTI-5348](https://konghq.atlassian.net/browse/FTI-5348)

- Allow to inject Nginx directives into Kong's proxy location block
 [#11623](https://github.com/Kong/kong/issues/11623)


- Validate LMDB cache by Kong's version (major + minor),
wiping the content if tag mismatch to avoid compatibility issues
during minor version upgrade.
 [#12026](https://github.com/Kong/kong/issues/12026)
 [KAG-3093](https://konghq.atlassian.net/browse/KAG-3093)
#### Core

- Adds telemetry collection for AI Proxy, AI Request Transformer, and AI Response Transformer, pertaining to model and provider usage.
 [#12495](https://github.com/Kong/kong/issues/12495)


- add ngx_brotli module to kong prebuild nginx
 [#12367](https://github.com/Kong/kong/issues/12367)
 [KAG-2477](https://konghq.atlassian.net/browse/KAG-2477)

- Allow primary key passed as a full entity to DAO functions.
 [#11695](https://github.com/Kong/kong/issues/11695)


- Build deb packages for Debian 12. The debian variant of kong docker image is built using Debian 12 now.
 [#12218](https://github.com/Kong/kong/issues/12218)
 [KAG-3015](https://konghq.atlassian.net/browse/KAG-3015)

- The expressions route now supports the `!` (not) operator, which allows creating routes like
`!(http.path =^ "/a")` and `!(http.path == "/a" || http.path == "/b")`
 [#12419](https://github.com/Kong/kong/issues/12419)
 [KAG-3605](https://konghq.atlassian.net/browse/KAG-3605)

- Add `source` property to log serializer, indicating the response is generated by `kong` or `upstream`.
 [#12052](https://github.com/Kong/kong/issues/12052)
 [FTI-5522](https://konghq.atlassian.net/browse/FTI-5522)

- Ensure Kong-owned directories are cleaned up after an uninstall using the system's package manager.
 [#12162](https://github.com/Kong/kong/issues/12162)
 [FTI-5553](https://konghq.atlassian.net/browse/FTI-5553)

- Support `http.path.segments.len` and `http.path.segments.*` fields in the expressions router
which allows matching incoming (normalized) request path by individual segment or ranges of segments,
plus checking the total number of segments.
 [#12283](https://github.com/Kong/kong/issues/12283)
 [KAG-3351](https://konghq.atlassian.net/browse/KAG-3351)

- `net.src.*` and `net.dst.*` match fields are now accessible in HTTP routes defined using expressions.
 [#11950](https://github.com/Kong/kong/issues/11950)
 [KAG-2963](https://konghq.atlassian.net/browse/KAG-2963) [KAG-3032](https://konghq.atlassian.net/browse/KAG-3032)

- Extend support for getting and setting Gateway values via proxy-wasm properties in the `kong.*` namespace.
 [#11856](https://github.com/Kong/kong/issues/11856)

#### PDK

- Increase the precision of JSON number encoding from 14 to 16 decimals
 [#12019](https://github.com/Kong/kong/issues/12019)
 [FTI-5515](https://konghq.atlassian.net/browse/FTI-5515)
#### Plugin

- Introduced the new **AI Prompt Decorator** plugin that enables prepending and appending llm/v1/chat messages onto consumer LLM requests, for prompt tuning.
 [#12336](https://github.com/Kong/kong/issues/12336)


- Introduced the new **AI Prompt Guard** which can allow and/or block  LLM requests based on pattern matching.
 [#12427](https://github.com/Kong/kong/issues/12427)


- Introduced the new **AI Prompt Template** which can offer consumers and array of LLM prompt templates, with variable substitutions.
 [#12340](https://github.com/Kong/kong/issues/12340)


- Introduced the new **AI Proxy** plugin that enables simplified integration with various AI provider Large Language Models.
 [#12323](https://github.com/Kong/kong/issues/12323)


- Introduced the new **AI Request Transformer** plugin that enables passing mid-flight consumer requests to an LLM for transformation or sanitization.
 [#12426](https://github.com/Kong/kong/issues/12426)


- Introduced the new **AI Response Transformer** plugin that enables passing mid-flight upstream responses to an LLM for transformation or sanitization.
 [#12426](https://github.com/Kong/kong/issues/12426)


- Tracing Sampling Rate can now be set via the `config.sampling_rate` property of the OpenTelemetry plugin instead of it just being a global setting for the gateway.
 [#12054](https://github.com/Kong/kong/issues/12054)
 [KAG-3126](https://konghq.atlassian.net/browse/KAG-3126)
#### Admin API

- add gateway edition to the root endpoint of the admin api
 [#12097](https://github.com/Kong/kong/issues/12097)
 [FTI-5557](https://konghq.atlassian.net/browse/FTI-5557)

- Enable `status_listen` on `127.0.0.1:8007` by default
 [#12304](https://github.com/Kong/kong/issues/12304)
 [KAG-3359](https://konghq.atlassian.net/browse/KAG-3359)
#### Clustering

- **Clustering**: Expose data plane certificate expiry date on the control plane API.
 [#11921](https://github.com/Kong/kong/issues/11921)
 [FTI-5530](https://konghq.atlassian.net/browse/FTI-5530)

### Fixes
#### Configuration

- fix error data loss caused by weakly typed of function in declarative_config_flattened function
 [#12167](https://github.com/Kong/kong/issues/12167)
 [FTI-5584](https://konghq.atlassian.net/browse/FTI-5584)

- respect custom `proxy_access_log`
 [#12073](https://github.com/Kong/kong/issues/12073)
 [FTI-5580](https://konghq.atlassian.net/browse/FTI-5580)
#### Core

- prevent ca to be deleted when it's still referenced by other entities and invalidate the related ca store caches when a ca cert is updated.
 [#11789](https://github.com/Kong/kong/issues/11789)
 [FTI-2060](https://konghq.atlassian.net/browse/FTI-2060)

- Now cookie names are validated against RFC 6265, which allows more characters than the previous validation.
 [#11881](https://github.com/Kong/kong/issues/11881)


- Remove nulls only if the schema has transformations definitions.
Improve performance as most schemas does not define transformations.
 [#12284](https://github.com/Kong/kong/issues/12284)
 [FTI-5260](https://konghq.atlassian.net/browse/FTI-5260)

- Fix a bug that the error_handler can not provide the meaningful response body when the internal error code 494 is triggered.
 [#12114](https://github.com/Kong/kong/issues/12114)
 [FTI-5374](https://konghq.atlassian.net/browse/FTI-5374)

- Header value matching (`http.headers.*`) in `expressions` router flavor are now case sensitive.
This change does not affect on `traditional_compatible` mode
where header value match are always performed ignoring the case.
 [#11905](https://github.com/Kong/kong/issues/11905)
 [KAG-2905](https://konghq.atlassian.net/browse/KAG-2905)

- print error message correctly when plugin fails
 [#11800](https://github.com/Kong/kong/issues/11800)
 [KAG-2844](https://konghq.atlassian.net/browse/KAG-2844)

- fix ldoc intermittent failure caused by LuaJIT error.
 [#11983](https://github.com/Kong/kong/issues/11983)
 [KAG-1761](https://konghq.atlassian.net/browse/KAG-1761)

- use NGX_WASM_MODULE_BRANCH environment variable to set ngx_wasm_module repository branch when building Kong.
 [#12241](https://github.com/Kong/kong/issues/12241)
 [KAG-3396](https://konghq.atlassian.net/browse/KAG-3396)

- Eliminate asynchronous timer in syncQuery() to prevent hang risk
 [#11900](https://github.com/Kong/kong/issues/11900)
 [KAG-2913](https://konghq.atlassian.net/browse/KAG-2913) [FTI-5348](https://konghq.atlassian.net/browse/FTI-5348)

- **tracing:** Fixed an issue where a DNS query failure would cause a tracing failure.
 [#11935](https://github.com/Kong/kong/issues/11935)
 [FTI-5544](https://konghq.atlassian.net/browse/FTI-5544)

- Expressions route in `http` and `stream` subsystem now have stricter validation.
Previously they share the same validation schema which means admin can configure expressions
route using fields like `http.path` even for stream routes. This is no longer allowed.
 [#11914](https://github.com/Kong/kong/issues/11914)
 [KAG-2961](https://konghq.atlassian.net/browse/KAG-2961)

- **Tracing**: dns spans are now correctly generated for upstream dns queries (in addition to cosocket ones)
 [#11996](https://github.com/Kong/kong/issues/11996)
 [KAG-3057](https://konghq.atlassian.net/browse/KAG-3057)

- Validate private and public key for `keys` entity to ensure they match each other.
 [#11923](https://github.com/Kong/kong/issues/11923)
 [KAG-390](https://konghq.atlassian.net/browse/KAG-390)

- **proxy-wasm**: Fixed "previous plan already attached" error thrown when a filter triggers re-entrancy of the access handler.
 [#12452](https://github.com/Kong/kong/issues/12452)
 [KAG-3603](https://konghq.atlassian.net/browse/KAG-3603)
#### PDK

- response.set_header support header argument with table array of string
 [#12164](https://github.com/Kong/kong/issues/12164)
 [FTI-5585](https://konghq.atlassian.net/browse/FTI-5585)

- Fix an issue that when using kong.response.exit, the Transfer-Encoding header set by user is not removed
 [#11936](https://github.com/Kong/kong/issues/11936)
 [FTI-5028](https://konghq.atlassian.net/browse/FTI-5028)

- **Plugin Server**: fix an issue where every request causes a new plugin instance to be created
 [#12020](https://github.com/Kong/kong/issues/12020)
 [KAG-2969](https://konghq.atlassian.net/browse/KAG-2969)
#### Plugin

- Add missing WWW-Authenticate headers to 401 response in basic auth plugin.
 [#11795](https://github.com/Kong/kong/issues/11795)
 [KAG-321](https://konghq.atlassian.net/browse/KAG-321)

- Enhance error responses for authentication failures in the Admin API
 [#12456](https://github.com/Kong/kong/issues/12456)
 [SEC-912](https://konghq.atlassian.net/browse/SEC-912) [KAG-1672](https://konghq.atlassian.net/browse/KAG-1672)

- Expose metrics for serviceless routes
 [#11781](https://github.com/Kong/kong/issues/11781)
 [FTI-5065](https://konghq.atlassian.net/browse/FTI-5065)

- **Rate Limiting**: fix to provide better accuracy in counters when sync_rate is used with the redis policy.
 [#11859](https://github.com/Kong/kong/issues/11859)
 [KAG-2906](https://konghq.atlassian.net/browse/KAG-2906)

- **Rate Limiting**: fix an issuer where all counters are synced to the same DB at the same rate.
 [#12003](https://github.com/Kong/kong/issues/12003)
 [KAG-2904](https://konghq.atlassian.net/browse/KAG-2904)

- **Datadog**: Fix a bug that datadog plugin is not triggered for serviceless routes. In this fix, datadog plugin is always triggered, and the value of tag `name`(service_name) is set as an empty value.
 [#12068](https://github.com/Kong/kong/issues/12068)
 [FTI-5576](https://konghq.atlassian.net/browse/FTI-5576)
#### Clustering

- Fix a bug causing data-plane status updates to fail when an empty PING frame is received from a data-plane
 [#11917](https://github.com/Kong/kong/issues/11917)
 [KAG-2967](https://konghq.atlassian.net/browse/KAG-2967)
## Kong-Manager






### Features
#### Default

- Added a JSON/YAML format preview for all entity forms.
 [#157](https://github.com/Kong/kong-manager/issues/157)


- Adopted resigned basic components for better UI/UX.
 [#131](https://github.com/Kong/kong-manager/issues/131) [#166](https://github.com/Kong/kong-manager/issues/166)


- Kong Manager and Konnect now share the same UI for plugin selection page and plugin form page.
 [#143](https://github.com/Kong/kong-manager/issues/143) [#147](https://github.com/Kong/kong-manager/issues/147)


### Fixes
#### Default

- Standardized notification text format.
 [#140](https://github.com/Kong/kong-manager/issues/140)

