## Kong


### Performance
#### Configuration

- Bumped the default value of `upstream_keepalive_pool_size` to `512` and `upstream_keepalive_max_requests` to `1000`
  [#11515](https://github.com/Kong/kong/issues/11515)
#### Core

- refactor workspace id and name retrieval
  [#11442](https://github.com/Kong/kong/issues/11442)

### Breaking Changes
#### Plugin

- **Session**: a new configuration field `read_body_for_logout` was added with a default value of `false`, that changes behavior of `logout_post_arg` in a way that it is not anymore considered if the `read_body_for_logout` is not explicitly set to `true`. This is to avoid session plugin from reading request bodies by default on e.g. `POST` request for logout detection.
  [#10333](https://github.com/Kong/kong/issues/10333)


### Dependencies
#### Core

- Bumped resty.openssl from 0.8.23 to 0.8.25
  [#11518](https://github.com/Kong/kong/issues/11518)

- Fix incorrect LuaJIT register allocation for IR_*LOAD on ARM64
  [#11638](https://github.com/Kong/kong/issues/11638)

- Fix LDP/STP fusing for unaligned accesses on ARM64
  [#11639](https://github.com/Kong/kong/issues/11639)


- Bump lua-kong-nginx-module from 0.6.0 to 0.8.0
  [#11663](https://github.com/Kong/kong/issues/11663)

- Fix incorrect LuaJIT LDP/STP fusion on ARM64 which may sometimes cause incorrect logic
  [#11537](https://github.com/Kong/kong/issues/11537)

#### Default

- Bumped lua-resty-healthcheck from 1.6.2 to 1.6.3
  [#11360](https://github.com/Kong/kong/issues/11360)

- Bumped OpenResty from 1.21.4.1 to 1.21.4.2
  [#11360](https://github.com/Kong/kong/issues/11360)

- Bumped LuaSec from 1.3.1 to 1.3.2
  [#11553](https://github.com/Kong/kong/issues/11553)


- Bumped lua-resty-aws from 1.3.1 to 1.3.5
  [#11613](https://github.com/Kong/kong/issues/11613)


- bump OpenSSL from 3.1.1 to 3.1.4
  [#11844](https://github.com/Kong/kong/issues/11844)


- Bumped kong-lapis from 1.14.0.2 to 1.14.0.3
  [#11849](https://github.com/Kong/kong/issues/11849)


- Bumped ngx_wasm_module to latest rolling release version.
  [#11678](https://github.com/Kong/kong/issues/11678)

- Bump Wasmtime version to 12.0.2
  [#11738](https://github.com/Kong/kong/issues/11738)

- Bumped lua-resty-aws from 1.3.0 to 1.3.1
  [#11419](https://github.com/Kong/kong/pull/11419)

- Bumped lua-resty-session from 4.0.4 to 4.0.5
  [#11416](https://github.com/Kong/kong/pull/11416)


### Features
#### Core

- Add a new endpoint `/schemas/vaults/:name` to retrieve the schema of a vault.
  [#11727](https://github.com/Kong/kong/issues/11727)

- rename `privileged_agent` to `dedicated_config_processing. Enable `dedicated_config_processing` by default
  [#11784](https://github.com/Kong/kong/issues/11784)

- Support observing the time consumed by some components in the given request.
  [#11627](https://github.com/Kong/kong/issues/11627)

- Plugins can now implement `Plugin:configure(configs)` function that is called whenever there is a change in plugin entities. An array of current plugin configurations is passed to the function, or `nil` in case there is no active configurations for the plugin.
  [#11703](https://github.com/Kong/kong/issues/11703)

- Add a request-aware table able to detect accesses from different requests.
  [#11017](https://github.com/Kong/kong/issues/11017)

- A unique Request ID is now populated in the error log, access log, error templates, log serializer, and in a new X-Kong-Request-Id header (configurable for upstream/downstream using the `headers` and `headers_upstream` configuration options).
  [#11663](https://github.com/Kong/kong/issues/11663)

- Add support for optional Wasm filter configuration schemas
  [#11568](https://github.com/Kong/kong/issues/11568)

- Support JSON in Wasm filter configuration
  [#11697](https://github.com/Kong/kong/issues/11697)

- Support HTTP query parameters in expression routes.
  [#11348](https://github.com/Kong/kong/pull/11348)

#### Plugin

- **response-ratelimiting**: add support for secret rotation with redis connection
  [#10570](https://github.com/Kong/kong/issues/10570)


- **CORS**: Support the `Access-Control-Request-Private-Network` header in crossing-origin pre-light requests
  [#11523](https://github.com/Kong/kong/issues/11523)

- add scan_count to redis storage schema
  [#11532](https://github.com/Kong/kong/issues/11532)


- **AWS-Lambda**: the AWS-Lambda plugin has been refactored by using `lua-resty-aws` as an
  underlying AWS library. The refactor simplifies the AWS-Lambda plugin code base and
  adding support for multiple IAM authenticating scenarios.
  [#11350](https://github.com/Kong/kong/pull/11350)

- **OpenTelemetry** and **Zipkin**: Support GCP X-Cloud-Trace-Context header
  The field `header_type` now accepts the value `gcp` to propagate the
  Google Cloud trace header
  [#11254](https://github.com/Kong/kong/pull/11254)

#### Clustering

- **Clustering**: Allow configuring DP metadata labels for on-premise CP Gateway
  [#11625](https://github.com/Kong/kong/issues/11625)

### Fixes
#### Configuration

- The default value of `dns_no_sync` option has been changed to `on`
  [#11871](https://github.com/Kong/kong/issues/11871)

#### Core

- Fix an issue that the TTL of the key-auth plugin didnt work in DB-less and Hybrid mode.
  [#11464](https://github.com/Kong/kong/issues/11464)

- Fix a problem that abnormal socket connection will be reused when querying Postgres database.
  [#11480](https://github.com/Kong/kong/issues/11480)

- Fix upstream ssl failure when plugins use response handler
  [#11502](https://github.com/Kong/kong/issues/11502)

- Fix an issue that protocol `tls_passthrough` can not work with expressions flavor
  [#11538](https://github.com/Kong/kong/issues/11538)

- Fix a bug that will cause a failure of sending tracing data to datadog when value of x-datadog-parent-id header in requests is a short dec string
  [#11599](https://github.com/Kong/kong/issues/11599)

- Apply Nginx patch for detecting HTTP/2 stream reset attacks early (CVE-2023-44487)
  [#11743](https://github.com/Kong/kong/issues/11743)

- fix the building failure when applying patches
  [#11696](https://github.com/Kong/kong/issues/11696)

- Vault references can be used in Dbless mode in declarative config
  [#11845](https://github.com/Kong/kong/issues/11845)


- Properly warmup Vault caches on init
  [#11827](https://github.com/Kong/kong/issues/11827)


- Vault resurrect time is respected in case a vault secret is deleted from a vault
  [#11852](https://github.com/Kong/kong/issues/11852)

- Fixed critical level logs when starting external plugin servers. Those logs cannot be suppressed due to the limitation of OpenResty. We choose to remove the socket availability detection feature.
  [#11372](https://github.com/Kong/kong/pull/11372)

- Fix an issue where a crashing Go plugin server process would cause subsequent
  requests proxied through Kong to execute Go plugins with inconsistent configurations.
  The issue only affects scenarios where the same Go plugin is applied to different Route
  or Service entities.
  [#11306](https://github.com/Kong/kong/pull/11306)

- Fix an issue where cluster_cert or cluster_ca_cert is inserted into lua_ssl_trusted_certificate before being base64 decoded.
  [#11385](https://github.com/Kong/kong/pull/11385)

- Fix cache warmup mechanism not working in `acls` plugin groups config entity scenario.
  [#11414](https://github.com/Kong/kong/pull/11414)

- Fix an issue that queue stops processing when a hard error is encountered in the handler function.
  [#11423](https://github.com/Kong/kong/pull/11423)

- Fix an issue that query parameters are not forwarded in proxied request.
  Thanks [@chirag-manwani](https://github.com/chirag-manwani) for contributing this change.
  [#11328](https://github.com/Kong/kong/pull/11328)

- Fix an issue that response status code is not real upstream status when using kong.response function.
  [#11437](https://github.com/Kong/kong/pull/11437)

- Removed a hardcoded proxy-wasm isolation level setting that was preventing the
  `nginx_http_proxy_wasm_isolation` configuration value from taking effect.
  [#11407](https://github.com/Kong/kong/pull/11407)

#### PDK

- Fix several issues in Vault and refactor the Vault code base: - Make DAOs to fallback to empty string when resolving Vault references fail - Use node level mutex when rotation references  - Refresh references on config changes - Update plugin referenced values only once per request - Pass only the valid config options to vault implementations - Resolve multi-value secrets only once when rotating them - Do not start vault secrets rotation timer on control planes - Re-enable negative caching - Reimplement the kong.vault.try function - Remove references from rotation in case their configuration has changed
  [#11652](https://github.com/Kong/kong/issues/11652)

- Fix response body gets repeated when `kong.response.get_raw_body()` is called multiple times in a request lifecycle.
  [#11424](https://github.com/Kong/kong/issues/11424)

- Tracing: fix an issue that resulted in some parent spans to end before their children due to different precision of their timestamps
  [#11484](https://github.com/Kong/kong/issues/11484)

- Fix a bug related to data interference between requests in the kong.log.serialize function.
  [#11566](https://github.com/Kong/kong/issues/11566)
#### Plugin

- **Opentelemetry**: fix an issue that resulted in invalid parent IDs in the propagated tracing headers
  [#11468](https://github.com/Kong/kong/issues/11468)

- **AWS-Lambda**: let plugin-level proxy take effect on EKS IRSA credential provider
  [#11551](https://github.com/Kong/kong/issues/11551)

- Cache the AWS lambda service by those lambda service related fields
  [#11821](https://github.com/Kong/kong/issues/11821)

- **Opentelemetry**: fix an issue that resulted in traces with invalid parent IDs when `balancer` instrumentation was enabled
  [#11830](https://github.com/Kong/kong/issues/11830)


- **tcp-log**: fix an issue of unnecessary handshakes when reusing TLS connection
  [#11848](https://github.com/Kong/kong/issues/11848)

- **OAuth2**: For OAuth2 plugin, `scope` has been taken into account as a new criterion of the request validation. When refreshing token with `refresh_token`, the scopes associated with the `refresh_token` provided in the request must be same with or a subset of the scopes configured in the OAuth2 plugin instance hit by the request.
  [#11342](https://github.com/Kong/kong/pull/11342)

- When the worker is in shutdown mode and more data is immediately available without waiting for `max_coalescing_delay`, queues are now cleared in batches.
  Thanks [@JensErat](https://github.com/JensErat) for contributing this change.
  [#11376](https://github.com/Kong/kong/pull/11376)

- A race condition in the plugin queue could potentially crash the worker when `max_entries` was set to `max_batch_size`.
  [#11378](https://github.com/Kong/kong/pull/11378)

- **AWS-Lambda**: fix an issue that the AWS-Lambda plugin cannot extract a json encoded proxy integration response.
  [#11413](https://github.com/Kong/kong/pull/11413)

#### Default

- Restore lapis & luarocks-admin bins
  [#11578](https://github.com/Kong/kong/issues/11578)
## Kong-Manager






### Features
#### Default

- Add `JSON` and `YAML` formats in entity config cards.
  [#111](https://github.com/Kong/kong-manager/issues/111)


- Plugin form fields now display descriptions from backend schema.
  [#66](https://github.com/Kong/kong-manager/issues/66)


- Add the `protocols` field in plugin form.
  [#93](https://github.com/Kong/kong-manager/issues/93)


- The upstream target list shows the `Mark Healthy` and `Mark Unhealthy` action items when certain conditions are met.
  [#86](https://github.com/Kong/kong-manager/issues/86)


### Fixes
#### Default

- Fix incorrect port number in Port Details.
  [#103](https://github.com/Kong/kong-manager/issues/103)


- Fix a bug where the `proxy-cache` plugin cannot be installed.
  [#104](https://github.com/Kong/kong-manager/issues/104)
