export const keyboardKeys: Record<string, { keyCode: number; label: string; code: string }> = {
  backspace: {
    keyCode: 8,
    code: 'Backspace',
    label: 'Backspace',
  },
  tab: {
    keyCode: 9,
    code: 'Tab',
    label: 'Tab',
  },
  enter: {
    keyCode: 13,
    code: 'Enter',
    label: 'Enter',
  },
  shift: {
    keyCode: 16,
    code: 'Shift',
    label: 'Shift',
  },
  ctrl: {
    keyCode: 17,
    code: 'Control',
    label: 'Ctrl',
  },
  alt: {
    keyCode: 18,
    code: 'Alt',
    label: 'Alt',
  },
  pausebreak: {
    keyCode: 19,
    code: 'Pause',
    label: 'PauseBreak',
  },
  capslock: {
    keyCode: 20,
    code: 'CapsLock',
    label: 'CapsLock',
  },
  esc: {
    keyCode: 27,
    code: 'Escape',
    label: 'Escape',
  },
  space: {
    keyCode: 32,
    code: 'Space',
    label: 'Space',
  },
  pageup: {
    keyCode: 33,
    code: 'PageUp',
    label: 'PageUp',
  },
  pagedown: {
    keyCode: 34,
    code: 'PageDown',
    label: 'PageDown',
  },
  end: {
    keyCode: 35,
    code: 'End',
    label: 'End',
  },
  home: {
    keyCode: 36,
    code: 'Home',
    label: 'Home',
  },
  leftarrow: {
    keyCode: 37,
    code: 'ArrowLeft',
    label: 'Left',
  },
  uparrow: {
    keyCode: 38,
    code: 'ArrowUp',
    label: 'Up',
  },
  rightarrow: {
    keyCode: 39,
    code: 'ArrowRight',
    label: 'Right',
  },
  downarrow: {
    keyCode: 40,
    code: 'ArrowDown',
    label: 'Down',
  },
  insert: {
    keyCode: 45,
    code: 'Numpad0',
    label: 'Insert',
  },
  delete: {
    keyCode: 46,
    code: 'Delete',
    label: 'Delete',
  },
  num0: {
    keyCode: 48,
    code: 'Digit0',
    label: '0',
  },
  num1: {
    keyCode: 49,
    code: 'Digit1',
    label: '1',
  },
  num2: {
    keyCode: 50,
    code: 'Digit2',
    label: '2',
  },
  num3: {
    keyCode: 51,
    code: 'Digit3',
    label: '3',
  },
  num4: {
    keyCode: 52,
    code: 'Digit4',
    label: '4',
  },
  num5: {
    keyCode: 53,
    code: 'Digit5',
    label: '5',
  },
  num6: {
    keyCode: 54,
    code: 'Digit6',
    label: '6',
  },
  num7: {
    keyCode: 55,
    code: 'Digit7',
    label: '7',
  },
  num8: {
    keyCode: 56,
    code: 'Digit8',
    label: '8',
  },
  num9: {
    keyCode: 57,
    code: 'Digit9',
    label: '9',
  },
  a: {
    keyCode: 65,
    code: 'KeyA',
    label: 'A',
  },
  b: {
    keyCode: 66,
    code: 'KeyB',
    label: 'B',
  },
  c: {
    keyCode: 67,
    code: 'KeyC',
    label: 'C',
  },
  d: {
    keyCode: 68,
    code: 'KeyD',
    label: 'D',
  },
  e: {
    keyCode: 69,
    code: 'KeyE',
    label: 'E',
  },
  f: {
    keyCode: 70,
    code: 'KeyF',
    label: 'F',
  },
  g: {
    keyCode: 71,
    code: 'KeyG',
    label: 'G',
  },
  h: {
    keyCode: 72,
    code: 'KeyH',
    label: 'H',
  },
  i: {
    keyCode: 73,
    code: 'KeyI',
    label: 'I',
  },
  j: {
    keyCode: 74,
    code: 'KeyJ',
    label: 'J',
  },
  k: {
    keyCode: 75,
    code: 'KeyK',
    label: 'K',
  },
  l: {
    keyCode: 76,
    code: 'KeyL',
    label: 'L',
  },
  m: {
    keyCode: 77,
    code: 'KeyM',
    label: 'M',
  },
  n: {
    keyCode: 78,
    code: 'KeyN',
    label: 'N',
  },
  o: {
    keyCode: 79,
    code: 'KeyO',
    label: 'O',
  },
  p: {
    keyCode: 80,
    code: 'KeyP',
    label: 'P',
  },
  q: {
    keyCode: 81,
    code: 'KeyQ',
    label: 'Q',
  },
  r: {
    keyCode: 82,
    code: 'KeyR',
    label: 'R',
  },
  s: {
    keyCode: 83,
    code: 'KeyS',
    label: 'S',
  },
  t: {
    keyCode: 84,
    code: 'KeyT',
    label: 'T',
  },
  u: {
    keyCode: 85,
    code: 'KeyU',
    label: 'U',
  },
  v: {
    keyCode: 86,
    code: 'KeyV',
    label: 'V',
  },
  w: {
    keyCode: 87,
    code: 'KeyW',
    label: 'W',
  },
  x: {
    keyCode: 88,
    code: 'KeyX',
    label: 'X',
  },
  y: {
    keyCode: 89,
    code: 'KeyY',
    label: 'Y',
  },
  z: {
    keyCode: 90,
    code: 'KeyZ',
    label: 'Z',
  },
  leftwindowkey: {
    keyCode: 91,
    code: 'MetaLeft',
    label: 'LeftWindow',
  },
  rightwindowkey: {
    keyCode: 92,
    code: 'MetaRight',
    label: 'RightWindow',
  },
  selectkey: {
    keyCode: 93,
    code: 'ContextMenu',
    label: 'Select',
  },
  numpad0: {
    keyCode: 96,
    code: 'Numpad0',
    label: 'NumPad0',
  },
  numpad1: {
    keyCode: 97,
    code: 'Numpad1',
    label: 'NumPad1',
  },
  numpad2: {
    keyCode: 98,
    code: 'Numpad2',
    label: 'NumPad2',
  },
  numpad3: {
    keyCode: 99,
    code: 'Numpad3',
    label: 'NumPad3',
  },
  numpad4: {
    keyCode: 100,
    code: 'Numpad4',
    label: 'NumPad4',
  },
  numpad5: {
    keyCode: 101,
    code: 'Numpad5',
    label: 'NumPad5',
  },
  numpad6: {
    keyCode: 102,
    code: 'Numpad6',
    label: 'NumPad6',
  },
  numpad7: {
    keyCode: 103,
    code: 'Numpad7',
    label: 'NumPad7',
  },
  numpad8: {
    keyCode: 104,
    code: 'Numpad8',
    label: 'NumPad8',
  },
  numpad9: {
    keyCode: 105,
    code: 'Numpad9',
    label: 'NumPad9',
  },
  multiply: {
    keyCode: 106,
    code: 'NumpadMultiply',
    label: 'NumPad_Multiply',
  },
  add: {
    keyCode: 107,
    code: 'NumpadAdd',
    label: 'NumPad_Add',
  },
  separator: {
    keyCode: 108,
    code: 'NumpadDecimal',
    label: 'NumPad_Separator',
  },
  subtract: {
    keyCode: 109,
    code: 'NumpadSubtract',
    label: 'NumPad_Subtract',
  },
  decimalpoint: {
    keyCode: 110,
    code: 'NumpadDecimal',
    label: 'NumPad_Decimal',
  },
  divide: {
    keyCode: 111,
    code: 'NumpadDivide',
    label: 'NumPad_Divide',
  },
  f1: {
    keyCode: 112,
    code: 'F1',
    label: 'F1',
  },
  f2: {
    keyCode: 113,
    code: 'F2',
    label: 'F2',
  },
  f3: {
    keyCode: 114,
    code: 'F3',
    label: 'F3',
  },
  f4: {
    keyCode: 115,
    code: 'F4',
    label: 'F4',
  },
  f5: {
    keyCode: 116,
    code: 'F5',
    label: 'F5',
  },
  f6: {
    keyCode: 117,
    code: 'F6',
    label: 'F6',
  },
  f7: {
    keyCode: 118,
    code: 'F7',
    label: 'F7',
  },
  f8: {
    keyCode: 119,
    code: 'F8',
    label: 'F8',
  },
  f9: {
    keyCode: 120,
    code: 'F9',
    label: 'F9',
  },
  f10: {
    keyCode: 121,
    code: 'F10',
    label: 'F10',
  },
  f11: {
    keyCode: 122,
    code: 'F11',
    label: 'F11',
  },
  f12: {
    keyCode: 123,
    code: 'F12',
    label: 'F12',
  },
  numlock: {
    keyCode: 144,
    code: 'NumLock',
    label: 'NumLock',
  },
  scrolllock: {
    keyCode: 145,
    code: 'ScrollLock',
    label: 'ScrollLock',
  },
  semicolon: {
    keyCode: 186,
    code: 'Semicolon',
    label: ';',
  },
  equalsign: {
    keyCode: 187,
    code: 'Equal',
    label: '=',
  },
  comma: {
    keyCode: 188,
    code: 'Comma',
    label: ',',
  },
  dash: {
    keyCode: 189,
    code: 'Minus',
    label: '-',
  },
  period: {
    keyCode: 190,
    code: 'Period',
    label: '.',
  },
  forwardslash: {
    keyCode: 191,
    code: 'Slash',
    label: '/',
  },
  graveaccent: {
    keyCode: 192,
    code: 'IntlBackslash',
    label: '`',
  },
  openbracket: {
    keyCode: 219,
    code: 'BracketLeft',
    label: '[',
  },
  backslash: {
    keyCode: 220,
    code: 'Backslash',
    label: '\\',
  },
  closebracket: {
    keyCode: 221,
    code: 'BracketRight',
    label: ']',
  },
  singlequote: {
    keyCode: 222,
    code: 'Quote',
    label: "'",
  },
};
