# Contributing to this project

Please take a moment to review this document in order to make the contribution process easy and effective for everyone involved.

## Using the issue tracker

[GitHub Issues](https://github.com/kong/insomnia/issues) is the preferred channel for [bug reports](#bug-reports), [features requests](#feature-requests) and [submitting pull requests](#pull-requests).

Please respect the following restrictions:

- Please **do not** derail or troll issues. Keep the discussion on topic and respect the opinions of others.

## Bug Reports

A bug is a _demonstrable problem_ that is caused by the code in the repository. Good bug reports are extremely helpful - thank you!

Guidelines for bug reports:

1. **Use the GitHub issue search** &mdash; check if the issue has already been reported.
1. **Check if the issue has been fixed** &mdash; try to reproduce it using the latest `master` or development branch in the repository.
1. **Demonstrate the problem** &mdash; provide clear steps that can be reproduced.

A good bug report should not leave others needing to chase you up for more information. Please try to be as detailed as possible in your report. What is your environment? What steps will reproduce the issue? What OS experienced the problem? What would you expect to be the outcome? All these details will help to fix any potential bugs.

## Feature Requests

Feature requests are welcome. But take a moment to find out whether your idea fits with the scope and aims of the project. It's up to _you_ to make a strong case to convince the project's developers of the merits of this feature. Please provide as much detail and context as possible.

## Pull Requests

Good pull requests (patches, improvements, new features) are a fantastic help. They should remain focused in scope and avoid containing unrelated commits.

**Please ask first** before embarking on any significant pull request (e.g. implementing features, refactoring code, porting to a different language), otherwise, you risk spending a lot of time working on something that might not get accepted into the project.

If you plan on helping with development, please read the [Develop Insomnia](README.md#develop-insomnia) section of the README for how to get started. The [Development Overview](DEVELOPMENT.md) may also prove useful for a general overview of the application architecture.

**IMPORTANT**: By submitting a patch, you agree to allow the project owner to license your work under the same license as that used by the project.

## Contributor Badge

If your pull request to [Kong/insomnia](https://github.com/Kong/insomnia) was accepted, and it fixes a bug, adds functionality, or makes it significantly easier to use or understand Insomnia, congratulations! You are eligible to receive a digital Contributor Badge! Go ahead and fill out the [Contributor Submissions form](https://goo.gl/forms/5w6mxLaE4tz2YM0L2).

_Badges expire after 1 year, at which point you may submit a new contribution to renew the badge._
