-- MySQL dump 10.17  Distrib 10.3.13-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: localhost    Database: train
-- ------------------------------------------------------
-- Server version	10.3.13-MariaDB-1:10.3.13+maria~bionic-log

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `neighbour`
--

DROP TABLE IF EXISTS `neighbour`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `neighbour` (
  `st1` varchar(5) NOT NULL,
  `st2` varchar(5) NOT NULL,
  `distance` int(10) unsigned NOT NULL,
  PRIMARY KEY (`st1`,`st2`),
  KEY `st2` (`st2`),
  CONSTRAINT `neighbour_ibfk_1` FOREIGN KEY (`st1`) REFERENCES `station` (`station_code`),
  CONSTRAINT `neighbour_ibfk_2` FOREIGN KEY (`st2`) REFERENCES `station` (`station_code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `neighbour`
--

LOCK TABLES `neighbour` WRITE;
/*!40000 ALTER TABLE `neighbour` DISABLE KEYS */;
INSERT INTO `neighbour` VALUES ('BHN','LKW',73),('BHN','MON',15),('BTC','PAN',72),('BTC','PRT',37),('CAB','KAM',103),('CAB','MON',25),('CAC','DOC',96),('CAP','HAT',93),('CAV','QRY',50),('DOC','CAC',96),('DOC','KAM',45),('FPR','GTK',33),('FPR','PMK',72),('FRM','MLT',45),('FRM','PCH',34),('GPL','HPT',46),('GPL','ZRK',82),('GTK','FPR',33),('GTK','PCH',77),('HAT','CAP',93),('HAT','KHO',96),('HPT','GPL',46),('HPT','PCH',21),('KAM','CAB',103),('KAM','DOC',45),('KHO','HAT',96),('KHO','MON',87),('KHO','TAT',10),('KMK','STB',92),('LKW','BHN',73),('LKW','QRY',36),('MLB','NOV',12),('MLT','FRM',45),('MLT','NOV',39),('MON','BHN',15),('MON','CAB',25),('MON','KHO',87),('NOV','MLB',12),('NOV','MLT',39),('PAN','BTC',72),('PAN','RUN',31),('PCH','FRM',34),('PCH','GTK',77),('PCH','HPT',21),('PCH','RZK',78),('PMK','FPR',72),('PRT','BTC',37),('PRT','TAT',100),('QRY','CAV',50),('QRY','LKW',36),('RUN','PAN',31),('RUN','TMB',59),('RZK','PCH',78),('RZK','YNP',77),('STB','KMK',92),('STB','YNP',39),('TAT','KHO',10),('TAT','PRT',100),('TMB','RUN',59),('YNP','RZK',77),('YNP','STB',39),('ZRK','GPL',82);
/*!40000 ALTER TABLE `neighbour` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `next_station`
--

DROP TABLE IF EXISTS `next_station`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `next_station` (
  `train_no` int(10) unsigned NOT NULL,
  `curr_station_code` varchar(5) NOT NULL,
  `next_station_code` varchar(5) NOT NULL,
  PRIMARY KEY (`train_no`,`curr_station_code`),
  KEY `curr_station_code` (`curr_station_code`),
  KEY `next_station_code` (`next_station_code`),
  CONSTRAINT `next_station_ibfk_1` FOREIGN KEY (`curr_station_code`) REFERENCES `station` (`station_code`),
  CONSTRAINT `next_station_ibfk_2` FOREIGN KEY (`next_station_code`) REFERENCES `station` (`station_code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `next_station`
--

LOCK TABLES `next_station` WRITE;
/*!40000 ALTER TABLE `next_station` DISABLE KEYS */;
INSERT INTO `next_station` VALUES (12511,'MON','BHN'),(12512,'LKW','BHN'),(12511,'PAN','BTC'),(12512,'PRT','BTC'),(12625,'MON','CAB'),(12626,'KAM','CAB'),(12625,'DOC','CAC'),(12626,'HAT','CAP'),(12511,'QRY','CAV'),(12625,'KAM','DOC'),(12626,'CAC','DOC'),(22485,'PMK','FPR'),(22486,'GTK','FPR'),(22485,'PCH','FRM'),(22486,'MLT','FRM'),(22161,'ZRK','GPL'),(22162,'HPT','GPL'),(22485,'FPR','GTK'),(22486,'PCH','GTK'),(12625,'CAP','HAT'),(12626,'KHO','HAT'),(22161,'GPL','HPT'),(22162,'PCH','HPT'),(12625,'CAB','KAM'),(12626,'DOC','KAM'),(12511,'TAT','KHO'),(12512,'MON','KHO'),(12625,'HAT','KHO'),(12626,'MON','KHO'),(22161,'STB','KMK'),(12511,'BHN','LKW'),(12512,'QRY','LKW'),(22485,'NOV','MLB'),(22485,'FRM','MLT'),(22486,'NOV','MLT'),(12511,'KHO','MON'),(12512,'BHN','MON'),(12625,'KHO','MON'),(12626,'CAB','MON'),(22485,'MLT','NOV'),(22486,'MLB','NOV'),(12511,'RUN','PAN'),(12512,'BTC','PAN'),(22161,'HPT','PCH'),(22162,'RZK','PCH'),(22485,'GTK','PCH'),(22486,'FRM','PCH'),(22486,'FPR','PMK'),(12511,'BTC','PRT'),(12512,'TAT','PRT'),(12511,'LKW','QRY'),(12512,'CAV','QRY'),(12511,'TMB','RUN'),(12512,'PAN','RUN'),(22161,'PCH','RZK'),(22162,'YNP','RZK'),(22161,'YNP','STB'),(22162,'KMK','STB'),(12511,'PRT','TAT'),(12512,'KHO','TAT'),(12512,'RUN','TMB'),(22161,'RZK','YNP'),(22162,'STB','YNP'),(22162,'GPL','ZRK');
/*!40000 ALTER TABLE `next_station` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `path`
--

DROP TABLE IF EXISTS `path`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `path` (
  `train_no` int(10) unsigned NOT NULL,
  `station_code` varchar(5) NOT NULL,
  `sched_arr` time NOT NULL,
  `sched_dept` time NOT NULL,
  `stoppage_idx` int(11) NOT NULL,
  `dist` float DEFAULT NULL CHECK (`dist` >= 0),
  PRIMARY KEY (`train_no`,`station_code`),
  KEY `station_code` (`station_code`),
  CONSTRAINT `path_ibfk_1` FOREIGN KEY (`train_no`) REFERENCES `train` (`train_no`),
  CONSTRAINT `path_ibfk_2` FOREIGN KEY (`station_code`) REFERENCES `station` (`station_code`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`sched_arr` < `sched_dept`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `path`
--

LOCK TABLES `path` WRITE;
/*!40000 ALTER TABLE `path` DISABLE KEYS */;
INSERT INTO `path` VALUES (12511,'BHN','14:53:29','14:58:29',8,411),(12511,'BTC','11:24:29','11:29:29',3,162),(12511,'CAV','17:38:29','17:43:29',11,570),(12511,'KHO','13:10:29','13:15:29',6,309),(12511,'LKW','16:38:29','16:43:29',9,484),(12511,'MON','13:33:29','13:38:29',7,396),(12511,'PAN','10:43:29','10:48:29',2,90),(12511,'PRT','11:46:29','11:51:29',4,199),(12511,'QRY','16:58:29','17:03:29',10,520),(12511,'RUN','09:29:29','09:34:29',1,59),(12511,'TAT','12:25:29','12:30:29',5,299),(12511,'TMB','07:40:29','07:45:29',0,0),(12512,'BHN','04:00:46','04:05:46',3,159),(12512,'BTC','07:51:46','07:56:46',8,408),(12512,'CAV','00:36:46','00:41:46',0,0),(12512,'KHO','04:39:46','04:44:46',5,261),(12512,'LKW','03:31:46','03:36:46',2,86),(12512,'MON','04:16:46','04:21:46',4,174),(12512,'PAN','08:17:46','08:22:46',9,480),(12512,'PRT','07:02:46','07:07:46',7,371),(12512,'QRY','01:54:46','01:59:46',1,50),(12512,'RUN','09:17:46','09:22:46',10,511),(12512,'TAT','05:34:46','05:39:46',6,271),(12512,'TMB','10:17:46','10:22:46',11,570),(12625,'CAB','07:04:43','07:09:43',4,301),(12625,'CAC','11:07:43','11:12:43',7,545),(12625,'CAP','01:53:43','01:58:43',0,0),(12625,'DOC','09:25:43','09:30:43',6,449),(12625,'HAT','03:29:43','03:34:43',1,93),(12625,'KAM','07:49:43','07:54:43',5,404),(12625,'KHO','04:56:43','05:01:43',2,189),(12625,'MON','05:21:43','05:26:43',3,276),(12626,'CAB','15:24:36','15:29:36',3,244),(12626,'CAC','13:01:36','13:06:36',0,0),(12626,'CAP','19:30:36','19:35:36',7,545),(12626,'DOC','13:33:36','13:38:36',1,96),(12626,'HAT','18:50:36','18:55:36',6,452),(12626,'KAM','13:51:36','13:56:36',2,141),(12626,'KHO','17:09:36','17:14:36',5,356),(12626,'MON','15:41:36','15:46:36',4,269),(22161,'GPL','08:56:29','09:01:29',1,82),(22161,'HPT','10:13:29','10:18:29',2,128),(22161,'KMK','14:17:29','14:22:29',7,435),(22161,'PCH','10:32:29','10:37:29',3,149),(22161,'RZK','11:13:29','11:18:29',4,227),(22161,'STB','12:46:29','12:51:29',6,343),(22161,'YNP','11:46:29','11:51:29',5,304),(22161,'ZRK','08:33:29','08:38:29',0,0),(22162,'GPL','12:20:04','12:25:04',6,353),(22162,'HPT','11:03:04','11:08:04',5,307),(22162,'KMK','06:48:04','06:53:04',0,0),(22162,'PCH','09:15:04','09:20:04',4,286),(22162,'RZK','08:42:04','08:47:04',3,208),(22162,'STB','08:02:04','08:07:04',1,92),(22162,'YNP','08:32:04','08:37:04',2,131),(22162,'ZRK','13:41:04','13:46:04',7,435),(22485,'FPR','11:01:38','11:06:38',1,72),(22485,'FRM','14:16:38','14:21:38',4,216),(22485,'GTK','11:53:38','11:58:38',2,105),(22485,'MLB','17:06:38','17:11:38',7,312),(22485,'MLT','15:06:38','15:11:38',5,261),(22485,'NOV','16:06:38','16:11:38',6,300),(22485,'PCH','12:48:38','12:53:38',3,182),(22485,'PMK','10:12:38','10:17:38',0,0),(22486,'FPR','05:02:21','05:07:21',6,240),(22486,'FRM','02:13:21','02:18:21',3,96),(22486,'GTK','04:17:21','04:22:21',5,207),(22486,'MLB','00:15:21','00:20:21',0,0),(22486,'MLT','01:30:21','01:35:21',2,51),(22486,'NOV','01:04:21','01:09:21',1,12),(22486,'PCH','03:55:21','04:00:21',4,130),(22486,'PMK','06:02:21','06:07:21',7,312);
/*!40000 ALTER TABLE `path` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `seat_allocation`
--

DROP TABLE IF EXISTS `seat_allocation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `seat_allocation` (
  `train_no` int(10) unsigned NOT NULL,
  `running_date` date NOT NULL,
  `seat_no` int(10) unsigned NOT NULL,
  `idx_0` bigint(20) unsigned DEFAULT NULL,
  `idx_1` bigint(20) unsigned DEFAULT NULL,
  `idx_2` bigint(20) unsigned DEFAULT NULL,
  `idx_3` bigint(20) unsigned DEFAULT NULL,
  `idx_4` bigint(20) unsigned DEFAULT NULL,
  `idx_5` bigint(20) unsigned DEFAULT NULL,
  `idx_6` bigint(20) unsigned DEFAULT NULL,
  `idx_7` bigint(20) unsigned DEFAULT NULL,
  `idx_8` bigint(20) unsigned DEFAULT NULL,
  `idx_9` bigint(20) unsigned DEFAULT NULL,
  `idx_10` bigint(20) unsigned DEFAULT NULL,
  `idx_11` bigint(20) unsigned DEFAULT NULL,
  `idx_12` bigint(20) unsigned DEFAULT NULL,
  `idx_13` bigint(20) unsigned DEFAULT NULL,
  `idx_14` bigint(20) unsigned DEFAULT NULL,
  `idx_15` bigint(20) unsigned DEFAULT NULL,
  `idx_16` bigint(20) unsigned DEFAULT NULL,
  `idx_17` bigint(20) unsigned DEFAULT NULL,
  `idx_18` bigint(20) unsigned DEFAULT NULL,
  `idx_19` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`train_no`,`running_date`,`seat_no`),
  CONSTRAINT `seat_allocation_ibfk_1` FOREIGN KEY (`train_no`) REFERENCES `train` (`train_no`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `seat_allocation`
--

LOCK TABLES `seat_allocation` WRITE;
/*!40000 ALTER TABLE `seat_allocation` DISABLE KEYS */;
INSERT INTO `seat_allocation` VALUES (12511,'1947-08-15',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12511,'1947-08-15',2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12511,'1947-08-15',3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12511,'1947-08-15',4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12511,'1947-08-15',5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12511,'1947-08-15',6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12511,'1947-08-15',7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12511,'1947-08-15',8,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12511,'1947-08-15',9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12511,'1947-08-15',10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12511,'1950-01-26',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12511,'1950-01-26',2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12511,'1950-01-26',3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12511,'1950-01-26',4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12511,'1950-01-26',5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12511,'1950-01-26',6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12511,'1950-01-26',7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12511,'1950-01-26',8,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12511,'1950-01-26',9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12511,'1950-01-26',10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12512,'1947-08-15',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12512,'1947-08-15',2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12512,'1947-08-15',3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12512,'1947-08-15',4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12512,'1947-08-15',5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12512,'1947-08-15',6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12512,'1947-08-15',7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12512,'1947-08-15',8,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12512,'1947-08-15',9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12512,'1947-08-15',10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12512,'1950-01-26',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12512,'1950-01-26',2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12512,'1950-01-26',3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12512,'1950-01-26',4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12512,'1950-01-26',5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12512,'1950-01-26',6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12512,'1950-01-26',7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12512,'1950-01-26',8,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12512,'1950-01-26',9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12512,'1950-01-26',10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12625,'1947-08-15',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12625,'1947-08-15',2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12625,'1947-08-15',3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12625,'1947-08-15',4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12625,'1947-08-15',5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12625,'1947-08-15',6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12625,'1947-08-15',7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12625,'1947-08-15',8,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12625,'1947-08-15',9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12625,'1947-08-15',10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12625,'1950-01-26',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12625,'1950-01-26',2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12625,'1950-01-26',3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12625,'1950-01-26',4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12625,'1950-01-26',5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12625,'1950-01-26',6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12625,'1950-01-26',7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12625,'1950-01-26',8,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12625,'1950-01-26',9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12625,'1950-01-26',10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12626,'1947-08-15',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12626,'1947-08-15',2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12626,'1947-08-15',3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12626,'1947-08-15',4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12626,'1947-08-15',5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12626,'1947-08-15',6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12626,'1947-08-15',7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12626,'1947-08-15',8,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12626,'1947-08-15',9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12626,'1947-08-15',10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12626,'1950-01-26',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12626,'1950-01-26',2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12626,'1950-01-26',3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12626,'1950-01-26',4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12626,'1950-01-26',5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12626,'1950-01-26',6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12626,'1950-01-26',7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12626,'1950-01-26',8,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12626,'1950-01-26',9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12626,'1950-01-26',10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22161,'1947-08-15',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22161,'1947-08-15',2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22161,'1947-08-15',3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22161,'1947-08-15',4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22161,'1947-08-15',5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22161,'1947-08-15',6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22161,'1947-08-15',7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22161,'1947-08-15',8,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22161,'1947-08-15',9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22161,'1947-08-15',10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22161,'1950-01-26',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22161,'1950-01-26',2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22161,'1950-01-26',3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22161,'1950-01-26',4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22161,'1950-01-26',5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22161,'1950-01-26',6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22161,'1950-01-26',7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22161,'1950-01-26',8,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22161,'1950-01-26',9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22161,'1950-01-26',10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22162,'1947-08-15',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22162,'1947-08-15',2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22162,'1947-08-15',3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22162,'1947-08-15',4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22162,'1947-08-15',5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22162,'1947-08-15',6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22162,'1947-08-15',7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22162,'1947-08-15',8,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22162,'1947-08-15',9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22162,'1947-08-15',10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22162,'1950-01-26',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22162,'1950-01-26',2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22162,'1950-01-26',3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22162,'1950-01-26',4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22162,'1950-01-26',5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22162,'1950-01-26',6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22162,'1950-01-26',7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22162,'1950-01-26',8,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22162,'1950-01-26',9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22162,'1950-01-26',10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22485,'1947-08-15',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22485,'1947-08-15',2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22485,'1947-08-15',3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22485,'1947-08-15',4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22485,'1947-08-15',5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22485,'1947-08-15',6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22485,'1947-08-15',7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22485,'1947-08-15',8,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22485,'1947-08-15',9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22485,'1947-08-15',10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22485,'1950-01-26',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22485,'1950-01-26',2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22485,'1950-01-26',3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22485,'1950-01-26',4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22485,'1950-01-26',5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22485,'1950-01-26',6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22485,'1950-01-26',7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22485,'1950-01-26',8,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22485,'1950-01-26',9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22485,'1950-01-26',10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22486,'1947-08-15',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22486,'1947-08-15',2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22486,'1947-08-15',3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22486,'1947-08-15',4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22486,'1947-08-15',5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22486,'1947-08-15',6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22486,'1947-08-15',7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22486,'1947-08-15',8,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22486,'1947-08-15',9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22486,'1947-08-15',10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22486,'1950-01-26',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22486,'1950-01-26',2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22486,'1950-01-26',3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22486,'1950-01-26',4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22486,'1950-01-26',5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22486,'1950-01-26',6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22486,'1950-01-26',7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22486,'1950-01-26',8,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22486,'1950-01-26',9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22486,'1950-01-26',10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `seat_allocation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `station`
--

DROP TABLE IF EXISTS `station`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `station` (
  `station_code` varchar(5) NOT NULL,
  `station_name` varchar(50) NOT NULL,
  `city` varchar(50) NOT NULL,
  PRIMARY KEY (`station_code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `station`
--

LOCK TABLES `station` WRITE;
/*!40000 ALTER TABLE `station` DISABLE KEYS */;
INSERT INTO `station` VALUES ('BHN','Bhan','Sanhok'),('BTC','Bootcamp','Sanhok'),('CAB','Camp Bravo','Sanhok'),('CAC','Camp Charlie','Sanhok'),('CAP','Camp Alpha','Sanhok'),('CAV','Cave','Sanhok'),('DOC','Docks','Sanhok'),('FPR','Ferry Pier','Erangel'),('FRM','Farm','Erangel'),('GPL','Georgopol','Erangel'),('GTK','Gatka','Erangel'),('HAT','Ha Tinh','Sanhok'),('HPT','Hospital','Erangel'),('KAM','Kampong','Sanhok'),('KHO','Khao','Sanhok'),('KMK','Kameshki','Erangel'),('LKW','Lakawi','Sanhok'),('MLB','Military Base','Erangel'),('MLT','Mylta','Erangel'),('MON','Mongnai','Sanhok'),('NOV','Novorepnoye','Erangel'),('PAN','Pai Nan','Sanhok'),('PCH','Pochinki','Erangel'),('PMK','Primorsk','Erangel'),('PRT','Paradise Resort','Sanhok'),('QRY','Quarry','Sanhok'),('RUN','Ruins','Sanhok'),('RZK','Rozhok','Erangel'),('STB','Stalber','Erangel'),('TAT','Tat Mok','Sanhok'),('TMB','Tampbang','Sanhok'),('YNP','Yasnaya Polyana','Erangel'),('ZRK','Zharki','Erangel');
/*!40000 ALTER TABLE `station` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ticket`
--

DROP TABLE IF EXISTS `ticket`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ticket` (
  `pnr` bigint(20) unsigned NOT NULL,
  `userid` varchar(50) NOT NULL,
  `source` varchar(5) NOT NULL,
  `dest` varchar(5) NOT NULL,
  `train_no` int(10) unsigned NOT NULL,
  `date_time_resv` datetime NOT NULL,
  `date_time_travel` datetime NOT NULL,
  `seat_no` int(10) unsigned NOT NULL,
  PRIMARY KEY (`pnr`),
  KEY `userid` (`userid`),
  KEY `source` (`source`),
  KEY `dest` (`dest`),
  KEY `train_no` (`train_no`),
  CONSTRAINT `ticket_ibfk_1` FOREIGN KEY (`userid`) REFERENCES `user` (`userid`),
  CONSTRAINT `ticket_ibfk_2` FOREIGN KEY (`source`) REFERENCES `station` (`station_code`),
  CONSTRAINT `ticket_ibfk_3` FOREIGN KEY (`dest`) REFERENCES `station` (`station_code`),
  CONSTRAINT `ticket_ibfk_4` FOREIGN KEY (`train_no`) REFERENCES `train` (`train_no`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`date_time_resv` < `date_time_travel`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ticket`
--

LOCK TABLES `ticket` WRITE;
/*!40000 ALTER TABLE `ticket` DISABLE KEYS */;
INSERT INTO `ticket` VALUES (1,'SageMadara','RZK','KMK',22161,'2019-02-04 21:16:00','2019-02-05 11:13:29',1);
/*!40000 ALTER TABLE `ticket` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `train`
--

DROP TABLE IF EXISTS `train`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `train` (
  `train_no` int(10) unsigned NOT NULL,
  `source_st` varchar(5) NOT NULL,
  `dest_st` varchar(5) NOT NULL,
  `fare_per_km` float unsigned NOT NULL,
  PRIMARY KEY (`train_no`),
  UNIQUE KEY `source_st` (`source_st`),
  UNIQUE KEY `dest_st` (`dest_st`),
  CONSTRAINT `train_ibfk_1` FOREIGN KEY (`source_st`) REFERENCES `station` (`station_code`),
  CONSTRAINT `train_ibfk_2` FOREIGN KEY (`dest_st`) REFERENCES `station` (`station_code`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`source_st` <> `dest_st`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `train`
--

LOCK TABLES `train` WRITE;
/*!40000 ALTER TABLE `train` DISABLE KEYS */;
INSERT INTO `train` VALUES (12511,'TMB','CAV',30),(12512,'CAV','TMB',30),(12625,'CAP','CAC',10),(12626,'CAC','CAP',10),(22161,'ZRK','KMK',20),(22162,'KMK','ZRK',20),(22485,'PMK','MLB',40),(22486,'MLB','PMK',40);
/*!40000 ALTER TABLE `train` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'IGNORE_SPACE,STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 trigger delete_train
before delete on train
for each row
    delete from path
    where path.train_no = train.train_no */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `user`
--

DROP TABLE IF EXISTS `user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user` (
  `userid` varchar(50) NOT NULL,
  `password_hash` varchar(255) NOT NULL,
  `name` varchar(100) NOT NULL,
  `aadhar_no` bigint(20) unsigned NOT NULL,
  `contact_no` varchar(20) NOT NULL,
  PRIMARY KEY (`userid`),
  UNIQUE KEY `aadhar_no` (`aadhar_no`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user`
--

LOCK TABLES `user` WRITE;
/*!40000 ALTER TABLE `user` DISABLE KEYS */;
INSERT INTO `user` VALUES ('HYDRA | DYNAMO','77a9cb1532a268df233389b762bab5fc','Kamlesh',1234567887654321,'7304709870'),('SageMadara','88a9cb4672a268df278989b762bab5fc','Kaushal',1023456788765401,'8281112731');
/*!40000 ALTER TABLE `user` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2019-03-04 19:36:24
