CREATE TABLE IF NOT EXISTS user (
  userid VARCHAR(50) NOT NULL PRIMARY KEY,
  password_hash VARCHAR(255) NOT NULL ,
  name VARCHAR(100) NOT NULL ,
  aadhar_no BIGINT UNSIGNED NOT NULL UNIQUE ,
  contact_no VARCHAR(20) NOT NULL
);


CREATE TABLE IF NOT EXISTS station (
  station_code VARCHAR(5) NOT NULL PRIMARY KEY ,
  station_name VARCHAR(50) NOT NULL ,
  city VARCHAR(50) NOT NULL
);


CREATE TABLE IF NOT EXISTS train (
  train_no INT UNSIGNED NOT NULL PRIMARY KEY ,
  source_st VARCHAR(5) NOT NULL UNIQUE ,
  dest_st VARCHAR(5) NOT NULL UNIQUE ,
  fare_per_km FLOAT UNSIGNED NOT NULL ,
  FOREIGN KEY (source_st) REFERENCES station(station_code),
  FOREIGN KEY (dest_st) REFERENCES station(station_code),
  CHECK ( source_st <> dest_st )
);


CREATE TABLE IF NOT EXISTS neighbour (
  st1 VARCHAR(5) NOT NULL ,
  st2 VARCHAR(5) NOT NULL ,
  distance INT UNSIGNED NOT NULL ,
  PRIMARY KEY (st1,st2),
  FOREIGN KEY (st1) REFERENCES station(station_code),
  FOREIGN KEY (st2) REFERENCES station(station_code)
);

CREATE TABLE IF NOT EXISTS path (
  train_no INT UNSIGNED NOT NULL ,
  station_code VARCHAR(5) NOT NULL ,
  sched_arr TIME NOT NULL,
  sched_dept TIME NOT NULL,
  stoppage_idx INT NOT NULL ,
  PRIMARY KEY (train_no, station_code),
  FOREIGN KEY (train_no) REFERENCES train(train_no),
  FOREIGN KEY (station_code) REFERENCES station(station_code),
  CHECK(sched_arr < sched_dept)
);

CREATE TABLE IF NOT EXISTS next_station (
  train_no INT UNSIGNED NOT NULL,
  curr_station_code VARCHAR(5) NOT NULL ,
  next_station_code VARCHAR(5) NOT NULL ,
  PRIMARY KEY (train_no, curr_station_code) ,
  FOREIGN KEY (curr_station_code) REFERENCES station(station_code),
  FOREIGN KEY (next_station_code) REFERENCES station(station_code)
);

CREATE TABLE IF NOT EXISTS ticket (
  pnr BIGINT UNSIGNED NOT NULL PRIMARY KEY ,
  userid VARCHAR(50) NOT NULL ,
  source VARCHAR(5) NOT NULL ,
  dest VARCHAR(5) NOT NULL ,
  train_no INT UNSIGNED NOT NULL ,
  date_time_resv DATETIME NOT NULL ,
  date_time_travel DATETIME NOT NULL ,
  seat_no INT UNSIGNED NOT NULL ,
  fare FLOAT UNSIGNED NOT NULL ,
  FOREIGN KEY (userid) REFERENCES user(userid) ,
  FOREIGN KEY (source) REFERENCES station(station_code) ,
  FOREIGN KEY (dest) REFERENCES station(station_code) ,
  FOREIGN KEY (train_no) REFERENCES train(train_no) ,
  CHECK ( date_time_resv < date_time_travel )
);

CREATE TABLE IF NOT EXISTS seat_allocation (
  train_no INT UNSIGNED NOT NULL ,
  running_date DATE NOT NULL,
  seat_no INT UNSIGNED NOT NULL ,
  idx_0 BIGINT UNSIGNED DEFAULT NULL,
  idx_1 BIGINT UNSIGNED DEFAULT NULL,
  idx_2 BIGINT UNSIGNED DEFAULT NULL,
  idx_3 BIGINT UNSIGNED DEFAULT NULL,
  idx_4 BIGINT UNSIGNED DEFAULT NULL,
  idx_5 BIGINT UNSIGNED DEFAULT NULL,
  idx_6 BIGINT UNSIGNED DEFAULT NULL,
  idx_7 BIGINT UNSIGNED DEFAULT NULL,
  idx_8 BIGINT UNSIGNED DEFAULT NULL,
  idx_9 BIGINT UNSIGNED DEFAULT NULL,
  idx_10 BIGINT UNSIGNED DEFAULT NULL,
  idx_11 BIGINT UNSIGNED DEFAULT NULL,
  idx_12 BIGINT UNSIGNED DEFAULT NULL,
  idx_13 BIGINT UNSIGNED DEFAULT NULL,
  idx_14 BIGINT UNSIGNED DEFAULT NULL,
  idx_15 BIGINT UNSIGNED DEFAULT NULL,
  idx_16 BIGINT UNSIGNED DEFAULT NULL,
  idx_17 BIGINT UNSIGNED DEFAULT NULL,
  idx_18 BIGINT UNSIGNED DEFAULT NULL,
  idx_19 BIGINT UNSIGNED DEFAULT NULL,
  PRIMARY KEY (train_no, running_date, seat_no),
  FOREIGN KEY (train_no) REFERENCES train(train_no)
);


INSERT INTO station VALUES

('CAP' , 'Camp Alpha', 'Sanhok'),
('HAT', 'Ha Tinh', 'Sanhok'),
('KHO', 'Khao', 'Sanhok'),
('MON', 'Mongnai', 'Sanhok'),
('CAB', 'Camp Bravo', 'Sanhok'),
('KAM', 'Kampong', 'Sanhok'),
('DOC', 'Docks', 'Sanhok'),
('CAC', 'Camp Charlie', 'Sanhok'),
('TMB', 'Tampbang', 'Sanhok'),
('RUN', 'Ruins', 'Sanhok'),
('PAN', 'Pai Nan', 'Sanhok'),
('BTC', 'Bootcamp', 'Sanhok'),
('PRT', 'Paradise Resort', 'Sanhok'),
('TAT', 'Tat Mok', 'Sanhok'),
('BHN', 'Bhan', 'Sanhok'),
('LKW', 'Lakawi', 'Sanhok'),
('QRY', 'Quarry', 'Sanhok'),
('CAV', 'Cave', 'Sanhok'),
('ZRK', 'Zharki', 'Erangel'),
('GPL', 'Georgopol', 'Erangel'),
('HPT', 'Hospital', 'Erangel'),
('PCH', 'Pochinki', 'Erangel'),
('RZK', 'Rozhok', 'Erangel'),
('YNP', 'Yasnaya Polyana', 'Erangel'),
('STB', 'Stalber', 'Erangel'),
('KMK', 'Kameshki', 'Erangel'),
('PMK', 'Primorsk', 'Erangel'),
('FPR', 'Ferry Pier', 'Erangel'),
('GTK', 'Gatka', 'Erangel'),
('FRM', 'Farm', 'Erangel'),
('MLT', 'Mylta', 'Erangel'),
('NOV', 'Novorepnoye', 'Erangel'),
('MLB', 'Military Base', 'Erangel');


INSERT INTO neighbour VALUES
('CAP', 'HAT', 93),
('HAT', 'CAP', 93),
('HAT', 'KHO', 96),
('KHO', 'HAT', 96),
('KHO', 'MON', 87),
('MON', 'KHO', 87),
('MON', 'CAB', 25),
('CAB', 'MON', 25),
('CAB', 'KAM', 103),
('KAM', 'CAB', 103),
('KAM', 'DOC', 45),
('DOC', 'KAM', 45),
('DOC', 'CAC', 96),
('CAC', 'DOC', 96),
('TMB', 'RUN', 59),
('RUN', 'TMB', 59),
('RUN', 'PAN', 31),
('PAN', 'RUN', 31),
('PAN', 'BTC', 72),
('BTC', 'PAN', 72),
('BTC', 'PRT', 37),
('PRT', 'BTC', 37),
('PRT', 'TAT', 100),
('TAT', 'PRT', 100),
('TAT', 'KHO', 10),
('KHO', 'TAT', 10),
('MON', 'BHN', 15),
('BHN', 'MON', 15),
('BHN', 'LKW', 73),
('LKW', 'BHN', 73),
('LKW', 'QRY', 36),
('QRY', 'LKW', 36),
('QRY', 'CAV', 50),
('CAV', 'QRY', 50),
('ZRK', 'GPL', 82),
('GPL', 'ZRK', 82),
('GPL', 'HPT', 46),
('HPT', 'GPL', 46),
('HPT', 'PCH', 21),
('PCH', 'HPT', 21),
('PCH', 'RZK', 78),
('RZK', 'PCH', 78),
('RZK', 'YNP', 77),
('YNP', 'RZK', 77),
('YNP', 'STB', 39),
('STB', 'YNP', 39),
('STB', 'KMK', 92),
('KMK', 'STB', 92),
('PMK', 'FPR', 72),
('FPR', 'PMK', 72),
('FPR', 'GTK', 33),
('GTK', 'FPR', 33),
('GTK', 'PCH', 77),
('PCH', 'GTK', 77),
('PCH', 'FRM', 34),
('FRM', 'PCH', 34),
('FRM', 'MLT', 45),
('MLT', 'FRM', 45),
('MLT', 'NOV', 39),
('NOV', 'MLT', 39),
('NOV', 'MLB', 12),
('MLB', 'NOV', 12);

INSERT INTO next_station VALUES
( 12625, 'CAP', 'HAT'),
( 12625, 'HAT', 'KHO'),
( 12625, 'KHO', 'MON'),
( 12625, 'MON', 'CAB'),
( 12625, 'CAB', 'KAM'),
( 12625, 'KAM', 'DOC'),
( 12625, 'DOC', 'CAC');

INSERT INTO next_station VALUES
( 12626, 'CAC', 'DOC'),
( 12626, 'DOC', 'KAM'),
( 12626, 'KAM', 'CAB'),
( 12626, 'CAB', 'MON'),
( 12626, 'MON', 'KHO'),
( 12626, 'KHO', 'HAT'),
( 12626, 'HAT', 'CAP');

INSERT INTO next_station VALUES
( 12512, 'CAV', 'QRY'),
( 12512, 'QRY', 'LKW'),
( 12512, 'LKW', 'BHN'),
( 12512, 'BHN', 'MON'),
( 12512, 'MON', 'KHO'),
( 12512, 'KHO', 'TAT'),
( 12512, 'TAT', 'PRT'),
( 12512, 'PRT', 'BTC'),
( 12512, 'BTC', 'PAN'),
( 12512, 'PAN', 'RUN'),
( 12512, 'RUN', 'TMB');

INSERT INTO next_station VALUES
( 22162, 'KMK', 'STB'),
( 22162, 'STB', 'YNP'),
( 22162, 'YNP', 'RZK'),
( 22162, 'RZK', 'PCH'),
( 22162, 'PCH', 'HPT'),
( 22162, 'HPT', 'GPL'),
( 22162, 'GPL', 'ZRK');

INSERT INTO next_station VALUES
( 22486, 'MLB', 'NOV'),
( 22486, 'NOV', 'MLT'),
( 22486, 'MLT', 'FRM'),
( 22486, 'FRM', 'PCH'),
( 22486, 'PCH', 'GTK'),
( 22486, 'GTK', 'FPR'),
( 22486, 'FPR', 'PMK');

INSERT INTO next_station VALUES
( 12511, 'TMB', 'RUN'),
( 12511, 'RUN', 'PAN'),
( 12511, 'PAN', 'BTC'),
( 12511, 'BTC', 'PRT'),
( 12511, 'PRT', 'TAT'),
( 12511, 'TAT', 'KHO'),
( 12511, 'KHO', 'MON'),
( 12511, 'MON', 'BHN'),
( 12511, 'BHN', 'LKW'),
( 12511, 'LKW', 'QRY'),
( 12511, 'QRY', 'CAV');

INSERT INTO next_station VALUES
( 22161, 'ZRK', 'GPL'),
( 22161, 'GPL', 'HPT'),
( 22161, 'HPT', 'PCH'),
( 22161, 'PCH', 'RZK'),
( 22161, 'RZK', 'YNP'),
( 22161, 'YNP', 'STB'),
( 22161, 'STB', 'KMK');

INSERT INTO next_station VALUES
( 22485, 'PMK', 'FPR'),
( 22485, 'FPR', 'GTK'),
( 22485, 'GTK', 'PCH'),
( 22485, 'PCH', 'FRM'),
( 22485, 'FRM', 'MLT'),
( 22485, 'MLT', 'NOV'),
( 22485, 'NOV', 'MLB');


INSERT INTO train VALUES
(12625, 'CAP', 'CAC', 10),
(12626, 'CAC', 'CAP', 10),
(12511, 'TMB', 'CAV', 30),
(12512, 'CAV', 'TMB', 30),
(22161, 'ZRK', 'KMK', 20),
(22162, 'KMK', 'ZRK', 20),
(22485, 'PMK', 'MLB', 40),
(22486, 'MLB', 'PMK', 40);




INSERT INTO path VALUES
( 12625, 'CAP', '01:53:43', '01:58:43', 0),
( 12625, 'HAT', '03:29:43', '03:34:43', 1),
( 12625, 'KHO', '04:56:43', '05:01:43', 2),
( 12625, 'MON', '05:21:43', '05:26:43', 3),
( 12625, 'CAB', '07:04:43', '07:09:43', 4),
( 12625, 'KAM', '07:49:43', '07:54:43', 5),
( 12625, 'DOC', '09:25:43', '09:30:43', 6),
( 12625, 'CAC', '11:07:43', '11:12:43', 7);

INSERT INTO path VALUES
( 12511, 'TMB', '07:40:29', '07:45:29', 0),
( 12511, 'RUN', '09:29:29', '09:34:29', 1),
( 12511, 'PAN', '10:43:29', '10:48:29', 2),
( 12511, 'BTC', '11:24:29', '11:29:29', 3),
( 12511, 'PRT', '11:46:29', '11:51:29', 4),
( 12511, 'TAT', '12:25:29', '12:30:29', 5),
( 12511, 'KHO', '13:10:29', '13:15:29', 6),
( 12511, 'MON', '13:33:29', '13:38:29', 7),
( 12511, 'BHN', '14:53:29', '14:58:29', 8),
( 12511, 'LKW', '16:38:29', '16:43:29', 9),
( 12511, 'QRY', '16:58:29', '17:03:29', 10),
( 12511, 'CAV', '17:38:29', '17:43:29', 11);

INSERT INTO path VALUES
( 22161, 'ZRK', '08:33:29', '08:38:29', 0),
( 22161, 'GPL', '08:56:29', '09:01:29', 1),
( 22161, 'HPT', '10:13:29', '10:18:29', 2),
( 22161, 'PCH', '10:32:29', '10:37:29', 3),
( 22161, 'RZK', '11:13:29', '11:18:29', 4),
( 22161, 'YNP', '11:46:29', '11:51:29', 5),
( 22161, 'STB', '12:46:29', '12:51:29', 6),
( 22161, 'KMK', '14:17:29', '14:22:29', 7);

INSERT INTO path VALUES
( 22485, 'PMK', '10:12:38', '10:17:38', 0),
( 22485, 'FPR', '11:01:38', '11:06:38', 1),
( 22485, 'GTK', '11:53:38', '11:58:38', 2),
( 22485, 'PCH', '12:48:38', '12:53:38', 3),
( 22485, 'FRM', '14:16:38', '14:21:38', 4),
( 22485, 'MLT', '15:06:38', '15:11:38', 5),
( 22485, 'NOV', '16:06:38', '16:11:38', 6),
( 22485, 'MLB', '17:06:38', '17:11:38', 7);

INSERT INTO path VALUES
( 12626, 'CAC', '13:01:36', '13:06:36', 0),
( 12626, 'DOC', '13:33:36', '13:38:36', 1),
( 12626, 'KAM', '13:51:36', '13:56:36', 2),
( 12626, 'CAB', '15:24:36', '15:29:36', 3),
( 12626, 'MON', '15:41:36', '15:46:36', 4),
( 12626, 'KHO', '17:09:36', '17:14:36', 5),
( 12626, 'HAT', '18:50:36', '18:55:36', 6),
( 12626, 'CAP', '19:30:36', '19:35:36', 7);

INSERT INTO path VALUES
( 12512, 'CAV', '00:36:46', '00:41:46', 0),
( 12512, 'QRY', '01:54:46', '01:59:46', 1),
( 12512, 'LKW', '03:31:46', '03:36:46', 2),
( 12512, 'BHN', '04:00:46', '04:05:46', 3),
( 12512, 'MON', '04:16:46', '04:21:46', 4),
( 12512, 'KHO', '04:39:46', '04:44:46', 5),
( 12512, 'TAT', '05:34:46', '05:39:46', 6),
( 12512, 'PRT', '07:02:46', '07:07:46', 7),
( 12512, 'BTC', '07:51:46', '07:56:46', 8),
( 12512, 'PAN', '08:17:46', '08:22:46', 9),
( 12512, 'RUN', '09:17:46', '09:22:46', 10),
( 12512, 'TMB', '10:17:46', '10:22:46', 11);

INSERT INTO path VALUES
( 22162, 'KMK', '06:48:04', '06:53:04', 0),
( 22162, 'STB', '08:02:04', '08:07:04', 1),
( 22162, 'YNP', '08:32:04', '08:37:04', 2),
( 22162, 'RZK', '08:42:04', '08:47:04', 3),
( 22162, 'PCH', '09:15:04', '09:20:04', 4),
( 22162, 'HPT', '11:03:04', '11:08:04', 5),
( 22162, 'GPL', '12:20:04', '12:25:04', 6),
( 22162, 'ZRK', '13:41:04', '13:46:04', 7);

INSERT INTO path VALUES
( 22486, 'MLB', '00:15:21', '00:20:21', 0),
( 22486, 'NOV', '01:04:21', '01:09:21', 1),
( 22486, 'MLT', '01:30:21', '01:35:21', 2),
( 22486, 'FRM', '02:13:21', '02:18:21', 3),
( 22486, 'PCH', '03:55:21', '04:00:21', 4),
( 22486, 'GTK', '04:17:21', '04:22:21', 5),
( 22486, 'FPR', '05:02:21', '05:07:21', 6),
( 22486, 'PMK', '06:02:21', '06:07:21', 7);

INSERT INTO user VALUES
('HYDRA | DYNAMO' , '77a9cb1532a268df233389b762bab5fc', 'Kamlesh', 1234567887654321, 7304709870);

INSERT INTO user VALUES
('SageMadara' , '88a9cb4672a268df278989b762bab5fc', 'Kaushal', 1023456788765401, 8281112731);


INSERT INTO seat_allocation (train_no, running_date, seat_no) VALUES
(12625, '1950-01-26', 1),
(12625, '1950-01-26', 2),
(12625, '1950-01-26', 3),
(12625, '1950-01-26', 4),
(12625, '1950-01-26', 5),
(12625, '1950-01-26', 6),
(12625, '1950-01-26', 7),
(12625, '1950-01-26', 8),
(12625, '1950-01-26', 9),
(12625, '1950-01-26', 10),
(12625, '1947-08-15', 1),
(12625, '1947-08-15', 2),
(12625, '1947-08-15', 3),
(12625, '1947-08-15', 4),
(12625, '1947-08-15', 5),
(12625, '1947-08-15', 6),
(12625, '1947-08-15', 7),
(12625, '1947-08-15', 8),
(12625, '1947-08-15', 9),
(12625, '1947-08-15', 10),
(12626, '1950-01-26', 1),
(12626, '1950-01-26', 2),
(12626, '1950-01-26', 3),
(12626, '1950-01-26', 4),
(12626, '1950-01-26', 5),
(12626, '1950-01-26', 6),
(12626, '1950-01-26', 7),
(12626, '1950-01-26', 8),
(12626, '1950-01-26', 9),
(12626, '1950-01-26', 10),
(12626, '1947-08-15', 1),
(12626, '1947-08-15', 2),
(12626, '1947-08-15', 3),
(12626, '1947-08-15', 4),
(12626, '1947-08-15', 5),
(12626, '1947-08-15', 6),
(12626, '1947-08-15', 7),
(12626, '1947-08-15', 8),
(12626, '1947-08-15', 9),
(12626, '1947-08-15', 10),
(12511, '1950-01-26', 1),
(12511, '1950-01-26', 2),
(12511, '1950-01-26', 3),
(12511, '1950-01-26', 4),
(12511, '1950-01-26', 5),
(12511, '1950-01-26', 6),
(12511, '1950-01-26', 7),
(12511, '1950-01-26', 8),
(12511, '1950-01-26', 9),
(12511, '1950-01-26', 10),
(12511, '1947-08-15', 1),
(12511, '1947-08-15', 2),
(12511, '1947-08-15', 3),
(12511, '1947-08-15', 4),
(12511, '1947-08-15', 5),
(12511, '1947-08-15', 6),
(12511, '1947-08-15', 7),
(12511, '1947-08-15', 8),
(12511, '1947-08-15', 9),
(12511, '1947-08-15', 10),
(12512, '1950-01-26', 1),
(12512, '1950-01-26', 2),
(12512, '1950-01-26', 3),
(12512, '1950-01-26', 4),
(12512, '1950-01-26', 5),
(12512, '1950-01-26', 6),
(12512, '1950-01-26', 7),
(12512, '1950-01-26', 8),
(12512, '1950-01-26', 9),
(12512, '1950-01-26', 10),
(12512, '1947-08-15', 1),
(12512, '1947-08-15', 2),
(12512, '1947-08-15', 3),
(12512, '1947-08-15', 4),
(12512, '1947-08-15', 5),
(12512, '1947-08-15', 6),
(12512, '1947-08-15', 7),
(12512, '1947-08-15', 8),
(12512, '1947-08-15', 9),
(12512, '1947-08-15', 10),
(22161, '1950-01-26', 1),
(22161, '1950-01-26', 2),
(22161, '1950-01-26', 3),
(22161, '1950-01-26', 4),
(22161, '1950-01-26', 5),
(22161, '1950-01-26', 6),
(22161, '1950-01-26', 7),
(22161, '1950-01-26', 8),
(22161, '1950-01-26', 9),
(22161, '1950-01-26', 10),
(22161, '1947-08-15', 1),
(22161, '1947-08-15', 2),
(22161, '1947-08-15', 3),
(22161, '1947-08-15', 4),
(22161, '1947-08-15', 5),
(22161, '1947-08-15', 6),
(22161, '1947-08-15', 7),
(22161, '1947-08-15', 8),
(22161, '1947-08-15', 9),
(22161, '1947-08-15', 10),
(22162, '1950-01-26', 1),
(22162, '1950-01-26', 2),
(22162, '1950-01-26', 3),
(22162, '1950-01-26', 4),
(22162, '1950-01-26', 5),
(22162, '1950-01-26', 6),
(22162, '1950-01-26', 7),
(22162, '1950-01-26', 8),
(22162, '1950-01-26', 9),
(22162, '1950-01-26', 10),
(22162, '1947-08-15', 1),
(22162, '1947-08-15', 2),
(22162, '1947-08-15', 3),
(22162, '1947-08-15', 4),
(22162, '1947-08-15', 5),
(22162, '1947-08-15', 6),
(22162, '1947-08-15', 7),
(22162, '1947-08-15', 8),
(22162, '1947-08-15', 9),
(22162, '1947-08-15', 10),
(22485, '1950-01-26', 1),
(22485, '1950-01-26', 2),
(22485, '1950-01-26', 3),
(22485, '1950-01-26', 4),
(22485, '1950-01-26', 5),
(22485, '1950-01-26', 6),
(22485, '1950-01-26', 7),
(22485, '1950-01-26', 8),
(22485, '1950-01-26', 9),
(22485, '1950-01-26', 10),
(22485, '1947-08-15', 1),
(22485, '1947-08-15', 2),
(22485, '1947-08-15', 3),
(22485, '1947-08-15', 4),
(22485, '1947-08-15', 5),
(22485, '1947-08-15', 6),
(22485, '1947-08-15', 7),
(22485, '1947-08-15', 8),
(22485, '1947-08-15', 9),
(22485, '1947-08-15', 10),
(22486, '1950-01-26', 1),
(22486, '1950-01-26', 2),
(22486, '1950-01-26', 3),
(22486, '1950-01-26', 4),
(22486, '1950-01-26', 5),
(22486, '1950-01-26', 6),
(22486, '1950-01-26', 7),
(22486, '1950-01-26', 8),
(22486, '1950-01-26', 9),
(22486, '1950-01-26', 10),
(22486, '1947-08-15', 1),
(22486, '1947-08-15', 2),
(22486, '1947-08-15', 3),
(22486, '1947-08-15', 4),
(22486, '1947-08-15', 5),
(22486, '1947-08-15', 6),
(22486, '1947-08-15', 7),
(22486, '1947-08-15', 8),
(22486, '1947-08-15', 9),
(22486, '1947-08-15', 10);