
<h1 align="center">MedStats</h1>

<h2 align="center"> MedState is an Open Source Personal Health Journal Website.</h2>

MedStats is an innovative Open Source Website constructed with HTML, CSS, JavaScript, and Bootstrap. This platform serves as a Personal Health Journal, empowering users to maintain a comprehensive digital record of their health-related data. With features designed for tracking health progress, documenting symptoms, and recording medications, MedStats offers a seamless and efficient method for individuals to proactively monitor and manage their well-being.

## Key Features for Contribution:

<ul>
  <li>
    <b>User Registration and Authentication:</b><br>
    Enables users to create accounts and securely log in to access their personal health journal.
  </li>
  <li>
    <b>Interactive Dashboard:</b><br>
    Offers a customized dashboard upon login, presenting users with insightful summaries and statistics pertaining to their health entries.
  </li>
  <li>
    <b>Effortless Health Entries:</b><br>
    Allows users to seamlessly add new journal entries, including detailed information about symptoms, progress, and medications.
  </li>
  <li>
    <b>Comprehensive Symptom Tracker:</b><br>
    Empowers users to record and monitor specific symptoms they're experiencing, providing options to include severity, duration, and additional notes.
  </li>
  <li>
    <b>Intuitive Medication Log:</b><br>
    Facilitates users in listing and managing their medications, specifying dosage, frequency, and any special instructions.
  </li>
  <li>
    <b>Intuitive Calendar View:</b><br>
    Furnishes a calendar view, enabling users to navigate dates and access their health entries for specific days.
  </li>
  <li>
    <b>Efficient Search and Filter Functionality:</b><br>
    Equips users with the ability to search for specific entries or apply filters, streamlining the process of locating pertinent information.
  </li>
  <li>
    <b>Visual Analytics with Graphs and Charts:</b><br>
    Generates visual representations of health trends over time, empowering users to discern patterns or changes in their well-being.
  </li>
  <li>
    <b>Timely Reminders and Notifications:</b><br>
    Enables users to set reminders for medication schedules, appointments, or other health-related tasks, ensuring they stay on track with their healthcare regimen.
  </li>
  
</ul>

These features collectively form a robust platform, enhancing the user's ability to manage and monitor their health effectively.

### Visit the website: [MedStats](https://medstats-health-journal.netlify.app/)

# 📌 Tech Stack

![HTML](https://img.shields.io/badge/html5%20-%23E34F26.svg?&style=for-the-badge&logo=html5&logoColor=white)
![CSS](https://img.shields.io/badge/css3%20-%231572B6.svg?&style=for-the-badge&logo=css3&logoColor=white)
![JS](https://img.shields.io/badge/javascript%20-%23323330.svg?&style=for-the-badge&logo=javascript&logoColor=%23F7DF1E)
<img alt="Bootstrap" src="https://img.shields.io/badge/bootstrap-%23563D7C.svg?style=for-the-badge&logo=bootstrap&logoColor=white"/>

# 📌 Contribution Guidelines 🏗 

Are we missing any of your favorite features, which you think you can add to it❓ We invite you to contribute to this project and make it better. 
To start contributing, follow the below guidelines: 

**1.**  Fork [this](https://github.com/KiranAminPanjwani/MedStats) repository.

**2.**  Clone your forked copy of the project.

```bash
   git clone https://github.com/KiranAminPanjwani/MedStats.git
```

**3.** Navigate to the project directory.
```
   cd MedStats-Website
```

**4.** Create a new branch:
```
   git checkout -b YourBranchName
```

**5.** Make changes in source code.

**6.** Stage your changes and commit

```
   git add .
   git commit -m "<your_commit_message>"
```

**7.** Push your local commits to the remote repo.

```
   git push origin YourBranchName
```

**8.** Create a [PR](https://help.github.com/en/github/collaborating-with-issues-and-pull-requests/creating-a-pull-request)

**9.** If anyone contribute to this repository, then the changes will not reflect in your local repository. For that:

**10.** Setup a reference(remote) to the original repository to get all the changes from the remote.
```
   git remote add upstream  https://github.com/KiranAminPanjwani/MedStats
```

**11.** Check the remotes for this repository.
```
   git remote -v
```

**12.** Fetching from the remote repository will bring in its branches and their respective commits.
```
   git fetch upstream
```

**13.** Make sure that you're on your master branch.
```
   git checkout main
```

**14.** Now that we have fetched the upstream repository, we want to merge its changes into our local branch. This will bring that branch into sync with the upstream, without losing our local changes.
```
   git merge upstream/main
```

# Code of Conduct 📜
	
To maintain a safe and inclusive space for everyone to learn and grow, contributors are advised to follow the [Code of Conduct](./CODE_OF_CONDUCT.md).
	
# Contribution is fun! ❤️

If you have any feedback or suggestions please reach out to me.  

In order to make a hassle-free environment, I implore you all (while contributing) to follow the instructions [Contributing Guidelines](https://github.com/KiranAminPanjwani/MedStats/blob/main/Contributing_Guidlines.md)!

You can create a <a href="https://github.com/KiranAminPanjwani/MedStats/issues">issue</a> and mention there , which new features or extension can make this Project more good.


<!-- ------------------------------------------------------------------------------------------------------------------------------------------------------------------ -->
<br>

<div align="center">

### Show some ❤️ by starring⭐ this awesome Repository!

</div>
  

#

<h1 align=center> OUR VALUABLE CONTRIBUTORS✨ </h1>
<p align="center">
  
	
<a href="https://github.com/KiranAminPanjwani/MedStats/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=KiranAminPanjwani/MedStats" />
</a>
</p>

#
	

<h3 align=center> Project Admin ❤️ </h3>

© 2023 Kiran Amin Panjwani and contributors\
This project is licensed under the [**MIT license**](https://github.com/KiranAminPanjwani/MedStats/blob/main/LICENSE).

[![forthebadge](https://forthebadge.com/images/badges/built-with-love.svg)](https://forthebadge.com)
<a href="#top"><img src="https://img.shields.io/badge/-Back%20to%20Top-red?style=for-the-badge" align="right"/></a>

<p align="center">
<table align="center">
  <tbody><tr>
     <td align="center"><a href="https://github.com/KiranAminPanjwani"><img alt="" src="https://user-images.githubusercontent.com/90326051/192037521-3d5fa306-f642-4ae1-a53c-2054f40e2975.png" width="125px;"><br><sub><b> Kiran Panjwani </b></sub></a><br></td> </a></td>
</tbody></table>

