
import React from 'react'
import { cn } from "@/lib/utils";

export const TopLeftShiningLight: React.FC = () => (
  <svg
    className="absolute top-0 left-0 hidden pointer-events-none md:flex"
    width="579"
    height="511"
    viewBox="0 0 579 511"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
  >
    <g style={{ mixBlendMode: "lighten" }} filter="url(#filter0_f_574_3059)">
      <ellipse
        cx="-5.14484"
        cy="-64.8282"
        rx="32.7783"
        ry="293.346"
        transform="rotate(20.0538 -5.14484 -64.8282)"
        fill="url(#paint0_linear_574_3059)"
        fillOpacity="0.5"
      />
    </g>
    <g style={{ mixBlendMode: "lighten" }} filter="url(#filter2_f_574_3059)">
      <ellipse
        cx="198.822"
        cy="3.50066"
        rx="22.3794"
        ry="381.284"
        transform="rotate(-10 198.822 3.50066)"
        fill="url(#paint2_linear_574_3059)"
        fillOpacity="0.5"
      />
    </g>
    <g style={{ mixBlendMode: "lighten" }} filter="url(#filter3_f_574_3059)">
      <ellipse
        cx="163.986"
        cy="-194.068"
        rx="22.3794"
        ry="180.667"
        transform="rotate(-10 163.986 -194.068)"
        fill="url(#paint3_linear_574_3059)"
        fillOpacity="0.5"
      />
    </g>
    <g style={{ mixBlendMode: "lighten" }} filter="url(#filter4_f_574_3059)">
      <ellipse
        cx="88.5057"
        cy="41.4464"
        rx="22.25"
        ry="381.5"
        transform="rotate(5 88.5057 41.4464)"
        fill="url(#paint4_linear_574_3059)"
        fillOpacity="0.5"
      />
    </g>
    <g style={{ mixBlendMode: "lighten" }} filter="url(#filter5_f_574_3059)">
      <ellipse
        cx="107.823"
        cy="-182.221"
        rx="321.5"
        ry="187.5"
        transform="rotate(5 107.823 -182.221)"
        fill="url(#paint5_linear_574_3059)"
        fillOpacity="0.5"
      />
    </g>
    <defs>
      <filter
        id="filter0_f_574_3059"
        x="-199.369"
        y="-429.622"
        width="388.449"
        height="729.588"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape" />
        <feGaussianBlur stdDeviation="44.5" result="effect1_foregroundBlur_574_3059" />
      </filter>
      <filter
        id="filter1_f_574_3059"
        x="-23.6509"
        y="-457.712"
        width="251.489"
        height="762.287"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape" />
        <feGaussianBlur stdDeviation="44.5" result="effect1_foregroundBlur_574_3059" />
      </filter>
      <filter
        id="filter2_f_574_3059"
        x="40.0224"
        y="-461.011"
        width="317.6"
        height="929.023"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape" />
        <feGaussianBlur stdDeviation="44.5" result="effect1_foregroundBlur_574_3059" />
      </filter>
      <filter
        id="filter3_f_574_3059"
        x="36.6421"
        y="-461.034"
        width="254.687"
        height="533.932"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape" />
        <feGaussianBlur stdDeviation="44.5" result="effect1_foregroundBlur_574_3059" />
      </filter>
      <filter
        id="filter4_f_574_3059"
        x="-40.4595"
        y="-427.607"
        width="257.93"
        height="938.107"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape" />
        <feGaussianBlur stdDeviation="44.5" result="effect1_foregroundBlur_574_3059" />
      </filter>
      <filter
        id="filter5_f_574_3059"
        x="-362.878"
        y="-521.123"
        width="941.402"
        height="677.805"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape" />
        <feGaussianBlur stdDeviation="75" result="effect1_foregroundBlur_574_3059" />
      </filter>
      <linearGradient
        id="paint0_linear_574_3059"
        x1="-5.14484"
        y1="-358.174"
        x2="-5.14484"
        y2="228.517"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" />
        <stop offset="1" stopColor="white" stopOpacity="0" />
      </linearGradient>
      <linearGradient
        id="paint1_linear_574_3059"
        x1="102.094"
        y1="-369.819"
        x2="102.094"
        y2="216.681"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" />
        <stop offset="1" stopColor="white" stopOpacity="0" />
      </linearGradient>
      <linearGradient
        id="paint2_linear_574_3059"
        x1="198.822"
        y1="-377.783"
        x2="198.822"
        y2="384.784"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" />
        <stop offset="1" stopColor="white" stopOpacity="0" />
      </linearGradient>
      <linearGradient
        id="paint3_linear_574_3059"
        x1="163.986"
        y1="-374.736"
        x2="163.986"
        y2="-13.4011"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" />
        <stop offset="1" stopColor="white" stopOpacity="0" />
      </linearGradient>
      <linearGradient
        id="paint4_linear_574_3059"
        x1="88.5057"
        y1="-340.054"
        x2="88.5057"
        y2="422.946"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" />
        <stop offset="1" stopColor="white" stopOpacity="0" />
      </linearGradient>
      <linearGradient
        id="paint5_linear_574_3059"
        x1="107.823"
        y1="-369.721"
        x2="107.823"
        y2="5.27896"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" />
        <stop offset="1" stopColor="white" stopOpacity="0" />
      </linearGradient>
    </defs>
  </svg>
);

export const TopRightShiningLight: React.FC = () => {
  return (
    <svg
      className="absolute top-0 right-0 hidden pointer-events-none md:flex"
      width="900"
      height="699"
      viewBox="0 0 445 699"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <g style={{ mixBlendMode: "lighten" }} filter="url(#filter0_f_574_3050)">
        <ellipse
          cx="336.291"
          cy="119.962"
          rx="32.7783"
          ry="293.346"
          transform="rotate(30.0538 336.291 119.962)"
          fill="url(#paint0_linear_574_3050)"
          fillOpacity="0.5"
        />
      </g>

      <g style={{ mixBlendMode: "lighten" }} filter="url(#filter2_f_574_3050)">
        <ellipse
          cx="525.295"
          cy="222.671"
          rx="22.3794"
          ry="381.284"
          fill="url(#paint2_linear_574_3050)"
          fillOpacity="0.5"
        />
      </g>
      <g style={{ mixBlendMode: "lighten" }} filter="url(#filter3_f_574_3050)">
        <ellipse
          cx="525.295"
          cy="22.0542"
          rx="22.3794"
          ry="180.667"
          fill="url(#paint3_linear_574_3050)"
          fillOpacity="0.5"
        />
      </g>
      <g style={{ mixBlendMode: "lighten" }} filter="url(#filter4_f_574_3050)">
        <ellipse
          cx="410.065"
          cy="240.884"
          rx="22.25"
          ry="381.5"
          transform="rotate(15 410.065 240.884)"
          fill="url(#paint4_linear_574_3050)"
          fillOpacity="0.5"
        />
      </g>
      <g style={{ mixBlendMode: "lighten" }} filter="url(#filter5_f_574_3050)">
        <ellipse
          cx="467.928"
          cy="23.9689"
          rx="321.5"
          ry="187.5"
          transform="rotate(15 467.928 23.9689)"
          fill="url(#paint5_linear_574_3050)"
          fillOpacity="0.5"
        />
      </g>
      <g style={{ mixBlendMode: "lighten" }} filter="url(#filter6_f_574_3050)">
        <ellipse
          cx="491.74"
          cy="-64.8963"
          rx="160.5"
          ry="95.5"
          transform="rotate(15 491.74 -64.8963)"
          fill="url(#paint6_linear_574_3050)"
          fillOpacity="0.5"
        />
      </g>
      <g style={{ mixBlendMode: "lighten" }} filter="url(#filter7_f_574_3050)">
        <ellipse
          cx="489.863"
          cy="-57.8934"
          rx="135"
          ry="80.25"
          transform="rotate(15 489.863 -57.8934)"
          fill="url(#paint7_linear_574_3050)"
          fillOpacity="0.5"
        />
      </g>
      <defs>
        <filter
          id="filter0_f_574_3050"
          x="97.6377"
          y="-223.485"
          width="477.308"
          height="686.892"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape" />
          <feGaussianBlur stdDeviation="44.5" result="effect1_foregroundBlur_574_3050" />
        </filter>
        <filter
          id="filter1_f_574_3050"
          x="274.818"
          y="-245.321"
          width="338.241"
          height="744.685"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape" />
          <feGaussianBlur stdDeviation="44.5" result="effect1_foregroundBlur_574_3050" />
        </filter>
        <filter
          id="filter2_f_574_3050"
          x="413.916"
          y="-247.613"
          width="222.759"
          height="940.567"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape" />
          <feGaussianBlur stdDeviation="44.5" result="effect1_foregroundBlur_574_3050" />
        </filter>
        <filter
          id="filter3_f_574_3050"
          x="413.916"
          y="-247.613"
          width="222.759"
          height="539.335"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape" />
          <feGaussianBlur stdDeviation="44.5" result="effect1_foregroundBlur_574_3050" />
        </filter>
        <filter
          id="filter4_f_574_3050"
          x="219.992"
          y="-216.663"
          width="380.146"
          height="915.093"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape" />
          <feGaussianBlur stdDeviation="44.5" result="effect1_foregroundBlur_574_3050" />
        </filter>
        <filter
          id="filter5_f_574_3050"
          x="3.56885"
          y="-325.391"
          width="928.719"
          height="698.72"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape" />
          <feGaussianBlur stdDeviation="75" result="effect1_foregroundBlur_574_3050" />
        </filter>
        <filter
          id="filter6_f_574_3050"
          x="184.728"
          y="-316.089"
          width="614.024"
          height="502.385"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape" />
          <feGaussianBlur stdDeviation="75" result="effect1_foregroundBlur_574_3050" />
        </filter>
        <filter
          id="filter7_f_574_3050"
          x="207.8"
          y="-292.941"
          width="564.126"
          height="470.095"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape" />
          <feGaussianBlur stdDeviation="75" result="effect1_foregroundBlur_574_3050" />
        </filter>
        <linearGradient
          id="paint0_linear_574_3050"
          x1="336.291"
          y1="-173.384"
          x2="336.291"
          y2="413.307"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="white" />
          <stop offset="1" stopColor="white" stopOpacity="0" />
        </linearGradient>
        <linearGradient
          id="paint1_linear_574_3050"
          x1="443.939"
          y1="-166.229"
          x2="443.939"
          y2="420.271"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="white" />
          <stop offset="1" stopColor="white" stopOpacity="0" />
        </linearGradient>
        <linearGradient
          id="paint2_linear_574_3050"
          x1="525.295"
          y1="-158.613"
          x2="525.295"
          y2="603.955"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="white" />
          <stop offset="1" stopColor="white" stopOpacity="0" />
        </linearGradient>
        <linearGradient
          id="paint3_linear_574_3050"
          x1="525.295"
          y1="-158.613"
          x2="525.295"
          y2="202.721"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="white" />
          <stop offset="1" stopColor="white" stopOpacity="0" />
        </linearGradient>
        <linearGradient
          id="paint4_linear_574_3050"
          x1="410.065"
          y1="-140.616"
          x2="410.065"
          y2="622.384"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="white" />
          <stop offset="1" stopColor="white" stopOpacity="0" />
        </linearGradient>
        <linearGradient
          id="paint5_linear_574_3050"
          x1="467.928"
          y1="-163.531"
          x2="467.928"
          y2="211.469"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="white" />
          <stop offset="1" stopColor="white" stopOpacity="0" />
        </linearGradient>
        <linearGradient
          id="paint6_linear_574_3050"
          x1="491.74"
          y1="-160.396"
          x2="491.74"
          y2="30.6037"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="white" />
          <stop offset="1" stopColor="white" stopOpacity="0" />
        </linearGradient>
        <linearGradient
          id="paint7_linear_574_3050"
          x1="489.863"
          y1="-138.143"
          x2="489.863"
          y2="22.3566"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="white" />
          <stop offset="1" stopColor="white" stopOpacity="0" />
        </linearGradient>
      </defs>
    </svg>
  );
};
export const HeroMainboardStuff: React.FC<{ className: string }> = ({ className }) => (
  <svg
    className={cn("hidden sm:flex pointer-events-none", className)}
    width="1368"
    height="476"
    viewBox="0 0 1368 476"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
  >
    <mask
      id="mask0_574_2323"
      style={{ maskType: "alpha" }}
      maskUnits="userSpaceOnUse"
      x="0"
      y="-70"
      width="1512"
      height="546"
    >
      <rect
        width="1512"
        height="545.25"
        transform="translate(0 -70)"
        fill="url(#paint0_radial_574_2323)"
      />
    </mask>
    <g mask="url(#mask0_574_2323)">
      <rect x="914" y="12" width="21" height="24" rx="3" fill="white" fillOpacity="0.16" />
      <rect x="917" y="26" width="15" height="6" rx="1.5" fill="white" fillOpacity="0.16" />
      <rect x="550" y="206" width="2" height="8" fill="white" fillOpacity="0.18" />
      <rect x="554" y="206" width="2" height="8" fill="white" fillOpacity="0.18" />
      <rect x="545" y="209" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="545" y="209" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="550" y="206" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="554" y="206" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="569" y="206" width="2" height="8" fill="white" fillOpacity="0.18" />
      <rect x="573" y="206" width="2" height="8" fill="white" fillOpacity="0.18" />
      <rect x="564" y="209" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="564" y="209" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="569" y="206" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="573" y="206" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="588" y="206" width="2" height="8" fill="white" fillOpacity="0.18" />
      <rect x="592" y="206" width="2" height="8" fill="white" fillOpacity="0.18" />
      <rect x="583" y="209" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="583" y="209" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="588" y="206" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="592" y="206" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="588" y="190" width="2" height="8" fill="white" fillOpacity="0.18" />
      <rect x="592" y="190" width="2" height="8" fill="white" fillOpacity="0.18" />
      <rect x="583" y="193" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="583" y="193" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="588" y="190" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="592" y="190" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="615" y="6" width="2" height="8" fill="white" fillOpacity="0.18" />
      <rect x="619" y="6" width="2" height="8" fill="white" fillOpacity="0.18" />
      <rect x="610" y="9" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="610" y="9" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="615" y="6" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="619" y="6" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1339" y="32" width="2" height="8" fill="white" fillOpacity="0.18" />
      <rect x="1343" y="32" width="2" height="8" fill="white" fillOpacity="0.18" />
      <rect x="1334" y="35" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="1334" y="35" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1339" y="32" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1343" y="32" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="634" y="6" width="2" height="8" fill="white" fillOpacity="0.18" />
      <rect x="638" y="6" width="2" height="8" fill="white" fillOpacity="0.18" />
      <rect x="629" y="9" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="629" y="9" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="634" y="6" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="638" y="6" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1358" y="32" width="2" height="8" fill="white" fillOpacity="0.18" />
      <rect x="1362" y="32" width="2" height="8" fill="white" fillOpacity="0.18" />
      <rect x="1353" y="35" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="1353" y="35" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1358" y="32" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1362" y="32" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="653" y="6" width="2" height="8" fill="white" fillOpacity="0.18" />
      <rect x="657" y="6" width="2" height="8" fill="white" fillOpacity="0.18" />
      <rect x="648" y="9" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="648" y="9" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="653" y="6" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="657" y="6" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="810" y="290" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="810" y="290" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="810" y="300" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="810" y="300" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="811" y="294" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="811" y="294" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="815" y="294" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="815" y="294" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="327" y="205" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="327" y="205" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="327" y="215" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="327" y="215" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="328" y="209" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="328" y="209" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="332" y="209" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="332" y="209" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1348" y="344" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="1348" y="344" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1348" y="354" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="1348" y="354" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1349" y="348" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="1349" y="348" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1353" y="348" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="1353" y="348" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="794" y="290" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="794" y="290" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="794" y="300" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="794" y="300" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="795" y="294" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="795" y="294" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="799" y="294" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="799" y="294" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="311" y="205" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="311" y="205" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="311" y="215" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="311" y="215" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="312" y="209" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="312" y="209" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="316" y="209" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="316" y="209" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1332" y="344" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="1332" y="344" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1332" y="354" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="1332" y="354" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1333" y="348" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="1333" y="348" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1337" y="348" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="1337" y="348" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="778" y="290" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="778" y="290" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="778" y="300" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="778" y="300" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="779" y="294" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="779" y="294" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="783" y="294" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="783" y="294" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="295" y="205" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="295" y="205" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="295" y="215" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="295" y="215" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="296" y="209" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="296" y="209" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="300" y="209" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="300" y="209" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1316" y="344" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="1316" y="344" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1316" y="354" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="1316" y="354" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1317" y="348" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="1317" y="348" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1321" y="348" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="1321" y="348" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="716" y="41" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="716" y="41" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="716" y="51" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="716" y="51" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="717" y="45" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="717" y="45" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="721" y="45" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="721" y="45" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="496" y="251" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="496" y="251" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="496" y="261" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="496" y="261" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="497" y="255" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="497" y="255" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="501" y="255" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="501" y="255" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1216" y="131" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="1216" y="131" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1216" y="141" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="1216" y="141" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1217" y="135" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="1217" y="135" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1221" y="135" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="1221" y="135" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1216" y="151" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="1216" y="151" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1216" y="161" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="1216" y="161" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1217" y="155" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="1217" y="155" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1221" y="155" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="1221" y="155" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1232" y="131" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="1232" y="131" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1232" y="141" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="1232" y="141" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1233" y="135" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="1233" y="135" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1237" y="135" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="1237" y="135" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="512" y="251" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="512" y="251" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="512" y="261" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="512" y="261" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="513" y="255" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="513" y="255" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="517" y="255" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="517" y="255" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="496" y="271" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="496" y="271" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="496" y="281" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="496" y="281" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="497" y="275" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="497" y="275" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="501" y="275" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="501" y="275" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="664" y="289" width="8" height="8" fill="white" fillOpacity="0.14" />
      <rect
        x="664.25"
        y="289.25"
        width="7.5"
        height="7.5"
        stroke="white"
        strokeOpacity="0.08"
        strokeWidth="0.5"
      />
      <rect x="668" y="293" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect
        x="660.25"
        y="285.25"
        width="15.5"
        height="15.5"
        stroke="white"
        strokeOpacity="0.08"
        strokeWidth="0.5"
      />
      <rect x="751" y="56" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="757" y="56" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="751" y="62" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="757" y="62" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="751" y="68" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="757" y="68" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="751" y="74" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="757" y="74" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="751" y="80" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="757" y="80" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="668" y="251" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect
        x="660.25"
        y="243.25"
        width="15.5"
        height="15.5"
        stroke="white"
        strokeOpacity="0.08"
        strokeWidth="0.5"
      />
      <rect x="664" y="247" width="8" height="8" fill="white" fillOpacity="0.14" />
      <rect
        x="664.25"
        y="247.25"
        width="7.5"
        height="7.5"
        stroke="white"
        strokeOpacity="0.08"
        strokeWidth="0.5"
      />
      <rect x="1353" y="130" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect
        x="1345.25"
        y="122.25"
        width="15.5"
        height="15.5"
        stroke="white"
        strokeOpacity="0.08"
        strokeWidth="0.5"
      />
      <rect x="1349" y="126" width="8" height="8" fill="white" fillOpacity="0.14" />
      <rect
        x="1349.25"
        y="126.25"
        width="7.5"
        height="7.5"
        stroke="white"
        strokeOpacity="0.08"
        strokeWidth="0.5"
      />
      <rect x="671" y="143" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="676" y="143" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="681" y="143" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="686" y="143" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="691" y="143" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="696" y="143" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="914" y="78" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="919" y="78" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="924" y="78" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="929" y="78" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="934" y="78" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="939" y="78" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="910" y="357" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="915" y="357" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="920" y="357" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="925" y="357" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="930" y="357" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="935" y="357" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="1216" y="339" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="1221" y="339" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="1226" y="339" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="1231" y="339" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="1236" y="339" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="1241" y="339" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="1024" y="9" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="1029" y="9" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="1034" y="9" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="1039" y="9" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="1044" y="9" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="1049" y="9" width="2" height="6" fill="white" fillOpacity="0.18" />
      <path d="M736.25 28.25H591.25V-50" stroke="white" strokeOpacity="0.06" strokeWidth="0.5" />
      <g clipPath="url(#clip0_574_2323)">
        <path
          d="M518 316C523.333 310.667 626.889 207.111 678 156"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M526 316C531.333 310.667 634.889 207.111 686 156"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M534 316C539.333 310.667 642.889 207.111 694 156"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M542 316C547.333 310.667 650.889 207.111 702 156"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M550 316C555.333 310.667 658.889 207.111 710 156"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M558 316C563.333 310.667 666.889 207.111 718 156"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M566 316C571.333 310.667 674.889 207.111 726 156"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M574 316C579.333 310.667 682.889 207.111 734 156"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M582 316C587.333 310.667 690.889 207.111 742 156"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M590 316C595.333 310.667 698.889 207.111 750 156"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M598 316C603.333 310.667 706.889 207.111 758 156"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M606 316C611.333 310.667 714.889 207.111 766 156"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M614 316C619.333 310.667 722.889 207.111 774 156"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M622 316C627.333 310.667 730.889 207.111 782 156"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
      </g>
      <g clipPath="url(#clip1_574_2323)">
        <path
          d="M769 376C774.333 370.667 877.889 267.111 929 216"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M777 376C782.333 370.667 885.889 267.111 937 216"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M785 376C790.333 370.667 893.889 267.111 945 216"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M793 376C798.333 370.667 901.889 267.111 953 216"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M801 376C806.333 370.667 909.889 267.111 961 216"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M809 376C814.333 370.667 917.889 267.111 969 216"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M817 376C822.333 370.667 925.889 267.111 977 216"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M825 376C830.333 370.667 933.889 267.111 985 216"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M833 376C838.333 370.667 941.889 267.111 993 216"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M841 376C846.333 370.667 949.889 267.111 1001 216"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M849 376C854.333 370.667 957.889 267.111 1009 216"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M857 376C862.333 370.667 965.889 267.111 1017 216"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M865 376C870.333 370.667 973.889 267.111 1025 216"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M873 376C878.333 370.667 981.889 267.111 1033 216"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
      </g>
      <path
        d="M802 229.25H263.604C259.69 229.25 257.734 229.25 255.892 228.808C254.26 228.416 252.699 227.77 251.267 226.892C249.653 225.903 248.269 224.519 245.502 221.752L0 -23.75"
        stroke="white"
        strokeOpacity="0.08"
        strokeWidth="0.5"
      />
      <path
        d="M711 129.25H602.604C598.69 129.25 596.734 129.25 594.892 129.692C593.26 130.084 591.699 130.73 590.267 131.608C588.653 132.597 587.269 133.981 584.502 136.748L492 229.25"
        stroke="white"
        strokeOpacity="0.08"
        strokeWidth="0.5"
      />
      <path
        d="M830 314.25H493.604C489.69 314.25 487.734 314.25 485.892 313.808C484.26 313.416 482.699 312.77 481.267 311.892C479.653 310.903 478.269 309.519 475.502 306.752L398 229.25"
        stroke="white"
        strokeOpacity="0.08"
        strokeWidth="0.5"
      />
      <path d="M802 95.25H711.25V229" stroke="white" strokeOpacity="0.08" strokeWidth="0.5" />
      <path
        d="M281.25 229V175.25H441.25V229"
        stroke="white"
        strokeOpacity="0.08"
        strokeWidth="0.5"
      />
      <rect x="419" y="190" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="425" y="190" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="419" y="196" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="425" y="196" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="419" y="202" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="425" y="202" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="419" y="208" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="425" y="208" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="419" y="214" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="425" y="214" width="2" height="2" fill="white" fillOpacity="0.18" />
      <path d="M1380 325.25H1202.25V459" stroke="white" strokeOpacity="0.08" strokeWidth="0.5" />
      <path d="M1512 422.25H1334.25V475" stroke="white" strokeOpacity="0.08" strokeWidth="0.5" />
      <path d="M1262.25 475.25H1440" stroke="white" strokeOpacity="0.08" strokeWidth="0.5" />
      <path d="M711.5 144.25H765" stroke="white" strokeOpacity="0.08" strokeWidth="0.5" />
      <rect opacity="0.02" x="714" y="147" width="49" height="79" rx="0.5" fill="white" />
      <rect opacity="0.05" x="716" y="149" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="716" y="155" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="716" y="161" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="716" y="167" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="716" y="173" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.1" x="716" y="179" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="716" y="185" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="716" y="191" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="716" y="197" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="716" y="203" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="716" y="209" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="716" y="215" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="716" y="221" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="723" y="149" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.15" x="723" y="155" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="723" y="161" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="723" y="167" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="723" y="173" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="723" y="179" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="723" y="185" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="723" y="191" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="723" y="197" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.15" x="723" y="203" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="723" y="209" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="723" y="215" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="723" y="221" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="730" y="149" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="730" y="155" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="730" y="161" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="730" y="167" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.1" x="730" y="173" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="730" y="179" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="730" y="185" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="730" y="191" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="730" y="197" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="730" y="203" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.1" x="730" y="209" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="730" y="215" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="730" y="221" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="737" y="149" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="737" y="155" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="737" y="161" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="737" y="167" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="737" y="173" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="737" y="179" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="737" y="185" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="737" y="191" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="737" y="197" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="737" y="203" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="737" y="209" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="737" y="215" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="737" y="221" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="744" y="149" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="744" y="155" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="744" y="161" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.1" x="744" y="167" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="744" y="173" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="744" y="179" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.1" x="744" y="185" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="744" y="191" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="744" y="197" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="744" y="203" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="744" y="209" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="744" y="215" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="744" y="221" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="751" y="149" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.1" x="751" y="155" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="751" y="161" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="751" y="167" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="751" y="173" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="751" y="179" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="751" y="185" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="751" y="191" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.1" x="751" y="197" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="751" y="203" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="751" y="209" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="751" y="215" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="751" y="221" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="758" y="149" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="758" y="155" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="758" y="161" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="758" y="167" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="758" y="173" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="758" y="179" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="758" y="185" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="758" y="191" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="758" y="197" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="758" y="203" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="758" y="209" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="758" y="215" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.15" x="758" y="221" width="3" height="3" rx="0.5" fill="white" />
      <path d="M765.25 95.5V229" stroke="white" strokeOpacity="0.08" strokeWidth="0.5" />
      <path
        d="M1014.25 192.25H917.25V143.5"
        stroke="white"
        strokeOpacity="0.08"
        strokeWidth="0.5"
      />
      <path
        d="M1374.25 149.25H1277.25V20.5"
        stroke="white"
        strokeOpacity="0.08"
        strokeWidth="0.5"
      />
      <path
        d="M830.25 268V346.25H947.25V424"
        stroke="white"
        strokeOpacity="0.08"
        strokeWidth="0.5"
      />
      <path d="M901 0V95" stroke="white" strokeOpacity="0.04" strokeWidth="2" />
      <path d="M737 0V95" stroke="white" strokeOpacity="0.04" strokeWidth="2" />
      <path d="M647 229.5V314" stroke="white" strokeOpacity="0.04" strokeWidth="2" />
      <path d="M689 229.5V314" stroke="white" strokeOpacity="0.04" strokeWidth="2" />
      <path d="M1268 325.5V410" stroke="white" strokeOpacity="0.04" strokeWidth="2" />
      <path d="M759 314.5V428" stroke="white" strokeOpacity="0.04" strokeWidth="2" />
      <path
        d="M858 95.25H982.378C984.348 95.25 985.333 95.25 986.28 95.0658C987.119 94.9023 987.935 94.6316 988.706 94.2605C989.575 93.8423 990.364 93.2533 991.944 92.0753L1009.1 79.2766C1010.99 77.8691 1011.93 77.1654 1012.61 76.2719C1013.22 75.4805 1013.67 74.5836 1013.94 73.6273C1014.25 72.5475 1014.25 71.3705 1014.25 69.0164V0"
        stroke="white"
        strokeOpacity="0.08"
        strokeWidth="0.5"
      />
      <path d="M1014 25.25H1090.25V-70" stroke="white" strokeOpacity="0.08" strokeWidth="0.5" />
      <path
        d="M963.25 95.25V143.25H886.25V95.25"
        stroke="white"
        strokeOpacity="0.08"
        strokeWidth="0.5"
      />
      <rect opacity="0.02" x="890" y="98" width="70" height="42" rx="0.5" fill="white" />
      <rect opacity="0.05" x="891" y="100" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="891" y="107" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="891" y="114" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="891" y="121" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="891" y="128" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="891" y="135" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="899" y="100" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="899" y="107" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.1" x="899" y="114" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="899" y="121" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="899" y="128" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="899" y="135" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="907" y="100" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="907" y="107" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="907" y="114" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="907" y="121" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="907" y="128" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.15" x="907" y="135" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.1" x="915" y="100" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="915" y="107" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="915" y="114" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="915" y="121" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="915" y="128" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="915" y="135" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="923" y="100" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="923" y="107" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="923" y="114" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.15" x="923" y="121" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="923" y="128" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="923" y="135" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="931" y="100" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="931" y="107" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="931" y="114" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="931" y="121" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="931" y="128" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="931" y="135" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="939" y="100" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="939" y="107" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.15" x="939" y="114" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="939" y="121" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="939" y="128" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="939" y="135" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.1" x="947" y="100" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="947" y="107" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="947" y="114" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="947" y="121" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="947" y="128" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.1" x="947" y="135" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="955" y="100" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="955" y="107" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="955" y="114" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="955" y="121" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="955" y="128" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="955" y="135" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.02" x="1340" y="428" width="70" height="42" rx="0.5" fill="white" />
      <rect opacity="0.05" x="1341" y="430" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="1341" y="437" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="1341" y="444" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="1341" y="451" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="1341" y="458" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="1341" y="465" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="1349" y="430" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="1349" y="437" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.1" x="1349" y="444" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="1349" y="451" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="1349" y="458" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="1349" y="465" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="1357" y="430" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="1357" y="437" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="1357" y="444" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="1357" y="451" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="1357" y="458" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.15" x="1357" y="465" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.1" x="1365" y="430" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="1365" y="437" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="1365" y="444" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="1365" y="451" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="1365" y="458" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="1365" y="465" width="3" height="3" rx="0.5" fill="white" />
      <path
        d="M1370 20H1196.59C1192.68 20 1190.73 20 1188.89 20.4407C1187.26 20.8314 1185.7 21.4758 1184.27 22.3505C1182.65 23.3369 1181.27 24.7164 1178.51 27.4755L1093.27 112.498C1090.5 115.267 1089.11 116.651 1088.12 118.267C1087.24 119.7 1086.59 121.263 1086.19 122.898C1085.75 124.742 1085.75 126.702 1085.75 130.623V163.75"
        stroke="white"
        strokeOpacity="0.3"
        strokeWidth="0.5"
      />
      <g filter="url(#filter0_b_574_2323)">
        <path
          d="M1084.5 160.8C1084.5 160.52 1084.5 160.38 1084.55 160.273C1084.6 160.179 1084.68 160.102 1084.77 160.054C1084.88 160 1085.02 160 1085.3 160H1086.2C1086.48 160 1086.62 160 1086.73 160.054C1086.82 160.102 1086.9 160.179 1086.95 160.273C1087 160.38 1087 160.52 1087 160.8V164H1084.5V160.8Z"
          fill="black"
        />
        <path
          d="M1084.5 160.8C1084.5 160.52 1084.5 160.38 1084.55 160.273C1084.6 160.179 1084.68 160.102 1084.77 160.054C1084.88 160 1085.02 160 1085.3 160H1086.2C1086.48 160 1086.62 160 1086.73 160.054C1086.82 160.102 1086.9 160.179 1086.95 160.273C1087 160.38 1087 160.52 1087 160.8V164H1084.5V160.8Z"
          fill="url(#paint1_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <path d="M822.25 200V119" stroke="white" strokeOpacity="0.3" strokeWidth="0.5" />
      <path d="M822.25 200V119" stroke="url(#paint2_angular_574_2323)" strokeWidth="0.5" />
      <path d="M837.75 200V119" stroke="white" strokeOpacity="0.3" strokeWidth="0.5" />
      <g filter="url(#filter1_b_574_2323)">
        <path
          d="M821 200.8C821 200.52 821 200.38 821.054 200.273C821.102 200.179 821.179 200.102 821.273 200.054C821.38 200 821.52 200 821.8 200H822.7C822.98 200 823.12 200 823.227 200.054C823.321 200.102 823.398 200.179 823.446 200.273C823.5 200.38 823.5 200.52 823.5 200.8V204H821V200.8Z"
          fill="black"
        />
        <path
          d="M821 200.8C821 200.52 821 200.38 821.054 200.273C821.102 200.179 821.179 200.102 821.273 200.054C821.38 200 821.52 200 821.8 200H822.7C822.98 200 823.12 200 823.227 200.054C823.321 200.102 823.398 200.179 823.446 200.273C823.5 200.38 823.5 200.52 823.5 200.8V204H821V200.8Z"
          fill="url(#paint3_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <g filter="url(#filter2_b_574_2323)">
        <path
          d="M836.5 200.8C836.5 200.52 836.5 200.38 836.554 200.273C836.602 200.179 836.679 200.102 836.773 200.054C836.88 200 837.02 200 837.3 200H838.2C838.48 200 838.62 200 838.727 200.054C838.821 200.102 838.898 200.179 838.946 200.273C839 200.38 839 200.52 839 200.8V204H836.5V200.8Z"
          fill="black"
        />
        <path
          d="M836.5 200.8C836.5 200.52 836.5 200.38 836.554 200.273C836.602 200.179 836.679 200.102 836.773 200.054C836.88 200 837.02 200 837.3 200H838.2C838.48 200 838.62 200 838.727 200.054C838.821 200.102 838.898 200.179 838.946 200.273C839 200.38 839 200.52 839 200.8V204H836.5V200.8Z"
          fill="url(#paint4_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <g filter="url(#filter3_b_574_2323)">
        <path
          d="M821 115H823.5V118.2C823.5 118.48 823.5 118.62 823.446 118.727C823.398 118.821 823.321 118.898 823.227 118.946C823.12 119 822.98 119 822.7 119H821.8C821.52 119 821.38 119 821.273 118.946C821.179 118.898 821.102 118.821 821.054 118.727C821 118.62 821 118.48 821 118.2V115Z"
          fill="black"
        />
        <path
          d="M821 115H823.5V118.2C823.5 118.48 823.5 118.62 823.446 118.727C823.398 118.821 823.321 118.898 823.227 118.946C823.12 119 822.98 119 822.7 119H821.8C821.52 119 821.38 119 821.273 118.946C821.179 118.898 821.102 118.821 821.054 118.727C821 118.62 821 118.48 821 118.2V115Z"
          fill="url(#paint5_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <g filter="url(#filter4_b_574_2323)">
        <path
          d="M836.5 115H839V118.2C839 118.48 839 118.62 838.946 118.727C838.898 118.821 838.821 118.898 838.727 118.946C838.62 119 838.48 119 838.2 119H837.3C837.02 119 836.88 119 836.773 118.946C836.679 118.898 836.602 118.821 836.554 118.727C836.5 118.62 836.5 118.48 836.5 118.2V115Z"
          fill="black"
        />
        <path
          d="M836.5 115H839V118.2C839 118.48 839 118.62 838.946 118.727C838.898 118.821 838.821 118.898 838.727 118.946C838.62 119 838.48 119 838.2 119H837.3C837.02 119 836.88 119 836.773 118.946C836.679 118.898 836.602 118.821 836.554 118.727C836.5 118.62 836.5 118.48 836.5 118.2V115Z"
          fill="url(#paint6_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <path d="M1101.25 428V312" stroke="white" strokeOpacity="0.15" strokeWidth="0.5" />
      <path d="M1091.25 428V312" stroke="white" strokeOpacity="0.15" strokeWidth="0.5" />
      <path d="M1081.25 428V312" stroke="white" strokeOpacity="0.15" strokeWidth="0.5" />
      <path
        d="M1081.25 428V312"
        stroke="url(#paint7_angular_574_2323)"
        strokeOpacity="0.3"
        strokeWidth="0.5"
      />
      <path d="M1071.25 428V312" stroke="white" strokeOpacity="0.15" strokeWidth="0.5" />
      <path d="M1061.25 428V312" stroke="white" strokeOpacity="0.15" strokeWidth="0.5" />
      <path d="M1061.25 428V312" stroke="url(#paint8_angular_574_2323)" strokeWidth="0.5" />
      <path d="M1110.75 428V312" stroke="white" strokeOpacity="0.15" strokeWidth="0.5" />
      <path d="M1110.75 428V312" stroke="url(#paint9_angular_574_2323)" strokeWidth="0.5" />
      <g filter="url(#filter5_b_574_2323)">
        <path
          d="M1100 308H1102.5V311.2C1102.5 311.48 1102.5 311.62 1102.45 311.727C1102.4 311.821 1102.32 311.898 1102.23 311.946C1102.12 312 1101.98 312 1101.7 312H1100.8C1100.52 312 1100.38 312 1100.27 311.946C1100.18 311.898 1100.1 311.821 1100.05 311.727C1100 311.62 1100 311.48 1100 311.2V308Z"
          fill="black"
        />
        <path
          d="M1100 308H1102.5V311.2C1102.5 311.48 1102.5 311.62 1102.45 311.727C1102.4 311.821 1102.32 311.898 1102.23 311.946C1102.12 312 1101.98 312 1101.7 312H1100.8C1100.52 312 1100.38 312 1100.27 311.946C1100.18 311.898 1100.1 311.821 1100.05 311.727C1100 311.62 1100 311.48 1100 311.2V308Z"
          fill="url(#paint10_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <g filter="url(#filter6_b_574_2323)">
        <path
          d="M1090 308H1092.5V311.2C1092.5 311.48 1092.5 311.62 1092.45 311.727C1092.4 311.821 1092.32 311.898 1092.23 311.946C1092.12 312 1091.98 312 1091.7 312H1090.8C1090.52 312 1090.38 312 1090.27 311.946C1090.18 311.898 1090.1 311.821 1090.05 311.727C1090 311.62 1090 311.48 1090 311.2V308Z"
          fill="black"
        />
        <path
          d="M1090 308H1092.5V311.2C1092.5 311.48 1092.5 311.62 1092.45 311.727C1092.4 311.821 1092.32 311.898 1092.23 311.946C1092.12 312 1091.98 312 1091.7 312H1090.8C1090.52 312 1090.38 312 1090.27 311.946C1090.18 311.898 1090.1 311.821 1090.05 311.727C1090 311.62 1090 311.48 1090 311.2V308Z"
          fill="url(#paint11_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <g filter="url(#filter7_b_574_2323)">
        <path
          d="M1080 308H1082.5V311.2C1082.5 311.48 1082.5 311.62 1082.45 311.727C1082.4 311.821 1082.32 311.898 1082.23 311.946C1082.12 312 1081.98 312 1081.7 312H1080.8C1080.52 312 1080.38 312 1080.27 311.946C1080.18 311.898 1080.1 311.821 1080.05 311.727C1080 311.62 1080 311.48 1080 311.2V308Z"
          fill="black"
        />
        <path
          d="M1080 308H1082.5V311.2C1082.5 311.48 1082.5 311.62 1082.45 311.727C1082.4 311.821 1082.32 311.898 1082.23 311.946C1082.12 312 1081.98 312 1081.7 312H1080.8C1080.52 312 1080.38 312 1080.27 311.946C1080.18 311.898 1080.1 311.821 1080.05 311.727C1080 311.62 1080 311.48 1080 311.2V308Z"
          fill="url(#paint12_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <g filter="url(#filter8_b_574_2323)">
        <path
          d="M1070 308H1072.5V311.2C1072.5 311.48 1072.5 311.62 1072.45 311.727C1072.4 311.821 1072.32 311.898 1072.23 311.946C1072.12 312 1071.98 312 1071.7 312H1070.8C1070.52 312 1070.38 312 1070.27 311.946C1070.18 311.898 1070.1 311.821 1070.05 311.727C1070 311.62 1070 311.48 1070 311.2V308Z"
          fill="black"
        />
        <path
          d="M1070 308H1072.5V311.2C1072.5 311.48 1072.5 311.62 1072.45 311.727C1072.4 311.821 1072.32 311.898 1072.23 311.946C1072.12 312 1071.98 312 1071.7 312H1070.8C1070.52 312 1070.38 312 1070.27 311.946C1070.18 311.898 1070.1 311.821 1070.05 311.727C1070 311.62 1070 311.48 1070 311.2V308Z"
          fill="url(#paint13_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <g filter="url(#filter9_b_574_2323)">
        <path
          d="M1060 308H1062.5V311.2C1062.5 311.48 1062.5 311.62 1062.45 311.727C1062.4 311.821 1062.32 311.898 1062.23 311.946C1062.12 312 1061.98 312 1061.7 312H1060.8C1060.52 312 1060.38 312 1060.27 311.946C1060.18 311.898 1060.1 311.821 1060.05 311.727C1060 311.62 1060 311.48 1060 311.2V308Z"
          fill="black"
        />
        <path
          d="M1060 308H1062.5V311.2C1062.5 311.48 1062.5 311.62 1062.45 311.727C1062.4 311.821 1062.32 311.898 1062.23 311.946C1062.12 312 1061.98 312 1061.7 312H1060.8C1060.52 312 1060.38 312 1060.27 311.946C1060.18 311.898 1060.1 311.821 1060.05 311.727C1060 311.62 1060 311.48 1060 311.2V308Z"
          fill="url(#paint14_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <g filter="url(#filter10_b_574_2323)">
        <path
          d="M1109.5 308H1112V311.2C1112 311.48 1112 311.62 1111.95 311.727C1111.9 311.821 1111.82 311.898 1111.73 311.946C1111.62 312 1111.48 312 1111.2 312H1110.3C1110.02 312 1109.88 312 1109.77 311.946C1109.68 311.898 1109.6 311.821 1109.55 311.727C1109.5 311.62 1109.5 311.48 1109.5 311.2V308Z"
          fill="black"
        />
        <path
          d="M1109.5 308H1112V311.2C1112 311.48 1112 311.62 1111.95 311.727C1111.9 311.821 1111.82 311.898 1111.73 311.946C1111.62 312 1111.48 312 1111.2 312H1110.3C1110.02 312 1109.88 312 1109.77 311.946C1109.68 311.898 1109.6 311.821 1109.55 311.727C1109.5 311.62 1109.5 311.48 1109.5 311.2V308Z"
          fill="url(#paint15_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <path
        d="M1014 226.25H858"
        stroke="url(#paint16_linear_574_2323)"
        strokeOpacity="0.3"
        strokeWidth="0.5"
      />
      <path d="M1014 226.25H858" stroke="url(#paint17_angular_574_2323)" strokeWidth="0.5" />
      <path
        d="M1014 235.25H858"
        stroke="url(#paint18_linear_574_2323)"
        strokeOpacity="0.3"
        strokeWidth="0.5"
      />
      <path d="M1014 235.25H858" stroke="url(#paint19_angular_574_2323)" strokeWidth="0.5" />
      <path
        d="M1014 244.25H858"
        stroke="url(#paint20_linear_574_2323)"
        strokeOpacity="0.3"
        strokeWidth="0.5"
      />
      <path d="M1014 244.25H858" stroke="url(#paint21_angular_574_2323)" strokeWidth="0.5" />
      <g filter="url(#filter11_b_574_2323)">
        <path
          d="M1010 225.8C1010 225.52 1010 225.38 1010.05 225.273C1010.1 225.179 1010.18 225.102 1010.27 225.054C1010.38 225 1010.52 225 1010.8 225H1014V227.5H1010.8C1010.52 227.5 1010.38 227.5 1010.27 227.446C1010.18 227.398 1010.1 227.321 1010.05 227.227C1010 227.12 1010 226.98 1010 226.7V225.8Z"
          fill="black"
        />
        <path
          d="M1010 225.8C1010 225.52 1010 225.38 1010.05 225.273C1010.1 225.179 1010.18 225.102 1010.27 225.054C1010.38 225 1010.52 225 1010.8 225H1014V227.5H1010.8C1010.52 227.5 1010.38 227.5 1010.27 227.446C1010.18 227.398 1010.1 227.321 1010.05 227.227C1010 227.12 1010 226.98 1010 226.7V225.8Z"
          fill="url(#paint22_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <g filter="url(#filter12_b_574_2323)">
        <path
          d="M1010 234.8C1010 234.52 1010 234.38 1010.05 234.273C1010.1 234.179 1010.18 234.102 1010.27 234.054C1010.38 234 1010.52 234 1010.8 234H1014V236.5H1010.8C1010.52 236.5 1010.38 236.5 1010.27 236.446C1010.18 236.398 1010.1 236.321 1010.05 236.227C1010 236.12 1010 235.98 1010 235.7V234.8Z"
          fill="black"
        />
        <path
          d="M1010 234.8C1010 234.52 1010 234.38 1010.05 234.273C1010.1 234.179 1010.18 234.102 1010.27 234.054C1010.38 234 1010.52 234 1010.8 234H1014V236.5H1010.8C1010.52 236.5 1010.38 236.5 1010.27 236.446C1010.18 236.398 1010.1 236.321 1010.05 236.227C1010 236.12 1010 235.98 1010 235.7V234.8Z"
          fill="url(#paint23_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <g filter="url(#filter13_b_574_2323)">
        <path
          d="M1010 244.8C1010 244.52 1010 244.38 1010.05 244.273C1010.1 244.179 1010.18 244.102 1010.27 244.054C1010.38 244 1010.52 244 1010.8 244H1014V246.5H1010.8C1010.52 246.5 1010.38 246.5 1010.27 246.446C1010.18 246.398 1010.1 246.321 1010.05 246.227C1010 246.12 1010 245.98 1010 245.7V244.8Z"
          fill="black"
        />
        <path
          d="M1010 244.8C1010 244.52 1010 244.38 1010.05 244.273C1010.1 244.179 1010.18 244.102 1010.27 244.054C1010.38 244 1010.52 244 1010.8 244H1014V246.5H1010.8C1010.52 246.5 1010.38 246.5 1010.27 246.446C1010.18 246.398 1010.1 246.321 1010.05 246.227C1010 246.12 1010 245.98 1010 245.7V244.8Z"
          fill="url(#paint24_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <g filter="url(#filter14_b_574_2323)">
        <path
          d="M858 225H861.2C861.48 225 861.62 225 861.727 225.054C861.821 225.102 861.898 225.179 861.946 225.273C862 225.38 862 225.52 862 225.8V226.7C862 226.98 862 227.12 861.946 227.227C861.898 227.321 861.821 227.398 861.727 227.446C861.62 227.5 861.48 227.5 861.2 227.5H858V225Z"
          fill="black"
        />
        <path
          d="M858 225H861.2C861.48 225 861.62 225 861.727 225.054C861.821 225.102 861.898 225.179 861.946 225.273C862 225.38 862 225.52 862 225.8V226.7C862 226.98 862 227.12 861.946 227.227C861.898 227.321 861.821 227.398 861.727 227.446C861.62 227.5 861.48 227.5 861.2 227.5H858V225Z"
          fill="url(#paint25_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <g filter="url(#filter15_b_574_2323)">
        <path
          d="M858 234H861.2C861.48 234 861.62 234 861.727 234.054C861.821 234.102 861.898 234.179 861.946 234.273C862 234.38 862 234.52 862 234.8V235.7C862 235.98 862 236.12 861.946 236.227C861.898 236.321 861.821 236.398 861.727 236.446C861.62 236.5 861.48 236.5 861.2 236.5H858V234Z"
          fill="black"
        />
        <path
          d="M858 234H861.2C861.48 234 861.62 234 861.727 234.054C861.821 234.102 861.898 234.179 861.946 234.273C862 234.38 862 234.52 862 234.8V235.7C862 235.98 862 236.12 861.946 236.227C861.898 236.321 861.821 236.398 861.727 236.446C861.62 236.5 861.48 236.5 861.2 236.5H858V234Z"
          fill="url(#paint26_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <g filter="url(#filter16_b_574_2323)">
        <path
          d="M858 243H861.2C861.48 243 861.62 243 861.727 243.054C861.821 243.102 861.898 243.179 861.946 243.273C862 243.38 862 243.52 862 243.8V244.7C862 244.98 862 245.12 861.946 245.227C861.898 245.321 861.821 245.398 861.727 245.446C861.62 245.5 861.48 245.5 861.2 245.5H858V243Z"
          fill="black"
        />
        <path
          d="M858 243H861.2C861.48 243 861.62 243 861.727 243.054C861.821 243.102 861.898 243.179 861.946 243.273C862 243.38 862 243.52 862 243.8V244.7C862 244.98 862 245.12 861.946 245.227C861.898 245.321 861.821 245.398 861.727 245.446C861.62 245.5 861.48 245.5 861.2 245.5H858V243Z"
          fill="url(#paint27_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <g filter="url(#filter17_d_574_2323)">
        <g clipPath="url(#clip2_574_2323)">
          <rect
            x="802"
            y="75"
            width="56"
            height="40"
            rx="3"
            fill="url(#paint28_radial_574_2323)"
            fillOpacity="0.6"
            shapeRendering="crispEdges"
          />
          <rect
            x="802"
            y="75"
            width="56"
            height="40"
            rx="3"
            fill="white"
            fillOpacity="0.15"
            shapeRendering="crispEdges"
          />
          <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M822.081 87H822.1H825V88H822.1C821.812 88 821.626 88.0004 821.484 88.012C821.348 88.023 821.298 88.0419 821.273 88.0545C821.179 88.1024 821.102 88.1789 821.054 88.273C821.042 88.2977 821.023 88.3481 821.012 88.4839C821 88.6256 821 88.8117 821 89.1V92H820V89.1V89.0807V89.0807C820 88.8171 820 88.5898 820.015 88.4025C820.031 88.2048 820.067 88.0082 820.163 87.819C820.307 87.5368 820.537 87.3073 820.819 87.1635C821.008 87.0671 821.205 87.0314 821.402 87.0153C821.59 87 821.817 87 822.081 87H822.081ZM838.516 88.012C838.374 88.0004 838.188 88 837.9 88H835V87H837.9H837.919H837.919C838.183 87 838.41 87 838.598 87.0153C838.795 87.0314 838.992 87.0671 839.181 87.1635C839.463 87.3073 839.693 87.5368 839.837 87.819C839.933 88.0082 839.969 88.2048 839.985 88.4025C840 88.5898 840 88.8171 840 89.0807V89.1V92H839V89.1C839 88.8117 839 88.6256 838.988 88.4839C838.977 88.3481 838.958 88.2977 838.946 88.273C838.898 88.1789 838.821 88.1024 838.727 88.0545C838.702 88.0419 838.652 88.023 838.516 88.012ZM821 99V101.9C821 102.188 821 102.374 821.012 102.516C821.023 102.652 821.042 102.702 821.054 102.727C821.102 102.821 821.179 102.898 821.273 102.945C821.298 102.958 821.348 102.977 821.484 102.988C821.626 103 821.812 103 822.1 103H825V104H822.1H822.081C821.817 104 821.59 104 821.402 103.985C821.205 103.969 821.008 103.933 820.819 103.836C820.537 103.693 820.307 103.463 820.163 103.181C820.067 102.992 820.031 102.795 820.015 102.598C820 102.41 820 102.183 820 101.919V101.919V101.9V99H821ZM839 101.9V99H840V101.9V101.919C840 102.183 840 102.41 839.985 102.598C839.969 102.795 839.933 102.992 839.837 103.181C839.693 103.463 839.463 103.693 839.181 103.836C838.992 103.933 838.795 103.969 838.598 103.985C838.41 104 838.183 104 837.919 104H837.9H835V103H837.9C838.188 103 838.374 103 838.516 102.988C838.652 102.977 838.702 102.958 838.727 102.945C838.821 102.898 838.898 102.821 838.946 102.727C838.958 102.702 838.977 102.652 838.988 102.516C839 102.374 839 102.188 839 101.9ZM826.5 91C826.776 91 827 91.2239 827 91.5V92.5C827 92.7761 826.776 93 826.5 93C826.224 93 826 92.7761 826 92.5V91.5C826 91.2239 826.224 91 826.5 91ZM831 93.5C831 93.2239 830.776 93 830.5 93C830.224 93 830 93.2239 830 93.5V94.75C830 94.8881 829.888 95 829.75 95H829.5C829.224 95 829 95.2239 829 95.5C829 95.7761 829.224 96 829.5 96H829.75C830.44 96 831 95.4404 831 94.75V93.5ZM826.85 98.1427C826.654 97.9512 826.34 97.9524 826.146 98.1464C825.951 98.3417 825.951 98.6583 826.146 98.8536L826.5 98.5C826.146 98.8536 826.147 98.8538 826.147 98.854L826.147 98.8545L826.148 98.8555L826.151 98.8577L826.156 98.8633L826.173 98.8786C826.186 98.8906 826.203 98.9059 826.224 98.9242C826.267 98.9608 826.328 99.009 826.407 99.0647C826.565 99.1763 826.797 99.3179 827.109 99.4569C827.737 99.7358 828.681 100 830 100C831.319 100 832.263 99.7358 832.891 99.4569C833.203 99.3179 833.435 99.1763 833.593 99.0647C833.672 99.009 833.733 98.9608 833.776 98.9242C833.797 98.9059 833.814 98.8906 833.827 98.8786L833.844 98.8633L833.849 98.8577L833.852 98.8555L833.853 98.8545L833.853 98.854C833.853 98.8538 833.854 98.8536 833.5 98.5L833.854 98.8536C834.049 98.6583 834.049 98.3417 833.854 98.1464C833.66 97.9524 833.346 97.9512 833.15 98.1427L833.149 98.1438C833.146 98.1465 833.139 98.1526 833.129 98.1617C833.107 98.1798 833.07 98.2098 833.016 98.2478C832.909 98.3237 832.734 98.4321 832.484 98.5431C831.987 98.7642 831.181 99 830 99C828.819 99 828.013 98.7642 827.516 98.5431C827.266 98.4321 827.091 98.3237 826.984 98.2478C826.93 98.2098 826.893 98.1798 826.871 98.1617C826.861 98.1526 826.854 98.1465 826.851 98.1438L826.85 98.1427L826.85 98.1427ZM833.149 98.1438L833.148 98.1449L833.147 98.1456L833.149 98.1438ZM834 91.5C834 91.2239 833.776 91 833.5 91C833.224 91 833 91.2239 833 91.5V92.5C833 92.7761 833.224 93 833.5 93C833.776 93 834 92.7761 834 92.5V91.5Z"
            fill="url(#paint29_linear_574_2323)"
            fillOpacity="0.2"
          />
          <g filter="url(#filter18_dd_574_2323)">
            <rect
              x="849"
              y="81"
              width="3"
              height="3"
              rx="1.5"
              fill="url(#paint30_radial_574_2323)"
              shapeRendering="crispEdges"
            />
            <rect
              x="848.75"
              y="80.75"
              width="3.5"
              height="3.5"
              rx="1.75"
              stroke="black"
              strokeOpacity="0.05"
              strokeWidth="0.5"
              shapeRendering="crispEdges"
            />
          </g>
        </g>
        <rect
          x="802.375"
          y="75.375"
          width="55.25"
          height="39.25"
          rx="2.625"
          stroke="url(#paint31_radial_574_2323)"
          strokeOpacity="0.13"
          strokeWidth="0.75"
          shapeRendering="crispEdges"
        />
      </g>
      <path d="M822.25 71V0" stroke="white" strokeOpacity="0.3" strokeWidth="0.5" />
      <path d="M837.75 71V0" stroke="white" strokeOpacity="0.3" strokeWidth="0.5" />
      <path d="M837.75 71V0" stroke="url(#paint32_angular_574_2323)" strokeWidth="0.5" />
      <g filter="url(#filter19_b_574_2323)">
        <path
          d="M821 71.8C821 71.52 821 71.38 821.054 71.273C821.102 71.1789 821.179 71.1024 821.273 71.0545C821.38 71 821.52 71 821.8 71H822.7C822.98 71 823.12 71 823.227 71.0545C823.321 71.1024 823.398 71.1789 823.446 71.273C823.5 71.38 823.5 71.52 823.5 71.8V75H821V71.8Z"
          fill="black"
        />
        <path
          d="M821 71.8C821 71.52 821 71.38 821.054 71.273C821.102 71.1789 821.179 71.1024 821.273 71.0545C821.38 71 821.52 71 821.8 71H822.7C822.98 71 823.12 71 823.227 71.0545C823.321 71.1024 823.398 71.1789 823.446 71.273C823.5 71.38 823.5 71.52 823.5 71.8V75H821V71.8Z"
          fill="url(#paint33_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <g filter="url(#filter20_b_574_2323)">
        <path
          d="M836.5 71.8C836.5 71.52 836.5 71.38 836.554 71.273C836.602 71.1789 836.679 71.1024 836.773 71.0545C836.88 71 837.02 71 837.3 71H838.2C838.48 71 838.62 71 838.727 71.0545C838.821 71.1024 838.898 71.1789 838.946 71.273C839 71.38 839 71.52 839 71.8V75H836.5V71.8Z"
          fill="black"
        />
        <path
          d="M836.5 71.8C836.5 71.52 836.5 71.38 836.554 71.273C836.602 71.1789 836.679 71.1024 836.773 71.0545C836.88 71 837.02 71 837.3 71H838.2C838.48 71 838.62 71 838.727 71.0545C838.821 71.1024 838.898 71.1789 838.946 71.273C839 71.38 839 71.52 839 71.8V75H836.5V71.8Z"
          fill="url(#paint34_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <path
        d="M1378 245.25H1162"
        stroke="url(#paint35_linear_574_2323)"
        strokeOpacity="0.3"
        strokeWidth="0.5"
      />
      <path d="M1378 245.25H1162" stroke="url(#paint36_angular_574_2323)" strokeWidth="0.5" />
      <path
        d="M1378 236.25H1162"
        stroke="url(#paint37_linear_574_2323)"
        strokeOpacity="0.3"
        strokeWidth="0.5"
      />
      <path
        d="M1378 227.25H1162"
        stroke="url(#paint38_linear_574_2323)"
        strokeOpacity="0.3"
        strokeWidth="0.5"
      />
      <path d="M1378 227.25H1162" stroke="url(#paint39_angular_574_2323)" strokeWidth="0.5" />
      <path
        d="M1378 218.25H1162"
        stroke="url(#paint40_linear_574_2323)"
        strokeOpacity="0.3"
        strokeWidth="0.5"
      />
      <path d="M1378 218.25H1162" stroke="url(#paint41_angular_574_2323)" strokeWidth="0.5" />
      <path
        d="M1378 209.25H1162"
        stroke="url(#paint42_linear_574_2323)"
        strokeOpacity="0.3"
        strokeWidth="0.5"
      />
      <path d="M1378 209.25H1162" stroke="url(#paint43_angular_574_2323)" strokeWidth="0.5" />
      <path
        d="M1378 254.25H1162"
        stroke="url(#paint44_linear_574_2323)"
        strokeOpacity="0.3"
        strokeWidth="0.5"
      />
      <path
        d="M1378 263.25H1162"
        stroke="url(#paint45_linear_574_2323)"
        strokeOpacity="0.3"
        strokeWidth="0.5"
      />
      <path d="M1378 263.25H1162" stroke="url(#paint46_angular_574_2323)" strokeWidth="0.5" />
      <g filter="url(#filter21_b_574_2323)">
        <path
          d="M1158 245H1161.2C1161.48 245 1161.62 245 1161.73 245.054C1161.82 245.102 1161.9 245.179 1161.95 245.273C1162 245.38 1162 245.52 1162 245.8V246.7C1162 246.98 1162 247.12 1161.95 247.227C1161.9 247.321 1161.82 247.398 1161.73 247.446C1161.62 247.5 1161.48 247.5 1161.2 247.5H1158V245Z"
          fill="black"
        />
        <path
          d="M1158 245H1161.2C1161.48 245 1161.62 245 1161.73 245.054C1161.82 245.102 1161.9 245.179 1161.95 245.273C1162 245.38 1162 245.52 1162 245.8V246.7C1162 246.98 1162 247.12 1161.95 247.227C1161.9 247.321 1161.82 247.398 1161.73 247.446C1161.62 247.5 1161.48 247.5 1161.2 247.5H1158V245Z"
          fill="url(#paint47_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <g filter="url(#filter22_b_574_2323)">
        <path
          d="M1158 235H1161.2C1161.48 235 1161.62 235 1161.73 235.054C1161.82 235.102 1161.9 235.179 1161.95 235.273C1162 235.38 1162 235.52 1162 235.8V236.7C1162 236.98 1162 237.12 1161.95 237.227C1161.9 237.321 1161.82 237.398 1161.73 237.446C1161.62 237.5 1161.48 237.5 1161.2 237.5H1158V235Z"
          fill="black"
        />
        <path
          d="M1158 235H1161.2C1161.48 235 1161.62 235 1161.73 235.054C1161.82 235.102 1161.9 235.179 1161.95 235.273C1162 235.38 1162 235.52 1162 235.8V236.7C1162 236.98 1162 237.12 1161.95 237.227C1161.9 237.321 1161.82 237.398 1161.73 237.446C1161.62 237.5 1161.48 237.5 1161.2 237.5H1158V235Z"
          fill="url(#paint48_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <g filter="url(#filter23_b_574_2323)">
        <path
          d="M1158 226H1161.2C1161.48 226 1161.62 226 1161.73 226.054C1161.82 226.102 1161.9 226.179 1161.95 226.273C1162 226.38 1162 226.52 1162 226.8V227.7C1162 227.98 1162 228.12 1161.95 228.227C1161.9 228.321 1161.82 228.398 1161.73 228.446C1161.62 228.5 1161.48 228.5 1161.2 228.5H1158V226Z"
          fill="black"
        />
        <path
          d="M1158 226H1161.2C1161.48 226 1161.62 226 1161.73 226.054C1161.82 226.102 1161.9 226.179 1161.95 226.273C1162 226.38 1162 226.52 1162 226.8V227.7C1162 227.98 1162 228.12 1161.95 228.227C1161.9 228.321 1161.82 228.398 1161.73 228.446C1161.62 228.5 1161.48 228.5 1161.2 228.5H1158V226Z"
          fill="url(#paint49_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <g filter="url(#filter24_b_574_2323)">
        <path
          d="M1158 217H1161.2C1161.48 217 1161.62 217 1161.73 217.054C1161.82 217.102 1161.9 217.179 1161.95 217.273C1162 217.38 1162 217.52 1162 217.8V218.7C1162 218.98 1162 219.12 1161.95 219.227C1161.9 219.321 1161.82 219.398 1161.73 219.446C1161.62 219.5 1161.48 219.5 1161.2 219.5H1158V217Z"
          fill="black"
        />
        <path
          d="M1158 217H1161.2C1161.48 217 1161.62 217 1161.73 217.054C1161.82 217.102 1161.9 217.179 1161.95 217.273C1162 217.38 1162 217.52 1162 217.8V218.7C1162 218.98 1162 219.12 1161.95 219.227C1161.9 219.321 1161.82 219.398 1161.73 219.446C1161.62 219.5 1161.48 219.5 1161.2 219.5H1158V217Z"
          fill="url(#paint50_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <g filter="url(#filter25_b_574_2323)">
        <path
          d="M1158 208H1161.2C1161.48 208 1161.62 208 1161.73 208.054C1161.82 208.102 1161.9 208.179 1161.95 208.273C1162 208.38 1162 208.52 1162 208.8V209.7C1162 209.98 1162 210.12 1161.95 210.227C1161.9 210.321 1161.82 210.398 1161.73 210.446C1161.62 210.5 1161.48 210.5 1161.2 210.5H1158V208Z"
          fill="black"
        />
        <path
          d="M1158 208H1161.2C1161.48 208 1161.62 208 1161.73 208.054C1161.82 208.102 1161.9 208.179 1161.95 208.273C1162 208.38 1162 208.52 1162 208.8V209.7C1162 209.98 1162 210.12 1161.95 210.227C1161.9 210.321 1161.82 210.398 1161.73 210.446C1161.62 210.5 1161.48 210.5 1161.2 210.5H1158V208Z"
          fill="url(#paint51_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <g filter="url(#filter26_b_574_2323)">
        <path
          d="M1158 253H1161.2C1161.48 253 1161.62 253 1161.73 253.054C1161.82 253.102 1161.9 253.179 1161.95 253.273C1162 253.38 1162 253.52 1162 253.8V254.7C1162 254.98 1162 255.12 1161.95 255.227C1161.9 255.321 1161.82 255.398 1161.73 255.446C1161.62 255.5 1161.48 255.5 1161.2 255.5H1158V253Z"
          fill="black"
        />
        <path
          d="M1158 253H1161.2C1161.48 253 1161.62 253 1161.73 253.054C1161.82 253.102 1161.9 253.179 1161.95 253.273C1162 253.38 1162 253.52 1162 253.8V254.7C1162 254.98 1162 255.12 1161.95 255.227C1161.9 255.321 1161.82 255.398 1161.73 255.446C1161.62 255.5 1161.48 255.5 1161.2 255.5H1158V253Z"
          fill="url(#paint52_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <g filter="url(#filter27_b_574_2323)">
        <path
          d="M1158 262H1161.2C1161.48 262 1161.62 262 1161.73 262.054C1161.82 262.102 1161.9 262.179 1161.95 262.273C1162 262.38 1162 262.52 1162 262.8V263.7C1162 263.98 1162 264.12 1161.95 264.227C1161.9 264.321 1161.82 264.398 1161.73 264.446C1161.62 264.5 1161.48 264.5 1161.2 264.5H1158V262Z"
          fill="black"
        />
        <path
          d="M1158 262H1161.2C1161.48 262 1161.62 262 1161.73 262.054C1161.82 262.102 1161.9 262.179 1161.95 262.273C1162 262.38 1162 262.52 1162 262.8V263.7C1162 263.98 1162 264.12 1161.95 264.227C1161.9 264.321 1161.82 264.398 1161.73 264.446C1161.62 264.5 1161.48 264.5 1161.2 264.5H1158V262Z"
          fill="url(#paint53_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <g filter="url(#filter28_d_574_2323)">
        <g clipPath="url(#clip3_574_2323)">
          <rect
            x="1014"
            y="164"
            width="144"
            height="144"
            rx="3"
            fill="white"
            fillOpacity="0.15"
            shapeRendering="crispEdges"
          />
          <rect
            x="1014"
            y="164"
            width="144"
            height="144"
            rx="3"
            fill="url(#paint54_radial_574_2323)"
            fillOpacity="0.6"
            shapeRendering="crispEdges"
          />
          <g filter="url(#filter29_di_574_2323)">
            <path
              fillRule="evenodd"
              clipRule="evenodd"
              d="M1066 221H1078L1066 253H1054L1066 221ZM1086 221H1098L1086 253H1074L1086 221ZM1118 221H1106L1094 253H1106L1118 221Z"
              fill="url(#paint55_linear_574_2323)"
              shapeRendering="crispEdges"
            />
          </g>
          <g filter="url(#filter30_dd_574_2323)">
            <rect
              x="1143"
              y="176"
              width="3"
              height="3"
              rx="1.5"
              fill="url(#paint56_radial_574_2323)"
            />
            <rect
              x="1143.25"
              y="176.25"
              width="2.5"
              height="2.5"
              rx="1.25"
              stroke="black"
              strokeOpacity="0.05"
              strokeWidth="0.5"
            />
          </g>
        </g>
        <rect
          x="1014.38"
          y="164.375"
          width="143.25"
          height="143.25"
          rx="2.625"
          stroke="url(#paint57_radial_574_2323)"
          strokeOpacity="0.13"
          strokeWidth="0.75"
          shapeRendering="crispEdges"
        />
      </g>
      <g filter="url(#filter31_d_574_2323)">
        <g clipPath="url(#clip4_574_2323)">
          <rect
            x="802"
            y="204"
            width="56"
            height="64"
            rx="3"
            fill="url(#paint58_radial_574_2323)"
            fillOpacity="0.6"
            shapeRendering="crispEdges"
          />
          <rect
            x="802"
            y="204"
            width="56"
            height="64"
            rx="3"
            fill="white"
            fillOpacity="0.15"
            shapeRendering="crispEdges"
          />
          <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M830 227H829.965H829.965C829.534 227 829.279 227 829.059 227.022C826.922 227.232 825.232 228.922 825.022 231.059C825 231.279 825 231.534 825 231.965L825 232V235H824.1H824.081C823.817 235 823.59 235 823.402 235.015C823.205 235.031 823.008 235.067 822.819 235.163C822.537 235.307 822.307 235.537 822.163 235.819C822.067 236.008 822.031 236.205 822.015 236.402C822 236.59 822 236.817 822 237.081V237.081V237.1V243.9V243.919V243.919C822 244.183 822 244.41 822.015 244.598C822.031 244.795 822.067 244.992 822.163 245.181C822.307 245.463 822.537 245.693 822.819 245.837C823.008 245.933 823.205 245.969 823.402 245.985C823.59 246 823.817 246 824.081 246H824.1H835.9H835.919C836.183 246 836.41 246 836.598 245.985C836.795 245.969 836.992 245.933 837.181 245.837C837.463 245.693 837.693 245.463 837.837 245.181C837.933 244.992 837.969 244.795 837.985 244.598C838 244.41 838 244.183 838 243.919V243.9V237.1V237.081C838 236.817 838 236.59 837.985 236.402C837.969 236.205 837.933 236.008 837.837 235.819C837.693 235.537 837.463 235.307 837.181 235.163C836.992 235.067 836.795 235.031 836.598 235.015C836.41 235 836.183 235 835.919 235H835.9H835V232V231.965C835 231.534 835 231.279 834.978 231.059C834.768 228.922 833.078 227.232 830.941 227.022C830.721 227 830.466 227 830.035 227H830.035H830ZM829.157 228.017C829.322 228.001 829.524 228 830 228C830.476 228 830.678 228.001 830.843 228.017C832.505 228.181 833.819 229.495 833.983 231.157C833.999 231.322 834 231.524 834 232V235H826V232C826 231.524 826.001 231.322 826.017 231.157C826.181 229.495 827.495 228.181 829.157 228.017ZM823.273 236.055C823.298 236.042 823.348 236.023 823.484 236.012C823.626 236 823.812 236 824.1 236H835.9C836.188 236 836.374 236 836.516 236.012C836.652 236.023 836.702 236.042 836.727 236.055C836.821 236.102 836.898 236.179 836.946 236.273C836.958 236.298 836.977 236.348 836.988 236.484C837 236.626 837 236.812 837 237.1V243.9C837 244.188 837 244.374 836.988 244.516C836.977 244.652 836.958 244.702 836.946 244.727C836.898 244.821 836.821 244.898 836.727 244.946C836.702 244.958 836.652 244.977 836.516 244.988C836.374 245 836.188 245 835.9 245H824.1C823.812 245 823.626 245 823.484 244.988C823.348 244.977 823.298 244.958 823.273 244.946C823.179 244.898 823.102 244.821 823.054 244.727C823.042 244.702 823.023 244.652 823.012 244.516C823 244.374 823 244.188 823 243.9V237.1C823 236.812 823 236.626 823.012 236.484C823.023 236.348 823.042 236.298 823.054 236.273C823.102 236.179 823.179 236.102 823.273 236.055Z"
            fill="url(#paint59_linear_574_2323)"
            fillOpacity="0.2"
          />
          <g filter="url(#filter32_dd_574_2323)">
            <rect
              x="849"
              y="210"
              width="3"
              height="3"
              rx="1.5"
              fill="url(#paint60_radial_574_2323)"
            />
            <rect
              x="849.25"
              y="210.25"
              width="2.5"
              height="2.5"
              rx="1.25"
              stroke="black"
              strokeOpacity="0.05"
              strokeWidth="0.5"
            />
          </g>
        </g>
        <rect
          x="802.375"
          y="204.375"
          width="55.25"
          height="63.25"
          rx="2.625"
          stroke="url(#paint61_radial_574_2323)"
          strokeOpacity="0.13"
          strokeWidth="0.75"
          shapeRendering="crispEdges"
        />
      </g>
    </g>
    <defs>
      <filter
        id="filter0_b_574_2323"
        x="1083.5"
        y="159"
        width="4.5"
        height="6"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter1_b_574_2323"
        x="820"
        y="199"
        width="4.5"
        height="6"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter2_b_574_2323"
        x="835.5"
        y="199"
        width="4.5"
        height="6"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter3_b_574_2323"
        x="820"
        y="114"
        width="4.5"
        height="6"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter4_b_574_2323"
        x="835.5"
        y="114"
        width="4.5"
        height="6"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter5_b_574_2323"
        x="1099"
        y="307"
        width="4.5"
        height="6"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter6_b_574_2323"
        x="1089"
        y="307"
        width="4.5"
        height="6"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter7_b_574_2323"
        x="1079"
        y="307"
        width="4.5"
        height="6"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter8_b_574_2323"
        x="1069"
        y="307"
        width="4.5"
        height="6"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter9_b_574_2323"
        x="1059"
        y="307"
        width="4.5"
        height="6"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter10_b_574_2323"
        x="1108.5"
        y="307"
        width="4.5"
        height="6"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter11_b_574_2323"
        x="1009"
        y="224"
        width="6"
        height="4.5"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter12_b_574_2323"
        x="1009"
        y="233"
        width="6"
        height="4.5"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter13_b_574_2323"
        x="1009"
        y="243"
        width="6"
        height="4.5"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter14_b_574_2323"
        x="857"
        y="224"
        width="6"
        height="4.5"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter15_b_574_2323"
        x="857"
        y="233"
        width="6"
        height="4.5"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter16_b_574_2323"
        x="857"
        y="242"
        width="6"
        height="4.5"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter17_d_574_2323"
        x="786"
        y="59"
        width="88"
        height="72"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feMorphology
          radius="4"
          operator="dilate"
          in="SourceAlpha"
          result="effect1_dropShadow_574_2323"
        />
        <feOffset />
        <feGaussianBlur stdDeviation="6" />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.8 0" />
        <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_dropShadow_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter18_dd_574_2323"
        x="828.5"
        y="60.5"
        width="44"
        height="44"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset />
        <feGaussianBlur stdDeviation="10" />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 0.466667 0 0 0 0 0.278431 0 0 0 0 1 0 0 0 1 0"
        />
        <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_574_2323" />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset />
        <feGaussianBlur stdDeviation="3" />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 0.466667 0 0 0 0 0.278431 0 0 0 0 1 0 0 0 1 0"
        />
        <feBlend
          mode="normal"
          in2="effect1_dropShadow_574_2323"
          result="effect2_dropShadow_574_2323"
        />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect2_dropShadow_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter19_b_574_2323"
        x="820"
        y="70"
        width="4.5"
        height="6"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter20_b_574_2323"
        x="835.5"
        y="70"
        width="4.5"
        height="6"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter21_b_574_2323"
        x="1157"
        y="244"
        width="6"
        height="4.5"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter22_b_574_2323"
        x="1157"
        y="234"
        width="6"
        height="4.5"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter23_b_574_2323"
        x="1157"
        y="225"
        width="6"
        height="4.5"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter24_b_574_2323"
        x="1157"
        y="216"
        width="6"
        height="4.5"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter25_b_574_2323"
        x="1157"
        y="207"
        width="6"
        height="4.5"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter26_b_574_2323"
        x="1157"
        y="252"
        width="6"
        height="4.5"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter27_b_574_2323"
        x="1157"
        y="261"
        width="6"
        height="4.5"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter28_d_574_2323"
        x="998"
        y="148"
        width="176"
        height="176"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feMorphology
          radius="4"
          operator="dilate"
          in="SourceAlpha"
          result="effect1_dropShadow_574_2323"
        />
        <feOffset />
        <feGaussianBlur stdDeviation="6" />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.8 0" />
        <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_dropShadow_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter29_di_574_2323"
        x="1054"
        y="221"
        width="64.25"
        height="32.25"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset dx="0.25" dy="0.25" />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix type="matrix" values="0 0 0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 0.15 0" />
        <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_dropShadow_574_2323"
          result="shape"
        />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset dx="0.25" dy="0.25" />
        <feComposite in2="hardAlpha" operator="arithmetic" k2="-1" k3="1" />
        <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.64 0" />
        <feBlend mode="normal" in2="shape" result="effect2_innerShadow_574_2323" />
      </filter>
      <filter
        id="filter30_dd_574_2323"
        x="1123"
        y="156"
        width="43"
        height="43"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset />
        <feGaussianBlur stdDeviation="10" />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 0.00784314 0 0 0 0 0.988235 0 0 0 0 0.945098 0 0 0 1 0"
        />
        <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_574_2323" />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset />
        <feGaussianBlur stdDeviation="3" />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 0.00784314 0 0 0 0 0.988235 0 0 0 0 0.945098 0 0 0 0.75 0"
        />
        <feBlend
          mode="normal"
          in2="effect1_dropShadow_574_2323"
          result="effect2_dropShadow_574_2323"
        />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect2_dropShadow_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter31_d_574_2323"
        x="786"
        y="188"
        width="88"
        height="96"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feMorphology
          radius="4"
          operator="dilate"
          in="SourceAlpha"
          result="effect1_dropShadow_574_2323"
        />
        <feOffset />
        <feGaussianBlur stdDeviation="6" />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.8 0" />
        <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_dropShadow_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter32_dd_574_2323"
        x="829"
        y="190"
        width="43"
        height="43"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset />
        <feGaussianBlur stdDeviation="10" />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 0.00784314 0 0 0 0 0.988235 0 0 0 0 0.945098 0 0 0 1 0"
        />
        <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_574_2323" />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset />
        <feGaussianBlur stdDeviation="3" />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 0.00784314 0 0 0 0 0.988235 0 0 0 0 0.945098 0 0 0 0.75 0"
        />
        <feBlend
          mode="normal"
          in2="effect1_dropShadow_574_2323"
          result="effect2_dropShadow_574_2323"
        />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect2_dropShadow_574_2323"
          result="shape"
        />
      </filter>
      <radialGradient
        id="paint0_radial_574_2323"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(871 290) rotate(173.161) scale(571.063 240.167)"
      >
        <stop stopColor="white" />
        <stop offset="0.669795" stopColor="white" />
        <stop offset="0.950551" stopColor="white" stopOpacity="0" />
      </radialGradient>
      <linearGradient
        id="paint1_linear_574_2323"
        x1="1085.75"
        y1="160"
        x2="1085.75"
        y2="164"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <radialGradient
        id="paint2_angular_574_2323"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(780 169.625) scale(51.5)"
      >
        <stop stopColor="#9D72FF" />
        <stop offset="0.0001" stopColor="#9D72FF" stopOpacity="0" />
        <stop offset="0.199397" stopColor="#9D72FF" stopOpacity="0" />
        <stop offset="0.899479" stopColor="#9D72FF" stopOpacity="0" />
      </radialGradient>
      <linearGradient
        id="paint3_linear_574_2323"
        x1="822.25"
        y1="200"
        x2="822.25"
        y2="204"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <linearGradient
        id="paint4_linear_574_2323"
        x1="837.75"
        y1="200"
        x2="837.75"
        y2="204"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <linearGradient
        id="paint5_linear_574_2323"
        x1="822.25"
        y1="115"
        x2="822.25"
        y2="119"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <linearGradient
        id="paint6_linear_574_2323"
        x1="837.75"
        y1="115"
        x2="837.75"
        y2="119"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <radialGradient
        id="paint7_angular_574_2323"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(1039 413.5) scale(50 90.625)"
      >
        <stop stopColor="white" />
        <stop offset="0.0001" stopColor="white" stopOpacity="0" />
        <stop offset="0.199397" stopColor="white" stopOpacity="0" />
        <stop offset="0.889429" stopColor="white" stopOpacity="0" />
      </radialGradient>
      <radialGradient
        id="paint8_angular_574_2323"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(1015 370) scale(52 52)"
      >
        <stop stopColor="#3DC5FA" />
        <stop offset="0.0001" stopColor="#3DC5FA" stopOpacity="0" />
        <stop offset="0.199397" stopColor="#3DC5FA" stopOpacity="0" />
        <stop offset="0.885417" stopColor="#3DC5FA" stopOpacity="0" />
      </radialGradient>
      <radialGradient
        id="paint9_angular_574_2323"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(1074 355) scale(44 44)"
      >
        <stop stopColor="#3DC5FA" />
        <stop offset="0.0001" stopColor="#3DC5FA" stopOpacity="0" />
        <stop offset="0.199397" stopColor="#3DC5FA" stopOpacity="0" />
        <stop offset="0.885417" stopColor="#3DC5FA" stopOpacity="0" />
      </radialGradient>
      <linearGradient
        id="paint10_linear_574_2323"
        x1="1101.25"
        y1="308"
        x2="1101.25"
        y2="312"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <linearGradient
        id="paint11_linear_574_2323"
        x1="1091.25"
        y1="308"
        x2="1091.25"
        y2="312"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <linearGradient
        id="paint12_linear_574_2323"
        x1="1081.25"
        y1="308"
        x2="1081.25"
        y2="312"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <linearGradient
        id="paint13_linear_574_2323"
        x1="1071.25"
        y1="308"
        x2="1071.25"
        y2="312"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <linearGradient
        id="paint14_linear_574_2323"
        x1="1061.25"
        y1="308"
        x2="1061.25"
        y2="312"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <linearGradient
        id="paint15_linear_574_2323"
        x1="1110.75"
        y1="308"
        x2="1110.75"
        y2="312"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <linearGradient
        id="paint16_linear_574_2323"
        x1="895.328"
        y1="11"
        x2="895.328"
        y2="226.25"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.204413" stopColor="white" stopOpacity="0" />
        <stop offset="1" stopColor="white" />
      </linearGradient>
      <radialGradient
        id="paint17_angular_574_2323"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(936 246) rotate(-90) scale(74 74)"
      >
        <stop offset="0.829622" stopColor="#3CEEAE" stopOpacity="0" />
        <stop offset="0.9999" stopColor="#3CEEAE" />
        <stop offset="1" stopColor="#3CEEAE" stopOpacity="0" />
      </radialGradient>
      <linearGradient
        id="paint18_linear_574_2323"
        x1="895.328"
        y1="20"
        x2="895.328"
        y2="235.25"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.204413" stopColor="white" stopOpacity="0" />
        <stop offset="1" stopColor="white" />
      </linearGradient>
      <radialGradient
        id="paint19_angular_574_2323"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(990 250) rotate(-90) scale(57 57)"
      >
        <stop offset="0.789488" stopColor="#3CEEAE" stopOpacity="0" />
        <stop offset="0.9999" stopColor="#3CEEAE" />
        <stop offset="1" stopColor="#3CEEAE" stopOpacity="0" />
      </radialGradient>
      <linearGradient
        id="paint20_linear_574_2323"
        x1="895.328"
        y1="29"
        x2="895.328"
        y2="244.25"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.204413" stopColor="white" stopOpacity="0" />
        <stop offset="1" stopColor="white" />
      </linearGradient>
      <radialGradient
        id="paint21_angular_574_2323"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(966 265) rotate(-90) scale(46 46)"
      >
        <stop offset="0.821417" stopColor="#3CEEAE" stopOpacity="0" />
        <stop offset="0.9999" stopColor="#3CEEAE" />
        <stop offset="1" stopColor="#3CEEAE" stopOpacity="0" />
      </radialGradient>
      <linearGradient
        id="paint22_linear_574_2323"
        x1="1012"
        y1="225"
        x2="1012"
        y2="227.5"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <linearGradient
        id="paint23_linear_574_2323"
        x1="1012"
        y1="234"
        x2="1012"
        y2="236.5"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <linearGradient
        id="paint24_linear_574_2323"
        x1="1012"
        y1="244"
        x2="1012"
        y2="246.5"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <linearGradient
        id="paint25_linear_574_2323"
        x1="860"
        y1="225"
        x2="860"
        y2="227.5"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <linearGradient
        id="paint26_linear_574_2323"
        x1="860"
        y1="234"
        x2="860"
        y2="236.5"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <linearGradient
        id="paint27_linear_574_2323"
        x1="860"
        y1="243"
        x2="860"
        y2="245.5"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <radialGradient
        id="paint28_radial_574_2323"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(830 75) rotate(90) scale(40 50.96)"
      >
        <stop stopColor="white" stopOpacity="0.2" />
        <stop offset="1" stopColor="white" stopOpacity="0" />
      </radialGradient>
      <linearGradient
        id="paint29_linear_574_2323"
        x1="830"
        y1="94.4375"
        x2="830"
        y2="104"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" />
        <stop offset="1" stopColor="white" stopOpacity="0.4" />
      </linearGradient>
      <radialGradient
        id="paint30_radial_574_2323"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(850.506 82.5) scale(1.49383 1.5)"
      >
        <stop offset="0.0416667" stopColor="#D4C5FF" />
        <stop offset="1" stopColor="#6015FF" />
      </radialGradient>
      <radialGradient
        id="paint31_radial_574_2323"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(858 75) rotate(90) scale(40 56)"
      >
        <stop stopColor="white" />
        <stop offset="1" stopColor="white" stopOpacity="0" />
      </radialGradient>
      <radialGradient
        id="paint32_angular_574_2323"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(808 51) scale(62 62)"
      >
        <stop stopColor="#9D72FF" />
        <stop offset="0.0001" stopColor="#9D72FF" stopOpacity="0" />
        <stop offset="0.778822" stopColor="#9D72FF" stopOpacity="0" />
      </radialGradient>
      <linearGradient
        id="paint33_linear_574_2323"
        x1="822.25"
        y1="71"
        x2="822.25"
        y2="75"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <linearGradient
        id="paint34_linear_574_2323"
        x1="837.75"
        y1="71"
        x2="837.75"
        y2="75"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <linearGradient
        id="paint35_linear_574_2323"
        x1="1213.68"
        y1="30"
        x2="1213.68"
        y2="245.25"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.204413" stopColor="white" stopOpacity="0" />
        <stop offset="1" stopColor="white" />
      </linearGradient>
      <radialGradient
        id="paint36_angular_574_2323"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(1292 262) rotate(-90) scale(66 66)"
      >
        <stop offset="0.787112" stopColor="#3DC5FA" stopOpacity="0" />
        <stop offset="0.9999" stopColor="#3DC5FA" />
        <stop offset="1" stopColor="#3DC5FA" stopOpacity="0" />
      </radialGradient>
      <linearGradient
        id="paint37_linear_574_2323"
        x1="1213.68"
        y1="21"
        x2="1213.68"
        y2="236.25"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.204413" stopColor="white" stopOpacity="0" />
        <stop offset="1" stopColor="white" />
      </linearGradient>
      <linearGradient
        id="paint38_linear_574_2323"
        x1="1213.68"
        y1="12"
        x2="1213.68"
        y2="227.25"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.204413" stopColor="white" stopOpacity="0" />
        <stop offset="1" stopColor="white" />
      </linearGradient>
      <radialGradient
        id="paint39_angular_574_2323"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(1231 251) rotate(-90) scale(79)"
      >
        <stop offset="0.829008" stopColor="#3DC5FA" stopOpacity="0" />
        <stop offset="0.9999" stopColor="#3DC5FA" />
        <stop offset="1" stopColor="#3DC5FA" stopOpacity="0" />
      </radialGradient>
      <linearGradient
        id="paint40_linear_574_2323"
        x1="1213.68"
        y1="3"
        x2="1213.68"
        y2="218.25"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.204413" stopColor="white" stopOpacity="0" />
        <stop offset="1" stopColor="white" />
      </linearGradient>
      <radialGradient
        id="paint41_angular_574_2323"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(1324 235) rotate(-90) scale(58 58)"
      >
        <stop offset="0.777021" stopColor="#3DC5FA" stopOpacity="0" />
        <stop offset="0.9999" stopColor="#3DC5FA" />
        <stop offset="1" stopColor="#3DC5FA" stopOpacity="0" />
      </radialGradient>
      <linearGradient
        id="paint42_linear_574_2323"
        x1="1213.68"
        y1="-6"
        x2="1213.68"
        y2="209.25"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.204413" stopColor="white" stopOpacity="0" />
        <stop offset="1" stopColor="white" />
      </linearGradient>
      <radialGradient
        id="paint43_angular_574_2323"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(1270 229) rotate(-90) scale(74 74)"
      >
        <stop offset="0.802794" stopColor="#3DC5FA" stopOpacity="0" />
        <stop offset="0.9999" stopColor="#3DC5FA" />
        <stop offset="1" stopColor="#3DC5FA" stopOpacity="0" />
      </radialGradient>
      <linearGradient
        id="paint44_linear_574_2323"
        x1="1213.68"
        y1="39"
        x2="1213.68"
        y2="254.25"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.204413" stopColor="white" stopOpacity="0" />
        <stop offset="1" stopColor="white" />
      </linearGradient>
      <linearGradient
        id="paint45_linear_574_2323"
        x1="1213.68"
        y1="48"
        x2="1213.68"
        y2="263.25"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.204413" stopColor="white" stopOpacity="0" />
        <stop offset="1" stopColor="white" />
      </linearGradient>
      <radialGradient
        id="paint46_angular_574_2323"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(1216 287) rotate(-90) scale(55)"
      >
        <stop offset="0.830707" stopColor="#3DC5FA" stopOpacity="0" />
        <stop offset="0.9999" stopColor="#3DC5FA" />
        <stop offset="1" stopColor="#3DC5FA" stopOpacity="0" />
      </radialGradient>
      <linearGradient
        id="paint47_linear_574_2323"
        x1="1160"
        y1="245"
        x2="1160"
        y2="247.5"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <linearGradient
        id="paint48_linear_574_2323"
        x1="1160"
        y1="235"
        x2="1160"
        y2="237.5"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <linearGradient
        id="paint49_linear_574_2323"
        x1="1160"
        y1="226"
        x2="1160"
        y2="228.5"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <linearGradient
        id="paint50_linear_574_2323"
        x1="1160"
        y1="217"
        x2="1160"
        y2="219.5"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <linearGradient
        id="paint51_linear_574_2323"
        x1="1160"
        y1="208"
        x2="1160"
        y2="210.5"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <linearGradient
        id="paint52_linear_574_2323"
        x1="1160"
        y1="253"
        x2="1160"
        y2="255.5"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <linearGradient
        id="paint53_linear_574_2323"
        x1="1160"
        y1="262"
        x2="1160"
        y2="264.5"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <radialGradient
        id="paint54_radial_574_2323"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(1086 164) rotate(90) scale(144 131.04)"
      >
        <stop stopColor="white" stopOpacity="0.2" />
        <stop offset="1" stopColor="white" stopOpacity="0" />
      </radialGradient>
      <linearGradient
        id="paint55_linear_574_2323"
        x1="1086"
        y1="221"
        x2="1086"
        y2="253"
        gradientUnits="userSpaceOnUse"
      >
        <stop />
        <stop offset="0.0001" stopOpacity="0.41" />
        <stop offset="1" stopOpacity="0.1" />
      </linearGradient>
      <radialGradient
        id="paint56_radial_574_2323"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(1144.51 177.5) scale(1.49383 1.5)"
      >
        <stop stopColor="#72FFF9" />
        <stop offset="1" stopColor="#0284FC" />
      </radialGradient>
      <radialGradient
        id="paint57_radial_574_2323"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(1158 164) rotate(90) scale(144 244)"
      >
        <stop stopColor="white" />
        <stop offset="1" stopColor="white" stopOpacity="0" />
      </radialGradient>
      <radialGradient
        id="paint58_radial_574_2323"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(830 204) rotate(90) scale(64 50.96)"
      >
        <stop stopColor="white" stopOpacity="0.2" />
        <stop offset="1" stopColor="white" stopOpacity="0" />
      </radialGradient>
      <linearGradient
        id="paint59_linear_574_2323"
        x1="830"
        y1="229"
        x2="830"
        y2="244"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" />
        <stop offset="1" stopColor="white" stopOpacity="0.4" />
      </linearGradient>
      <radialGradient
        id="paint60_radial_574_2323"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(850.506 211.5) scale(1.49383 1.5)"
      >
        <stop stopColor="#72FFAA" />
        <stop offset="1" stopColor="#00DAB3" />
      </radialGradient>
      <radialGradient
        id="paint61_radial_574_2323"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(858 204) rotate(90) scale(64 56)"
      >
        <stop stopColor="white" />
        <stop offset="1" stopColor="white" stopOpacity="0" />
      </radialGradient>
      <clipPath id="clip0_574_2323">
        <rect width="40" height="77" fill="white" transform="translate(592 233)" />
      </clipPath>
      <clipPath id="clip1_574_2323">
        <rect width="80" height="40" fill="white" transform="translate(843 293)" />
      </clipPath>
      <clipPath id="clip2_574_2323">
        <rect x="802" y="75" width="56" height="40" rx="3" fill="white" />
      </clipPath>
      <clipPath id="clip3_574_2323">
        <rect x="1014" y="164" width="144" height="144" rx="3" fill="white" />
      </clipPath>
      <clipPath id="clip4_574_2323">
        <rect x="802" y="204" width="56" height="64" rx="3" fill="white" />
      </clipPath>
    </defs>
  </svg>
);

export const HeroMainboardStuffMobile: React.FC<{ className: string }> = ({ className }) => (
  <svg
    className={cn("flex sm:hidden pointer-events-none", className)}
    width="1368"
    height="476"
    viewBox="0 0 668 476"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
  >
    <mask
      id="mask0_574_2323"
      style={{ maskType: "alpha" }}
      maskUnits="userSpaceOnUse"
      x="0"
      y="-70"
      width="1512"
      height="546"
    >
      <rect
        width="1512"
        height="545.25"
        transform="translate(0 -70)"
        fill="url(#paint0_radial_574_2323)"
      />
    </mask>
    <g mask="url(#mask0_574_2323)">
      <rect x="914" y="12" width="21" height="24" rx="3" fill="white" fillOpacity="0.16" />
      <rect x="917" y="26" width="15" height="6" rx="1.5" fill="white" fillOpacity="0.16" />
      <rect x="550" y="206" width="2" height="8" fill="white" fillOpacity="0.18" />
      <rect x="554" y="206" width="2" height="8" fill="white" fillOpacity="0.18" />
      <rect x="545" y="209" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="545" y="209" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="550" y="206" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="554" y="206" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="569" y="206" width="2" height="8" fill="white" fillOpacity="0.18" />
      <rect x="573" y="206" width="2" height="8" fill="white" fillOpacity="0.18" />
      <rect x="564" y="209" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="564" y="209" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="569" y="206" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="573" y="206" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="588" y="206" width="2" height="8" fill="white" fillOpacity="0.18" />
      <rect x="592" y="206" width="2" height="8" fill="white" fillOpacity="0.18" />
      <rect x="583" y="209" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="583" y="209" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="588" y="206" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="592" y="206" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="588" y="190" width="2" height="8" fill="white" fillOpacity="0.18" />
      <rect x="592" y="190" width="2" height="8" fill="white" fillOpacity="0.18" />
      <rect x="583" y="193" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="583" y="193" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="588" y="190" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="592" y="190" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="615" y="6" width="2" height="8" fill="white" fillOpacity="0.18" />
      <rect x="619" y="6" width="2" height="8" fill="white" fillOpacity="0.18" />
      <rect x="610" y="9" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="610" y="9" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="615" y="6" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="619" y="6" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1339" y="32" width="2" height="8" fill="white" fillOpacity="0.18" />
      <rect x="1343" y="32" width="2" height="8" fill="white" fillOpacity="0.18" />
      <rect x="1334" y="35" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="1334" y="35" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1339" y="32" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1343" y="32" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="634" y="6" width="2" height="8" fill="white" fillOpacity="0.18" />
      <rect x="638" y="6" width="2" height="8" fill="white" fillOpacity="0.18" />
      <rect x="629" y="9" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="629" y="9" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="634" y="6" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="638" y="6" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1358" y="32" width="2" height="8" fill="white" fillOpacity="0.18" />
      <rect x="1362" y="32" width="2" height="8" fill="white" fillOpacity="0.18" />
      <rect x="1353" y="35" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="1353" y="35" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1358" y="32" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1362" y="32" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="653" y="6" width="2" height="8" fill="white" fillOpacity="0.18" />
      <rect x="657" y="6" width="2" height="8" fill="white" fillOpacity="0.18" />
      <rect x="648" y="9" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="648" y="9" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="653" y="6" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="657" y="6" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="810" y="290" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="810" y="290" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="810" y="300" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="810" y="300" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="811" y="294" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="811" y="294" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="815" y="294" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="815" y="294" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="327" y="205" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="327" y="205" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="327" y="215" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="327" y="215" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="328" y="209" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="328" y="209" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="332" y="209" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="332" y="209" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1348" y="344" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="1348" y="344" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1348" y="354" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="1348" y="354" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1349" y="348" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="1349" y="348" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1353" y="348" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="1353" y="348" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="794" y="290" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="794" y="290" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="794" y="300" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="794" y="300" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="795" y="294" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="795" y="294" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="799" y="294" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="799" y="294" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="311" y="205" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="311" y="205" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="311" y="215" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="311" y="215" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="312" y="209" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="312" y="209" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="316" y="209" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="316" y="209" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1332" y="344" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="1332" y="344" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1332" y="354" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="1332" y="354" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1333" y="348" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="1333" y="348" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1337" y="348" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="1337" y="348" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="778" y="290" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="778" y="290" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="778" y="300" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="778" y="300" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="779" y="294" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="779" y="294" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="783" y="294" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="783" y="294" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="295" y="205" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="295" y="205" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="295" y="215" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="295" y="215" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="296" y="209" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="296" y="209" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="300" y="209" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="300" y="209" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1316" y="344" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="1316" y="344" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1316" y="354" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="1316" y="354" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1317" y="348" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="1317" y="348" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1321" y="348" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="1321" y="348" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="716" y="41" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="716" y="41" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="716" y="51" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="716" y="51" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="717" y="45" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="717" y="45" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="721" y="45" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="721" y="45" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="496" y="251" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="496" y="251" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="496" y="261" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="496" y="261" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="497" y="255" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="497" y="255" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="501" y="255" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="501" y="255" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1216" y="131" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="1216" y="131" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1216" y="141" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="1216" y="141" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1217" y="135" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="1217" y="135" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1221" y="135" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="1221" y="135" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1216" y="151" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="1216" y="151" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1216" y="161" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="1216" y="161" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1217" y="155" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="1217" y="155" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1221" y="155" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="1221" y="155" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1232" y="131" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="1232" y="131" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1232" y="141" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="1232" y="141" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1233" y="135" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="1233" y="135" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="1237" y="135" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="1237" y="135" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="512" y="251" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="512" y="251" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="512" y="261" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="512" y="261" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="513" y="255" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="513" y="255" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="517" y="255" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="517" y="255" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="496" y="271" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="496" y="271" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="496" y="281" width="8" height="2" fill="white" fillOpacity="0.18" />
      <rect x="496" y="281" width="8" height="1" fill="white" fillOpacity="0.14" />
      <rect x="497" y="275" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="497" y="275" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="501" y="275" width="2" height="4" fill="white" fillOpacity="0.18" />
      <rect x="501" y="275" width="2" height="1" fill="white" fillOpacity="0.14" />
      <rect x="664" y="289" width="8" height="8" fill="white" fillOpacity="0.14" />
      <rect
        x="664.25"
        y="289.25"
        width="7.5"
        height="7.5"
        stroke="white"
        strokeOpacity="0.08"
        strokeWidth="0.5"
      />
      <rect x="668" y="293" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect
        x="660.25"
        y="285.25"
        width="15.5"
        height="15.5"
        stroke="white"
        strokeOpacity="0.08"
        strokeWidth="0.5"
      />
      <rect x="751" y="56" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="757" y="56" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="751" y="62" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="757" y="62" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="751" y="68" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="757" y="68" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="751" y="74" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="757" y="74" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="751" y="80" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="757" y="80" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="668" y="251" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect
        x="660.25"
        y="243.25"
        width="15.5"
        height="15.5"
        stroke="white"
        strokeOpacity="0.08"
        strokeWidth="0.5"
      />
      <rect x="664" y="247" width="8" height="8" fill="white" fillOpacity="0.14" />
      <rect
        x="664.25"
        y="247.25"
        width="7.5"
        height="7.5"
        stroke="white"
        strokeOpacity="0.08"
        strokeWidth="0.5"
      />
      <rect x="1353" y="130" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect
        x="1345.25"
        y="122.25"
        width="15.5"
        height="15.5"
        stroke="white"
        strokeOpacity="0.08"
        strokeWidth="0.5"
      />
      <rect x="1349" y="126" width="8" height="8" fill="white" fillOpacity="0.14" />
      <rect
        x="1349.25"
        y="126.25"
        width="7.5"
        height="7.5"
        stroke="white"
        strokeOpacity="0.08"
        strokeWidth="0.5"
      />
      <rect x="671" y="143" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="676" y="143" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="681" y="143" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="686" y="143" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="691" y="143" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="696" y="143" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="914" y="78" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="919" y="78" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="924" y="78" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="929" y="78" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="934" y="78" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="939" y="78" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="910" y="357" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="915" y="357" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="920" y="357" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="925" y="357" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="930" y="357" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="935" y="357" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="1216" y="339" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="1221" y="339" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="1226" y="339" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="1231" y="339" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="1236" y="339" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="1241" y="339" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="1024" y="9" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="1029" y="9" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="1034" y="9" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="1039" y="9" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="1044" y="9" width="2" height="6" fill="white" fillOpacity="0.18" />
      <rect x="1049" y="9" width="2" height="6" fill="white" fillOpacity="0.18" />
      <path d="M736.25 28.25H591.25V-50" stroke="white" strokeOpacity="0.06" strokeWidth="0.5" />
      <g clipPath="url(#clip0_574_2323)">
        <path
          d="M518 316C523.333 310.667 626.889 207.111 678 156"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M526 316C531.333 310.667 634.889 207.111 686 156"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M534 316C539.333 310.667 642.889 207.111 694 156"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M542 316C547.333 310.667 650.889 207.111 702 156"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M550 316C555.333 310.667 658.889 207.111 710 156"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M558 316C563.333 310.667 666.889 207.111 718 156"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M566 316C571.333 310.667 674.889 207.111 726 156"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M574 316C579.333 310.667 682.889 207.111 734 156"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M582 316C587.333 310.667 690.889 207.111 742 156"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M590 316C595.333 310.667 698.889 207.111 750 156"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M598 316C603.333 310.667 706.889 207.111 758 156"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M606 316C611.333 310.667 714.889 207.111 766 156"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M614 316C619.333 310.667 722.889 207.111 774 156"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M622 316C627.333 310.667 730.889 207.111 782 156"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
      </g>
      <g clipPath="url(#clip1_574_2323)">
        <path
          d="M769 376C774.333 370.667 877.889 267.111 929 216"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M777 376C782.333 370.667 885.889 267.111 937 216"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M785 376C790.333 370.667 893.889 267.111 945 216"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M793 376C798.333 370.667 901.889 267.111 953 216"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M801 376C806.333 370.667 909.889 267.111 961 216"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M809 376C814.333 370.667 917.889 267.111 969 216"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M817 376C822.333 370.667 925.889 267.111 977 216"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M825 376C830.333 370.667 933.889 267.111 985 216"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M833 376C838.333 370.667 941.889 267.111 993 216"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M841 376C846.333 370.667 949.889 267.111 1001 216"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M849 376C854.333 370.667 957.889 267.111 1009 216"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M857 376C862.333 370.667 965.889 267.111 1017 216"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M865 376C870.333 370.667 973.889 267.111 1025 216"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
        <path
          d="M873 376C878.333 370.667 981.889 267.111 1033 216"
          stroke="white"
          strokeOpacity="0.3"
          strokeWidth="0.3"
        />
      </g>
      <path
        d="M802 229.25H263.604C259.69 229.25 257.734 229.25 255.892 228.808C254.26 228.416 252.699 227.77 251.267 226.892C249.653 225.903 248.269 224.519 245.502 221.752L0 -23.75"
        stroke="white"
        strokeOpacity="0.08"
        strokeWidth="0.5"
      />
      <path
        d="M711 129.25H602.604C598.69 129.25 596.734 129.25 594.892 129.692C593.26 130.084 591.699 130.73 590.267 131.608C588.653 132.597 587.269 133.981 584.502 136.748L492 229.25"
        stroke="white"
        strokeOpacity="0.08"
        strokeWidth="0.5"
      />
      <path
        d="M830 314.25H493.604C489.69 314.25 487.734 314.25 485.892 313.808C484.26 313.416 482.699 312.77 481.267 311.892C479.653 310.903 478.269 309.519 475.502 306.752L398 229.25"
        stroke="white"
        strokeOpacity="0.08"
        strokeWidth="0.5"
      />
      <path d="M802 95.25H711.25V229" stroke="white" strokeOpacity="0.08" strokeWidth="0.5" />
      <path
        d="M281.25 229V175.25H441.25V229"
        stroke="white"
        strokeOpacity="0.08"
        strokeWidth="0.5"
      />
      <rect x="419" y="190" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="425" y="190" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="419" y="196" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="425" y="196" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="419" y="202" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="425" y="202" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="419" y="208" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="425" y="208" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="419" y="214" width="2" height="2" fill="white" fillOpacity="0.18" />
      <rect x="425" y="214" width="2" height="2" fill="white" fillOpacity="0.18" />
      <path d="M1380 325.25H1202.25V459" stroke="white" strokeOpacity="0.08" strokeWidth="0.5" />
      <path d="M1512 422.25H1334.25V475" stroke="white" strokeOpacity="0.08" strokeWidth="0.5" />
      <path d="M1262.25 475.25H1440" stroke="white" strokeOpacity="0.08" strokeWidth="0.5" />
      <path d="M711.5 144.25H765" stroke="white" strokeOpacity="0.08" strokeWidth="0.5" />
      <rect opacity="0.02" x="714" y="147" width="49" height="79" rx="0.5" fill="white" />
      <rect opacity="0.05" x="716" y="149" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="716" y="155" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="716" y="161" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="716" y="167" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="716" y="173" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.1" x="716" y="179" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="716" y="185" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="716" y="191" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="716" y="197" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="716" y="203" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="716" y="209" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="716" y="215" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="716" y="221" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="723" y="149" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.15" x="723" y="155" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="723" y="161" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="723" y="167" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="723" y="173" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="723" y="179" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="723" y="185" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="723" y="191" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="723" y="197" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.15" x="723" y="203" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="723" y="209" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="723" y="215" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="723" y="221" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="730" y="149" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="730" y="155" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="730" y="161" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="730" y="167" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.1" x="730" y="173" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="730" y="179" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="730" y="185" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="730" y="191" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="730" y="197" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="730" y="203" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.1" x="730" y="209" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="730" y="215" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="730" y="221" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="737" y="149" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="737" y="155" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="737" y="161" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="737" y="167" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="737" y="173" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="737" y="179" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="737" y="185" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="737" y="191" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="737" y="197" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="737" y="203" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="737" y="209" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="737" y="215" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="737" y="221" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="744" y="149" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="744" y="155" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="744" y="161" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.1" x="744" y="167" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="744" y="173" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="744" y="179" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.1" x="744" y="185" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="744" y="191" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="744" y="197" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="744" y="203" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="744" y="209" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="744" y="215" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="744" y="221" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="751" y="149" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.1" x="751" y="155" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="751" y="161" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="751" y="167" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="751" y="173" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="751" y="179" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="751" y="185" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="751" y="191" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.1" x="751" y="197" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="751" y="203" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="751" y="209" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="751" y="215" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="751" y="221" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="758" y="149" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="758" y="155" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="758" y="161" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="758" y="167" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="758" y="173" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="758" y="179" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="758" y="185" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="758" y="191" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="758" y="197" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="758" y="203" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="758" y="209" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="758" y="215" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.15" x="758" y="221" width="3" height="3" rx="0.5" fill="white" />
      <path d="M765.25 95.5V229" stroke="white" strokeOpacity="0.08" strokeWidth="0.5" />
      <path
        d="M1014.25 192.25H917.25V143.5"
        stroke="white"
        strokeOpacity="0.08"
        strokeWidth="0.5"
      />
      <path
        d="M1374.25 149.25H1277.25V20.5"
        stroke="white"
        strokeOpacity="0.08"
        strokeWidth="0.5"
      />
      <path
        d="M830.25 268V346.25H947.25V424"
        stroke="white"
        strokeOpacity="0.08"
        strokeWidth="0.5"
      />
      <path d="M901 0V95" stroke="white" strokeOpacity="0.04" strokeWidth="2" />
      <path d="M737 0V95" stroke="white" strokeOpacity="0.04" strokeWidth="2" />
      <path d="M647 229.5V314" stroke="white" strokeOpacity="0.04" strokeWidth="2" />
      <path d="M689 229.5V314" stroke="white" strokeOpacity="0.04" strokeWidth="2" />
      <path d="M1268 325.5V410" stroke="white" strokeOpacity="0.04" strokeWidth="2" />
      <path d="M759 314.5V428" stroke="white" strokeOpacity="0.04" strokeWidth="2" />
      <path
        d="M858 95.25H982.378C984.348 95.25 985.333 95.25 986.28 95.0658C987.119 94.9023 987.935 94.6316 988.706 94.2605C989.575 93.8423 990.364 93.2533 991.944 92.0753L1009.1 79.2766C1010.99 77.8691 1011.93 77.1654 1012.61 76.2719C1013.22 75.4805 1013.67 74.5836 1013.94 73.6273C1014.25 72.5475 1014.25 71.3705 1014.25 69.0164V0"
        stroke="white"
        strokeOpacity="0.08"
        strokeWidth="0.5"
      />
      <path d="M1014 25.25H1090.25V-70" stroke="white" strokeOpacity="0.08" strokeWidth="0.5" />
      <path
        d="M963.25 95.25V143.25H886.25V95.25"
        stroke="white"
        strokeOpacity="0.08"
        strokeWidth="0.5"
      />
      <rect opacity="0.02" x="890" y="98" width="70" height="42" rx="0.5" fill="white" />
      <rect opacity="0.05" x="891" y="100" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="891" y="107" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="891" y="114" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="891" y="121" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="891" y="128" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="891" y="135" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="899" y="100" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="899" y="107" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.1" x="899" y="114" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="899" y="121" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="899" y="128" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="899" y="135" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="907" y="100" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="907" y="107" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="907" y="114" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="907" y="121" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="907" y="128" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.15" x="907" y="135" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.1" x="915" y="100" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="915" y="107" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="915" y="114" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="915" y="121" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="915" y="128" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="915" y="135" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="923" y="100" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="923" y="107" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="923" y="114" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.15" x="923" y="121" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="923" y="128" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="923" y="135" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="931" y="100" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="931" y="107" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="931" y="114" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="931" y="121" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="931" y="128" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="931" y="135" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="939" y="100" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="939" y="107" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.15" x="939" y="114" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="939" y="121" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="939" y="128" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="939" y="135" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.1" x="947" y="100" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="947" y="107" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="947" y="114" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="947" y="121" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="947" y="128" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.1" x="947" y="135" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="955" y="100" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="955" y="107" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="955" y="114" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="955" y="121" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="955" y="128" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="955" y="135" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.02" x="1340" y="428" width="70" height="42" rx="0.5" fill="white" />
      <rect opacity="0.05" x="1341" y="430" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="1341" y="437" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="1341" y="444" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="1341" y="451" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="1341" y="458" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="1341" y="465" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="1349" y="430" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="1349" y="437" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.1" x="1349" y="444" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="1349" y="451" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="1349" y="458" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="1349" y="465" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="1357" y="430" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="1357" y="437" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="1357" y="444" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="1357" y="451" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="1357" y="458" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.15" x="1357" y="465" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.1" x="1365" y="430" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="1365" y="437" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="1365" y="444" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="1365" y="451" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="1365" y="458" width="3" height="3" rx="0.5" fill="white" />
      <rect opacity="0.05" x="1365" y="465" width="3" height="3" rx="0.5" fill="white" />
      <path
        d="M1370 20H1196.59C1192.68 20 1190.73 20 1188.89 20.4407C1187.26 20.8314 1185.7 21.4758 1184.27 22.3505C1182.65 23.3369 1181.27 24.7164 1178.51 27.4755L1093.27 112.498C1090.5 115.267 1089.11 116.651 1088.12 118.267C1087.24 119.7 1086.59 121.263 1086.19 122.898C1085.75 124.742 1085.75 126.702 1085.75 130.623V163.75"
        stroke="white"
        strokeOpacity="0.3"
        strokeWidth="0.5"
      />
      <g filter="url(#filter0_b_574_2323)">
        <path
          d="M1084.5 160.8C1084.5 160.52 1084.5 160.38 1084.55 160.273C1084.6 160.179 1084.68 160.102 1084.77 160.054C1084.88 160 1085.02 160 1085.3 160H1086.2C1086.48 160 1086.62 160 1086.73 160.054C1086.82 160.102 1086.9 160.179 1086.95 160.273C1087 160.38 1087 160.52 1087 160.8V164H1084.5V160.8Z"
          fill="black"
        />
        <path
          d="M1084.5 160.8C1084.5 160.52 1084.5 160.38 1084.55 160.273C1084.6 160.179 1084.68 160.102 1084.77 160.054C1084.88 160 1085.02 160 1085.3 160H1086.2C1086.48 160 1086.62 160 1086.73 160.054C1086.82 160.102 1086.9 160.179 1086.95 160.273C1087 160.38 1087 160.52 1087 160.8V164H1084.5V160.8Z"
          fill="url(#paint1_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <path d="M822.25 200V119" stroke="white" strokeOpacity="0.3" strokeWidth="0.5" />
      <path d="M822.25 200V119" stroke="url(#paint2_angular_574_2323)" strokeWidth="0.5" />
      <path d="M837.75 200V119" stroke="white" strokeOpacity="0.3" strokeWidth="0.5" />
      <g filter="url(#filter1_b_574_2323)">
        <path
          d="M821 200.8C821 200.52 821 200.38 821.054 200.273C821.102 200.179 821.179 200.102 821.273 200.054C821.38 200 821.52 200 821.8 200H822.7C822.98 200 823.12 200 823.227 200.054C823.321 200.102 823.398 200.179 823.446 200.273C823.5 200.38 823.5 200.52 823.5 200.8V204H821V200.8Z"
          fill="black"
        />
        <path
          d="M821 200.8C821 200.52 821 200.38 821.054 200.273C821.102 200.179 821.179 200.102 821.273 200.054C821.38 200 821.52 200 821.8 200H822.7C822.98 200 823.12 200 823.227 200.054C823.321 200.102 823.398 200.179 823.446 200.273C823.5 200.38 823.5 200.52 823.5 200.8V204H821V200.8Z"
          fill="url(#paint3_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <g filter="url(#filter2_b_574_2323)">
        <path
          d="M836.5 200.8C836.5 200.52 836.5 200.38 836.554 200.273C836.602 200.179 836.679 200.102 836.773 200.054C836.88 200 837.02 200 837.3 200H838.2C838.48 200 838.62 200 838.727 200.054C838.821 200.102 838.898 200.179 838.946 200.273C839 200.38 839 200.52 839 200.8V204H836.5V200.8Z"
          fill="black"
        />
        <path
          d="M836.5 200.8C836.5 200.52 836.5 200.38 836.554 200.273C836.602 200.179 836.679 200.102 836.773 200.054C836.88 200 837.02 200 837.3 200H838.2C838.48 200 838.62 200 838.727 200.054C838.821 200.102 838.898 200.179 838.946 200.273C839 200.38 839 200.52 839 200.8V204H836.5V200.8Z"
          fill="url(#paint4_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <g filter="url(#filter3_b_574_2323)">
        <path
          d="M821 115H823.5V118.2C823.5 118.48 823.5 118.62 823.446 118.727C823.398 118.821 823.321 118.898 823.227 118.946C823.12 119 822.98 119 822.7 119H821.8C821.52 119 821.38 119 821.273 118.946C821.179 118.898 821.102 118.821 821.054 118.727C821 118.62 821 118.48 821 118.2V115Z"
          fill="black"
        />
        <path
          d="M821 115H823.5V118.2C823.5 118.48 823.5 118.62 823.446 118.727C823.398 118.821 823.321 118.898 823.227 118.946C823.12 119 822.98 119 822.7 119H821.8C821.52 119 821.38 119 821.273 118.946C821.179 118.898 821.102 118.821 821.054 118.727C821 118.62 821 118.48 821 118.2V115Z"
          fill="url(#paint5_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <g filter="url(#filter4_b_574_2323)">
        <path
          d="M836.5 115H839V118.2C839 118.48 839 118.62 838.946 118.727C838.898 118.821 838.821 118.898 838.727 118.946C838.62 119 838.48 119 838.2 119H837.3C837.02 119 836.88 119 836.773 118.946C836.679 118.898 836.602 118.821 836.554 118.727C836.5 118.62 836.5 118.48 836.5 118.2V115Z"
          fill="black"
        />
        <path
          d="M836.5 115H839V118.2C839 118.48 839 118.62 838.946 118.727C838.898 118.821 838.821 118.898 838.727 118.946C838.62 119 838.48 119 838.2 119H837.3C837.02 119 836.88 119 836.773 118.946C836.679 118.898 836.602 118.821 836.554 118.727C836.5 118.62 836.5 118.48 836.5 118.2V115Z"
          fill="url(#paint6_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <path d="M1101.25 428V312" stroke="white" strokeOpacity="0.15" strokeWidth="0.5" />
      <path d="M1091.25 428V312" stroke="white" strokeOpacity="0.15" strokeWidth="0.5" />
      <path d="M1081.25 428V312" stroke="white" strokeOpacity="0.15" strokeWidth="0.5" />
      <path
        d="M1081.25 428V312"
        stroke="url(#paint7_angular_574_2323)"
        strokeOpacity="0.3"
        strokeWidth="0.5"
      />
      <path d="M1071.25 428V312" stroke="white" strokeOpacity="0.15" strokeWidth="0.5" />
      <path d="M1061.25 428V312" stroke="white" strokeOpacity="0.15" strokeWidth="0.5" />
      <path d="M1061.25 428V312" stroke="url(#paint8_angular_574_2323)" strokeWidth="0.5" />
      <path d="M1110.75 428V312" stroke="white" strokeOpacity="0.15" strokeWidth="0.5" />
      <path d="M1110.75 428V312" stroke="url(#paint9_angular_574_2323)" strokeWidth="0.5" />
      <g filter="url(#filter5_b_574_2323)">
        <path
          d="M1100 308H1102.5V311.2C1102.5 311.48 1102.5 311.62 1102.45 311.727C1102.4 311.821 1102.32 311.898 1102.23 311.946C1102.12 312 1101.98 312 1101.7 312H1100.8C1100.52 312 1100.38 312 1100.27 311.946C1100.18 311.898 1100.1 311.821 1100.05 311.727C1100 311.62 1100 311.48 1100 311.2V308Z"
          fill="black"
        />
        <path
          d="M1100 308H1102.5V311.2C1102.5 311.48 1102.5 311.62 1102.45 311.727C1102.4 311.821 1102.32 311.898 1102.23 311.946C1102.12 312 1101.98 312 1101.7 312H1100.8C1100.52 312 1100.38 312 1100.27 311.946C1100.18 311.898 1100.1 311.821 1100.05 311.727C1100 311.62 1100 311.48 1100 311.2V308Z"
          fill="url(#paint10_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <g filter="url(#filter6_b_574_2323)">
        <path
          d="M1090 308H1092.5V311.2C1092.5 311.48 1092.5 311.62 1092.45 311.727C1092.4 311.821 1092.32 311.898 1092.23 311.946C1092.12 312 1091.98 312 1091.7 312H1090.8C1090.52 312 1090.38 312 1090.27 311.946C1090.18 311.898 1090.1 311.821 1090.05 311.727C1090 311.62 1090 311.48 1090 311.2V308Z"
          fill="black"
        />
        <path
          d="M1090 308H1092.5V311.2C1092.5 311.48 1092.5 311.62 1092.45 311.727C1092.4 311.821 1092.32 311.898 1092.23 311.946C1092.12 312 1091.98 312 1091.7 312H1090.8C1090.52 312 1090.38 312 1090.27 311.946C1090.18 311.898 1090.1 311.821 1090.05 311.727C1090 311.62 1090 311.48 1090 311.2V308Z"
          fill="url(#paint11_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <g filter="url(#filter7_b_574_2323)">
        <path
          d="M1080 308H1082.5V311.2C1082.5 311.48 1082.5 311.62 1082.45 311.727C1082.4 311.821 1082.32 311.898 1082.23 311.946C1082.12 312 1081.98 312 1081.7 312H1080.8C1080.52 312 1080.38 312 1080.27 311.946C1080.18 311.898 1080.1 311.821 1080.05 311.727C1080 311.62 1080 311.48 1080 311.2V308Z"
          fill="black"
        />
        <path
          d="M1080 308H1082.5V311.2C1082.5 311.48 1082.5 311.62 1082.45 311.727C1082.4 311.821 1082.32 311.898 1082.23 311.946C1082.12 312 1081.98 312 1081.7 312H1080.8C1080.52 312 1080.38 312 1080.27 311.946C1080.18 311.898 1080.1 311.821 1080.05 311.727C1080 311.62 1080 311.48 1080 311.2V308Z"
          fill="url(#paint12_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <g filter="url(#filter8_b_574_2323)">
        <path
          d="M1070 308H1072.5V311.2C1072.5 311.48 1072.5 311.62 1072.45 311.727C1072.4 311.821 1072.32 311.898 1072.23 311.946C1072.12 312 1071.98 312 1071.7 312H1070.8C1070.52 312 1070.38 312 1070.27 311.946C1070.18 311.898 1070.1 311.821 1070.05 311.727C1070 311.62 1070 311.48 1070 311.2V308Z"
          fill="black"
        />
        <path
          d="M1070 308H1072.5V311.2C1072.5 311.48 1072.5 311.62 1072.45 311.727C1072.4 311.821 1072.32 311.898 1072.23 311.946C1072.12 312 1071.98 312 1071.7 312H1070.8C1070.52 312 1070.38 312 1070.27 311.946C1070.18 311.898 1070.1 311.821 1070.05 311.727C1070 311.62 1070 311.48 1070 311.2V308Z"
          fill="url(#paint13_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <g filter="url(#filter9_b_574_2323)">
        <path
          d="M1060 308H1062.5V311.2C1062.5 311.48 1062.5 311.62 1062.45 311.727C1062.4 311.821 1062.32 311.898 1062.23 311.946C1062.12 312 1061.98 312 1061.7 312H1060.8C1060.52 312 1060.38 312 1060.27 311.946C1060.18 311.898 1060.1 311.821 1060.05 311.727C1060 311.62 1060 311.48 1060 311.2V308Z"
          fill="black"
        />
        <path
          d="M1060 308H1062.5V311.2C1062.5 311.48 1062.5 311.62 1062.45 311.727C1062.4 311.821 1062.32 311.898 1062.23 311.946C1062.12 312 1061.98 312 1061.7 312H1060.8C1060.52 312 1060.38 312 1060.27 311.946C1060.18 311.898 1060.1 311.821 1060.05 311.727C1060 311.62 1060 311.48 1060 311.2V308Z"
          fill="url(#paint14_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <g filter="url(#filter10_b_574_2323)">
        <path
          d="M1109.5 308H1112V311.2C1112 311.48 1112 311.62 1111.95 311.727C1111.9 311.821 1111.82 311.898 1111.73 311.946C1111.62 312 1111.48 312 1111.2 312H1110.3C1110.02 312 1109.88 312 1109.77 311.946C1109.68 311.898 1109.6 311.821 1109.55 311.727C1109.5 311.62 1109.5 311.48 1109.5 311.2V308Z"
          fill="black"
        />
        <path
          d="M1109.5 308H1112V311.2C1112 311.48 1112 311.62 1111.95 311.727C1111.9 311.821 1111.82 311.898 1111.73 311.946C1111.62 312 1111.48 312 1111.2 312H1110.3C1110.02 312 1109.88 312 1109.77 311.946C1109.68 311.898 1109.6 311.821 1109.55 311.727C1109.5 311.62 1109.5 311.48 1109.5 311.2V308Z"
          fill="url(#paint15_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <path
        d="M1014 226.25H858"
        stroke="url(#paint16_linear_574_2323)"
        strokeOpacity="0.3"
        strokeWidth="0.5"
      />
      <path d="M1014 226.25H858" stroke="url(#paint17_angular_574_2323)" strokeWidth="0.5" />
      <path
        d="M1014 235.25H858"
        stroke="url(#paint18_linear_574_2323)"
        strokeOpacity="0.3"
        strokeWidth="0.5"
      />
      <path d="M1014 235.25H858" stroke="url(#paint19_angular_574_2323)" strokeWidth="0.5" />
      <path
        d="M1014 244.25H858"
        stroke="url(#paint20_linear_574_2323)"
        strokeOpacity="0.3"
        strokeWidth="0.5"
      />
      <path d="M1014 244.25H858" stroke="url(#paint21_angular_574_2323)" strokeWidth="0.5" />
      <g filter="url(#filter11_b_574_2323)">
        <path
          d="M1010 225.8C1010 225.52 1010 225.38 1010.05 225.273C1010.1 225.179 1010.18 225.102 1010.27 225.054C1010.38 225 1010.52 225 1010.8 225H1014V227.5H1010.8C1010.52 227.5 1010.38 227.5 1010.27 227.446C1010.18 227.398 1010.1 227.321 1010.05 227.227C1010 227.12 1010 226.98 1010 226.7V225.8Z"
          fill="black"
        />
        <path
          d="M1010 225.8C1010 225.52 1010 225.38 1010.05 225.273C1010.1 225.179 1010.18 225.102 1010.27 225.054C1010.38 225 1010.52 225 1010.8 225H1014V227.5H1010.8C1010.52 227.5 1010.38 227.5 1010.27 227.446C1010.18 227.398 1010.1 227.321 1010.05 227.227C1010 227.12 1010 226.98 1010 226.7V225.8Z"
          fill="url(#paint22_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <g filter="url(#filter12_b_574_2323)">
        <path
          d="M1010 234.8C1010 234.52 1010 234.38 1010.05 234.273C1010.1 234.179 1010.18 234.102 1010.27 234.054C1010.38 234 1010.52 234 1010.8 234H1014V236.5H1010.8C1010.52 236.5 1010.38 236.5 1010.27 236.446C1010.18 236.398 1010.1 236.321 1010.05 236.227C1010 236.12 1010 235.98 1010 235.7V234.8Z"
          fill="black"
        />
        <path
          d="M1010 234.8C1010 234.52 1010 234.38 1010.05 234.273C1010.1 234.179 1010.18 234.102 1010.27 234.054C1010.38 234 1010.52 234 1010.8 234H1014V236.5H1010.8C1010.52 236.5 1010.38 236.5 1010.27 236.446C1010.18 236.398 1010.1 236.321 1010.05 236.227C1010 236.12 1010 235.98 1010 235.7V234.8Z"
          fill="url(#paint23_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <g filter="url(#filter13_b_574_2323)">
        <path
          d="M1010 244.8C1010 244.52 1010 244.38 1010.05 244.273C1010.1 244.179 1010.18 244.102 1010.27 244.054C1010.38 244 1010.52 244 1010.8 244H1014V246.5H1010.8C1010.52 246.5 1010.38 246.5 1010.27 246.446C1010.18 246.398 1010.1 246.321 1010.05 246.227C1010 246.12 1010 245.98 1010 245.7V244.8Z"
          fill="black"
        />
        <path
          d="M1010 244.8C1010 244.52 1010 244.38 1010.05 244.273C1010.1 244.179 1010.18 244.102 1010.27 244.054C1010.38 244 1010.52 244 1010.8 244H1014V246.5H1010.8C1010.52 246.5 1010.38 246.5 1010.27 246.446C1010.18 246.398 1010.1 246.321 1010.05 246.227C1010 246.12 1010 245.98 1010 245.7V244.8Z"
          fill="url(#paint24_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <g filter="url(#filter14_b_574_2323)">
        <path
          d="M858 225H861.2C861.48 225 861.62 225 861.727 225.054C861.821 225.102 861.898 225.179 861.946 225.273C862 225.38 862 225.52 862 225.8V226.7C862 226.98 862 227.12 861.946 227.227C861.898 227.321 861.821 227.398 861.727 227.446C861.62 227.5 861.48 227.5 861.2 227.5H858V225Z"
          fill="black"
        />
        <path
          d="M858 225H861.2C861.48 225 861.62 225 861.727 225.054C861.821 225.102 861.898 225.179 861.946 225.273C862 225.38 862 225.52 862 225.8V226.7C862 226.98 862 227.12 861.946 227.227C861.898 227.321 861.821 227.398 861.727 227.446C861.62 227.5 861.48 227.5 861.2 227.5H858V225Z"
          fill="url(#paint25_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <g filter="url(#filter15_b_574_2323)">
        <path
          d="M858 234H861.2C861.48 234 861.62 234 861.727 234.054C861.821 234.102 861.898 234.179 861.946 234.273C862 234.38 862 234.52 862 234.8V235.7C862 235.98 862 236.12 861.946 236.227C861.898 236.321 861.821 236.398 861.727 236.446C861.62 236.5 861.48 236.5 861.2 236.5H858V234Z"
          fill="black"
        />
        <path
          d="M858 234H861.2C861.48 234 861.62 234 861.727 234.054C861.821 234.102 861.898 234.179 861.946 234.273C862 234.38 862 234.52 862 234.8V235.7C862 235.98 862 236.12 861.946 236.227C861.898 236.321 861.821 236.398 861.727 236.446C861.62 236.5 861.48 236.5 861.2 236.5H858V234Z"
          fill="url(#paint26_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <g filter="url(#filter16_b_574_2323)">
        <path
          d="M858 243H861.2C861.48 243 861.62 243 861.727 243.054C861.821 243.102 861.898 243.179 861.946 243.273C862 243.38 862 243.52 862 243.8V244.7C862 244.98 862 245.12 861.946 245.227C861.898 245.321 861.821 245.398 861.727 245.446C861.62 245.5 861.48 245.5 861.2 245.5H858V243Z"
          fill="black"
        />
        <path
          d="M858 243H861.2C861.48 243 861.62 243 861.727 243.054C861.821 243.102 861.898 243.179 861.946 243.273C862 243.38 862 243.52 862 243.8V244.7C862 244.98 862 245.12 861.946 245.227C861.898 245.321 861.821 245.398 861.727 245.446C861.62 245.5 861.48 245.5 861.2 245.5H858V243Z"
          fill="url(#paint27_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <g filter="url(#filter17_d_574_2323)">
        <g clipPath="url(#clip2_574_2323)">
          <rect
            x="802"
            y="75"
            width="56"
            height="40"
            rx="3"
            fill="url(#paint28_radial_574_2323)"
            fillOpacity="0.6"
            shapeRendering="crispEdges"
          />
          <rect
            x="802"
            y="75"
            width="56"
            height="40"
            rx="3"
            fill="white"
            fillOpacity="0.15"
            shapeRendering="crispEdges"
          />
          <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M822.081 87H822.1H825V88H822.1C821.812 88 821.626 88.0004 821.484 88.012C821.348 88.023 821.298 88.0419 821.273 88.0545C821.179 88.1024 821.102 88.1789 821.054 88.273C821.042 88.2977 821.023 88.3481 821.012 88.4839C821 88.6256 821 88.8117 821 89.1V92H820V89.1V89.0807V89.0807C820 88.8171 820 88.5898 820.015 88.4025C820.031 88.2048 820.067 88.0082 820.163 87.819C820.307 87.5368 820.537 87.3073 820.819 87.1635C821.008 87.0671 821.205 87.0314 821.402 87.0153C821.59 87 821.817 87 822.081 87H822.081ZM838.516 88.012C838.374 88.0004 838.188 88 837.9 88H835V87H837.9H837.919H837.919C838.183 87 838.41 87 838.598 87.0153C838.795 87.0314 838.992 87.0671 839.181 87.1635C839.463 87.3073 839.693 87.5368 839.837 87.819C839.933 88.0082 839.969 88.2048 839.985 88.4025C840 88.5898 840 88.8171 840 89.0807V89.1V92H839V89.1C839 88.8117 839 88.6256 838.988 88.4839C838.977 88.3481 838.958 88.2977 838.946 88.273C838.898 88.1789 838.821 88.1024 838.727 88.0545C838.702 88.0419 838.652 88.023 838.516 88.012ZM821 99V101.9C821 102.188 821 102.374 821.012 102.516C821.023 102.652 821.042 102.702 821.054 102.727C821.102 102.821 821.179 102.898 821.273 102.945C821.298 102.958 821.348 102.977 821.484 102.988C821.626 103 821.812 103 822.1 103H825V104H822.1H822.081C821.817 104 821.59 104 821.402 103.985C821.205 103.969 821.008 103.933 820.819 103.836C820.537 103.693 820.307 103.463 820.163 103.181C820.067 102.992 820.031 102.795 820.015 102.598C820 102.41 820 102.183 820 101.919V101.919V101.9V99H821ZM839 101.9V99H840V101.9V101.919C840 102.183 840 102.41 839.985 102.598C839.969 102.795 839.933 102.992 839.837 103.181C839.693 103.463 839.463 103.693 839.181 103.836C838.992 103.933 838.795 103.969 838.598 103.985C838.41 104 838.183 104 837.919 104H837.9H835V103H837.9C838.188 103 838.374 103 838.516 102.988C838.652 102.977 838.702 102.958 838.727 102.945C838.821 102.898 838.898 102.821 838.946 102.727C838.958 102.702 838.977 102.652 838.988 102.516C839 102.374 839 102.188 839 101.9ZM826.5 91C826.776 91 827 91.2239 827 91.5V92.5C827 92.7761 826.776 93 826.5 93C826.224 93 826 92.7761 826 92.5V91.5C826 91.2239 826.224 91 826.5 91ZM831 93.5C831 93.2239 830.776 93 830.5 93C830.224 93 830 93.2239 830 93.5V94.75C830 94.8881 829.888 95 829.75 95H829.5C829.224 95 829 95.2239 829 95.5C829 95.7761 829.224 96 829.5 96H829.75C830.44 96 831 95.4404 831 94.75V93.5ZM826.85 98.1427C826.654 97.9512 826.34 97.9524 826.146 98.1464C825.951 98.3417 825.951 98.6583 826.146 98.8536L826.5 98.5C826.146 98.8536 826.147 98.8538 826.147 98.854L826.147 98.8545L826.148 98.8555L826.151 98.8577L826.156 98.8633L826.173 98.8786C826.186 98.8906 826.203 98.9059 826.224 98.9242C826.267 98.9608 826.328 99.009 826.407 99.0647C826.565 99.1763 826.797 99.3179 827.109 99.4569C827.737 99.7358 828.681 100 830 100C831.319 100 832.263 99.7358 832.891 99.4569C833.203 99.3179 833.435 99.1763 833.593 99.0647C833.672 99.009 833.733 98.9608 833.776 98.9242C833.797 98.9059 833.814 98.8906 833.827 98.8786L833.844 98.8633L833.849 98.8577L833.852 98.8555L833.853 98.8545L833.853 98.854C833.853 98.8538 833.854 98.8536 833.5 98.5L833.854 98.8536C834.049 98.6583 834.049 98.3417 833.854 98.1464C833.66 97.9524 833.346 97.9512 833.15 98.1427L833.149 98.1438C833.146 98.1465 833.139 98.1526 833.129 98.1617C833.107 98.1798 833.07 98.2098 833.016 98.2478C832.909 98.3237 832.734 98.4321 832.484 98.5431C831.987 98.7642 831.181 99 830 99C828.819 99 828.013 98.7642 827.516 98.5431C827.266 98.4321 827.091 98.3237 826.984 98.2478C826.93 98.2098 826.893 98.1798 826.871 98.1617C826.861 98.1526 826.854 98.1465 826.851 98.1438L826.85 98.1427L826.85 98.1427ZM833.149 98.1438L833.148 98.1449L833.147 98.1456L833.149 98.1438ZM834 91.5C834 91.2239 833.776 91 833.5 91C833.224 91 833 91.2239 833 91.5V92.5C833 92.7761 833.224 93 833.5 93C833.776 93 834 92.7761 834 92.5V91.5Z"
            fill="url(#paint29_linear_574_2323)"
            fillOpacity="0.2"
          />
          <g filter="url(#filter18_dd_574_2323)">
            <rect
              x="849"
              y="81"
              width="3"
              height="3"
              rx="1.5"
              fill="url(#paint30_radial_574_2323)"
              shapeRendering="crispEdges"
            />
            <rect
              x="848.75"
              y="80.75"
              width="3.5"
              height="3.5"
              rx="1.75"
              stroke="black"
              strokeOpacity="0.05"
              strokeWidth="0.5"
              shapeRendering="crispEdges"
            />
          </g>
        </g>
        <rect
          x="802.375"
          y="75.375"
          width="55.25"
          height="39.25"
          rx="2.625"
          stroke="url(#paint31_radial_574_2323)"
          strokeOpacity="0.13"
          strokeWidth="0.75"
          shapeRendering="crispEdges"
        />
      </g>
      <path d="M822.25 71V0" stroke="white" strokeOpacity="0.3" strokeWidth="0.5" />
      <path d="M837.75 71V0" stroke="white" strokeOpacity="0.3" strokeWidth="0.5" />
      <path d="M837.75 71V0" stroke="url(#paint32_angular_574_2323)" strokeWidth="0.5" />
      <g filter="url(#filter19_b_574_2323)">
        <path
          d="M821 71.8C821 71.52 821 71.38 821.054 71.273C821.102 71.1789 821.179 71.1024 821.273 71.0545C821.38 71 821.52 71 821.8 71H822.7C822.98 71 823.12 71 823.227 71.0545C823.321 71.1024 823.398 71.1789 823.446 71.273C823.5 71.38 823.5 71.52 823.5 71.8V75H821V71.8Z"
          fill="black"
        />
        <path
          d="M821 71.8C821 71.52 821 71.38 821.054 71.273C821.102 71.1789 821.179 71.1024 821.273 71.0545C821.38 71 821.52 71 821.8 71H822.7C822.98 71 823.12 71 823.227 71.0545C823.321 71.1024 823.398 71.1789 823.446 71.273C823.5 71.38 823.5 71.52 823.5 71.8V75H821V71.8Z"
          fill="url(#paint33_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <g filter="url(#filter20_b_574_2323)">
        <path
          d="M836.5 71.8C836.5 71.52 836.5 71.38 836.554 71.273C836.602 71.1789 836.679 71.1024 836.773 71.0545C836.88 71 837.02 71 837.3 71H838.2C838.48 71 838.62 71 838.727 71.0545C838.821 71.1024 838.898 71.1789 838.946 71.273C839 71.38 839 71.52 839 71.8V75H836.5V71.8Z"
          fill="black"
        />
        <path
          d="M836.5 71.8C836.5 71.52 836.5 71.38 836.554 71.273C836.602 71.1789 836.679 71.1024 836.773 71.0545C836.88 71 837.02 71 837.3 71H838.2C838.48 71 838.62 71 838.727 71.0545C838.821 71.1024 838.898 71.1789 838.946 71.273C839 71.38 839 71.52 839 71.8V75H836.5V71.8Z"
          fill="url(#paint34_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <path
        d="M1378 245.25H1162"
        stroke="url(#paint35_linear_574_2323)"
        strokeOpacity="0.3"
        strokeWidth="0.5"
      />
      <path d="M1378 245.25H1162" stroke="url(#paint36_angular_574_2323)" strokeWidth="0.5" />
      <path
        d="M1378 236.25H1162"
        stroke="url(#paint37_linear_574_2323)"
        strokeOpacity="0.3"
        strokeWidth="0.5"
      />
      <path
        d="M1378 227.25H1162"
        stroke="url(#paint38_linear_574_2323)"
        strokeOpacity="0.3"
        strokeWidth="0.5"
      />
      <path d="M1378 227.25H1162" stroke="url(#paint39_angular_574_2323)" strokeWidth="0.5" />
      <path
        d="M1378 218.25H1162"
        stroke="url(#paint40_linear_574_2323)"
        strokeOpacity="0.3"
        strokeWidth="0.5"
      />
      <path d="M1378 218.25H1162" stroke="url(#paint41_angular_574_2323)" strokeWidth="0.5" />
      <path
        d="M1378 209.25H1162"
        stroke="url(#paint42_linear_574_2323)"
        strokeOpacity="0.3"
        strokeWidth="0.5"
      />
      <path d="M1378 209.25H1162" stroke="url(#paint43_angular_574_2323)" strokeWidth="0.5" />
      <path
        d="M1378 254.25H1162"
        stroke="url(#paint44_linear_574_2323)"
        strokeOpacity="0.3"
        strokeWidth="0.5"
      />
      <path
        d="M1378 263.25H1162"
        stroke="url(#paint45_linear_574_2323)"
        strokeOpacity="0.3"
        strokeWidth="0.5"
      />
      <path d="M1378 263.25H1162" stroke="url(#paint46_angular_574_2323)" strokeWidth="0.5" />
      <g filter="url(#filter21_b_574_2323)">
        <path
          d="M1158 245H1161.2C1161.48 245 1161.62 245 1161.73 245.054C1161.82 245.102 1161.9 245.179 1161.95 245.273C1162 245.38 1162 245.52 1162 245.8V246.7C1162 246.98 1162 247.12 1161.95 247.227C1161.9 247.321 1161.82 247.398 1161.73 247.446C1161.62 247.5 1161.48 247.5 1161.2 247.5H1158V245Z"
          fill="black"
        />
        <path
          d="M1158 245H1161.2C1161.48 245 1161.62 245 1161.73 245.054C1161.82 245.102 1161.9 245.179 1161.95 245.273C1162 245.38 1162 245.52 1162 245.8V246.7C1162 246.98 1162 247.12 1161.95 247.227C1161.9 247.321 1161.82 247.398 1161.73 247.446C1161.62 247.5 1161.48 247.5 1161.2 247.5H1158V245Z"
          fill="url(#paint47_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <g filter="url(#filter22_b_574_2323)">
        <path
          d="M1158 235H1161.2C1161.48 235 1161.62 235 1161.73 235.054C1161.82 235.102 1161.9 235.179 1161.95 235.273C1162 235.38 1162 235.52 1162 235.8V236.7C1162 236.98 1162 237.12 1161.95 237.227C1161.9 237.321 1161.82 237.398 1161.73 237.446C1161.62 237.5 1161.48 237.5 1161.2 237.5H1158V235Z"
          fill="black"
        />
        <path
          d="M1158 235H1161.2C1161.48 235 1161.62 235 1161.73 235.054C1161.82 235.102 1161.9 235.179 1161.95 235.273C1162 235.38 1162 235.52 1162 235.8V236.7C1162 236.98 1162 237.12 1161.95 237.227C1161.9 237.321 1161.82 237.398 1161.73 237.446C1161.62 237.5 1161.48 237.5 1161.2 237.5H1158V235Z"
          fill="url(#paint48_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <g filter="url(#filter23_b_574_2323)">
        <path
          d="M1158 226H1161.2C1161.48 226 1161.62 226 1161.73 226.054C1161.82 226.102 1161.9 226.179 1161.95 226.273C1162 226.38 1162 226.52 1162 226.8V227.7C1162 227.98 1162 228.12 1161.95 228.227C1161.9 228.321 1161.82 228.398 1161.73 228.446C1161.62 228.5 1161.48 228.5 1161.2 228.5H1158V226Z"
          fill="black"
        />
        <path
          d="M1158 226H1161.2C1161.48 226 1161.62 226 1161.73 226.054C1161.82 226.102 1161.9 226.179 1161.95 226.273C1162 226.38 1162 226.52 1162 226.8V227.7C1162 227.98 1162 228.12 1161.95 228.227C1161.9 228.321 1161.82 228.398 1161.73 228.446C1161.62 228.5 1161.48 228.5 1161.2 228.5H1158V226Z"
          fill="url(#paint49_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <g filter="url(#filter24_b_574_2323)">
        <path
          d="M1158 217H1161.2C1161.48 217 1161.62 217 1161.73 217.054C1161.82 217.102 1161.9 217.179 1161.95 217.273C1162 217.38 1162 217.52 1162 217.8V218.7C1162 218.98 1162 219.12 1161.95 219.227C1161.9 219.321 1161.82 219.398 1161.73 219.446C1161.62 219.5 1161.48 219.5 1161.2 219.5H1158V217Z"
          fill="black"
        />
        <path
          d="M1158 217H1161.2C1161.48 217 1161.62 217 1161.73 217.054C1161.82 217.102 1161.9 217.179 1161.95 217.273C1162 217.38 1162 217.52 1162 217.8V218.7C1162 218.98 1162 219.12 1161.95 219.227C1161.9 219.321 1161.82 219.398 1161.73 219.446C1161.62 219.5 1161.48 219.5 1161.2 219.5H1158V217Z"
          fill="url(#paint50_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <g filter="url(#filter25_b_574_2323)">
        <path
          d="M1158 208H1161.2C1161.48 208 1161.62 208 1161.73 208.054C1161.82 208.102 1161.9 208.179 1161.95 208.273C1162 208.38 1162 208.52 1162 208.8V209.7C1162 209.98 1162 210.12 1161.95 210.227C1161.9 210.321 1161.82 210.398 1161.73 210.446C1161.62 210.5 1161.48 210.5 1161.2 210.5H1158V208Z"
          fill="black"
        />
        <path
          d="M1158 208H1161.2C1161.48 208 1161.62 208 1161.73 208.054C1161.82 208.102 1161.9 208.179 1161.95 208.273C1162 208.38 1162 208.52 1162 208.8V209.7C1162 209.98 1162 210.12 1161.95 210.227C1161.9 210.321 1161.82 210.398 1161.73 210.446C1161.62 210.5 1161.48 210.5 1161.2 210.5H1158V208Z"
          fill="url(#paint51_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <g filter="url(#filter26_b_574_2323)">
        <path
          d="M1158 253H1161.2C1161.48 253 1161.62 253 1161.73 253.054C1161.82 253.102 1161.9 253.179 1161.95 253.273C1162 253.38 1162 253.52 1162 253.8V254.7C1162 254.98 1162 255.12 1161.95 255.227C1161.9 255.321 1161.82 255.398 1161.73 255.446C1161.62 255.5 1161.48 255.5 1161.2 255.5H1158V253Z"
          fill="black"
        />
        <path
          d="M1158 253H1161.2C1161.48 253 1161.62 253 1161.73 253.054C1161.82 253.102 1161.9 253.179 1161.95 253.273C1162 253.38 1162 253.52 1162 253.8V254.7C1162 254.98 1162 255.12 1161.95 255.227C1161.9 255.321 1161.82 255.398 1161.73 255.446C1161.62 255.5 1161.48 255.5 1161.2 255.5H1158V253Z"
          fill="url(#paint52_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <g filter="url(#filter27_b_574_2323)">
        <path
          d="M1158 262H1161.2C1161.48 262 1161.62 262 1161.73 262.054C1161.82 262.102 1161.9 262.179 1161.95 262.273C1162 262.38 1162 262.52 1162 262.8V263.7C1162 263.98 1162 264.12 1161.95 264.227C1161.9 264.321 1161.82 264.398 1161.73 264.446C1161.62 264.5 1161.48 264.5 1161.2 264.5H1158V262Z"
          fill="black"
        />
        <path
          d="M1158 262H1161.2C1161.48 262 1161.62 262 1161.73 262.054C1161.82 262.102 1161.9 262.179 1161.95 262.273C1162 262.38 1162 262.52 1162 262.8V263.7C1162 263.98 1162 264.12 1161.95 264.227C1161.9 264.321 1161.82 264.398 1161.73 264.446C1161.62 264.5 1161.48 264.5 1161.2 264.5H1158V262Z"
          fill="url(#paint53_linear_574_2323)"
          fillOpacity="0.6"
        />
      </g>
      <g filter="url(#filter28_d_574_2323)">
        <g clipPath="url(#clip3_574_2323)">
          <rect
            x="1014"
            y="164"
            width="144"
            height="144"
            rx="3"
            fill="white"
            fillOpacity="0.15"
            shapeRendering="crispEdges"
          />
          <rect
            x="1014"
            y="164"
            width="144"
            height="144"
            rx="3"
            fill="url(#paint54_radial_574_2323)"
            fillOpacity="0.6"
            shapeRendering="crispEdges"
          />
          <g filter="url(#filter29_di_574_2323)">
            <path
              fillRule="evenodd"
              clipRule="evenodd"
              d="M1066 221H1078L1066 253H1054L1066 221ZM1086 221H1098L1086 253H1074L1086 221ZM1118 221H1106L1094 253H1106L1118 221Z"
              fill="url(#paint55_linear_574_2323)"
              shapeRendering="crispEdges"
            />
          </g>
          <g filter="url(#filter30_dd_574_2323)">
            <rect
              x="1143"
              y="176"
              width="3"
              height="3"
              rx="1.5"
              fill="url(#paint56_radial_574_2323)"
            />
            <rect
              x="1143.25"
              y="176.25"
              width="2.5"
              height="2.5"
              rx="1.25"
              stroke="black"
              strokeOpacity="0.05"
              strokeWidth="0.5"
            />
          </g>
        </g>
        <rect
          x="1014.38"
          y="164.375"
          width="143.25"
          height="143.25"
          rx="2.625"
          stroke="url(#paint57_radial_574_2323)"
          strokeOpacity="0.13"
          strokeWidth="0.75"
          shapeRendering="crispEdges"
        />
      </g>
      <g filter="url(#filter31_d_574_2323)">
        <g clipPath="url(#clip4_574_2323)">
          <rect
            x="802"
            y="204"
            width="56"
            height="64"
            rx="3"
            fill="url(#paint58_radial_574_2323)"
            fillOpacity="0.6"
            shapeRendering="crispEdges"
          />
          <rect
            x="802"
            y="204"
            width="56"
            height="64"
            rx="3"
            fill="white"
            fillOpacity="0.15"
            shapeRendering="crispEdges"
          />
          <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M830 227H829.965H829.965C829.534 227 829.279 227 829.059 227.022C826.922 227.232 825.232 228.922 825.022 231.059C825 231.279 825 231.534 825 231.965L825 232V235H824.1H824.081C823.817 235 823.59 235 823.402 235.015C823.205 235.031 823.008 235.067 822.819 235.163C822.537 235.307 822.307 235.537 822.163 235.819C822.067 236.008 822.031 236.205 822.015 236.402C822 236.59 822 236.817 822 237.081V237.081V237.1V243.9V243.919V243.919C822 244.183 822 244.41 822.015 244.598C822.031 244.795 822.067 244.992 822.163 245.181C822.307 245.463 822.537 245.693 822.819 245.837C823.008 245.933 823.205 245.969 823.402 245.985C823.59 246 823.817 246 824.081 246H824.1H835.9H835.919C836.183 246 836.41 246 836.598 245.985C836.795 245.969 836.992 245.933 837.181 245.837C837.463 245.693 837.693 245.463 837.837 245.181C837.933 244.992 837.969 244.795 837.985 244.598C838 244.41 838 244.183 838 243.919V243.9V237.1V237.081C838 236.817 838 236.59 837.985 236.402C837.969 236.205 837.933 236.008 837.837 235.819C837.693 235.537 837.463 235.307 837.181 235.163C836.992 235.067 836.795 235.031 836.598 235.015C836.41 235 836.183 235 835.919 235H835.9H835V232V231.965C835 231.534 835 231.279 834.978 231.059C834.768 228.922 833.078 227.232 830.941 227.022C830.721 227 830.466 227 830.035 227H830.035H830ZM829.157 228.017C829.322 228.001 829.524 228 830 228C830.476 228 830.678 228.001 830.843 228.017C832.505 228.181 833.819 229.495 833.983 231.157C833.999 231.322 834 231.524 834 232V235H826V232C826 231.524 826.001 231.322 826.017 231.157C826.181 229.495 827.495 228.181 829.157 228.017ZM823.273 236.055C823.298 236.042 823.348 236.023 823.484 236.012C823.626 236 823.812 236 824.1 236H835.9C836.188 236 836.374 236 836.516 236.012C836.652 236.023 836.702 236.042 836.727 236.055C836.821 236.102 836.898 236.179 836.946 236.273C836.958 236.298 836.977 236.348 836.988 236.484C837 236.626 837 236.812 837 237.1V243.9C837 244.188 837 244.374 836.988 244.516C836.977 244.652 836.958 244.702 836.946 244.727C836.898 244.821 836.821 244.898 836.727 244.946C836.702 244.958 836.652 244.977 836.516 244.988C836.374 245 836.188 245 835.9 245H824.1C823.812 245 823.626 245 823.484 244.988C823.348 244.977 823.298 244.958 823.273 244.946C823.179 244.898 823.102 244.821 823.054 244.727C823.042 244.702 823.023 244.652 823.012 244.516C823 244.374 823 244.188 823 243.9V237.1C823 236.812 823 236.626 823.012 236.484C823.023 236.348 823.042 236.298 823.054 236.273C823.102 236.179 823.179 236.102 823.273 236.055Z"
            fill="url(#paint59_linear_574_2323)"
            fillOpacity="0.2"
          />
          <g filter="url(#filter32_dd_574_2323)">
            <rect
              x="849"
              y="210"
              width="3"
              height="3"
              rx="1.5"
              fill="url(#paint60_radial_574_2323)"
            />
            <rect
              x="849.25"
              y="210.25"
              width="2.5"
              height="2.5"
              rx="1.25"
              stroke="black"
              strokeOpacity="0.05"
              strokeWidth="0.5"
            />
          </g>
        </g>
        <rect
          x="802.375"
          y="204.375"
          width="55.25"
          height="63.25"
          rx="2.625"
          stroke="url(#paint61_radial_574_2323)"
          strokeOpacity="0.13"
          strokeWidth="0.75"
          shapeRendering="crispEdges"
        />
      </g>
    </g>
    <defs>
      <filter
        id="filter0_b_574_2323"
        x="1083.5"
        y="159"
        width="4.5"
        height="6"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter1_b_574_2323"
        x="820"
        y="199"
        width="4.5"
        height="6"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter2_b_574_2323"
        x="835.5"
        y="199"
        width="4.5"
        height="6"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter3_b_574_2323"
        x="820"
        y="114"
        width="4.5"
        height="6"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter4_b_574_2323"
        x="835.5"
        y="114"
        width="4.5"
        height="6"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter5_b_574_2323"
        x="1099"
        y="307"
        width="4.5"
        height="6"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter6_b_574_2323"
        x="1089"
        y="307"
        width="4.5"
        height="6"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter7_b_574_2323"
        x="1079"
        y="307"
        width="4.5"
        height="6"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter8_b_574_2323"
        x="1069"
        y="307"
        width="4.5"
        height="6"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter9_b_574_2323"
        x="1059"
        y="307"
        width="4.5"
        height="6"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter10_b_574_2323"
        x="1108.5"
        y="307"
        width="4.5"
        height="6"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter11_b_574_2323"
        x="1009"
        y="224"
        width="6"
        height="4.5"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter12_b_574_2323"
        x="1009"
        y="233"
        width="6"
        height="4.5"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter13_b_574_2323"
        x="1009"
        y="243"
        width="6"
        height="4.5"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter14_b_574_2323"
        x="857"
        y="224"
        width="6"
        height="4.5"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter15_b_574_2323"
        x="857"
        y="233"
        width="6"
        height="4.5"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter16_b_574_2323"
        x="857"
        y="242"
        width="6"
        height="4.5"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter17_d_574_2323"
        x="786"
        y="59"
        width="88"
        height="72"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feMorphology
          radius="4"
          operator="dilate"
          in="SourceAlpha"
          result="effect1_dropShadow_574_2323"
        />
        <feOffset />
        <feGaussianBlur stdDeviation="6" />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.8 0" />
        <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_dropShadow_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter18_dd_574_2323"
        x="828.5"
        y="60.5"
        width="44"
        height="44"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset />
        <feGaussianBlur stdDeviation="10" />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 0.466667 0 0 0 0 0.278431 0 0 0 0 1 0 0 0 1 0"
        />
        <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_574_2323" />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset />
        <feGaussianBlur stdDeviation="3" />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 0.466667 0 0 0 0 0.278431 0 0 0 0 1 0 0 0 1 0"
        />
        <feBlend
          mode="normal"
          in2="effect1_dropShadow_574_2323"
          result="effect2_dropShadow_574_2323"
        />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect2_dropShadow_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter19_b_574_2323"
        x="820"
        y="70"
        width="4.5"
        height="6"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter20_b_574_2323"
        x="835.5"
        y="70"
        width="4.5"
        height="6"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter21_b_574_2323"
        x="1157"
        y="244"
        width="6"
        height="4.5"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter22_b_574_2323"
        x="1157"
        y="234"
        width="6"
        height="4.5"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter23_b_574_2323"
        x="1157"
        y="225"
        width="6"
        height="4.5"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter24_b_574_2323"
        x="1157"
        y="216"
        width="6"
        height="4.5"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter25_b_574_2323"
        x="1157"
        y="207"
        width="6"
        height="4.5"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter26_b_574_2323"
        x="1157"
        y="252"
        width="6"
        height="4.5"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter27_b_574_2323"
        x="1157"
        y="261"
        width="6"
        height="4.5"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation="0.5" />
        <feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter28_d_574_2323"
        x="998"
        y="148"
        width="176"
        height="176"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feMorphology
          radius="4"
          operator="dilate"
          in="SourceAlpha"
          result="effect1_dropShadow_574_2323"
        />
        <feOffset />
        <feGaussianBlur stdDeviation="6" />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.8 0" />
        <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_dropShadow_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter29_di_574_2323"
        x="1054"
        y="221"
        width="64.25"
        height="32.25"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset dx="0.25" dy="0.25" />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix type="matrix" values="0 0 0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 0.15 0" />
        <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_dropShadow_574_2323"
          result="shape"
        />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset dx="0.25" dy="0.25" />
        <feComposite in2="hardAlpha" operator="arithmetic" k2="-1" k3="1" />
        <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.64 0" />
        <feBlend mode="normal" in2="shape" result="effect2_innerShadow_574_2323" />
      </filter>
      <filter
        id="filter30_dd_574_2323"
        x="1123"
        y="156"
        width="43"
        height="43"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset />
        <feGaussianBlur stdDeviation="10" />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 0.00784314 0 0 0 0 0.988235 0 0 0 0 0.945098 0 0 0 1 0"
        />
        <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_574_2323" />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset />
        <feGaussianBlur stdDeviation="3" />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 0.00784314 0 0 0 0 0.988235 0 0 0 0 0.945098 0 0 0 0.75 0"
        />
        <feBlend
          mode="normal"
          in2="effect1_dropShadow_574_2323"
          result="effect2_dropShadow_574_2323"
        />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect2_dropShadow_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter31_d_574_2323"
        x="786"
        y="188"
        width="88"
        height="96"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feMorphology
          radius="4"
          operator="dilate"
          in="SourceAlpha"
          result="effect1_dropShadow_574_2323"
        />
        <feOffset />
        <feGaussianBlur stdDeviation="6" />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.8 0" />
        <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_574_2323" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_dropShadow_574_2323"
          result="shape"
        />
      </filter>
      <filter
        id="filter32_dd_574_2323"
        x="829"
        y="190"
        width="43"
        height="43"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset />
        <feGaussianBlur stdDeviation="10" />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 0.00784314 0 0 0 0 0.988235 0 0 0 0 0.945098 0 0 0 1 0"
        />
        <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_574_2323" />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset />
        <feGaussianBlur stdDeviation="3" />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 0.00784314 0 0 0 0 0.988235 0 0 0 0 0.945098 0 0 0 0.75 0"
        />
        <feBlend
          mode="normal"
          in2="effect1_dropShadow_574_2323"
          result="effect2_dropShadow_574_2323"
        />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect2_dropShadow_574_2323"
          result="shape"
        />
      </filter>
      <radialGradient
        id="paint0_radial_574_2323"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(871 290) rotate(173.161) scale(571.063 240.167)"
      >
        <stop stopColor="white" />
        <stop offset="0.669795" stopColor="white" />
        <stop offset="0.950551" stopColor="white" stopOpacity="0" />
      </radialGradient>
      <linearGradient
        id="paint1_linear_574_2323"
        x1="1085.75"
        y1="160"
        x2="1085.75"
        y2="164"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <radialGradient
        id="paint2_angular_574_2323"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(780 169.625) scale(51.5)"
      >
        <stop stopColor="#9D72FF" />
        <stop offset="0.0001" stopColor="#9D72FF" stopOpacity="0" />
        <stop offset="0.199397" stopColor="#9D72FF" stopOpacity="0" />
        <stop offset="0.899479" stopColor="#9D72FF" stopOpacity="0" />
      </radialGradient>
      <linearGradient
        id="paint3_linear_574_2323"
        x1="822.25"
        y1="200"
        x2="822.25"
        y2="204"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <linearGradient
        id="paint4_linear_574_2323"
        x1="837.75"
        y1="200"
        x2="837.75"
        y2="204"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <linearGradient
        id="paint5_linear_574_2323"
        x1="822.25"
        y1="115"
        x2="822.25"
        y2="119"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <linearGradient
        id="paint6_linear_574_2323"
        x1="837.75"
        y1="115"
        x2="837.75"
        y2="119"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <radialGradient
        id="paint7_angular_574_2323"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(1039 413.5) scale(50 90.625)"
      >
        <stop stopColor="white" />
        <stop offset="0.0001" stopColor="white" stopOpacity="0" />
        <stop offset="0.199397" stopColor="white" stopOpacity="0" />
        <stop offset="0.889429" stopColor="white" stopOpacity="0" />
      </radialGradient>
      <radialGradient
        id="paint8_angular_574_2323"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(1015 370) scale(52 52)"
      >
        <stop stopColor="#3DC5FA" />
        <stop offset="0.0001" stopColor="#3DC5FA" stopOpacity="0" />
        <stop offset="0.199397" stopColor="#3DC5FA" stopOpacity="0" />
        <stop offset="0.885417" stopColor="#3DC5FA" stopOpacity="0" />
      </radialGradient>
      <radialGradient
        id="paint9_angular_574_2323"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(1074 355) scale(44 44)"
      >
        <stop stopColor="#3DC5FA" />
        <stop offset="0.0001" stopColor="#3DC5FA" stopOpacity="0" />
        <stop offset="0.199397" stopColor="#3DC5FA" stopOpacity="0" />
        <stop offset="0.885417" stopColor="#3DC5FA" stopOpacity="0" />
      </radialGradient>
      <linearGradient
        id="paint10_linear_574_2323"
        x1="1101.25"
        y1="308"
        x2="1101.25"
        y2="312"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <linearGradient
        id="paint11_linear_574_2323"
        x1="1091.25"
        y1="308"
        x2="1091.25"
        y2="312"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <linearGradient
        id="paint12_linear_574_2323"
        x1="1081.25"
        y1="308"
        x2="1081.25"
        y2="312"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <linearGradient
        id="paint13_linear_574_2323"
        x1="1071.25"
        y1="308"
        x2="1071.25"
        y2="312"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <linearGradient
        id="paint14_linear_574_2323"
        x1="1061.25"
        y1="308"
        x2="1061.25"
        y2="312"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <linearGradient
        id="paint15_linear_574_2323"
        x1="1110.75"
        y1="308"
        x2="1110.75"
        y2="312"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <linearGradient
        id="paint16_linear_574_2323"
        x1="895.328"
        y1="11"
        x2="895.328"
        y2="226.25"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.204413" stopColor="white" stopOpacity="0" />
        <stop offset="1" stopColor="white" />
      </linearGradient>
      <radialGradient
        id="paint17_angular_574_2323"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(936 246) rotate(-90) scale(74 74)"
      >
        <stop offset="0.829622" stopColor="#3CEEAE" stopOpacity="0" />
        <stop offset="0.9999" stopColor="#3CEEAE" />
        <stop offset="1" stopColor="#3CEEAE" stopOpacity="0" />
      </radialGradient>
      <linearGradient
        id="paint18_linear_574_2323"
        x1="895.328"
        y1="20"
        x2="895.328"
        y2="235.25"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.204413" stopColor="white" stopOpacity="0" />
        <stop offset="1" stopColor="white" />
      </linearGradient>
      <radialGradient
        id="paint19_angular_574_2323"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(990 250) rotate(-90) scale(57 57)"
      >
        <stop offset="0.789488" stopColor="#3CEEAE" stopOpacity="0" />
        <stop offset="0.9999" stopColor="#3CEEAE" />
        <stop offset="1" stopColor="#3CEEAE" stopOpacity="0" />
      </radialGradient>
      <linearGradient
        id="paint20_linear_574_2323"
        x1="895.328"
        y1="29"
        x2="895.328"
        y2="244.25"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.204413" stopColor="white" stopOpacity="0" />
        <stop offset="1" stopColor="white" />
      </linearGradient>
      <radialGradient
        id="paint21_angular_574_2323"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(966 265) rotate(-90) scale(46 46)"
      >
        <stop offset="0.821417" stopColor="#3CEEAE" stopOpacity="0" />
        <stop offset="0.9999" stopColor="#3CEEAE" />
        <stop offset="1" stopColor="#3CEEAE" stopOpacity="0" />
      </radialGradient>
      <linearGradient
        id="paint22_linear_574_2323"
        x1="1012"
        y1="225"
        x2="1012"
        y2="227.5"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <linearGradient
        id="paint23_linear_574_2323"
        x1="1012"
        y1="234"
        x2="1012"
        y2="236.5"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <linearGradient
        id="paint24_linear_574_2323"
        x1="1012"
        y1="244"
        x2="1012"
        y2="246.5"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <linearGradient
        id="paint25_linear_574_2323"
        x1="860"
        y1="225"
        x2="860"
        y2="227.5"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <linearGradient
        id="paint26_linear_574_2323"
        x1="860"
        y1="234"
        x2="860"
        y2="236.5"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <linearGradient
        id="paint27_linear_574_2323"
        x1="860"
        y1="243"
        x2="860"
        y2="245.5"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <radialGradient
        id="paint28_radial_574_2323"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(830 75) rotate(90) scale(40 50.96)"
      >
        <stop stopColor="white" stopOpacity="0.2" />
        <stop offset="1" stopColor="white" stopOpacity="0" />
      </radialGradient>
      <linearGradient
        id="paint29_linear_574_2323"
        x1="830"
        y1="94.4375"
        x2="830"
        y2="104"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" />
        <stop offset="1" stopColor="white" stopOpacity="0.4" />
      </linearGradient>
      <radialGradient
        id="paint30_radial_574_2323"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(850.506 82.5) scale(1.49383 1.5)"
      >
        <stop offset="0.0416667" stopColor="#D4C5FF" />
        <stop offset="1" stopColor="#6015FF" />
      </radialGradient>
      <radialGradient
        id="paint31_radial_574_2323"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(858 75) rotate(90) scale(40 56)"
      >
        <stop stopColor="white" />
        <stop offset="1" stopColor="white" stopOpacity="0" />
      </radialGradient>
      <radialGradient
        id="paint32_angular_574_2323"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(808 51) scale(62 62)"
      >
        <stop stopColor="#9D72FF" />
        <stop offset="0.0001" stopColor="#9D72FF" stopOpacity="0" />
        <stop offset="0.778822" stopColor="#9D72FF" stopOpacity="0" />
      </radialGradient>
      <linearGradient
        id="paint33_linear_574_2323"
        x1="822.25"
        y1="71"
        x2="822.25"
        y2="75"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <linearGradient
        id="paint34_linear_574_2323"
        x1="837.75"
        y1="71"
        x2="837.75"
        y2="75"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <linearGradient
        id="paint35_linear_574_2323"
        x1="1213.68"
        y1="30"
        x2="1213.68"
        y2="245.25"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.204413" stopColor="white" stopOpacity="0" />
        <stop offset="1" stopColor="white" />
      </linearGradient>
      <radialGradient
        id="paint36_angular_574_2323"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(1292 262) rotate(-90) scale(66 66)"
      >
        <stop offset="0.787112" stopColor="#3DC5FA" stopOpacity="0" />
        <stop offset="0.9999" stopColor="#3DC5FA" />
        <stop offset="1" stopColor="#3DC5FA" stopOpacity="0" />
      </radialGradient>
      <linearGradient
        id="paint37_linear_574_2323"
        x1="1213.68"
        y1="21"
        x2="1213.68"
        y2="236.25"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.204413" stopColor="white" stopOpacity="0" />
        <stop offset="1" stopColor="white" />
      </linearGradient>
      <linearGradient
        id="paint38_linear_574_2323"
        x1="1213.68"
        y1="12"
        x2="1213.68"
        y2="227.25"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.204413" stopColor="white" stopOpacity="0" />
        <stop offset="1" stopColor="white" />
      </linearGradient>
      <radialGradient
        id="paint39_angular_574_2323"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(1231 251) rotate(-90) scale(79)"
      >
        <stop offset="0.829008" stopColor="#3DC5FA" stopOpacity="0" />
        <stop offset="0.9999" stopColor="#3DC5FA" />
        <stop offset="1" stopColor="#3DC5FA" stopOpacity="0" />
      </radialGradient>
      <linearGradient
        id="paint40_linear_574_2323"
        x1="1213.68"
        y1="3"
        x2="1213.68"
        y2="218.25"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.204413" stopColor="white" stopOpacity="0" />
        <stop offset="1" stopColor="white" />
      </linearGradient>
      <radialGradient
        id="paint41_angular_574_2323"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(1324 235) rotate(-90) scale(58 58)"
      >
        <stop offset="0.777021" stopColor="#3DC5FA" stopOpacity="0" />
        <stop offset="0.9999" stopColor="#3DC5FA" />
        <stop offset="1" stopColor="#3DC5FA" stopOpacity="0" />
      </radialGradient>
      <linearGradient
        id="paint42_linear_574_2323"
        x1="1213.68"
        y1="-6"
        x2="1213.68"
        y2="209.25"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.204413" stopColor="white" stopOpacity="0" />
        <stop offset="1" stopColor="white" />
      </linearGradient>
      <radialGradient
        id="paint43_angular_574_2323"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(1270 229) rotate(-90) scale(74 74)"
      >
        <stop offset="0.802794" stopColor="#3DC5FA" stopOpacity="0" />
        <stop offset="0.9999" stopColor="#3DC5FA" />
        <stop offset="1" stopColor="#3DC5FA" stopOpacity="0" />
      </radialGradient>
      <linearGradient
        id="paint44_linear_574_2323"
        x1="1213.68"
        y1="39"
        x2="1213.68"
        y2="254.25"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.204413" stopColor="white" stopOpacity="0" />
        <stop offset="1" stopColor="white" />
      </linearGradient>
      <linearGradient
        id="paint45_linear_574_2323"
        x1="1213.68"
        y1="48"
        x2="1213.68"
        y2="263.25"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.204413" stopColor="white" stopOpacity="0" />
        <stop offset="1" stopColor="white" />
      </linearGradient>
      <radialGradient
        id="paint46_angular_574_2323"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(1216 287) rotate(-90) scale(55)"
      >
        <stop offset="0.830707" stopColor="#3DC5FA" stopOpacity="0" />
        <stop offset="0.9999" stopColor="#3DC5FA" />
        <stop offset="1" stopColor="#3DC5FA" stopOpacity="0" />
      </radialGradient>
      <linearGradient
        id="paint47_linear_574_2323"
        x1="1160"
        y1="245"
        x2="1160"
        y2="247.5"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <linearGradient
        id="paint48_linear_574_2323"
        x1="1160"
        y1="235"
        x2="1160"
        y2="237.5"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <linearGradient
        id="paint49_linear_574_2323"
        x1="1160"
        y1="226"
        x2="1160"
        y2="228.5"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <linearGradient
        id="paint50_linear_574_2323"
        x1="1160"
        y1="217"
        x2="1160"
        y2="219.5"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <linearGradient
        id="paint51_linear_574_2323"
        x1="1160"
        y1="208"
        x2="1160"
        y2="210.5"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <linearGradient
        id="paint52_linear_574_2323"
        x1="1160"
        y1="253"
        x2="1160"
        y2="255.5"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <linearGradient
        id="paint53_linear_574_2323"
        x1="1160"
        y1="262"
        x2="1160"
        y2="264.5"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0.6" />
        <stop offset="1" stopColor="white" stopOpacity="0.3" />
      </linearGradient>
      <radialGradient
        id="paint54_radial_574_2323"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(1086 164) rotate(90) scale(144 131.04)"
      >
        <stop stopColor="white" stopOpacity="0.2" />
        <stop offset="1" stopColor="white" stopOpacity="0" />
      </radialGradient>
      <linearGradient
        id="paint55_linear_574_2323"
        x1="1086"
        y1="221"
        x2="1086"
        y2="253"
        gradientUnits="userSpaceOnUse"
      >
        <stop />
        <stop offset="0.0001" stopOpacity="0.41" />
        <stop offset="1" stopOpacity="0.1" />
      </linearGradient>
      <radialGradient
        id="paint56_radial_574_2323"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(1144.51 177.5) scale(1.49383 1.5)"
      >
        <stop stopColor="#72FFF9" />
        <stop offset="1" stopColor="#0284FC" />
      </radialGradient>
      <radialGradient
        id="paint57_radial_574_2323"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(1158 164) rotate(90) scale(144 244)"
      >
        <stop stopColor="white" />
        <stop offset="1" stopColor="white" stopOpacity="0" />
      </radialGradient>
      <radialGradient
        id="paint58_radial_574_2323"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(830 204) rotate(90) scale(64 50.96)"
      >
        <stop stopColor="white" stopOpacity="0.2" />
        <stop offset="1" stopColor="white" stopOpacity="0" />
      </radialGradient>
      <linearGradient
        id="paint59_linear_574_2323"
        x1="830"
        y1="229"
        x2="830"
        y2="244"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" />
        <stop offset="1" stopColor="white" stopOpacity="0.4" />
      </linearGradient>
      <radialGradient
        id="paint60_radial_574_2323"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(850.506 211.5) scale(1.49383 1.5)"
      >
        <stop stopColor="#72FFAA" />
        <stop offset="1" stopColor="#00DAB3" />
      </radialGradient>
      <radialGradient
        id="paint61_radial_574_2323"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(858 204) rotate(90) scale(64 56)"
      >
        <stop stopColor="white" />
        <stop offset="1" stopColor="white" stopOpacity="0" />
      </radialGradient>
      <clipPath id="clip0_574_2323">
        <rect width="40" height="77" fill="white" transform="translate(592 233)" />
      </clipPath>
      <clipPath id="clip1_574_2323">
        <rect width="80" height="40" fill="white" transform="translate(843 293)" />
      </clipPath>
      <clipPath id="clip2_574_2323">
        <rect x="802" y="75" width="56" height="40" rx="3" fill="white" />
      </clipPath>
      <clipPath id="clip3_574_2323">
        <rect x="1014" y="164" width="144" height="144" rx="3" fill="white" />
      </clipPath>
      <clipPath id="clip4_574_2323">
        <rect x="802" y="204" width="56" height="64" rx="3" fill="white" />
      </clipPath>
    </defs>
  </svg>
);

export function SubHeroMainboardStuff({ className }: { className?: string }) {
  return (
    <svg
      width="908"
      height="357"
      viewBox="0 0 908 357"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      className={className}
    >
      <mask
        id="mask0_1_215"
        style={{ maskType: "alpha" }}
        maskUnits="userSpaceOnUse"
        x="0"
        y="0"
        width="1072"
        height="324"
      >
        <rect
          width="1072"
          height="323"
          transform="translate(0 0.25)"
          fill="url(#paint0_radial_1_215)"
        />
      </mask>
      <g mask="url(#mask0_1_215)">
        <path
          d="M1072 194.25H735.604C731.69 194.25 729.734 194.25 727.892 193.808C726.26 193.416 724.699 192.77 723.267 191.892C721.653 190.903 720.269 189.519 717.502 186.752L640 109.25"
          stroke="white"
          strokeOpacity="0.08"
          strokeWidth="0.5"
        />
        <rect x="828" y="149" width="21" height="24" rx="3" fill="white" fillOpacity="0.16" />
        <rect x="831" y="163" width="15" height="6" rx="1.5" fill="white" fillOpacity="0.16" />
        <rect x="746" y="151" width="8" height="2" fill="white" fillOpacity="0.18" />
        <rect x="746" y="151" width="8" height="1" fill="white" fillOpacity="0.14" />
        <rect x="746" y="161" width="8" height="2" fill="white" fillOpacity="0.18" />
        <rect x="746" y="161" width="8" height="1" fill="white" fillOpacity="0.14" />
        <rect x="747" y="155" width="2" height="4" fill="white" fillOpacity="0.18" />
        <rect x="747" y="155" width="2" height="1" fill="white" fillOpacity="0.14" />
        <rect x="751" y="155" width="2" height="4" fill="white" fillOpacity="0.18" />
        <rect x="751" y="155" width="2" height="1" fill="white" fillOpacity="0.14" />
        <rect x="746" y="171" width="8" height="2" fill="white" fillOpacity="0.18" />
        <rect x="746" y="171" width="8" height="1" fill="white" fillOpacity="0.14" />
        <rect x="746" y="181" width="8" height="2" fill="white" fillOpacity="0.18" />
        <rect x="746" y="181" width="8" height="1" fill="white" fillOpacity="0.14" />
        <rect x="747" y="175" width="2" height="4" fill="white" fillOpacity="0.18" />
        <rect x="747" y="175" width="2" height="1" fill="white" fillOpacity="0.14" />
        <rect x="751" y="175" width="2" height="4" fill="white" fillOpacity="0.18" />
        <rect x="751" y="175" width="2" height="1" fill="white" fillOpacity="0.14" />
        <rect x="762" y="171" width="8" height="2" fill="white" fillOpacity="0.18" />
        <rect x="762" y="171" width="8" height="1" fill="white" fillOpacity="0.14" />
        <rect x="762" y="181" width="8" height="2" fill="white" fillOpacity="0.18" />
        <rect x="762" y="181" width="8" height="1" fill="white" fillOpacity="0.14" />
        <rect x="763" y="175" width="2" height="4" fill="white" fillOpacity="0.18" />
        <rect x="763" y="175" width="2" height="1" fill="white" fillOpacity="0.14" />
        <rect x="767" y="175" width="2" height="4" fill="white" fillOpacity="0.18" />
        <rect x="767" y="175" width="2" height="1" fill="white" fillOpacity="0.14" />
        <rect x="778" y="171" width="8" height="2" fill="white" fillOpacity="0.18" />
        <rect x="778" y="171" width="8" height="1" fill="white" fillOpacity="0.14" />
        <rect x="778" y="181" width="8" height="2" fill="white" fillOpacity="0.18" />
        <rect x="778" y="181" width="8" height="1" fill="white" fillOpacity="0.14" />
        <rect x="779" y="175" width="2" height="4" fill="white" fillOpacity="0.18" />
        <rect x="779" y="175" width="2" height="1" fill="white" fillOpacity="0.14" />
        <rect x="783" y="175" width="2" height="4" fill="white" fillOpacity="0.18" />
        <rect x="783" y="175" width="2" height="1" fill="white" fillOpacity="0.14" />
        <rect x="762" y="151" width="8" height="2" fill="white" fillOpacity="0.18" />
        <rect x="762" y="151" width="8" height="1" fill="white" fillOpacity="0.14" />
        <rect x="762" y="161" width="8" height="2" fill="white" fillOpacity="0.18" />
        <rect x="762" y="161" width="8" height="1" fill="white" fillOpacity="0.14" />
        <rect x="763" y="155" width="2" height="4" fill="white" fillOpacity="0.18" />
        <rect x="763" y="155" width="2" height="1" fill="white" fillOpacity="0.14" />
        <rect x="767" y="155" width="2" height="4" fill="white" fillOpacity="0.18" />
        <rect x="767" y="155" width="2" height="1" fill="white" fillOpacity="0.14" />
        <path d="M869 194.5V323" stroke="white" strokeOpacity="0.04" strokeWidth="2" />
        <path d="M918 0.25H807.25V194" stroke="white" strokeOpacity="0.08" strokeWidth="0.5" />
        <path
          d="M924.25 323.25H807.25V194.5"
          stroke="white"
          strokeOpacity="0.08"
          strokeWidth="0.5"
        />
        <path
          d="M0 237.25H312.084C314.115 237.25 315.131 237.25 316.105 237.055C316.968 236.881 317.806 236.595 318.594 236.202C319.483 235.76 320.286 235.137 321.891 233.892L351.296 211.081C353.114 209.67 354.023 208.965 354.678 208.081C355.258 207.298 355.69 206.416 355.953 205.478C356.25 204.419 356.25 203.268 356.25 200.967V105"
          stroke="white"
          strokeOpacity="0.08"
          strokeWidth="0.5"
        />
        <path d="M356 157.25H177.25V237" stroke="white" strokeOpacity="0.08" strokeWidth="0.5" />
        <rect x="321" y="142" width="2" height="6" fill="white" fillOpacity="0.18" />
        <rect x="326" y="142" width="2" height="6" fill="white" fillOpacity="0.18" />
        <rect x="331" y="142" width="2" height="6" fill="white" fillOpacity="0.18" />
        <rect x="336" y="142" width="2" height="6" fill="white" fillOpacity="0.18" />
        <rect x="341" y="142" width="2" height="6" fill="white" fillOpacity="0.18" />
        <rect x="346" y="142" width="2" height="6" fill="white" fillOpacity="0.18" />
        <path d="M177.25 7.5V157" stroke="white" strokeOpacity="0.08" strokeWidth="0.5" />
        <rect opacity="0.02" x="183" y="163" width="75" height="68" rx="0.5" fill="white" />
        <rect opacity="0.05" x="187" y="189" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="187" y="182" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="187" y="174" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="187" y="174" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="187" y="167" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="187" y="196" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="187" y="203" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="187" y="210" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="187" y="217" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="187" y="224" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="195" y="189" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="195" y="182" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="195" y="174" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="195" y="174" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="195" y="167" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="195" y="196" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.1" x="195" y="203" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="195" y="210" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="195" y="217" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="195" y="224" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="203" y="189" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="203" y="182" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="203" y="174" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="203" y="174" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="203" y="167" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="203" y="196" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="203" y="203" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="203" y="210" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="203" y="217" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.15" x="203" y="224" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.1" x="211" y="189" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="211" y="182" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="211" y="174" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="211" y="174" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="211" y="167" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="211" y="196" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="211" y="203" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="211" y="210" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="211" y="217" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="211" y="224" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="219" y="189" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="219" y="182" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="219" y="174" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="219" y="174" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="219" y="167" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="219" y="196" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="219" y="203" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.15" x="219" y="210" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="219" y="217" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="219" y="224" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="227" y="189" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="227" y="182" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="227" y="174" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="227" y="174" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="227" y="167" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="227" y="196" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="227" y="203" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="227" y="210" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="227" y="217" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="227" y="224" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="235" y="189" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="235" y="182" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="235" y="174" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="235" y="174" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="235" y="167" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="235" y="196" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.15" x="235" y="203" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="235" y="210" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="235" y="217" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="235" y="224" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.1" x="243" y="189" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="243" y="182" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="243" y="174" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="243" y="174" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="243" y="167" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="243" y="196" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="243" y="203" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="243" y="210" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="243" y="217" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.1" x="243" y="224" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="251" y="189" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="251" y="182" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="251" y="174" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="251" y="174" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="251" y="167" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="251" y="196" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="251" y="203" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="251" y="210" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="251" y="217" width="3" height="3" rx="0.5" fill="white" />
        <rect opacity="0.05" x="251" y="224" width="3" height="3" rx="0.5" fill="white" />
        <rect x="107" y="215" width="2" height="8" fill="white" fillOpacity="0.18" />
        <rect x="111" y="215" width="2" height="8" fill="white" fillOpacity="0.18" />
        <rect x="102" y="218" width="2" height="2" fill="white" fillOpacity="0.18" />
        <rect x="102" y="218" width="2" height="1" fill="white" fillOpacity="0.14" />
        <rect x="107" y="215" width="2" height="1" fill="white" fillOpacity="0.14" />
        <rect x="111" y="215" width="2" height="1" fill="white" fillOpacity="0.14" />
        <rect x="107" y="199" width="2" height="8" fill="white" fillOpacity="0.18" />
        <rect x="111" y="199" width="2" height="8" fill="white" fillOpacity="0.18" />
        <rect x="102" y="202" width="2" height="2" fill="white" fillOpacity="0.18" />
        <rect x="102" y="202" width="2" height="1" fill="white" fillOpacity="0.14" />
        <rect x="107" y="199" width="2" height="1" fill="white" fillOpacity="0.14" />
        <rect x="111" y="199" width="2" height="1" fill="white" fillOpacity="0.14" />
        <rect x="107" y="183" width="2" height="8" fill="white" fillOpacity="0.18" />
        <rect x="111" y="183" width="2" height="8" fill="white" fillOpacity="0.18" />
        <rect x="102" y="186" width="2" height="2" fill="white" fillOpacity="0.18" />
        <rect x="102" y="186" width="2" height="1" fill="white" fillOpacity="0.14" />
        <rect x="107" y="183" width="2" height="1" fill="white" fillOpacity="0.14" />
        <rect x="111" y="183" width="2" height="1" fill="white" fillOpacity="0.14" />
        <rect x="126" y="215" width="2" height="8" fill="white" fillOpacity="0.18" />
        <rect x="130" y="215" width="2" height="8" fill="white" fillOpacity="0.18" />
        <rect x="121" y="218" width="2" height="2" fill="white" fillOpacity="0.18" />
        <rect x="121" y="218" width="2" height="1" fill="white" fillOpacity="0.14" />
        <rect x="126" y="215" width="2" height="1" fill="white" fillOpacity="0.14" />
        <rect x="130" y="215" width="2" height="1" fill="white" fillOpacity="0.14" />
        <path
          d="M286 7.25H158.67C154.111 7.25 151.831 7.25 149.729 7.83406C147.867 8.35146 146.114 9.20191 144.555 10.3442C142.796 11.6337 141.385 13.4244 138.563 17.0056L92.7424 75.1548C90.7062 77.7388 89.6881 79.0309 88.9644 80.4657C88.3222 81.7388 87.8532 83.092 87.5696 84.4893C87.25 86.0643 87.25 87.7092 87.25 90.9992V237"
          stroke="white"
          strokeOpacity="0.08"
          strokeWidth="0.5"
        />
        <g clipPath="url(#clip0_1_215)">
          <path
            d="M744 288C749.333 282.667 852.889 179.111 904 128"
            stroke="white"
            strokeOpacity="0.3"
            strokeWidth="0.3"
          />
          <path
            d="M752 288C757.333 282.667 860.889 179.111 912 128"
            stroke="white"
            strokeOpacity="0.3"
            strokeWidth="0.3"
          />
          <path
            d="M760 288C765.333 282.667 868.889 179.111 920 128"
            stroke="white"
            strokeOpacity="0.3"
            strokeWidth="0.3"
          />
          <path
            d="M768 288C773.333 282.667 876.889 179.111 928 128"
            stroke="white"
            strokeOpacity="0.3"
            strokeWidth="0.3"
          />
          <path
            d="M776 288C781.333 282.667 884.889 179.111 936 128"
            stroke="white"
            strokeOpacity="0.3"
            strokeWidth="0.3"
          />
          <path
            d="M784 288C789.333 282.667 892.889 179.111 944 128"
            stroke="white"
            strokeOpacity="0.3"
            strokeWidth="0.3"
          />
          <path
            d="M792 288C797.333 282.667 900.889 179.111 952 128"
            stroke="white"
            strokeOpacity="0.3"
            strokeWidth="0.3"
          />
          <path
            d="M800 288C805.333 282.667 908.889 179.111 960 128"
            stroke="white"
            strokeOpacity="0.3"
            strokeWidth="0.3"
          />
          <path
            d="M808 288C813.333 282.667 916.889 179.111 968 128"
            stroke="white"
            strokeOpacity="0.3"
            strokeWidth="0.3"
          />
          <path
            d="M816 288C821.333 282.667 924.889 179.111 976 128"
            stroke="white"
            strokeOpacity="0.3"
            strokeWidth="0.3"
          />
          <path
            d="M824 288C829.333 282.667 932.889 179.111 984 128"
            stroke="white"
            strokeOpacity="0.3"
            strokeWidth="0.3"
          />
          <path
            d="M832 288C837.333 282.667 940.889 179.111 992 128"
            stroke="white"
            strokeOpacity="0.3"
            strokeWidth="0.3"
          />
          <path
            d="M840 288C845.333 282.667 948.889 179.111 1000 128"
            stroke="white"
            strokeOpacity="0.3"
            strokeWidth="0.3"
          />
          <path
            d="M848 288C853.333 282.667 956.889 179.111 1008 128"
            stroke="white"
            strokeOpacity="0.3"
            strokeWidth="0.3"
          />
        </g>
        <rect x="818" y="298" width="2" height="6" fill="white" fillOpacity="0.18" />
        <rect x="823" y="298" width="2" height="6" fill="white" fillOpacity="0.18" />
        <rect x="828" y="298" width="2" height="6" fill="white" fillOpacity="0.18" />
        <rect x="833" y="298" width="2" height="6" fill="white" fillOpacity="0.18" />
        <rect x="838" y="298" width="2" height="6" fill="white" fillOpacity="0.18" />
        <rect x="843" y="298" width="2" height="6" fill="white" fillOpacity="0.18" />
      </g>
      <path d="M566.25 357V109" stroke="url(#paint1_linear_1_215)" strokeWidth="0.5" />
      <path d="M546.25 357V109" stroke="url(#paint2_linear_1_215)" strokeWidth="0.5" />
      <path d="M526.25 357V109" stroke="url(#paint3_linear_1_215)" strokeWidth="0.5" />
      <path
        d="M526.25 357V109"
        stroke="url(#paint4_angular_1_215)"
        strokeOpacity="0.5"
        strokeWidth="0.5"
      />
      <path d="M506.25 357V109" stroke="url(#paint5_linear_1_215)" strokeWidth="0.5" />
      <path d="M486.25 357V109" stroke="url(#paint6_linear_1_215)" strokeWidth="0.5" />
      <path
        d="M486.25 357V109"
        stroke="url(#paint7_angular_1_215)"
        strokeOpacity="0.5"
        strokeWidth="0.5"
      />
      <path d="M496.25 357V109" stroke="url(#paint8_linear_1_215)" strokeWidth="0.5" />
      <path d="M516.25 357V109" stroke="url(#paint9_linear_1_215)" strokeWidth="0.5" />
      <path d="M536.25 357V109" stroke="url(#paint10_linear_1_215)" strokeWidth="0.5" />
      <path d="M556.25 357V109" stroke="url(#paint11_linear_1_215)" strokeWidth="0.5" />
      <path d="M576.25 357V109" stroke="url(#paint12_linear_1_215)" strokeWidth="0.5" />
      <path d="M585.25 357V109" stroke="url(#paint13_linear_1_215)" strokeWidth="0.5" />
      <path
        d="M585.25 357V109"
        stroke="url(#paint14_angular_1_215)"
        strokeOpacity="0.5"
        strokeWidth="0.5"
      />
      <defs>
        <radialGradient
          id="paint0_radial_1_215"
          cx="0"
          cy="0"
          r="1"
          gradientUnits="userSpaceOnUse"
          gradientTransform="translate(536 161.5) rotate(90) scale(161.5 536)"
        >
          <stop stopColor="white" />
          <stop offset="0.496904" stopColor="white" />
          <stop offset="1" stopColor="white" stopOpacity="0" />
        </radialGradient>
        <linearGradient
          id="paint1_linear_1_215"
          x1="566.75"
          y1="109"
          x2="566.75"
          y2="357"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="white" stopOpacity="0.15" />
          <stop offset="1" stopColor="white" stopOpacity="0.05" />
        </linearGradient>
        <linearGradient
          id="paint2_linear_1_215"
          x1="546.75"
          y1="109"
          x2="546.75"
          y2="357"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="white" stopOpacity="0.15" />
          <stop offset="1" stopColor="white" stopOpacity="0.05" />
        </linearGradient>
        <linearGradient
          id="paint3_linear_1_215"
          x1="526.75"
          y1="109"
          x2="526.75"
          y2="357"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="white" stopOpacity="0.15" />
          <stop offset="1" stopColor="white" stopOpacity="0.05" />
        </linearGradient>
        <radialGradient
          id="paint4_angular_1_215"
          cx="0"
          cy="0"
          r="1"
          gradientUnits="userSpaceOnUse"
          gradientTransform="translate(483 306.421) scale(55 213.125)"
        >
          <stop stopColor="white" />
          <stop offset="0.0001" stopColor="white" stopOpacity="0" />
          <stop offset="0.199397" stopColor="white" stopOpacity="0" />
          <stop offset="0.939101" stopColor="white" stopOpacity="0" />
        </radialGradient>
        <linearGradient
          id="paint5_linear_1_215"
          x1="506.75"
          y1="109"
          x2="506.75"
          y2="357"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="white" stopOpacity="0.15" />
          <stop offset="1" stopColor="white" stopOpacity="0.05" />
        </linearGradient>
        <linearGradient
          id="paint6_linear_1_215"
          x1="486.75"
          y1="109"
          x2="486.75"
          y2="357"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="white" stopOpacity="0.15" />
          <stop offset="1" stopColor="white" stopOpacity="0.05" />
        </linearGradient>
        <radialGradient
          id="paint7_angular_1_215"
          cx="0"
          cy="0"
          r="1"
          gradientUnits="userSpaceOnUse"
          gradientTransform="translate(445 257.474) scale(72 117.474)"
        >
          <stop stopColor="white" />
          <stop offset="0.0001" stopColor="white" stopOpacity="0" />
          <stop offset="0.199397" stopColor="white" stopOpacity="0" />
          <stop offset="0.856266" stopColor="white" stopOpacity="0" />
        </radialGradient>
        <linearGradient
          id="paint8_linear_1_215"
          x1="496.75"
          y1="109"
          x2="496.75"
          y2="357"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="white" stopOpacity="0.15" />
          <stop offset="1" stopColor="white" stopOpacity="0.05" />
        </linearGradient>
        <linearGradient
          id="paint9_linear_1_215"
          x1="516.75"
          y1="109"
          x2="516.75"
          y2="357"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="white" stopOpacity="0.15" />
          <stop offset="1" stopColor="white" stopOpacity="0.05" />
        </linearGradient>
        <linearGradient
          id="paint10_linear_1_215"
          x1="536.75"
          y1="109"
          x2="536.75"
          y2="357"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="white" stopOpacity="0.15" />
          <stop offset="1" stopColor="white" stopOpacity="0.05" />
        </linearGradient>
        <linearGradient
          id="paint11_linear_1_215"
          x1="556.75"
          y1="109"
          x2="556.75"
          y2="357"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="white" stopOpacity="0.15" />
          <stop offset="1" stopColor="white" stopOpacity="0.05" />
        </linearGradient>
        <linearGradient
          id="paint12_linear_1_215"
          x1="576.75"
          y1="109"
          x2="576.75"
          y2="357"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="white" stopOpacity="0.15" />
          <stop offset="1" stopColor="white" stopOpacity="0.05" />
        </linearGradient>
        <linearGradient
          id="paint13_linear_1_215"
          x1="585.75"
          y1="109"
          x2="585.75"
          y2="357"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="white" stopOpacity="0.15" />
          <stop offset="1" stopColor="white" stopOpacity="0.05" />
        </linearGradient>
        <radialGradient
          id="paint14_angular_1_215"
          cx="0"
          cy="0"
          r="1"
          gradientUnits="userSpaceOnUse"
          gradientTransform="translate(549.5 213.625) scale(45 174.375)"
        >
          <stop stopColor="white" />
          <stop offset="0.0001" stopColor="white" stopOpacity="0" />
          <stop offset="0.199397" stopColor="white" stopOpacity="0" />
          <stop offset="0.946685" stopColor="white" stopOpacity="0" />
        </radialGradient>
        <clipPath id="clip0_1_215">
          <rect width="40" height="77" fill="white" transform="translate(818 205)" />
        </clipPath>
      </defs>
    </svg>
  );
}