/**
 * This file was auto-generated by openapi-typescript.
 * Do not make direct changes to the file.
 */

export interface paths {
    "/ping": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Ping */
        get: operations["ping_ping_get"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/project": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Create Project */
        post: operations["create_project_api_project_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/project/{project_id}": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        /** Update Project */
        patch: operations["update_project_api_project__project_id__patch"];
        trace?: never;
    };
    "/api/projects": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Get Projects */
        get: operations["get_projects_api_projects_get"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/projects/{project_id}": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Get Project */
        get: operations["get_project_api_projects__project_id__get"];
        put?: never;
        post?: never;
        /** Delete Project */
        delete: operations["delete_project_api_projects__project_id__delete"];
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/import_project": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Import Project */
        post: operations["import_project_api_import_project_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/projects/{project_id}/task": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Create Task */
        post: operations["create_task_api_projects__project_id__task_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/projects/{project_id}/task/{task_id}": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        /** Update Task */
        patch: operations["update_task_api_projects__project_id__task__task_id__patch"];
        trace?: never;
    };
    "/api/projects/{project_id}/tasks": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Get Tasks */
        get: operations["get_tasks_api_projects__project_id__tasks_get"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/projects/{project_id}/tasks/{task_id}": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Get Task */
        get: operations["get_task_api_projects__project_id__tasks__task_id__get"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/projects/{project_id}/task/{task_id}/prompt": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Create Prompt */
        post: operations["create_prompt_api_projects__project_id__task__task_id__prompt_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/projects/{project_id}/task/{task_id}/prompts": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Get Prompts */
        get: operations["get_prompts_api_projects__project_id__task__task_id__prompts_get"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/projects/{project_id}/tasks/{task_id}/runs/{run_id}": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Get Run */
        get: operations["get_run_api_projects__project_id__tasks__task_id__runs__run_id__get"];
        put?: never;
        post?: never;
        /** Delete Run */
        delete: operations["delete_run_api_projects__project_id__tasks__task_id__runs__run_id__delete"];
        options?: never;
        head?: never;
        /** Update Run */
        patch: operations["update_run_api_projects__project_id__tasks__task_id__runs__run_id__patch"];
        trace?: never;
    };
    "/api/projects/{project_id}/tasks/{task_id}/runs": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Get Runs */
        get: operations["get_runs_api_projects__project_id__tasks__task_id__runs_get"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/projects/{project_id}/tasks/{task_id}/runs_summaries": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Get Runs Summary */
        get: operations["get_runs_summary_api_projects__project_id__tasks__task_id__runs_summaries_get"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/projects/{project_id}/tasks/{task_id}/runs/delete": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Delete Runs */
        post: operations["delete_runs_api_projects__project_id__tasks__task_id__runs_delete_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/projects/{project_id}/tasks/{task_id}/run": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Run Task */
        post: operations["run_task_api_projects__project_id__tasks__task_id__run_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/projects/{project_id}/tasks/{task_id}/runs/edit_tags": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Edit Tags */
        post: operations["edit_tags_api_projects__project_id__tasks__task_id__runs_edit_tags_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/providers/models": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Get Providers Models */
        get: operations["get_providers_models_api_providers_models_get"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/available_models": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Get Available Models */
        get: operations["get_available_models_api_available_models_get"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/provider/ollama/connect": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Connect Ollama Api */
        get: operations["connect_ollama_api_api_provider_ollama_connect_get"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/provider/openai_compatible": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Save Openai Compatible Providers */
        post: operations["save_openai_compatible_providers_api_provider_openai_compatible_post"];
        /** Delete Openai Compatible Providers */
        delete: operations["delete_openai_compatible_providers_api_provider_openai_compatible_delete"];
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/provider/connect_api_key": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Connect Api Key */
        post: operations["connect_api_key_api_provider_connect_api_key_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/projects/{project_id}/task/{task_id}/gen_prompt/{prompt_generator}": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Generate Prompt */
        get: operations["generate_prompt_api_projects__project_id__task__task_id__gen_prompt__prompt_generator__get"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/projects/{project_id}/tasks/{task_id}/runs/{run_id}/run_repair": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Run Repair */
        post: operations["run_repair_api_projects__project_id__tasks__task_id__runs__run_id__run_repair_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/projects/{project_id}/tasks/{task_id}/runs/{run_id}/repair": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Post Repair Run */
        post: operations["post_repair_run_api_projects__project_id__tasks__task_id__runs__run_id__repair_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/settings": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Read Settings */
        get: operations["read_settings_api_settings_get"];
        put?: never;
        /** Update Settings */
        post: operations["update_settings_api_settings_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/settings/{item_id}": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Read Setting Item */
        get: operations["read_setting_item_api_settings__item_id__get"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/projects/{project_id}/tasks/{task_id}/generate_categories": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Generate Categories */
        post: operations["generate_categories_api_projects__project_id__tasks__task_id__generate_categories_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/projects/{project_id}/tasks/{task_id}/generate_samples": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Generate Samples */
        post: operations["generate_samples_api_projects__project_id__tasks__task_id__generate_samples_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/projects/{project_id}/tasks/{task_id}/save_sample": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Save Sample */
        post: operations["save_sample_api_projects__project_id__tasks__task_id__save_sample_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/projects/{project_id}/tasks/{task_id}/dataset_splits": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Dataset Splits */
        get: operations["dataset_splits_api_projects__project_id__tasks__task_id__dataset_splits_get"];
        put?: never;
        /** Create Dataset Split */
        post: operations["create_dataset_split_api_projects__project_id__tasks__task_id__dataset_splits_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/projects/{project_id}/tasks/{task_id}/finetunes": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Finetunes */
        get: operations["finetunes_api_projects__project_id__tasks__task_id__finetunes_get"];
        put?: never;
        /** Create Finetune */
        post: operations["create_finetune_api_projects__project_id__tasks__task_id__finetunes_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/projects/{project_id}/tasks/{task_id}/finetunes/{finetune_id}": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Finetune */
        get: operations["finetune_api_projects__project_id__tasks__task_id__finetunes__finetune_id__get"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/finetune_providers": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Finetune Providers */
        get: operations["finetune_providers_api_finetune_providers_get"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/finetune/hyperparameters/{provider_id}": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Finetune Hyperparameters */
        get: operations["finetune_hyperparameters_api_finetune_hyperparameters__provider_id__get"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/download_dataset_jsonl": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Download Dataset Jsonl */
        get: operations["download_dataset_jsonl_api_download_dataset_jsonl_get"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
}
export type webhooks = Record<string, never>;
export interface components {
    schemas: {
        /** AvailableModels */
        AvailableModels: {
            /** Provider Name */
            provider_name: string;
            /** Provider Id */
            provider_id: string;
            /** Models */
            models: components["schemas"]["ModelDetails"][];
        };
        /** Body_edit_tags_api_projects__project_id__tasks__task_id__runs_edit_tags_post */
        Body_edit_tags_api_projects__project_id__tasks__task_id__runs_edit_tags_post: {
            /** Run Ids */
            run_ids: string[];
            /** Add Tags */
            add_tags?: string[] | null;
            /** Remove Tags */
            remove_tags?: string[] | null;
        };
        /**
         * CreateDatasetSplitRequest
         * @description Request to create a dataset split
         */
        CreateDatasetSplitRequest: {
            dataset_split_type: components["schemas"]["DatasetSplitType"];
            filter_type: components["schemas"]["DatasetFilterType"];
            /** Name */
            name?: string | null;
            /** Description */
            description?: string | null;
        };
        /**
         * CreateFinetuneRequest
         * @description Request to create a finetune
         */
        CreateFinetuneRequest: {
            /** Name */
            name?: string | null;
            /** Description */
            description?: string | null;
            /** Dataset Id */
            dataset_id: string;
            /** Train Split Name */
            train_split_name: string;
            /** Validation Split Name */
            validation_split_name?: string | null;
            /** Parameters */
            parameters: {
                [key: string]: string | number | boolean;
            };
            /** Provider */
            provider: string;
            /** Base Model Id */
            base_model_id: string;
            /** System Message Generator */
            system_message_generator?: string | null;
            /** Custom System Message */
            custom_system_message?: string | null;
            /** Custom Thinking Instructions */
            custom_thinking_instructions?: string | null;
            data_strategy: components["schemas"]["FinetuneDataStrategy"];
        };
        /** DataGenCategoriesApiInput */
        DataGenCategoriesApiInput: {
            /**
             * Node Path
             * @description Path to the node in the category tree
             * @default []
             */
            node_path: string[];
            /**
             * Num Subtopics
             * @description Number of subtopics to generate
             * @default 6
             */
            num_subtopics: number;
            /**
             * Human Guidance
             * @description Optional human guidance for generation
             */
            human_guidance?: string | null;
            /**
             * Existing Topics
             * @description Optional list of existing topics to avoid
             */
            existing_topics?: string[] | null;
            /**
             * Model Name
             * @description The name of the model to use
             */
            model_name: string;
            /**
             * Provider
             * @description The provider of the model to use
             */
            provider: string;
        };
        /** DataGenSampleApiInput */
        DataGenSampleApiInput: {
            /**
             * Topic
             * @description Topic path for sample generation
             * @default []
             */
            topic: string[];
            /**
             * Num Samples
             * @description Number of samples to generate
             * @default 8
             */
            num_samples: number;
            /**
             * Human Guidance
             * @description Optional human guidance for generation
             */
            human_guidance?: string | null;
            /**
             * Model Name
             * @description The name of the model to use
             */
            model_name: string;
            /**
             * Provider
             * @description The provider of the model to use
             */
            provider: string;
        };
        /** DataGenSaveSamplesApiInput */
        DataGenSaveSamplesApiInput: {
            /**
             * Input
             * @description Input for this sample
             */
            input: string | Record<string, never>;
            /**
             * Topic Path
             * @description The path to the topic for this sample. Empty is the root topic.
             */
            topic_path: string[];
            /**
             * Input Model Name
             * @description The name of the model used to generate the input
             */
            input_model_name: string;
            /**
             * Input Provider
             * @description The provider of the model used to generate the input
             */
            input_provider: string;
            /**
             * Output Model Name
             * @description The name of the model to use
             */
            output_model_name: string;
            /**
             * Output Provider
             * @description The provider of the model to use
             */
            output_provider: string;
            /**
             * Prompt Method
             * @description The prompt method used to generate the output
             */
            prompt_method: string;
        };
        /**
         * DataSource
         * @description Represents the origin of data, either human or synthetic, with associated properties.
         *
         *     Properties vary based on the source type - for synthetic sources this includes
         *     model information, for human sources this includes creator information.
         */
        DataSource: {
            type: components["schemas"]["DataSourceType"];
            /**
             * Properties
             * @description Properties describing the data source. For synthetic things like model. For human, the human's name.
             * @default {}
             */
            properties: {
                [key: string]: string | number;
            };
        };
        /**
         * DataSourceType
         * @description The source type of a piece of data.
         *
         *     Human: a human created the data
         *     Synthetic: a model created the data
         * @enum {string}
         */
        DataSourceType: "human" | "synthetic";
        /**
         * DatasetFilterType
         * @description Dataset filter names.
         * @enum {string}
         */
        DatasetFilterType: "all" | "high_rating" | "thinking_model" | "thinking_model_high_rated";
        /**
         * DatasetSplit
         * @description A collection of task runs, with optional splits (train, test, validation).
         *
         *     Used to freeze a dataset into train/test/validation splits for repeatable fine-tuning or other tasks.
         *
         *     Maintains a list of IDs for each split, to avoid data duplication.
         */
        DatasetSplit: {
            /**
             * V
             * @default 1
             */
            v: number;
            /** Id */
            id?: string | null;
            /** Path */
            path?: string | null;
            /**
             * Created At
             * Format: date-time
             */
            created_at?: string;
            /** Created By */
            created_by?: string;
            /**
             * Name
             * @description A name for this entity.
             */
            name: string;
            /**
             * Description
             * @description A description of the dataset for you and your team. Not used in training.
             */
            description?: string | null;
            /**
             * Splits
             * @description The splits in the dataset.
             */
            splits?: components["schemas"]["DatasetSplitDefinition"][];
            /**
             * Split Contents
             * @description The contents of each split in the dataset. The key is the split name, and the value is a list of task run IDs.
             */
            split_contents: {
                [key: string]: string[];
            };
            /** @description The filter used to build the dataset. */
            filter?: components["schemas"]["DatasetFilterType"] | null;
            /** Model Type */
            readonly model_type: string;
        };
        /**
         * DatasetSplitDefinition
         * @description A definition of a split in a dataset.
         *
         *     Example: name="train", description="The training set", percentage=0.8 (80% of the dataset)
         */
        DatasetSplitDefinition: {
            /**
             * Name
             * @description A name for this entity.
             */
            name: string;
            /**
             * Description
             * @description A description of the dataset for you and your team. Not used in training.
             */
            description?: string | null;
            /**
             * Percentage
             * @description The percentage of the dataset that this split represents (between 0 and 1).
             */
            percentage: number;
        };
        /**
         * DatasetSplitType
         * @description Dataset split types used in the API. Any split type can be created in code.
         * @enum {string}
         */
        DatasetSplitType: "train_test" | "train_test_val" | "train_test_val_80" | "all";
        /**
         * FineTuneParameter
         * @description A parameter for a fine-tune. Hyperparameters, etc.
         */
        FineTuneParameter: {
            /** Name */
            name: string;
            /**
             * Type
             * @enum {string}
             */
            type: "string" | "int" | "float" | "bool";
            /** Description */
            description: string;
            /**
             * Optional
             * @default true
             */
            optional: boolean;
        };
        /**
         * FineTuneStatus
         * @description The status of a fine-tune, including a user friendly message.
         */
        FineTuneStatus: {
            status: components["schemas"]["FineTuneStatusType"];
            /** Message */
            message?: string | null;
        };
        /**
         * FineTuneStatusType
         * @description The status type of a fine-tune (running, completed, failed, etc).
         * @enum {string}
         */
        FineTuneStatusType: "unknown" | "pending" | "running" | "completed" | "failed";
        /**
         * Finetune
         * @description The Kiln fine-tune datamodel.
         *
         *     Initially holds a reference to a training job, with needed identifiers to update the status. When complete, contains the new model ID.
         */
        Finetune: {
            /**
             * V
             * @default 1
             */
            v: number;
            /** Id */
            id?: string | null;
            /** Path */
            path?: string | null;
            /**
             * Created At
             * Format: date-time
             */
            created_at?: string;
            /** Created By */
            created_by?: string;
            /**
             * Name
             * @description A name for this entity.
             */
            name: string;
            /**
             * Description
             * @description A description of the fine-tune for you and your team. Not used in training.
             */
            description?: string | null;
            /** @description The mode to use to train the model for structured output, if it was trained with structured output. Will determine how we call the tuned model, so we call with the matching mode. */
            structured_output_mode?: components["schemas"]["StructuredOutputMode"] | null;
            /**
             * Provider
             * @description The provider to use for the fine-tune (e.g. 'openai').
             */
            provider: string;
            /**
             * Base Model Id
             * @description The id of the base model to use for the fine-tune. This string relates to the provider's IDs for their own models, not Kiln IDs.
             */
            base_model_id: string;
            /**
             * Provider Id
             * @description The ID of the fine-tune job on the provider's side. May not be the same as the fine_tune_model_id.
             */
            provider_id?: string | null;
            /**
             * Fine Tune Model Id
             * @description The ID of the fine-tuned model on the provider's side. May not be the same as the provider_id.
             */
            fine_tune_model_id?: string | null;
            /**
             * Dataset Split Id
             * @description The ID of the dataset split to use for this fine-tune.
             */
            dataset_split_id: string;
            /**
             * Train Split Name
             * @description The name of the training split to use for this fine-tune.
             * @default train
             */
            train_split_name: string;
            /**
             * Validation Split Name
             * @description The name of the validation split to use for this fine-tune. Optional.
             */
            validation_split_name?: string | null;
            /**
             * Parameters
             * @description The parameters to use for this fine-tune. These are provider-specific.
             * @default {}
             */
            parameters: {
                [key: string]: string | number | boolean;
            };
            /**
             * System Message
             * @description The system message to use for this fine-tune.
             */
            system_message: string;
            /**
             * Thinking Instructions
             * @description The thinking instructions to use for this fine-tune. Only used when data_strategy is final_and_intermediate.
             */
            thinking_instructions?: string | null;
            /**
             * @description The latest known status of this fine-tune. Not updated in real time.
             * @default unknown
             */
            latest_status: components["schemas"]["FineTuneStatusType"];
            /**
             * Properties
             * @description Properties of the fine-tune. Different providers may use different properties.
             * @default {}
             */
            properties: {
                [key: string]: string | number;
            };
            /**
             * @description The strategy to use for training the model. 'final_only' will only train on the final response. 'final_and_intermediate' will train on the final response and intermediate outputs (chain of thought or reasoning).
             * @default final_only
             */
            data_strategy: components["schemas"]["FinetuneDataStrategy"];
            /** Model Type */
            readonly model_type: string;
        };
        /**
         * FinetuneDataStrategy
         * @enum {string}
         */
        FinetuneDataStrategy: "final_only" | "final_and_intermediate";
        /**
         * FinetuneProvider
         * @description Finetune provider: list of models a provider supports for fine-tuning
         */
        FinetuneProvider: {
            /** Name */
            name: string;
            /** Id */
            id: string;
            /** Enabled */
            enabled: boolean;
            /** Models */
            models: components["schemas"]["FinetuneProviderModel"][];
        };
        /**
         * FinetuneProviderModel
         * @description Finetune provider model: a model a provider supports for fine-tuning
         */
        FinetuneProviderModel: {
            /** Name */
            name: string;
            /** Id */
            id: string;
        };
        /**
         * FinetuneWithStatus
         * @description Finetune with status
         */
        FinetuneWithStatus: {
            finetune: components["schemas"]["Finetune"];
            status: components["schemas"]["FineTuneStatus"];
        };
        /** HTTPValidationError */
        HTTPValidationError: {
            /** Detail */
            detail?: components["schemas"]["ValidationError"][];
        };
        /**
         * KilnBaseModel
         * @description Base model for all Kiln data models with common functionality for persistence and versioning.
         *
         *     Attributes:
         *         v (int): Schema version number for migration support
         *         id (str): Unique identifier for the model instance
         *         path (Path): File system path where the model is stored
         *         created_at (datetime): Timestamp when the model was created
         *         created_by (str): User ID of the creator
         */
        KilnBaseModel: {
            /**
             * V
             * @default 1
             */
            v: number;
            /** Id */
            id?: string | null;
            /** Path */
            path?: string | null;
            /**
             * Created At
             * Format: date-time
             */
            created_at?: string;
            /** Created By */
            created_by?: string;
        };
        /** ModelDetails */
        ModelDetails: {
            /** Id */
            id: string;
            /** Name */
            name: string;
            /** Supports Structured Output */
            supports_structured_output: boolean;
            /** Supports Data Gen */
            supports_data_gen: boolean;
            /**
             * Untested Model
             * @default false
             */
            untested_model: boolean;
            /** Task Filter */
            task_filter?: string[] | null;
        };
        /**
         * ModelName
         * @description Enumeration of specific model versions supported by the system.
         *     Where models have instruct and raw versions, instruct is default and raw is specified.
         * @enum {string}
         */
        ModelName: "llama_3_1_8b" | "llama_3_1_70b" | "llama_3_1_405b" | "llama_3_2_1b" | "llama_3_2_3b" | "llama_3_2_11b" | "llama_3_2_90b" | "llama_3_3_70b" | "gpt_4o_mini" | "gpt_4o" | "phi_3_5" | "phi_4" | "mistral_large" | "mistral_nemo" | "gemma_2_2b" | "gemma_2_9b" | "gemma_2_27b" | "claude_3_5_haiku" | "claude_3_5_sonnet" | "gemini_1_5_flash" | "gemini_1_5_flash_8b" | "gemini_1_5_pro" | "nemotron_70b" | "mixtral_8x7b" | "qwen_2p5_7b" | "qwen_2p5_72b" | "deepseek_3" | "deepseek_r1";
        /** OllamaConnection */
        OllamaConnection: {
            /** Message */
            message: string;
            /** Supported Models */
            supported_models: string[];
            /** Untested Models */
            untested_models?: string[];
        };
        /**
         * Priority
         * @description Defines priority levels for tasks and requirements, where P0 is highest priority.
         * @enum {integer}
         */
        Priority: 0 | 1 | 2 | 3;
        /**
         * Project
         * @description A collection of related tasks.
         *
         *     Projects organize tasks into logical groups and provide high-level descriptions
         *     of the overall goals.
         */
        "Project-Input": {
            /**
             * V
             * @default 1
             */
            v: number;
            /** Id */
            id?: string | null;
            /** Path */
            path?: string | null;
            /**
             * Created At
             * Format: date-time
             */
            created_at?: string;
            /** Created By */
            created_by?: string;
            /**
             * Name
             * @description A name for this entity.
             */
            name: string;
            /**
             * Description
             * @description A description of the project for you and your team. Will not be used in prompts/training/validation.
             */
            description?: string | null;
        };
        /**
         * Project
         * @description A collection of related tasks.
         *
         *     Projects organize tasks into logical groups and provide high-level descriptions
         *     of the overall goals.
         */
        "Project-Output": {
            /**
             * V
             * @default 1
             */
            v: number;
            /** Id */
            id?: string | null;
            /** Path */
            path?: string | null;
            /**
             * Created At
             * Format: date-time
             */
            created_at?: string;
            /** Created By */
            created_by?: string;
            /**
             * Name
             * @description A name for this entity.
             */
            name: string;
            /**
             * Description
             * @description A description of the project for you and your team. Will not be used in prompts/training/validation.
             */
            description?: string | null;
            /** Model Type */
            readonly model_type: string;
        };
        /**
         * Prompt
         * @description A prompt for a task.
         */
        Prompt: {
            /**
             * V
             * @default 1
             */
            v: number;
            /** Id */
            id?: string | null;
            /** Path */
            path?: string | null;
            /**
             * Created At
             * Format: date-time
             */
            created_at?: string;
            /** Created By */
            created_by?: string;
            /**
             * Name
             * @description A name for this entity.
             */
            name: string;
            /**
             * Prompt
             * @description The prompt for the task.
             */
            prompt: string;
            /**
             * Chain Of Thought Instructions
             * @description Instructions for the model 'thinking' about the requirement prior to answering. Used for chain of thought style prompting. COT will not be used unless this is provided.
             */
            chain_of_thought_instructions?: string | null;
            /** Model Type */
            readonly model_type: string;
        };
        /** PromptApiResponse */
        PromptApiResponse: {
            /** Prompt */
            prompt: string;
            /** Prompt Builder Name */
            prompt_builder_name: string;
            /** Ui Generator Name */
            ui_generator_name: string;
        };
        /** PromptCreateRequest */
        PromptCreateRequest: {
            /** Name */
            name: string;
            /** Prompt */
            prompt: string;
            /** Chain Of Thought Instructions */
            chain_of_thought_instructions?: string | null;
        };
        /** PromptGenerator */
        PromptGenerator: {
            /** Id */
            id: string;
            /** Ui Id */
            ui_id: string;
            /** Short Description */
            short_description: string;
            /** Description */
            description: string;
            /** Name */
            name: string;
            /** Chain Of Thought */
            chain_of_thought: boolean;
        };
        /** PromptResponse */
        PromptResponse: {
            /** Generators */
            generators: components["schemas"]["PromptGenerator"][];
            /** Prompts */
            prompts: components["schemas"]["Prompt"][];
        };
        /** ProviderModel */
        ProviderModel: {
            /** Id */
            id: string;
            /** Name */
            name: string;
        };
        /** ProviderModels */
        ProviderModels: {
            /** Models */
            models: {
                [key: string]: components["schemas"]["ProviderModel"];
            };
        };
        /** RepairRunPost */
        RepairRunPost: {
            repair_run: components["schemas"]["TaskRun-Input"];
            /** Evaluator Feedback */
            evaluator_feedback: string;
        };
        /** RepairTaskApiInput */
        RepairTaskApiInput: {
            /**
             * Evaluator Feedback
             * @description Feedback from an evaluator on how to repair the task run.
             */
            evaluator_feedback: string;
            /**
             * Model Name
             * @description The name of the model to use for the repair task. Optional, if not specified, the model of the original task will be used.
             */
            model_name?: string | null;
            /**
             * Provider
             * @description The provider of the model to use for the repair task. Optional, if not specified, the provider of the original task will be used.
             */
            provider?: string | null;
        };
        /**
         * RequirementRating
         * @description Rating for a specific requirement within a task output.
         */
        RequirementRating: {
            /**
             * Value
             * @description The rating value. Interpretation depends on rating type
             */
            value: number;
            /** @description The type of rating */
            type: components["schemas"]["TaskOutputRatingType"];
        };
        /** RunSummary */
        RunSummary: {
            /** Id */
            id: string | null;
            rating?: components["schemas"]["TaskOutputRating-Output"] | null;
            /**
             * Created At
             * Format: date-time
             */
            created_at: string;
            /** Input Preview */
            input_preview?: string | null;
            /** Output Preview */
            output_preview?: string | null;
            /** Repair State */
            repair_state?: string | null;
            /** Model Name */
            model_name?: string | null;
            /** Input Source */
            input_source?: string | null;
            /** Tags */
            tags?: string[] | null;
        };
        /** RunTaskRequest */
        RunTaskRequest: {
            /** Model Name */
            model_name: string;
            /** Provider */
            provider: string;
            /** Plaintext Input */
            plaintext_input?: string | null;
            /** Structured Input */
            structured_input?: Record<string, never> | null;
            /** Ui Prompt Method */
            ui_prompt_method?: string | null;
            /** Tags */
            tags?: string[] | null;
        };
        /**
         * StructuredOutputMode
         * @description Enumeration of supported structured output modes.
         *
         *     - default: let the adapter decide
         *     - json_schema: request json using API capabilities for json_schema
         *     - function_calling: request json using API capabilities for function calling
         *     - json_mode: request json using API's JSON mode, which should return valid JSON, but isn't checking/passing the schema
         *     - json_instructions: append instructions to the prompt to request json matching the schema. No API capabilities are used. You should have a custom parser on these models as they will be returning strings.
         *     - json_instruction_and_object: append instructions to the prompt to request json matching the schema. Also request the response as json_mode via API capabilities (returning dictionaries).
         * @enum {string}
         */
        StructuredOutputMode: "default" | "json_schema" | "function_calling" | "json_mode" | "json_instructions" | "json_instruction_and_object";
        /**
         * Task
         * @description Represents a specific task to be performed, with associated requirements and validation rules.
         *
         *     Contains the task definition, requirements, input/output schemas, and maintains
         *     a collection of task runs.
         */
        Task: {
            /**
             * V
             * @default 1
             */
            v: number;
            /** Id */
            id?: string | null;
            /** Path */
            path?: string | null;
            /**
             * Created At
             * Format: date-time
             */
            created_at?: string;
            /** Created By */
            created_by?: string;
            /**
             * Name
             * @description A name for this entity.
             */
            name: string;
            /**
             * Description
             * @description A description of the task for you and your team. Will not be used in prompts/training/validation.
             */
            description?: string | null;
            /**
             * Instruction
             * @description The instructions for the task. Will be used in prompts/training/validation.
             */
            instruction: string;
            /**
             * Requirements
             * @default []
             */
            requirements: components["schemas"]["TaskRequirement"][];
            /** Output Json Schema */
            output_json_schema?: string | null;
            /** Input Json Schema */
            input_json_schema?: string | null;
            /**
             * Thinking Instruction
             * @description Instructions for the model 'thinking' about the requirement prior to answering. Used for chain of thought style prompting.
             */
            thinking_instruction?: string | null;
            /** Model Type */
            readonly model_type: string;
        };
        /**
         * TaskOutput
         * @description An output for a specific task run.
         *
         *     Contains the actual output content, its source (human or synthetic),
         *     and optional rating information.
         */
        "TaskOutput-Input": {
            /**
             * V
             * @default 1
             */
            v: number;
            /** Id */
            id?: string | null;
            /** Path */
            path?: string | null;
            /**
             * Created At
             * Format: date-time
             */
            created_at?: string;
            /** Created By */
            created_by?: string;
            /**
             * Output
             * @description The output of the task. JSON formatted for structured output, plaintext for unstructured output.
             */
            output: string;
            /** @description The source of the output: human or synthetic. */
            source?: components["schemas"]["DataSource"] | null;
            /** @description The rating of the output */
            rating?: components["schemas"]["TaskOutputRating-Input"] | null;
        };
        /**
         * TaskOutput
         * @description An output for a specific task run.
         *
         *     Contains the actual output content, its source (human or synthetic),
         *     and optional rating information.
         */
        "TaskOutput-Output": {
            /**
             * V
             * @default 1
             */
            v: number;
            /** Id */
            id?: string | null;
            /** Path */
            path?: string | null;
            /**
             * Created At
             * Format: date-time
             */
            created_at?: string;
            /** Created By */
            created_by?: string;
            /**
             * Output
             * @description The output of the task. JSON formatted for structured output, plaintext for unstructured output.
             */
            output: string;
            /** @description The source of the output: human or synthetic. */
            source?: components["schemas"]["DataSource"] | null;
            /** @description The rating of the output */
            rating?: components["schemas"]["TaskOutputRating-Output"] | null;
            /** Model Type */
            readonly model_type: string;
        };
        /**
         * TaskOutputRating
         * @description A rating for a task output, including an overall rating and ratings for each requirement.
         *
         *     Supports:
         *     - five_star: 1-5 star ratings
         *     - pass_fail: boolean pass/fail (1.0 = pass, 0.0 = fail)
         *     - pass_fail_critical: tri-state (1.0 = pass, 0.0 = fail, -1.0 = critical fail)
         */
        "TaskOutputRating-Input": {
            /**
             * V
             * @default 1
             */
            v: number;
            /** Id */
            id?: string | null;
            /** Path */
            path?: string | null;
            /**
             * Created At
             * Format: date-time
             */
            created_at?: string;
            /** Created By */
            created_by?: string;
            /** @default five_star */
            type: components["schemas"]["TaskOutputRatingType"];
            /**
             * Value
             * @description The rating value. Interpretation depends on rating type:
             *     - five_star: 1-5 stars
             *     - pass_fail: 1.0 (pass) or 0.0 (fail)
             *     - pass_fail_critical: 1.0 (pass), 0.0 (fail), or -1.0 (critical fail)
             */
            value?: number | null;
            /**
             * Requirement Ratings
             * @description The ratings of the requirements of the task.
             * @default {}
             */
            requirement_ratings: {
                [key: string]: components["schemas"]["RequirementRating"];
            };
        };
        /**
         * TaskOutputRating
         * @description A rating for a task output, including an overall rating and ratings for each requirement.
         *
         *     Supports:
         *     - five_star: 1-5 star ratings
         *     - pass_fail: boolean pass/fail (1.0 = pass, 0.0 = fail)
         *     - pass_fail_critical: tri-state (1.0 = pass, 0.0 = fail, -1.0 = critical fail)
         */
        "TaskOutputRating-Output": {
            /**
             * V
             * @default 1
             */
            v: number;
            /** Id */
            id?: string | null;
            /** Path */
            path?: string | null;
            /**
             * Created At
             * Format: date-time
             */
            created_at?: string;
            /** Created By */
            created_by?: string;
            /** @default five_star */
            type: components["schemas"]["TaskOutputRatingType"];
            /**
             * Value
             * @description The rating value. Interpretation depends on rating type:
             *     - five_star: 1-5 stars
             *     - pass_fail: 1.0 (pass) or 0.0 (fail)
             *     - pass_fail_critical: 1.0 (pass), 0.0 (fail), or -1.0 (critical fail)
             */
            value?: number | null;
            /**
             * Requirement Ratings
             * @description The ratings of the requirements of the task.
             * @default {}
             */
            requirement_ratings: {
                [key: string]: components["schemas"]["RequirementRating"];
            };
            /** Model Type */
            readonly model_type: string;
        };
        /**
         * TaskOutputRatingType
         * @description Defines the types of rating systems available for task outputs.
         * @enum {string}
         */
        TaskOutputRatingType: "five_star" | "pass_fail" | "pass_fail_critical" | "custom";
        /**
         * TaskRequirement
         * @description Defines a specific requirement that should be met by task outputs.
         *
         *     Includes an identifier, name, description, instruction for meeting the requirement,
         *     priority level, and rating type (five_star, pass_fail, pass_fail_critical, custom).
         */
        TaskRequirement: {
            /** Id */
            id?: string | null;
            /**
             * Name
             * @description A name for this entity
             */
            name: string;
            /** Description */
            description?: string | null;
            /** Instruction */
            instruction: string;
            /** @default 2 */
            priority: components["schemas"]["Priority"];
            /** @default five_star */
            type: components["schemas"]["TaskOutputRatingType"];
        };
        /**
         * TaskRun
         * @description Represents a single execution of a Task.
         *
         *     Contains the input used, its source, the output produced, and optional
         *     repair information if the output needed correction.
         */
        "TaskRun-Input": {
            /**
             * V
             * @default 1
             */
            v: number;
            /** Id */
            id?: string | null;
            /** Path */
            path?: string | null;
            /**
             * Created At
             * Format: date-time
             */
            created_at?: string;
            /** Created By */
            created_by?: string;
            parent?: components["schemas"]["KilnBaseModel"] | null;
            /**
             * Input
             * @description The inputs to the task. JSON formatted for structured input, plaintext for unstructured input.
             */
            input: string;
            /** @description The source of the input: human or synthetic. */
            input_source?: components["schemas"]["DataSource"] | null;
            /** @description The output of the task run. */
            output: components["schemas"]["TaskOutput-Input"];
            /**
             * Repair Instructions
             * @description Instructions for fixing the output. Should define what is wrong, and how to fix it. Will be used by models for both generating a fixed output, and evaluating future models.
             */
            repair_instructions?: string | null;
            /** @description An version of the output with issues fixed. This must be a 'fixed' version of the existing output, and not an entirely new output. If you wish to generate an ideal curatorial output for this task unrelated to this output, generate a new TaskOutput with type 'human' instead of using this field. */
            repaired_output?: components["schemas"]["TaskOutput-Input"] | null;
            /**
             * Intermediate Outputs
             * @description Intermediate outputs from the task run. Keys are the names of the intermediate output steps (cot=chain of thought, etc), values are the output data.
             */
            intermediate_outputs?: {
                [key: string]: string;
            } | null;
            /**
             * Tags
             * @description Tags for the task run. Tags are used to categorize task runs for filtering and reporting.
             * @default []
             */
            tags: string[];
        };
        /**
         * TaskRun
         * @description Represents a single execution of a Task.
         *
         *     Contains the input used, its source, the output produced, and optional
         *     repair information if the output needed correction.
         */
        "TaskRun-Output": {
            /**
             * V
             * @default 1
             */
            v: number;
            /** Id */
            id?: string | null;
            /** Path */
            path?: string | null;
            /**
             * Created At
             * Format: date-time
             */
            created_at?: string;
            /** Created By */
            created_by?: string;
            /**
             * Input
             * @description The inputs to the task. JSON formatted for structured input, plaintext for unstructured input.
             */
            input: string;
            /** @description The source of the input: human or synthetic. */
            input_source?: components["schemas"]["DataSource"] | null;
            /** @description The output of the task run. */
            output: components["schemas"]["TaskOutput-Output"];
            /**
             * Repair Instructions
             * @description Instructions for fixing the output. Should define what is wrong, and how to fix it. Will be used by models for both generating a fixed output, and evaluating future models.
             */
            repair_instructions?: string | null;
            /** @description An version of the output with issues fixed. This must be a 'fixed' version of the existing output, and not an entirely new output. If you wish to generate an ideal curatorial output for this task unrelated to this output, generate a new TaskOutput with type 'human' instead of using this field. */
            repaired_output?: components["schemas"]["TaskOutput-Output"] | null;
            /**
             * Intermediate Outputs
             * @description Intermediate outputs from the task run. Keys are the names of the intermediate output steps (cot=chain of thought, etc), values are the output data.
             */
            intermediate_outputs?: {
                [key: string]: string;
            } | null;
            /**
             * Tags
             * @description Tags for the task run. Tags are used to categorize task runs for filtering and reporting.
             * @default []
             */
            tags: string[];
            /** Model Type */
            readonly model_type: string;
        };
        /** ValidationError */
        ValidationError: {
            /** Location */
            loc: (string | number)[];
            /** Message */
            msg: string;
            /** Error Type */
            type: string;
        };
    };
    responses: never;
    parameters: never;
    requestBodies: never;
    headers: never;
    pathItems: never;
}
export type $defs = Record<string, never>;
export interface operations {
    ping_ping_get: {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": unknown;
                };
            };
        };
    };
    create_project_api_project_post: {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["Project-Input"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["Project-Output"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    update_project_api_project__project_id__patch: {
        parameters: {
            query?: never;
            header?: never;
            path: {
                project_id: string;
            };
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": Record<string, never>;
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["Project-Output"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    get_projects_api_projects_get: {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["Project-Output"][];
                };
            };
        };
    };
    get_project_api_projects__project_id__get: {
        parameters: {
            query?: never;
            header?: never;
            path: {
                project_id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["Project-Output"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    delete_project_api_projects__project_id__delete: {
        parameters: {
            query?: never;
            header?: never;
            path: {
                project_id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": Record<string, never>;
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    import_project_api_import_project_post: {
        parameters: {
            query: {
                project_path: string;
            };
            header?: never;
            path?: never;
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["Project-Output"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    create_task_api_projects__project_id__task_post: {
        parameters: {
            query?: never;
            header?: never;
            path: {
                project_id: string;
            };
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": Record<string, never>;
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["Task"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    update_task_api_projects__project_id__task__task_id__patch: {
        parameters: {
            query?: never;
            header?: never;
            path: {
                project_id: string;
                task_id: string;
            };
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": Record<string, never>;
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["Task"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    get_tasks_api_projects__project_id__tasks_get: {
        parameters: {
            query?: never;
            header?: never;
            path: {
                project_id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["Task"][];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    get_task_api_projects__project_id__tasks__task_id__get: {
        parameters: {
            query?: never;
            header?: never;
            path: {
                project_id: string;
                task_id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["Task"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    create_prompt_api_projects__project_id__task__task_id__prompt_post: {
        parameters: {
            query?: never;
            header?: never;
            path: {
                project_id: string;
                task_id: string;
            };
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["PromptCreateRequest"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["Prompt"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    get_prompts_api_projects__project_id__task__task_id__prompts_get: {
        parameters: {
            query?: never;
            header?: never;
            path: {
                project_id: string;
                task_id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["PromptResponse"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    get_run_api_projects__project_id__tasks__task_id__runs__run_id__get: {
        parameters: {
            query?: never;
            header?: never;
            path: {
                project_id: string;
                task_id: string;
                run_id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["TaskRun-Output"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    delete_run_api_projects__project_id__tasks__task_id__runs__run_id__delete: {
        parameters: {
            query?: never;
            header?: never;
            path: {
                project_id: string;
                task_id: string;
                run_id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": unknown;
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    update_run_api_projects__project_id__tasks__task_id__runs__run_id__patch: {
        parameters: {
            query?: never;
            header?: never;
            path: {
                project_id: string;
                task_id: string;
                run_id: string;
            };
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": Record<string, never>;
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["TaskRun-Output"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    get_runs_api_projects__project_id__tasks__task_id__runs_get: {
        parameters: {
            query?: never;
            header?: never;
            path: {
                project_id: string;
                task_id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["TaskRun-Output"][];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    get_runs_summary_api_projects__project_id__tasks__task_id__runs_summaries_get: {
        parameters: {
            query?: never;
            header?: never;
            path: {
                project_id: string;
                task_id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["RunSummary"][];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    delete_runs_api_projects__project_id__tasks__task_id__runs_delete_post: {
        parameters: {
            query?: never;
            header?: never;
            path: {
                project_id: string;
                task_id: string;
            };
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": string[];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": unknown;
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    run_task_api_projects__project_id__tasks__task_id__run_post: {
        parameters: {
            query?: never;
            header?: never;
            path: {
                project_id: string;
                task_id: string;
            };
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["RunTaskRequest"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["TaskRun-Output"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    edit_tags_api_projects__project_id__tasks__task_id__runs_edit_tags_post: {
        parameters: {
            query?: never;
            header?: never;
            path: {
                project_id: string;
                task_id: string;
            };
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["Body_edit_tags_api_projects__project_id__tasks__task_id__runs_edit_tags_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": unknown;
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    get_providers_models_api_providers_models_get: {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["ProviderModels"];
                };
            };
        };
    };
    get_available_models_api_available_models_get: {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["AvailableModels"][];
                };
            };
        };
    };
    connect_ollama_api_api_provider_ollama_connect_get: {
        parameters: {
            query?: {
                custom_ollama_url?: string | null;
            };
            header?: never;
            path?: never;
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["OllamaConnection"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    save_openai_compatible_providers_api_provider_openai_compatible_post: {
        parameters: {
            query: {
                name: string;
                base_url: string;
                api_key: string;
            };
            header?: never;
            path?: never;
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": unknown;
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    delete_openai_compatible_providers_api_provider_openai_compatible_delete: {
        parameters: {
            query: {
                name: string;
            };
            header?: never;
            path?: never;
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": unknown;
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    connect_api_key_api_provider_connect_api_key_post: {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": Record<string, never>;
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": unknown;
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    generate_prompt_api_projects__project_id__task__task_id__gen_prompt__prompt_generator__get: {
        parameters: {
            query?: never;
            header?: never;
            path: {
                project_id: string;
                task_id: string;
                prompt_generator: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["PromptApiResponse"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    run_repair_api_projects__project_id__tasks__task_id__runs__run_id__run_repair_post: {
        parameters: {
            query?: never;
            header?: never;
            path: {
                project_id: string;
                task_id: string;
                run_id: string;
            };
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["RepairTaskApiInput"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["TaskRun-Output"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    post_repair_run_api_projects__project_id__tasks__task_id__runs__run_id__repair_post: {
        parameters: {
            query?: never;
            header?: never;
            path: {
                project_id: string;
                task_id: string;
                run_id: string;
            };
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["RepairRunPost"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["TaskRun-Output"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_settings_api_settings_get: {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": Record<string, never>;
                };
            };
        };
    };
    update_settings_api_settings_post: {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": {
                    [key: string]: number | string | boolean | unknown[] | null;
                };
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": unknown;
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_setting_item_api_settings__item_id__get: {
        parameters: {
            query?: never;
            header?: never;
            path: {
                item_id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": unknown;
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    generate_categories_api_projects__project_id__tasks__task_id__generate_categories_post: {
        parameters: {
            query?: never;
            header?: never;
            path: {
                project_id: string;
                task_id: string;
            };
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["DataGenCategoriesApiInput"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["TaskRun-Output"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    generate_samples_api_projects__project_id__tasks__task_id__generate_samples_post: {
        parameters: {
            query?: never;
            header?: never;
            path: {
                project_id: string;
                task_id: string;
            };
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["DataGenSampleApiInput"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["TaskRun-Output"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    save_sample_api_projects__project_id__tasks__task_id__save_sample_post: {
        parameters: {
            query?: {
                session_id?: string | null;
            };
            header?: never;
            path: {
                project_id: string;
                task_id: string;
            };
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["DataGenSaveSamplesApiInput"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["TaskRun-Output"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    dataset_splits_api_projects__project_id__tasks__task_id__dataset_splits_get: {
        parameters: {
            query?: never;
            header?: never;
            path: {
                project_id: string;
                task_id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["DatasetSplit"][];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    create_dataset_split_api_projects__project_id__tasks__task_id__dataset_splits_post: {
        parameters: {
            query?: never;
            header?: never;
            path: {
                project_id: string;
                task_id: string;
            };
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["CreateDatasetSplitRequest"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["DatasetSplit"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    finetunes_api_projects__project_id__tasks__task_id__finetunes_get: {
        parameters: {
            query?: {
                update_status?: boolean;
            };
            header?: never;
            path: {
                project_id: string;
                task_id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["Finetune"][];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    create_finetune_api_projects__project_id__tasks__task_id__finetunes_post: {
        parameters: {
            query?: never;
            header?: never;
            path: {
                project_id: string;
                task_id: string;
            };
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["CreateFinetuneRequest"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["Finetune"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    finetune_api_projects__project_id__tasks__task_id__finetunes__finetune_id__get: {
        parameters: {
            query?: never;
            header?: never;
            path: {
                project_id: string;
                task_id: string;
                finetune_id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["FinetuneWithStatus"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    finetune_providers_api_finetune_providers_get: {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["FinetuneProvider"][];
                };
            };
        };
    };
    finetune_hyperparameters_api_finetune_hyperparameters__provider_id__get: {
        parameters: {
            query?: never;
            header?: never;
            path: {
                provider_id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["FineTuneParameter"][];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    download_dataset_jsonl_api_download_dataset_jsonl_get: {
        parameters: {
            query: {
                project_id: string;
                task_id: string;
                dataset_id: string;
                split_name: string;
                format_type: string;
                data_strategy: string;
                system_message_generator?: string | null;
                custom_system_message?: string | null;
                custom_thinking_instructions?: string | null;
            };
            header?: never;
            path?: never;
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": unknown;
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
}
