#include <stdio.h>
#include <windows.h>
#include <stdint.h>

#include "defs.h"

typedef NTSTATUS( NTAPI* pNtQuerySystemInformation )( ULONG SystemInformationClass, PVOID SystemInformation, ULONG SystemInformationLength, PULONG ReturnLength );

#define SystemPolicyInformation 134

//
// constant encryption/decryption keys and context 
// SPCallServerHandleIsAppLicensed
//
static const uint8_t DECRYPT_ARGS[ 128 ] = {
    0xc9, 0x98, 0xe5, 0x1b, 0xa3, 0xa9, 0x63, 0x2e, 0x56, 0xe1, 0xe2, 0x53, 0xe0, 0x65, 0x77, 0x7c,
    0x3e, 0x26, 0x3d, 0x34, 0x5f, 0xb9, 0x87, 0xce, 0x86, 0xa9, 0xe7, 0xf2, 0x98, 0x08, 0x83, 0x14,
    0x85, 0x1e, 0x83, 0x91, 0x9d, 0xbd, 0x3c, 0xc3, 0x22, 0x0c, 0x21, 0xbe, 0x4a, 0x78, 0x05, 0xb2,
    0xce, 0x2d, 0x0e, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t DECRYPT_INDEX[ 32 ] = {
    0x1d, 0x0e, 0x0f, 0x09, 0x1b, 0x01, 0x1a, 0x18, 0x1e, 0x05, 0x0b, 0x19, 0x02, 0x1f, 0x1f, 0x1f,
    0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f
};

static const uint64_t DECRYPT_KEY = 0x584ab5b117cb1ec8;

static const uint8_t ENCRYPT_ARGS[ 128 ] = {
    0x95, 0x97, 0x99, 0xc4, 0x2f, 0x89, 0xc6, 0x57, 0x24, 0x4e, 0x89, 0x6e, 0x58, 0x98, 0x8d, 0x2f,
    0x22, 0xd9, 0xde, 0xbf, 0x11, 0x69, 0x56, 0xdc, 0x39, 0xf1, 0xe6, 0x44, 0xbb, 0x2e, 0xb3, 0x4c,
    0xa9, 0x08, 0x59, 0x23, 0x9a, 0x62, 0x56, 0x6e, 0x7b, 0xda, 0xd3, 0xf1, 0x1e, 0x22, 0x42, 0x53,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
static const uint8_t ENCRYPT_INDEX[ 32 ] = {
    0x14, 0x02, 0x0f, 0x0c, 0x16, 0x19, 0x1c, 0x09, 0x03, 0x15, 0x06, 0x1d, 0x1f, 0x1f, 0x1f, 0x1f,
    0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f
};

static const uint64_t ENCRYPT_KEY = 0x5e6069ab7f13f107;


typedef struct _SYSTEM_POLICY_INFORMATION
{
    PVOID InputData;
    PVOID OutputData;
    ULONG InputSize;
    ULONG OutputSize;
    ULONG Version;
    NTSTATUS Status;
} SYSTEM_POLICY_INFORMATION, * PSYSTEM_POLICY_INFORMATION;

int main( void )
{
    NTSTATUS status = 0;
    ULONG RetLength = 0;

    pNtQuerySystemInformation NtQuerySystemInformation = ( pNtQuerySystemInformation ) GetProcAddress( GetModuleHandleW( L"ntdll.dll" ), "NtQuerySystemInformation" );
    if ( !NtQuerySystemInformation )
        return 1;

    SYSTEM_POLICY_INFORMATION PolicyInput;

    //
    // input structure
    //
    SLS_ENCRYPTED_DATA EncryptedData;

    SLS_DECRYPTED_DATA DecryptedData;
    SLS_DECRYPTED_HEADER SPDecryptedHdr;

    SLS_ENCRYPT_DECRYPT_ARGS SPDecryptArgs;
    SLS_KEY SPDecryptKey;

    SLS_ENCRYPT_DECRYPT_ARGS SPEncryptArgs;
    SLS_KEY SPEncryptKey;

    //
    // setup initial decrypted (original) data
    //
    DecryptedData.ParameterCount = 9;  // depends on system policy type
    DecryptedData.DecryptedSize = 382; // EncryptedSize (w/out xorkey) - 14 decimal (280)

    SPDecryptedHdr.PolicyTypeSize = sizeof( ULONG );
    SPDecryptedHdr.PolicyType = IsAppLicensed;

    RtlZeroMemory( &SPDecryptArgs, sizeof( SLS_ENCRYPT_DECRYPT_ARGS ) );

    //
    // setup input data decryption keys
    //
    SPDecryptKey.Key = DECRYPT_KEY;

    //
    // setup input data decrypt arguments
    //
    memcpy( SPDecryptArgs.FnArgs, DECRYPT_ARGS, 128 );
    memcpy( SPDecryptArgs.FnIndex, DECRYPT_INDEX, 32 );

    RtlZeroMemory( &SPEncryptArgs, sizeof( SLS_ENCRYPT_DECRYPT_ARGS ) );

    const WCHAR* app = L"Microsoft.XboxIdentityProvider_12.67.21001.0_x64__8wekyb3d8bbwe";

    status = NtQuerySystemInformation( SystemPolicyInformation, &PolicyInput, sizeof( SYSTEM_POLICY_INFORMATION ), &RetLength );
    printf( "status: 0x%08x\nlength: %i\n", status, RetLength );

    return 0;
}
