// Copyright 2015-2024 The Khronos Group Inc.
//
// SPDX-License-Identifier: Apache-2.0 OR MIT
//

// This header is generated from the Khronos Vulkan XML API Registry.

#ifndef VULKAN_STRUCTS_HPP
#define VULKAN_STRUCTS_HPP

// include-what-you-use: make sure, vulkan.hpp is used by code-completers
// IWYU pragma: private; include "vulkan.hpp"

#include <cstring>  // strcmp

namespace VULKAN_HPP_NAMESPACE
{

  //===============
  //=== STRUCTS ===
  //===============

  struct AcquireNextImageInfoKHR
  {
    using NativeType = VkAcquireNextImageInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAcquireNextImageInfoKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AcquireNextImageInfoKHR( VULKAN_HPP_NAMESPACE::SwapchainKHR swapchain_  = {},
                                                  uint64_t                           timeout_    = {},
                                                  VULKAN_HPP_NAMESPACE::Semaphore    semaphore_  = {},
                                                  VULKAN_HPP_NAMESPACE::Fence        fence_      = {},
                                                  uint32_t                           deviceMask_ = {},
                                                  const void *                       pNext_      = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , swapchain{ swapchain_ }
      , timeout{ timeout_ }
      , semaphore{ semaphore_ }
      , fence{ fence_ }
      , deviceMask{ deviceMask_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AcquireNextImageInfoKHR( AcquireNextImageInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AcquireNextImageInfoKHR( VkAcquireNextImageInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AcquireNextImageInfoKHR( *reinterpret_cast<AcquireNextImageInfoKHR const *>( &rhs ) )
    {
    }

    AcquireNextImageInfoKHR & operator=( AcquireNextImageInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AcquireNextImageInfoKHR & operator=( VkAcquireNextImageInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AcquireNextImageInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AcquireNextImageInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AcquireNextImageInfoKHR & setSwapchain( VULKAN_HPP_NAMESPACE::SwapchainKHR swapchain_ ) VULKAN_HPP_NOEXCEPT
    {
      swapchain = swapchain_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AcquireNextImageInfoKHR & setTimeout( uint64_t timeout_ ) VULKAN_HPP_NOEXCEPT
    {
      timeout = timeout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AcquireNextImageInfoKHR & setSemaphore( VULKAN_HPP_NAMESPACE::Semaphore semaphore_ ) VULKAN_HPP_NOEXCEPT
    {
      semaphore = semaphore_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AcquireNextImageInfoKHR & setFence( VULKAN_HPP_NAMESPACE::Fence fence_ ) VULKAN_HPP_NOEXCEPT
    {
      fence = fence_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AcquireNextImageInfoKHR & setDeviceMask( uint32_t deviceMask_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceMask = deviceMask_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkAcquireNextImageInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAcquireNextImageInfoKHR *>( this );
    }

    operator VkAcquireNextImageInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAcquireNextImageInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::SwapchainKHR const &,
               uint64_t const &,
               VULKAN_HPP_NAMESPACE::Semaphore const &,
               VULKAN_HPP_NAMESPACE::Fence const &,
               uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, swapchain, timeout, semaphore, fence, deviceMask );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AcquireNextImageInfoKHR const & ) const = default;
#else
    bool operator==( AcquireNextImageInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( swapchain == rhs.swapchain ) && ( timeout == rhs.timeout ) &&
             ( semaphore == rhs.semaphore ) && ( fence == rhs.fence ) && ( deviceMask == rhs.deviceMask );
#  endif
    }

    bool operator!=( AcquireNextImageInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType      = StructureType::eAcquireNextImageInfoKHR;
    const void *                        pNext      = {};
    VULKAN_HPP_NAMESPACE::SwapchainKHR  swapchain  = {};
    uint64_t                            timeout    = {};
    VULKAN_HPP_NAMESPACE::Semaphore     semaphore  = {};
    VULKAN_HPP_NAMESPACE::Fence         fence      = {};
    uint32_t                            deviceMask = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAcquireNextImageInfoKHR>
  {
    using Type = AcquireNextImageInfoKHR;
  };

  struct AcquireProfilingLockInfoKHR
  {
    using NativeType = VkAcquireProfilingLockInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAcquireProfilingLockInfoKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AcquireProfilingLockInfoKHR( VULKAN_HPP_NAMESPACE::AcquireProfilingLockFlagsKHR flags_   = {},
                                                      uint64_t                                           timeout_ = {},
                                                      const void *                                       pNext_   = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , timeout{ timeout_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AcquireProfilingLockInfoKHR( AcquireProfilingLockInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AcquireProfilingLockInfoKHR( VkAcquireProfilingLockInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AcquireProfilingLockInfoKHR( *reinterpret_cast<AcquireProfilingLockInfoKHR const *>( &rhs ) )
    {
    }

    AcquireProfilingLockInfoKHR & operator=( AcquireProfilingLockInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AcquireProfilingLockInfoKHR & operator=( VkAcquireProfilingLockInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AcquireProfilingLockInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AcquireProfilingLockInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AcquireProfilingLockInfoKHR & setFlags( VULKAN_HPP_NAMESPACE::AcquireProfilingLockFlagsKHR flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AcquireProfilingLockInfoKHR & setTimeout( uint64_t timeout_ ) VULKAN_HPP_NOEXCEPT
    {
      timeout = timeout_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkAcquireProfilingLockInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAcquireProfilingLockInfoKHR *>( this );
    }

    operator VkAcquireProfilingLockInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAcquireProfilingLockInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::AcquireProfilingLockFlagsKHR const &, uint64_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, timeout );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AcquireProfilingLockInfoKHR const & ) const = default;
#else
    bool operator==( AcquireProfilingLockInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( timeout == rhs.timeout );
#  endif
    }

    bool operator!=( AcquireProfilingLockInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                sType   = StructureType::eAcquireProfilingLockInfoKHR;
    const void *                                       pNext   = {};
    VULKAN_HPP_NAMESPACE::AcquireProfilingLockFlagsKHR flags   = {};
    uint64_t                                           timeout = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAcquireProfilingLockInfoKHR>
  {
    using Type = AcquireProfilingLockInfoKHR;
  };

  struct AllocationCallbacks
  {
    using NativeType = VkAllocationCallbacks;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AllocationCallbacks( void *                               pUserData_             = {},
                                              PFN_vkAllocationFunction             pfnAllocation_         = {},
                                              PFN_vkReallocationFunction           pfnReallocation_       = {},
                                              PFN_vkFreeFunction                   pfnFree_               = {},
                                              PFN_vkInternalAllocationNotification pfnInternalAllocation_ = {},
                                              PFN_vkInternalFreeNotification       pfnInternalFree_       = {} ) VULKAN_HPP_NOEXCEPT
      : pUserData{ pUserData_ }
      , pfnAllocation{ pfnAllocation_ }
      , pfnReallocation{ pfnReallocation_ }
      , pfnFree{ pfnFree_ }
      , pfnInternalAllocation{ pfnInternalAllocation_ }
      , pfnInternalFree{ pfnInternalFree_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AllocationCallbacks( AllocationCallbacks const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AllocationCallbacks( VkAllocationCallbacks const & rhs ) VULKAN_HPP_NOEXCEPT : AllocationCallbacks( *reinterpret_cast<AllocationCallbacks const *>( &rhs ) )
    {
    }

    AllocationCallbacks & operator=( AllocationCallbacks const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AllocationCallbacks & operator=( VkAllocationCallbacks const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AllocationCallbacks const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AllocationCallbacks & setPUserData( void * pUserData_ ) VULKAN_HPP_NOEXCEPT
    {
      pUserData = pUserData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AllocationCallbacks & setPfnAllocation( PFN_vkAllocationFunction pfnAllocation_ ) VULKAN_HPP_NOEXCEPT
    {
      pfnAllocation = pfnAllocation_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AllocationCallbacks & setPfnReallocation( PFN_vkReallocationFunction pfnReallocation_ ) VULKAN_HPP_NOEXCEPT
    {
      pfnReallocation = pfnReallocation_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AllocationCallbacks & setPfnFree( PFN_vkFreeFunction pfnFree_ ) VULKAN_HPP_NOEXCEPT
    {
      pfnFree = pfnFree_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AllocationCallbacks & setPfnInternalAllocation( PFN_vkInternalAllocationNotification pfnInternalAllocation_ ) VULKAN_HPP_NOEXCEPT
    {
      pfnInternalAllocation = pfnInternalAllocation_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AllocationCallbacks & setPfnInternalFree( PFN_vkInternalFreeNotification pfnInternalFree_ ) VULKAN_HPP_NOEXCEPT
    {
      pfnInternalFree = pfnInternalFree_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkAllocationCallbacks const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAllocationCallbacks *>( this );
    }

    operator VkAllocationCallbacks &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAllocationCallbacks *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<void * const &,
               PFN_vkAllocationFunction const &,
               PFN_vkReallocationFunction const &,
               PFN_vkFreeFunction const &,
               PFN_vkInternalAllocationNotification const &,
               PFN_vkInternalFreeNotification const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( pUserData, pfnAllocation, pfnReallocation, pfnFree, pfnInternalAllocation, pfnInternalFree );
    }
#endif

    bool operator==( AllocationCallbacks const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#else
      return ( pUserData == rhs.pUserData ) && ( pfnAllocation == rhs.pfnAllocation ) && ( pfnReallocation == rhs.pfnReallocation ) &&
             ( pfnFree == rhs.pfnFree ) && ( pfnInternalAllocation == rhs.pfnInternalAllocation ) && ( pfnInternalFree == rhs.pfnInternalFree );
#endif
    }

    bool operator!=( AllocationCallbacks const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }

  public:
    void *                               pUserData             = {};
    PFN_vkAllocationFunction             pfnAllocation         = {};
    PFN_vkReallocationFunction           pfnReallocation       = {};
    PFN_vkFreeFunction                   pfnFree               = {};
    PFN_vkInternalAllocationNotification pfnInternalAllocation = {};
    PFN_vkInternalFreeNotification       pfnInternalFree       = {};
  };

  struct ApplicationInfo
  {
    using NativeType = VkApplicationInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eApplicationInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ApplicationInfo( const char * pApplicationName_   = {},
                                          uint32_t     applicationVersion_ = {},
                                          const char * pEngineName_        = {},
                                          uint32_t     engineVersion_      = {},
                                          uint32_t     apiVersion_         = {},
                                          const void * pNext_              = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , pApplicationName{ pApplicationName_ }
      , applicationVersion{ applicationVersion_ }
      , pEngineName{ pEngineName_ }
      , engineVersion{ engineVersion_ }
      , apiVersion{ apiVersion_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ApplicationInfo( ApplicationInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ApplicationInfo( VkApplicationInfo const & rhs ) VULKAN_HPP_NOEXCEPT : ApplicationInfo( *reinterpret_cast<ApplicationInfo const *>( &rhs ) ) {}

    ApplicationInfo & operator=( ApplicationInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ApplicationInfo & operator=( VkApplicationInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ApplicationInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ApplicationInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ApplicationInfo & setPApplicationName( const char * pApplicationName_ ) VULKAN_HPP_NOEXCEPT
    {
      pApplicationName = pApplicationName_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ApplicationInfo & setApplicationVersion( uint32_t applicationVersion_ ) VULKAN_HPP_NOEXCEPT
    {
      applicationVersion = applicationVersion_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ApplicationInfo & setPEngineName( const char * pEngineName_ ) VULKAN_HPP_NOEXCEPT
    {
      pEngineName = pEngineName_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ApplicationInfo & setEngineVersion( uint32_t engineVersion_ ) VULKAN_HPP_NOEXCEPT
    {
      engineVersion = engineVersion_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ApplicationInfo & setApiVersion( uint32_t apiVersion_ ) VULKAN_HPP_NOEXCEPT
    {
      apiVersion = apiVersion_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkApplicationInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkApplicationInfo *>( this );
    }

    operator VkApplicationInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkApplicationInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               const char * const &,
               uint32_t const &,
               const char * const &,
               uint32_t const &,
               uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, pApplicationName, applicationVersion, pEngineName, engineVersion, apiVersion );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    std::strong_ordering operator<=>( ApplicationInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      if ( auto cmp = sType <=> rhs.sType; cmp != 0 )
        return cmp;
      if ( auto cmp = pNext <=> rhs.pNext; cmp != 0 )
        return cmp;
      if ( pApplicationName != rhs.pApplicationName )
        if ( auto cmp = strcmp( pApplicationName, rhs.pApplicationName ); cmp != 0 )
          return ( cmp < 0 ) ? std::strong_ordering::less : std::strong_ordering::greater;
      if ( auto cmp = applicationVersion <=> rhs.applicationVersion; cmp != 0 )
        return cmp;
      if ( pEngineName != rhs.pEngineName )
        if ( auto cmp = strcmp( pEngineName, rhs.pEngineName ); cmp != 0 )
          return ( cmp < 0 ) ? std::strong_ordering::less : std::strong_ordering::greater;
      if ( auto cmp = engineVersion <=> rhs.engineVersion; cmp != 0 )
        return cmp;
      if ( auto cmp = apiVersion <=> rhs.apiVersion; cmp != 0 )
        return cmp;

      return std::strong_ordering::equivalent;
    }
#endif

    bool operator==( ApplicationInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) &&
             ( ( pApplicationName == rhs.pApplicationName ) || ( strcmp( pApplicationName, rhs.pApplicationName ) == 0 ) ) &&
             ( applicationVersion == rhs.applicationVersion ) && ( ( pEngineName == rhs.pEngineName ) || ( strcmp( pEngineName, rhs.pEngineName ) == 0 ) ) &&
             ( engineVersion == rhs.engineVersion ) && ( apiVersion == rhs.apiVersion );
    }

    bool operator!=( ApplicationInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType              = StructureType::eApplicationInfo;
    const void *                        pNext              = {};
    const char *                        pApplicationName   = {};
    uint32_t                            applicationVersion = {};
    const char *                        pEngineName        = {};
    uint32_t                            engineVersion      = {};
    uint32_t                            apiVersion         = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eApplicationInfo>
  {
    using Type = ApplicationInfo;
  };

  struct ApplicationParametersEXT
  {
    using NativeType = VkApplicationParametersEXT;

    static const bool                                  allowDuplicate = true;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eApplicationParametersEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ApplicationParametersEXT(
      uint32_t vendorID_ = {}, uint32_t deviceID_ = {}, uint32_t key_ = {}, uint64_t value_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , vendorID{ vendorID_ }
      , deviceID{ deviceID_ }
      , key{ key_ }
      , value{ value_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ApplicationParametersEXT( ApplicationParametersEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ApplicationParametersEXT( VkApplicationParametersEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : ApplicationParametersEXT( *reinterpret_cast<ApplicationParametersEXT const *>( &rhs ) )
    {
    }

    ApplicationParametersEXT & operator=( ApplicationParametersEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ApplicationParametersEXT & operator=( VkApplicationParametersEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ApplicationParametersEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ApplicationParametersEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ApplicationParametersEXT & setVendorID( uint32_t vendorID_ ) VULKAN_HPP_NOEXCEPT
    {
      vendorID = vendorID_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ApplicationParametersEXT & setDeviceID( uint32_t deviceID_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceID = deviceID_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ApplicationParametersEXT & setKey( uint32_t key_ ) VULKAN_HPP_NOEXCEPT
    {
      key = key_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ApplicationParametersEXT & setValue( uint64_t value_ ) VULKAN_HPP_NOEXCEPT
    {
      value = value_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkApplicationParametersEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkApplicationParametersEXT *>( this );
    }

    operator VkApplicationParametersEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkApplicationParametersEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, uint32_t const &, uint32_t const &, uint32_t const &, uint64_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, vendorID, deviceID, key, value );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ApplicationParametersEXT const & ) const = default;
#else
    bool operator==( ApplicationParametersEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( vendorID == rhs.vendorID ) && ( deviceID == rhs.deviceID ) && ( key == rhs.key ) &&
             ( value == rhs.value );
#  endif
    }

    bool operator!=( ApplicationParametersEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType    = StructureType::eApplicationParametersEXT;
    const void *                        pNext    = {};
    uint32_t                            vendorID = {};
    uint32_t                            deviceID = {};
    uint32_t                            key      = {};
    uint64_t                            value    = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eApplicationParametersEXT>
  {
    using Type = ApplicationParametersEXT;
  };

  struct AttachmentDescription
  {
    using NativeType = VkAttachmentDescription;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      AttachmentDescription( VULKAN_HPP_NAMESPACE::AttachmentDescriptionFlags flags_          = {},
                             VULKAN_HPP_NAMESPACE::Format                     format_         = VULKAN_HPP_NAMESPACE::Format::eUndefined,
                             VULKAN_HPP_NAMESPACE::SampleCountFlagBits        samples_        = VULKAN_HPP_NAMESPACE::SampleCountFlagBits::e1,
                             VULKAN_HPP_NAMESPACE::AttachmentLoadOp           loadOp_         = VULKAN_HPP_NAMESPACE::AttachmentLoadOp::eLoad,
                             VULKAN_HPP_NAMESPACE::AttachmentStoreOp          storeOp_        = VULKAN_HPP_NAMESPACE::AttachmentStoreOp::eStore,
                             VULKAN_HPP_NAMESPACE::AttachmentLoadOp           stencilLoadOp_  = VULKAN_HPP_NAMESPACE::AttachmentLoadOp::eLoad,
                             VULKAN_HPP_NAMESPACE::AttachmentStoreOp          stencilStoreOp_ = VULKAN_HPP_NAMESPACE::AttachmentStoreOp::eStore,
                             VULKAN_HPP_NAMESPACE::ImageLayout                initialLayout_  = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                             VULKAN_HPP_NAMESPACE::ImageLayout                finalLayout_ = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined ) VULKAN_HPP_NOEXCEPT
      : flags{ flags_ }
      , format{ format_ }
      , samples{ samples_ }
      , loadOp{ loadOp_ }
      , storeOp{ storeOp_ }
      , stencilLoadOp{ stencilLoadOp_ }
      , stencilStoreOp{ stencilStoreOp_ }
      , initialLayout{ initialLayout_ }
      , finalLayout{ finalLayout_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AttachmentDescription( AttachmentDescription const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentDescription( VkAttachmentDescription const & rhs ) VULKAN_HPP_NOEXCEPT
      : AttachmentDescription( *reinterpret_cast<AttachmentDescription const *>( &rhs ) )
    {
    }

    AttachmentDescription & operator=( AttachmentDescription const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AttachmentDescription & operator=( VkAttachmentDescription const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AttachmentDescription const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription & setFlags( VULKAN_HPP_NAMESPACE::AttachmentDescriptionFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription & setFormat( VULKAN_HPP_NAMESPACE::Format format_ ) VULKAN_HPP_NOEXCEPT
    {
      format = format_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription & setSamples( VULKAN_HPP_NAMESPACE::SampleCountFlagBits samples_ ) VULKAN_HPP_NOEXCEPT
    {
      samples = samples_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription & setLoadOp( VULKAN_HPP_NAMESPACE::AttachmentLoadOp loadOp_ ) VULKAN_HPP_NOEXCEPT
    {
      loadOp = loadOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription & setStoreOp( VULKAN_HPP_NAMESPACE::AttachmentStoreOp storeOp_ ) VULKAN_HPP_NOEXCEPT
    {
      storeOp = storeOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription & setStencilLoadOp( VULKAN_HPP_NAMESPACE::AttachmentLoadOp stencilLoadOp_ ) VULKAN_HPP_NOEXCEPT
    {
      stencilLoadOp = stencilLoadOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription & setStencilStoreOp( VULKAN_HPP_NAMESPACE::AttachmentStoreOp stencilStoreOp_ ) VULKAN_HPP_NOEXCEPT
    {
      stencilStoreOp = stencilStoreOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription & setInitialLayout( VULKAN_HPP_NAMESPACE::ImageLayout initialLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      initialLayout = initialLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription & setFinalLayout( VULKAN_HPP_NAMESPACE::ImageLayout finalLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      finalLayout = finalLayout_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkAttachmentDescription const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAttachmentDescription *>( this );
    }

    operator VkAttachmentDescription &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAttachmentDescription *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::AttachmentDescriptionFlags const &,
               VULKAN_HPP_NAMESPACE::Format const &,
               VULKAN_HPP_NAMESPACE::SampleCountFlagBits const &,
               VULKAN_HPP_NAMESPACE::AttachmentLoadOp const &,
               VULKAN_HPP_NAMESPACE::AttachmentStoreOp const &,
               VULKAN_HPP_NAMESPACE::AttachmentLoadOp const &,
               VULKAN_HPP_NAMESPACE::AttachmentStoreOp const &,
               VULKAN_HPP_NAMESPACE::ImageLayout const &,
               VULKAN_HPP_NAMESPACE::ImageLayout const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( flags, format, samples, loadOp, storeOp, stencilLoadOp, stencilStoreOp, initialLayout, finalLayout );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AttachmentDescription const & ) const = default;
#else
    bool operator==( AttachmentDescription const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( flags == rhs.flags ) && ( format == rhs.format ) && ( samples == rhs.samples ) && ( loadOp == rhs.loadOp ) && ( storeOp == rhs.storeOp ) &&
             ( stencilLoadOp == rhs.stencilLoadOp ) && ( stencilStoreOp == rhs.stencilStoreOp ) && ( initialLayout == rhs.initialLayout ) &&
             ( finalLayout == rhs.finalLayout );
#  endif
    }

    bool operator!=( AttachmentDescription const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::AttachmentDescriptionFlags flags          = {};
    VULKAN_HPP_NAMESPACE::Format                     format         = VULKAN_HPP_NAMESPACE::Format::eUndefined;
    VULKAN_HPP_NAMESPACE::SampleCountFlagBits        samples        = VULKAN_HPP_NAMESPACE::SampleCountFlagBits::e1;
    VULKAN_HPP_NAMESPACE::AttachmentLoadOp           loadOp         = VULKAN_HPP_NAMESPACE::AttachmentLoadOp::eLoad;
    VULKAN_HPP_NAMESPACE::AttachmentStoreOp          storeOp        = VULKAN_HPP_NAMESPACE::AttachmentStoreOp::eStore;
    VULKAN_HPP_NAMESPACE::AttachmentLoadOp           stencilLoadOp  = VULKAN_HPP_NAMESPACE::AttachmentLoadOp::eLoad;
    VULKAN_HPP_NAMESPACE::AttachmentStoreOp          stencilStoreOp = VULKAN_HPP_NAMESPACE::AttachmentStoreOp::eStore;
    VULKAN_HPP_NAMESPACE::ImageLayout                initialLayout  = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    VULKAN_HPP_NAMESPACE::ImageLayout                finalLayout    = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
  };

  struct AttachmentDescription2
  {
    using NativeType = VkAttachmentDescription2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAttachmentDescription2;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AttachmentDescription2( VULKAN_HPP_NAMESPACE::AttachmentDescriptionFlags flags_   = {},
                                                 VULKAN_HPP_NAMESPACE::Format                     format_  = VULKAN_HPP_NAMESPACE::Format::eUndefined,
                                                 VULKAN_HPP_NAMESPACE::SampleCountFlagBits        samples_ = VULKAN_HPP_NAMESPACE::SampleCountFlagBits::e1,
                                                 VULKAN_HPP_NAMESPACE::AttachmentLoadOp           loadOp_  = VULKAN_HPP_NAMESPACE::AttachmentLoadOp::eLoad,
                                                 VULKAN_HPP_NAMESPACE::AttachmentStoreOp          storeOp_ = VULKAN_HPP_NAMESPACE::AttachmentStoreOp::eStore,
                                                 VULKAN_HPP_NAMESPACE::AttachmentLoadOp  stencilLoadOp_    = VULKAN_HPP_NAMESPACE::AttachmentLoadOp::eLoad,
                                                 VULKAN_HPP_NAMESPACE::AttachmentStoreOp stencilStoreOp_   = VULKAN_HPP_NAMESPACE::AttachmentStoreOp::eStore,
                                                 VULKAN_HPP_NAMESPACE::ImageLayout       initialLayout_    = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                                                 VULKAN_HPP_NAMESPACE::ImageLayout       finalLayout_      = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                                                 const void *                            pNext_            = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , format{ format_ }
      , samples{ samples_ }
      , loadOp{ loadOp_ }
      , storeOp{ storeOp_ }
      , stencilLoadOp{ stencilLoadOp_ }
      , stencilStoreOp{ stencilStoreOp_ }
      , initialLayout{ initialLayout_ }
      , finalLayout{ finalLayout_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AttachmentDescription2( AttachmentDescription2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentDescription2( VkAttachmentDescription2 const & rhs ) VULKAN_HPP_NOEXCEPT
      : AttachmentDescription2( *reinterpret_cast<AttachmentDescription2 const *>( &rhs ) )
    {
    }

    AttachmentDescription2 & operator=( AttachmentDescription2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AttachmentDescription2 & operator=( VkAttachmentDescription2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AttachmentDescription2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription2 & setFlags( VULKAN_HPP_NAMESPACE::AttachmentDescriptionFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription2 & setFormat( VULKAN_HPP_NAMESPACE::Format format_ ) VULKAN_HPP_NOEXCEPT
    {
      format = format_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription2 & setSamples( VULKAN_HPP_NAMESPACE::SampleCountFlagBits samples_ ) VULKAN_HPP_NOEXCEPT
    {
      samples = samples_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription2 & setLoadOp( VULKAN_HPP_NAMESPACE::AttachmentLoadOp loadOp_ ) VULKAN_HPP_NOEXCEPT
    {
      loadOp = loadOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription2 & setStoreOp( VULKAN_HPP_NAMESPACE::AttachmentStoreOp storeOp_ ) VULKAN_HPP_NOEXCEPT
    {
      storeOp = storeOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription2 & setStencilLoadOp( VULKAN_HPP_NAMESPACE::AttachmentLoadOp stencilLoadOp_ ) VULKAN_HPP_NOEXCEPT
    {
      stencilLoadOp = stencilLoadOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription2 & setStencilStoreOp( VULKAN_HPP_NAMESPACE::AttachmentStoreOp stencilStoreOp_ ) VULKAN_HPP_NOEXCEPT
    {
      stencilStoreOp = stencilStoreOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription2 & setInitialLayout( VULKAN_HPP_NAMESPACE::ImageLayout initialLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      initialLayout = initialLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription2 & setFinalLayout( VULKAN_HPP_NAMESPACE::ImageLayout finalLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      finalLayout = finalLayout_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkAttachmentDescription2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAttachmentDescription2 *>( this );
    }

    operator VkAttachmentDescription2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAttachmentDescription2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::AttachmentDescriptionFlags const &,
               VULKAN_HPP_NAMESPACE::Format const &,
               VULKAN_HPP_NAMESPACE::SampleCountFlagBits const &,
               VULKAN_HPP_NAMESPACE::AttachmentLoadOp const &,
               VULKAN_HPP_NAMESPACE::AttachmentStoreOp const &,
               VULKAN_HPP_NAMESPACE::AttachmentLoadOp const &,
               VULKAN_HPP_NAMESPACE::AttachmentStoreOp const &,
               VULKAN_HPP_NAMESPACE::ImageLayout const &,
               VULKAN_HPP_NAMESPACE::ImageLayout const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, format, samples, loadOp, storeOp, stencilLoadOp, stencilStoreOp, initialLayout, finalLayout );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AttachmentDescription2 const & ) const = default;
#else
    bool operator==( AttachmentDescription2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( format == rhs.format ) && ( samples == rhs.samples ) &&
             ( loadOp == rhs.loadOp ) && ( storeOp == rhs.storeOp ) && ( stencilLoadOp == rhs.stencilLoadOp ) && ( stencilStoreOp == rhs.stencilStoreOp ) &&
             ( initialLayout == rhs.initialLayout ) && ( finalLayout == rhs.finalLayout );
#  endif
    }

    bool operator!=( AttachmentDescription2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType              sType          = StructureType::eAttachmentDescription2;
    const void *                                     pNext          = {};
    VULKAN_HPP_NAMESPACE::AttachmentDescriptionFlags flags          = {};
    VULKAN_HPP_NAMESPACE::Format                     format         = VULKAN_HPP_NAMESPACE::Format::eUndefined;
    VULKAN_HPP_NAMESPACE::SampleCountFlagBits        samples        = VULKAN_HPP_NAMESPACE::SampleCountFlagBits::e1;
    VULKAN_HPP_NAMESPACE::AttachmentLoadOp           loadOp         = VULKAN_HPP_NAMESPACE::AttachmentLoadOp::eLoad;
    VULKAN_HPP_NAMESPACE::AttachmentStoreOp          storeOp        = VULKAN_HPP_NAMESPACE::AttachmentStoreOp::eStore;
    VULKAN_HPP_NAMESPACE::AttachmentLoadOp           stencilLoadOp  = VULKAN_HPP_NAMESPACE::AttachmentLoadOp::eLoad;
    VULKAN_HPP_NAMESPACE::AttachmentStoreOp          stencilStoreOp = VULKAN_HPP_NAMESPACE::AttachmentStoreOp::eStore;
    VULKAN_HPP_NAMESPACE::ImageLayout                initialLayout  = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    VULKAN_HPP_NAMESPACE::ImageLayout                finalLayout    = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
  };

  template <>
  struct CppType<StructureType, StructureType::eAttachmentDescription2>
  {
    using Type = AttachmentDescription2;
  };

  using AttachmentDescription2KHR = AttachmentDescription2;

  struct AttachmentDescriptionStencilLayout
  {
    using NativeType = VkAttachmentDescriptionStencilLayout;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAttachmentDescriptionStencilLayout;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      AttachmentDescriptionStencilLayout( VULKAN_HPP_NAMESPACE::ImageLayout stencilInitialLayout_ = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                                          VULKAN_HPP_NAMESPACE::ImageLayout stencilFinalLayout_   = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                                          void *                            pNext_                = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , stencilInitialLayout{ stencilInitialLayout_ }
      , stencilFinalLayout{ stencilFinalLayout_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AttachmentDescriptionStencilLayout( AttachmentDescriptionStencilLayout const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentDescriptionStencilLayout( VkAttachmentDescriptionStencilLayout const & rhs ) VULKAN_HPP_NOEXCEPT
      : AttachmentDescriptionStencilLayout( *reinterpret_cast<AttachmentDescriptionStencilLayout const *>( &rhs ) )
    {
    }

    AttachmentDescriptionStencilLayout & operator=( AttachmentDescriptionStencilLayout const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AttachmentDescriptionStencilLayout & operator=( VkAttachmentDescriptionStencilLayout const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AttachmentDescriptionStencilLayout const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AttachmentDescriptionStencilLayout & setPNext( void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescriptionStencilLayout &
      setStencilInitialLayout( VULKAN_HPP_NAMESPACE::ImageLayout stencilInitialLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      stencilInitialLayout = stencilInitialLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescriptionStencilLayout &
      setStencilFinalLayout( VULKAN_HPP_NAMESPACE::ImageLayout stencilFinalLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      stencilFinalLayout = stencilFinalLayout_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkAttachmentDescriptionStencilLayout const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAttachmentDescriptionStencilLayout *>( this );
    }

    operator VkAttachmentDescriptionStencilLayout &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAttachmentDescriptionStencilLayout *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::
      tuple<VULKAN_HPP_NAMESPACE::StructureType const &, void * const &, VULKAN_HPP_NAMESPACE::ImageLayout const &, VULKAN_HPP_NAMESPACE::ImageLayout const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, stencilInitialLayout, stencilFinalLayout );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AttachmentDescriptionStencilLayout const & ) const = default;
#else
    bool operator==( AttachmentDescriptionStencilLayout const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( stencilInitialLayout == rhs.stencilInitialLayout ) &&
             ( stencilFinalLayout == rhs.stencilFinalLayout );
#  endif
    }

    bool operator!=( AttachmentDescriptionStencilLayout const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType                = StructureType::eAttachmentDescriptionStencilLayout;
    void *                              pNext                = {};
    VULKAN_HPP_NAMESPACE::ImageLayout   stencilInitialLayout = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    VULKAN_HPP_NAMESPACE::ImageLayout   stencilFinalLayout   = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
  };

  template <>
  struct CppType<StructureType, StructureType::eAttachmentDescriptionStencilLayout>
  {
    using Type = AttachmentDescriptionStencilLayout;
  };

  using AttachmentDescriptionStencilLayoutKHR = AttachmentDescriptionStencilLayout;

  struct AttachmentReference
  {
    using NativeType = VkAttachmentReference;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AttachmentReference( uint32_t                          attachment_ = {},
                                              VULKAN_HPP_NAMESPACE::ImageLayout layout_ = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined ) VULKAN_HPP_NOEXCEPT
      : attachment{ attachment_ }
      , layout{ layout_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AttachmentReference( AttachmentReference const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentReference( VkAttachmentReference const & rhs ) VULKAN_HPP_NOEXCEPT : AttachmentReference( *reinterpret_cast<AttachmentReference const *>( &rhs ) )
    {
    }

    AttachmentReference & operator=( AttachmentReference const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AttachmentReference & operator=( VkAttachmentReference const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AttachmentReference const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AttachmentReference & setAttachment( uint32_t attachment_ ) VULKAN_HPP_NOEXCEPT
    {
      attachment = attachment_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentReference & setLayout( VULKAN_HPP_NAMESPACE::ImageLayout layout_ ) VULKAN_HPP_NOEXCEPT
    {
      layout = layout_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkAttachmentReference const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAttachmentReference *>( this );
    }

    operator VkAttachmentReference &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAttachmentReference *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &, VULKAN_HPP_NAMESPACE::ImageLayout const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( attachment, layout );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AttachmentReference const & ) const = default;
#else
    bool operator==( AttachmentReference const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( attachment == rhs.attachment ) && ( layout == rhs.layout );
#  endif
    }

    bool operator!=( AttachmentReference const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t                          attachment = {};
    VULKAN_HPP_NAMESPACE::ImageLayout layout     = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
  };

  struct AttachmentReference2
  {
    using NativeType = VkAttachmentReference2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAttachmentReference2;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AttachmentReference2( uint32_t                               attachment_ = {},
                                               VULKAN_HPP_NAMESPACE::ImageLayout      layout_     = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                                               VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask_ = {},
                                               const void *                           pNext_      = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , attachment{ attachment_ }
      , layout{ layout_ }
      , aspectMask{ aspectMask_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AttachmentReference2( AttachmentReference2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentReference2( VkAttachmentReference2 const & rhs ) VULKAN_HPP_NOEXCEPT
      : AttachmentReference2( *reinterpret_cast<AttachmentReference2 const *>( &rhs ) )
    {
    }

    AttachmentReference2 & operator=( AttachmentReference2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AttachmentReference2 & operator=( VkAttachmentReference2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AttachmentReference2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AttachmentReference2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentReference2 & setAttachment( uint32_t attachment_ ) VULKAN_HPP_NOEXCEPT
    {
      attachment = attachment_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentReference2 & setLayout( VULKAN_HPP_NAMESPACE::ImageLayout layout_ ) VULKAN_HPP_NOEXCEPT
    {
      layout = layout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentReference2 & setAspectMask( VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask_ ) VULKAN_HPP_NOEXCEPT
    {
      aspectMask = aspectMask_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkAttachmentReference2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAttachmentReference2 *>( this );
    }

    operator VkAttachmentReference2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAttachmentReference2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::ImageLayout const &,
               VULKAN_HPP_NAMESPACE::ImageAspectFlags const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, attachment, layout, aspectMask );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AttachmentReference2 const & ) const = default;
#else
    bool operator==( AttachmentReference2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( attachment == rhs.attachment ) && ( layout == rhs.layout ) &&
             ( aspectMask == rhs.aspectMask );
#  endif
    }

    bool operator!=( AttachmentReference2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType    sType      = StructureType::eAttachmentReference2;
    const void *                           pNext      = {};
    uint32_t                               attachment = {};
    VULKAN_HPP_NAMESPACE::ImageLayout      layout     = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAttachmentReference2>
  {
    using Type = AttachmentReference2;
  };

  using AttachmentReference2KHR = AttachmentReference2;

  struct AttachmentReferenceStencilLayout
  {
    using NativeType = VkAttachmentReferenceStencilLayout;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAttachmentReferenceStencilLayout;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AttachmentReferenceStencilLayout( VULKAN_HPP_NAMESPACE::ImageLayout stencilLayout_ = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                                                           void *                            pNext_         = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , stencilLayout{ stencilLayout_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AttachmentReferenceStencilLayout( AttachmentReferenceStencilLayout const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentReferenceStencilLayout( VkAttachmentReferenceStencilLayout const & rhs ) VULKAN_HPP_NOEXCEPT
      : AttachmentReferenceStencilLayout( *reinterpret_cast<AttachmentReferenceStencilLayout const *>( &rhs ) )
    {
    }

    AttachmentReferenceStencilLayout & operator=( AttachmentReferenceStencilLayout const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AttachmentReferenceStencilLayout & operator=( VkAttachmentReferenceStencilLayout const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AttachmentReferenceStencilLayout const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AttachmentReferenceStencilLayout & setPNext( void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentReferenceStencilLayout & setStencilLayout( VULKAN_HPP_NAMESPACE::ImageLayout stencilLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      stencilLayout = stencilLayout_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkAttachmentReferenceStencilLayout const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAttachmentReferenceStencilLayout *>( this );
    }

    operator VkAttachmentReferenceStencilLayout &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAttachmentReferenceStencilLayout *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, void * const &, VULKAN_HPP_NAMESPACE::ImageLayout const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, stencilLayout );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AttachmentReferenceStencilLayout const & ) const = default;
#else
    bool operator==( AttachmentReferenceStencilLayout const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( stencilLayout == rhs.stencilLayout );
#  endif
    }

    bool operator!=( AttachmentReferenceStencilLayout const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType         = StructureType::eAttachmentReferenceStencilLayout;
    void *                              pNext         = {};
    VULKAN_HPP_NAMESPACE::ImageLayout   stencilLayout = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
  };

  template <>
  struct CppType<StructureType, StructureType::eAttachmentReferenceStencilLayout>
  {
    using Type = AttachmentReferenceStencilLayout;
  };

  using AttachmentReferenceStencilLayoutKHR = AttachmentReferenceStencilLayout;

  struct Extent2D
  {
    using NativeType = VkExtent2D;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR Extent2D( uint32_t width_ = {}, uint32_t height_ = {} ) VULKAN_HPP_NOEXCEPT
      : width{ width_ }
      , height{ height_ }
    {
    }

    VULKAN_HPP_CONSTEXPR Extent2D( Extent2D const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    Extent2D( VkExtent2D const & rhs ) VULKAN_HPP_NOEXCEPT : Extent2D( *reinterpret_cast<Extent2D const *>( &rhs ) ) {}

    Extent2D & operator=( Extent2D const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    Extent2D & operator=( VkExtent2D const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::Extent2D const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 Extent2D & setWidth( uint32_t width_ ) VULKAN_HPP_NOEXCEPT
    {
      width = width_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Extent2D & setHeight( uint32_t height_ ) VULKAN_HPP_NOEXCEPT
    {
      height = height_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkExtent2D const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkExtent2D *>( this );
    }

    operator VkExtent2D &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkExtent2D *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( width, height );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( Extent2D const & ) const = default;
#else
    bool operator==( Extent2D const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( width == rhs.width ) && ( height == rhs.height );
#  endif
    }

    bool operator!=( Extent2D const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t width  = {};
    uint32_t height = {};
  };

  struct SampleLocationEXT
  {
    using NativeType = VkSampleLocationEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR SampleLocationEXT( float x_ = {}, float y_ = {} ) VULKAN_HPP_NOEXCEPT
      : x{ x_ }
      , y{ y_ }
    {
    }

    VULKAN_HPP_CONSTEXPR SampleLocationEXT( SampleLocationEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SampleLocationEXT( VkSampleLocationEXT const & rhs ) VULKAN_HPP_NOEXCEPT : SampleLocationEXT( *reinterpret_cast<SampleLocationEXT const *>( &rhs ) ) {}

    SampleLocationEXT & operator=( SampleLocationEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    SampleLocationEXT & operator=( VkSampleLocationEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::SampleLocationEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 SampleLocationEXT & setX( float x_ ) VULKAN_HPP_NOEXCEPT
    {
      x = x_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SampleLocationEXT & setY( float y_ ) VULKAN_HPP_NOEXCEPT
    {
      y = y_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkSampleLocationEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkSampleLocationEXT *>( this );
    }

    operator VkSampleLocationEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkSampleLocationEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<float const &, float const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( x, y );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( SampleLocationEXT const & ) const = default;
#else
    bool operator==( SampleLocationEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( x == rhs.x ) && ( y == rhs.y );
#  endif
    }

    bool operator!=( SampleLocationEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    float x = {};
    float y = {};
  };

  struct SampleLocationsInfoEXT
  {
    using NativeType = VkSampleLocationsInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eSampleLocationsInfoEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      SampleLocationsInfoEXT( VULKAN_HPP_NAMESPACE::SampleCountFlagBits       sampleLocationsPerPixel_ = VULKAN_HPP_NAMESPACE::SampleCountFlagBits::e1,
                              VULKAN_HPP_NAMESPACE::Extent2D                  sampleLocationGridSize_  = {},
                              uint32_t                                        sampleLocationsCount_    = {},
                              const VULKAN_HPP_NAMESPACE::SampleLocationEXT * pSampleLocations_        = {},
                              const void *                                    pNext_                   = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , sampleLocationsPerPixel{ sampleLocationsPerPixel_ }
      , sampleLocationGridSize{ sampleLocationGridSize_ }
      , sampleLocationsCount{ sampleLocationsCount_ }
      , pSampleLocations{ pSampleLocations_ }
    {
    }

    VULKAN_HPP_CONSTEXPR SampleLocationsInfoEXT( SampleLocationsInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SampleLocationsInfoEXT( VkSampleLocationsInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : SampleLocationsInfoEXT( *reinterpret_cast<SampleLocationsInfoEXT const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    SampleLocationsInfoEXT( VULKAN_HPP_NAMESPACE::SampleCountFlagBits                                                            sampleLocationsPerPixel_,
                            VULKAN_HPP_NAMESPACE::Extent2D                                                                       sampleLocationGridSize_,
                            VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SampleLocationEXT> const & sampleLocations_,
                            const void *                                                                                         pNext_ = nullptr )
      : pNext( pNext_ )
      , sampleLocationsPerPixel( sampleLocationsPerPixel_ )
      , sampleLocationGridSize( sampleLocationGridSize_ )
      , sampleLocationsCount( static_cast<uint32_t>( sampleLocations_.size() ) )
      , pSampleLocations( sampleLocations_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    SampleLocationsInfoEXT & operator=( SampleLocationsInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    SampleLocationsInfoEXT & operator=( VkSampleLocationsInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::SampleLocationsInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 SampleLocationsInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SampleLocationsInfoEXT &
      setSampleLocationsPerPixel( VULKAN_HPP_NAMESPACE::SampleCountFlagBits sampleLocationsPerPixel_ ) VULKAN_HPP_NOEXCEPT
    {
      sampleLocationsPerPixel = sampleLocationsPerPixel_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SampleLocationsInfoEXT &
      setSampleLocationGridSize( VULKAN_HPP_NAMESPACE::Extent2D const & sampleLocationGridSize_ ) VULKAN_HPP_NOEXCEPT
    {
      sampleLocationGridSize = sampleLocationGridSize_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SampleLocationsInfoEXT & setSampleLocationsCount( uint32_t sampleLocationsCount_ ) VULKAN_HPP_NOEXCEPT
    {
      sampleLocationsCount = sampleLocationsCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SampleLocationsInfoEXT &
      setPSampleLocations( const VULKAN_HPP_NAMESPACE::SampleLocationEXT * pSampleLocations_ ) VULKAN_HPP_NOEXCEPT
    {
      pSampleLocations = pSampleLocations_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    SampleLocationsInfoEXT & setSampleLocations(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SampleLocationEXT> const & sampleLocations_ ) VULKAN_HPP_NOEXCEPT
    {
      sampleLocationsCount = static_cast<uint32_t>( sampleLocations_.size() );
      pSampleLocations     = sampleLocations_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkSampleLocationsInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkSampleLocationsInfoEXT *>( this );
    }

    operator VkSampleLocationsInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkSampleLocationsInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::SampleCountFlagBits const &,
               VULKAN_HPP_NAMESPACE::Extent2D const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::SampleLocationEXT * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, sampleLocationsPerPixel, sampleLocationGridSize, sampleLocationsCount, pSampleLocations );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( SampleLocationsInfoEXT const & ) const = default;
#else
    bool operator==( SampleLocationsInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( sampleLocationsPerPixel == rhs.sampleLocationsPerPixel ) &&
             ( sampleLocationGridSize == rhs.sampleLocationGridSize ) && ( sampleLocationsCount == rhs.sampleLocationsCount ) &&
             ( pSampleLocations == rhs.pSampleLocations );
#  endif
    }

    bool operator!=( SampleLocationsInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType             sType                   = StructureType::eSampleLocationsInfoEXT;
    const void *                                    pNext                   = {};
    VULKAN_HPP_NAMESPACE::SampleCountFlagBits       sampleLocationsPerPixel = VULKAN_HPP_NAMESPACE::SampleCountFlagBits::e1;
    VULKAN_HPP_NAMESPACE::Extent2D                  sampleLocationGridSize  = {};
    uint32_t                                        sampleLocationsCount    = {};
    const VULKAN_HPP_NAMESPACE::SampleLocationEXT * pSampleLocations        = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eSampleLocationsInfoEXT>
  {
    using Type = SampleLocationsInfoEXT;
  };

  struct AttachmentSampleLocationsEXT
  {
    using NativeType = VkAttachmentSampleLocationsEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AttachmentSampleLocationsEXT( uint32_t                                     attachmentIndex_     = {},
                                                       VULKAN_HPP_NAMESPACE::SampleLocationsInfoEXT sampleLocationsInfo_ = {} ) VULKAN_HPP_NOEXCEPT
      : attachmentIndex{ attachmentIndex_ }
      , sampleLocationsInfo{ sampleLocationsInfo_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AttachmentSampleLocationsEXT( AttachmentSampleLocationsEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentSampleLocationsEXT( VkAttachmentSampleLocationsEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : AttachmentSampleLocationsEXT( *reinterpret_cast<AttachmentSampleLocationsEXT const *>( &rhs ) )
    {
    }

    AttachmentSampleLocationsEXT & operator=( AttachmentSampleLocationsEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AttachmentSampleLocationsEXT & operator=( VkAttachmentSampleLocationsEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AttachmentSampleLocationsEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AttachmentSampleLocationsEXT & setAttachmentIndex( uint32_t attachmentIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      attachmentIndex = attachmentIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentSampleLocationsEXT &
      setSampleLocationsInfo( VULKAN_HPP_NAMESPACE::SampleLocationsInfoEXT const & sampleLocationsInfo_ ) VULKAN_HPP_NOEXCEPT
    {
      sampleLocationsInfo = sampleLocationsInfo_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkAttachmentSampleLocationsEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAttachmentSampleLocationsEXT *>( this );
    }

    operator VkAttachmentSampleLocationsEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAttachmentSampleLocationsEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &, VULKAN_HPP_NAMESPACE::SampleLocationsInfoEXT const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( attachmentIndex, sampleLocationsInfo );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AttachmentSampleLocationsEXT const & ) const = default;
#else
    bool operator==( AttachmentSampleLocationsEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( attachmentIndex == rhs.attachmentIndex ) && ( sampleLocationsInfo == rhs.sampleLocationsInfo );
#  endif
    }

    bool operator!=( AttachmentSampleLocationsEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t                                     attachmentIndex     = {};
    VULKAN_HPP_NAMESPACE::SampleLocationsInfoEXT sampleLocationsInfo = {};
  };

  struct BaseInStructure
  {
    using NativeType = VkBaseInStructure;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    BaseInStructure( VULKAN_HPP_NAMESPACE::StructureType                  sType_ = VULKAN_HPP_NAMESPACE::StructureType::eApplicationInfo,
                     const struct VULKAN_HPP_NAMESPACE::BaseInStructure * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : sType{ sType_ }
      , pNext{ pNext_ }
    {
    }

    BaseInStructure( BaseInStructure const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BaseInStructure( VkBaseInStructure const & rhs ) VULKAN_HPP_NOEXCEPT : BaseInStructure( *reinterpret_cast<BaseInStructure const *>( &rhs ) ) {}

    BaseInStructure & operator=( BaseInStructure const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BaseInStructure & operator=( VkBaseInStructure const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BaseInStructure const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BaseInStructure & setPNext( const struct VULKAN_HPP_NAMESPACE::BaseInStructure * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBaseInStructure const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBaseInStructure *>( this );
    }

    operator VkBaseInStructure &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBaseInStructure *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const struct VULKAN_HPP_NAMESPACE::BaseInStructure * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BaseInStructure const & ) const = default;
#else
    bool operator==( BaseInStructure const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext );
#  endif
    }

    bool operator!=( BaseInStructure const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                  sType = VULKAN_HPP_NAMESPACE::StructureType::eApplicationInfo;
    const struct VULKAN_HPP_NAMESPACE::BaseInStructure * pNext = {};
  };

  struct BaseOutStructure
  {
    using NativeType = VkBaseOutStructure;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    BaseOutStructure( VULKAN_HPP_NAMESPACE::StructureType             sType_ = VULKAN_HPP_NAMESPACE::StructureType::eApplicationInfo,
                      struct VULKAN_HPP_NAMESPACE::BaseOutStructure * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : sType{ sType_ }
      , pNext{ pNext_ }
    {
    }

    BaseOutStructure( BaseOutStructure const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BaseOutStructure( VkBaseOutStructure const & rhs ) VULKAN_HPP_NOEXCEPT : BaseOutStructure( *reinterpret_cast<BaseOutStructure const *>( &rhs ) ) {}

    BaseOutStructure & operator=( BaseOutStructure const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BaseOutStructure & operator=( VkBaseOutStructure const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BaseOutStructure const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BaseOutStructure & setPNext( struct VULKAN_HPP_NAMESPACE::BaseOutStructure * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBaseOutStructure const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBaseOutStructure *>( this );
    }

    operator VkBaseOutStructure &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBaseOutStructure *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, struct VULKAN_HPP_NAMESPACE::BaseOutStructure * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BaseOutStructure const & ) const = default;
#else
    bool operator==( BaseOutStructure const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext );
#  endif
    }

    bool operator!=( BaseOutStructure const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType             sType = VULKAN_HPP_NAMESPACE::StructureType::eApplicationInfo;
    struct VULKAN_HPP_NAMESPACE::BaseOutStructure * pNext = {};
  };

  struct BindBufferMemoryDeviceGroupInfo
  {
    using NativeType = VkBindBufferMemoryDeviceGroupInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBindBufferMemoryDeviceGroupInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindBufferMemoryDeviceGroupInfo( uint32_t         deviceIndexCount_ = {},
                                                          const uint32_t * pDeviceIndices_   = {},
                                                          const void *     pNext_            = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , deviceIndexCount{ deviceIndexCount_ }
      , pDeviceIndices{ pDeviceIndices_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BindBufferMemoryDeviceGroupInfo( BindBufferMemoryDeviceGroupInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindBufferMemoryDeviceGroupInfo( VkBindBufferMemoryDeviceGroupInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindBufferMemoryDeviceGroupInfo( *reinterpret_cast<BindBufferMemoryDeviceGroupInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindBufferMemoryDeviceGroupInfo( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint32_t> const & deviceIndices_, const void * pNext_ = nullptr )
      : pNext( pNext_ ), deviceIndexCount( static_cast<uint32_t>( deviceIndices_.size() ) ), pDeviceIndices( deviceIndices_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    BindBufferMemoryDeviceGroupInfo & operator=( BindBufferMemoryDeviceGroupInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BindBufferMemoryDeviceGroupInfo & operator=( VkBindBufferMemoryDeviceGroupInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BindBufferMemoryDeviceGroupInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindBufferMemoryDeviceGroupInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindBufferMemoryDeviceGroupInfo & setDeviceIndexCount( uint32_t deviceIndexCount_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceIndexCount = deviceIndexCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindBufferMemoryDeviceGroupInfo & setPDeviceIndices( const uint32_t * pDeviceIndices_ ) VULKAN_HPP_NOEXCEPT
    {
      pDeviceIndices = pDeviceIndices_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindBufferMemoryDeviceGroupInfo &
      setDeviceIndices( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint32_t> const & deviceIndices_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceIndexCount = static_cast<uint32_t>( deviceIndices_.size() );
      pDeviceIndices   = deviceIndices_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBindBufferMemoryDeviceGroupInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindBufferMemoryDeviceGroupInfo *>( this );
    }

    operator VkBindBufferMemoryDeviceGroupInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindBufferMemoryDeviceGroupInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, uint32_t const &, const uint32_t * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, deviceIndexCount, pDeviceIndices );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindBufferMemoryDeviceGroupInfo const & ) const = default;
#else
    bool operator==( BindBufferMemoryDeviceGroupInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( deviceIndexCount == rhs.deviceIndexCount ) && ( pDeviceIndices == rhs.pDeviceIndices );
#  endif
    }

    bool operator!=( BindBufferMemoryDeviceGroupInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType            = StructureType::eBindBufferMemoryDeviceGroupInfo;
    const void *                        pNext            = {};
    uint32_t                            deviceIndexCount = {};
    const uint32_t *                    pDeviceIndices   = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBindBufferMemoryDeviceGroupInfo>
  {
    using Type = BindBufferMemoryDeviceGroupInfo;
  };

  using BindBufferMemoryDeviceGroupInfoKHR = BindBufferMemoryDeviceGroupInfo;

  struct BindBufferMemoryInfo
  {
    using NativeType = VkBindBufferMemoryInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBindBufferMemoryInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindBufferMemoryInfo( VULKAN_HPP_NAMESPACE::Buffer       buffer_       = {},
                                               VULKAN_HPP_NAMESPACE::DeviceMemory memory_       = {},
                                               VULKAN_HPP_NAMESPACE::DeviceSize   memoryOffset_ = {},
                                               const void *                       pNext_        = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , buffer{ buffer_ }
      , memory{ memory_ }
      , memoryOffset{ memoryOffset_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BindBufferMemoryInfo( BindBufferMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindBufferMemoryInfo( VkBindBufferMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindBufferMemoryInfo( *reinterpret_cast<BindBufferMemoryInfo const *>( &rhs ) )
    {
    }

    BindBufferMemoryInfo & operator=( BindBufferMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BindBufferMemoryInfo & operator=( VkBindBufferMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BindBufferMemoryInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindBufferMemoryInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindBufferMemoryInfo & setBuffer( VULKAN_HPP_NAMESPACE::Buffer buffer_ ) VULKAN_HPP_NOEXCEPT
    {
      buffer = buffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindBufferMemoryInfo & setMemory( VULKAN_HPP_NAMESPACE::DeviceMemory memory_ ) VULKAN_HPP_NOEXCEPT
    {
      memory = memory_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindBufferMemoryInfo & setMemoryOffset( VULKAN_HPP_NAMESPACE::DeviceSize memoryOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      memoryOffset = memoryOffset_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBindBufferMemoryInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindBufferMemoryInfo *>( this );
    }

    operator VkBindBufferMemoryInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindBufferMemoryInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::Buffer const &,
               VULKAN_HPP_NAMESPACE::DeviceMemory const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, buffer, memory, memoryOffset );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindBufferMemoryInfo const & ) const = default;
#else
    bool operator==( BindBufferMemoryInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( buffer == rhs.buffer ) && ( memory == rhs.memory ) && ( memoryOffset == rhs.memoryOffset );
#  endif
    }

    bool operator!=( BindBufferMemoryInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType        = StructureType::eBindBufferMemoryInfo;
    const void *                        pNext        = {};
    VULKAN_HPP_NAMESPACE::Buffer        buffer       = {};
    VULKAN_HPP_NAMESPACE::DeviceMemory  memory       = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    memoryOffset = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBindBufferMemoryInfo>
  {
    using Type = BindBufferMemoryInfo;
  };

  using BindBufferMemoryInfoKHR = BindBufferMemoryInfo;

  struct Offset2D
  {
    using NativeType = VkOffset2D;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR Offset2D( int32_t x_ = {}, int32_t y_ = {} ) VULKAN_HPP_NOEXCEPT
      : x{ x_ }
      , y{ y_ }
    {
    }

    VULKAN_HPP_CONSTEXPR Offset2D( Offset2D const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    Offset2D( VkOffset2D const & rhs ) VULKAN_HPP_NOEXCEPT : Offset2D( *reinterpret_cast<Offset2D const *>( &rhs ) ) {}

    Offset2D & operator=( Offset2D const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    Offset2D & operator=( VkOffset2D const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::Offset2D const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 Offset2D & setX( int32_t x_ ) VULKAN_HPP_NOEXCEPT
    {
      x = x_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Offset2D & setY( int32_t y_ ) VULKAN_HPP_NOEXCEPT
    {
      y = y_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkOffset2D const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkOffset2D *>( this );
    }

    operator VkOffset2D &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkOffset2D *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<int32_t const &, int32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( x, y );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( Offset2D const & ) const = default;
#else
    bool operator==( Offset2D const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( x == rhs.x ) && ( y == rhs.y );
#  endif
    }

    bool operator!=( Offset2D const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    int32_t x = {};
    int32_t y = {};
  };

  struct Rect2D
  {
    using NativeType = VkRect2D;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR Rect2D( VULKAN_HPP_NAMESPACE::Offset2D offset_ = {}, VULKAN_HPP_NAMESPACE::Extent2D extent_ = {} ) VULKAN_HPP_NOEXCEPT
      : offset{ offset_ }
      , extent{ extent_ }
    {
    }

    VULKAN_HPP_CONSTEXPR Rect2D( Rect2D const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    Rect2D( VkRect2D const & rhs ) VULKAN_HPP_NOEXCEPT : Rect2D( *reinterpret_cast<Rect2D const *>( &rhs ) ) {}

    Rect2D & operator=( Rect2D const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    Rect2D & operator=( VkRect2D const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::Rect2D const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 Rect2D & setOffset( VULKAN_HPP_NAMESPACE::Offset2D const & offset_ ) VULKAN_HPP_NOEXCEPT
    {
      offset = offset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Rect2D & setExtent( VULKAN_HPP_NAMESPACE::Extent2D const & extent_ ) VULKAN_HPP_NOEXCEPT
    {
      extent = extent_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkRect2D const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkRect2D *>( this );
    }

    operator VkRect2D &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkRect2D *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::Offset2D const &, VULKAN_HPP_NAMESPACE::Extent2D const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( offset, extent );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( Rect2D const & ) const = default;
#else
    bool operator==( Rect2D const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( offset == rhs.offset ) && ( extent == rhs.extent );
#  endif
    }

    bool operator!=( Rect2D const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::Offset2D offset = {};
    VULKAN_HPP_NAMESPACE::Extent2D extent = {};
  };

  struct BindImageMemoryDeviceGroupInfo
  {
    using NativeType = VkBindImageMemoryDeviceGroupInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBindImageMemoryDeviceGroupInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindImageMemoryDeviceGroupInfo( uint32_t                             deviceIndexCount_             = {},
                                                         const uint32_t *                     pDeviceIndices_               = {},
                                                         uint32_t                             splitInstanceBindRegionCount_ = {},
                                                         const VULKAN_HPP_NAMESPACE::Rect2D * pSplitInstanceBindRegions_    = {},
                                                         const void *                         pNext_                        = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , deviceIndexCount{ deviceIndexCount_ }
      , pDeviceIndices{ pDeviceIndices_ }
      , splitInstanceBindRegionCount{ splitInstanceBindRegionCount_ }
      , pSplitInstanceBindRegions{ pSplitInstanceBindRegions_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BindImageMemoryDeviceGroupInfo( BindImageMemoryDeviceGroupInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindImageMemoryDeviceGroupInfo( VkBindImageMemoryDeviceGroupInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindImageMemoryDeviceGroupInfo( *reinterpret_cast<BindImageMemoryDeviceGroupInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindImageMemoryDeviceGroupInfo( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint32_t> const &                     deviceIndices_,
                                    VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::Rect2D> const & splitInstanceBindRegions_ = {},
                                    const void *                                                                              pNext_ = nullptr )
      : pNext( pNext_ )
      , deviceIndexCount( static_cast<uint32_t>( deviceIndices_.size() ) )
      , pDeviceIndices( deviceIndices_.data() )
      , splitInstanceBindRegionCount( static_cast<uint32_t>( splitInstanceBindRegions_.size() ) )
      , pSplitInstanceBindRegions( splitInstanceBindRegions_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    BindImageMemoryDeviceGroupInfo & operator=( BindImageMemoryDeviceGroupInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BindImageMemoryDeviceGroupInfo & operator=( VkBindImageMemoryDeviceGroupInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BindImageMemoryDeviceGroupInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindImageMemoryDeviceGroupInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindImageMemoryDeviceGroupInfo & setDeviceIndexCount( uint32_t deviceIndexCount_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceIndexCount = deviceIndexCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindImageMemoryDeviceGroupInfo & setPDeviceIndices( const uint32_t * pDeviceIndices_ ) VULKAN_HPP_NOEXCEPT
    {
      pDeviceIndices = pDeviceIndices_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindImageMemoryDeviceGroupInfo &
      setDeviceIndices( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint32_t> const & deviceIndices_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceIndexCount = static_cast<uint32_t>( deviceIndices_.size() );
      pDeviceIndices   = deviceIndices_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 BindImageMemoryDeviceGroupInfo & setSplitInstanceBindRegionCount( uint32_t splitInstanceBindRegionCount_ ) VULKAN_HPP_NOEXCEPT
    {
      splitInstanceBindRegionCount = splitInstanceBindRegionCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindImageMemoryDeviceGroupInfo &
      setPSplitInstanceBindRegions( const VULKAN_HPP_NAMESPACE::Rect2D * pSplitInstanceBindRegions_ ) VULKAN_HPP_NOEXCEPT
    {
      pSplitInstanceBindRegions = pSplitInstanceBindRegions_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindImageMemoryDeviceGroupInfo & setSplitInstanceBindRegions(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::Rect2D> const & splitInstanceBindRegions_ ) VULKAN_HPP_NOEXCEPT
    {
      splitInstanceBindRegionCount = static_cast<uint32_t>( splitInstanceBindRegions_.size() );
      pSplitInstanceBindRegions    = splitInstanceBindRegions_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBindImageMemoryDeviceGroupInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindImageMemoryDeviceGroupInfo *>( this );
    }

    operator VkBindImageMemoryDeviceGroupInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindImageMemoryDeviceGroupInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               uint32_t const &,
               const uint32_t * const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::Rect2D * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, deviceIndexCount, pDeviceIndices, splitInstanceBindRegionCount, pSplitInstanceBindRegions );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindImageMemoryDeviceGroupInfo const & ) const = default;
#else
    bool operator==( BindImageMemoryDeviceGroupInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( deviceIndexCount == rhs.deviceIndexCount ) && ( pDeviceIndices == rhs.pDeviceIndices ) &&
             ( splitInstanceBindRegionCount == rhs.splitInstanceBindRegionCount ) && ( pSplitInstanceBindRegions == rhs.pSplitInstanceBindRegions );
#  endif
    }

    bool operator!=( BindImageMemoryDeviceGroupInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType  sType                        = StructureType::eBindImageMemoryDeviceGroupInfo;
    const void *                         pNext                        = {};
    uint32_t                             deviceIndexCount             = {};
    const uint32_t *                     pDeviceIndices               = {};
    uint32_t                             splitInstanceBindRegionCount = {};
    const VULKAN_HPP_NAMESPACE::Rect2D * pSplitInstanceBindRegions    = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBindImageMemoryDeviceGroupInfo>
  {
    using Type = BindImageMemoryDeviceGroupInfo;
  };

  using BindImageMemoryDeviceGroupInfoKHR = BindImageMemoryDeviceGroupInfo;

  struct BindImageMemoryInfo
  {
    using NativeType = VkBindImageMemoryInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBindImageMemoryInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindImageMemoryInfo( VULKAN_HPP_NAMESPACE::Image        image_        = {},
                                              VULKAN_HPP_NAMESPACE::DeviceMemory memory_       = {},
                                              VULKAN_HPP_NAMESPACE::DeviceSize   memoryOffset_ = {},
                                              const void *                       pNext_        = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , image{ image_ }
      , memory{ memory_ }
      , memoryOffset{ memoryOffset_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BindImageMemoryInfo( BindImageMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindImageMemoryInfo( VkBindImageMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT : BindImageMemoryInfo( *reinterpret_cast<BindImageMemoryInfo const *>( &rhs ) )
    {
    }

    BindImageMemoryInfo & operator=( BindImageMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BindImageMemoryInfo & operator=( VkBindImageMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BindImageMemoryInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindImageMemoryInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindImageMemoryInfo & setImage( VULKAN_HPP_NAMESPACE::Image image_ ) VULKAN_HPP_NOEXCEPT
    {
      image = image_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindImageMemoryInfo & setMemory( VULKAN_HPP_NAMESPACE::DeviceMemory memory_ ) VULKAN_HPP_NOEXCEPT
    {
      memory = memory_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindImageMemoryInfo & setMemoryOffset( VULKAN_HPP_NAMESPACE::DeviceSize memoryOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      memoryOffset = memoryOffset_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBindImageMemoryInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindImageMemoryInfo *>( this );
    }

    operator VkBindImageMemoryInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindImageMemoryInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::Image const &,
               VULKAN_HPP_NAMESPACE::DeviceMemory const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, image, memory, memoryOffset );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindImageMemoryInfo const & ) const = default;
#else
    bool operator==( BindImageMemoryInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( image == rhs.image ) && ( memory == rhs.memory ) && ( memoryOffset == rhs.memoryOffset );
#  endif
    }

    bool operator!=( BindImageMemoryInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType        = StructureType::eBindImageMemoryInfo;
    const void *                        pNext        = {};
    VULKAN_HPP_NAMESPACE::Image         image        = {};
    VULKAN_HPP_NAMESPACE::DeviceMemory  memory       = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    memoryOffset = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBindImageMemoryInfo>
  {
    using Type = BindImageMemoryInfo;
  };

  using BindImageMemoryInfoKHR = BindImageMemoryInfo;

  struct BindImageMemorySwapchainInfoKHR
  {
    using NativeType = VkBindImageMemorySwapchainInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBindImageMemorySwapchainInfoKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindImageMemorySwapchainInfoKHR( VULKAN_HPP_NAMESPACE::SwapchainKHR swapchain_  = {},
                                                          uint32_t                           imageIndex_ = {},
                                                          const void *                       pNext_      = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , swapchain{ swapchain_ }
      , imageIndex{ imageIndex_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BindImageMemorySwapchainInfoKHR( BindImageMemorySwapchainInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindImageMemorySwapchainInfoKHR( VkBindImageMemorySwapchainInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindImageMemorySwapchainInfoKHR( *reinterpret_cast<BindImageMemorySwapchainInfoKHR const *>( &rhs ) )
    {
    }

    BindImageMemorySwapchainInfoKHR & operator=( BindImageMemorySwapchainInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BindImageMemorySwapchainInfoKHR & operator=( VkBindImageMemorySwapchainInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BindImageMemorySwapchainInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindImageMemorySwapchainInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindImageMemorySwapchainInfoKHR & setSwapchain( VULKAN_HPP_NAMESPACE::SwapchainKHR swapchain_ ) VULKAN_HPP_NOEXCEPT
    {
      swapchain = swapchain_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindImageMemorySwapchainInfoKHR & setImageIndex( uint32_t imageIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      imageIndex = imageIndex_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBindImageMemorySwapchainInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindImageMemorySwapchainInfoKHR *>( this );
    }

    operator VkBindImageMemorySwapchainInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindImageMemorySwapchainInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::SwapchainKHR const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, swapchain, imageIndex );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindImageMemorySwapchainInfoKHR const & ) const = default;
#else
    bool operator==( BindImageMemorySwapchainInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( swapchain == rhs.swapchain ) && ( imageIndex == rhs.imageIndex );
#  endif
    }

    bool operator!=( BindImageMemorySwapchainInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType      = StructureType::eBindImageMemorySwapchainInfoKHR;
    const void *                        pNext      = {};
    VULKAN_HPP_NAMESPACE::SwapchainKHR  swapchain  = {};
    uint32_t                            imageIndex = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBindImageMemorySwapchainInfoKHR>
  {
    using Type = BindImageMemorySwapchainInfoKHR;
  };

  struct BindImagePlaneMemoryInfo
  {
    using NativeType = VkBindImagePlaneMemoryInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBindImagePlaneMemoryInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindImagePlaneMemoryInfo( VULKAN_HPP_NAMESPACE::ImageAspectFlagBits planeAspect_ = VULKAN_HPP_NAMESPACE::ImageAspectFlagBits::eColor,
                                                   const void *                              pNext_       = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , planeAspect{ planeAspect_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BindImagePlaneMemoryInfo( BindImagePlaneMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindImagePlaneMemoryInfo( VkBindImagePlaneMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindImagePlaneMemoryInfo( *reinterpret_cast<BindImagePlaneMemoryInfo const *>( &rhs ) )
    {
    }

    BindImagePlaneMemoryInfo & operator=( BindImagePlaneMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BindImagePlaneMemoryInfo & operator=( VkBindImagePlaneMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BindImagePlaneMemoryInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindImagePlaneMemoryInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindImagePlaneMemoryInfo & setPlaneAspect( VULKAN_HPP_NAMESPACE::ImageAspectFlagBits planeAspect_ ) VULKAN_HPP_NOEXCEPT
    {
      planeAspect = planeAspect_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBindImagePlaneMemoryInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindImagePlaneMemoryInfo *>( this );
    }

    operator VkBindImagePlaneMemoryInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindImagePlaneMemoryInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::ImageAspectFlagBits const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, planeAspect );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindImagePlaneMemoryInfo const & ) const = default;
#else
    bool operator==( BindImagePlaneMemoryInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( planeAspect == rhs.planeAspect );
#  endif
    }

    bool operator!=( BindImagePlaneMemoryInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType       sType       = StructureType::eBindImagePlaneMemoryInfo;
    const void *                              pNext       = {};
    VULKAN_HPP_NAMESPACE::ImageAspectFlagBits planeAspect = VULKAN_HPP_NAMESPACE::ImageAspectFlagBits::eColor;
  };

  template <>
  struct CppType<StructureType, StructureType::eBindImagePlaneMemoryInfo>
  {
    using Type = BindImagePlaneMemoryInfo;
  };

  using BindImagePlaneMemoryInfoKHR = BindImagePlaneMemoryInfo;

  struct ImageSubresourceLayers
  {
    using NativeType = VkImageSubresourceLayers;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ImageSubresourceLayers( VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask_     = {},
                                                 uint32_t                               mipLevel_       = {},
                                                 uint32_t                               baseArrayLayer_ = {},
                                                 uint32_t                               layerCount_     = {} ) VULKAN_HPP_NOEXCEPT
      : aspectMask{ aspectMask_ }
      , mipLevel{ mipLevel_ }
      , baseArrayLayer{ baseArrayLayer_ }
      , layerCount{ layerCount_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ImageSubresourceLayers( ImageSubresourceLayers const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageSubresourceLayers( VkImageSubresourceLayers const & rhs ) VULKAN_HPP_NOEXCEPT
      : ImageSubresourceLayers( *reinterpret_cast<ImageSubresourceLayers const *>( &rhs ) )
    {
    }

    ImageSubresourceLayers & operator=( ImageSubresourceLayers const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ImageSubresourceLayers & operator=( VkImageSubresourceLayers const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ImageSubresourceLayers & setAspectMask( VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask_ ) VULKAN_HPP_NOEXCEPT
    {
      aspectMask = aspectMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageSubresourceLayers & setMipLevel( uint32_t mipLevel_ ) VULKAN_HPP_NOEXCEPT
    {
      mipLevel = mipLevel_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageSubresourceLayers & setBaseArrayLayer( uint32_t baseArrayLayer_ ) VULKAN_HPP_NOEXCEPT
    {
      baseArrayLayer = baseArrayLayer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageSubresourceLayers & setLayerCount( uint32_t layerCount_ ) VULKAN_HPP_NOEXCEPT
    {
      layerCount = layerCount_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkImageSubresourceLayers const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkImageSubresourceLayers *>( this );
    }

    operator VkImageSubresourceLayers &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkImageSubresourceLayers *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::ImageAspectFlags const &, uint32_t const &, uint32_t const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( aspectMask, mipLevel, baseArrayLayer, layerCount );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ImageSubresourceLayers const & ) const = default;
#else
    bool operator==( ImageSubresourceLayers const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( aspectMask == rhs.aspectMask ) && ( mipLevel == rhs.mipLevel ) && ( baseArrayLayer == rhs.baseArrayLayer ) && ( layerCount == rhs.layerCount );
#  endif
    }

    bool operator!=( ImageSubresourceLayers const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask     = {};
    uint32_t                               mipLevel       = {};
    uint32_t                               baseArrayLayer = {};
    uint32_t                               layerCount     = {};
  };

  struct Offset3D
  {
    using NativeType = VkOffset3D;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR Offset3D( int32_t x_ = {}, int32_t y_ = {}, int32_t z_ = {} ) VULKAN_HPP_NOEXCEPT
      : x{ x_ }
      , y{ y_ }
      , z{ z_ }
    {
    }

    VULKAN_HPP_CONSTEXPR Offset3D( Offset3D const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    Offset3D( VkOffset3D const & rhs ) VULKAN_HPP_NOEXCEPT : Offset3D( *reinterpret_cast<Offset3D const *>( &rhs ) ) {}

    explicit Offset3D( Offset2D const & offset2D, int32_t z_ = {} ) : x( offset2D.x ), y( offset2D.y ), z( z_ ) {}

    Offset3D & operator=( Offset3D const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    Offset3D & operator=( VkOffset3D const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::Offset3D const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 Offset3D & setX( int32_t x_ ) VULKAN_HPP_NOEXCEPT
    {
      x = x_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Offset3D & setY( int32_t y_ ) VULKAN_HPP_NOEXCEPT
    {
      y = y_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Offset3D & setZ( int32_t z_ ) VULKAN_HPP_NOEXCEPT
    {
      z = z_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkOffset3D const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkOffset3D *>( this );
    }

    operator VkOffset3D &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkOffset3D *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<int32_t const &, int32_t const &, int32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( x, y, z );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( Offset3D const & ) const = default;
#else
    bool operator==( Offset3D const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( x == rhs.x ) && ( y == rhs.y ) && ( z == rhs.z );
#  endif
    }

    bool operator!=( Offset3D const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    int32_t x = {};
    int32_t y = {};
    int32_t z = {};
  };

  struct ImageBlit2
  {
    using NativeType = VkImageBlit2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eImageBlit2;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 ImageBlit2( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers          srcSubresource_ = {},
                                        std::array<VULKAN_HPP_NAMESPACE::Offset3D, 2> const & srcOffsets_     = {},
                                        VULKAN_HPP_NAMESPACE::ImageSubresourceLayers          dstSubresource_ = {},
                                        std::array<VULKAN_HPP_NAMESPACE::Offset3D, 2> const & dstOffsets_     = {},
                                        const void *                                          pNext_          = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , srcSubresource{ srcSubresource_ }
      , srcOffsets{ srcOffsets_ }
      , dstSubresource{ dstSubresource_ }
      , dstOffsets{ dstOffsets_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14 ImageBlit2( ImageBlit2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageBlit2( VkImageBlit2 const & rhs ) VULKAN_HPP_NOEXCEPT : ImageBlit2( *reinterpret_cast<ImageBlit2 const *>( &rhs ) ) {}

    ImageBlit2 & operator=( ImageBlit2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ImageBlit2 & operator=( VkImageBlit2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ImageBlit2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ImageBlit2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageBlit2 & setSrcSubresource( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const & srcSubresource_ ) VULKAN_HPP_NOEXCEPT
    {
      srcSubresource = srcSubresource_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageBlit2 & setSrcOffsets( std::array<VULKAN_HPP_NAMESPACE::Offset3D, 2> const & srcOffsets_ ) VULKAN_HPP_NOEXCEPT
    {
      srcOffsets = srcOffsets_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageBlit2 & setDstSubresource( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const & dstSubresource_ ) VULKAN_HPP_NOEXCEPT
    {
      dstSubresource = dstSubresource_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageBlit2 & setDstOffsets( std::array<VULKAN_HPP_NAMESPACE::Offset3D, 2> const & dstOffsets_ ) VULKAN_HPP_NOEXCEPT
    {
      dstOffsets = dstOffsets_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkImageBlit2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkImageBlit2 *>( this );
    }

    operator VkImageBlit2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkImageBlit2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const &,
               VULKAN_HPP_NAMESPACE::ArrayWrapper1D<VULKAN_HPP_NAMESPACE::Offset3D, 2> const &,
               VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const &,
               VULKAN_HPP_NAMESPACE::ArrayWrapper1D<VULKAN_HPP_NAMESPACE::Offset3D, 2> const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, srcSubresource, srcOffsets, dstSubresource, dstOffsets );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ImageBlit2 const & ) const = default;
#else
    bool operator==( ImageBlit2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcSubresource == rhs.srcSubresource ) && ( srcOffsets == rhs.srcOffsets ) &&
             ( dstSubresource == rhs.dstSubresource ) && ( dstOffsets == rhs.dstOffsets );
#  endif
    }

    bool operator!=( ImageBlit2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                                     sType          = StructureType::eImageBlit2;
    const void *                                                            pNext          = {};
    VULKAN_HPP_NAMESPACE::ImageSubresourceLayers                            srcSubresource = {};
    VULKAN_HPP_NAMESPACE::ArrayWrapper1D<VULKAN_HPP_NAMESPACE::Offset3D, 2> srcOffsets     = {};
    VULKAN_HPP_NAMESPACE::ImageSubresourceLayers                            dstSubresource = {};
    VULKAN_HPP_NAMESPACE::ArrayWrapper1D<VULKAN_HPP_NAMESPACE::Offset3D, 2> dstOffsets     = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eImageBlit2>
  {
    using Type = ImageBlit2;
  };

  using ImageBlit2KHR = ImageBlit2;

  struct BlitImageInfo2
  {
    using NativeType = VkBlitImageInfo2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBlitImageInfo2;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 BlitImageInfo2( VULKAN_HPP_NAMESPACE::Image              srcImage_       = {},
                                            VULKAN_HPP_NAMESPACE::ImageLayout        srcImageLayout_ = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                                            VULKAN_HPP_NAMESPACE::Image              dstImage_       = {},
                                            VULKAN_HPP_NAMESPACE::ImageLayout        dstImageLayout_ = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                                            uint32_t                                 regionCount_    = {},
                                            const VULKAN_HPP_NAMESPACE::ImageBlit2 * pRegions_       = {},
                                            VULKAN_HPP_NAMESPACE::Filter             filter_         = VULKAN_HPP_NAMESPACE::Filter::eNearest,
                                            const void *                             pNext_          = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , srcImage{ srcImage_ }
      , srcImageLayout{ srcImageLayout_ }
      , dstImage{ dstImage_ }
      , dstImageLayout{ dstImageLayout_ }
      , regionCount{ regionCount_ }
      , pRegions{ pRegions_ }
      , filter{ filter_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14 BlitImageInfo2( BlitImageInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BlitImageInfo2( VkBlitImageInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT : BlitImageInfo2( *reinterpret_cast<BlitImageInfo2 const *>( &rhs ) ) {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BlitImageInfo2( VULKAN_HPP_NAMESPACE::Image                                                                   srcImage_,
                    VULKAN_HPP_NAMESPACE::ImageLayout                                                             srcImageLayout_,
                    VULKAN_HPP_NAMESPACE::Image                                                                   dstImage_,
                    VULKAN_HPP_NAMESPACE::ImageLayout                                                             dstImageLayout_,
                    VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::ImageBlit2> const & regions_,
                    VULKAN_HPP_NAMESPACE::Filter filter_ = VULKAN_HPP_NAMESPACE::Filter::eNearest,
                    const void *                 pNext_  = nullptr )
      : pNext( pNext_ )
      , srcImage( srcImage_ )
      , srcImageLayout( srcImageLayout_ )
      , dstImage( dstImage_ )
      , dstImageLayout( dstImageLayout_ )
      , regionCount( static_cast<uint32_t>( regions_.size() ) )
      , pRegions( regions_.data() )
      , filter( filter_ )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    BlitImageInfo2 & operator=( BlitImageInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BlitImageInfo2 & operator=( VkBlitImageInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BlitImageInfo2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BlitImageInfo2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BlitImageInfo2 & setSrcImage( VULKAN_HPP_NAMESPACE::Image srcImage_ ) VULKAN_HPP_NOEXCEPT
    {
      srcImage = srcImage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BlitImageInfo2 & setSrcImageLayout( VULKAN_HPP_NAMESPACE::ImageLayout srcImageLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      srcImageLayout = srcImageLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BlitImageInfo2 & setDstImage( VULKAN_HPP_NAMESPACE::Image dstImage_ ) VULKAN_HPP_NOEXCEPT
    {
      dstImage = dstImage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BlitImageInfo2 & setDstImageLayout( VULKAN_HPP_NAMESPACE::ImageLayout dstImageLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      dstImageLayout = dstImageLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BlitImageInfo2 & setRegionCount( uint32_t regionCount_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = regionCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BlitImageInfo2 & setPRegions( const VULKAN_HPP_NAMESPACE::ImageBlit2 * pRegions_ ) VULKAN_HPP_NOEXCEPT
    {
      pRegions = pRegions_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BlitImageInfo2 & setRegions( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::ImageBlit2> const & regions_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = static_cast<uint32_t>( regions_.size() );
      pRegions    = regions_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 BlitImageInfo2 & setFilter( VULKAN_HPP_NAMESPACE::Filter filter_ ) VULKAN_HPP_NOEXCEPT
    {
      filter = filter_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBlitImageInfo2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBlitImageInfo2 *>( this );
    }

    operator VkBlitImageInfo2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBlitImageInfo2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::Image const &,
               VULKAN_HPP_NAMESPACE::ImageLayout const &,
               VULKAN_HPP_NAMESPACE::Image const &,
               VULKAN_HPP_NAMESPACE::ImageLayout const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::ImageBlit2 * const &,
               VULKAN_HPP_NAMESPACE::Filter const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions, filter );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BlitImageInfo2 const & ) const = default;
#else
    bool operator==( BlitImageInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcImage == rhs.srcImage ) && ( srcImageLayout == rhs.srcImageLayout ) &&
             ( dstImage == rhs.dstImage ) && ( dstImageLayout == rhs.dstImageLayout ) && ( regionCount == rhs.regionCount ) && ( pRegions == rhs.pRegions ) &&
             ( filter == rhs.filter );
#  endif
    }

    bool operator!=( BlitImageInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType      sType          = StructureType::eBlitImageInfo2;
    const void *                             pNext          = {};
    VULKAN_HPP_NAMESPACE::Image              srcImage       = {};
    VULKAN_HPP_NAMESPACE::ImageLayout        srcImageLayout = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    VULKAN_HPP_NAMESPACE::Image              dstImage       = {};
    VULKAN_HPP_NAMESPACE::ImageLayout        dstImageLayout = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    uint32_t                                 regionCount    = {};
    const VULKAN_HPP_NAMESPACE::ImageBlit2 * pRegions       = {};
    VULKAN_HPP_NAMESPACE::Filter             filter         = VULKAN_HPP_NAMESPACE::Filter::eNearest;
  };

  template <>
  struct CppType<StructureType, StructureType::eBlitImageInfo2>
  {
    using Type = BlitImageInfo2;
  };

  using BlitImageInfo2KHR = BlitImageInfo2;

  struct BufferCopy
  {
    using NativeType = VkBufferCopy;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferCopy( VULKAN_HPP_NAMESPACE::DeviceSize srcOffset_ = {},
                                     VULKAN_HPP_NAMESPACE::DeviceSize dstOffset_ = {},
                                     VULKAN_HPP_NAMESPACE::DeviceSize size_      = {} ) VULKAN_HPP_NOEXCEPT
      : srcOffset{ srcOffset_ }
      , dstOffset{ dstOffset_ }
      , size{ size_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferCopy( BufferCopy const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferCopy( VkBufferCopy const & rhs ) VULKAN_HPP_NOEXCEPT : BufferCopy( *reinterpret_cast<BufferCopy const *>( &rhs ) ) {}

    BufferCopy & operator=( BufferCopy const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BufferCopy & operator=( VkBufferCopy const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferCopy const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferCopy & setSrcOffset( VULKAN_HPP_NAMESPACE::DeviceSize srcOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      srcOffset = srcOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCopy & setDstOffset( VULKAN_HPP_NAMESPACE::DeviceSize dstOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      dstOffset = dstOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCopy & setSize( VULKAN_HPP_NAMESPACE::DeviceSize size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBufferCopy const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferCopy *>( this );
    }

    operator VkBufferCopy &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferCopy *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::DeviceSize const &, VULKAN_HPP_NAMESPACE::DeviceSize const &, VULKAN_HPP_NAMESPACE::DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( srcOffset, dstOffset, size );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferCopy const & ) const = default;
#else
    bool operator==( BufferCopy const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( srcOffset == rhs.srcOffset ) && ( dstOffset == rhs.dstOffset ) && ( size == rhs.size );
#  endif
    }

    bool operator!=( BufferCopy const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::DeviceSize srcOffset = {};
    VULKAN_HPP_NAMESPACE::DeviceSize dstOffset = {};
    VULKAN_HPP_NAMESPACE::DeviceSize size      = {};
  };

  struct BufferCopy2
  {
    using NativeType = VkBufferCopy2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferCopy2;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferCopy2( VULKAN_HPP_NAMESPACE::DeviceSize srcOffset_ = {},
                                      VULKAN_HPP_NAMESPACE::DeviceSize dstOffset_ = {},
                                      VULKAN_HPP_NAMESPACE::DeviceSize size_      = {},
                                      const void *                     pNext_     = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , srcOffset{ srcOffset_ }
      , dstOffset{ dstOffset_ }
      , size{ size_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferCopy2( BufferCopy2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferCopy2( VkBufferCopy2 const & rhs ) VULKAN_HPP_NOEXCEPT : BufferCopy2( *reinterpret_cast<BufferCopy2 const *>( &rhs ) ) {}

    BufferCopy2 & operator=( BufferCopy2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BufferCopy2 & operator=( VkBufferCopy2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferCopy2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferCopy2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCopy2 & setSrcOffset( VULKAN_HPP_NAMESPACE::DeviceSize srcOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      srcOffset = srcOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCopy2 & setDstOffset( VULKAN_HPP_NAMESPACE::DeviceSize dstOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      dstOffset = dstOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCopy2 & setSize( VULKAN_HPP_NAMESPACE::DeviceSize size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBufferCopy2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferCopy2 *>( this );
    }

    operator VkBufferCopy2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferCopy2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, srcOffset, dstOffset, size );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferCopy2 const & ) const = default;
#else
    bool operator==( BufferCopy2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcOffset == rhs.srcOffset ) && ( dstOffset == rhs.dstOffset ) && ( size == rhs.size );
#  endif
    }

    bool operator!=( BufferCopy2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType     = StructureType::eBufferCopy2;
    const void *                        pNext     = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    srcOffset = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    dstOffset = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    size      = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBufferCopy2>
  {
    using Type = BufferCopy2;
  };

  using BufferCopy2KHR = BufferCopy2;

  struct BufferCreateInfo
  {
    using NativeType = VkBufferCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferCreateInfo( VULKAN_HPP_NAMESPACE::BufferCreateFlags flags_                 = {},
                                           VULKAN_HPP_NAMESPACE::DeviceSize        size_                  = {},
                                           VULKAN_HPP_NAMESPACE::BufferUsageFlags  usage_                 = {},
                                           VULKAN_HPP_NAMESPACE::SharingMode       sharingMode_           = VULKAN_HPP_NAMESPACE::SharingMode::eExclusive,
                                           uint32_t                                queueFamilyIndexCount_ = {},
                                           const uint32_t *                        pQueueFamilyIndices_   = {},
                                           const void *                            pNext_                 = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , size{ size_ }
      , usage{ usage_ }
      , sharingMode{ sharingMode_ }
      , queueFamilyIndexCount{ queueFamilyIndexCount_ }
      , pQueueFamilyIndices{ pQueueFamilyIndices_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferCreateInfo( BufferCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferCreateInfo( VkBufferCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT : BufferCreateInfo( *reinterpret_cast<BufferCreateInfo const *>( &rhs ) ) {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BufferCreateInfo( VULKAN_HPP_NAMESPACE::BufferCreateFlags                               flags_,
                      VULKAN_HPP_NAMESPACE::DeviceSize                                      size_,
                      VULKAN_HPP_NAMESPACE::BufferUsageFlags                                usage_,
                      VULKAN_HPP_NAMESPACE::SharingMode                                     sharingMode_,
                      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint32_t> const & queueFamilyIndices_,
                      const void *                                                          pNext_ = nullptr )
      : pNext( pNext_ )
      , flags( flags_ )
      , size( size_ )
      , usage( usage_ )
      , sharingMode( sharingMode_ )
      , queueFamilyIndexCount( static_cast<uint32_t>( queueFamilyIndices_.size() ) )
      , pQueueFamilyIndices( queueFamilyIndices_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    BufferCreateInfo & operator=( BufferCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BufferCreateInfo & operator=( VkBufferCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCreateInfo & setFlags( VULKAN_HPP_NAMESPACE::BufferCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCreateInfo & setSize( VULKAN_HPP_NAMESPACE::DeviceSize size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCreateInfo & setUsage( VULKAN_HPP_NAMESPACE::BufferUsageFlags usage_ ) VULKAN_HPP_NOEXCEPT
    {
      usage = usage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCreateInfo & setSharingMode( VULKAN_HPP_NAMESPACE::SharingMode sharingMode_ ) VULKAN_HPP_NOEXCEPT
    {
      sharingMode = sharingMode_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCreateInfo & setQueueFamilyIndexCount( uint32_t queueFamilyIndexCount_ ) VULKAN_HPP_NOEXCEPT
    {
      queueFamilyIndexCount = queueFamilyIndexCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCreateInfo & setPQueueFamilyIndices( const uint32_t * pQueueFamilyIndices_ ) VULKAN_HPP_NOEXCEPT
    {
      pQueueFamilyIndices = pQueueFamilyIndices_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BufferCreateInfo & setQueueFamilyIndices( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint32_t> const & queueFamilyIndices_ ) VULKAN_HPP_NOEXCEPT
    {
      queueFamilyIndexCount = static_cast<uint32_t>( queueFamilyIndices_.size() );
      pQueueFamilyIndices   = queueFamilyIndices_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBufferCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferCreateInfo *>( this );
    }

    operator VkBufferCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::BufferCreateFlags const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::BufferUsageFlags const &,
               VULKAN_HPP_NAMESPACE::SharingMode const &,
               uint32_t const &,
               const uint32_t * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, size, usage, sharingMode, queueFamilyIndexCount, pQueueFamilyIndices );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferCreateInfo const & ) const = default;
#else
    bool operator==( BufferCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( size == rhs.size ) && ( usage == rhs.usage ) &&
             ( sharingMode == rhs.sharingMode ) && ( queueFamilyIndexCount == rhs.queueFamilyIndexCount ) && ( pQueueFamilyIndices == rhs.pQueueFamilyIndices );
#  endif
    }

    bool operator!=( BufferCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType     sType                 = StructureType::eBufferCreateInfo;
    const void *                            pNext                 = {};
    VULKAN_HPP_NAMESPACE::BufferCreateFlags flags                 = {};
    VULKAN_HPP_NAMESPACE::DeviceSize        size                  = {};
    VULKAN_HPP_NAMESPACE::BufferUsageFlags  usage                 = {};
    VULKAN_HPP_NAMESPACE::SharingMode       sharingMode           = VULKAN_HPP_NAMESPACE::SharingMode::eExclusive;
    uint32_t                                queueFamilyIndexCount = {};
    const uint32_t *                        pQueueFamilyIndices   = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBufferCreateInfo>
  {
    using Type = BufferCreateInfo;
  };

  struct BufferDeviceAddressInfo
  {
    using NativeType = VkBufferDeviceAddressInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferDeviceAddressInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferDeviceAddressInfo( VULKAN_HPP_NAMESPACE::Buffer buffer_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , buffer{ buffer_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferDeviceAddressInfo( BufferDeviceAddressInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferDeviceAddressInfo( VkBufferDeviceAddressInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferDeviceAddressInfo( *reinterpret_cast<BufferDeviceAddressInfo const *>( &rhs ) )
    {
    }

    BufferDeviceAddressInfo & operator=( BufferDeviceAddressInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BufferDeviceAddressInfo & operator=( VkBufferDeviceAddressInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferDeviceAddressInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferDeviceAddressInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferDeviceAddressInfo & setBuffer( VULKAN_HPP_NAMESPACE::Buffer buffer_ ) VULKAN_HPP_NOEXCEPT
    {
      buffer = buffer_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBufferDeviceAddressInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferDeviceAddressInfo *>( this );
    }

    operator VkBufferDeviceAddressInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferDeviceAddressInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::Buffer const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, buffer );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferDeviceAddressInfo const & ) const = default;
#else
    bool operator==( BufferDeviceAddressInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( buffer == rhs.buffer );
#  endif
    }

    bool operator!=( BufferDeviceAddressInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType  = StructureType::eBufferDeviceAddressInfo;
    const void *                        pNext  = {};
    VULKAN_HPP_NAMESPACE::Buffer        buffer = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBufferDeviceAddressInfo>
  {
    using Type = BufferDeviceAddressInfo;
  };

  using BufferDeviceAddressInfoEXT = BufferDeviceAddressInfo;
  using BufferDeviceAddressInfoKHR = BufferDeviceAddressInfo;

  struct Extent3D
  {
    using NativeType = VkExtent3D;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR Extent3D( uint32_t width_ = {}, uint32_t height_ = {}, uint32_t depth_ = {} ) VULKAN_HPP_NOEXCEPT
      : width{ width_ }
      , height{ height_ }
      , depth{ depth_ }
    {
    }

    VULKAN_HPP_CONSTEXPR Extent3D( Extent3D const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    Extent3D( VkExtent3D const & rhs ) VULKAN_HPP_NOEXCEPT : Extent3D( *reinterpret_cast<Extent3D const *>( &rhs ) ) {}

    explicit Extent3D( Extent2D const & extent2D, uint32_t depth_ = {} ) : width( extent2D.width ), height( extent2D.height ), depth( depth_ ) {}

    Extent3D & operator=( Extent3D const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    Extent3D & operator=( VkExtent3D const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::Extent3D const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 Extent3D & setWidth( uint32_t width_ ) VULKAN_HPP_NOEXCEPT
    {
      width = width_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Extent3D & setHeight( uint32_t height_ ) VULKAN_HPP_NOEXCEPT
    {
      height = height_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Extent3D & setDepth( uint32_t depth_ ) VULKAN_HPP_NOEXCEPT
    {
      depth = depth_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkExtent3D const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkExtent3D *>( this );
    }

    operator VkExtent3D &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkExtent3D *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &, uint32_t const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( width, height, depth );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( Extent3D const & ) const = default;
#else
    bool operator==( Extent3D const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( width == rhs.width ) && ( height == rhs.height ) && ( depth == rhs.depth );
#  endif
    }

    bool operator!=( Extent3D const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t width  = {};
    uint32_t height = {};
    uint32_t depth  = {};
  };

  struct BufferImageCopy
  {
    using NativeType = VkBufferImageCopy;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferImageCopy( VULKAN_HPP_NAMESPACE::DeviceSize             bufferOffset_      = {},
                                          uint32_t                                     bufferRowLength_   = {},
                                          uint32_t                                     bufferImageHeight_ = {},
                                          VULKAN_HPP_NAMESPACE::ImageSubresourceLayers imageSubresource_  = {},
                                          VULKAN_HPP_NAMESPACE::Offset3D               imageOffset_       = {},
                                          VULKAN_HPP_NAMESPACE::Extent3D               imageExtent_       = {} ) VULKAN_HPP_NOEXCEPT
      : bufferOffset{ bufferOffset_ }
      , bufferRowLength{ bufferRowLength_ }
      , bufferImageHeight{ bufferImageHeight_ }
      , imageSubresource{ imageSubresource_ }
      , imageOffset{ imageOffset_ }
      , imageExtent{ imageExtent_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferImageCopy( BufferImageCopy const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferImageCopy( VkBufferImageCopy const & rhs ) VULKAN_HPP_NOEXCEPT : BufferImageCopy( *reinterpret_cast<BufferImageCopy const *>( &rhs ) ) {}

    BufferImageCopy & operator=( BufferImageCopy const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BufferImageCopy & operator=( VkBufferImageCopy const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferImageCopy const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy & setBufferOffset( VULKAN_HPP_NAMESPACE::DeviceSize bufferOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferOffset = bufferOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy & setBufferRowLength( uint32_t bufferRowLength_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferRowLength = bufferRowLength_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy & setBufferImageHeight( uint32_t bufferImageHeight_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferImageHeight = bufferImageHeight_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy & setImageSubresource( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const & imageSubresource_ ) VULKAN_HPP_NOEXCEPT
    {
      imageSubresource = imageSubresource_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy & setImageOffset( VULKAN_HPP_NAMESPACE::Offset3D const & imageOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      imageOffset = imageOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy & setImageExtent( VULKAN_HPP_NAMESPACE::Extent3D const & imageExtent_ ) VULKAN_HPP_NOEXCEPT
    {
      imageExtent = imageExtent_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBufferImageCopy const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferImageCopy *>( this );
    }

    operator VkBufferImageCopy &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferImageCopy *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::DeviceSize const &,
               uint32_t const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const &,
               VULKAN_HPP_NAMESPACE::Offset3D const &,
               VULKAN_HPP_NAMESPACE::Extent3D const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( bufferOffset, bufferRowLength, bufferImageHeight, imageSubresource, imageOffset, imageExtent );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferImageCopy const & ) const = default;
#else
    bool operator==( BufferImageCopy const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( bufferOffset == rhs.bufferOffset ) && ( bufferRowLength == rhs.bufferRowLength ) && ( bufferImageHeight == rhs.bufferImageHeight ) &&
             ( imageSubresource == rhs.imageSubresource ) && ( imageOffset == rhs.imageOffset ) && ( imageExtent == rhs.imageExtent );
#  endif
    }

    bool operator!=( BufferImageCopy const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::DeviceSize             bufferOffset      = {};
    uint32_t                                     bufferRowLength   = {};
    uint32_t                                     bufferImageHeight = {};
    VULKAN_HPP_NAMESPACE::ImageSubresourceLayers imageSubresource  = {};
    VULKAN_HPP_NAMESPACE::Offset3D               imageOffset       = {};
    VULKAN_HPP_NAMESPACE::Extent3D               imageExtent       = {};
  };

  struct BufferImageCopy2
  {
    using NativeType = VkBufferImageCopy2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferImageCopy2;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferImageCopy2( VULKAN_HPP_NAMESPACE::DeviceSize             bufferOffset_      = {},
                                           uint32_t                                     bufferRowLength_   = {},
                                           uint32_t                                     bufferImageHeight_ = {},
                                           VULKAN_HPP_NAMESPACE::ImageSubresourceLayers imageSubresource_  = {},
                                           VULKAN_HPP_NAMESPACE::Offset3D               imageOffset_       = {},
                                           VULKAN_HPP_NAMESPACE::Extent3D               imageExtent_       = {},
                                           const void *                                 pNext_             = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , bufferOffset{ bufferOffset_ }
      , bufferRowLength{ bufferRowLength_ }
      , bufferImageHeight{ bufferImageHeight_ }
      , imageSubresource{ imageSubresource_ }
      , imageOffset{ imageOffset_ }
      , imageExtent{ imageExtent_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferImageCopy2( BufferImageCopy2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferImageCopy2( VkBufferImageCopy2 const & rhs ) VULKAN_HPP_NOEXCEPT : BufferImageCopy2( *reinterpret_cast<BufferImageCopy2 const *>( &rhs ) ) {}

    BufferImageCopy2 & operator=( BufferImageCopy2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BufferImageCopy2 & operator=( VkBufferImageCopy2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferImageCopy2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy2 & setBufferOffset( VULKAN_HPP_NAMESPACE::DeviceSize bufferOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferOffset = bufferOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy2 & setBufferRowLength( uint32_t bufferRowLength_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferRowLength = bufferRowLength_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy2 & setBufferImageHeight( uint32_t bufferImageHeight_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferImageHeight = bufferImageHeight_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy2 & setImageSubresource( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const & imageSubresource_ ) VULKAN_HPP_NOEXCEPT
    {
      imageSubresource = imageSubresource_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy2 & setImageOffset( VULKAN_HPP_NAMESPACE::Offset3D const & imageOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      imageOffset = imageOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy2 & setImageExtent( VULKAN_HPP_NAMESPACE::Extent3D const & imageExtent_ ) VULKAN_HPP_NOEXCEPT
    {
      imageExtent = imageExtent_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBufferImageCopy2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferImageCopy2 *>( this );
    }

    operator VkBufferImageCopy2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferImageCopy2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               uint32_t const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const &,
               VULKAN_HPP_NAMESPACE::Offset3D const &,
               VULKAN_HPP_NAMESPACE::Extent3D const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, bufferOffset, bufferRowLength, bufferImageHeight, imageSubresource, imageOffset, imageExtent );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferImageCopy2 const & ) const = default;
#else
    bool operator==( BufferImageCopy2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( bufferOffset == rhs.bufferOffset ) && ( bufferRowLength == rhs.bufferRowLength ) &&
             ( bufferImageHeight == rhs.bufferImageHeight ) && ( imageSubresource == rhs.imageSubresource ) && ( imageOffset == rhs.imageOffset ) &&
             ( imageExtent == rhs.imageExtent );
#  endif
    }

    bool operator!=( BufferImageCopy2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType          sType             = StructureType::eBufferImageCopy2;
    const void *                                 pNext             = {};
    VULKAN_HPP_NAMESPACE::DeviceSize             bufferOffset      = {};
    uint32_t                                     bufferRowLength   = {};
    uint32_t                                     bufferImageHeight = {};
    VULKAN_HPP_NAMESPACE::ImageSubresourceLayers imageSubresource  = {};
    VULKAN_HPP_NAMESPACE::Offset3D               imageOffset       = {};
    VULKAN_HPP_NAMESPACE::Extent3D               imageExtent       = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBufferImageCopy2>
  {
    using Type = BufferImageCopy2;
  };

  using BufferImageCopy2KHR = BufferImageCopy2;

  struct BufferMemoryBarrier
  {
    using NativeType = VkBufferMemoryBarrier;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferMemoryBarrier;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferMemoryBarrier( VULKAN_HPP_NAMESPACE::AccessFlags srcAccessMask_       = {},
                                              VULKAN_HPP_NAMESPACE::AccessFlags dstAccessMask_       = {},
                                              uint32_t                          srcQueueFamilyIndex_ = {},
                                              uint32_t                          dstQueueFamilyIndex_ = {},
                                              VULKAN_HPP_NAMESPACE::Buffer      buffer_              = {},
                                              VULKAN_HPP_NAMESPACE::DeviceSize  offset_              = {},
                                              VULKAN_HPP_NAMESPACE::DeviceSize  size_                = {},
                                              const void *                      pNext_               = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , srcAccessMask{ srcAccessMask_ }
      , dstAccessMask{ dstAccessMask_ }
      , srcQueueFamilyIndex{ srcQueueFamilyIndex_ }
      , dstQueueFamilyIndex{ dstQueueFamilyIndex_ }
      , buffer{ buffer_ }
      , offset{ offset_ }
      , size{ size_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferMemoryBarrier( BufferMemoryBarrier const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferMemoryBarrier( VkBufferMemoryBarrier const & rhs ) VULKAN_HPP_NOEXCEPT : BufferMemoryBarrier( *reinterpret_cast<BufferMemoryBarrier const *>( &rhs ) )
    {
    }

    BufferMemoryBarrier & operator=( BufferMemoryBarrier const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BufferMemoryBarrier & operator=( VkBufferMemoryBarrier const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferMemoryBarrier const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier & setSrcAccessMask( VULKAN_HPP_NAMESPACE::AccessFlags srcAccessMask_ ) VULKAN_HPP_NOEXCEPT
    {
      srcAccessMask = srcAccessMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier & setDstAccessMask( VULKAN_HPP_NAMESPACE::AccessFlags dstAccessMask_ ) VULKAN_HPP_NOEXCEPT
    {
      dstAccessMask = dstAccessMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier & setSrcQueueFamilyIndex( uint32_t srcQueueFamilyIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      srcQueueFamilyIndex = srcQueueFamilyIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier & setDstQueueFamilyIndex( uint32_t dstQueueFamilyIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      dstQueueFamilyIndex = dstQueueFamilyIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier & setBuffer( VULKAN_HPP_NAMESPACE::Buffer buffer_ ) VULKAN_HPP_NOEXCEPT
    {
      buffer = buffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier & setOffset( VULKAN_HPP_NAMESPACE::DeviceSize offset_ ) VULKAN_HPP_NOEXCEPT
    {
      offset = offset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier & setSize( VULKAN_HPP_NAMESPACE::DeviceSize size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBufferMemoryBarrier const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferMemoryBarrier *>( this );
    }

    operator VkBufferMemoryBarrier &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferMemoryBarrier *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::AccessFlags const &,
               VULKAN_HPP_NAMESPACE::AccessFlags const &,
               uint32_t const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::Buffer const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, srcAccessMask, dstAccessMask, srcQueueFamilyIndex, dstQueueFamilyIndex, buffer, offset, size );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferMemoryBarrier const & ) const = default;
#else
    bool operator==( BufferMemoryBarrier const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcAccessMask == rhs.srcAccessMask ) && ( dstAccessMask == rhs.dstAccessMask ) &&
             ( srcQueueFamilyIndex == rhs.srcQueueFamilyIndex ) && ( dstQueueFamilyIndex == rhs.dstQueueFamilyIndex ) && ( buffer == rhs.buffer ) &&
             ( offset == rhs.offset ) && ( size == rhs.size );
#  endif
    }

    bool operator!=( BufferMemoryBarrier const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType               = StructureType::eBufferMemoryBarrier;
    const void *                        pNext               = {};
    VULKAN_HPP_NAMESPACE::AccessFlags   srcAccessMask       = {};
    VULKAN_HPP_NAMESPACE::AccessFlags   dstAccessMask       = {};
    uint32_t                            srcQueueFamilyIndex = {};
    uint32_t                            dstQueueFamilyIndex = {};
    VULKAN_HPP_NAMESPACE::Buffer        buffer              = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    offset              = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    size                = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBufferMemoryBarrier>
  {
    using Type = BufferMemoryBarrier;
  };

  struct BufferMemoryBarrier2
  {
    using NativeType = VkBufferMemoryBarrier2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferMemoryBarrier2;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferMemoryBarrier2( VULKAN_HPP_NAMESPACE::PipelineStageFlags2 srcStageMask_        = {},
                                               VULKAN_HPP_NAMESPACE::AccessFlags2        srcAccessMask_       = {},
                                               VULKAN_HPP_NAMESPACE::PipelineStageFlags2 dstStageMask_        = {},
                                               VULKAN_HPP_NAMESPACE::AccessFlags2        dstAccessMask_       = {},
                                               uint32_t                                  srcQueueFamilyIndex_ = {},
                                               uint32_t                                  dstQueueFamilyIndex_ = {},
                                               VULKAN_HPP_NAMESPACE::Buffer              buffer_              = {},
                                               VULKAN_HPP_NAMESPACE::DeviceSize          offset_              = {},
                                               VULKAN_HPP_NAMESPACE::DeviceSize          size_                = {},
                                               const void *                              pNext_               = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , srcStageMask{ srcStageMask_ }
      , srcAccessMask{ srcAccessMask_ }
      , dstStageMask{ dstStageMask_ }
      , dstAccessMask{ dstAccessMask_ }
      , srcQueueFamilyIndex{ srcQueueFamilyIndex_ }
      , dstQueueFamilyIndex{ dstQueueFamilyIndex_ }
      , buffer{ buffer_ }
      , offset{ offset_ }
      , size{ size_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferMemoryBarrier2( BufferMemoryBarrier2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferMemoryBarrier2( VkBufferMemoryBarrier2 const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferMemoryBarrier2( *reinterpret_cast<BufferMemoryBarrier2 const *>( &rhs ) )
    {
    }

    BufferMemoryBarrier2 & operator=( BufferMemoryBarrier2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BufferMemoryBarrier2 & operator=( VkBufferMemoryBarrier2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferMemoryBarrier2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier2 & setSrcStageMask( VULKAN_HPP_NAMESPACE::PipelineStageFlags2 srcStageMask_ ) VULKAN_HPP_NOEXCEPT
    {
      srcStageMask = srcStageMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier2 & setSrcAccessMask( VULKAN_HPP_NAMESPACE::AccessFlags2 srcAccessMask_ ) VULKAN_HPP_NOEXCEPT
    {
      srcAccessMask = srcAccessMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier2 & setDstStageMask( VULKAN_HPP_NAMESPACE::PipelineStageFlags2 dstStageMask_ ) VULKAN_HPP_NOEXCEPT
    {
      dstStageMask = dstStageMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier2 & setDstAccessMask( VULKAN_HPP_NAMESPACE::AccessFlags2 dstAccessMask_ ) VULKAN_HPP_NOEXCEPT
    {
      dstAccessMask = dstAccessMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier2 & setSrcQueueFamilyIndex( uint32_t srcQueueFamilyIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      srcQueueFamilyIndex = srcQueueFamilyIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier2 & setDstQueueFamilyIndex( uint32_t dstQueueFamilyIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      dstQueueFamilyIndex = dstQueueFamilyIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier2 & setBuffer( VULKAN_HPP_NAMESPACE::Buffer buffer_ ) VULKAN_HPP_NOEXCEPT
    {
      buffer = buffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier2 & setOffset( VULKAN_HPP_NAMESPACE::DeviceSize offset_ ) VULKAN_HPP_NOEXCEPT
    {
      offset = offset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier2 & setSize( VULKAN_HPP_NAMESPACE::DeviceSize size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBufferMemoryBarrier2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferMemoryBarrier2 *>( this );
    }

    operator VkBufferMemoryBarrier2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferMemoryBarrier2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::PipelineStageFlags2 const &,
               VULKAN_HPP_NAMESPACE::AccessFlags2 const &,
               VULKAN_HPP_NAMESPACE::PipelineStageFlags2 const &,
               VULKAN_HPP_NAMESPACE::AccessFlags2 const &,
               uint32_t const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::Buffer const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, srcStageMask, srcAccessMask, dstStageMask, dstAccessMask, srcQueueFamilyIndex, dstQueueFamilyIndex, buffer, offset, size );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferMemoryBarrier2 const & ) const = default;
#else
    bool operator==( BufferMemoryBarrier2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcStageMask == rhs.srcStageMask ) && ( srcAccessMask == rhs.srcAccessMask ) &&
             ( dstStageMask == rhs.dstStageMask ) && ( dstAccessMask == rhs.dstAccessMask ) && ( srcQueueFamilyIndex == rhs.srcQueueFamilyIndex ) &&
             ( dstQueueFamilyIndex == rhs.dstQueueFamilyIndex ) && ( buffer == rhs.buffer ) && ( offset == rhs.offset ) && ( size == rhs.size );
#  endif
    }

    bool operator!=( BufferMemoryBarrier2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType       sType               = StructureType::eBufferMemoryBarrier2;
    const void *                              pNext               = {};
    VULKAN_HPP_NAMESPACE::PipelineStageFlags2 srcStageMask        = {};
    VULKAN_HPP_NAMESPACE::AccessFlags2        srcAccessMask       = {};
    VULKAN_HPP_NAMESPACE::PipelineStageFlags2 dstStageMask        = {};
    VULKAN_HPP_NAMESPACE::AccessFlags2        dstAccessMask       = {};
    uint32_t                                  srcQueueFamilyIndex = {};
    uint32_t                                  dstQueueFamilyIndex = {};
    VULKAN_HPP_NAMESPACE::Buffer              buffer              = {};
    VULKAN_HPP_NAMESPACE::DeviceSize          offset              = {};
    VULKAN_HPP_NAMESPACE::DeviceSize          size                = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBufferMemoryBarrier2>
  {
    using Type = BufferMemoryBarrier2;
  };

  using BufferMemoryBarrier2KHR = BufferMemoryBarrier2;

  struct BufferMemoryRequirementsInfo2
  {
    using NativeType = VkBufferMemoryRequirementsInfo2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferMemoryRequirementsInfo2;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferMemoryRequirementsInfo2( VULKAN_HPP_NAMESPACE::Buffer buffer_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , buffer{ buffer_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferMemoryRequirementsInfo2( BufferMemoryRequirementsInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferMemoryRequirementsInfo2( VkBufferMemoryRequirementsInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferMemoryRequirementsInfo2( *reinterpret_cast<BufferMemoryRequirementsInfo2 const *>( &rhs ) )
    {
    }

    BufferMemoryRequirementsInfo2 & operator=( BufferMemoryRequirementsInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BufferMemoryRequirementsInfo2 & operator=( VkBufferMemoryRequirementsInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferMemoryRequirementsInfo2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferMemoryRequirementsInfo2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryRequirementsInfo2 & setBuffer( VULKAN_HPP_NAMESPACE::Buffer buffer_ ) VULKAN_HPP_NOEXCEPT
    {
      buffer = buffer_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBufferMemoryRequirementsInfo2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferMemoryRequirementsInfo2 *>( this );
    }

    operator VkBufferMemoryRequirementsInfo2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferMemoryRequirementsInfo2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::Buffer const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, buffer );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferMemoryRequirementsInfo2 const & ) const = default;
#else
    bool operator==( BufferMemoryRequirementsInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( buffer == rhs.buffer );
#  endif
    }

    bool operator!=( BufferMemoryRequirementsInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType  = StructureType::eBufferMemoryRequirementsInfo2;
    const void *                        pNext  = {};
    VULKAN_HPP_NAMESPACE::Buffer        buffer = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBufferMemoryRequirementsInfo2>
  {
    using Type = BufferMemoryRequirementsInfo2;
  };

  using BufferMemoryRequirementsInfo2KHR = BufferMemoryRequirementsInfo2;

  struct BufferOpaqueCaptureAddressCreateInfo
  {
    using NativeType = VkBufferOpaqueCaptureAddressCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferOpaqueCaptureAddressCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferOpaqueCaptureAddressCreateInfo( uint64_t opaqueCaptureAddress_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , opaqueCaptureAddress{ opaqueCaptureAddress_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferOpaqueCaptureAddressCreateInfo( BufferOpaqueCaptureAddressCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferOpaqueCaptureAddressCreateInfo( VkBufferOpaqueCaptureAddressCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferOpaqueCaptureAddressCreateInfo( *reinterpret_cast<BufferOpaqueCaptureAddressCreateInfo const *>( &rhs ) )
    {
    }

    BufferOpaqueCaptureAddressCreateInfo & operator=( BufferOpaqueCaptureAddressCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BufferOpaqueCaptureAddressCreateInfo & operator=( VkBufferOpaqueCaptureAddressCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferOpaqueCaptureAddressCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferOpaqueCaptureAddressCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferOpaqueCaptureAddressCreateInfo & setOpaqueCaptureAddress( uint64_t opaqueCaptureAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      opaqueCaptureAddress = opaqueCaptureAddress_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBufferOpaqueCaptureAddressCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferOpaqueCaptureAddressCreateInfo *>( this );
    }

    operator VkBufferOpaqueCaptureAddressCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferOpaqueCaptureAddressCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, uint64_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, opaqueCaptureAddress );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferOpaqueCaptureAddressCreateInfo const & ) const = default;
#else
    bool operator==( BufferOpaqueCaptureAddressCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( opaqueCaptureAddress == rhs.opaqueCaptureAddress );
#  endif
    }

    bool operator!=( BufferOpaqueCaptureAddressCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType                = StructureType::eBufferOpaqueCaptureAddressCreateInfo;
    const void *                        pNext                = {};
    uint64_t                            opaqueCaptureAddress = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBufferOpaqueCaptureAddressCreateInfo>
  {
    using Type = BufferOpaqueCaptureAddressCreateInfo;
  };

  using BufferOpaqueCaptureAddressCreateInfoKHR = BufferOpaqueCaptureAddressCreateInfo;

  struct BufferViewCreateInfo
  {
    using NativeType = VkBufferViewCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferViewCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferViewCreateInfo( VULKAN_HPP_NAMESPACE::BufferViewCreateFlags flags_  = {},
                                               VULKAN_HPP_NAMESPACE::Buffer                buffer_ = {},
                                               VULKAN_HPP_NAMESPACE::Format                format_ = VULKAN_HPP_NAMESPACE::Format::eUndefined,
                                               VULKAN_HPP_NAMESPACE::DeviceSize            offset_ = {},
                                               VULKAN_HPP_NAMESPACE::DeviceSize            range_  = {},
                                               const void *                                pNext_  = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , buffer{ buffer_ }
      , format{ format_ }
      , offset{ offset_ }
      , range{ range_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferViewCreateInfo( BufferViewCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferViewCreateInfo( VkBufferViewCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferViewCreateInfo( *reinterpret_cast<BufferViewCreateInfo const *>( &rhs ) )
    {
    }

    BufferViewCreateInfo & operator=( BufferViewCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BufferViewCreateInfo & operator=( VkBufferViewCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferViewCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferViewCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferViewCreateInfo & setFlags( VULKAN_HPP_NAMESPACE::BufferViewCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferViewCreateInfo & setBuffer( VULKAN_HPP_NAMESPACE::Buffer buffer_ ) VULKAN_HPP_NOEXCEPT
    {
      buffer = buffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferViewCreateInfo & setFormat( VULKAN_HPP_NAMESPACE::Format format_ ) VULKAN_HPP_NOEXCEPT
    {
      format = format_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferViewCreateInfo & setOffset( VULKAN_HPP_NAMESPACE::DeviceSize offset_ ) VULKAN_HPP_NOEXCEPT
    {
      offset = offset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferViewCreateInfo & setRange( VULKAN_HPP_NAMESPACE::DeviceSize range_ ) VULKAN_HPP_NOEXCEPT
    {
      range = range_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBufferViewCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferViewCreateInfo *>( this );
    }

    operator VkBufferViewCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferViewCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::BufferViewCreateFlags const &,
               VULKAN_HPP_NAMESPACE::Buffer const &,
               VULKAN_HPP_NAMESPACE::Format const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, buffer, format, offset, range );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferViewCreateInfo const & ) const = default;
#else
    bool operator==( BufferViewCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( buffer == rhs.buffer ) && ( format == rhs.format ) &&
             ( offset == rhs.offset ) && ( range == rhs.range );
#  endif
    }

    bool operator!=( BufferViewCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType         sType  = StructureType::eBufferViewCreateInfo;
    const void *                                pNext  = {};
    VULKAN_HPP_NAMESPACE::BufferViewCreateFlags flags  = {};
    VULKAN_HPP_NAMESPACE::Buffer                buffer = {};
    VULKAN_HPP_NAMESPACE::Format                format = VULKAN_HPP_NAMESPACE::Format::eUndefined;
    VULKAN_HPP_NAMESPACE::DeviceSize            offset = {};
    VULKAN_HPP_NAMESPACE::DeviceSize            range  = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBufferViewCreateInfo>
  {
    using Type = BufferViewCreateInfo;
  };

  struct CalibratedTimestampInfoKHR
  {
    using NativeType = VkCalibratedTimestampInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCalibratedTimestampInfoKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CalibratedTimestampInfoKHR( VULKAN_HPP_NAMESPACE::TimeDomainKHR timeDomain_ = VULKAN_HPP_NAMESPACE::TimeDomainKHR::eDevice,
                                                     const void *                        pNext_      = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , timeDomain{ timeDomain_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CalibratedTimestampInfoKHR( CalibratedTimestampInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CalibratedTimestampInfoKHR( VkCalibratedTimestampInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : CalibratedTimestampInfoKHR( *reinterpret_cast<CalibratedTimestampInfoKHR const *>( &rhs ) )
    {
    }

    CalibratedTimestampInfoKHR & operator=( CalibratedTimestampInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CalibratedTimestampInfoKHR & operator=( VkCalibratedTimestampInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CalibratedTimestampInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CalibratedTimestampInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CalibratedTimestampInfoKHR & setTimeDomain( VULKAN_HPP_NAMESPACE::TimeDomainKHR timeDomain_ ) VULKAN_HPP_NOEXCEPT
    {
      timeDomain = timeDomain_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkCalibratedTimestampInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCalibratedTimestampInfoKHR *>( this );
    }

    operator VkCalibratedTimestampInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCalibratedTimestampInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::TimeDomainKHR const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, timeDomain );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CalibratedTimestampInfoKHR const & ) const = default;
#else
    bool operator==( CalibratedTimestampInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( timeDomain == rhs.timeDomain );
#  endif
    }

    bool operator!=( CalibratedTimestampInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType      = StructureType::eCalibratedTimestampInfoKHR;
    const void *                        pNext      = {};
    VULKAN_HPP_NAMESPACE::TimeDomainKHR timeDomain = VULKAN_HPP_NAMESPACE::TimeDomainKHR::eDevice;
  };

  template <>
  struct CppType<StructureType, StructureType::eCalibratedTimestampInfoKHR>
  {
    using Type = CalibratedTimestampInfoKHR;
  };

  using CalibratedTimestampInfoEXT = CalibratedTimestampInfoKHR;

  union ClearColorValue
  {
    using NativeType = VkClearColorValue;
#if !defined( VULKAN_HPP_NO_UNION_CONSTRUCTORS )

    VULKAN_HPP_CONSTEXPR_14 ClearColorValue( const std::array<float, 4> & float32_ = {} ) : float32( float32_ ) {}

    VULKAN_HPP_CONSTEXPR ClearColorValue( float float32_0, float float32_1, float float32_2, float float32_3 )
      : float32{ { { float32_0, float32_1, float32_2, float32_3 } } }
    {
    }

    VULKAN_HPP_CONSTEXPR_14 ClearColorValue( const std::array<int32_t, 4> & int32_ ) : int32( int32_ ) {}

    VULKAN_HPP_CONSTEXPR ClearColorValue( int32_t int32_0, int32_t int32_1, int32_t int32_2, int32_t int32_3 )
      : int32{ { { int32_0, int32_1, int32_2, int32_3 } } }
    {
    }

    VULKAN_HPP_CONSTEXPR_14 ClearColorValue( const std::array<uint32_t, 4> & uint32_ ) : uint32( uint32_ ) {}

    VULKAN_HPP_CONSTEXPR ClearColorValue( uint32_t uint32_0, uint32_t uint32_1, uint32_t uint32_2, uint32_t uint32_3 )
      : uint32{ { { uint32_0, uint32_1, uint32_2, uint32_3 } } }
    {
    }
#endif /*VULKAN_HPP_NO_UNION_CONSTRUCTORS*/

#if !defined( VULKAN_HPP_NO_UNION_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ClearColorValue & setFloat32( std::array<float, 4> float32_ ) VULKAN_HPP_NOEXCEPT
    {
      float32 = float32_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClearColorValue & setInt32( std::array<int32_t, 4> int32_ ) VULKAN_HPP_NOEXCEPT
    {
      int32 = int32_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClearColorValue & setUint32( std::array<uint32_t, 4> uint32_ ) VULKAN_HPP_NOEXCEPT
    {
      uint32 = uint32_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_UNION_SETTERS*/

    operator VkClearColorValue const &() const
    {
      return *reinterpret_cast<const VkClearColorValue *>( this );
    }

    operator VkClearColorValue &()
    {
      return *reinterpret_cast<VkClearColorValue *>( this );
    }

    VULKAN_HPP_NAMESPACE::ArrayWrapper1D<float, 4>    float32;
    VULKAN_HPP_NAMESPACE::ArrayWrapper1D<int32_t, 4>  int32;
    VULKAN_HPP_NAMESPACE::ArrayWrapper1D<uint32_t, 4> uint32;
  };

  struct ClearDepthStencilValue
  {
    using NativeType = VkClearDepthStencilValue;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ClearDepthStencilValue( float depth_ = {}, uint32_t stencil_ = {} ) VULKAN_HPP_NOEXCEPT
      : depth{ depth_ }
      , stencil{ stencil_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ClearDepthStencilValue( ClearDepthStencilValue const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ClearDepthStencilValue( VkClearDepthStencilValue const & rhs ) VULKAN_HPP_NOEXCEPT
      : ClearDepthStencilValue( *reinterpret_cast<ClearDepthStencilValue const *>( &rhs ) )
    {
    }

    ClearDepthStencilValue & operator=( ClearDepthStencilValue const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ClearDepthStencilValue & operator=( VkClearDepthStencilValue const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ClearDepthStencilValue const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ClearDepthStencilValue & setDepth( float depth_ ) VULKAN_HPP_NOEXCEPT
    {
      depth = depth_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClearDepthStencilValue & setStencil( uint32_t stencil_ ) VULKAN_HPP_NOEXCEPT
    {
      stencil = stencil_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkClearDepthStencilValue const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkClearDepthStencilValue *>( this );
    }

    operator VkClearDepthStencilValue &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkClearDepthStencilValue *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<float const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( depth, stencil );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ClearDepthStencilValue const & ) const = default;
#else
    bool operator==( ClearDepthStencilValue const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( depth == rhs.depth ) && ( stencil == rhs.stencil );
#  endif
    }

    bool operator!=( ClearDepthStencilValue const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    float    depth   = {};
    uint32_t stencil = {};
  };

  union ClearValue
  {
    using NativeType = VkClearValue;
#if !defined( VULKAN_HPP_NO_UNION_CONSTRUCTORS )

    VULKAN_HPP_CONSTEXPR_14 ClearValue( VULKAN_HPP_NAMESPACE::ClearColorValue color_ = {} ) : color( color_ ) {}

    VULKAN_HPP_CONSTEXPR_14 ClearValue( VULKAN_HPP_NAMESPACE::ClearDepthStencilValue depthStencil_ ) : depthStencil( depthStencil_ ) {}
#endif /*VULKAN_HPP_NO_UNION_CONSTRUCTORS*/

#if !defined( VULKAN_HPP_NO_UNION_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ClearValue & setColor( VULKAN_HPP_NAMESPACE::ClearColorValue const & color_ ) VULKAN_HPP_NOEXCEPT
    {
      color = color_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClearValue & setDepthStencil( VULKAN_HPP_NAMESPACE::ClearDepthStencilValue const & depthStencil_ ) VULKAN_HPP_NOEXCEPT
    {
      depthStencil = depthStencil_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_UNION_SETTERS*/

    operator VkClearValue const &() const
    {
      return *reinterpret_cast<const VkClearValue *>( this );
    }

    operator VkClearValue &()
    {
      return *reinterpret_cast<VkClearValue *>( this );
    }

#ifdef VULKAN_HPP_HAS_UNRESTRICTED_UNIONS
    VULKAN_HPP_NAMESPACE::ClearColorValue        color;
    VULKAN_HPP_NAMESPACE::ClearDepthStencilValue depthStencil;
#else
    VkClearColorValue        color;
    VkClearDepthStencilValue depthStencil;
#endif /*VULKAN_HPP_HAS_UNRESTRICTED_UNIONS*/
  };

  struct ClearAttachment
  {
    using NativeType = VkClearAttachment;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 ClearAttachment( VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask_      = {},
                                             uint32_t                               colorAttachment_ = {},
                                             VULKAN_HPP_NAMESPACE::ClearValue       clearValue_      = {} ) VULKAN_HPP_NOEXCEPT
      : aspectMask{ aspectMask_ }
      , colorAttachment{ colorAttachment_ }
      , clearValue{ clearValue_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14 ClearAttachment( ClearAttachment const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ClearAttachment( VkClearAttachment const & rhs ) VULKAN_HPP_NOEXCEPT : ClearAttachment( *reinterpret_cast<ClearAttachment const *>( &rhs ) ) {}

    ClearAttachment & operator=( ClearAttachment const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ClearAttachment & operator=( VkClearAttachment const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ClearAttachment const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ClearAttachment & setAspectMask( VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask_ ) VULKAN_HPP_NOEXCEPT
    {
      aspectMask = aspectMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClearAttachment & setColorAttachment( uint32_t colorAttachment_ ) VULKAN_HPP_NOEXCEPT
    {
      colorAttachment = colorAttachment_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClearAttachment & setClearValue( VULKAN_HPP_NAMESPACE::ClearValue const & clearValue_ ) VULKAN_HPP_NOEXCEPT
    {
      clearValue = clearValue_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkClearAttachment const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkClearAttachment *>( this );
    }

    operator VkClearAttachment &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkClearAttachment *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::ImageAspectFlags const &, uint32_t const &, VULKAN_HPP_NAMESPACE::ClearValue const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( aspectMask, colorAttachment, clearValue );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask      = {};
    uint32_t                               colorAttachment = {};
    VULKAN_HPP_NAMESPACE::ClearValue       clearValue      = {};
  };

  struct ClearRect
  {
    using NativeType = VkClearRect;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ClearRect( VULKAN_HPP_NAMESPACE::Rect2D rect_ = {}, uint32_t baseArrayLayer_ = {}, uint32_t layerCount_ = {} ) VULKAN_HPP_NOEXCEPT
      : rect{ rect_ }
      , baseArrayLayer{ baseArrayLayer_ }
      , layerCount{ layerCount_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ClearRect( ClearRect const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ClearRect( VkClearRect const & rhs ) VULKAN_HPP_NOEXCEPT : ClearRect( *reinterpret_cast<ClearRect const *>( &rhs ) ) {}

    ClearRect & operator=( ClearRect const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ClearRect & operator=( VkClearRect const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ClearRect const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ClearRect & setRect( VULKAN_HPP_NAMESPACE::Rect2D const & rect_ ) VULKAN_HPP_NOEXCEPT
    {
      rect = rect_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClearRect & setBaseArrayLayer( uint32_t baseArrayLayer_ ) VULKAN_HPP_NOEXCEPT
    {
      baseArrayLayer = baseArrayLayer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClearRect & setLayerCount( uint32_t layerCount_ ) VULKAN_HPP_NOEXCEPT
    {
      layerCount = layerCount_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkClearRect const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkClearRect *>( this );
    }

    operator VkClearRect &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkClearRect *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::Rect2D const &, uint32_t const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( rect, baseArrayLayer, layerCount );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ClearRect const & ) const = default;
#else
    bool                     operator==( ClearRect const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( rect == rhs.rect ) && ( baseArrayLayer == rhs.baseArrayLayer ) && ( layerCount == rhs.layerCount );
#  endif
    }

    bool operator!=( ClearRect const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::Rect2D rect           = {};
    uint32_t                     baseArrayLayer = {};
    uint32_t                     layerCount     = {};
  };

  struct CommandBufferAllocateInfo
  {
    using NativeType = VkCommandBufferAllocateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCommandBufferAllocateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CommandBufferAllocateInfo( VULKAN_HPP_NAMESPACE::CommandPool        commandPool_ = {},
                                                    VULKAN_HPP_NAMESPACE::CommandBufferLevel level_       = VULKAN_HPP_NAMESPACE::CommandBufferLevel::ePrimary,
                                                    uint32_t                                 commandBufferCount_ = {},
                                                    const void *                             pNext_              = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , commandPool{ commandPool_ }
      , level{ level_ }
      , commandBufferCount{ commandBufferCount_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CommandBufferAllocateInfo( CommandBufferAllocateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferAllocateInfo( VkCommandBufferAllocateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : CommandBufferAllocateInfo( *reinterpret_cast<CommandBufferAllocateInfo const *>( &rhs ) )
    {
    }

    CommandBufferAllocateInfo & operator=( CommandBufferAllocateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CommandBufferAllocateInfo & operator=( VkCommandBufferAllocateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CommandBufferAllocateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CommandBufferAllocateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferAllocateInfo & setCommandPool( VULKAN_HPP_NAMESPACE::CommandPool commandPool_ ) VULKAN_HPP_NOEXCEPT
    {
      commandPool = commandPool_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferAllocateInfo & setLevel( VULKAN_HPP_NAMESPACE::CommandBufferLevel level_ ) VULKAN_HPP_NOEXCEPT
    {
      level = level_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferAllocateInfo & setCommandBufferCount( uint32_t commandBufferCount_ ) VULKAN_HPP_NOEXCEPT
    {
      commandBufferCount = commandBufferCount_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkCommandBufferAllocateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCommandBufferAllocateInfo *>( this );
    }

    operator VkCommandBufferAllocateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCommandBufferAllocateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::CommandPool const &,
               VULKAN_HPP_NAMESPACE::CommandBufferLevel const &,
               uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, commandPool, level, commandBufferCount );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CommandBufferAllocateInfo const & ) const = default;
#else
    bool operator==( CommandBufferAllocateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( commandPool == rhs.commandPool ) && ( level == rhs.level ) &&
             ( commandBufferCount == rhs.commandBufferCount );
#  endif
    }

    bool operator!=( CommandBufferAllocateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType      sType              = StructureType::eCommandBufferAllocateInfo;
    const void *                             pNext              = {};
    VULKAN_HPP_NAMESPACE::CommandPool        commandPool        = {};
    VULKAN_HPP_NAMESPACE::CommandBufferLevel level              = VULKAN_HPP_NAMESPACE::CommandBufferLevel::ePrimary;
    uint32_t                                 commandBufferCount = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCommandBufferAllocateInfo>
  {
    using Type = CommandBufferAllocateInfo;
  };

  struct CommandBufferInheritanceInfo
  {
    using NativeType = VkCommandBufferInheritanceInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCommandBufferInheritanceInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CommandBufferInheritanceInfo( VULKAN_HPP_NAMESPACE::RenderPass                  renderPass_           = {},
                                                       uint32_t                                          subpass_              = {},
                                                       VULKAN_HPP_NAMESPACE::Framebuffer                 framebuffer_          = {},
                                                       VULKAN_HPP_NAMESPACE::Bool32                      occlusionQueryEnable_ = {},
                                                       VULKAN_HPP_NAMESPACE::QueryControlFlags           queryFlags_           = {},
                                                       VULKAN_HPP_NAMESPACE::QueryPipelineStatisticFlags pipelineStatistics_   = {},
                                                       const void *                                      pNext_                = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , renderPass{ renderPass_ }
      , subpass{ subpass_ }
      , framebuffer{ framebuffer_ }
      , occlusionQueryEnable{ occlusionQueryEnable_ }
      , queryFlags{ queryFlags_ }
      , pipelineStatistics{ pipelineStatistics_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CommandBufferInheritanceInfo( CommandBufferInheritanceInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferInheritanceInfo( VkCommandBufferInheritanceInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : CommandBufferInheritanceInfo( *reinterpret_cast<CommandBufferInheritanceInfo const *>( &rhs ) )
    {
    }

    CommandBufferInheritanceInfo & operator=( CommandBufferInheritanceInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CommandBufferInheritanceInfo & operator=( VkCommandBufferInheritanceInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CommandBufferInheritanceInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceInfo & setRenderPass( VULKAN_HPP_NAMESPACE::RenderPass renderPass_ ) VULKAN_HPP_NOEXCEPT
    {
      renderPass = renderPass_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceInfo & setSubpass( uint32_t subpass_ ) VULKAN_HPP_NOEXCEPT
    {
      subpass = subpass_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceInfo & setFramebuffer( VULKAN_HPP_NAMESPACE::Framebuffer framebuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      framebuffer = framebuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceInfo & setOcclusionQueryEnable( VULKAN_HPP_NAMESPACE::Bool32 occlusionQueryEnable_ ) VULKAN_HPP_NOEXCEPT
    {
      occlusionQueryEnable = occlusionQueryEnable_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceInfo & setQueryFlags( VULKAN_HPP_NAMESPACE::QueryControlFlags queryFlags_ ) VULKAN_HPP_NOEXCEPT
    {
      queryFlags = queryFlags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceInfo &
      setPipelineStatistics( VULKAN_HPP_NAMESPACE::QueryPipelineStatisticFlags pipelineStatistics_ ) VULKAN_HPP_NOEXCEPT
    {
      pipelineStatistics = pipelineStatistics_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkCommandBufferInheritanceInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCommandBufferInheritanceInfo *>( this );
    }

    operator VkCommandBufferInheritanceInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCommandBufferInheritanceInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::RenderPass const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::Framebuffer const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::QueryControlFlags const &,
               VULKAN_HPP_NAMESPACE::QueryPipelineStatisticFlags const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, renderPass, subpass, framebuffer, occlusionQueryEnable, queryFlags, pipelineStatistics );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CommandBufferInheritanceInfo const & ) const = default;
#else
    bool operator==( CommandBufferInheritanceInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( renderPass == rhs.renderPass ) && ( subpass == rhs.subpass ) &&
             ( framebuffer == rhs.framebuffer ) && ( occlusionQueryEnable == rhs.occlusionQueryEnable ) && ( queryFlags == rhs.queryFlags ) &&
             ( pipelineStatistics == rhs.pipelineStatistics );
#  endif
    }

    bool operator!=( CommandBufferInheritanceInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType               sType                = StructureType::eCommandBufferInheritanceInfo;
    const void *                                      pNext                = {};
    VULKAN_HPP_NAMESPACE::RenderPass                  renderPass           = {};
    uint32_t                                          subpass              = {};
    VULKAN_HPP_NAMESPACE::Framebuffer                 framebuffer          = {};
    VULKAN_HPP_NAMESPACE::Bool32                      occlusionQueryEnable = {};
    VULKAN_HPP_NAMESPACE::QueryControlFlags           queryFlags           = {};
    VULKAN_HPP_NAMESPACE::QueryPipelineStatisticFlags pipelineStatistics   = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCommandBufferInheritanceInfo>
  {
    using Type = CommandBufferInheritanceInfo;
  };

  struct CommandBufferBeginInfo
  {
    using NativeType = VkCommandBufferBeginInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCommandBufferBeginInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CommandBufferBeginInfo( VULKAN_HPP_NAMESPACE::CommandBufferUsageFlags              flags_            = {},
                                                 const VULKAN_HPP_NAMESPACE::CommandBufferInheritanceInfo * pInheritanceInfo_ = {},
                                                 const void *                                               pNext_            = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , pInheritanceInfo{ pInheritanceInfo_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CommandBufferBeginInfo( CommandBufferBeginInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferBeginInfo( VkCommandBufferBeginInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : CommandBufferBeginInfo( *reinterpret_cast<CommandBufferBeginInfo const *>( &rhs ) )
    {
    }

    CommandBufferBeginInfo & operator=( CommandBufferBeginInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CommandBufferBeginInfo & operator=( VkCommandBufferBeginInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CommandBufferBeginInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CommandBufferBeginInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferBeginInfo & setFlags( VULKAN_HPP_NAMESPACE::CommandBufferUsageFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferBeginInfo &
      setPInheritanceInfo( const VULKAN_HPP_NAMESPACE::CommandBufferInheritanceInfo * pInheritanceInfo_ ) VULKAN_HPP_NOEXCEPT
    {
      pInheritanceInfo = pInheritanceInfo_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkCommandBufferBeginInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCommandBufferBeginInfo *>( this );
    }

    operator VkCommandBufferBeginInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCommandBufferBeginInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::CommandBufferUsageFlags const &,
               const VULKAN_HPP_NAMESPACE::CommandBufferInheritanceInfo * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, pInheritanceInfo );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CommandBufferBeginInfo const & ) const = default;
#else
    bool operator==( CommandBufferBeginInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( pInheritanceInfo == rhs.pInheritanceInfo );
#  endif
    }

    bool operator!=( CommandBufferBeginInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                        sType            = StructureType::eCommandBufferBeginInfo;
    const void *                                               pNext            = {};
    VULKAN_HPP_NAMESPACE::CommandBufferUsageFlags              flags            = {};
    const VULKAN_HPP_NAMESPACE::CommandBufferInheritanceInfo * pInheritanceInfo = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCommandBufferBeginInfo>
  {
    using Type = CommandBufferBeginInfo;
  };

  struct CommandBufferInheritanceRenderingInfo
  {
    using NativeType = VkCommandBufferInheritanceRenderingInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCommandBufferInheritanceRenderingInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      CommandBufferInheritanceRenderingInfo( VULKAN_HPP_NAMESPACE::RenderingFlags      flags_                   = {},
                                             uint32_t                                  viewMask_                = {},
                                             uint32_t                                  colorAttachmentCount_    = {},
                                             const VULKAN_HPP_NAMESPACE::Format *      pColorAttachmentFormats_ = {},
                                             VULKAN_HPP_NAMESPACE::Format              depthAttachmentFormat_   = VULKAN_HPP_NAMESPACE::Format::eUndefined,
                                             VULKAN_HPP_NAMESPACE::Format              stencilAttachmentFormat_ = VULKAN_HPP_NAMESPACE::Format::eUndefined,
                                             VULKAN_HPP_NAMESPACE::SampleCountFlagBits rasterizationSamples_    = VULKAN_HPP_NAMESPACE::SampleCountFlagBits::e1,
                                             const void *                              pNext_                   = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , viewMask{ viewMask_ }
      , colorAttachmentCount{ colorAttachmentCount_ }
      , pColorAttachmentFormats{ pColorAttachmentFormats_ }
      , depthAttachmentFormat{ depthAttachmentFormat_ }
      , stencilAttachmentFormat{ stencilAttachmentFormat_ }
      , rasterizationSamples{ rasterizationSamples_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CommandBufferInheritanceRenderingInfo( CommandBufferInheritanceRenderingInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferInheritanceRenderingInfo( VkCommandBufferInheritanceRenderingInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : CommandBufferInheritanceRenderingInfo( *reinterpret_cast<CommandBufferInheritanceRenderingInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CommandBufferInheritanceRenderingInfo( VULKAN_HPP_NAMESPACE::RenderingFlags                                                      flags_,
                                           uint32_t                                                                                  viewMask_,
                                           VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::Format> const & colorAttachmentFormats_,
                                           VULKAN_HPP_NAMESPACE::Format              depthAttachmentFormat_   = VULKAN_HPP_NAMESPACE::Format::eUndefined,
                                           VULKAN_HPP_NAMESPACE::Format              stencilAttachmentFormat_ = VULKAN_HPP_NAMESPACE::Format::eUndefined,
                                           VULKAN_HPP_NAMESPACE::SampleCountFlagBits rasterizationSamples_    = VULKAN_HPP_NAMESPACE::SampleCountFlagBits::e1,
                                           const void *                              pNext_                   = nullptr )
      : pNext( pNext_ )
      , flags( flags_ )
      , viewMask( viewMask_ )
      , colorAttachmentCount( static_cast<uint32_t>( colorAttachmentFormats_.size() ) )
      , pColorAttachmentFormats( colorAttachmentFormats_.data() )
      , depthAttachmentFormat( depthAttachmentFormat_ )
      , stencilAttachmentFormat( stencilAttachmentFormat_ )
      , rasterizationSamples( rasterizationSamples_ )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    CommandBufferInheritanceRenderingInfo & operator=( CommandBufferInheritanceRenderingInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CommandBufferInheritanceRenderingInfo & operator=( VkCommandBufferInheritanceRenderingInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CommandBufferInheritanceRenderingInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderingInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderingInfo & setFlags( VULKAN_HPP_NAMESPACE::RenderingFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderingInfo & setViewMask( uint32_t viewMask_ ) VULKAN_HPP_NOEXCEPT
    {
      viewMask = viewMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderingInfo & setColorAttachmentCount( uint32_t colorAttachmentCount_ ) VULKAN_HPP_NOEXCEPT
    {
      colorAttachmentCount = colorAttachmentCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderingInfo &
      setPColorAttachmentFormats( const VULKAN_HPP_NAMESPACE::Format * pColorAttachmentFormats_ ) VULKAN_HPP_NOEXCEPT
    {
      pColorAttachmentFormats = pColorAttachmentFormats_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CommandBufferInheritanceRenderingInfo & setColorAttachmentFormats(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::Format> const & colorAttachmentFormats_ ) VULKAN_HPP_NOEXCEPT
    {
      colorAttachmentCount    = static_cast<uint32_t>( colorAttachmentFormats_.size() );
      pColorAttachmentFormats = colorAttachmentFormats_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderingInfo &
      setDepthAttachmentFormat( VULKAN_HPP_NAMESPACE::Format depthAttachmentFormat_ ) VULKAN_HPP_NOEXCEPT
    {
      depthAttachmentFormat = depthAttachmentFormat_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderingInfo &
      setStencilAttachmentFormat( VULKAN_HPP_NAMESPACE::Format stencilAttachmentFormat_ ) VULKAN_HPP_NOEXCEPT
    {
      stencilAttachmentFormat = stencilAttachmentFormat_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderingInfo &
      setRasterizationSamples( VULKAN_HPP_NAMESPACE::SampleCountFlagBits rasterizationSamples_ ) VULKAN_HPP_NOEXCEPT
    {
      rasterizationSamples = rasterizationSamples_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkCommandBufferInheritanceRenderingInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCommandBufferInheritanceRenderingInfo *>( this );
    }

    operator VkCommandBufferInheritanceRenderingInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCommandBufferInheritanceRenderingInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::RenderingFlags const &,
               uint32_t const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::Format * const &,
               VULKAN_HPP_NAMESPACE::Format const &,
               VULKAN_HPP_NAMESPACE::Format const &,
               VULKAN_HPP_NAMESPACE::SampleCountFlagBits const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie(
        sType, pNext, flags, viewMask, colorAttachmentCount, pColorAttachmentFormats, depthAttachmentFormat, stencilAttachmentFormat, rasterizationSamples );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CommandBufferInheritanceRenderingInfo const & ) const = default;
#else
    bool operator==( CommandBufferInheritanceRenderingInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( viewMask == rhs.viewMask ) &&
             ( colorAttachmentCount == rhs.colorAttachmentCount ) && ( pColorAttachmentFormats == rhs.pColorAttachmentFormats ) &&
             ( depthAttachmentFormat == rhs.depthAttachmentFormat ) && ( stencilAttachmentFormat == rhs.stencilAttachmentFormat ) &&
             ( rasterizationSamples == rhs.rasterizationSamples );
#  endif
    }

    bool operator!=( CommandBufferInheritanceRenderingInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType       sType                   = StructureType::eCommandBufferInheritanceRenderingInfo;
    const void *                              pNext                   = {};
    VULKAN_HPP_NAMESPACE::RenderingFlags      flags                   = {};
    uint32_t                                  viewMask                = {};
    uint32_t                                  colorAttachmentCount    = {};
    const VULKAN_HPP_NAMESPACE::Format *      pColorAttachmentFormats = {};
    VULKAN_HPP_NAMESPACE::Format              depthAttachmentFormat   = VULKAN_HPP_NAMESPACE::Format::eUndefined;
    VULKAN_HPP_NAMESPACE::Format              stencilAttachmentFormat = VULKAN_HPP_NAMESPACE::Format::eUndefined;
    VULKAN_HPP_NAMESPACE::SampleCountFlagBits rasterizationSamples    = VULKAN_HPP_NAMESPACE::SampleCountFlagBits::e1;
  };

  template <>
  struct CppType<StructureType, StructureType::eCommandBufferInheritanceRenderingInfo>
  {
    using Type = CommandBufferInheritanceRenderingInfo;
  };

  using CommandBufferInheritanceRenderingInfoKHR = CommandBufferInheritanceRenderingInfo;

  struct CommandBufferSubmitInfo
  {
    using NativeType = VkCommandBufferSubmitInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCommandBufferSubmitInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CommandBufferSubmitInfo( VULKAN_HPP_NAMESPACE::CommandBuffer commandBuffer_ = {},
                                                  uint32_t                            deviceMask_    = {},
                                                  const void *                        pNext_         = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , commandBuffer{ commandBuffer_ }
      , deviceMask{ deviceMask_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CommandBufferSubmitInfo( CommandBufferSubmitInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferSubmitInfo( VkCommandBufferSubmitInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : CommandBufferSubmitInfo( *reinterpret_cast<CommandBufferSubmitInfo const *>( &rhs ) )
    {
    }

    CommandBufferSubmitInfo & operator=( CommandBufferSubmitInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CommandBufferSubmitInfo & operator=( VkCommandBufferSubmitInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CommandBufferSubmitInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CommandBufferSubmitInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferSubmitInfo & setCommandBuffer( VULKAN_HPP_NAMESPACE::CommandBuffer commandBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      commandBuffer = commandBuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferSubmitInfo & setDeviceMask( uint32_t deviceMask_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceMask = deviceMask_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkCommandBufferSubmitInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCommandBufferSubmitInfo *>( this );
    }

    operator VkCommandBufferSubmitInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCommandBufferSubmitInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::CommandBuffer const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, commandBuffer, deviceMask );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CommandBufferSubmitInfo const & ) const = default;
#else
    bool operator==( CommandBufferSubmitInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( commandBuffer == rhs.commandBuffer ) && ( deviceMask == rhs.deviceMask );
#  endif
    }

    bool operator!=( CommandBufferSubmitInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType         = StructureType::eCommandBufferSubmitInfo;
    const void *                        pNext         = {};
    VULKAN_HPP_NAMESPACE::CommandBuffer commandBuffer = {};
    uint32_t                            deviceMask    = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCommandBufferSubmitInfo>
  {
    using Type = CommandBufferSubmitInfo;
  };

  using CommandBufferSubmitInfoKHR = CommandBufferSubmitInfo;

  struct CommandPoolCreateInfo
  {
    using NativeType = VkCommandPoolCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCommandPoolCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CommandPoolCreateInfo( VULKAN_HPP_NAMESPACE::CommandPoolCreateFlags flags_            = {},
                                                uint32_t                                     queueFamilyIndex_ = {},
                                                const void *                                 pNext_            = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , queueFamilyIndex{ queueFamilyIndex_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CommandPoolCreateInfo( CommandPoolCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandPoolCreateInfo( VkCommandPoolCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : CommandPoolCreateInfo( *reinterpret_cast<CommandPoolCreateInfo const *>( &rhs ) )
    {
    }

    CommandPoolCreateInfo & operator=( CommandPoolCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CommandPoolCreateInfo & operator=( VkCommandPoolCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CommandPoolCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CommandPoolCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandPoolCreateInfo & setFlags( VULKAN_HPP_NAMESPACE::CommandPoolCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandPoolCreateInfo & setQueueFamilyIndex( uint32_t queueFamilyIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      queueFamilyIndex = queueFamilyIndex_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkCommandPoolCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCommandPoolCreateInfo *>( this );
    }

    operator VkCommandPoolCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCommandPoolCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::CommandPoolCreateFlags const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, queueFamilyIndex );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CommandPoolCreateInfo const & ) const = default;
#else
    bool operator==( CommandPoolCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( queueFamilyIndex == rhs.queueFamilyIndex );
#  endif
    }

    bool operator!=( CommandPoolCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType          sType            = StructureType::eCommandPoolCreateInfo;
    const void *                                 pNext            = {};
    VULKAN_HPP_NAMESPACE::CommandPoolCreateFlags flags            = {};
    uint32_t                                     queueFamilyIndex = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCommandPoolCreateInfo>
  {
    using Type = CommandPoolCreateInfo;
  };

  struct CommandPoolMemoryConsumption
  {
    using NativeType = VkCommandPoolMemoryConsumption;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCommandPoolMemoryConsumption;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CommandPoolMemoryConsumption( VULKAN_HPP_NAMESPACE::DeviceSize commandPoolAllocated_    = {},
                                                       VULKAN_HPP_NAMESPACE::DeviceSize commandPoolReservedSize_ = {},
                                                       VULKAN_HPP_NAMESPACE::DeviceSize commandBufferAllocated_  = {},
                                                       void *                           pNext_                   = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , commandPoolAllocated{ commandPoolAllocated_ }
      , commandPoolReservedSize{ commandPoolReservedSize_ }
      , commandBufferAllocated{ commandBufferAllocated_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CommandPoolMemoryConsumption( CommandPoolMemoryConsumption const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandPoolMemoryConsumption( VkCommandPoolMemoryConsumption const & rhs ) VULKAN_HPP_NOEXCEPT
      : CommandPoolMemoryConsumption( *reinterpret_cast<CommandPoolMemoryConsumption const *>( &rhs ) )
    {
    }

    CommandPoolMemoryConsumption & operator=( CommandPoolMemoryConsumption const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CommandPoolMemoryConsumption & operator=( VkCommandPoolMemoryConsumption const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CommandPoolMemoryConsumption const *>( &rhs );
      return *this;
    }

    operator VkCommandPoolMemoryConsumption const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCommandPoolMemoryConsumption *>( this );
    }

    operator VkCommandPoolMemoryConsumption &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCommandPoolMemoryConsumption *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               void * const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, commandPoolAllocated, commandPoolReservedSize, commandBufferAllocated );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CommandPoolMemoryConsumption const & ) const = default;
#else
    bool operator==( CommandPoolMemoryConsumption const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( commandPoolAllocated == rhs.commandPoolAllocated ) &&
             ( commandPoolReservedSize == rhs.commandPoolReservedSize ) && ( commandBufferAllocated == rhs.commandBufferAllocated );
#  endif
    }

    bool operator!=( CommandPoolMemoryConsumption const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType                   = StructureType::eCommandPoolMemoryConsumption;
    void *                              pNext                   = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    commandPoolAllocated    = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    commandPoolReservedSize = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    commandBufferAllocated  = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCommandPoolMemoryConsumption>
  {
    using Type = CommandPoolMemoryConsumption;
  };

  struct CommandPoolMemoryReservationCreateInfo
  {
    using NativeType = VkCommandPoolMemoryReservationCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCommandPoolMemoryReservationCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CommandPoolMemoryReservationCreateInfo( VULKAN_HPP_NAMESPACE::DeviceSize commandPoolReservedSize_      = {},
                                                                 uint32_t                         commandPoolMaxCommandBuffers_ = {},
                                                                 const void *                     pNext_                        = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , commandPoolReservedSize{ commandPoolReservedSize_ }
      , commandPoolMaxCommandBuffers{ commandPoolMaxCommandBuffers_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CommandPoolMemoryReservationCreateInfo( CommandPoolMemoryReservationCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandPoolMemoryReservationCreateInfo( VkCommandPoolMemoryReservationCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : CommandPoolMemoryReservationCreateInfo( *reinterpret_cast<CommandPoolMemoryReservationCreateInfo const *>( &rhs ) )
    {
    }

    CommandPoolMemoryReservationCreateInfo & operator=( CommandPoolMemoryReservationCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CommandPoolMemoryReservationCreateInfo & operator=( VkCommandPoolMemoryReservationCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CommandPoolMemoryReservationCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CommandPoolMemoryReservationCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandPoolMemoryReservationCreateInfo &
      setCommandPoolReservedSize( VULKAN_HPP_NAMESPACE::DeviceSize commandPoolReservedSize_ ) VULKAN_HPP_NOEXCEPT
    {
      commandPoolReservedSize = commandPoolReservedSize_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandPoolMemoryReservationCreateInfo &
      setCommandPoolMaxCommandBuffers( uint32_t commandPoolMaxCommandBuffers_ ) VULKAN_HPP_NOEXCEPT
    {
      commandPoolMaxCommandBuffers = commandPoolMaxCommandBuffers_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkCommandPoolMemoryReservationCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCommandPoolMemoryReservationCreateInfo *>( this );
    }

    operator VkCommandPoolMemoryReservationCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCommandPoolMemoryReservationCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::DeviceSize const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, commandPoolReservedSize, commandPoolMaxCommandBuffers );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CommandPoolMemoryReservationCreateInfo const & ) const = default;
#else
    bool operator==( CommandPoolMemoryReservationCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( commandPoolReservedSize == rhs.commandPoolReservedSize ) &&
             ( commandPoolMaxCommandBuffers == rhs.commandPoolMaxCommandBuffers );
#  endif
    }

    bool operator!=( CommandPoolMemoryReservationCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType                        = StructureType::eCommandPoolMemoryReservationCreateInfo;
    const void *                        pNext                        = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    commandPoolReservedSize      = {};
    uint32_t                            commandPoolMaxCommandBuffers = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCommandPoolMemoryReservationCreateInfo>
  {
    using Type = CommandPoolMemoryReservationCreateInfo;
  };

  struct ComponentMapping
  {
    using NativeType = VkComponentMapping;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ComponentMapping( VULKAN_HPP_NAMESPACE::ComponentSwizzle r_ = VULKAN_HPP_NAMESPACE::ComponentSwizzle::eIdentity,
                                           VULKAN_HPP_NAMESPACE::ComponentSwizzle g_ = VULKAN_HPP_NAMESPACE::ComponentSwizzle::eIdentity,
                                           VULKAN_HPP_NAMESPACE::ComponentSwizzle b_ = VULKAN_HPP_NAMESPACE::ComponentSwizzle::eIdentity,
                                           VULKAN_HPP_NAMESPACE::ComponentSwizzle a_ = VULKAN_HPP_NAMESPACE::ComponentSwizzle::eIdentity ) VULKAN_HPP_NOEXCEPT
      : r{ r_ }
      , g{ g_ }
      , b{ b_ }
      , a{ a_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ComponentMapping( ComponentMapping const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ComponentMapping( VkComponentMapping const & rhs ) VULKAN_HPP_NOEXCEPT : ComponentMapping( *reinterpret_cast<ComponentMapping const *>( &rhs ) ) {}

    ComponentMapping & operator=( ComponentMapping const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ComponentMapping & operator=( VkComponentMapping const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ComponentMapping const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ComponentMapping & setR( VULKAN_HPP_NAMESPACE::ComponentSwizzle r_ ) VULKAN_HPP_NOEXCEPT
    {
      r = r_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ComponentMapping & setG( VULKAN_HPP_NAMESPACE::ComponentSwizzle g_ ) VULKAN_HPP_NOEXCEPT
    {
      g = g_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ComponentMapping & setB( VULKAN_HPP_NAMESPACE::ComponentSwizzle b_ ) VULKAN_HPP_NOEXCEPT
    {
      b = b_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ComponentMapping & setA( VULKAN_HPP_NAMESPACE::ComponentSwizzle a_ ) VULKAN_HPP_NOEXCEPT
    {
      a = a_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkComponentMapping const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkComponentMapping *>( this );
    }

    operator VkComponentMapping &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkComponentMapping *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::ComponentSwizzle const &,
               VULKAN_HPP_NAMESPACE::ComponentSwizzle const &,
               VULKAN_HPP_NAMESPACE::ComponentSwizzle const &,
               VULKAN_HPP_NAMESPACE::ComponentSwizzle const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( r, g, b, a );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ComponentMapping const & ) const = default;
#else
    bool operator==( ComponentMapping const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( r == rhs.r ) && ( g == rhs.g ) && ( b == rhs.b ) && ( a == rhs.a );
#  endif
    }

    bool operator!=( ComponentMapping const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::ComponentSwizzle r = VULKAN_HPP_NAMESPACE::ComponentSwizzle::eIdentity;
    VULKAN_HPP_NAMESPACE::ComponentSwizzle g = VULKAN_HPP_NAMESPACE::ComponentSwizzle::eIdentity;
    VULKAN_HPP_NAMESPACE::ComponentSwizzle b = VULKAN_HPP_NAMESPACE::ComponentSwizzle::eIdentity;
    VULKAN_HPP_NAMESPACE::ComponentSwizzle a = VULKAN_HPP_NAMESPACE::ComponentSwizzle::eIdentity;
  };

  struct SpecializationMapEntry
  {
    using NativeType = VkSpecializationMapEntry;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR SpecializationMapEntry( uint32_t constantID_ = {}, uint32_t offset_ = {}, size_t size_ = {} ) VULKAN_HPP_NOEXCEPT
      : constantID{ constantID_ }
      , offset{ offset_ }
      , size{ size_ }
    {
    }

    VULKAN_HPP_CONSTEXPR SpecializationMapEntry( SpecializationMapEntry const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SpecializationMapEntry( VkSpecializationMapEntry const & rhs ) VULKAN_HPP_NOEXCEPT
      : SpecializationMapEntry( *reinterpret_cast<SpecializationMapEntry const *>( &rhs ) )
    {
    }

    SpecializationMapEntry & operator=( SpecializationMapEntry const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    SpecializationMapEntry & operator=( VkSpecializationMapEntry const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::SpecializationMapEntry const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 SpecializationMapEntry & setConstantID( uint32_t constantID_ ) VULKAN_HPP_NOEXCEPT
    {
      constantID = constantID_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SpecializationMapEntry & setOffset( uint32_t offset_ ) VULKAN_HPP_NOEXCEPT
    {
      offset = offset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SpecializationMapEntry & setSize( size_t size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkSpecializationMapEntry const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkSpecializationMapEntry *>( this );
    }

    operator VkSpecializationMapEntry &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkSpecializationMapEntry *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &, uint32_t const &, size_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( constantID, offset, size );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( SpecializationMapEntry const & ) const = default;
#else
    bool operator==( SpecializationMapEntry const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( constantID == rhs.constantID ) && ( offset == rhs.offset ) && ( size == rhs.size );
#  endif
    }

    bool operator!=( SpecializationMapEntry const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t constantID = {};
    uint32_t offset     = {};
    size_t   size       = {};
  };

  struct SpecializationInfo
  {
    using NativeType = VkSpecializationInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR SpecializationInfo( uint32_t                                             mapEntryCount_ = {},
                                             const VULKAN_HPP_NAMESPACE::SpecializationMapEntry * pMapEntries_   = {},
                                             size_t                                               dataSize_      = {},
                                             const void *                                         pData_         = {} ) VULKAN_HPP_NOEXCEPT
      : mapEntryCount{ mapEntryCount_ }
      , pMapEntries{ pMapEntries_ }
      , dataSize{ dataSize_ }
      , pData{ pData_ }
    {
    }

    VULKAN_HPP_CONSTEXPR SpecializationInfo( SpecializationInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SpecializationInfo( VkSpecializationInfo const & rhs ) VULKAN_HPP_NOEXCEPT : SpecializationInfo( *reinterpret_cast<SpecializationInfo const *>( &rhs ) ) {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    template <typename T>
    SpecializationInfo( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SpecializationMapEntry> const & mapEntries_,
                        VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const T> const &                                            data_ = {} )
      : mapEntryCount( static_cast<uint32_t>( mapEntries_.size() ) )
      , pMapEntries( mapEntries_.data() )
      , dataSize( data_.size() * sizeof( T ) )
      , pData( data_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    SpecializationInfo & operator=( SpecializationInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    SpecializationInfo & operator=( VkSpecializationInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::SpecializationInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 SpecializationInfo & setMapEntryCount( uint32_t mapEntryCount_ ) VULKAN_HPP_NOEXCEPT
    {
      mapEntryCount = mapEntryCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SpecializationInfo & setPMapEntries( const VULKAN_HPP_NAMESPACE::SpecializationMapEntry * pMapEntries_ ) VULKAN_HPP_NOEXCEPT
    {
      pMapEntries = pMapEntries_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    SpecializationInfo &
      setMapEntries( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SpecializationMapEntry> const & mapEntries_ ) VULKAN_HPP_NOEXCEPT
    {
      mapEntryCount = static_cast<uint32_t>( mapEntries_.size() );
      pMapEntries   = mapEntries_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 SpecializationInfo & setDataSize( size_t dataSize_ ) VULKAN_HPP_NOEXCEPT
    {
      dataSize = dataSize_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SpecializationInfo & setPData( const void * pData_ ) VULKAN_HPP_NOEXCEPT
    {
      pData = pData_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    template <typename T>
    SpecializationInfo & setData( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const T> const & data_ ) VULKAN_HPP_NOEXCEPT
    {
      dataSize = data_.size() * sizeof( T );
      pData    = data_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkSpecializationInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkSpecializationInfo *>( this );
    }

    operator VkSpecializationInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkSpecializationInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &, const VULKAN_HPP_NAMESPACE::SpecializationMapEntry * const &, size_t const &, const void * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( mapEntryCount, pMapEntries, dataSize, pData );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( SpecializationInfo const & ) const = default;
#else
    bool operator==( SpecializationInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( mapEntryCount == rhs.mapEntryCount ) && ( pMapEntries == rhs.pMapEntries ) && ( dataSize == rhs.dataSize ) && ( pData == rhs.pData );
#  endif
    }

    bool operator!=( SpecializationInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t                                             mapEntryCount = {};
    const VULKAN_HPP_NAMESPACE::SpecializationMapEntry * pMapEntries   = {};
    size_t                                               dataSize      = {};
    const void *                                         pData         = {};
  };

  struct PipelineShaderStageCreateInfo
  {
    using NativeType = VkPipelineShaderStageCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::ePipelineShaderStageCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR PipelineShaderStageCreateInfo( VULKAN_HPP_NAMESPACE::PipelineShaderStageCreateFlags flags_ = {},
                                                        VULKAN_HPP_NAMESPACE::ShaderStageFlagBits stage_  = VULKAN_HPP_NAMESPACE::ShaderStageFlagBits::eVertex,
                                                        VULKAN_HPP_NAMESPACE::ShaderModule        module_ = {},
                                                        const char *                              pName_  = {},
                                                        const VULKAN_HPP_NAMESPACE::SpecializationInfo * pSpecializationInfo_ = {},
                                                        const void *                                     pNext_               = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , stage{ stage_ }
      , module{ module_ }
      , pName{ pName_ }
      , pSpecializationInfo{ pSpecializationInfo_ }
    {
    }

    VULKAN_HPP_CONSTEXPR PipelineShaderStageCreateInfo( PipelineShaderStageCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    PipelineShaderStageCreateInfo( VkPipelineShaderStageCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : PipelineShaderStageCreateInfo( *reinterpret_cast<PipelineShaderStageCreateInfo const *>( &rhs ) )
    {
    }

    PipelineShaderStageCreateInfo & operator=( PipelineShaderStageCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    PipelineShaderStageCreateInfo & operator=( VkPipelineShaderStageCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::PipelineShaderStageCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 PipelineShaderStageCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineShaderStageCreateInfo & setFlags( VULKAN_HPP_NAMESPACE::PipelineShaderStageCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineShaderStageCreateInfo & setStage( VULKAN_HPP_NAMESPACE::ShaderStageFlagBits stage_ ) VULKAN_HPP_NOEXCEPT
    {
      stage = stage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineShaderStageCreateInfo & setModule( VULKAN_HPP_NAMESPACE::ShaderModule module_ ) VULKAN_HPP_NOEXCEPT
    {
      module = module_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineShaderStageCreateInfo & setPName( const char * pName_ ) VULKAN_HPP_NOEXCEPT
    {
      pName = pName_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineShaderStageCreateInfo &
      setPSpecializationInfo( const VULKAN_HPP_NAMESPACE::SpecializationInfo * pSpecializationInfo_ ) VULKAN_HPP_NOEXCEPT
    {
      pSpecializationInfo = pSpecializationInfo_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkPipelineShaderStageCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkPipelineShaderStageCreateInfo *>( this );
    }

    operator VkPipelineShaderStageCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkPipelineShaderStageCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::PipelineShaderStageCreateFlags const &,
               VULKAN_HPP_NAMESPACE::ShaderStageFlagBits const &,
               VULKAN_HPP_NAMESPACE::ShaderModule const &,
               const char * const &,
               const VULKAN_HPP_NAMESPACE::SpecializationInfo * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, stage, module, pName, pSpecializationInfo );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    std::strong_ordering operator<=>( PipelineShaderStageCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      if ( auto cmp = sType <=> rhs.sType; cmp != 0 )
        return cmp;
      if ( auto cmp = pNext <=> rhs.pNext; cmp != 0 )
        return cmp;
      if ( auto cmp = flags <=> rhs.flags; cmp != 0 )
        return cmp;
      if ( auto cmp = stage <=> rhs.stage; cmp != 0 )
        return cmp;
      if ( auto cmp = module <=> rhs.module; cmp != 0 )
        return cmp;
      if ( pName != rhs.pName )
        if ( auto cmp = strcmp( pName, rhs.pName ); cmp != 0 )
          return ( cmp < 0 ) ? std::strong_ordering::less : std::strong_ordering::greater;
      if ( auto cmp = pSpecializationInfo <=> rhs.pSpecializationInfo; cmp != 0 )
        return cmp;

      return std::strong_ordering::equivalent;
    }
#endif

    bool operator==( PipelineShaderStageCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( stage == rhs.stage ) && ( module == rhs.module ) &&
             ( ( pName == rhs.pName ) || ( strcmp( pName, rhs.pName ) == 0 ) ) && ( pSpecializationInfo == rhs.pSpecializationInfo );
    }

    bool operator!=( PipelineShaderStageCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }

  public:
    VULKAN_HPP_NAMESPACE::StructureType                  sType               = StructureType::ePipelineShaderStageCreateInfo;
    const void *                                         pNext               = {};
    VULKAN_HPP_NAMESPACE::PipelineShaderStageCreateFlags flags               = {};
    VULKAN_HPP_NAMESPACE::ShaderStageFlagBits            stage               = VULKAN_HPP_NAMESPACE::ShaderStageFlagBits::eVertex;
    VULKAN_HPP_NAMESPACE::ShaderModule                   module              = {};
    const char *                                         pName               = {};
    const VULKAN_HPP_NAMESPACE::SpecializationInfo *     pSpecializationInfo = {};
  };

  template <>
  struct CppType<StructureType, StructureType::ePipelineShaderStageCreateInfo>
  {
    using Type = PipelineShaderStageCreateInfo;
  };

  struct ComputePipelineCreateInfo
  {
    using NativeType = VkComputePipelineCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eComputePipelineCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ComputePipelineCreateInfo( VULKAN_HPP_NAMESPACE::PipelineCreateFlags           flags_              = {},
                                                    VULKAN_HPP_NAMESPACE::PipelineShaderStageCreateInfo stage_              = {},
                                                    VULKAN_HPP_NAMESPACE::PipelineLayout                layout_             = {},
                                                    VULKAN_HPP_NAMESPACE::Pipeline                      basePipelineHandle_ = {},
                                                    int32_t                                             basePipelineIndex_  = {},
                                                    const void *                                        pNext_              = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , stage{ stage_ }
      , layout{ layout_ }
      , basePipelineHandle{ basePipelineHandle_ }
      , basePipelineIndex{ basePipelineIndex_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ComputePipelineCreateInfo( ComputePipelineCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ComputePipelineCreateInfo( VkComputePipelineCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : ComputePipelineCreateInfo( *reinterpret_cast<ComputePipelineCreateInfo const *>( &rhs ) )
    {
    }

    ComputePipelineCreateInfo & operator=( ComputePipelineCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ComputePipelineCreateInfo & operator=( VkComputePipelineCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ComputePipelineCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ComputePipelineCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ComputePipelineCreateInfo & setFlags( VULKAN_HPP_NAMESPACE::PipelineCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ComputePipelineCreateInfo & setStage( VULKAN_HPP_NAMESPACE::PipelineShaderStageCreateInfo const & stage_ ) VULKAN_HPP_NOEXCEPT
    {
      stage = stage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ComputePipelineCreateInfo & setLayout( VULKAN_HPP_NAMESPACE::PipelineLayout layout_ ) VULKAN_HPP_NOEXCEPT
    {
      layout = layout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ComputePipelineCreateInfo & setBasePipelineHandle( VULKAN_HPP_NAMESPACE::Pipeline basePipelineHandle_ ) VULKAN_HPP_NOEXCEPT
    {
      basePipelineHandle = basePipelineHandle_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ComputePipelineCreateInfo & setBasePipelineIndex( int32_t basePipelineIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      basePipelineIndex = basePipelineIndex_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkComputePipelineCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkComputePipelineCreateInfo *>( this );
    }

    operator VkComputePipelineCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkComputePipelineCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::PipelineCreateFlags const &,
               VULKAN_HPP_NAMESPACE::PipelineShaderStageCreateInfo const &,
               VULKAN_HPP_NAMESPACE::PipelineLayout const &,
               VULKAN_HPP_NAMESPACE::Pipeline const &,
               int32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, stage, layout, basePipelineHandle, basePipelineIndex );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ComputePipelineCreateInfo const & ) const = default;
#else
    bool operator==( ComputePipelineCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( stage == rhs.stage ) && ( layout == rhs.layout ) &&
             ( basePipelineHandle == rhs.basePipelineHandle ) && ( basePipelineIndex == rhs.basePipelineIndex );
#  endif
    }

    bool operator!=( ComputePipelineCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                 sType              = StructureType::eComputePipelineCreateInfo;
    const void *                                        pNext              = {};
    VULKAN_HPP_NAMESPACE::PipelineCreateFlags           flags              = {};
    VULKAN_HPP_NAMESPACE::PipelineShaderStageCreateInfo stage              = {};
    VULKAN_HPP_NAMESPACE::PipelineLayout                layout             = {};
    VULKAN_HPP_NAMESPACE::Pipeline                      basePipelineHandle = {};
    int32_t                                             basePipelineIndex  = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eComputePipelineCreateInfo>
  {
    using Type = ComputePipelineCreateInfo;
  };

  struct ConformanceVersion
  {
    using NativeType = VkConformanceVersion;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ConformanceVersion( uint8_t major_ = {}, uint8_t minor_ = {}, uint8_t subminor_ = {}, uint8_t patch_ = {} ) VULKAN_HPP_NOEXCEPT
      : major{ major_ }
      , minor{ minor_ }
      , subminor{ subminor_ }
      , patch{ patch_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ConformanceVersion( ConformanceVersion const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ConformanceVersion( VkConformanceVersion const & rhs ) VULKAN_HPP_NOEXCEPT : ConformanceVersion( *reinterpret_cast<ConformanceVersion const *>( &rhs ) ) {}

    ConformanceVersion & operator=( ConformanceVersion const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ConformanceVersion & operator=( VkConformanceVersion const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ConformanceVersion const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ConformanceVersion & setMajor( uint8_t major_ ) VULKAN_HPP_NOEXCEPT
    {
      major = major_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConformanceVersion & setMinor( uint8_t minor_ ) VULKAN_HPP_NOEXCEPT
    {
      minor = minor_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConformanceVersion & setSubminor( uint8_t subminor_ ) VULKAN_HPP_NOEXCEPT
    {
      subminor = subminor_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConformanceVersion & setPatch( uint8_t patch_ ) VULKAN_HPP_NOEXCEPT
    {
      patch = patch_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkConformanceVersion const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkConformanceVersion *>( this );
    }

    operator VkConformanceVersion &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkConformanceVersion *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint8_t const &, uint8_t const &, uint8_t const &, uint8_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( major, minor, subminor, patch );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ConformanceVersion const & ) const = default;
#else
    bool operator==( ConformanceVersion const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( major == rhs.major ) && ( minor == rhs.minor ) && ( subminor == rhs.subminor ) && ( patch == rhs.patch );
#  endif
    }

    bool operator!=( ConformanceVersion const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint8_t major    = {};
    uint8_t minor    = {};
    uint8_t subminor = {};
    uint8_t patch    = {};
  };

  using ConformanceVersionKHR = ConformanceVersion;

  struct CopyBufferInfo2
  {
    using NativeType = VkCopyBufferInfo2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCopyBufferInfo2;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CopyBufferInfo2( VULKAN_HPP_NAMESPACE::Buffer              srcBuffer_   = {},
                                          VULKAN_HPP_NAMESPACE::Buffer              dstBuffer_   = {},
                                          uint32_t                                  regionCount_ = {},
                                          const VULKAN_HPP_NAMESPACE::BufferCopy2 * pRegions_    = {},
                                          const void *                              pNext_       = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , srcBuffer{ srcBuffer_ }
      , dstBuffer{ dstBuffer_ }
      , regionCount{ regionCount_ }
      , pRegions{ pRegions_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CopyBufferInfo2( CopyBufferInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyBufferInfo2( VkCopyBufferInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT : CopyBufferInfo2( *reinterpret_cast<CopyBufferInfo2 const *>( &rhs ) ) {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyBufferInfo2( VULKAN_HPP_NAMESPACE::Buffer                                                                   srcBuffer_,
                     VULKAN_HPP_NAMESPACE::Buffer                                                                   dstBuffer_,
                     VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::BufferCopy2> const & regions_,
                     const void *                                                                                   pNext_ = nullptr )
      : pNext( pNext_ ), srcBuffer( srcBuffer_ ), dstBuffer( dstBuffer_ ), regionCount( static_cast<uint32_t>( regions_.size() ) ), pRegions( regions_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    CopyBufferInfo2 & operator=( CopyBufferInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CopyBufferInfo2 & operator=( VkCopyBufferInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CopyBufferInfo2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyBufferInfo2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyBufferInfo2 & setSrcBuffer( VULKAN_HPP_NAMESPACE::Buffer srcBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      srcBuffer = srcBuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyBufferInfo2 & setDstBuffer( VULKAN_HPP_NAMESPACE::Buffer dstBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      dstBuffer = dstBuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyBufferInfo2 & setRegionCount( uint32_t regionCount_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = regionCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyBufferInfo2 & setPRegions( const VULKAN_HPP_NAMESPACE::BufferCopy2 * pRegions_ ) VULKAN_HPP_NOEXCEPT
    {
      pRegions = pRegions_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyBufferInfo2 & setRegions( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::BufferCopy2> const & regions_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = static_cast<uint32_t>( regions_.size() );
      pRegions    = regions_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkCopyBufferInfo2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyBufferInfo2 *>( this );
    }

    operator VkCopyBufferInfo2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyBufferInfo2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::Buffer const &,
               VULKAN_HPP_NAMESPACE::Buffer const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::BufferCopy2 * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, srcBuffer, dstBuffer, regionCount, pRegions );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CopyBufferInfo2 const & ) const = default;
#else
    bool operator==( CopyBufferInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcBuffer == rhs.srcBuffer ) && ( dstBuffer == rhs.dstBuffer ) &&
             ( regionCount == rhs.regionCount ) && ( pRegions == rhs.pRegions );
#  endif
    }

    bool operator!=( CopyBufferInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType       sType       = StructureType::eCopyBufferInfo2;
    const void *                              pNext       = {};
    VULKAN_HPP_NAMESPACE::Buffer              srcBuffer   = {};
    VULKAN_HPP_NAMESPACE::Buffer              dstBuffer   = {};
    uint32_t                                  regionCount = {};
    const VULKAN_HPP_NAMESPACE::BufferCopy2 * pRegions    = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCopyBufferInfo2>
  {
    using Type = CopyBufferInfo2;
  };

  using CopyBufferInfo2KHR = CopyBufferInfo2;

  struct CopyBufferToImageInfo2
  {
    using NativeType = VkCopyBufferToImageInfo2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCopyBufferToImageInfo2;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CopyBufferToImageInfo2( VULKAN_HPP_NAMESPACE::Buffer                   srcBuffer_      = {},
                                                 VULKAN_HPP_NAMESPACE::Image                    dstImage_       = {},
                                                 VULKAN_HPP_NAMESPACE::ImageLayout              dstImageLayout_ = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                                                 uint32_t                                       regionCount_    = {},
                                                 const VULKAN_HPP_NAMESPACE::BufferImageCopy2 * pRegions_       = {},
                                                 const void *                                   pNext_          = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , srcBuffer{ srcBuffer_ }
      , dstImage{ dstImage_ }
      , dstImageLayout{ dstImageLayout_ }
      , regionCount{ regionCount_ }
      , pRegions{ pRegions_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CopyBufferToImageInfo2( CopyBufferToImageInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyBufferToImageInfo2( VkCopyBufferToImageInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT
      : CopyBufferToImageInfo2( *reinterpret_cast<CopyBufferToImageInfo2 const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyBufferToImageInfo2( VULKAN_HPP_NAMESPACE::Buffer                                                                        srcBuffer_,
                            VULKAN_HPP_NAMESPACE::Image                                                                         dstImage_,
                            VULKAN_HPP_NAMESPACE::ImageLayout                                                                   dstImageLayout_,
                            VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::BufferImageCopy2> const & regions_,
                            const void *                                                                                        pNext_ = nullptr )
      : pNext( pNext_ )
      , srcBuffer( srcBuffer_ )
      , dstImage( dstImage_ )
      , dstImageLayout( dstImageLayout_ )
      , regionCount( static_cast<uint32_t>( regions_.size() ) )
      , pRegions( regions_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    CopyBufferToImageInfo2 & operator=( CopyBufferToImageInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CopyBufferToImageInfo2 & operator=( VkCopyBufferToImageInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CopyBufferToImageInfo2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyBufferToImageInfo2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyBufferToImageInfo2 & setSrcBuffer( VULKAN_HPP_NAMESPACE::Buffer srcBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      srcBuffer = srcBuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyBufferToImageInfo2 & setDstImage( VULKAN_HPP_NAMESPACE::Image dstImage_ ) VULKAN_HPP_NOEXCEPT
    {
      dstImage = dstImage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyBufferToImageInfo2 & setDstImageLayout( VULKAN_HPP_NAMESPACE::ImageLayout dstImageLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      dstImageLayout = dstImageLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyBufferToImageInfo2 & setRegionCount( uint32_t regionCount_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = regionCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyBufferToImageInfo2 & setPRegions( const VULKAN_HPP_NAMESPACE::BufferImageCopy2 * pRegions_ ) VULKAN_HPP_NOEXCEPT
    {
      pRegions = pRegions_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyBufferToImageInfo2 &
      setRegions( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::BufferImageCopy2> const & regions_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = static_cast<uint32_t>( regions_.size() );
      pRegions    = regions_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkCopyBufferToImageInfo2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyBufferToImageInfo2 *>( this );
    }

    operator VkCopyBufferToImageInfo2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyBufferToImageInfo2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::Buffer const &,
               VULKAN_HPP_NAMESPACE::Image const &,
               VULKAN_HPP_NAMESPACE::ImageLayout const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::BufferImageCopy2 * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, srcBuffer, dstImage, dstImageLayout, regionCount, pRegions );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CopyBufferToImageInfo2 const & ) const = default;
#else
    bool operator==( CopyBufferToImageInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcBuffer == rhs.srcBuffer ) && ( dstImage == rhs.dstImage ) &&
             ( dstImageLayout == rhs.dstImageLayout ) && ( regionCount == rhs.regionCount ) && ( pRegions == rhs.pRegions );
#  endif
    }

    bool operator!=( CopyBufferToImageInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType            sType          = StructureType::eCopyBufferToImageInfo2;
    const void *                                   pNext          = {};
    VULKAN_HPP_NAMESPACE::Buffer                   srcBuffer      = {};
    VULKAN_HPP_NAMESPACE::Image                    dstImage       = {};
    VULKAN_HPP_NAMESPACE::ImageLayout              dstImageLayout = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    uint32_t                                       regionCount    = {};
    const VULKAN_HPP_NAMESPACE::BufferImageCopy2 * pRegions       = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCopyBufferToImageInfo2>
  {
    using Type = CopyBufferToImageInfo2;
  };

  using CopyBufferToImageInfo2KHR = CopyBufferToImageInfo2;

  struct CopyDescriptorSet
  {
    using NativeType = VkCopyDescriptorSet;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCopyDescriptorSet;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CopyDescriptorSet( VULKAN_HPP_NAMESPACE::DescriptorSet srcSet_          = {},
                                            uint32_t                            srcBinding_      = {},
                                            uint32_t                            srcArrayElement_ = {},
                                            VULKAN_HPP_NAMESPACE::DescriptorSet dstSet_          = {},
                                            uint32_t                            dstBinding_      = {},
                                            uint32_t                            dstArrayElement_ = {},
                                            uint32_t                            descriptorCount_ = {},
                                            const void *                        pNext_           = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , srcSet{ srcSet_ }
      , srcBinding{ srcBinding_ }
      , srcArrayElement{ srcArrayElement_ }
      , dstSet{ dstSet_ }
      , dstBinding{ dstBinding_ }
      , dstArrayElement{ dstArrayElement_ }
      , descriptorCount{ descriptorCount_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CopyDescriptorSet( CopyDescriptorSet const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyDescriptorSet( VkCopyDescriptorSet const & rhs ) VULKAN_HPP_NOEXCEPT : CopyDescriptorSet( *reinterpret_cast<CopyDescriptorSet const *>( &rhs ) ) {}

    CopyDescriptorSet & operator=( CopyDescriptorSet const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CopyDescriptorSet & operator=( VkCopyDescriptorSet const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CopyDescriptorSet const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyDescriptorSet & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyDescriptorSet & setSrcSet( VULKAN_HPP_NAMESPACE::DescriptorSet srcSet_ ) VULKAN_HPP_NOEXCEPT
    {
      srcSet = srcSet_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyDescriptorSet & setSrcBinding( uint32_t srcBinding_ ) VULKAN_HPP_NOEXCEPT
    {
      srcBinding = srcBinding_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyDescriptorSet & setSrcArrayElement( uint32_t srcArrayElement_ ) VULKAN_HPP_NOEXCEPT
    {
      srcArrayElement = srcArrayElement_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyDescriptorSet & setDstSet( VULKAN_HPP_NAMESPACE::DescriptorSet dstSet_ ) VULKAN_HPP_NOEXCEPT
    {
      dstSet = dstSet_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyDescriptorSet & setDstBinding( uint32_t dstBinding_ ) VULKAN_HPP_NOEXCEPT
    {
      dstBinding = dstBinding_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyDescriptorSet & setDstArrayElement( uint32_t dstArrayElement_ ) VULKAN_HPP_NOEXCEPT
    {
      dstArrayElement = dstArrayElement_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyDescriptorSet & setDescriptorCount( uint32_t descriptorCount_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorCount = descriptorCount_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkCopyDescriptorSet const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyDescriptorSet *>( this );
    }

    operator VkCopyDescriptorSet &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyDescriptorSet *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::DescriptorSet const &,
               uint32_t const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::DescriptorSet const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, srcSet, srcBinding, srcArrayElement, dstSet, dstBinding, dstArrayElement, descriptorCount );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CopyDescriptorSet const & ) const = default;
#else
    bool operator==( CopyDescriptorSet const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcSet == rhs.srcSet ) && ( srcBinding == rhs.srcBinding ) &&
             ( srcArrayElement == rhs.srcArrayElement ) && ( dstSet == rhs.dstSet ) && ( dstBinding == rhs.dstBinding ) &&
             ( dstArrayElement == rhs.dstArrayElement ) && ( descriptorCount == rhs.descriptorCount );
#  endif
    }

    bool operator!=( CopyDescriptorSet const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType           = StructureType::eCopyDescriptorSet;
    const void *                        pNext           = {};
    VULKAN_HPP_NAMESPACE::DescriptorSet srcSet          = {};
    uint32_t                            srcBinding      = {};
    uint32_t                            srcArrayElement = {};
    VULKAN_HPP_NAMESPACE::DescriptorSet dstSet          = {};
    uint32_t                            dstBinding      = {};
    uint32_t                            dstArrayElement = {};
    uint32_t                            descriptorCount = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCopyDescriptorSet>
  {
    using Type = CopyDescriptorSet;
  };

  struct ImageCopy2
  {
    using NativeType = VkImageCopy2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eImageCopy2;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ImageCopy2( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers srcSubresource_ = {},
                                     VULKAN_HPP_NAMESPACE::Offset3D               srcOffset_      = {},
                                     VULKAN_HPP_NAMESPACE::ImageSubresourceLayers dstSubresource_ = {},
                                     VULKAN_HPP_NAMESPACE::Offset3D               dstOffset_      = {},
                                     VULKAN_HPP_NAMESPACE::Extent3D               extent_         = {},
                                     const void *                                 pNext_          = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , srcSubresource{ srcSubresource_ }
      , srcOffset{ srcOffset_ }
      , dstSubresource{ dstSubresource_ }
      , dstOffset{ dstOffset_ }
      , extent{ extent_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ImageCopy2( ImageCopy2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageCopy2( VkImageCopy2 const & rhs ) VULKAN_HPP_NOEXCEPT : ImageCopy2( *reinterpret_cast<ImageCopy2 const *>( &rhs ) ) {}

    ImageCopy2 & operator=( ImageCopy2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ImageCopy2 & operator=( VkImageCopy2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ImageCopy2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ImageCopy2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageCopy2 & setSrcSubresource( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const & srcSubresource_ ) VULKAN_HPP_NOEXCEPT
    {
      srcSubresource = srcSubresource_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageCopy2 & setSrcOffset( VULKAN_HPP_NAMESPACE::Offset3D const & srcOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      srcOffset = srcOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageCopy2 & setDstSubresource( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const & dstSubresource_ ) VULKAN_HPP_NOEXCEPT
    {
      dstSubresource = dstSubresource_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageCopy2 & setDstOffset( VULKAN_HPP_NAMESPACE::Offset3D const & dstOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      dstOffset = dstOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageCopy2 & setExtent( VULKAN_HPP_NAMESPACE::Extent3D const & extent_ ) VULKAN_HPP_NOEXCEPT
    {
      extent = extent_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkImageCopy2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkImageCopy2 *>( this );
    }

    operator VkImageCopy2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkImageCopy2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const &,
               VULKAN_HPP_NAMESPACE::Offset3D const &,
               VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const &,
               VULKAN_HPP_NAMESPACE::Offset3D const &,
               VULKAN_HPP_NAMESPACE::Extent3D const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, srcSubresource, srcOffset, dstSubresource, dstOffset, extent );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ImageCopy2 const & ) const = default;
#else
    bool operator==( ImageCopy2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcSubresource == rhs.srcSubresource ) && ( srcOffset == rhs.srcOffset ) &&
             ( dstSubresource == rhs.dstSubresource ) && ( dstOffset == rhs.dstOffset ) && ( extent == rhs.extent );
#  endif
    }

    bool operator!=( ImageCopy2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType          sType          = StructureType::eImageCopy2;
    const void *                                 pNext          = {};
    VULKAN_HPP_NAMESPACE::ImageSubresourceLayers srcSubresource = {};
    VULKAN_HPP_NAMESPACE::Offset3D               srcOffset      = {};
    VULKAN_HPP_NAMESPACE::ImageSubresourceLayers dstSubresource = {};
    VULKAN_HPP_NAMESPACE::Offset3D               dstOffset      = {};
    VULKAN_HPP_NAMESPACE::Extent3D               extent         = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eImageCopy2>
  {
    using Type = ImageCopy2;
  };

  using ImageCopy2KHR = ImageCopy2;

  struct CopyImageInfo2
  {
    using NativeType = VkCopyImageInfo2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCopyImageInfo2;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CopyImageInfo2( VULKAN_HPP_NAMESPACE::Image              srcImage_       = {},
                                         VULKAN_HPP_NAMESPACE::ImageLayout        srcImageLayout_ = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                                         VULKAN_HPP_NAMESPACE::Image              dstImage_       = {},
                                         VULKAN_HPP_NAMESPACE::ImageLayout        dstImageLayout_ = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                                         uint32_t                                 regionCount_    = {},
                                         const VULKAN_HPP_NAMESPACE::ImageCopy2 * pRegions_       = {},
                                         const void *                             pNext_          = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , srcImage{ srcImage_ }
      , srcImageLayout{ srcImageLayout_ }
      , dstImage{ dstImage_ }
      , dstImageLayout{ dstImageLayout_ }
      , regionCount{ regionCount_ }
      , pRegions{ pRegions_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CopyImageInfo2( CopyImageInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyImageInfo2( VkCopyImageInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT : CopyImageInfo2( *reinterpret_cast<CopyImageInfo2 const *>( &rhs ) ) {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyImageInfo2( VULKAN_HPP_NAMESPACE::Image                                                                   srcImage_,
                    VULKAN_HPP_NAMESPACE::ImageLayout                                                             srcImageLayout_,
                    VULKAN_HPP_NAMESPACE::Image                                                                   dstImage_,
                    VULKAN_HPP_NAMESPACE::ImageLayout                                                             dstImageLayout_,
                    VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::ImageCopy2> const & regions_,
                    const void *                                                                                  pNext_ = nullptr )
      : pNext( pNext_ )
      , srcImage( srcImage_ )
      , srcImageLayout( srcImageLayout_ )
      , dstImage( dstImage_ )
      , dstImageLayout( dstImageLayout_ )
      , regionCount( static_cast<uint32_t>( regions_.size() ) )
      , pRegions( regions_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    CopyImageInfo2 & operator=( CopyImageInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CopyImageInfo2 & operator=( VkCopyImageInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CopyImageInfo2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyImageInfo2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageInfo2 & setSrcImage( VULKAN_HPP_NAMESPACE::Image srcImage_ ) VULKAN_HPP_NOEXCEPT
    {
      srcImage = srcImage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageInfo2 & setSrcImageLayout( VULKAN_HPP_NAMESPACE::ImageLayout srcImageLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      srcImageLayout = srcImageLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageInfo2 & setDstImage( VULKAN_HPP_NAMESPACE::Image dstImage_ ) VULKAN_HPP_NOEXCEPT
    {
      dstImage = dstImage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageInfo2 & setDstImageLayout( VULKAN_HPP_NAMESPACE::ImageLayout dstImageLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      dstImageLayout = dstImageLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageInfo2 & setRegionCount( uint32_t regionCount_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = regionCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageInfo2 & setPRegions( const VULKAN_HPP_NAMESPACE::ImageCopy2 * pRegions_ ) VULKAN_HPP_NOEXCEPT
    {
      pRegions = pRegions_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyImageInfo2 & setRegions( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::ImageCopy2> const & regions_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = static_cast<uint32_t>( regions_.size() );
      pRegions    = regions_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkCopyImageInfo2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyImageInfo2 *>( this );
    }

    operator VkCopyImageInfo2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyImageInfo2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::Image const &,
               VULKAN_HPP_NAMESPACE::ImageLayout const &,
               VULKAN_HPP_NAMESPACE::Image const &,
               VULKAN_HPP_NAMESPACE::ImageLayout const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::ImageCopy2 * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CopyImageInfo2 const & ) const = default;
#else
    bool operator==( CopyImageInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcImage == rhs.srcImage ) && ( srcImageLayout == rhs.srcImageLayout ) &&
             ( dstImage == rhs.dstImage ) && ( dstImageLayout == rhs.dstImageLayout ) && ( regionCount == rhs.regionCount ) && ( pRegions == rhs.pRegions );
#  endif
    }

    bool operator!=( CopyImageInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType      sType          = StructureType::eCopyImageInfo2;
    const void *                             pNext          = {};
    VULKAN_HPP_NAMESPACE::Image              srcImage       = {};
    VULKAN_HPP_NAMESPACE::ImageLayout        srcImageLayout = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    VULKAN_HPP_NAMESPACE::Image              dstImage       = {};
    VULKAN_HPP_NAMESPACE::ImageLayout        dstImageLayout = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    uint32_t                                 regionCount    = {};
    const VULKAN_HPP_NAMESPACE::ImageCopy2 * pRegions       = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCopyImageInfo2>
  {
    using Type = CopyImageInfo2;
  };

  using CopyImageInfo2KHR = CopyImageInfo2;

  struct CopyImageToBufferInfo2
  {
    using NativeType = VkCopyImageToBufferInfo2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCopyImageToBufferInfo2;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CopyImageToBufferInfo2( VULKAN_HPP_NAMESPACE::Image                    srcImage_       = {},
                                                 VULKAN_HPP_NAMESPACE::ImageLayout              srcImageLayout_ = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                                                 VULKAN_HPP_NAMESPACE::Buffer                   dstBuffer_      = {},
                                                 uint32_t                                       regionCount_    = {},
                                                 const VULKAN_HPP_NAMESPACE::BufferImageCopy2 * pRegions_       = {},
                                                 const void *                                   pNext_          = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , srcImage{ srcImage_ }
      , srcImageLayout{ srcImageLayout_ }
      , dstBuffer{ dstBuffer_ }
      , regionCount{ regionCount_ }
      , pRegions{ pRegions_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CopyImageToBufferInfo2( CopyImageToBufferInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyImageToBufferInfo2( VkCopyImageToBufferInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT
      : CopyImageToBufferInfo2( *reinterpret_cast<CopyImageToBufferInfo2 const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyImageToBufferInfo2( VULKAN_HPP_NAMESPACE::Image                                                                         srcImage_,
                            VULKAN_HPP_NAMESPACE::ImageLayout                                                                   srcImageLayout_,
                            VULKAN_HPP_NAMESPACE::Buffer                                                                        dstBuffer_,
                            VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::BufferImageCopy2> const & regions_,
                            const void *                                                                                        pNext_ = nullptr )
      : pNext( pNext_ )
      , srcImage( srcImage_ )
      , srcImageLayout( srcImageLayout_ )
      , dstBuffer( dstBuffer_ )
      , regionCount( static_cast<uint32_t>( regions_.size() ) )
      , pRegions( regions_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    CopyImageToBufferInfo2 & operator=( CopyImageToBufferInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CopyImageToBufferInfo2 & operator=( VkCopyImageToBufferInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CopyImageToBufferInfo2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyImageToBufferInfo2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageToBufferInfo2 & setSrcImage( VULKAN_HPP_NAMESPACE::Image srcImage_ ) VULKAN_HPP_NOEXCEPT
    {
      srcImage = srcImage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageToBufferInfo2 & setSrcImageLayout( VULKAN_HPP_NAMESPACE::ImageLayout srcImageLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      srcImageLayout = srcImageLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageToBufferInfo2 & setDstBuffer( VULKAN_HPP_NAMESPACE::Buffer dstBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      dstBuffer = dstBuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageToBufferInfo2 & setRegionCount( uint32_t regionCount_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = regionCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageToBufferInfo2 & setPRegions( const VULKAN_HPP_NAMESPACE::BufferImageCopy2 * pRegions_ ) VULKAN_HPP_NOEXCEPT
    {
      pRegions = pRegions_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyImageToBufferInfo2 &
      setRegions( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::BufferImageCopy2> const & regions_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = static_cast<uint32_t>( regions_.size() );
      pRegions    = regions_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkCopyImageToBufferInfo2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyImageToBufferInfo2 *>( this );
    }

    operator VkCopyImageToBufferInfo2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyImageToBufferInfo2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::Image const &,
               VULKAN_HPP_NAMESPACE::ImageLayout const &,
               VULKAN_HPP_NAMESPACE::Buffer const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::BufferImageCopy2 * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, srcImage, srcImageLayout, dstBuffer, regionCount, pRegions );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CopyImageToBufferInfo2 const & ) const = default;
#else
    bool operator==( CopyImageToBufferInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcImage == rhs.srcImage ) && ( srcImageLayout == rhs.srcImageLayout ) &&
             ( dstBuffer == rhs.dstBuffer ) && ( regionCount == rhs.regionCount ) && ( pRegions == rhs.pRegions );
#  endif
    }

    bool operator!=( CopyImageToBufferInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType            sType          = StructureType::eCopyImageToBufferInfo2;
    const void *                                   pNext          = {};
    VULKAN_HPP_NAMESPACE::Image                    srcImage       = {};
    VULKAN_HPP_NAMESPACE::ImageLayout              srcImageLayout = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    VULKAN_HPP_NAMESPACE::Buffer                   dstBuffer      = {};
    uint32_t                                       regionCount    = {};
    const VULKAN_HPP_NAMESPACE::BufferImageCopy2 * pRegions       = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCopyImageToBufferInfo2>
  {
    using Type = CopyImageToBufferInfo2;
  };

  using CopyImageToBufferInfo2KHR = CopyImageToBufferInfo2;

  struct DebugUtilsLabelEXT
  {
    using NativeType = VkDebugUtilsLabelEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDebugUtilsLabelEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14
      DebugUtilsLabelEXT( const char * pLabelName_ = {}, std::array<float, 4> const & color_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , pLabelName{ pLabelName_ }
      , color{ color_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsLabelEXT( DebugUtilsLabelEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DebugUtilsLabelEXT( VkDebugUtilsLabelEXT const & rhs ) VULKAN_HPP_NOEXCEPT : DebugUtilsLabelEXT( *reinterpret_cast<DebugUtilsLabelEXT const *>( &rhs ) ) {}

    DebugUtilsLabelEXT & operator=( DebugUtilsLabelEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DebugUtilsLabelEXT & operator=( VkDebugUtilsLabelEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DebugUtilsLabelEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DebugUtilsLabelEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsLabelEXT & setPLabelName( const char * pLabelName_ ) VULKAN_HPP_NOEXCEPT
    {
      pLabelName = pLabelName_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsLabelEXT & setColor( std::array<float, 4> color_ ) VULKAN_HPP_NOEXCEPT
    {
      color = color_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDebugUtilsLabelEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDebugUtilsLabelEXT *>( this );
    }

    operator VkDebugUtilsLabelEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDebugUtilsLabelEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, const char * const &, VULKAN_HPP_NAMESPACE::ArrayWrapper1D<float, 4> const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, pLabelName, color );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    std::partial_ordering operator<=>( DebugUtilsLabelEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      if ( auto cmp = sType <=> rhs.sType; cmp != 0 )
        return cmp;
      if ( auto cmp = pNext <=> rhs.pNext; cmp != 0 )
        return cmp;
      if ( pLabelName != rhs.pLabelName )
        if ( auto cmp = strcmp( pLabelName, rhs.pLabelName ); cmp != 0 )
          return ( cmp < 0 ) ? std::partial_ordering::less : std::partial_ordering::greater;
      if ( auto cmp = color <=> rhs.color; cmp != 0 )
        return cmp;

      return std::partial_ordering::equivalent;
    }
#endif

    bool operator==( DebugUtilsLabelEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( ( pLabelName == rhs.pLabelName ) || ( strcmp( pLabelName, rhs.pLabelName ) == 0 ) ) &&
             ( color == rhs.color );
    }

    bool operator!=( DebugUtilsLabelEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }

  public:
    VULKAN_HPP_NAMESPACE::StructureType            sType      = StructureType::eDebugUtilsLabelEXT;
    const void *                                   pNext      = {};
    const char *                                   pLabelName = {};
    VULKAN_HPP_NAMESPACE::ArrayWrapper1D<float, 4> color      = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eDebugUtilsLabelEXT>
  {
    using Type = DebugUtilsLabelEXT;
  };

  struct DebugUtilsObjectNameInfoEXT
  {
    using NativeType = VkDebugUtilsObjectNameInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDebugUtilsObjectNameInfoEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DebugUtilsObjectNameInfoEXT( VULKAN_HPP_NAMESPACE::ObjectType objectType_   = VULKAN_HPP_NAMESPACE::ObjectType::eUnknown,
                                                      uint64_t                         objectHandle_ = {},
                                                      const char *                     pObjectName_  = {},
                                                      const void *                     pNext_        = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , objectType{ objectType_ }
      , objectHandle{ objectHandle_ }
      , pObjectName{ pObjectName_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DebugUtilsObjectNameInfoEXT( DebugUtilsObjectNameInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DebugUtilsObjectNameInfoEXT( VkDebugUtilsObjectNameInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : DebugUtilsObjectNameInfoEXT( *reinterpret_cast<DebugUtilsObjectNameInfoEXT const *>( &rhs ) )
    {
    }

    DebugUtilsObjectNameInfoEXT & operator=( DebugUtilsObjectNameInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DebugUtilsObjectNameInfoEXT & operator=( VkDebugUtilsObjectNameInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DebugUtilsObjectNameInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DebugUtilsObjectNameInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsObjectNameInfoEXT & setObjectType( VULKAN_HPP_NAMESPACE::ObjectType objectType_ ) VULKAN_HPP_NOEXCEPT
    {
      objectType = objectType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsObjectNameInfoEXT & setObjectHandle( uint64_t objectHandle_ ) VULKAN_HPP_NOEXCEPT
    {
      objectHandle = objectHandle_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsObjectNameInfoEXT & setPObjectName( const char * pObjectName_ ) VULKAN_HPP_NOEXCEPT
    {
      pObjectName = pObjectName_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDebugUtilsObjectNameInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDebugUtilsObjectNameInfoEXT *>( this );
    }

    operator VkDebugUtilsObjectNameInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDebugUtilsObjectNameInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::
      tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::ObjectType const &, uint64_t const &, const char * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, objectType, objectHandle, pObjectName );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    std::strong_ordering operator<=>( DebugUtilsObjectNameInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      if ( auto cmp = sType <=> rhs.sType; cmp != 0 )
        return cmp;
      if ( auto cmp = pNext <=> rhs.pNext; cmp != 0 )
        return cmp;
      if ( auto cmp = objectType <=> rhs.objectType; cmp != 0 )
        return cmp;
      if ( auto cmp = objectHandle <=> rhs.objectHandle; cmp != 0 )
        return cmp;
      if ( pObjectName != rhs.pObjectName )
        if ( auto cmp = strcmp( pObjectName, rhs.pObjectName ); cmp != 0 )
          return ( cmp < 0 ) ? std::strong_ordering::less : std::strong_ordering::greater;

      return std::strong_ordering::equivalent;
    }
#endif

    bool operator==( DebugUtilsObjectNameInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( objectType == rhs.objectType ) && ( objectHandle == rhs.objectHandle ) &&
             ( ( pObjectName == rhs.pObjectName ) || ( strcmp( pObjectName, rhs.pObjectName ) == 0 ) );
    }

    bool operator!=( DebugUtilsObjectNameInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType        = StructureType::eDebugUtilsObjectNameInfoEXT;
    const void *                        pNext        = {};
    VULKAN_HPP_NAMESPACE::ObjectType    objectType   = VULKAN_HPP_NAMESPACE::ObjectType::eUnknown;
    uint64_t                            objectHandle = {};
    const char *                        pObjectName  = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eDebugUtilsObjectNameInfoEXT>
  {
    using Type = DebugUtilsObjectNameInfoEXT;
  };

  struct DebugUtilsMessengerCallbackDataEXT
  {
    using NativeType = VkDebugUtilsMessengerCallbackDataEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDebugUtilsMessengerCallbackDataEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCallbackDataEXT( VULKAN_HPP_NAMESPACE::DebugUtilsMessengerCallbackDataFlagsEXT flags_            = {},
                                                                const char *                                                  pMessageIdName_   = {},
                                                                int32_t                                                       messageIdNumber_  = {},
                                                                const char *                                                  pMessage_         = {},
                                                                uint32_t                                                      queueLabelCount_  = {},
                                                                const VULKAN_HPP_NAMESPACE::DebugUtilsLabelEXT *              pQueueLabels_     = {},
                                                                uint32_t                                                      cmdBufLabelCount_ = {},
                                                                const VULKAN_HPP_NAMESPACE::DebugUtilsLabelEXT *              pCmdBufLabels_    = {},
                                                                uint32_t                                                      objectCount_      = {},
                                                                const VULKAN_HPP_NAMESPACE::DebugUtilsObjectNameInfoEXT *     pObjects_         = {},
                                                                const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , pMessageIdName{ pMessageIdName_ }
      , messageIdNumber{ messageIdNumber_ }
      , pMessage{ pMessage_ }
      , queueLabelCount{ queueLabelCount_ }
      , pQueueLabels{ pQueueLabels_ }
      , cmdBufLabelCount{ cmdBufLabelCount_ }
      , pCmdBufLabels{ pCmdBufLabels_ }
      , objectCount{ objectCount_ }
      , pObjects{ pObjects_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCallbackDataEXT( DebugUtilsMessengerCallbackDataEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DebugUtilsMessengerCallbackDataEXT( VkDebugUtilsMessengerCallbackDataEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : DebugUtilsMessengerCallbackDataEXT( *reinterpret_cast<DebugUtilsMessengerCallbackDataEXT const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DebugUtilsMessengerCallbackDataEXT(
      VULKAN_HPP_NAMESPACE::DebugUtilsMessengerCallbackDataFlagsEXT                                                  flags_,
      const char *                                                                                                   pMessageIdName_,
      int32_t                                                                                                        messageIdNumber_,
      const char *                                                                                                   pMessage_,
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DebugUtilsLabelEXT> const &          queueLabels_,
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DebugUtilsLabelEXT> const &          cmdBufLabels_ = {},
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DebugUtilsObjectNameInfoEXT> const & objects_      = {},
      const void *                                                                                                   pNext_        = nullptr )
      : pNext( pNext_ )
      , flags( flags_ )
      , pMessageIdName( pMessageIdName_ )
      , messageIdNumber( messageIdNumber_ )
      , pMessage( pMessage_ )
      , queueLabelCount( static_cast<uint32_t>( queueLabels_.size() ) )
      , pQueueLabels( queueLabels_.data() )
      , cmdBufLabelCount( static_cast<uint32_t>( cmdBufLabels_.size() ) )
      , pCmdBufLabels( cmdBufLabels_.data() )
      , objectCount( static_cast<uint32_t>( objects_.size() ) )
      , pObjects( objects_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    DebugUtilsMessengerCallbackDataEXT & operator=( DebugUtilsMessengerCallbackDataEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DebugUtilsMessengerCallbackDataEXT & operator=( VkDebugUtilsMessengerCallbackDataEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DebugUtilsMessengerCallbackDataEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCallbackDataEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCallbackDataEXT &
      setFlags( VULKAN_HPP_NAMESPACE::DebugUtilsMessengerCallbackDataFlagsEXT flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCallbackDataEXT & setPMessageIdName( const char * pMessageIdName_ ) VULKAN_HPP_NOEXCEPT
    {
      pMessageIdName = pMessageIdName_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCallbackDataEXT & setMessageIdNumber( int32_t messageIdNumber_ ) VULKAN_HPP_NOEXCEPT
    {
      messageIdNumber = messageIdNumber_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCallbackDataEXT & setPMessage( const char * pMessage_ ) VULKAN_HPP_NOEXCEPT
    {
      pMessage = pMessage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCallbackDataEXT & setQueueLabelCount( uint32_t queueLabelCount_ ) VULKAN_HPP_NOEXCEPT
    {
      queueLabelCount = queueLabelCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCallbackDataEXT &
      setPQueueLabels( const VULKAN_HPP_NAMESPACE::DebugUtilsLabelEXT * pQueueLabels_ ) VULKAN_HPP_NOEXCEPT
    {
      pQueueLabels = pQueueLabels_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DebugUtilsMessengerCallbackDataEXT &
      setQueueLabels( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DebugUtilsLabelEXT> const & queueLabels_ ) VULKAN_HPP_NOEXCEPT
    {
      queueLabelCount = static_cast<uint32_t>( queueLabels_.size() );
      pQueueLabels    = queueLabels_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCallbackDataEXT & setCmdBufLabelCount( uint32_t cmdBufLabelCount_ ) VULKAN_HPP_NOEXCEPT
    {
      cmdBufLabelCount = cmdBufLabelCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCallbackDataEXT &
      setPCmdBufLabels( const VULKAN_HPP_NAMESPACE::DebugUtilsLabelEXT * pCmdBufLabels_ ) VULKAN_HPP_NOEXCEPT
    {
      pCmdBufLabels = pCmdBufLabels_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DebugUtilsMessengerCallbackDataEXT &
      setCmdBufLabels( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DebugUtilsLabelEXT> const & cmdBufLabels_ ) VULKAN_HPP_NOEXCEPT
    {
      cmdBufLabelCount = static_cast<uint32_t>( cmdBufLabels_.size() );
      pCmdBufLabels    = cmdBufLabels_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCallbackDataEXT & setObjectCount( uint32_t objectCount_ ) VULKAN_HPP_NOEXCEPT
    {
      objectCount = objectCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCallbackDataEXT &
      setPObjects( const VULKAN_HPP_NAMESPACE::DebugUtilsObjectNameInfoEXT * pObjects_ ) VULKAN_HPP_NOEXCEPT
    {
      pObjects = pObjects_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DebugUtilsMessengerCallbackDataEXT &
      setObjects( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DebugUtilsObjectNameInfoEXT> const & objects_ ) VULKAN_HPP_NOEXCEPT
    {
      objectCount = static_cast<uint32_t>( objects_.size() );
      pObjects    = objects_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDebugUtilsMessengerCallbackDataEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDebugUtilsMessengerCallbackDataEXT *>( this );
    }

    operator VkDebugUtilsMessengerCallbackDataEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDebugUtilsMessengerCallbackDataEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::DebugUtilsMessengerCallbackDataFlagsEXT const &,
               const char * const &,
               int32_t const &,
               const char * const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::DebugUtilsLabelEXT * const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::DebugUtilsLabelEXT * const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::DebugUtilsObjectNameInfoEXT * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie(
        sType, pNext, flags, pMessageIdName, messageIdNumber, pMessage, queueLabelCount, pQueueLabels, cmdBufLabelCount, pCmdBufLabels, objectCount, pObjects );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    std::strong_ordering operator<=>( DebugUtilsMessengerCallbackDataEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      if ( auto cmp = sType <=> rhs.sType; cmp != 0 )
        return cmp;
      if ( auto cmp = pNext <=> rhs.pNext; cmp != 0 )
        return cmp;
      if ( auto cmp = flags <=> rhs.flags; cmp != 0 )
        return cmp;
      if ( pMessageIdName != rhs.pMessageIdName )
        if ( auto cmp = strcmp( pMessageIdName, rhs.pMessageIdName ); cmp != 0 )
          return ( cmp < 0 ) ? std::strong_ordering::less : std::strong_ordering::greater;
      if ( auto cmp = messageIdNumber <=> rhs.messageIdNumber; cmp != 0 )
        return cmp;
      if ( pMessage != rhs.pMessage )
        if ( auto cmp = strcmp( pMessage, rhs.pMessage ); cmp != 0 )
          return ( cmp < 0 ) ? std::strong_ordering::less : std::strong_ordering::greater;
      if ( auto cmp = queueLabelCount <=> rhs.queueLabelCount; cmp != 0 )
        return cmp;
      if ( auto cmp = pQueueLabels <=> rhs.pQueueLabels; cmp != 0 )
        return cmp;
      if ( auto cmp = cmdBufLabelCount <=> rhs.cmdBufLabelCount; cmp != 0 )
        return cmp;
      if ( auto cmp = pCmdBufLabels <=> rhs.pCmdBufLabels; cmp != 0 )
        return cmp;
      if ( auto cmp = objectCount <=> rhs.objectCount; cmp != 0 )
        return cmp;
      if ( auto cmp = pObjects <=> rhs.pObjects; cmp != 0 )
        return cmp;

      return std::strong_ordering::equivalent;
    }
#endif

    bool operator==( DebugUtilsMessengerCallbackDataEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) &&
             ( ( pMessageIdName == rhs.pMessageIdName ) || ( strcmp( pMessageIdName, rhs.pMessageIdName ) == 0 ) ) &&
             ( messageIdNumber == rhs.messageIdNumber ) && ( ( pMessage == rhs.pMessage ) || ( strcmp( pMessage, rhs.pMessage ) == 0 ) ) &&
             ( queueLabelCount == rhs.queueLabelCount ) && ( pQueueLabels == rhs.pQueueLabels ) && ( cmdBufLabelCount == rhs.cmdBufLabelCount ) &&
             ( pCmdBufLabels == rhs.pCmdBufLabels ) && ( objectCount == rhs.objectCount ) && ( pObjects == rhs.pObjects );
    }

    bool operator!=( DebugUtilsMessengerCallbackDataEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }

  public:
    VULKAN_HPP_NAMESPACE::StructureType                           sType            = StructureType::eDebugUtilsMessengerCallbackDataEXT;
    const void *                                                  pNext            = {};
    VULKAN_HPP_NAMESPACE::DebugUtilsMessengerCallbackDataFlagsEXT flags            = {};
    const char *                                                  pMessageIdName   = {};
    int32_t                                                       messageIdNumber  = {};
    const char *                                                  pMessage         = {};
    uint32_t                                                      queueLabelCount  = {};
    const VULKAN_HPP_NAMESPACE::DebugUtilsLabelEXT *              pQueueLabels     = {};
    uint32_t                                                      cmdBufLabelCount = {};
    const VULKAN_HPP_NAMESPACE::DebugUtilsLabelEXT *              pCmdBufLabels    = {};
    uint32_t                                                      objectCount      = {};
    const VULKAN_HPP_NAMESPACE::DebugUtilsObjectNameInfoEXT *     pObjects         = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eDebugUtilsMessengerCallbackDataEXT>
  {
    using Type = DebugUtilsMessengerCallbackDataEXT;
  };

  struct DebugUtilsMessengerCreateInfoEXT
  {
    using NativeType = VkDebugUtilsMessengerCreateInfoEXT;

    static const bool                                  allowDuplicate = true;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDebugUtilsMessengerCreateInfoEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DebugUtilsMessengerCreateInfoEXT( VULKAN_HPP_NAMESPACE::DebugUtilsMessengerCreateFlagsEXT flags_           = {},
                                                           VULKAN_HPP_NAMESPACE::DebugUtilsMessageSeverityFlagsEXT messageSeverity_ = {},
                                                           VULKAN_HPP_NAMESPACE::DebugUtilsMessageTypeFlagsEXT     messageType_     = {},
                                                           PFN_vkDebugUtilsMessengerCallbackEXT                    pfnUserCallback_ = {},
                                                           void *                                                  pUserData_       = {},
                                                           const void *                                            pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , messageSeverity{ messageSeverity_ }
      , messageType{ messageType_ }
      , pfnUserCallback{ pfnUserCallback_ }
      , pUserData{ pUserData_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DebugUtilsMessengerCreateInfoEXT( DebugUtilsMessengerCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DebugUtilsMessengerCreateInfoEXT( VkDebugUtilsMessengerCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : DebugUtilsMessengerCreateInfoEXT( *reinterpret_cast<DebugUtilsMessengerCreateInfoEXT const *>( &rhs ) )
    {
    }

    DebugUtilsMessengerCreateInfoEXT & operator=( DebugUtilsMessengerCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DebugUtilsMessengerCreateInfoEXT & operator=( VkDebugUtilsMessengerCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DebugUtilsMessengerCreateInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCreateInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCreateInfoEXT & setFlags( VULKAN_HPP_NAMESPACE::DebugUtilsMessengerCreateFlagsEXT flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCreateInfoEXT &
      setMessageSeverity( VULKAN_HPP_NAMESPACE::DebugUtilsMessageSeverityFlagsEXT messageSeverity_ ) VULKAN_HPP_NOEXCEPT
    {
      messageSeverity = messageSeverity_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCreateInfoEXT &
      setMessageType( VULKAN_HPP_NAMESPACE::DebugUtilsMessageTypeFlagsEXT messageType_ ) VULKAN_HPP_NOEXCEPT
    {
      messageType = messageType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCreateInfoEXT & setPfnUserCallback( PFN_vkDebugUtilsMessengerCallbackEXT pfnUserCallback_ ) VULKAN_HPP_NOEXCEPT
    {
      pfnUserCallback = pfnUserCallback_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCreateInfoEXT & setPUserData( void * pUserData_ ) VULKAN_HPP_NOEXCEPT
    {
      pUserData = pUserData_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDebugUtilsMessengerCreateInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDebugUtilsMessengerCreateInfoEXT *>( this );
    }

    operator VkDebugUtilsMessengerCreateInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDebugUtilsMessengerCreateInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::DebugUtilsMessengerCreateFlagsEXT const &,
               VULKAN_HPP_NAMESPACE::DebugUtilsMessageSeverityFlagsEXT const &,
               VULKAN_HPP_NAMESPACE::DebugUtilsMessageTypeFlagsEXT const &,
               PFN_vkDebugUtilsMessengerCallbackEXT const &,
               void * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, messageSeverity, messageType, pfnUserCallback, pUserData );
    }
#endif

    bool operator==( DebugUtilsMessengerCreateInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( messageSeverity == rhs.messageSeverity ) &&
             ( messageType == rhs.messageType ) && ( pfnUserCallback == rhs.pfnUserCallback ) && ( pUserData == rhs.pUserData );
#endif
    }

    bool operator!=( DebugUtilsMessengerCreateInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }

  public:
    VULKAN_HPP_NAMESPACE::StructureType                     sType           = StructureType::eDebugUtilsMessengerCreateInfoEXT;
    const void *                                            pNext           = {};
    VULKAN_HPP_NAMESPACE::DebugUtilsMessengerCreateFlagsEXT flags           = {};
    VULKAN_HPP_NAMESPACE::DebugUtilsMessageSeverityFlagsEXT messageSeverity = {};
    VULKAN_HPP_NAMESPACE::DebugUtilsMessageTypeFlagsEXT     messageType     = {};
    PFN_vkDebugUtilsMessengerCallbackEXT                    pfnUserCallback = {};
    void *                                                  pUserData       = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eDebugUtilsMessengerCreateInfoEXT>
  {
    using Type = DebugUtilsMessengerCreateInfoEXT;
  };

  struct DebugUtilsObjectTagInfoEXT
  {
    using NativeType = VkDebugUtilsObjectTagInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDebugUtilsObjectTagInfoEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DebugUtilsObjectTagInfoEXT( VULKAN_HPP_NAMESPACE::ObjectType objectType_   = VULKAN_HPP_NAMESPACE::ObjectType::eUnknown,
                                                     uint64_t                         objectHandle_ = {},
                                                     uint64_t                         tagName_      = {},
                                                     size_t                           tagSize_      = {},
                                                     const void *                     pTag_         = {},
                                                     const void *                     pNext_        = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , objectType{ objectType_ }
      , objectHandle{ objectHandle_ }
      , tagName{ tagName_ }
      , tagSize{ tagSize_ }
      , pTag{ pTag_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DebugUtilsObjectTagInfoEXT( DebugUtilsObjectTagInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DebugUtilsObjectTagInfoEXT( VkDebugUtilsObjectTagInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : DebugUtilsObjectTagInfoEXT( *reinterpret_cast<DebugUtilsObjectTagInfoEXT const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    template <typename T>
    DebugUtilsObjectTagInfoEXT( VULKAN_HPP_NAMESPACE::ObjectType                               objectType_,
                                uint64_t                                                       objectHandle_,
                                uint64_t                                                       tagName_,
                                VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const T> const & tag_,
                                const void *                                                   pNext_ = nullptr )
      : pNext( pNext_ )
      , objectType( objectType_ )
      , objectHandle( objectHandle_ )
      , tagName( tagName_ )
      , tagSize( tag_.size() * sizeof( T ) )
      , pTag( tag_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    DebugUtilsObjectTagInfoEXT & operator=( DebugUtilsObjectTagInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DebugUtilsObjectTagInfoEXT & operator=( VkDebugUtilsObjectTagInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DebugUtilsObjectTagInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DebugUtilsObjectTagInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsObjectTagInfoEXT & setObjectType( VULKAN_HPP_NAMESPACE::ObjectType objectType_ ) VULKAN_HPP_NOEXCEPT
    {
      objectType = objectType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsObjectTagInfoEXT & setObjectHandle( uint64_t objectHandle_ ) VULKAN_HPP_NOEXCEPT
    {
      objectHandle = objectHandle_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsObjectTagInfoEXT & setTagName( uint64_t tagName_ ) VULKAN_HPP_NOEXCEPT
    {
      tagName = tagName_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsObjectTagInfoEXT & setTagSize( size_t tagSize_ ) VULKAN_HPP_NOEXCEPT
    {
      tagSize = tagSize_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsObjectTagInfoEXT & setPTag( const void * pTag_ ) VULKAN_HPP_NOEXCEPT
    {
      pTag = pTag_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    template <typename T>
    DebugUtilsObjectTagInfoEXT & setTag( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const T> const & tag_ ) VULKAN_HPP_NOEXCEPT
    {
      tagSize = tag_.size() * sizeof( T );
      pTag    = tag_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDebugUtilsObjectTagInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDebugUtilsObjectTagInfoEXT *>( this );
    }

    operator VkDebugUtilsObjectTagInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDebugUtilsObjectTagInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::ObjectType const &,
               uint64_t const &,
               uint64_t const &,
               size_t const &,
               const void * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, objectType, objectHandle, tagName, tagSize, pTag );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DebugUtilsObjectTagInfoEXT const & ) const = default;
#else
    bool operator==( DebugUtilsObjectTagInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( objectType == rhs.objectType ) && ( objectHandle == rhs.objectHandle ) &&
             ( tagName == rhs.tagName ) && ( tagSize == rhs.tagSize ) && ( pTag == rhs.pTag );
#  endif
    }

    bool operator!=( DebugUtilsObjectTagInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType        = StructureType::eDebugUtilsObjectTagInfoEXT;
    const void *                        pNext        = {};
    VULKAN_HPP_NAMESPACE::ObjectType    objectType   = VULKAN_HPP_NAMESPACE::ObjectType::eUnknown;
    uint64_t                            objectHandle = {};
    uint64_t                            tagName      = {};
    size_t                              tagSize      = {};
    const void *                        pTag         = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eDebugUtilsObjectTagInfoEXT>
  {
    using Type = DebugUtilsObjectTagInfoEXT;
  };

  struct MemoryBarrier2
  {
    using NativeType = VkMemoryBarrier2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eMemoryBarrier2;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR MemoryBarrier2( VULKAN_HPP_NAMESPACE::PipelineStageFlags2 srcStageMask_  = {},
                                         VULKAN_HPP_NAMESPACE::AccessFlags2        srcAccessMask_ = {},
                                         VULKAN_HPP_NAMESPACE::PipelineStageFlags2 dstStageMask_  = {},
                                         VULKAN_HPP_NAMESPACE::AccessFlags2        dstAccessMask_ = {},
                                         const void *                              pNext_         = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , srcStageMask{ srcStageMask_ }
      , srcAccessMask{ srcAccessMask_ }
      , dstStageMask{ dstStageMask_ }
      , dstAccessMask{ dstAccessMask_ }
    {
    }

    VULKAN_HPP_CONSTEXPR MemoryBarrier2( MemoryBarrier2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    MemoryBarrier2( VkMemoryBarrier2 const & rhs ) VULKAN_HPP_NOEXCEPT : MemoryBarrier2( *reinterpret_cast<MemoryBarrier2 const *>( &rhs ) ) {}

    MemoryBarrier2 & operator=( MemoryBarrier2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    MemoryBarrier2 & operator=( VkMemoryBarrier2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::MemoryBarrier2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 MemoryBarrier2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 MemoryBarrier2 & setSrcStageMask( VULKAN_HPP_NAMESPACE::PipelineStageFlags2 srcStageMask_ ) VULKAN_HPP_NOEXCEPT
    {
      srcStageMask = srcStageMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 MemoryBarrier2 & setSrcAccessMask( VULKAN_HPP_NAMESPACE::AccessFlags2 srcAccessMask_ ) VULKAN_HPP_NOEXCEPT
    {
      srcAccessMask = srcAccessMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 MemoryBarrier2 & setDstStageMask( VULKAN_HPP_NAMESPACE::PipelineStageFlags2 dstStageMask_ ) VULKAN_HPP_NOEXCEPT
    {
      dstStageMask = dstStageMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 MemoryBarrier2 & setDstAccessMask( VULKAN_HPP_NAMESPACE::AccessFlags2 dstAccessMask_ ) VULKAN_HPP_NOEXCEPT
    {
      dstAccessMask = dstAccessMask_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkMemoryBarrier2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkMemoryBarrier2 *>( this );
    }

    operator VkMemoryBarrier2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkMemoryBarrier2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::PipelineStageFlags2 const &,
               VULKAN_HPP_NAMESPACE::AccessFlags2 const &,
               VULKAN_HPP_NAMESPACE::PipelineStageFlags2 const &,
               VULKAN_HPP_NAMESPACE::AccessFlags2 const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, srcStageMask, srcAccessMask, dstStageMask, dstAccessMask );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( MemoryBarrier2 const & ) const = default;
#else
    bool operator==( MemoryBarrier2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcStageMask == rhs.srcStageMask ) && ( srcAccessMask == rhs.srcAccessMask ) &&
             ( dstStageMask == rhs.dstStageMask ) && ( dstAccessMask == rhs.dstAccessMask );
#  endif
    }

    bool operator!=( MemoryBarrier2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType       sType         = StructureType::eMemoryBarrier2;
    const void *                              pNext         = {};
    VULKAN_HPP_NAMESPACE::PipelineStageFlags2 srcStageMask  = {};
    VULKAN_HPP_NAMESPACE::AccessFlags2        srcAccessMask = {};
    VULKAN_HPP_NAMESPACE::PipelineStageFlags2 dstStageMask  = {};
    VULKAN_HPP_NAMESPACE::AccessFlags2        dstAccessMask = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eMemoryBarrier2>
  {
    using Type = MemoryBarrier2;
  };

  using MemoryBarrier2KHR = MemoryBarrier2;

  struct ImageSubresourceRange
  {
    using NativeType = VkImageSubresourceRange;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ImageSubresourceRange( VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask_     = {},
                                                uint32_t                               baseMipLevel_   = {},
                                                uint32_t                               levelCount_     = {},
                                                uint32_t                               baseArrayLayer_ = {},
                                                uint32_t                               layerCount_     = {} ) VULKAN_HPP_NOEXCEPT
      : aspectMask{ aspectMask_ }
      , baseMipLevel{ baseMipLevel_ }
      , levelCount{ levelCount_ }
      , baseArrayLayer{ baseArrayLayer_ }
      , layerCount{ layerCount_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ImageSubresourceRange( ImageSubresourceRange const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageSubresourceRange( VkImageSubresourceRange const & rhs ) VULKAN_HPP_NOEXCEPT
      : ImageSubresourceRange( *reinterpret_cast<ImageSubresourceRange const *>( &rhs ) )
    {
    }

    ImageSubresourceRange & operator=( ImageSubresourceRange const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ImageSubresourceRange & operator=( VkImageSubresourceRange const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ImageSubresourceRange const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ImageSubresourceRange & setAspectMask( VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask_ ) VULKAN_HPP_NOEXCEPT
    {
      aspectMask = aspectMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageSubresourceRange & setBaseMipLevel( uint32_t baseMipLevel_ ) VULKAN_HPP_NOEXCEPT
    {
      baseMipLevel = baseMipLevel_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageSubresourceRange & setLevelCount( uint32_t levelCount_ ) VULKAN_HPP_NOEXCEPT
    {
      levelCount = levelCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageSubresourceRange & setBaseArrayLayer( uint32_t baseArrayLayer_ ) VULKAN_HPP_NOEXCEPT
    {
      baseArrayLayer = baseArrayLayer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageSubresourceRange & setLayerCount( uint32_t layerCount_ ) VULKAN_HPP_NOEXCEPT
    {
      layerCount = layerCount_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkImageSubresourceRange const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkImageSubresourceRange *>( this );
    }

    operator VkImageSubresourceRange &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkImageSubresourceRange *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::ImageAspectFlags const &, uint32_t const &, uint32_t const &, uint32_t const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( aspectMask, baseMipLevel, levelCount, baseArrayLayer, layerCount );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ImageSubresourceRange const & ) const = default;
#else
    bool operator==( ImageSubresourceRange const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( aspectMask == rhs.aspectMask ) && ( baseMipLevel == rhs.baseMipLevel ) && ( levelCount == rhs.levelCount ) &&
             ( baseArrayLayer == rhs.baseArrayLayer ) && ( layerCount == rhs.layerCount );
#  endif
    }

    bool operator!=( ImageSubresourceRange const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask     = {};
    uint32_t                               baseMipLevel   = {};
    uint32_t                               levelCount     = {};
    uint32_t                               baseArrayLayer = {};
    uint32_t                               layerCount     = {};
  };

  struct ImageMemoryBarrier2
  {
    using NativeType = VkImageMemoryBarrier2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eImageMemoryBarrier2;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ImageMemoryBarrier2( VULKAN_HPP_NAMESPACE::PipelineStageFlags2   srcStageMask_        = {},
                                              VULKAN_HPP_NAMESPACE::AccessFlags2          srcAccessMask_       = {},
                                              VULKAN_HPP_NAMESPACE::PipelineStageFlags2   dstStageMask_        = {},
                                              VULKAN_HPP_NAMESPACE::AccessFlags2          dstAccessMask_       = {},
                                              VULKAN_HPP_NAMESPACE::ImageLayout           oldLayout_           = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                                              VULKAN_HPP_NAMESPACE::ImageLayout           newLayout_           = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                                              uint32_t                                    srcQueueFamilyIndex_ = {},
                                              uint32_t                                    dstQueueFamilyIndex_ = {},
                                              VULKAN_HPP_NAMESPACE::Image                 image_               = {},
                                              VULKAN_HPP_NAMESPACE::ImageSubresourceRange subresourceRange_    = {},
                                              const void *                                pNext_               = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , srcStageMask{ srcStageMask_ }
      , srcAccessMask{ srcAccessMask_ }
      , dstStageMask{ dstStageMask_ }
      , dstAccessMask{ dstAccessMask_ }
      , oldLayout{ oldLayout_ }
      , newLayout{ newLayout_ }
      , srcQueueFamilyIndex{ srcQueueFamilyIndex_ }
      , dstQueueFamilyIndex{ dstQueueFamilyIndex_ }
      , image{ image_ }
      , subresourceRange{ subresourceRange_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ImageMemoryBarrier2( ImageMemoryBarrier2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageMemoryBarrier2( VkImageMemoryBarrier2 const & rhs ) VULKAN_HPP_NOEXCEPT : ImageMemoryBarrier2( *reinterpret_cast<ImageMemoryBarrier2 const *>( &rhs ) )
    {
    }

    ImageMemoryBarrier2 & operator=( ImageMemoryBarrier2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ImageMemoryBarrier2 & operator=( VkImageMemoryBarrier2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ImageMemoryBarrier2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ImageMemoryBarrier2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageMemoryBarrier2 & setSrcStageMask( VULKAN_HPP_NAMESPACE::PipelineStageFlags2 srcStageMask_ ) VULKAN_HPP_NOEXCEPT
    {
      srcStageMask = srcStageMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageMemoryBarrier2 & setSrcAccessMask( VULKAN_HPP_NAMESPACE::AccessFlags2 srcAccessMask_ ) VULKAN_HPP_NOEXCEPT
    {
      srcAccessMask = srcAccessMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageMemoryBarrier2 & setDstStageMask( VULKAN_HPP_NAMESPACE::PipelineStageFlags2 dstStageMask_ ) VULKAN_HPP_NOEXCEPT
    {
      dstStageMask = dstStageMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageMemoryBarrier2 & setDstAccessMask( VULKAN_HPP_NAMESPACE::AccessFlags2 dstAccessMask_ ) VULKAN_HPP_NOEXCEPT
    {
      dstAccessMask = dstAccessMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageMemoryBarrier2 & setOldLayout( VULKAN_HPP_NAMESPACE::ImageLayout oldLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      oldLayout = oldLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageMemoryBarrier2 & setNewLayout( VULKAN_HPP_NAMESPACE::ImageLayout newLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      newLayout = newLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageMemoryBarrier2 & setSrcQueueFamilyIndex( uint32_t srcQueueFamilyIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      srcQueueFamilyIndex = srcQueueFamilyIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageMemoryBarrier2 & setDstQueueFamilyIndex( uint32_t dstQueueFamilyIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      dstQueueFamilyIndex = dstQueueFamilyIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageMemoryBarrier2 & setImage( VULKAN_HPP_NAMESPACE::Image image_ ) VULKAN_HPP_NOEXCEPT
    {
      image = image_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageMemoryBarrier2 &
      setSubresourceRange( VULKAN_HPP_NAMESPACE::ImageSubresourceRange const & subresourceRange_ ) VULKAN_HPP_NOEXCEPT
    {
      subresourceRange = subresourceRange_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkImageMemoryBarrier2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkImageMemoryBarrier2 *>( this );
    }

    operator VkImageMemoryBarrier2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkImageMemoryBarrier2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::PipelineStageFlags2 const &,
               VULKAN_HPP_NAMESPACE::AccessFlags2 const &,
               VULKAN_HPP_NAMESPACE::PipelineStageFlags2 const &,
               VULKAN_HPP_NAMESPACE::AccessFlags2 const &,
               VULKAN_HPP_NAMESPACE::ImageLayout const &,
               VULKAN_HPP_NAMESPACE::ImageLayout const &,
               uint32_t const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::Image const &,
               VULKAN_HPP_NAMESPACE::ImageSubresourceRange const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType,
                       pNext,
                       srcStageMask,
                       srcAccessMask,
                       dstStageMask,
                       dstAccessMask,
                       oldLayout,
                       newLayout,
                       srcQueueFamilyIndex,
                       dstQueueFamilyIndex,
                       image,
                       subresourceRange );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ImageMemoryBarrier2 const & ) const = default;
#else
    bool operator==( ImageMemoryBarrier2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcStageMask == rhs.srcStageMask ) && ( srcAccessMask == rhs.srcAccessMask ) &&
             ( dstStageMask == rhs.dstStageMask ) && ( dstAccessMask == rhs.dstAccessMask ) && ( oldLayout == rhs.oldLayout ) &&
             ( newLayout == rhs.newLayout ) && ( srcQueueFamilyIndex == rhs.srcQueueFamilyIndex ) && ( dstQueueFamilyIndex == rhs.dstQueueFamilyIndex ) &&
             ( image == rhs.image ) && ( subresourceRange == rhs.subresourceRange );
#  endif
    }

    bool operator!=( ImageMemoryBarrier2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType         sType               = StructureType::eImageMemoryBarrier2;
    const void *                                pNext               = {};
    VULKAN_HPP_NAMESPACE::PipelineStageFlags2   srcStageMask        = {};
    VULKAN_HPP_NAMESPACE::AccessFlags2          srcAccessMask       = {};
    VULKAN_HPP_NAMESPACE::PipelineStageFlags2   dstStageMask        = {};
    VULKAN_HPP_NAMESPACE::AccessFlags2          dstAccessMask       = {};
    VULKAN_HPP_NAMESPACE::ImageLayout           oldLayout           = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    VULKAN_HPP_NAMESPACE::ImageLayout           newLayout           = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    uint32_t                                    srcQueueFamilyIndex = {};
    uint32_t                                    dstQueueFamilyIndex = {};
    VULKAN_HPP_NAMESPACE::Image                 image               = {};
    VULKAN_HPP_NAMESPACE::ImageSubresourceRange subresourceRange    = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eImageMemoryBarrier2>
  {
    using Type = ImageMemoryBarrier2;
  };

  using ImageMemoryBarrier2KHR = ImageMemoryBarrier2;

  struct DependencyInfo
  {
    using NativeType = VkDependencyInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDependencyInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DependencyInfo( VULKAN_HPP_NAMESPACE::DependencyFlags              dependencyFlags_          = {},
                                         uint32_t                                           memoryBarrierCount_       = {},
                                         const VULKAN_HPP_NAMESPACE::MemoryBarrier2 *       pMemoryBarriers_          = {},
                                         uint32_t                                           bufferMemoryBarrierCount_ = {},
                                         const VULKAN_HPP_NAMESPACE::BufferMemoryBarrier2 * pBufferMemoryBarriers_    = {},
                                         uint32_t                                           imageMemoryBarrierCount_  = {},
                                         const VULKAN_HPP_NAMESPACE::ImageMemoryBarrier2 *  pImageMemoryBarriers_     = {},
                                         const void *                                       pNext_                    = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , dependencyFlags{ dependencyFlags_ }
      , memoryBarrierCount{ memoryBarrierCount_ }
      , pMemoryBarriers{ pMemoryBarriers_ }
      , bufferMemoryBarrierCount{ bufferMemoryBarrierCount_ }
      , pBufferMemoryBarriers{ pBufferMemoryBarriers_ }
      , imageMemoryBarrierCount{ imageMemoryBarrierCount_ }
      , pImageMemoryBarriers{ pImageMemoryBarriers_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DependencyInfo( DependencyInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DependencyInfo( VkDependencyInfo const & rhs ) VULKAN_HPP_NOEXCEPT : DependencyInfo( *reinterpret_cast<DependencyInfo const *>( &rhs ) ) {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DependencyInfo( VULKAN_HPP_NAMESPACE::DependencyFlags                                                                   dependencyFlags_,
                    VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::MemoryBarrier2> const &       memoryBarriers_,
                    VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::BufferMemoryBarrier2> const & bufferMemoryBarriers_ = {},
                    VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::ImageMemoryBarrier2> const &  imageMemoryBarriers_  = {},
                    const void *                                                                                            pNext_                = nullptr )
      : pNext( pNext_ )
      , dependencyFlags( dependencyFlags_ )
      , memoryBarrierCount( static_cast<uint32_t>( memoryBarriers_.size() ) )
      , pMemoryBarriers( memoryBarriers_.data() )
      , bufferMemoryBarrierCount( static_cast<uint32_t>( bufferMemoryBarriers_.size() ) )
      , pBufferMemoryBarriers( bufferMemoryBarriers_.data() )
      , imageMemoryBarrierCount( static_cast<uint32_t>( imageMemoryBarriers_.size() ) )
      , pImageMemoryBarriers( imageMemoryBarriers_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    DependencyInfo & operator=( DependencyInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DependencyInfo & operator=( VkDependencyInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DependencyInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DependencyInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DependencyInfo & setDependencyFlags( VULKAN_HPP_NAMESPACE::DependencyFlags dependencyFlags_ ) VULKAN_HPP_NOEXCEPT
    {
      dependencyFlags = dependencyFlags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DependencyInfo & setMemoryBarrierCount( uint32_t memoryBarrierCount_ ) VULKAN_HPP_NOEXCEPT
    {
      memoryBarrierCount = memoryBarrierCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DependencyInfo & setPMemoryBarriers( const VULKAN_HPP_NAMESPACE::MemoryBarrier2 * pMemoryBarriers_ ) VULKAN_HPP_NOEXCEPT
    {
      pMemoryBarriers = pMemoryBarriers_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DependencyInfo &
      setMemoryBarriers( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::MemoryBarrier2> const & memoryBarriers_ ) VULKAN_HPP_NOEXCEPT
    {
      memoryBarrierCount = static_cast<uint32_t>( memoryBarriers_.size() );
      pMemoryBarriers    = memoryBarriers_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 DependencyInfo & setBufferMemoryBarrierCount( uint32_t bufferMemoryBarrierCount_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferMemoryBarrierCount = bufferMemoryBarrierCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DependencyInfo &
      setPBufferMemoryBarriers( const VULKAN_HPP_NAMESPACE::BufferMemoryBarrier2 * pBufferMemoryBarriers_ ) VULKAN_HPP_NOEXCEPT
    {
      pBufferMemoryBarriers = pBufferMemoryBarriers_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DependencyInfo & setBufferMemoryBarriers(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::BufferMemoryBarrier2> const & bufferMemoryBarriers_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferMemoryBarrierCount = static_cast<uint32_t>( bufferMemoryBarriers_.size() );
      pBufferMemoryBarriers    = bufferMemoryBarriers_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 DependencyInfo & setImageMemoryBarrierCount( uint32_t imageMemoryBarrierCount_ ) VULKAN_HPP_NOEXCEPT
    {
      imageMemoryBarrierCount = imageMemoryBarrierCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DependencyInfo &
      setPImageMemoryBarriers( const VULKAN_HPP_NAMESPACE::ImageMemoryBarrier2 * pImageMemoryBarriers_ ) VULKAN_HPP_NOEXCEPT
    {
      pImageMemoryBarriers = pImageMemoryBarriers_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DependencyInfo & setImageMemoryBarriers(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::ImageMemoryBarrier2> const & imageMemoryBarriers_ ) VULKAN_HPP_NOEXCEPT
    {
      imageMemoryBarrierCount = static_cast<uint32_t>( imageMemoryBarriers_.size() );
      pImageMemoryBarriers    = imageMemoryBarriers_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDependencyInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDependencyInfo *>( this );
    }

    operator VkDependencyInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDependencyInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::DependencyFlags const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::MemoryBarrier2 * const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::BufferMemoryBarrier2 * const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::ImageMemoryBarrier2 * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType,
                       pNext,
                       dependencyFlags,
                       memoryBarrierCount,
                       pMemoryBarriers,
                       bufferMemoryBarrierCount,
                       pBufferMemoryBarriers,
                       imageMemoryBarrierCount,
                       pImageMemoryBarriers );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DependencyInfo const & ) const = default;
#else
    bool operator==( DependencyInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( dependencyFlags == rhs.dependencyFlags ) &&
             ( memoryBarrierCount == rhs.memoryBarrierCount ) && ( pMemoryBarriers == rhs.pMemoryBarriers ) &&
             ( bufferMemoryBarrierCount == rhs.bufferMemoryBarrierCount ) && ( pBufferMemoryBarriers == rhs.pBufferMemoryBarriers ) &&
             ( imageMemoryBarrierCount == rhs.imageMemoryBarrierCount ) && ( pImageMemoryBarriers == rhs.pImageMemoryBarriers );
#  endif
    }

    bool operator!=( DependencyInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                sType                    = StructureType::eDependencyInfo;
    const void *                                       pNext                    = {};
    VULKAN_HPP_NAMESPACE::DependencyFlags              dependencyFlags          = {};
    uint32_t                                           memoryBarrierCount       = {};
    const VULKAN_HPP_NAMESPACE::MemoryBarrier2 *       pMemoryBarriers          = {};
    uint32_t                                           bufferMemoryBarrierCount = {};
    const VULKAN_HPP_NAMESPACE::BufferMemoryBarrier2 * pBufferMemoryBarriers    = {};
    uint32_t                                           imageMemoryBarrierCount  = {};
    const VULKAN_HPP_NAMESPACE::ImageMemoryBarrier2 *  pImageMemoryBarriers     = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eDependencyInfo>
  {
    using Type = DependencyInfo;
  };

  using DependencyInfoKHR = DependencyInfo;

  struct DescriptorBufferInfo
  {
    using NativeType = VkDescriptorBufferInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DescriptorBufferInfo( VULKAN_HPP_NAMESPACE::Buffer     buffer_ = {},
                                               VULKAN_HPP_NAMESPACE::DeviceSize offset_ = {},
                                               VULKAN_HPP_NAMESPACE::DeviceSize range_  = {} ) VULKAN_HPP_NOEXCEPT
      : buffer{ buffer_ }
      , offset{ offset_ }
      , range{ range_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DescriptorBufferInfo( DescriptorBufferInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorBufferInfo( VkDescriptorBufferInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : DescriptorBufferInfo( *reinterpret_cast<DescriptorBufferInfo const *>( &rhs ) )
    {
    }

    DescriptorBufferInfo & operator=( DescriptorBufferInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DescriptorBufferInfo & operator=( VkDescriptorBufferInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DescriptorBufferInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DescriptorBufferInfo & setBuffer( VULKAN_HPP_NAMESPACE::Buffer buffer_ ) VULKAN_HPP_NOEXCEPT
    {
      buffer = buffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorBufferInfo & setOffset( VULKAN_HPP_NAMESPACE::DeviceSize offset_ ) VULKAN_HPP_NOEXCEPT
    {
      offset = offset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorBufferInfo & setRange( VULKAN_HPP_NAMESPACE::DeviceSize range_ ) VULKAN_HPP_NOEXCEPT
    {
      range = range_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDescriptorBufferInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDescriptorBufferInfo *>( this );
    }

    operator VkDescriptorBufferInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDescriptorBufferInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::Buffer const &, VULKAN_HPP_NAMESPACE::DeviceSize const &, VULKAN_HPP_NAMESPACE::DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( buffer, offset, range );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DescriptorBufferInfo const & ) const = default;
#else
    bool operator==( DescriptorBufferInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( buffer == rhs.buffer ) && ( offset == rhs.offset ) && ( range == rhs.range );
#  endif
    }

    bool operator!=( DescriptorBufferInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::Buffer     buffer = {};
    VULKAN_HPP_NAMESPACE::DeviceSize offset = {};
    VULKAN_HPP_NAMESPACE::DeviceSize range  = {};
  };

  struct DescriptorImageInfo
  {
    using NativeType = VkDescriptorImageInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      DescriptorImageInfo( VULKAN_HPP_NAMESPACE::Sampler     sampler_     = {},
                           VULKAN_HPP_NAMESPACE::ImageView   imageView_   = {},
                           VULKAN_HPP_NAMESPACE::ImageLayout imageLayout_ = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined ) VULKAN_HPP_NOEXCEPT
      : sampler{ sampler_ }
      , imageView{ imageView_ }
      , imageLayout{ imageLayout_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DescriptorImageInfo( DescriptorImageInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorImageInfo( VkDescriptorImageInfo const & rhs ) VULKAN_HPP_NOEXCEPT : DescriptorImageInfo( *reinterpret_cast<DescriptorImageInfo const *>( &rhs ) )
    {
    }

    DescriptorImageInfo & operator=( DescriptorImageInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DescriptorImageInfo & operator=( VkDescriptorImageInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DescriptorImageInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DescriptorImageInfo & setSampler( VULKAN_HPP_NAMESPACE::Sampler sampler_ ) VULKAN_HPP_NOEXCEPT
    {
      sampler = sampler_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorImageInfo & setImageView( VULKAN_HPP_NAMESPACE::ImageView imageView_ ) VULKAN_HPP_NOEXCEPT
    {
      imageView = imageView_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorImageInfo & setImageLayout( VULKAN_HPP_NAMESPACE::ImageLayout imageLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      imageLayout = imageLayout_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDescriptorImageInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDescriptorImageInfo *>( this );
    }

    operator VkDescriptorImageInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDescriptorImageInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::Sampler const &, VULKAN_HPP_NAMESPACE::ImageView const &, VULKAN_HPP_NAMESPACE::ImageLayout const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sampler, imageView, imageLayout );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DescriptorImageInfo const & ) const = default;
#else
    bool operator==( DescriptorImageInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sampler == rhs.sampler ) && ( imageView == rhs.imageView ) && ( imageLayout == rhs.imageLayout );
#  endif
    }

    bool operator!=( DescriptorImageInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::Sampler     sampler     = {};
    VULKAN_HPP_NAMESPACE::ImageView   imageView   = {};
    VULKAN_HPP_NAMESPACE::ImageLayout imageLayout = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
  };

  struct DescriptorPoolSize
  {
    using NativeType = VkDescriptorPoolSize;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DescriptorPoolSize( VULKAN_HPP_NAMESPACE::DescriptorType type_            = VULKAN_HPP_NAMESPACE::DescriptorType::eSampler,
                                             uint32_t                             descriptorCount_ = {} ) VULKAN_HPP_NOEXCEPT
      : type{ type_ }
      , descriptorCount{ descriptorCount_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DescriptorPoolSize( DescriptorPoolSize const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorPoolSize( VkDescriptorPoolSize const & rhs ) VULKAN_HPP_NOEXCEPT : DescriptorPoolSize( *reinterpret_cast<DescriptorPoolSize const *>( &rhs ) ) {}

    DescriptorPoolSize & operator=( DescriptorPoolSize const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DescriptorPoolSize & operator=( VkDescriptorPoolSize const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DescriptorPoolSize const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DescriptorPoolSize & setType( VULKAN_HPP_NAMESPACE::DescriptorType type_ ) VULKAN_HPP_NOEXCEPT
    {
      type = type_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorPoolSize & setDescriptorCount( uint32_t descriptorCount_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorCount = descriptorCount_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDescriptorPoolSize const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDescriptorPoolSize *>( this );
    }

    operator VkDescriptorPoolSize &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDescriptorPoolSize *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::DescriptorType const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( type, descriptorCount );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DescriptorPoolSize const & ) const = default;
#else
    bool operator==( DescriptorPoolSize const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( type == rhs.type ) && ( descriptorCount == rhs.descriptorCount );
#  endif
    }

    bool operator!=( DescriptorPoolSize const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::DescriptorType type            = VULKAN_HPP_NAMESPACE::DescriptorType::eSampler;
    uint32_t                             descriptorCount = {};
  };

  struct DescriptorPoolCreateInfo
  {
    using NativeType = VkDescriptorPoolCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDescriptorPoolCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DescriptorPoolCreateInfo( VULKAN_HPP_NAMESPACE::DescriptorPoolCreateFlags  flags_         = {},
                                                   uint32_t                                         maxSets_       = {},
                                                   uint32_t                                         poolSizeCount_ = {},
                                                   const VULKAN_HPP_NAMESPACE::DescriptorPoolSize * pPoolSizes_    = {},
                                                   const void *                                     pNext_         = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , maxSets{ maxSets_ }
      , poolSizeCount{ poolSizeCount_ }
      , pPoolSizes{ pPoolSizes_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DescriptorPoolCreateInfo( DescriptorPoolCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorPoolCreateInfo( VkDescriptorPoolCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : DescriptorPoolCreateInfo( *reinterpret_cast<DescriptorPoolCreateInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DescriptorPoolCreateInfo( VULKAN_HPP_NAMESPACE::DescriptorPoolCreateFlags                                                       flags_,
                              uint32_t                                                                                              maxSets_,
                              VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DescriptorPoolSize> const & poolSizes_,
                              const void *                                                                                          pNext_ = nullptr )
      : pNext( pNext_ ), flags( flags_ ), maxSets( maxSets_ ), poolSizeCount( static_cast<uint32_t>( poolSizes_.size() ) ), pPoolSizes( poolSizes_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    DescriptorPoolCreateInfo & operator=( DescriptorPoolCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DescriptorPoolCreateInfo & operator=( VkDescriptorPoolCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DescriptorPoolCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DescriptorPoolCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorPoolCreateInfo & setFlags( VULKAN_HPP_NAMESPACE::DescriptorPoolCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorPoolCreateInfo & setMaxSets( uint32_t maxSets_ ) VULKAN_HPP_NOEXCEPT
    {
      maxSets = maxSets_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorPoolCreateInfo & setPoolSizeCount( uint32_t poolSizeCount_ ) VULKAN_HPP_NOEXCEPT
    {
      poolSizeCount = poolSizeCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorPoolCreateInfo & setPPoolSizes( const VULKAN_HPP_NAMESPACE::DescriptorPoolSize * pPoolSizes_ ) VULKAN_HPP_NOEXCEPT
    {
      pPoolSizes = pPoolSizes_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DescriptorPoolCreateInfo &
      setPoolSizes( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DescriptorPoolSize> const & poolSizes_ ) VULKAN_HPP_NOEXCEPT
    {
      poolSizeCount = static_cast<uint32_t>( poolSizes_.size() );
      pPoolSizes    = poolSizes_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDescriptorPoolCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDescriptorPoolCreateInfo *>( this );
    }

    operator VkDescriptorPoolCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDescriptorPoolCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::DescriptorPoolCreateFlags const &,
               uint32_t const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::DescriptorPoolSize * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, maxSets, poolSizeCount, pPoolSizes );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DescriptorPoolCreateInfo const & ) const = default;
#else
    bool operator==( DescriptorPoolCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( maxSets == rhs.maxSets ) &&
             ( poolSizeCount == rhs.poolSizeCount ) && ( pPoolSizes == rhs.pPoolSizes );
#  endif
    }

    bool operator!=( DescriptorPoolCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType              sType         = StructureType::eDescriptorPoolCreateInfo;
    const void *                                     pNext         = {};
    VULKAN_HPP_NAMESPACE::DescriptorPoolCreateFlags  flags         = {};
    uint32_t                                         maxSets       = {};
    uint32_t                                         poolSizeCount = {};
    const VULKAN_HPP_NAMESPACE::DescriptorPoolSize * pPoolSizes    = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eDescriptorPoolCreateInfo>
  {
    using Type = DescriptorPoolCreateInfo;
  };

  struct DescriptorPoolInlineUniformBlockCreateInfo
  {
    using NativeType = VkDescriptorPoolInlineUniformBlockCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDescriptorPoolInlineUniformBlockCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DescriptorPoolInlineUniformBlockCreateInfo( uint32_t     maxInlineUniformBlockBindings_ = {},
                                                                     const void * pNext_                         = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , maxInlineUniformBlockBindings{ maxInlineUniformBlockBindings_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DescriptorPoolInlineUniformBlockCreateInfo( DescriptorPoolInlineUniformBlockCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorPoolInlineUniformBlockCreateInfo( VkDescriptorPoolInlineUniformBlockCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : DescriptorPoolInlineUniformBlockCreateInfo( *reinterpret_cast<DescriptorPoolInlineUniformBlockCreateInfo const *>( &rhs ) )
    {
    }

    DescriptorPoolInlineUniformBlockCreateInfo & operator=( DescriptorPoolInlineUniformBlockCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DescriptorPoolInlineUniformBlockCreateInfo & operator=( VkDescriptorPoolInlineUniformBlockCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DescriptorPoolInlineUniformBlockCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DescriptorPoolInlineUniformBlockCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorPoolInlineUniformBlockCreateInfo &
      setMaxInlineUniformBlockBindings( uint32_t maxInlineUniformBlockBindings_ ) VULKAN_HPP_NOEXCEPT
    {
      maxInlineUniformBlockBindings = maxInlineUniformBlockBindings_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDescriptorPoolInlineUniformBlockCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDescriptorPoolInlineUniformBlockCreateInfo *>( this );
    }

    operator VkDescriptorPoolInlineUniformBlockCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDescriptorPoolInlineUniformBlockCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, maxInlineUniformBlockBindings );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DescriptorPoolInlineUniformBlockCreateInfo const & ) const = default;
#else
    bool operator==( DescriptorPoolInlineUniformBlockCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( maxInlineUniformBlockBindings == rhs.maxInlineUniformBlockBindings );
#  endif
    }

    bool operator!=( DescriptorPoolInlineUniformBlockCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType                         = StructureType::eDescriptorPoolInlineUniformBlockCreateInfo;
    const void *                        pNext                         = {};
    uint32_t                            maxInlineUniformBlockBindings = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eDescriptorPoolInlineUniformBlockCreateInfo>
  {
    using Type = DescriptorPoolInlineUniformBlockCreateInfo;
  };

  using DescriptorPoolInlineUniformBlockCreateInfoEXT = DescriptorPoolInlineUniformBlockCreateInfo;

  struct DescriptorSetAllocateInfo
  {
    using NativeType = VkDescriptorSetAllocateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDescriptorSetAllocateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DescriptorSetAllocateInfo( VULKAN_HPP_NAMESPACE::DescriptorPool              descriptorPool_     = {},
                                                    uint32_t                                          descriptorSetCount_ = {},
                                                    const VULKAN_HPP_NAMESPACE::DescriptorSetLayout * pSetLayouts_        = {},
                                                    const void *                                      pNext_              = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , descriptorPool{ descriptorPool_ }
      , descriptorSetCount{ descriptorSetCount_ }
      , pSetLayouts{ pSetLayouts_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DescriptorSetAllocateInfo( DescriptorSetAllocateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorSetAllocateInfo( VkDescriptorSetAllocateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : DescriptorSetAllocateInfo( *reinterpret_cast<DescriptorSetAllocateInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DescriptorSetAllocateInfo( VULKAN_HPP_NAMESPACE::DescriptorPool                                                                   descriptorPool_,
                               VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DescriptorSetLayout> const & setLayouts_,
                               const void *                                                                                           pNext_ = nullptr )
      : pNext( pNext_ ), descriptorPool( descriptorPool_ ), descriptorSetCount( static_cast<uint32_t>( setLayouts_.size() ) ), pSetLayouts( setLayouts_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    DescriptorSetAllocateInfo & operator=( DescriptorSetAllocateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DescriptorSetAllocateInfo & operator=( VkDescriptorSetAllocateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DescriptorSetAllocateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DescriptorSetAllocateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorSetAllocateInfo & setDescriptorPool( VULKAN_HPP_NAMESPACE::DescriptorPool descriptorPool_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorPool = descriptorPool_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorSetAllocateInfo & setDescriptorSetCount( uint32_t descriptorSetCount_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorSetCount = descriptorSetCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorSetAllocateInfo & setPSetLayouts( const VULKAN_HPP_NAMESPACE::DescriptorSetLayout * pSetLayouts_ ) VULKAN_HPP_NOEXCEPT
    {
      pSetLayouts = pSetLayouts_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DescriptorSetAllocateInfo &
      setSetLayouts( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DescriptorSetLayout> const & setLayouts_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorSetCount = static_cast<uint32_t>( setLayouts_.size() );
      pSetLayouts        = setLayouts_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDescriptorSetAllocateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDescriptorSetAllocateInfo *>( this );
    }

    operator VkDescriptorSetAllocateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDescriptorSetAllocateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::DescriptorPool const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::DescriptorSetLayout * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, descriptorPool, descriptorSetCount, pSetLayouts );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DescriptorSetAllocateInfo const & ) const = default;
#else
    bool operator==( DescriptorSetAllocateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( descriptorPool == rhs.descriptorPool ) && ( descriptorSetCount == rhs.descriptorSetCount ) &&
             ( pSetLayouts == rhs.pSetLayouts );
#  endif
    }

    bool operator!=( DescriptorSetAllocateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType               sType              = StructureType::eDescriptorSetAllocateInfo;
    const void *                                      pNext              = {};
    VULKAN_HPP_NAMESPACE::DescriptorPool              descriptorPool     = {};
    uint32_t                                          descriptorSetCount = {};
    const VULKAN_HPP_NAMESPACE::DescriptorSetLayout * pSetLayouts        = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eDescriptorSetAllocateInfo>
  {
    using Type = DescriptorSetAllocateInfo;
  };

  struct DescriptorSetLayoutBinding
  {
    using NativeType = VkDescriptorSetLayoutBinding;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DescriptorSetLayoutBinding( uint32_t                               binding_         = {},
                                                     VULKAN_HPP_NAMESPACE::DescriptorType   descriptorType_  = VULKAN_HPP_NAMESPACE::DescriptorType::eSampler,
                                                     uint32_t                               descriptorCount_ = {},
                                                     VULKAN_HPP_NAMESPACE::ShaderStageFlags stageFlags_      = {},
                                                     const VULKAN_HPP_NAMESPACE::Sampler *  pImmutableSamplers_ = {} ) VULKAN_HPP_NOEXCEPT
      : binding{ binding_ }
      , descriptorType{ descriptorType_ }
      , descriptorCount{ descriptorCount_ }
      , stageFlags{ stageFlags_ }
      , pImmutableSamplers{ pImmutableSamplers_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DescriptorSetLayoutBinding( DescriptorSetLayoutBinding const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorSetLayoutBinding( VkDescriptorSetLayoutBinding const & rhs ) VULKAN_HPP_NOEXCEPT
      : DescriptorSetLayoutBinding( *reinterpret_cast<DescriptorSetLayoutBinding const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DescriptorSetLayoutBinding( uint32_t                                                                                   binding_,
                                VULKAN_HPP_NAMESPACE::DescriptorType                                                       descriptorType_,
                                VULKAN_HPP_NAMESPACE::ShaderStageFlags                                                     stageFlags_,
                                VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::Sampler> const & immutableSamplers_ )
      : binding( binding_ )
      , descriptorType( descriptorType_ )
      , descriptorCount( static_cast<uint32_t>( immutableSamplers_.size() ) )
      , stageFlags( stageFlags_ )
      , pImmutableSamplers( immutableSamplers_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    DescriptorSetLayoutBinding & operator=( DescriptorSetLayoutBinding const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DescriptorSetLayoutBinding & operator=( VkDescriptorSetLayoutBinding const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DescriptorSetLayoutBinding const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DescriptorSetLayoutBinding & setBinding( uint32_t binding_ ) VULKAN_HPP_NOEXCEPT
    {
      binding = binding_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorSetLayoutBinding & setDescriptorType( VULKAN_HPP_NAMESPACE::DescriptorType descriptorType_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorType = descriptorType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorSetLayoutBinding & setDescriptorCount( uint32_t descriptorCount_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorCount = descriptorCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorSetLayoutBinding & setStageFlags( VULKAN_HPP_NAMESPACE::ShaderStageFlags stageFlags_ ) VULKAN_HPP_NOEXCEPT
    {
      stageFlags = stageFlags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorSetLayoutBinding & setPImmutableSamplers( const VULKAN_HPP_NAMESPACE::Sampler * pImmutableSamplers_ ) VULKAN_HPP_NOEXCEPT
    {
      pImmutableSamplers = pImmutableSamplers_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DescriptorSetLayoutBinding &
      setImmutableSamplers( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::Sampler> const & immutableSamplers_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorCount    = static_cast<uint32_t>( immutableSamplers_.size() );
      pImmutableSamplers = immutableSamplers_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDescriptorSetLayoutBinding const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDescriptorSetLayoutBinding *>( this );
    }

    operator VkDescriptorSetLayoutBinding &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDescriptorSetLayoutBinding *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &,
               VULKAN_HPP_NAMESPACE::DescriptorType const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::ShaderStageFlags const &,
               const VULKAN_HPP_NAMESPACE::Sampler * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( binding, descriptorType, descriptorCount, stageFlags, pImmutableSamplers );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DescriptorSetLayoutBinding const & ) const = default;
#else
    bool operator==( DescriptorSetLayoutBinding const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( binding == rhs.binding ) && ( descriptorType == rhs.descriptorType ) && ( descriptorCount == rhs.descriptorCount ) &&
             ( stageFlags == rhs.stageFlags ) && ( pImmutableSamplers == rhs.pImmutableSamplers );
#  endif
    }

    bool operator!=( DescriptorSetLayoutBinding const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t                               binding            = {};
    VULKAN_HPP_NAMESPACE::DescriptorType   descriptorType     = VULKAN_HPP_NAMESPACE::DescriptorType::eSampler;
    uint32_t                               descriptorCount    = {};
    VULKAN_HPP_NAMESPACE::ShaderStageFlags stageFlags         = {};
    const VULKAN_HPP_NAMESPACE::Sampler *  pImmutableSamplers = {};
  };

  struct DescriptorSetLayoutBindingFlagsCreateInfo
  {
    using NativeType = VkDescriptorSetLayoutBindingFlagsCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDescriptorSetLayoutBindingFlagsCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DescriptorSetLayoutBindingFlagsCreateInfo( uint32_t                                             bindingCount_  = {},
                                                                    const VULKAN_HPP_NAMESPACE::DescriptorBindingFlags * pBindingFlags_ = {},
                                                                    const void *                                         pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , bindingCount{ bindingCount_ }
      , pBindingFlags{ pBindingFlags_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DescriptorSetLayoutBindingFlagsCreateInfo( DescriptorSetLayoutBindingFlagsCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorSetLayoutBindingFlagsCreateInfo( VkDescriptorSetLayoutBindingFlagsCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : DescriptorSetLayoutBindingFlagsCreateInfo( *reinterpret_cast<DescriptorSetLayoutBindingFlagsCreateInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DescriptorSetLayoutBindingFlagsCreateInfo(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DescriptorBindingFlags> const & bindingFlags_, const void * pNext_ = nullptr )
      : pNext( pNext_ ), bindingCount( static_cast<uint32_t>( bindingFlags_.size() ) ), pBindingFlags( bindingFlags_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    DescriptorSetLayoutBindingFlagsCreateInfo & operator=( DescriptorSetLayoutBindingFlagsCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DescriptorSetLayoutBindingFlagsCreateInfo & operator=( VkDescriptorSetLayoutBindingFlagsCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DescriptorSetLayoutBindingFlagsCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DescriptorSetLayoutBindingFlagsCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorSetLayoutBindingFlagsCreateInfo & setBindingCount( uint32_t bindingCount_ ) VULKAN_HPP_NOEXCEPT
    {
      bindingCount = bindingCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorSetLayoutBindingFlagsCreateInfo &
      setPBindingFlags( const VULKAN_HPP_NAMESPACE::DescriptorBindingFlags * pBindingFlags_ ) VULKAN_HPP_NOEXCEPT
    {
      pBindingFlags = pBindingFlags_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DescriptorSetLayoutBindingFlagsCreateInfo & setBindingFlags(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DescriptorBindingFlags> const & bindingFlags_ ) VULKAN_HPP_NOEXCEPT
    {
      bindingCount  = static_cast<uint32_t>( bindingFlags_.size() );
      pBindingFlags = bindingFlags_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDescriptorSetLayoutBindingFlagsCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDescriptorSetLayoutBindingFlagsCreateInfo *>( this );
    }

    operator VkDescriptorSetLayoutBindingFlagsCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDescriptorSetLayoutBindingFlagsCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::
      tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, uint32_t const &, const VULKAN_HPP_NAMESPACE::DescriptorBindingFlags * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, bindingCount, pBindingFlags );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DescriptorSetLayoutBindingFlagsCreateInfo const & ) const = default;
#else
    bool operator==( DescriptorSetLayoutBindingFlagsCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( bindingCount == rhs.bindingCount ) && ( pBindingFlags == rhs.pBindingFlags );
#  endif
    }

    bool operator!=( DescriptorSetLayoutBindingFlagsCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                  sType         = StructureType::eDescriptorSetLayoutBindingFlagsCreateInfo;
    const void *                                         pNext         = {};
    uint32_t                                             bindingCount  = {};
    const VULKAN_HPP_NAMESPACE::DescriptorBindingFlags * pBindingFlags = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eDescriptorSetLayoutBindingFlagsCreateInfo>
  {
    using Type = DescriptorSetLayoutBindingFlagsCreateInfo;
  };

  using DescriptorSetLayoutBindingFlagsCreateInfoEXT = DescriptorSetLayoutBindingFlagsCreateInfo;

  struct DescriptorSetLayoutCreateInfo
  {
    using NativeType = VkDescriptorSetLayoutCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDescriptorSetLayoutCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DescriptorSetLayoutCreateInfo( VULKAN_HPP_NAMESPACE::DescriptorSetLayoutCreateFlags     flags_        = {},
                                                        uint32_t                                                 bindingCount_ = {},
                                                        const VULKAN_HPP_NAMESPACE::DescriptorSetLayoutBinding * pBindings_    = {},
                                                        const void *                                             pNext_        = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , bindingCount{ bindingCount_ }
      , pBindings{ pBindings_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DescriptorSetLayoutCreateInfo( DescriptorSetLayoutCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorSetLayoutCreateInfo( VkDescriptorSetLayoutCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : DescriptorSetLayoutCreateInfo( *reinterpret_cast<DescriptorSetLayoutCreateInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DescriptorSetLayoutCreateInfo( VULKAN_HPP_NAMESPACE::DescriptorSetLayoutCreateFlags                                                          flags_,
                                   VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DescriptorSetLayoutBinding> const & bindings_,
                                   const void * pNext_ = nullptr )
      : pNext( pNext_ ), flags( flags_ ), bindingCount( static_cast<uint32_t>( bindings_.size() ) ), pBindings( bindings_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    DescriptorSetLayoutCreateInfo & operator=( DescriptorSetLayoutCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DescriptorSetLayoutCreateInfo & operator=( VkDescriptorSetLayoutCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DescriptorSetLayoutCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DescriptorSetLayoutCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorSetLayoutCreateInfo & setFlags( VULKAN_HPP_NAMESPACE::DescriptorSetLayoutCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorSetLayoutCreateInfo & setBindingCount( uint32_t bindingCount_ ) VULKAN_HPP_NOEXCEPT
    {
      bindingCount = bindingCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorSetLayoutCreateInfo &
      setPBindings( const VULKAN_HPP_NAMESPACE::DescriptorSetLayoutBinding * pBindings_ ) VULKAN_HPP_NOEXCEPT
    {
      pBindings = pBindings_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DescriptorSetLayoutCreateInfo &
      setBindings( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DescriptorSetLayoutBinding> const & bindings_ ) VULKAN_HPP_NOEXCEPT
    {
      bindingCount = static_cast<uint32_t>( bindings_.size() );
      pBindings    = bindings_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDescriptorSetLayoutCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDescriptorSetLayoutCreateInfo *>( this );
    }

    operator VkDescriptorSetLayoutCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDescriptorSetLayoutCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::DescriptorSetLayoutCreateFlags const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::DescriptorSetLayoutBinding * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, bindingCount, pBindings );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DescriptorSetLayoutCreateInfo const & ) const = default;
#else
    bool operator==( DescriptorSetLayoutCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( bindingCount == rhs.bindingCount ) &&
             ( pBindings == rhs.pBindings );
#  endif
    }

    bool operator!=( DescriptorSetLayoutCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                      sType        = StructureType::eDescriptorSetLayoutCreateInfo;
    const void *                                             pNext        = {};
    VULKAN_HPP_NAMESPACE::DescriptorSetLayoutCreateFlags     flags        = {};
    uint32_t                                                 bindingCount = {};
    const VULKAN_HPP_NAMESPACE::DescriptorSetLayoutBinding * pBindings    = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eDescriptorSetLayoutCreateInfo>
  {
    using Type = DescriptorSetLayoutCreateInfo;
  };

  struct DescriptorSetLayoutSupport
  {
    using NativeType = VkDescriptorSetLayoutSupport;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDescriptorSetLayoutSupport;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DescriptorSetLayoutSupport( VULKAN_HPP_NAMESPACE::Bool32 supported_ = {}, void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , supported{ supported_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DescriptorSetLayoutSupport( DescriptorSetLayoutSupport const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorSetLayoutSupport( VkDescriptorSetLayoutSupport const & rhs ) VULKAN_HPP_NOEXCEPT
      : DescriptorSetLayoutSupport( *reinterpret_cast<DescriptorSetLayoutSupport const *>( &rhs ) )
    {
    }

    DescriptorSetLayoutSupport & operator=( DescriptorSetLayoutSupport const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DescriptorSetLayoutSupport & operator=( VkDescriptorSetLayoutSupport const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DescriptorSetLayoutSupport const *>( &rhs );
      return *this;
    }

    operator VkDescriptorSetLayoutSupport const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDescriptorSetLayoutSupport *>( this );
    }

    operator VkDescriptorSetLayoutSupport &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDescriptorSetLayoutSupport *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, void * const &, VULKAN_HPP_NAMESPACE::Bool32 const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, supported );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DescriptorSetLayoutSupport const & ) const = default;
#else
    bool operator==( DescriptorSetLayoutSupport const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( supported == rhs.supported );
#  endif
    }

    bool operator!=( DescriptorSetLayoutSupport const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType     = StructureType::eDescriptorSetLayoutSupport;
    void *                              pNext     = {};
    VULKAN_HPP_NAMESPACE::Bool32        supported = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eDescriptorSetLayoutSupport>
  {
    using Type = DescriptorSetLayoutSupport;
  };

  using DescriptorSetLayoutSupportKHR = DescriptorSetLayoutSupport;

  struct DescriptorSetVariableDescriptorCountAllocateInfo
  {
    using NativeType = VkDescriptorSetVariableDescriptorCountAllocateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDescriptorSetVariableDescriptorCountAllocateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DescriptorSetVariableDescriptorCountAllocateInfo( uint32_t         descriptorSetCount_ = {},
                                                                           const uint32_t * pDescriptorCounts_  = {},
                                                                           const void *     pNext_              = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , descriptorSetCount{ descriptorSetCount_ }
      , pDescriptorCounts{ pDescriptorCounts_ }
    {
    }

    VULKAN_HPP_CONSTEXPR
      DescriptorSetVariableDescriptorCountAllocateInfo( DescriptorSetVariableDescriptorCountAllocateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorSetVariableDescriptorCountAllocateInfo( VkDescriptorSetVariableDescriptorCountAllocateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : DescriptorSetVariableDescriptorCountAllocateInfo( *reinterpret_cast<DescriptorSetVariableDescriptorCountAllocateInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DescriptorSetVariableDescriptorCountAllocateInfo( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint32_t> const & descriptorCounts_,
                                                      const void *                                                          pNext_ = nullptr )
      : pNext( pNext_ ), descriptorSetCount( static_cast<uint32_t>( descriptorCounts_.size() ) ), pDescriptorCounts( descriptorCounts_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    DescriptorSetVariableDescriptorCountAllocateInfo & operator=( DescriptorSetVariableDescriptorCountAllocateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DescriptorSetVariableDescriptorCountAllocateInfo & operator=( VkDescriptorSetVariableDescriptorCountAllocateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DescriptorSetVariableDescriptorCountAllocateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DescriptorSetVariableDescriptorCountAllocateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorSetVariableDescriptorCountAllocateInfo & setDescriptorSetCount( uint32_t descriptorSetCount_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorSetCount = descriptorSetCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorSetVariableDescriptorCountAllocateInfo & setPDescriptorCounts( const uint32_t * pDescriptorCounts_ ) VULKAN_HPP_NOEXCEPT
    {
      pDescriptorCounts = pDescriptorCounts_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DescriptorSetVariableDescriptorCountAllocateInfo &
      setDescriptorCounts( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint32_t> const & descriptorCounts_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorSetCount = static_cast<uint32_t>( descriptorCounts_.size() );
      pDescriptorCounts  = descriptorCounts_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDescriptorSetVariableDescriptorCountAllocateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDescriptorSetVariableDescriptorCountAllocateInfo *>( this );
    }

    operator VkDescriptorSetVariableDescriptorCountAllocateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDescriptorSetVariableDescriptorCountAllocateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, uint32_t const &, const uint32_t * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, descriptorSetCount, pDescriptorCounts );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DescriptorSetVariableDescriptorCountAllocateInfo const & ) const = default;
#else
    bool operator==( DescriptorSetVariableDescriptorCountAllocateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( descriptorSetCount == rhs.descriptorSetCount ) &&
             ( pDescriptorCounts == rhs.pDescriptorCounts );
#  endif
    }

    bool operator!=( DescriptorSetVariableDescriptorCountAllocateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType              = StructureType::eDescriptorSetVariableDescriptorCountAllocateInfo;
    const void *                        pNext              = {};
    uint32_t                            descriptorSetCount = {};
    const uint32_t *                    pDescriptorCounts  = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eDescriptorSetVariableDescriptorCountAllocateInfo>
  {
    using Type = DescriptorSetVariableDescriptorCountAllocateInfo;
  };

  using DescriptorSetVariableDescriptorCountAllocateInfoEXT = DescriptorSetVariableDescriptorCountAllocateInfo;

  struct DescriptorSetVariableDescriptorCountLayoutSupport
  {
    using NativeType = VkDescriptorSetVariableDescriptorCountLayoutSupport;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDescriptorSetVariableDescriptorCountLayoutSupport;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DescriptorSetVariableDescriptorCountLayoutSupport( uint32_t maxVariableDescriptorCount_ = {},
                                                                            void *   pNext_                      = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , maxVariableDescriptorCount{ maxVariableDescriptorCount_ }
    {
    }

    VULKAN_HPP_CONSTEXPR
      DescriptorSetVariableDescriptorCountLayoutSupport( DescriptorSetVariableDescriptorCountLayoutSupport const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorSetVariableDescriptorCountLayoutSupport( VkDescriptorSetVariableDescriptorCountLayoutSupport const & rhs ) VULKAN_HPP_NOEXCEPT
      : DescriptorSetVariableDescriptorCountLayoutSupport( *reinterpret_cast<DescriptorSetVariableDescriptorCountLayoutSupport const *>( &rhs ) )
    {
    }

    DescriptorSetVariableDescriptorCountLayoutSupport &
      operator=( DescriptorSetVariableDescriptorCountLayoutSupport const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DescriptorSetVariableDescriptorCountLayoutSupport & operator=( VkDescriptorSetVariableDescriptorCountLayoutSupport const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DescriptorSetVariableDescriptorCountLayoutSupport const *>( &rhs );
      return *this;
    }

    operator VkDescriptorSetVariableDescriptorCountLayoutSupport const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDescriptorSetVariableDescriptorCountLayoutSupport *>( this );
    }

    operator VkDescriptorSetVariableDescriptorCountLayoutSupport &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDescriptorSetVariableDescriptorCountLayoutSupport *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, void * const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, maxVariableDescriptorCount );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DescriptorSetVariableDescriptorCountLayoutSupport const & ) const = default;
#else
    bool operator==( DescriptorSetVariableDescriptorCountLayoutSupport const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( maxVariableDescriptorCount == rhs.maxVariableDescriptorCount );
#  endif
    }

    bool operator!=( DescriptorSetVariableDescriptorCountLayoutSupport const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType                      = StructureType::eDescriptorSetVariableDescriptorCountLayoutSupport;
    void *                              pNext                      = {};
    uint32_t                            maxVariableDescriptorCount = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eDescriptorSetVariableDescriptorCountLayoutSupport>
  {
    using Type = DescriptorSetVariableDescriptorCountLayoutSupport;
  };

  using DescriptorSetVariableDescriptorCountLayoutSupportEXT = DescriptorSetVariableDescriptorCountLayoutSupport;

  struct DeviceBufferMemoryRequirements
  {
    using NativeType = VkDeviceBufferMemoryRequirements;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDeviceBufferMemoryRequirements;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DeviceBufferMemoryRequirements( const VULKAN_HPP_NAMESPACE::BufferCreateInfo * pCreateInfo_ = {},
                                                         const void *                                   pNext_       = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , pCreateInfo{ pCreateInfo_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DeviceBufferMemoryRequirements( DeviceBufferMemoryRequirements const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DeviceBufferMemoryRequirements( VkDeviceBufferMemoryRequirements const & rhs ) VULKAN_HPP_NOEXCEPT
      : DeviceBufferMemoryRequirements( *reinterpret_cast<DeviceBufferMemoryRequirements const *>( &rhs ) )
    {
    }

    DeviceBufferMemoryRequirements & operator=( DeviceBufferMemoryRequirements const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DeviceBufferMemoryRequirements & operator=( VkDeviceBufferMemoryRequirements const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DeviceBufferMemoryRequirements const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DeviceBufferMemoryRequirements & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceBufferMemoryRequirements & setPCreateInfo( const VULKAN_HPP_NAMESPACE::BufferCreateInfo * pCreateInfo_ ) VULKAN_HPP_NOEXCEPT
    {
      pCreateInfo = pCreateInfo_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDeviceBufferMemoryRequirements const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDeviceBufferMemoryRequirements *>( this );
    }

    operator VkDeviceBufferMemoryRequirements &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDeviceBufferMemoryRequirements *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, const VULKAN_HPP_NAMESPACE::BufferCreateInfo * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, pCreateInfo );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DeviceBufferMemoryRequirements const & ) const = default;
#else
    bool operator==( DeviceBufferMemoryRequirements const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( pCreateInfo == rhs.pCreateInfo );
#  endif
    }

    bool operator!=( DeviceBufferMemoryRequirements const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType            sType       = StructureType::eDeviceBufferMemoryRequirements;
    const void *                                   pNext       = {};
    const VULKAN_HPP_NAMESPACE::BufferCreateInfo * pCreateInfo = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eDeviceBufferMemoryRequirements>
  {
    using Type = DeviceBufferMemoryRequirements;
  };

  using DeviceBufferMemoryRequirementsKHR = DeviceBufferMemoryRequirements;

  struct DeviceQueueCreateInfo
  {
    using NativeType = VkDeviceQueueCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDeviceQueueCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DeviceQueueCreateInfo( VULKAN_HPP_NAMESPACE::DeviceQueueCreateFlags flags_            = {},
                                                uint32_t                                     queueFamilyIndex_ = {},
                                                uint32_t                                     queueCount_       = {},
                                                const float *                                pQueuePriorities_ = {},
                                                const void *                                 pNext_            = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , queueFamilyIndex{ queueFamilyIndex_ }
      , queueCount{ queueCount_ }
      , pQueuePriorities{ pQueuePriorities_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DeviceQueueCreateInfo( DeviceQueueCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DeviceQueueCreateInfo( VkDeviceQueueCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : DeviceQueueCreateInfo( *reinterpret_cast<DeviceQueueCreateInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DeviceQueueCreateInfo( VULKAN_HPP_NAMESPACE::DeviceQueueCreateFlags                       flags_,
                           uint32_t                                                           queueFamilyIndex_,
                           VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const float> const & queuePriorities_,
                           const void *                                                       pNext_ = nullptr )
      : pNext( pNext_ )
      , flags( flags_ )
      , queueFamilyIndex( queueFamilyIndex_ )
      , queueCount( static_cast<uint32_t>( queuePriorities_.size() ) )
      , pQueuePriorities( queuePriorities_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    DeviceQueueCreateInfo & operator=( DeviceQueueCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DeviceQueueCreateInfo & operator=( VkDeviceQueueCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DeviceQueueCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DeviceQueueCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceQueueCreateInfo & setFlags( VULKAN_HPP_NAMESPACE::DeviceQueueCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceQueueCreateInfo & setQueueFamilyIndex( uint32_t queueFamilyIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      queueFamilyIndex = queueFamilyIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceQueueCreateInfo & setQueueCount( uint32_t queueCount_ ) VULKAN_HPP_NOEXCEPT
    {
      queueCount = queueCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceQueueCreateInfo & setPQueuePriorities( const float * pQueuePriorities_ ) VULKAN_HPP_NOEXCEPT
    {
      pQueuePriorities = pQueuePriorities_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DeviceQueueCreateInfo & setQueuePriorities( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const float> const & queuePriorities_ ) VULKAN_HPP_NOEXCEPT
    {
      queueCount       = static_cast<uint32_t>( queuePriorities_.size() );
      pQueuePriorities = queuePriorities_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDeviceQueueCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDeviceQueueCreateInfo *>( this );
    }

    operator VkDeviceQueueCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDeviceQueueCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::DeviceQueueCreateFlags const &,
               uint32_t const &,
               uint32_t const &,
               const float * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, queueFamilyIndex, queueCount, pQueuePriorities );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DeviceQueueCreateInfo const & ) const = default;
#else
    bool operator==( DeviceQueueCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( queueFamilyIndex == rhs.queueFamilyIndex ) &&
             ( queueCount == rhs.queueCount ) && ( pQueuePriorities == rhs.pQueuePriorities );
#  endif
    }

    bool operator!=( DeviceQueueCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType          sType            = StructureType::eDeviceQueueCreateInfo;
    const void *                                 pNext            = {};
    VULKAN_HPP_NAMESPACE::DeviceQueueCreateFlags flags            = {};
    uint32_t                                     queueFamilyIndex = {};
    uint32_t                                     queueCount       = {};
    const float *                                pQueuePriorities = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eDeviceQueueCreateInfo>
  {
    using Type = DeviceQueueCreateInfo;
  };

  struct PhysicalDeviceFeatures
  {
    using NativeType = VkPhysicalDeviceFeatures;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR PhysicalDeviceFeatures( VULKAN_HPP_NAMESPACE::Bool32 robustBufferAccess_                      = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 fullDrawIndexUint32_                     = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 imageCubeArray_                          = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 independentBlend_                        = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 geometryShader_                          = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 tessellationShader_                      = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 sampleRateShading_                       = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 dualSrcBlend_                            = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 logicOp_                                 = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 multiDrawIndirect_                       = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 drawIndirectFirstInstance_               = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 depthClamp_                              = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 depthBiasClamp_                          = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 fillModeNonSolid_                        = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 depthBounds_                             = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 wideLines_                               = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 largePoints_                             = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 alphaToOne_                              = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 multiViewport_                           = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 samplerAnisotropy_                       = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 textureCompressionETC2_                  = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 textureCompressionASTC_LDR_              = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 textureCompressionBC_                    = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 occlusionQueryPrecise_                   = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 pipelineStatisticsQuery_                 = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 vertexPipelineStoresAndAtomics_          = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 fragmentStoresAndAtomics_                = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 shaderTessellationAndGeometryPointSize_  = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 shaderImageGatherExtended_               = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 shaderStorageImageExtendedFormats_       = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 shaderStorageImageMultisample_           = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 shaderStorageImageReadWithoutFormat_     = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 shaderStorageImageWriteWithoutFormat_    = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 shaderUniformBufferArrayDynamicIndexing_ = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 shaderSampledImageArrayDynamicIndexing_  = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 shaderStorageBufferArrayDynamicIndexing_ = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 shaderStorageImageArrayDynamicIndexing_  = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 shaderClipDistance_                      = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 shaderCullDistance_                      = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 shaderFloat64_                           = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 shaderInt64_                             = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 shaderInt16_                             = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 shaderResourceResidency_                 = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 shaderResourceMinLod_                    = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 sparseBinding_                           = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 sparseResidencyBuffer_                   = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 sparseResidencyImage2D_                  = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 sparseResidencyImage3D_                  = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 sparseResidency2Samples_                 = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 sparseResidency4Samples_                 = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 sparseResidency8Samples_                 = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 sparseResidency16Samples_                = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 sparseResidencyAliased_                  = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 variableMultisampleRate_                 = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 inheritedQueries_                        = {} ) VULKAN_HPP_NOEXCEPT
      : robustBufferAccess{ robustBufferAccess_ }
      , fullDrawIndexUint32{ fullDrawIndexUint32_ }
      , imageCubeArray{ imageCubeArray_ }
      , independentBlend{ independentBlend_ }
      , geometryShader{ geometryShader_ }
      , tessellationShader{ tessellationShader_ }
      , sampleRateShading{ sampleRateShading_ }
      , dualSrcBlend{ dualSrcBlend_ }
      , logicOp{ logicOp_ }
      , multiDrawIndirect{ multiDrawIndirect_ }
      , drawIndirectFirstInstance{ drawIndirectFirstInstance_ }
      , depthClamp{ depthClamp_ }
      , depthBiasClamp{ depthBiasClamp_ }
      , fillModeNonSolid{ fillModeNonSolid_ }
      , depthBounds{ depthBounds_ }
      , wideLines{ wideLines_ }
      , largePoints{ largePoints_ }
      , alphaToOne{ alphaToOne_ }
      , multiViewport{ multiViewport_ }
      , samplerAnisotropy{ samplerAnisotropy_ }
      , textureCompressionETC2{ textureCompressionETC2_ }
      , textureCompressionASTC_LDR{ textureCompressionASTC_LDR_ }
      , textureCompressionBC{ textureCompressionBC_ }
      , occlusionQueryPrecise{ occlusionQueryPrecise_ }
      , pipelineStatisticsQuery{ pipelineStatisticsQuery_ }
      , vertexPipelineStoresAndAtomics{ vertexPipelineStoresAndAtomics_ }
      , fragmentStoresAndAtomics{ fragmentStoresAndAtomics_ }
      , shaderTessellationAndGeometryPointSize{ shaderTessellationAndGeometryPointSize_ }
      , shaderImageGatherExtended{ shaderImageGatherExtended_ }
      , shaderStorageImageExtendedFormats{ shaderStorageImageExtendedFormats_ }
      , shaderStorageImageMultisample{ shaderStorageImageMultisample_ }
      , shaderStorageImageReadWithoutFormat{ shaderStorageImageReadWithoutFormat_ }
      , shaderStorageImageWriteWithoutFormat{ shaderStorageImageWriteWithoutFormat_ }
      , shaderUniformBufferArrayDynamicIndexing{ shaderUniformBufferArrayDynamicIndexing_ }
      , shaderSampledImageArrayDynamicIndexing{ shaderSampledImageArrayDynamicIndexing_ }
      , shaderStorageBufferArrayDynamicIndexing{ shaderStorageBufferArrayDynamicIndexing_ }
      , shaderStorageImageArrayDynamicIndexing{ shaderStorageImageArrayDynamicIndexing_ }
      , shaderClipDistance{ shaderClipDistance_ }
      , shaderCullDistance{ shaderCullDistance_ }
      , shaderFloat64{ shaderFloat64_ }
      , shaderInt64{ shaderInt64_ }
      , shaderInt16{ shaderInt16_ }
      , shaderResourceResidency{ shaderResourceResidency_ }
      , shaderResourceMinLod{ shaderResourceMinLod_ }
      , sparseBinding{ sparseBinding_ }
      , sparseResidencyBuffer{ sparseResidencyBuffer_ }
      , sparseResidencyImage2D{ sparseResidencyImage2D_ }
      , sparseResidencyImage3D{ sparseResidencyImage3D_ }
      , sparseResidency2Samples{ sparseResidency2Samples_ }
      , sparseResidency4Samples{ sparseResidency4Samples_ }
      , sparseResidency8Samples{ sparseResidency8Samples_ }
      , sparseResidency16Samples{ sparseResidency16Samples_ }
      , sparseResidencyAliased{ sparseResidencyAliased_ }
      , variableMultisampleRate{ variableMultisampleRate_ }
      , inheritedQueries{ inheritedQueries_ }
    {
    }

    VULKAN_HPP_CONSTEXPR PhysicalDeviceFeatures( PhysicalDeviceFeatures const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    PhysicalDeviceFeatures( VkPhysicalDeviceFeatures const & rhs ) VULKAN_HPP_NOEXCEPT
      : PhysicalDeviceFeatures( *reinterpret_cast<PhysicalDeviceFeatures const *>( &rhs ) )
    {
    }

    PhysicalDeviceFeatures & operator=( PhysicalDeviceFeatures const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    PhysicalDeviceFeatures & operator=( VkPhysicalDeviceFeatures const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::PhysicalDeviceFeatures const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setRobustBufferAccess( VULKAN_HPP_NAMESPACE::Bool32 robustBufferAccess_ ) VULKAN_HPP_NOEXCEPT
    {
      robustBufferAccess = robustBufferAccess_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setFullDrawIndexUint32( VULKAN_HPP_NAMESPACE::Bool32 fullDrawIndexUint32_ ) VULKAN_HPP_NOEXCEPT
    {
      fullDrawIndexUint32 = fullDrawIndexUint32_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setImageCubeArray( VULKAN_HPP_NAMESPACE::Bool32 imageCubeArray_ ) VULKAN_HPP_NOEXCEPT
    {
      imageCubeArray = imageCubeArray_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setIndependentBlend( VULKAN_HPP_NAMESPACE::Bool32 independentBlend_ ) VULKAN_HPP_NOEXCEPT
    {
      independentBlend = independentBlend_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setGeometryShader( VULKAN_HPP_NAMESPACE::Bool32 geometryShader_ ) VULKAN_HPP_NOEXCEPT
    {
      geometryShader = geometryShader_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setTessellationShader( VULKAN_HPP_NAMESPACE::Bool32 tessellationShader_ ) VULKAN_HPP_NOEXCEPT
    {
      tessellationShader = tessellationShader_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setSampleRateShading( VULKAN_HPP_NAMESPACE::Bool32 sampleRateShading_ ) VULKAN_HPP_NOEXCEPT
    {
      sampleRateShading = sampleRateShading_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setDualSrcBlend( VULKAN_HPP_NAMESPACE::Bool32 dualSrcBlend_ ) VULKAN_HPP_NOEXCEPT
    {
      dualSrcBlend = dualSrcBlend_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setLogicOp( VULKAN_HPP_NAMESPACE::Bool32 logicOp_ ) VULKAN_HPP_NOEXCEPT
    {
      logicOp = logicOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setMultiDrawIndirect( VULKAN_HPP_NAMESPACE::Bool32 multiDrawIndirect_ ) VULKAN_HPP_NOEXCEPT
    {
      multiDrawIndirect = multiDrawIndirect_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setDrawIndirectFirstInstance( VULKAN_HPP_NAMESPACE::Bool32 drawIndirectFirstInstance_ ) VULKAN_HPP_NOEXCEPT
    {
      drawIndirectFirstInstance = drawIndirectFirstInstance_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setDepthClamp( VULKAN_HPP_NAMESPACE::Bool32 depthClamp_ ) VULKAN_HPP_NOEXCEPT
    {
      depthClamp = depthClamp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setDepthBiasClamp( VULKAN_HPP_NAMESPACE::Bool32 depthBiasClamp_ ) VULKAN_HPP_NOEXCEPT
    {
      depthBiasClamp = depthBiasClamp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setFillModeNonSolid( VULKAN_HPP_NAMESPACE::Bool32 fillModeNonSolid_ ) VULKAN_HPP_NOEXCEPT
    {
      fillModeNonSolid = fillModeNonSolid_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setDepthBounds( VULKAN_HPP_NAMESPACE::Bool32 depthBounds_ ) VULKAN_HPP_NOEXCEPT
    {
      depthBounds = depthBounds_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setWideLines( VULKAN_HPP_NAMESPACE::Bool32 wideLines_ ) VULKAN_HPP_NOEXCEPT
    {
      wideLines = wideLines_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setLargePoints( VULKAN_HPP_NAMESPACE::Bool32 largePoints_ ) VULKAN_HPP_NOEXCEPT
    {
      largePoints = largePoints_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setAlphaToOne( VULKAN_HPP_NAMESPACE::Bool32 alphaToOne_ ) VULKAN_HPP_NOEXCEPT
    {
      alphaToOne = alphaToOne_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setMultiViewport( VULKAN_HPP_NAMESPACE::Bool32 multiViewport_ ) VULKAN_HPP_NOEXCEPT
    {
      multiViewport = multiViewport_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setSamplerAnisotropy( VULKAN_HPP_NAMESPACE::Bool32 samplerAnisotropy_ ) VULKAN_HPP_NOEXCEPT
    {
      samplerAnisotropy = samplerAnisotropy_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setTextureCompressionETC2( VULKAN_HPP_NAMESPACE::Bool32 textureCompressionETC2_ ) VULKAN_HPP_NOEXCEPT
    {
      textureCompressionETC2 = textureCompressionETC2_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
      setTextureCompressionASTC_LDR( VULKAN_HPP_NAMESPACE::Bool32 textureCompressionASTC_LDR_ ) VULKAN_HPP_NOEXCEPT
    {
      textureCompressionASTC_LDR = textureCompressionASTC_LDR_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setTextureCompressionBC( VULKAN_HPP_NAMESPACE::Bool32 textureCompressionBC_ ) VULKAN_HPP_NOEXCEPT
    {
      textureCompressionBC = textureCompressionBC_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setOcclusionQueryPrecise( VULKAN_HPP_NAMESPACE::Bool32 occlusionQueryPrecise_ ) VULKAN_HPP_NOEXCEPT
    {
      occlusionQueryPrecise = occlusionQueryPrecise_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setPipelineStatisticsQuery( VULKAN_HPP_NAMESPACE::Bool32 pipelineStatisticsQuery_ ) VULKAN_HPP_NOEXCEPT
    {
      pipelineStatisticsQuery = pipelineStatisticsQuery_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
      setVertexPipelineStoresAndAtomics( VULKAN_HPP_NAMESPACE::Bool32 vertexPipelineStoresAndAtomics_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexPipelineStoresAndAtomics = vertexPipelineStoresAndAtomics_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setFragmentStoresAndAtomics( VULKAN_HPP_NAMESPACE::Bool32 fragmentStoresAndAtomics_ ) VULKAN_HPP_NOEXCEPT
    {
      fragmentStoresAndAtomics = fragmentStoresAndAtomics_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
      setShaderTessellationAndGeometryPointSize( VULKAN_HPP_NAMESPACE::Bool32 shaderTessellationAndGeometryPointSize_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderTessellationAndGeometryPointSize = shaderTessellationAndGeometryPointSize_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setShaderImageGatherExtended( VULKAN_HPP_NAMESPACE::Bool32 shaderImageGatherExtended_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderImageGatherExtended = shaderImageGatherExtended_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
      setShaderStorageImageExtendedFormats( VULKAN_HPP_NAMESPACE::Bool32 shaderStorageImageExtendedFormats_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderStorageImageExtendedFormats = shaderStorageImageExtendedFormats_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
      setShaderStorageImageMultisample( VULKAN_HPP_NAMESPACE::Bool32 shaderStorageImageMultisample_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderStorageImageMultisample = shaderStorageImageMultisample_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
      setShaderStorageImageReadWithoutFormat( VULKAN_HPP_NAMESPACE::Bool32 shaderStorageImageReadWithoutFormat_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderStorageImageReadWithoutFormat = shaderStorageImageReadWithoutFormat_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
      setShaderStorageImageWriteWithoutFormat( VULKAN_HPP_NAMESPACE::Bool32 shaderStorageImageWriteWithoutFormat_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderStorageImageWriteWithoutFormat = shaderStorageImageWriteWithoutFormat_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
      setShaderUniformBufferArrayDynamicIndexing( VULKAN_HPP_NAMESPACE::Bool32 shaderUniformBufferArrayDynamicIndexing_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderUniformBufferArrayDynamicIndexing = shaderUniformBufferArrayDynamicIndexing_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
      setShaderSampledImageArrayDynamicIndexing( VULKAN_HPP_NAMESPACE::Bool32 shaderSampledImageArrayDynamicIndexing_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderSampledImageArrayDynamicIndexing = shaderSampledImageArrayDynamicIndexing_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
      setShaderStorageBufferArrayDynamicIndexing( VULKAN_HPP_NAMESPACE::Bool32 shaderStorageBufferArrayDynamicIndexing_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderStorageBufferArrayDynamicIndexing = shaderStorageBufferArrayDynamicIndexing_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
      setShaderStorageImageArrayDynamicIndexing( VULKAN_HPP_NAMESPACE::Bool32 shaderStorageImageArrayDynamicIndexing_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderStorageImageArrayDynamicIndexing = shaderStorageImageArrayDynamicIndexing_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setShaderClipDistance( VULKAN_HPP_NAMESPACE::Bool32 shaderClipDistance_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderClipDistance = shaderClipDistance_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setShaderCullDistance( VULKAN_HPP_NAMESPACE::Bool32 shaderCullDistance_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderCullDistance = shaderCullDistance_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setShaderFloat64( VULKAN_HPP_NAMESPACE::Bool32 shaderFloat64_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderFloat64 = shaderFloat64_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setShaderInt64( VULKAN_HPP_NAMESPACE::Bool32 shaderInt64_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderInt64 = shaderInt64_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setShaderInt16( VULKAN_HPP_NAMESPACE::Bool32 shaderInt16_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderInt16 = shaderInt16_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setShaderResourceResidency( VULKAN_HPP_NAMESPACE::Bool32 shaderResourceResidency_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderResourceResidency = shaderResourceResidency_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setShaderResourceMinLod( VULKAN_HPP_NAMESPACE::Bool32 shaderResourceMinLod_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderResourceMinLod = shaderResourceMinLod_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setSparseBinding( VULKAN_HPP_NAMESPACE::Bool32 sparseBinding_ ) VULKAN_HPP_NOEXCEPT
    {
      sparseBinding = sparseBinding_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setSparseResidencyBuffer( VULKAN_HPP_NAMESPACE::Bool32 sparseResidencyBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      sparseResidencyBuffer = sparseResidencyBuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setSparseResidencyImage2D( VULKAN_HPP_NAMESPACE::Bool32 sparseResidencyImage2D_ ) VULKAN_HPP_NOEXCEPT
    {
      sparseResidencyImage2D = sparseResidencyImage2D_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setSparseResidencyImage3D( VULKAN_HPP_NAMESPACE::Bool32 sparseResidencyImage3D_ ) VULKAN_HPP_NOEXCEPT
    {
      sparseResidencyImage3D = sparseResidencyImage3D_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setSparseResidency2Samples( VULKAN_HPP_NAMESPACE::Bool32 sparseResidency2Samples_ ) VULKAN_HPP_NOEXCEPT
    {
      sparseResidency2Samples = sparseResidency2Samples_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setSparseResidency4Samples( VULKAN_HPP_NAMESPACE::Bool32 sparseResidency4Samples_ ) VULKAN_HPP_NOEXCEPT
    {
      sparseResidency4Samples = sparseResidency4Samples_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setSparseResidency8Samples( VULKAN_HPP_NAMESPACE::Bool32 sparseResidency8Samples_ ) VULKAN_HPP_NOEXCEPT
    {
      sparseResidency8Samples = sparseResidency8Samples_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setSparseResidency16Samples( VULKAN_HPP_NAMESPACE::Bool32 sparseResidency16Samples_ ) VULKAN_HPP_NOEXCEPT
    {
      sparseResidency16Samples = sparseResidency16Samples_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setSparseResidencyAliased( VULKAN_HPP_NAMESPACE::Bool32 sparseResidencyAliased_ ) VULKAN_HPP_NOEXCEPT
    {
      sparseResidencyAliased = sparseResidencyAliased_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setVariableMultisampleRate( VULKAN_HPP_NAMESPACE::Bool32 variableMultisampleRate_ ) VULKAN_HPP_NOEXCEPT
    {
      variableMultisampleRate = variableMultisampleRate_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setInheritedQueries( VULKAN_HPP_NAMESPACE::Bool32 inheritedQueries_ ) VULKAN_HPP_NOEXCEPT
    {
      inheritedQueries = inheritedQueries_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkPhysicalDeviceFeatures const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkPhysicalDeviceFeatures *>( this );
    }

    operator VkPhysicalDeviceFeatures &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkPhysicalDeviceFeatures *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( robustBufferAccess,
                       fullDrawIndexUint32,
                       imageCubeArray,
                       independentBlend,
                       geometryShader,
                       tessellationShader,
                       sampleRateShading,
                       dualSrcBlend,
                       logicOp,
                       multiDrawIndirect,
                       drawIndirectFirstInstance,
                       depthClamp,
                       depthBiasClamp,
                       fillModeNonSolid,
                       depthBounds,
                       wideLines,
                       largePoints,
                       alphaToOne,
                       multiViewport,
                       samplerAnisotropy,
                       textureCompressionETC2,
                       textureCompressionASTC_LDR,
                       textureCompressionBC,
                       occlusionQueryPrecise,
                       pipelineStatisticsQuery,
                       vertexPipelineStoresAndAtomics,
                       fragmentStoresAndAtomics,
                       shaderTessellationAndGeometryPointSize,
                       shaderImageGatherExtended,
                       shaderStorageImageExtendedFormats,
                       shaderStorageImageMultisample,
                       shaderStorageImageReadWithoutFormat,
                       shaderStorageImageWriteWithoutFormat,
                       shaderUniformBufferArrayDynamicIndexing,
                       shaderSampledImageArrayDynamicIndexing,
                       shaderStorageBufferArrayDynamicIndexing,
                       shaderStorageImageArrayDynamicIndexing,
                       shaderClipDistance,
                       shaderCullDistance,
                       shaderFloat64,
                       shaderInt64,
                       shaderInt16,
                       shaderResourceResidency,
                       shaderResourceMinLod,
                       sparseBinding,
                       sparseResidencyBuffer,
                       sparseResidencyImage2D,
                       sparseResidencyImage3D,
                       sparseResidency2Samples,
                       sparseResidency4Samples,
                       sparseResidency8Samples,
                       sparseResidency16Samples,
                       sparseResidencyAliased,
                       variableMultisampleRate,
                       inheritedQueries );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( PhysicalDeviceFeatures const & ) const = default;
#else
    bool operator==( PhysicalDeviceFeatures const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( robustBufferAccess == rhs.robustBufferAccess ) && ( fullDrawIndexUint32 == rhs.fullDrawIndexUint32 ) &&
             ( imageCubeArray == rhs.imageCubeArray ) && ( independentBlend == rhs.independentBlend ) && ( geometryShader == rhs.geometryShader ) &&
             ( tessellationShader == rhs.tessellationShader ) && ( sampleRateShading == rhs.sampleRateShading ) && ( dualSrcBlend == rhs.dualSrcBlend ) &&
             ( logicOp == rhs.logicOp ) && ( multiDrawIndirect == rhs.multiDrawIndirect ) && ( drawIndirectFirstInstance == rhs.drawIndirectFirstInstance ) &&
             ( depthClamp == rhs.depthClamp ) && ( depthBiasClamp == rhs.depthBiasClamp ) && ( fillModeNonSolid == rhs.fillModeNonSolid ) &&
             ( depthBounds == rhs.depthBounds ) && ( wideLines == rhs.wideLines ) && ( largePoints == rhs.largePoints ) && ( alphaToOne == rhs.alphaToOne ) &&
             ( multiViewport == rhs.multiViewport ) && ( samplerAnisotropy == rhs.samplerAnisotropy ) &&
             ( textureCompressionETC2 == rhs.textureCompressionETC2 ) && ( textureCompressionASTC_LDR == rhs.textureCompressionASTC_LDR ) &&
             ( textureCompressionBC == rhs.textureCompressionBC ) && ( occlusionQueryPrecise == rhs.occlusionQueryPrecise ) &&
             ( pipelineStatisticsQuery == rhs.pipelineStatisticsQuery ) && ( vertexPipelineStoresAndAtomics == rhs.vertexPipelineStoresAndAtomics ) &&
             ( fragmentStoresAndAtomics == rhs.fragmentStoresAndAtomics ) &&
             ( shaderTessellationAndGeometryPointSize == rhs.shaderTessellationAndGeometryPointSize ) &&
             ( shaderImageGatherExtended == rhs.shaderImageGatherExtended ) && ( shaderStorageImageExtendedFormats == rhs.shaderStorageImageExtendedFormats ) &&
             ( shaderStorageImageMultisample == rhs.shaderStorageImageMultisample ) &&
             ( shaderStorageImageReadWithoutFormat == rhs.shaderStorageImageReadWithoutFormat ) &&
             ( shaderStorageImageWriteWithoutFormat == rhs.shaderStorageImageWriteWithoutFormat ) &&
             ( shaderUniformBufferArrayDynamicIndexing == rhs.shaderUniformBufferArrayDynamicIndexing ) &&
             ( shaderSampledImageArrayDynamicIndexing == rhs.shaderSampledImageArrayDynamicIndexing ) &&
             ( shaderStorageBufferArrayDynamicIndexing == rhs.shaderStorageBufferArrayDynamicIndexing ) &&
             ( shaderStorageImageArrayDynamicIndexing == rhs.shaderStorageImageArrayDynamicIndexing ) && ( shaderClipDistance == rhs.shaderClipDistance ) &&
             ( shaderCullDistance == rhs.shaderCullDistance ) && ( shaderFloat64 == rhs.shaderFloat64 ) && ( shaderInt64 == rhs.shaderInt64 ) &&
             ( shaderInt16 == rhs.shaderInt16 ) && ( shaderResourceResidency == rhs.shaderResourceResidency ) &&
             ( shaderResourceMinLod == rhs.shaderResourceMinLod ) && ( sparseBinding == rhs.sparseBinding ) &&
             ( sparseResidencyBuffer == rhs.sparseResidencyBuffer ) && ( sparseResidencyImage2D == rhs.sparseResidencyImage2D ) &&
             ( sparseResidencyImage3D == rhs.sparseResidencyImage3D ) && ( sparseResidency2Samples == rhs.sparseResidency2Samples ) &&
             ( sparseResidency4Samples == rhs.sparseResidency4Samples ) && ( sparseResidency8Samples == rhs.sparseResidency8Samples ) &&
             ( sparseResidency16Samples == rhs.sparseResidency16Samples ) && ( sparseResidencyAliased == rhs.sparseResidencyAliased ) &&
             ( variableMultisampleRate == rhs.variableMultisampleRate ) && ( inheritedQueries == rhs.inheritedQueries );
#  endif
    }

    bool operator!=( PhysicalDeviceFeatures const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::Bool32 robustBufferAccess                      = {};
    VULKAN_HPP_NAMESPACE::Bool32 fullDrawIndexUint32                     = {};
    VULKAN_HPP_NAMESPACE::Bool32 imageCubeArray                          = {};
    VULKAN_HPP_NAMESPACE::Bool32 independentBlend                        = {};
    VULKAN_HPP_NAMESPACE::Bool32 geometryShader                          = {};
    VULKAN_HPP_NAMESPACE::Bool32 tessellationShader                      = {};
    VULKAN_HPP_NAMESPACE::Bool32 sampleRateShading                       = {};
    VULKAN_HPP_NAMESPACE::Bool32 dualSrcBlend                            = {};
    VULKAN_HPP_NAMESPACE::Bool32 logicOp                                 = {};
    VULKAN_HPP_NAMESPACE::Bool32 multiDrawIndirect                       = {};
    VULKAN_HPP_NAMESPACE::Bool32 drawIndirectFirstInstance               = {};
    VULKAN_HPP_NAMESPACE::Bool32 depthClamp                              = {};
    VULKAN_HPP_NAMESPACE::Bool32 depthBiasClamp                          = {};
    VULKAN_HPP_NAMESPACE::Bool32 fillModeNonSolid                        = {};
    VULKAN_HPP_NAMESPACE::Bool32 depthBounds                             = {};
    VULKAN_HPP_NAMESPACE::Bool32 wideLines                               = {};
    VULKAN_HPP_NAMESPACE::Bool32 largePoints                             = {};
    VULKAN_HPP_NAMESPACE::Bool32 alphaToOne                              = {};
    VULKAN_HPP_NAMESPACE::Bool32 multiViewport                           = {};
    VULKAN_HPP_NAMESPACE::Bool32 samplerAnisotropy                       = {};
    VULKAN_HPP_NAMESPACE::Bool32 textureCompressionETC2                  = {};
    VULKAN_HPP_NAMESPACE::Bool32 textureCompressionASTC_LDR              = {};
    VULKAN_HPP_NAMESPACE::Bool32 textureCompressionBC                    = {};
    VULKAN_HPP_NAMESPACE::Bool32 occlusionQueryPrecise                   = {};
    VULKAN_HPP_NAMESPACE::Bool32 pipelineStatisticsQuery                 = {};
    VULKAN_HPP_NAMESPACE::Bool32 vertexPipelineStoresAndAtomics          = {};
    VULKAN_HPP_NAMESPACE::Bool32 fragmentStoresAndAtomics                = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderTessellationAndGeometryPointSize  = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderImageGatherExtended               = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderStorageImageExtendedFormats       = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderStorageImageMultisample           = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderStorageImageReadWithoutFormat     = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderStorageImageWriteWithoutFormat    = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderUniformBufferArrayDynamicIndexing = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderSampledImageArrayDynamicIndexing  = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderStorageBufferArrayDynamicIndexing = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderStorageImageArrayDynamicIndexing  = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderClipDistance                      = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderCullDistance                      = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderFloat64                           = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderInt64                             = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderInt16                             = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderResourceResidency                 = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderResourceMinLod                    = {};
    VULKAN_HPP_NAMESPACE::Bool32 sparseBinding                           = {};
    VULKAN_HPP_NAMESPACE::Bool32 sparseResidencyBuffer                   = {};
    VULKAN_HPP_NAMESPACE::Bool32 sparseResidencyImage2D                  = {};
    VULKAN_HPP_NAMESPACE::Bool32 sparseResidencyImage3D                  = {};
    VULKAN_HPP_NAMESPACE::Bool32 sparseResidency2Samples                 = {};
    VULKAN_HPP_NAMESPACE::Bool32 sparseResidency4Samples                 = {};
    VULKAN_HPP_NAMESPACE::Bool32 sparseResidency8Samples                 = {};
    VULKAN_HPP_NAMESPACE::Bool32 sparseResidency16Samples                = {};
    VULKAN_HPP_NAMESPACE::Bool32 sparseResidencyAliased                  = {};
    VULKAN_HPP_NAMESPACE::Bool32 variableMultisampleRate                 = {};
    VULKAN_HPP_NAMESPACE::Bool32 inheritedQueries                        = {};
  };

  struct DeviceCreateInfo
  {
    using NativeType = VkDeviceCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDeviceCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DeviceCreateInfo( VULKAN_HPP_NAMESPACE::DeviceCreateFlags              flags_                   = {},
                                           uint32_t                                             queueCreateInfoCount_    = {},
                                           const VULKAN_HPP_NAMESPACE::DeviceQueueCreateInfo *  pQueueCreateInfos_       = {},
                                           uint32_t                                             enabledLayerCount_       = {},
                                           const char * const *                                 ppEnabledLayerNames_     = {},
                                           uint32_t                                             enabledExtensionCount_   = {},
                                           const char * const *                                 ppEnabledExtensionNames_ = {},
                                           const VULKAN_HPP_NAMESPACE::PhysicalDeviceFeatures * pEnabledFeatures_        = {},
                                           const void *                                         pNext_                   = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , queueCreateInfoCount{ queueCreateInfoCount_ }
      , pQueueCreateInfos{ pQueueCreateInfos_ }
      , enabledLayerCount{ enabledLayerCount_ }
      , ppEnabledLayerNames{ ppEnabledLayerNames_ }
      , enabledExtensionCount{ enabledExtensionCount_ }
      , ppEnabledExtensionNames{ ppEnabledExtensionNames_ }
      , pEnabledFeatures{ pEnabledFeatures_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DeviceCreateInfo( DeviceCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DeviceCreateInfo( VkDeviceCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT : DeviceCreateInfo( *reinterpret_cast<DeviceCreateInfo const *>( &rhs ) ) {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DeviceCreateInfo( VULKAN_HPP_NAMESPACE::DeviceCreateFlags                                                                  flags_,
                      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DeviceQueueCreateInfo> const & queueCreateInfos_,
                      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const char * const> const &                                pEnabledLayerNames_     = {},
                      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const char * const> const &                                pEnabledExtensionNames_ = {},
                      const VULKAN_HPP_NAMESPACE::PhysicalDeviceFeatures *                                                     pEnabledFeatures_       = {},
                      const void *                                                                                             pNext_ = nullptr )
      : pNext( pNext_ )
      , flags( flags_ )
      , queueCreateInfoCount( static_cast<uint32_t>( queueCreateInfos_.size() ) )
      , pQueueCreateInfos( queueCreateInfos_.data() )
      , enabledLayerCount( static_cast<uint32_t>( pEnabledLayerNames_.size() ) )
      , ppEnabledLayerNames( pEnabledLayerNames_.data() )
      , enabledExtensionCount( static_cast<uint32_t>( pEnabledExtensionNames_.size() ) )
      , ppEnabledExtensionNames( pEnabledExtensionNames_.data() )
      , pEnabledFeatures( pEnabledFeatures_ )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    DeviceCreateInfo & operator=( DeviceCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DeviceCreateInfo & operator=( VkDeviceCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DeviceCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DeviceCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceCreateInfo & setFlags( VULKAN_HPP_NAMESPACE::DeviceCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceCreateInfo & setQueueCreateInfoCount( uint32_t queueCreateInfoCount_ ) VULKAN_HPP_NOEXCEPT
    {
      queueCreateInfoCount = queueCreateInfoCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceCreateInfo &
      setPQueueCreateInfos( const VULKAN_HPP_NAMESPACE::DeviceQueueCreateInfo * pQueueCreateInfos_ ) VULKAN_HPP_NOEXCEPT
    {
      pQueueCreateInfos = pQueueCreateInfos_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DeviceCreateInfo & setQueueCreateInfos(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DeviceQueueCreateInfo> const & queueCreateInfos_ ) VULKAN_HPP_NOEXCEPT
    {
      queueCreateInfoCount = static_cast<uint32_t>( queueCreateInfos_.size() );
      pQueueCreateInfos    = queueCreateInfos_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 DeviceCreateInfo & setEnabledLayerCount( uint32_t enabledLayerCount_ ) VULKAN_HPP_NOEXCEPT
    {
      enabledLayerCount = enabledLayerCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceCreateInfo & setPpEnabledLayerNames( const char * const * ppEnabledLayerNames_ ) VULKAN_HPP_NOEXCEPT
    {
      ppEnabledLayerNames = ppEnabledLayerNames_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DeviceCreateInfo &
      setPEnabledLayerNames( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const char * const> const & pEnabledLayerNames_ ) VULKAN_HPP_NOEXCEPT
    {
      enabledLayerCount   = static_cast<uint32_t>( pEnabledLayerNames_.size() );
      ppEnabledLayerNames = pEnabledLayerNames_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 DeviceCreateInfo & setEnabledExtensionCount( uint32_t enabledExtensionCount_ ) VULKAN_HPP_NOEXCEPT
    {
      enabledExtensionCount = enabledExtensionCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceCreateInfo & setPpEnabledExtensionNames( const char * const * ppEnabledExtensionNames_ ) VULKAN_HPP_NOEXCEPT
    {
      ppEnabledExtensionNames = ppEnabledExtensionNames_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DeviceCreateInfo &
      setPEnabledExtensionNames( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const char * const> const & pEnabledExtensionNames_ ) VULKAN_HPP_NOEXCEPT
    {
      enabledExtensionCount   = static_cast<uint32_t>( pEnabledExtensionNames_.size() );
      ppEnabledExtensionNames = pEnabledExtensionNames_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 DeviceCreateInfo & setPEnabledFeatures( const VULKAN_HPP_NAMESPACE::PhysicalDeviceFeatures * pEnabledFeatures_ ) VULKAN_HPP_NOEXCEPT
    {
      pEnabledFeatures = pEnabledFeatures_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDeviceCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDeviceCreateInfo *>( this );
    }

    operator VkDeviceCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDeviceCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::DeviceCreateFlags const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::DeviceQueueCreateInfo * const &,
               uint32_t const &,
               const char * const * const &,
               uint32_t const &,
               const char * const * const &,
               const VULKAN_HPP_NAMESPACE::PhysicalDeviceFeatures * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType,
                       pNext,
                       flags,
                       queueCreateInfoCount,
                       pQueueCreateInfos,
                       enabledLayerCount,
                       ppEnabledLayerNames,
                       enabledExtensionCount,
                       ppEnabledExtensionNames,
                       pEnabledFeatures );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    std::strong_ordering operator<=>( DeviceCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      if ( auto cmp = sType <=> rhs.sType; cmp != 0 )
        return cmp;
      if ( auto cmp = pNext <=> rhs.pNext; cmp != 0 )
        return cmp;
      if ( auto cmp = flags <=> rhs.flags; cmp != 0 )
        return cmp;
      if ( auto cmp = queueCreateInfoCount <=> rhs.queueCreateInfoCount; cmp != 0 )
        return cmp;
      if ( auto cmp = pQueueCreateInfos <=> rhs.pQueueCreateInfos; cmp != 0 )
        return cmp;
      if ( auto cmp = enabledLayerCount <=> rhs.enabledLayerCount; cmp != 0 )
        return cmp;
      for ( size_t i = 0; i < enabledLayerCount; ++i )
      {
        if ( ppEnabledLayerNames[i] != rhs.ppEnabledLayerNames[i] )
          if ( auto cmp = strcmp( ppEnabledLayerNames[i], rhs.ppEnabledLayerNames[i] ); cmp != 0 )
            return cmp < 0 ? std::strong_ordering::less : std::strong_ordering::greater;
      }
      if ( auto cmp = enabledExtensionCount <=> rhs.enabledExtensionCount; cmp != 0 )
        return cmp;
      for ( size_t i = 0; i < enabledExtensionCount; ++i )
      {
        if ( ppEnabledExtensionNames[i] != rhs.ppEnabledExtensionNames[i] )
          if ( auto cmp = strcmp( ppEnabledExtensionNames[i], rhs.ppEnabledExtensionNames[i] ); cmp != 0 )
            return cmp < 0 ? std::strong_ordering::less : std::strong_ordering::greater;
      }
      if ( auto cmp = pEnabledFeatures <=> rhs.pEnabledFeatures; cmp != 0 )
        return cmp;

      return std::strong_ordering::equivalent;
    }
#endif

    bool operator==( DeviceCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( queueCreateInfoCount == rhs.queueCreateInfoCount ) &&
             ( pQueueCreateInfos == rhs.pQueueCreateInfos ) && ( enabledLayerCount == rhs.enabledLayerCount ) &&
             std::equal( ppEnabledLayerNames,
                         ppEnabledLayerNames + enabledLayerCount,
                         rhs.ppEnabledLayerNames,
                         []( char const * left, char const * right ) { return ( left == right ) || ( strcmp( left, right ) == 0 ); } ) &&
             ( enabledExtensionCount == rhs.enabledExtensionCount ) &&
             std::equal( ppEnabledExtensionNames,
                         ppEnabledExtensionNames + enabledExtensionCount,
                         rhs.ppEnabledExtensionNames,
                         []( char const * left, char const * right ) { return ( left == right ) || ( strcmp( left, right ) == 0 ); } ) &&
             ( pEnabledFeatures == rhs.pEnabledFeatures );
    }

    bool operator!=( DeviceCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }

  public:
    VULKAN_HPP_NAMESPACE::StructureType                  sType                   = StructureType::eDeviceCreateInfo;
    const void *                                         pNext                   = {};
    VULKAN_HPP_NAMESPACE::DeviceCreateFlags              flags                   = {};
    uint32_t                                             queueCreateInfoCount    = {};
    const VULKAN_HPP_NAMESPACE::DeviceQueueCreateInfo *  pQueueCreateInfos       = {};
    uint32_t                                             enabledLayerCount       = {};
    const char * const *                                 ppEnabledLayerNames     = {};
    uint32_t                                             enabledExtensionCount   = {};
    const char * const *                                 ppEnabledExtensionNames = {};
    const VULKAN_HPP_NAMESPACE::PhysicalDeviceFeatures * pEnabledFeatures        = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eDeviceCreateInfo>
  {
    using Type = DeviceCreateInfo;
  };

  struct DeviceEventInfoEXT
  {
    using NativeType = VkDeviceEventInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDeviceEventInfoEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DeviceEventInfoEXT( VULKAN_HPP_NAMESPACE::DeviceEventTypeEXT deviceEvent_ = VULKAN_HPP_NAMESPACE::DeviceEventTypeEXT::eDisplayHotplug,
                                             const void *                             pNext_       = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , deviceEvent{ deviceEvent_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DeviceEventInfoEXT( DeviceEventInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DeviceEventInfoEXT( VkDeviceEventInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT : DeviceEventInfoEXT( *reinterpret_cast<DeviceEventInfoEXT const *>( &rhs ) ) {}

    DeviceEventInfoEXT & operator=( DeviceEventInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DeviceEventInfoEXT & operator=( VkDeviceEventInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DeviceEventInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DeviceEventInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceEventInfoEXT & setDeviceEvent( VULKAN_HPP_NAMESPACE::DeviceEventTypeEXT deviceEvent_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceEvent = deviceEvent_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDeviceEventInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDeviceEventInfoEXT *>( this );
    }

    operator VkDeviceEventInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDeviceEventInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::DeviceEventTypeEXT const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, deviceEvent );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DeviceEventInfoEXT const & ) const = default;
#else
    bool operator==( DeviceEventInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( deviceEvent == rhs.deviceEvent );
#  endif
    }

    bool operator!=( DeviceEventInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType      sType       = StructureType::eDeviceEventInfoEXT;
    const void *                             pNext       = {};
    VULKAN_HPP_NAMESPACE::DeviceEventTypeEXT deviceEvent = VULKAN_HPP_NAMESPACE::DeviceEventTypeEXT::eDisplayHotplug;
  };

  template <>
  struct CppType<StructureType, StructureType::eDeviceEventInfoEXT>
  {
    using Type = DeviceEventInfoEXT;
  };

  struct DeviceGroupCommandBufferBeginInfo
  {
    using NativeType = VkDeviceGroupCommandBufferBeginInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDeviceGroupCommandBufferBeginInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DeviceGroupCommandBufferBeginInfo( uint32_t deviceMask_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , deviceMask{ deviceMask_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DeviceGroupCommandBufferBeginInfo( DeviceGroupCommandBufferBeginInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DeviceGroupCommandBufferBeginInfo( VkDeviceGroupCommandBufferBeginInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : DeviceGroupCommandBufferBeginInfo( *reinterpret_cast<DeviceGroupCommandBufferBeginInfo const *>( &rhs ) )
    {
    }

    DeviceGroupCommandBufferBeginInfo & operator=( DeviceGroupCommandBufferBeginInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DeviceGroupCommandBufferBeginInfo & operator=( VkDeviceGroupCommandBufferBeginInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DeviceGroupCommandBufferBeginInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DeviceGroupCommandBufferBeginInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceGroupCommandBufferBeginInfo & setDeviceMask( uint32_t deviceMask_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceMask = deviceMask_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDeviceGroupCommandBufferBeginInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDeviceGroupCommandBufferBeginInfo *>( this );
    }

    operator VkDeviceGroupCommandBufferBeginInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDeviceGroupCommandBufferBeginInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, deviceMask );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DeviceGroupCommandBufferBeginInfo const & ) const = default;
#else
    bool operator==( DeviceGroupCommandBufferBeginInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( deviceMask == rhs.deviceMask );
#  endif
    }

    bool operator!=( DeviceGroupCommandBufferBeginInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType      = StructureType::eDeviceGroupCommandBufferBeginInfo;
    const void *                        pNext      = {};
    uint32_t                            deviceMask = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eDeviceGroupCommandBufferBeginInfo>
  {
    using Type = DeviceGroupCommandBufferBeginInfo;
  };

  using DeviceGroupCommandBufferBeginInfoKHR = DeviceGroupCommandBufferBeginInfo;

  struct DeviceGroupDeviceCreateInfo
  {
    using NativeType = VkDeviceGroupDeviceCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDeviceGroupDeviceCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DeviceGroupDeviceCreateInfo( uint32_t                                     physicalDeviceCount_ = {},
                                                      const VULKAN_HPP_NAMESPACE::PhysicalDevice * pPhysicalDevices_    = {},
                                                      const void *                                 pNext_               = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , physicalDeviceCount{ physicalDeviceCount_ }
      , pPhysicalDevices{ pPhysicalDevices_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DeviceGroupDeviceCreateInfo( DeviceGroupDeviceCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DeviceGroupDeviceCreateInfo( VkDeviceGroupDeviceCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : DeviceGroupDeviceCreateInfo( *reinterpret_cast<DeviceGroupDeviceCreateInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DeviceGroupDeviceCreateInfo( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::PhysicalDevice> const & physicalDevices_,
                                 const void *                                                                                      pNext_ = nullptr )
      : pNext( pNext_ ), physicalDeviceCount( static_cast<uint32_t>( physicalDevices_.size() ) ), pPhysicalDevices( physicalDevices_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    DeviceGroupDeviceCreateInfo & operator=( DeviceGroupDeviceCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DeviceGroupDeviceCreateInfo & operator=( VkDeviceGroupDeviceCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DeviceGroupDeviceCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DeviceGroupDeviceCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceGroupDeviceCreateInfo & setPhysicalDeviceCount( uint32_t physicalDeviceCount_ ) VULKAN_HPP_NOEXCEPT
    {
      physicalDeviceCount = physicalDeviceCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceGroupDeviceCreateInfo &
      setPPhysicalDevices( const VULKAN_HPP_NAMESPACE::PhysicalDevice * pPhysicalDevices_ ) VULKAN_HPP_NOEXCEPT
    {
      pPhysicalDevices = pPhysicalDevices_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DeviceGroupDeviceCreateInfo & setPhysicalDevices(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::PhysicalDevice> const & physicalDevices_ ) VULKAN_HPP_NOEXCEPT
    {
      physicalDeviceCount = static_cast<uint32_t>( physicalDevices_.size() );
      pPhysicalDevices    = physicalDevices_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDeviceGroupDeviceCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDeviceGroupDeviceCreateInfo *>( this );
    }

    operator VkDeviceGroupDeviceCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDeviceGroupDeviceCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, uint32_t const &, const VULKAN_HPP_NAMESPACE::PhysicalDevice * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, physicalDeviceCount, pPhysicalDevices );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DeviceGroupDeviceCreateInfo const & ) const = default;
#else
    bool operator==( DeviceGroupDeviceCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( physicalDeviceCount == rhs.physicalDeviceCount ) &&
             ( pPhysicalDevices == rhs.pPhysicalDevices );
#  endif
    }

    bool operator!=( DeviceGroupDeviceCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType          sType               = StructureType::eDeviceGroupDeviceCreateInfo;
    const void *                                 pNext               = {};
    uint32_t                                     physicalDeviceCount = {};
    const VULKAN_HPP_NAMESPACE::PhysicalDevice * pPhysicalDevices    = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eDeviceGroupDeviceCreateInfo>
  {
    using Type = DeviceGroupDeviceCreateInfo;
  };

  using DeviceGroupDeviceCreateInfoKHR = DeviceGroupDeviceCreateInfo;

  struct DeviceGroupPresentCapabilitiesKHR
  {
    using NativeType = VkDeviceGroupPresentCapabilitiesKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDeviceGroupPresentCapabilitiesKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 DeviceGroupPresentCapabilitiesKHR( std::array<uint32_t, VK_MAX_DEVICE_GROUP_SIZE> const & presentMask_ = {},
                                                               VULKAN_HPP_NAMESPACE::DeviceGroupPresentModeFlagsKHR   modes_       = {},
                                                               void *                                                 pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , presentMask{ presentMask_ }
      , modes{ modes_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceGroupPresentCapabilitiesKHR( DeviceGroupPresentCapabilitiesKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DeviceGroupPresentCapabilitiesKHR( VkDeviceGroupPresentCapabilitiesKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : DeviceGroupPresentCapabilitiesKHR( *reinterpret_cast<DeviceGroupPresentCapabilitiesKHR const *>( &rhs ) )
    {
    }

    DeviceGroupPresentCapabilitiesKHR & operator=( DeviceGroupPresentCapabilitiesKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DeviceGroupPresentCapabilitiesKHR & operator=( VkDeviceGroupPresentCapabilitiesKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DeviceGroupPresentCapabilitiesKHR const *>( &rhs );
      return *this;
    }

    operator VkDeviceGroupPresentCapabilitiesKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDeviceGroupPresentCapabilitiesKHR *>( this );
    }

    operator VkDeviceGroupPresentCapabilitiesKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDeviceGroupPresentCapabilitiesKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               void * const &,
               VULKAN_HPP_NAMESPACE::ArrayWrapper1D<uint32_t, VK_MAX_DEVICE_GROUP_SIZE> const &,
               VULKAN_HPP_NAMESPACE::DeviceGroupPresentModeFlagsKHR const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, presentMask, modes );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DeviceGroupPresentCapabilitiesKHR const & ) const = default;
#else
    bool operator==( DeviceGroupPresentCapabilitiesKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( presentMask == rhs.presentMask ) && ( modes == rhs.modes );
#  endif
    }

    bool operator!=( DeviceGroupPresentCapabilitiesKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                                      sType       = StructureType::eDeviceGroupPresentCapabilitiesKHR;
    void *                                                                   pNext       = {};
    VULKAN_HPP_NAMESPACE::ArrayWrapper1D<uint32_t, VK_MAX_DEVICE_GROUP_SIZE> presentMask = {};
    VULKAN_HPP_NAMESPACE::DeviceGroupPresentModeFlagsKHR                     modes       = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eDeviceGroupPresentCapabilitiesKHR>
  {
    using Type = DeviceGroupPresentCapabilitiesKHR;
  };

  struct DeviceGroupPresentInfoKHR
  {
    using NativeType = VkDeviceGroupPresentInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDeviceGroupPresentInfoKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DeviceGroupPresentInfoKHR(
      uint32_t                                                swapchainCount_ = {},
      const uint32_t *                                        pDeviceMasks_   = {},
      VULKAN_HPP_NAMESPACE::DeviceGroupPresentModeFlagBitsKHR mode_           = VULKAN_HPP_NAMESPACE::DeviceGroupPresentModeFlagBitsKHR::eLocal,
      const void *                                            pNext_          = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , swapchainCount{ swapchainCount_ }
      , pDeviceMasks{ pDeviceMasks_ }
      , mode{ mode_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DeviceGroupPresentInfoKHR( DeviceGroupPresentInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DeviceGroupPresentInfoKHR( VkDeviceGroupPresentInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : DeviceGroupPresentInfoKHR( *reinterpret_cast<DeviceGroupPresentInfoKHR const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DeviceGroupPresentInfoKHR( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint32_t> const & deviceMasks_,
                               VULKAN_HPP_NAMESPACE::DeviceGroupPresentModeFlagBitsKHR mode_  = VULKAN_HPP_NAMESPACE::DeviceGroupPresentModeFlagBitsKHR::eLocal,
                               const void *                                            pNext_ = nullptr )
      : pNext( pNext_ ), swapchainCount( static_cast<uint32_t>( deviceMasks_.size() ) ), pDeviceMasks( deviceMasks_.data() ), mode( mode_ )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    DeviceGroupPresentInfoKHR & operator=( DeviceGroupPresentInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DeviceGroupPresentInfoKHR & operator=( VkDeviceGroupPresentInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DeviceGroupPresentInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DeviceGroupPresentInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceGroupPresentInfoKHR & setSwapchainCount( uint32_t swapchainCount_ ) VULKAN_HPP_NOEXCEPT
    {
      swapchainCount = swapchainCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceGroupPresentInfoKHR & setPDeviceMasks( const uint32_t * pDeviceMasks_ ) VULKAN_HPP_NOEXCEPT
    {
      pDeviceMasks = pDeviceMasks_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DeviceGroupPresentInfoKHR & setDeviceMasks( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint32_t> const & deviceMasks_ ) VULKAN_HPP_NOEXCEPT
    {
      swapchainCount = static_cast<uint32_t>( deviceMasks_.size() );
      pDeviceMasks   = deviceMasks_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 DeviceGroupPresentInfoKHR & setMode( VULKAN_HPP_NAMESPACE::DeviceGroupPresentModeFlagBitsKHR mode_ ) VULKAN_HPP_NOEXCEPT
    {
      mode = mode_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDeviceGroupPresentInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDeviceGroupPresentInfoKHR *>( this );
    }

    operator VkDeviceGroupPresentInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDeviceGroupPresentInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               uint32_t const &,
               const uint32_t * const &,
               VULKAN_HPP_NAMESPACE::DeviceGroupPresentModeFlagBitsKHR const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, swapchainCount, pDeviceMasks, mode );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DeviceGroupPresentInfoKHR const & ) const = default;
#else
    bool operator==( DeviceGroupPresentInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( swapchainCount == rhs.swapchainCount ) && ( pDeviceMasks == rhs.pDeviceMasks ) &&
             ( mode == rhs.mode );
#  endif
    }

    bool operator!=( DeviceGroupPresentInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                     sType          = StructureType::eDeviceGroupPresentInfoKHR;
    const void *                                            pNext          = {};
    uint32_t                                                swapchainCount = {};
    const uint32_t *                                        pDeviceMasks   = {};
    VULKAN_HPP_NAMESPACE::DeviceGroupPresentModeFlagBitsKHR mode           = VULKAN_HPP_NAMESPACE::DeviceGroupPresentModeFlagBitsKHR::eLocal;
  };

  template <>
  struct CppType<StructureType, StructureType::eDeviceGroupPresentInfoKHR>
  {
    using Type = DeviceGroupPresentInfoKHR;
  };

  struct DeviceGroupRenderPassBeginInfo
  {
    using NativeType = VkDeviceGroupRenderPassBeginInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDeviceGroupRenderPassBeginInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DeviceGroupRenderPassBeginInfo( uint32_t                             deviceMask_            = {},
                                                         uint32_t                             deviceRenderAreaCount_ = {},
                                                         const VULKAN_HPP_NAMESPACE::Rect2D * pDeviceRenderAreas_    = {},
                                                         const void *                         pNext_                 = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , deviceMask{ deviceMask_ }
      , deviceRenderAreaCount{ deviceRenderAreaCount_ }
      , pDeviceRenderAreas{ pDeviceRenderAreas_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DeviceGroupRenderPassBeginInfo( DeviceGroupRenderPassBeginInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DeviceGroupRenderPassBeginInfo( VkDeviceGroupRenderPassBeginInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : DeviceGroupRenderPassBeginInfo( *reinterpret_cast<DeviceGroupRenderPassBeginInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DeviceGroupRenderPassBeginInfo( uint32_t                                                                                  deviceMask_,
                                    VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::Rect2D> const & deviceRenderAreas_,
                                    const void *                                                                              pNext_ = nullptr )
      : pNext( pNext_ )
      , deviceMask( deviceMask_ )
      , deviceRenderAreaCount( static_cast<uint32_t>( deviceRenderAreas_.size() ) )
      , pDeviceRenderAreas( deviceRenderAreas_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    DeviceGroupRenderPassBeginInfo & operator=( DeviceGroupRenderPassBeginInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DeviceGroupRenderPassBeginInfo & operator=( VkDeviceGroupRenderPassBeginInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DeviceGroupRenderPassBeginInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DeviceGroupRenderPassBeginInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceGroupRenderPassBeginInfo & setDeviceMask( uint32_t deviceMask_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceMask = deviceMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceGroupRenderPassBeginInfo & setDeviceRenderAreaCount( uint32_t deviceRenderAreaCount_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceRenderAreaCount = deviceRenderAreaCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceGroupRenderPassBeginInfo &
      setPDeviceRenderAreas( const VULKAN_HPP_NAMESPACE::Rect2D * pDeviceRenderAreas_ ) VULKAN_HPP_NOEXCEPT
    {
      pDeviceRenderAreas = pDeviceRenderAreas_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DeviceGroupRenderPassBeginInfo &
      setDeviceRenderAreas( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::Rect2D> const & deviceRenderAreas_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceRenderAreaCount = static_cast<uint32_t>( deviceRenderAreas_.size() );
      pDeviceRenderAreas    = deviceRenderAreas_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDeviceGroupRenderPassBeginInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDeviceGroupRenderPassBeginInfo *>( this );
    }

    operator VkDeviceGroupRenderPassBeginInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDeviceGroupRenderPassBeginInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::
      tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, uint32_t const &, uint32_t const &, const VULKAN_HPP_NAMESPACE::Rect2D * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, deviceMask, deviceRenderAreaCount, pDeviceRenderAreas );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DeviceGroupRenderPassBeginInfo const & ) const = default;
#else
    bool operator==( DeviceGroupRenderPassBeginInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( deviceMask == rhs.deviceMask ) && ( deviceRenderAreaCount == rhs.deviceRenderAreaCount ) &&
             ( pDeviceRenderAreas == rhs.pDeviceRenderAreas );
#  endif
    }

    bool operator!=( DeviceGroupRenderPassBeginInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType  sType                 = StructureType::eDeviceGroupRenderPassBeginInfo;
    const void *                         pNext                 = {};
    uint32_t                             deviceMask            = {};
    uint32_t                             deviceRenderAreaCount = {};
    const VULKAN_HPP_NAMESPACE::Rect2D * pDeviceRenderAreas    = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eDeviceGroupRenderPassBeginInfo>
  {
    using Type = DeviceGroupRenderPassBeginInfo;
  };

  using DeviceGroupRenderPassBeginInfoKHR = DeviceGroupRenderPassBeginInfo;

  struct DeviceGroupSubmitInfo
  {
    using NativeType = VkDeviceGroupSubmitInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDeviceGroupSubmitInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DeviceGroupSubmitInfo( uint32_t         waitSemaphoreCount_            = {},
                                                const uint32_t * pWaitSemaphoreDeviceIndices_   = {},
                                                uint32_t         commandBufferCount_            = {},
                                                const uint32_t * pCommandBufferDeviceMasks_     = {},
                                                uint32_t         signalSemaphoreCount_          = {},
                                                const uint32_t * pSignalSemaphoreDeviceIndices_ = {},
                                                const void *     pNext_                         = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , waitSemaphoreCount{ waitSemaphoreCount_ }
      , pWaitSemaphoreDeviceIndices{ pWaitSemaphoreDeviceIndices_ }
      , commandBufferCount{ commandBufferCount_ }
      , pCommandBufferDeviceMasks{ pCommandBufferDeviceMasks_ }
      , signalSemaphoreCount{ signalSemaphoreCount_ }
      , pSignalSemaphoreDeviceIndices{ pSignalSemaphoreDeviceIndices_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DeviceGroupSubmitInfo( DeviceGroupSubmitInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DeviceGroupSubmitInfo( VkDeviceGroupSubmitInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : DeviceGroupSubmitInfo( *reinterpret_cast<DeviceGroupSubmitInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DeviceGroupSubmitInfo( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint32_t> const & waitSemaphoreDeviceIndices_,
                           VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint32_t> const & commandBufferDeviceMasks_     = {},
                           VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint32_t> const & signalSemaphoreDeviceIndices_ = {},
                           const void *                                                          pNext_                        = nullptr )
      : pNext( pNext_ )
      , waitSemaphoreCount( static_cast<uint32_t>( waitSemaphoreDeviceIndices_.size() ) )
      , pWaitSemaphoreDeviceIndices( waitSemaphoreDeviceIndices_.data() )
      , commandBufferCount( static_cast<uint32_t>( commandBufferDeviceMasks_.size() ) )
      , pCommandBufferDeviceMasks( commandBufferDeviceMasks_.data() )
      , signalSemaphoreCount( static_cast<uint32_t>( signalSemaphoreDeviceIndices_.size() ) )
      , pSignalSemaphoreDeviceIndices( signalSemaphoreDeviceIndices_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    DeviceGroupSubmitInfo & operator=( DeviceGroupSubmitInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DeviceGroupSubmitInfo & operator=( VkDeviceGroupSubmitInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DeviceGroupSubmitInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DeviceGroupSubmitInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceGroupSubmitInfo & setWaitSemaphoreCount( uint32_t waitSemaphoreCount_ ) VULKAN_HPP_NOEXCEPT
    {
      waitSemaphoreCount = waitSemaphoreCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceGroupSubmitInfo & setPWaitSemaphoreDeviceIndices( const uint32_t * pWaitSemaphoreDeviceIndices_ ) VULKAN_HPP_NOEXCEPT
    {
      pWaitSemaphoreDeviceIndices = pWaitSemaphoreDeviceIndices_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DeviceGroupSubmitInfo &
      setWaitSemaphoreDeviceIndices( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint32_t> const & waitSemaphoreDeviceIndices_ ) VULKAN_HPP_NOEXCEPT
    {
      waitSemaphoreCount          = static_cast<uint32_t>( waitSemaphoreDeviceIndices_.size() );
      pWaitSemaphoreDeviceIndices = waitSemaphoreDeviceIndices_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 DeviceGroupSubmitInfo & setCommandBufferCount( uint32_t commandBufferCount_ ) VULKAN_HPP_NOEXCEPT
    {
      commandBufferCount = commandBufferCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceGroupSubmitInfo & setPCommandBufferDeviceMasks( const uint32_t * pCommandBufferDeviceMasks_ ) VULKAN_HPP_NOEXCEPT
    {
      pCommandBufferDeviceMasks = pCommandBufferDeviceMasks_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DeviceGroupSubmitInfo &
      setCommandBufferDeviceMasks( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint32_t> const & commandBufferDeviceMasks_ ) VULKAN_HPP_NOEXCEPT
    {
      commandBufferCount        = static_cast<uint32_t>( commandBufferDeviceMasks_.size() );
      pCommandBufferDeviceMasks = commandBufferDeviceMasks_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 DeviceGroupSubmitInfo & setSignalSemaphoreCount( uint32_t signalSemaphoreCount_ ) VULKAN_HPP_NOEXCEPT
    {
      signalSemaphoreCount = signalSemaphoreCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceGroupSubmitInfo & setPSignalSemaphoreDeviceIndices( const uint32_t * pSignalSemaphoreDeviceIndices_ ) VULKAN_HPP_NOEXCEPT
    {
      pSignalSemaphoreDeviceIndices = pSignalSemaphoreDeviceIndices_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DeviceGroupSubmitInfo &
      setSignalSemaphoreDeviceIndices( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint32_t> const & signalSemaphoreDeviceIndices_ ) VULKAN_HPP_NOEXCEPT
    {
      signalSemaphoreCount          = static_cast<uint32_t>( signalSemaphoreDeviceIndices_.size() );
      pSignalSemaphoreDeviceIndices = signalSemaphoreDeviceIndices_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDeviceGroupSubmitInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDeviceGroupSubmitInfo *>( this );
    }

    operator VkDeviceGroupSubmitInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDeviceGroupSubmitInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               uint32_t const &,
               const uint32_t * const &,
               uint32_t const &,
               const uint32_t * const &,
               uint32_t const &,
               const uint32_t * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType,
                       pNext,
                       waitSemaphoreCount,
                       pWaitSemaphoreDeviceIndices,
                       commandBufferCount,
                       pCommandBufferDeviceMasks,
                       signalSemaphoreCount,
                       pSignalSemaphoreDeviceIndices );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DeviceGroupSubmitInfo const & ) const = default;
#else
    bool operator==( DeviceGroupSubmitInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( waitSemaphoreCount == rhs.waitSemaphoreCount ) &&
             ( pWaitSemaphoreDeviceIndices == rhs.pWaitSemaphoreDeviceIndices ) && ( commandBufferCount == rhs.commandBufferCount ) &&
             ( pCommandBufferDeviceMasks == rhs.pCommandBufferDeviceMasks ) && ( signalSemaphoreCount == rhs.signalSemaphoreCount ) &&
             ( pSignalSemaphoreDeviceIndices == rhs.pSignalSemaphoreDeviceIndices );
#  endif
    }

    bool operator!=( DeviceGroupSubmitInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType                         = StructureType::eDeviceGroupSubmitInfo;
    const void *                        pNext                         = {};
    uint32_t                            waitSemaphoreCount            = {};
    const uint32_t *                    pWaitSemaphoreDeviceIndices   = {};
    uint32_t                            commandBufferCount            = {};
    const uint32_t *                    pCommandBufferDeviceMasks     = {};
    uint32_t                            signalSemaphoreCount          = {};
    const uint32_t *                    pSignalSemaphoreDeviceIndices = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eDeviceGroupSubmitInfo>
  {
    using Type = DeviceGroupSubmitInfo;
  };

  using DeviceGroupSubmitInfoKHR = DeviceGroupSubmitInfo;

  struct DeviceGroupSwapchainCreateInfoKHR
  {
    using NativeType = VkDeviceGroupSwapchainCreateInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDeviceGroupSwapchainCreateInfoKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DeviceGroupSwapchainCreateInfoKHR( VULKAN_HPP_NAMESPACE::DeviceGroupPresentModeFlagsKHR modes_ = {},
                                                            const void *                                         pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , modes{ modes_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DeviceGroupSwapchainCreateInfoKHR( DeviceGroupSwapchainCreateInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DeviceGroupSwapchainCreateInfoKHR( VkDeviceGroupSwapchainCreateInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : DeviceGroupSwapchainCreateInfoKHR( *reinterpret_cast<DeviceGroupSwapchainCreateInfoKHR const *>( &rhs ) )
    {
    }

    DeviceGroupSwapchainCreateInfoKHR & operator=( DeviceGroupSwapchainCreateInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DeviceGroupSwapchainCreateInfoKHR & operator=( VkDeviceGroupSwapchainCreateInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DeviceGroupSwapchainCreateInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DeviceGroupSwapchainCreateInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceGroupSwapchainCreateInfoKHR & setModes( VULKAN_HPP_NAMESPACE::DeviceGroupPresentModeFlagsKHR modes_ ) VULKAN_HPP_NOEXCEPT
    {
      modes = modes_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDeviceGroupSwapchainCreateInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDeviceGroupSwapchainCreateInfoKHR *>( this );
    }

    operator VkDeviceGroupSwapchainCreateInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDeviceGroupSwapchainCreateInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::DeviceGroupPresentModeFlagsKHR const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, modes );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DeviceGroupSwapchainCreateInfoKHR const & ) const = default;
#else
    bool operator==( DeviceGroupSwapchainCreateInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( modes == rhs.modes );
#  endif
    }

    bool operator!=( DeviceGroupSwapchainCreateInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                  sType = StructureType::eDeviceGroupSwapchainCreateInfoKHR;
    const void *                                         pNext = {};
    VULKAN_HPP_NAMESPACE::DeviceGroupPresentModeFlagsKHR modes = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eDeviceGroupSwapchainCreateInfoKHR>
  {
    using Type = DeviceGroupSwapchainCreateInfoKHR;
  };

  struct ImageCreateInfo
  {
    using NativeType = VkImageCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eImageCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ImageCreateInfo( VULKAN_HPP_NAMESPACE::ImageCreateFlags    flags_                 = {},
                                          VULKAN_HPP_NAMESPACE::ImageType           imageType_             = VULKAN_HPP_NAMESPACE::ImageType::e1D,
                                          VULKAN_HPP_NAMESPACE::Format              format_                = VULKAN_HPP_NAMESPACE::Format::eUndefined,
                                          VULKAN_HPP_NAMESPACE::Extent3D            extent_                = {},
                                          uint32_t                                  mipLevels_             = {},
                                          uint32_t                                  arrayLayers_           = {},
                                          VULKAN_HPP_NAMESPACE::SampleCountFlagBits samples_               = VULKAN_HPP_NAMESPACE::SampleCountFlagBits::e1,
                                          VULKAN_HPP_NAMESPACE::ImageTiling         tiling_                = VULKAN_HPP_NAMESPACE::ImageTiling::eOptimal,
                                          VULKAN_HPP_NAMESPACE::ImageUsageFlags     usage_                 = {},
                                          VULKAN_HPP_NAMESPACE::SharingMode         sharingMode_           = VULKAN_HPP_NAMESPACE::SharingMode::eExclusive,
                                          uint32_t                                  queueFamilyIndexCount_ = {},
                                          const uint32_t *                          pQueueFamilyIndices_   = {},
                                          VULKAN_HPP_NAMESPACE::ImageLayout         initialLayout_         = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                                          const void *                              pNext_                 = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , imageType{ imageType_ }
      , format{ format_ }
      , extent{ extent_ }
      , mipLevels{ mipLevels_ }
      , arrayLayers{ arrayLayers_ }
      , samples{ samples_ }
      , tiling{ tiling_ }
      , usage{ usage_ }
      , sharingMode{ sharingMode_ }
      , queueFamilyIndexCount{ queueFamilyIndexCount_ }
      , pQueueFamilyIndices{ pQueueFamilyIndices_ }
      , initialLayout{ initialLayout_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ImageCreateInfo( ImageCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageCreateInfo( VkImageCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT : ImageCreateInfo( *reinterpret_cast<ImageCreateInfo const *>( &rhs ) ) {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    ImageCreateInfo( VULKAN_HPP_NAMESPACE::ImageCreateFlags                                flags_,
                     VULKAN_HPP_NAMESPACE::ImageType                                       imageType_,
                     VULKAN_HPP_NAMESPACE::Format                                          format_,
                     VULKAN_HPP_NAMESPACE::Extent3D                                        extent_,
                     uint32_t                                                              mipLevels_,
                     uint32_t                                                              arrayLayers_,
                     VULKAN_HPP_NAMESPACE::SampleCountFlagBits                             samples_,
                     VULKAN_HPP_NAMESPACE::ImageTiling                                     tiling_,
                     VULKAN_HPP_NAMESPACE::ImageUsageFlags                                 usage_,
                     VULKAN_HPP_NAMESPACE::SharingMode                                     sharingMode_,
                     VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint32_t> const & queueFamilyIndices_,
                     VULKAN_HPP_NAMESPACE::ImageLayout                                     initialLayout_ = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                     const void *                                                          pNext_         = nullptr )
      : pNext( pNext_ )
      , flags( flags_ )
      , imageType( imageType_ )
      , format( format_ )
      , extent( extent_ )
      , mipLevels( mipLevels_ )
      , arrayLayers( arrayLayers_ )
      , samples( samples_ )
      , tiling( tiling_ )
      , usage( usage_ )
      , sharingMode( sharingMode_ )
      , queueFamilyIndexCount( static_cast<uint32_t>( queueFamilyIndices_.size() ) )
      , pQueueFamilyIndices( queueFamilyIndices_.data() )
      , initialLayout( initialLayout_ )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    ImageCreateInfo & operator=( ImageCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ImageCreateInfo & operator=( VkImageCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ImageCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ImageCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageCreateInfo & setFlags( VULKAN_HPP_NAMESPACE::ImageCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageCreateInfo & setImageType( VULKAN_HPP_NAMESPACE::ImageType imageType_ ) VULKAN_HPP_NOEXCEPT
    {
      imageType = imageType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageCreateInfo & setFormat( VULKAN_HPP_NAMESPACE::Format format_ ) VULKAN_HPP_NOEXCEPT
    {
      format = format_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageCreateInfo & setExtent( VULKAN_HPP_NAMESPACE::Extent3D const & extent_ ) VULKAN_HPP_NOEXCEPT
    {
      extent = extent_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageCreateInfo & setMipLevels( uint32_t mipLevels_ ) VULKAN_HPP_NOEXCEPT
    {
      mipLevels = mipLevels_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageCreateInfo & setArrayLayers( uint32_t arrayLayers_ ) VULKAN_HPP_NOEXCEPT
    {
      arrayLayers = arrayLayers_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageCreateInfo & setSamples( VULKAN_HPP_NAMESPACE::SampleCountFlagBits samples_ ) VULKAN_HPP_NOEXCEPT
    {
      samples = samples_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageCreateInfo & setTiling( VULKAN_HPP_NAMESPACE::ImageTiling tiling_ ) VULKAN_HPP_NOEXCEPT
    {
      tiling = tiling_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageCreateInfo & setUsage( VULKAN_HPP_NAMESPACE::ImageUsageFlags usage_ ) VULKAN_HPP_NOEXCEPT
    {
      usage = usage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageCreateInfo & setSharingMode( VULKAN_HPP_NAMESPACE::SharingMode sharingMode_ ) VULKAN_HPP_NOEXCEPT
    {
      sharingMode = sharingMode_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageCreateInfo & setQueueFamilyIndexCount( uint32_t queueFamilyIndexCount_ ) VULKAN_HPP_NOEXCEPT
    {
      queueFamilyIndexCount = queueFamilyIndexCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageCreateInfo & setPQueueFamilyIndices( const uint32_t * pQueueFamilyIndices_ ) VULKAN_HPP_NOEXCEPT
    {
      pQueueFamilyIndices = pQueueFamilyIndices_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    ImageCreateInfo & setQueueFamilyIndices( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint32_t> const & queueFamilyIndices_ ) VULKAN_HPP_NOEXCEPT
    {
      queueFamilyIndexCount = static_cast<uint32_t>( queueFamilyIndices_.size() );
      pQueueFamilyIndices   = queueFamilyIndices_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 ImageCreateInfo & setInitialLayout( VULKAN_HPP_NAMESPACE::ImageLayout initialLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      initialLayout = initialLayout_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkImageCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkImageCreateInfo *>( this );
    }

    operator VkImageCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkImageCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::ImageCreateFlags const &,
               VULKAN_HPP_NAMESPACE::ImageType const &,
               VULKAN_HPP_NAMESPACE::Format const &,
               VULKAN_HPP_NAMESPACE::Extent3D const &,
               uint32_t const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::SampleCountFlagBits const &,
               VULKAN_HPP_NAMESPACE::ImageTiling const &,
               VULKAN_HPP_NAMESPACE::ImageUsageFlags const &,
               VULKAN_HPP_NAMESPACE::SharingMode const &,
               uint32_t const &,
               const uint32_t * const &,
               VULKAN_HPP_NAMESPACE::ImageLayout const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType,
                       pNext,
                       flags,
                       imageType,
                       format,
                       extent,
                       mipLevels,
                       arrayLayers,
                       samples,
                       tiling,
                       usage,
                       sharingMode,
                       queueFamilyIndexCount,
                       pQueueFamilyIndices,
                       initialLayout );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ImageCreateInfo const & ) const = default;
#else
    bool operator==( ImageCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( imageType == rhs.imageType ) && ( format == rhs.format ) &&
             ( extent == rhs.extent ) && ( mipLevels == rhs.mipLevels ) && ( arrayLayers == rhs.arrayLayers ) && ( samples == rhs.samples ) &&
             ( tiling == rhs.tiling ) && ( usage == rhs.usage ) && ( sharingMode == rhs.sharingMode ) &&
             ( queueFamilyIndexCount == rhs.queueFamilyIndexCount ) && ( pQueueFamilyIndices == rhs.pQueueFamilyIndices ) &&
             ( initialLayout == rhs.initialLayout );
#  endif
    }

    bool operator!=( ImageCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType       sType                 = StructureType::eImageCreateInfo;
    const void *                              pNext                 = {};
    VULKAN_HPP_NAMESPACE::ImageCreateFlags    flags                 = {};
    VULKAN_HPP_NAMESPACE::ImageType           imageType             = VULKAN_HPP_NAMESPACE::ImageType::e1D;
    VULKAN_HPP_NAMESPACE::Format              format                = VULKAN_HPP_NAMESPACE::Format::eUndefined;
    VULKAN_HPP_NAMESPACE::Extent3D            extent                = {};
    uint32_t                                  mipLevels             = {};
    uint32_t                                  arrayLayers           = {};
    VULKAN_HPP_NAMESPACE::SampleCountFlagBits samples               = VULKAN_HPP_NAMESPACE::SampleCountFlagBits::e1;
    VULKAN_HPP_NAMESPACE::ImageTiling         tiling                = VULKAN_HPP_NAMESPACE::ImageTiling::eOptimal;
    VULKAN_HPP_NAMESPACE::ImageUsageFlags     usage                 = {};
    VULKAN_HPP_NAMESPACE::SharingMode         sharingMode           = VULKAN_HPP_NAMESPACE::SharingMode::eExclusive;
    uint32_t                                  queueFamilyIndexCount = {};
    const uint32_t *                          pQueueFamilyIndices   = {};
    VULKAN_HPP_NAMESPACE::ImageLayout         initialLayout         = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
  };

  template <>
  struct CppType<StructureType, StructureType::eImageCreateInfo>
  {
    using Type = ImageCreateInfo;
  };

  struct DeviceImageMemoryRequirements
  {
    using NativeType = VkDeviceImageMemoryRequirements;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDeviceImageMemoryRequirements;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      DeviceImageMemoryRequirements( const VULKAN_HPP_NAMESPACE::ImageCreateInfo * pCreateInfo_ = {},
                                     VULKAN_HPP_NAMESPACE::ImageAspectFlagBits     planeAspect_ = VULKAN_HPP_NAMESPACE::ImageAspectFlagBits::eColor,
                                     const void *                                  pNext_       = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , pCreateInfo{ pCreateInfo_ }
      , planeAspect{ planeAspect_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DeviceImageMemoryRequirements( DeviceImageMemoryRequirements const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DeviceImageMemoryRequirements( VkDeviceImageMemoryRequirements const & rhs ) VULKAN_HPP_NOEXCEPT
      : DeviceImageMemoryRequirements( *reinterpret_cast<DeviceImageMemoryRequirements const *>( &rhs ) )
    {
    }

    DeviceImageMemoryRequirements & operator=( DeviceImageMemoryRequirements const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DeviceImageMemoryRequirements & operator=( VkDeviceImageMemoryRequirements const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DeviceImageMemoryRequirements const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DeviceImageMemoryRequirements & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceImageMemoryRequirements & setPCreateInfo( const VULKAN_HPP_NAMESPACE::ImageCreateInfo * pCreateInfo_ ) VULKAN_HPP_NOEXCEPT
    {
      pCreateInfo = pCreateInfo_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceImageMemoryRequirements & setPlaneAspect( VULKAN_HPP_NAMESPACE::ImageAspectFlagBits planeAspect_ ) VULKAN_HPP_NOEXCEPT
    {
      planeAspect = planeAspect_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDeviceImageMemoryRequirements const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDeviceImageMemoryRequirements *>( this );
    }

    operator VkDeviceImageMemoryRequirements &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDeviceImageMemoryRequirements *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               const VULKAN_HPP_NAMESPACE::ImageCreateInfo * const &,
               VULKAN_HPP_NAMESPACE::ImageAspectFlagBits const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, pCreateInfo, planeAspect );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DeviceImageMemoryRequirements const & ) const = default;
#else
    bool operator==( DeviceImageMemoryRequirements const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( pCreateInfo == rhs.pCreateInfo ) && ( planeAspect == rhs.planeAspect );
#  endif
    }

    bool operator!=( DeviceImageMemoryRequirements const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType           sType       = StructureType::eDeviceImageMemoryRequirements;
    const void *                                  pNext       = {};
    const VULKAN_HPP_NAMESPACE::ImageCreateInfo * pCreateInfo = {};
    VULKAN_HPP_NAMESPACE::ImageAspectFlagBits     planeAspect = VULKAN_HPP_NAMESPACE::ImageAspectFlagBits::eColor;
  };

  template <>
  struct CppType<StructureType, StructureType::eDeviceImageMemoryRequirements>
  {
    using Type = DeviceImageMemoryRequirements;
  };

  using DeviceImageMemoryRequirementsKHR = DeviceImageMemoryRequirements;

  struct DeviceMemoryOpaqueCaptureAddressInfo
  {
    using NativeType = VkDeviceMemoryOpaqueCaptureAddressInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDeviceMemoryOpaqueCaptureAddressInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DeviceMemoryOpaqueCaptureAddressInfo( VULKAN_HPP_NAMESPACE::DeviceMemory memory_ = {},
                                                               const void *                       pNext_  = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , memory{ memory_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DeviceMemoryOpaqueCaptureAddressInfo( DeviceMemoryOpaqueCaptureAddressInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DeviceMemoryOpaqueCaptureAddressInfo( VkDeviceMemoryOpaqueCaptureAddressInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : DeviceMemoryOpaqueCaptureAddressInfo( *reinterpret_cast<DeviceMemoryOpaqueCaptureAddressInfo const *>( &rhs ) )
    {
    }

    DeviceMemoryOpaqueCaptureAddressInfo & operator=( DeviceMemoryOpaqueCaptureAddressInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DeviceMemoryOpaqueCaptureAddressInfo & operator=( VkDeviceMemoryOpaqueCaptureAddressInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DeviceMemoryOpaqueCaptureAddressInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DeviceMemoryOpaqueCaptureAddressInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceMemoryOpaqueCaptureAddressInfo & setMemory( VULKAN_HPP_NAMESPACE::DeviceMemory memory_ ) VULKAN_HPP_NOEXCEPT
    {
      memory = memory_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDeviceMemoryOpaqueCaptureAddressInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDeviceMemoryOpaqueCaptureAddressInfo *>( this );
    }

    operator VkDeviceMemoryOpaqueCaptureAddressInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDeviceMemoryOpaqueCaptureAddressInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::DeviceMemory const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, memory );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DeviceMemoryOpaqueCaptureAddressInfo const & ) const = default;
#else
    bool operator==( DeviceMemoryOpaqueCaptureAddressInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( memory == rhs.memory );
#  endif
    }

    bool operator!=( DeviceMemoryOpaqueCaptureAddressInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType  = StructureType::eDeviceMemoryOpaqueCaptureAddressInfo;
    const void *                        pNext  = {};
    VULKAN_HPP_NAMESPACE::DeviceMemory  memory = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eDeviceMemoryOpaqueCaptureAddressInfo>
  {
    using Type = DeviceMemoryOpaqueCaptureAddressInfo;
  };

  using DeviceMemoryOpaqueCaptureAddressInfoKHR = DeviceMemoryOpaqueCaptureAddressInfo;

  struct PipelineCacheCreateInfo
  {
    using NativeType = VkPipelineCacheCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::ePipelineCacheCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR PipelineCacheCreateInfo( VULKAN_HPP_NAMESPACE::PipelineCacheCreateFlags flags_           = {},
                                                  size_t                                         initialDataSize_ = {},
                                                  const void *                                   pInitialData_    = {},
                                                  const void *                                   pNext_           = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , initialDataSize{ initialDataSize_ }
      , pInitialData{ pInitialData_ }
    {
    }

    VULKAN_HPP_CONSTEXPR PipelineCacheCreateInfo( PipelineCacheCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    PipelineCacheCreateInfo( VkPipelineCacheCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : PipelineCacheCreateInfo( *reinterpret_cast<PipelineCacheCreateInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    template <typename T>
    PipelineCacheCreateInfo( VULKAN_HPP_NAMESPACE::PipelineCacheCreateFlags                 flags_,
                             VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const T> const & initialData_,
                             const void *                                                   pNext_ = nullptr )
      : pNext( pNext_ ), flags( flags_ ), initialDataSize( initialData_.size() * sizeof( T ) ), pInitialData( initialData_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    PipelineCacheCreateInfo & operator=( PipelineCacheCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    PipelineCacheCreateInfo & operator=( VkPipelineCacheCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::PipelineCacheCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 PipelineCacheCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineCacheCreateInfo & setFlags( VULKAN_HPP_NAMESPACE::PipelineCacheCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineCacheCreateInfo & setInitialDataSize( size_t initialDataSize_ ) VULKAN_HPP_NOEXCEPT
    {
      initialDataSize = initialDataSize_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineCacheCreateInfo & setPInitialData( const void * pInitialData_ ) VULKAN_HPP_NOEXCEPT
    {
      pInitialData = pInitialData_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    template <typename T>
    PipelineCacheCreateInfo & setInitialData( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const T> const & initialData_ ) VULKAN_HPP_NOEXCEPT
    {
      initialDataSize = initialData_.size() * sizeof( T );
      pInitialData    = initialData_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkPipelineCacheCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkPipelineCacheCreateInfo *>( this );
    }

    operator VkPipelineCacheCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkPipelineCacheCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::PipelineCacheCreateFlags const &,
               size_t const &,
               const void * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, initialDataSize, pInitialData );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( PipelineCacheCreateInfo const & ) const = default;
#else
    bool operator==( PipelineCacheCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( initialDataSize == rhs.initialDataSize ) &&
             ( pInitialData == rhs.pInitialData );
#  endif
    }

    bool operator!=( PipelineCacheCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType            sType           = StructureType::ePipelineCacheCreateInfo;
    const void *                                   pNext           = {};
    VULKAN_HPP_NAMESPACE::PipelineCacheCreateFlags flags           = {};
    size_t                                         initialDataSize = {};
    const void *                                   pInitialData    = {};
  };

  template <>
  struct CppType<StructureType, StructureType::ePipelineCacheCreateInfo>
  {
    using Type = PipelineCacheCreateInfo;
  };

  struct PipelinePoolSize
  {
    using NativeType = VkPipelinePoolSize;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::ePipelinePoolSize;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      PipelinePoolSize( VULKAN_HPP_NAMESPACE::DeviceSize poolEntrySize_ = {}, uint32_t poolEntryCount_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , poolEntrySize{ poolEntrySize_ }
      , poolEntryCount{ poolEntryCount_ }
    {
    }

    VULKAN_HPP_CONSTEXPR PipelinePoolSize( PipelinePoolSize const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    PipelinePoolSize( VkPipelinePoolSize const & rhs ) VULKAN_HPP_NOEXCEPT : PipelinePoolSize( *reinterpret_cast<PipelinePoolSize const *>( &rhs ) ) {}

    PipelinePoolSize & operator=( PipelinePoolSize const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    PipelinePoolSize & operator=( VkPipelinePoolSize const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::PipelinePoolSize const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 PipelinePoolSize & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelinePoolSize & setPoolEntrySize( VULKAN_HPP_NAMESPACE::DeviceSize poolEntrySize_ ) VULKAN_HPP_NOEXCEPT
    {
      poolEntrySize = poolEntrySize_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelinePoolSize & setPoolEntryCount( uint32_t poolEntryCount_ ) VULKAN_HPP_NOEXCEPT
    {
      poolEntryCount = poolEntryCount_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkPipelinePoolSize const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkPipelinePoolSize *>( this );
    }

    operator VkPipelinePoolSize &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkPipelinePoolSize *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::DeviceSize const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, poolEntrySize, poolEntryCount );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( PipelinePoolSize const & ) const = default;
#else
    bool operator==( PipelinePoolSize const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( poolEntrySize == rhs.poolEntrySize ) && ( poolEntryCount == rhs.poolEntryCount );
#  endif
    }

    bool operator!=( PipelinePoolSize const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType          = StructureType::ePipelinePoolSize;
    const void *                        pNext          = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    poolEntrySize  = {};
    uint32_t                            poolEntryCount = {};
  };

  template <>
  struct CppType<StructureType, StructureType::ePipelinePoolSize>
  {
    using Type = PipelinePoolSize;
  };

  struct DeviceObjectReservationCreateInfo
  {
    using NativeType = VkDeviceObjectReservationCreateInfo;

    static const bool                                  allowDuplicate = true;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDeviceObjectReservationCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DeviceObjectReservationCreateInfo( uint32_t                                              pipelineCacheCreateInfoCount_           = {},
                                                            const VULKAN_HPP_NAMESPACE::PipelineCacheCreateInfo * pPipelineCacheCreateInfos_              = {},
                                                            uint32_t                                              pipelinePoolSizeCount_                  = {},
                                                            const VULKAN_HPP_NAMESPACE::PipelinePoolSize *        pPipelinePoolSizes_                     = {},
                                                            uint32_t                                              semaphoreRequestCount_                  = {},
                                                            uint32_t                                              commandBufferRequestCount_              = {},
                                                            uint32_t                                              fenceRequestCount_                      = {},
                                                            uint32_t                                              deviceMemoryRequestCount_               = {},
                                                            uint32_t                                              bufferRequestCount_                     = {},
                                                            uint32_t                                              imageRequestCount_                      = {},
                                                            uint32_t                                              eventRequestCount_                      = {},
                                                            uint32_t                                              queryPoolRequestCount_                  = {},
                                                            uint32_t                                              bufferViewRequestCount_                 = {},
                                                            uint32_t                                              imageViewRequestCount_                  = {},
                                                            uint32_t                                              layeredImageViewRequestCount_           = {},
                                                            uint32_t                                              pipelineCacheRequestCount_              = {},
                                                            uint32_t                                              pipelineLayoutRequestCount_             = {},
                                                            uint32_t                                              renderPassRequestCount_                 = {},
                                                            uint32_t                                              graphicsPipelineRequestCount_           = {},
                                                            uint32_t                                              computePipelineRequestCount_            = {},
                                                            uint32_t                                              descriptorSetLayoutRequestCount_        = {},
                                                            uint32_t                                              samplerRequestCount_                    = {},
                                                            uint32_t                                              descriptorPoolRequestCount_             = {},
                                                            uint32_t                                              descriptorSetRequestCount_              = {},
                                                            uint32_t                                              framebufferRequestCount_                = {},
                                                            uint32_t                                              commandPoolRequestCount_                = {},
                                                            uint32_t                                              samplerYcbcrConversionRequestCount_     = {},
                                                            uint32_t                                              surfaceRequestCount_                    = {},
                                                            uint32_t                                              swapchainRequestCount_                  = {},
                                                            uint32_t                                              displayModeRequestCount_                = {},
                                                            uint32_t                                              subpassDescriptionRequestCount_         = {},
                                                            uint32_t                                              attachmentDescriptionRequestCount_      = {},
                                                            uint32_t                                              descriptorSetLayoutBindingRequestCount_ = {},
                                                            uint32_t                                              descriptorSetLayoutBindingLimit_        = {},
                                                            uint32_t                                              maxImageViewMipLevels_                  = {},
                                                            uint32_t                                              maxImageViewArrayLayers_                = {},
                                                            uint32_t                                              maxLayeredImageViewMipLevels_           = {},
                                                            uint32_t                                              maxOcclusionQueriesPerPool_             = {},
                                                            uint32_t                                              maxPipelineStatisticsQueriesPerPool_    = {},
                                                            uint32_t                                              maxTimestampQueriesPerPool_             = {},
                                                            uint32_t     maxImmutableSamplersPerDescriptorSetLayout_                                      = {},
                                                            const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , pipelineCacheCreateInfoCount{ pipelineCacheCreateInfoCount_ }
      , pPipelineCacheCreateInfos{ pPipelineCacheCreateInfos_ }
      , pipelinePoolSizeCount{ pipelinePoolSizeCount_ }
      , pPipelinePoolSizes{ pPipelinePoolSizes_ }
      , semaphoreRequestCount{ semaphoreRequestCount_ }
      , commandBufferRequestCount{ commandBufferRequestCount_ }
      , fenceRequestCount{ fenceRequestCount_ }
      , deviceMemoryRequestCount{ deviceMemoryRequestCount_ }
      , bufferRequestCount{ bufferRequestCount_ }
      , imageRequestCount{ imageRequestCount_ }
      , eventRequestCount{ eventRequestCount_ }
      , queryPoolRequestCount{ queryPoolRequestCount_ }
      , bufferViewRequestCount{ bufferViewRequestCount_ }
      , imageViewRequestCount{ imageViewRequestCount_ }
      , layeredImageViewRequestCount{ layeredImageViewRequestCount_ }
      , pipelineCacheRequestCount{ pipelineCacheRequestCount_ }
      , pipelineLayoutRequestCount{ pipelineLayoutRequestCount_ }
      , renderPassRequestCount{ renderPassRequestCount_ }
      , graphicsPipelineRequestCount{ graphicsPipelineRequestCount_ }
      , computePipelineRequestCount{ computePipelineRequestCount_ }
      , descriptorSetLayoutRequestCount{ descriptorSetLayoutRequestCount_ }
      , samplerRequestCount{ samplerRequestCount_ }
      , descriptorPoolRequestCount{ descriptorPoolRequestCount_ }
      , descriptorSetRequestCount{ descriptorSetRequestCount_ }
      , framebufferRequestCount{ framebufferRequestCount_ }
      , commandPoolRequestCount{ commandPoolRequestCount_ }
      , samplerYcbcrConversionRequestCount{ samplerYcbcrConversionRequestCount_ }
      , surfaceRequestCount{ surfaceRequestCount_ }
      , swapchainRequestCount{ swapchainRequestCount_ }
      , displayModeRequestCount{ displayModeRequestCount_ }
      , subpassDescriptionRequestCount{ subpassDescriptionRequestCount_ }
      , attachmentDescriptionRequestCount{ attachmentDescriptionRequestCount_ }
      , descriptorSetLayoutBindingRequestCount{ descriptorSetLayoutBindingRequestCount_ }
      , descriptorSetLayoutBindingLimit{ descriptorSetLayoutBindingLimit_ }
      , maxImageViewMipLevels{ maxImageViewMipLevels_ }
      , maxImageViewArrayLayers{ maxImageViewArrayLayers_ }
      , maxLayeredImageViewMipLevels{ maxLayeredImageViewMipLevels_ }
      , maxOcclusionQueriesPerPool{ maxOcclusionQueriesPerPool_ }
      , maxPipelineStatisticsQueriesPerPool{ maxPipelineStatisticsQueriesPerPool_ }
      , maxTimestampQueriesPerPool{ maxTimestampQueriesPerPool_ }
      , maxImmutableSamplersPerDescriptorSetLayout{ maxImmutableSamplersPerDescriptorSetLayout_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DeviceObjectReservationCreateInfo( DeviceObjectReservationCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DeviceObjectReservationCreateInfo( VkDeviceObjectReservationCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : DeviceObjectReservationCreateInfo( *reinterpret_cast<DeviceObjectReservationCreateInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DeviceObjectReservationCreateInfo(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::PipelineCacheCreateInfo> const & pipelineCacheCreateInfos_,
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::PipelinePoolSize> const &        pipelinePoolSizes_                      = {},
      uint32_t                                                                                                   semaphoreRequestCount_                  = {},
      uint32_t                                                                                                   commandBufferRequestCount_              = {},
      uint32_t                                                                                                   fenceRequestCount_                      = {},
      uint32_t                                                                                                   deviceMemoryRequestCount_               = {},
      uint32_t                                                                                                   bufferRequestCount_                     = {},
      uint32_t                                                                                                   imageRequestCount_                      = {},
      uint32_t                                                                                                   eventRequestCount_                      = {},
      uint32_t                                                                                                   queryPoolRequestCount_                  = {},
      uint32_t                                                                                                   bufferViewRequestCount_                 = {},
      uint32_t                                                                                                   imageViewRequestCount_                  = {},
      uint32_t                                                                                                   layeredImageViewRequestCount_           = {},
      uint32_t                                                                                                   pipelineCacheRequestCount_              = {},
      uint32_t                                                                                                   pipelineLayoutRequestCount_             = {},
      uint32_t                                                                                                   renderPassRequestCount_                 = {},
      uint32_t                                                                                                   graphicsPipelineRequestCount_           = {},
      uint32_t                                                                                                   computePipelineRequestCount_            = {},
      uint32_t                                                                                                   descriptorSetLayoutRequestCount_        = {},
      uint32_t                                                                                                   samplerRequestCount_                    = {},
      uint32_t                                                                                                   descriptorPoolRequestCount_             = {},
      uint32_t                                                                                                   descriptorSetRequestCount_              = {},
      uint32_t                                                                                                   framebufferRequestCount_                = {},
      uint32_t                                                                                                   commandPoolRequestCount_                = {},
      uint32_t                                                                                                   samplerYcbcrConversionRequestCount_     = {},
      uint32_t                                                                                                   surfaceRequestCount_                    = {},
      uint32_t                                                                                                   swapchainRequestCount_                  = {},
      uint32_t                                                                                                   displayModeRequestCount_                = {},
      uint32_t                                                                                                   subpassDescriptionRequestCount_         = {},
      uint32_t                                                                                                   attachmentDescriptionRequestCount_      = {},
      uint32_t                                                                                                   descriptorSetLayoutBindingRequestCount_ = {},
      uint32_t                                                                                                   descriptorSetLayoutBindingLimit_        = {},
      uint32_t                                                                                                   maxImageViewMipLevels_                  = {},
      uint32_t                                                                                                   maxImageViewArrayLayers_                = {},
      uint32_t                                                                                                   maxLayeredImageViewMipLevels_           = {},
      uint32_t                                                                                                   maxOcclusionQueriesPerPool_             = {},
      uint32_t                                                                                                   maxPipelineStatisticsQueriesPerPool_    = {},
      uint32_t                                                                                                   maxTimestampQueriesPerPool_             = {},
      uint32_t     maxImmutableSamplersPerDescriptorSetLayout_                                                                                           = {},
      const void * pNext_ = nullptr )
      : pNext( pNext_ )
      , pipelineCacheCreateInfoCount( static_cast<uint32_t>( pipelineCacheCreateInfos_.size() ) )
      , pPipelineCacheCreateInfos( pipelineCacheCreateInfos_.data() )
      , pipelinePoolSizeCount( static_cast<uint32_t>( pipelinePoolSizes_.size() ) )
      , pPipelinePoolSizes( pipelinePoolSizes_.data() )
      , semaphoreRequestCount( semaphoreRequestCount_ )
      , commandBufferRequestCount( commandBufferRequestCount_ )
      , fenceRequestCount( fenceRequestCount_ )
      , deviceMemoryRequestCount( deviceMemoryRequestCount_ )
      , bufferRequestCount( bufferRequestCount_ )
      , imageRequestCount( imageRequestCount_ )
      , eventRequestCount( eventRequestCount_ )
      , queryPoolRequestCount( queryPoolRequestCount_ )
      , bufferViewRequestCount( bufferViewRequestCount_ )
      , imageViewRequestCount( imageViewRequestCount_ )
      , layeredImageViewRequestCount( layeredImageViewRequestCount_ )
      , pipelineCacheRequestCount( pipelineCacheRequestCount_ )
      , pipelineLayoutRequestCount( pipelineLayoutRequestCount_ )
      , renderPassRequestCount( renderPassRequestCount_ )
      , graphicsPipelineRequestCount( graphicsPipelineRequestCount_ )
      , computePipelineRequestCount( computePipelineRequestCount_ )
      , descriptorSetLayoutRequestCount( descriptorSetLayoutRequestCount_ )
      , samplerRequestCount( samplerRequestCount_ )
      , descriptorPoolRequestCount( descriptorPoolRequestCount_ )
      , descriptorSetRequestCount( descriptorSetRequestCount_ )
      , framebufferRequestCount( framebufferRequestCount_ )
      , commandPoolRequestCount( commandPoolRequestCount_ )
      , samplerYcbcrConversionRequestCount( samplerYcbcrConversionRequestCount_ )
      , surfaceRequestCount( surfaceRequestCount_ )
      , swapchainRequestCount( swapchainRequestCount_ )
      , displayModeRequestCount( displayModeRequestCount_ )
      , subpassDescriptionRequestCount( subpassDescriptionRequestCount_ )
      , attachmentDescriptionRequestCount( attachmentDescriptionRequestCount_ )
      , descriptorSetLayoutBindingRequestCount( descriptorSetLayoutBindingRequestCount_ )
      , descriptorSetLayoutBindingLimit( descriptorSetLayoutBindingLimit_ )
      , maxImageViewMipLevels( maxImageViewMipLevels_ )
      , maxImageViewArrayLayers( maxImageViewArrayLayers_ )
      , maxLayeredImageViewMipLevels( maxLayeredImageViewMipLevels_ )
      , maxOcclusionQueriesPerPool( maxOcclusionQueriesPerPool_ )
      , maxPipelineStatisticsQueriesPerPool( maxPipelineStatisticsQueriesPerPool_ )
      , maxTimestampQueriesPerPool( maxTimestampQueriesPerPool_ )
      , maxImmutableSamplersPerDescriptorSetLayout( maxImmutableSamplersPerDescriptorSetLayout_ )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    DeviceObjectReservationCreateInfo & operator=( DeviceObjectReservationCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DeviceObjectReservationCreateInfo & operator=( VkDeviceObjectReservationCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DeviceObjectReservationCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DeviceObjectReservationCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceObjectReservationCreateInfo & setPipelineCacheCreateInfoCount( uint32_t pipelineCacheCreateInfoCount_ ) VULKAN_HPP_NOEXCEPT
    {
      pipelineCacheCreateInfoCount = pipelineCacheCreateInfoCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceObjectReservationCreateInfo &
      setPPipelineCacheCreateInfos( const VULKAN_HPP_NAMESPACE::PipelineCacheCreateInfo * pPipelineCacheCreateInfos_ ) VULKAN_HPP_NOEXCEPT
    {
      pPipelineCacheCreateInfos = pPipelineCacheCreateInfos_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DeviceObjectReservationCreateInfo & setPipelineCacheCreateInfos(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::PipelineCacheCreateInfo> const & pipelineCacheCreateInfos_ ) VULKAN_HPP_NOEXCEPT
    {
      pipelineCacheCreateInfoCount = static_cast<uint32_t>( pipelineCacheCreateInfos_.size() );
      pPipelineCacheCreateInfos    = pipelineCacheCreateInfos_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 DeviceObjectReservationCreateInfo & setPipelinePoolSizeCount( uint32_t pipelinePoolSizeCount_ ) VULKAN_HPP_NOEXCEPT
    {
      pipelinePoolSizeCount = pipelinePoolSizeCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceObjectReservationCreateInfo &
      setPPipelinePoolSizes( const VULKAN_HPP_NAMESPACE::PipelinePoolSize * pPipelinePoolSizes_ ) VULKAN_HPP_NOEXCEPT
    {
      pPipelinePoolSizes = pPipelinePoolSizes_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DeviceObjectReservationCreateInfo & setPipelinePoolSizes(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::PipelinePoolSize> const & pipelinePoolSizes_ ) VULKAN_HPP_NOEXCEPT
    {
      pipelinePoolSizeCount = static_cast<uint32_t>( pipelinePoolSizes_.size() );
      pPipelinePoolSizes    = pipelinePoolSizes_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 DeviceObjectReservationCreateInfo & setSemaphoreRequestCount( uint32_t semaphoreRequestCount_ ) VULKAN_HPP_NOEXCEPT
    {
      semaphoreRequestCount = semaphoreRequestCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceObjectReservationCreateInfo & setCommandBufferRequestCount( uint32_t commandBufferRequestCount_ ) VULKAN_HPP_NOEXCEPT
    {
      commandBufferRequestCount = commandBufferRequestCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceObjectReservationCreateInfo & setFenceRequestCount( uint32_t fenceRequestCount_ ) VULKAN_HPP_NOEXCEPT
    {
      fenceRequestCount = fenceRequestCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceObjectReservationCreateInfo & setDeviceMemoryRequestCount( uint32_t deviceMemoryRequestCount_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceMemoryRequestCount = deviceMemoryRequestCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceObjectReservationCreateInfo & setBufferRequestCount( uint32_t bufferRequestCount_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferRequestCount = bufferRequestCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceObjectReservationCreateInfo & setImageRequestCount( uint32_t imageRequestCount_ ) VULKAN_HPP_NOEXCEPT
    {
      imageRequestCount = imageRequestCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceObjectReservationCreateInfo & setEventRequestCount( uint32_t eventRequestCount_ ) VULKAN_HPP_NOEXCEPT
    {
      eventRequestCount = eventRequestCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceObjectReservationCreateInfo & setQueryPoolRequestCount( uint32_t queryPoolRequestCount_ ) VULKAN_HPP_NOEXCEPT
    {
      queryPoolRequestCount = queryPoolRequestCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceObjectReservationCreateInfo & setBufferViewRequestCount( uint32_t bufferViewRequestCount_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferViewRequestCount = bufferViewRequestCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceObjectReservationCreateInfo & setImageViewRequestCount( uint32_t imageViewRequestCount_ ) VULKAN_HPP_NOEXCEPT
    {
      imageViewRequestCount = imageViewRequestCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceObjectReservationCreateInfo & setLayeredImageViewRequestCount( uint32_t layeredImageViewRequestCount_ ) VULKAN_HPP_NOEXCEPT
    {
      layeredImageViewRequestCount = layeredImageViewRequestCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceObjectReservationCreateInfo & setPipelineCacheRequestCount( uint32_t pipelineCacheRequestCount_ ) VULKAN_HPP_NOEXCEPT
    {
      pipelineCacheRequestCount = pipelineCacheRequestCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceObjectReservationCreateInfo & setPipelineLayoutRequestCount( uint32_t pipelineLayoutRequestCount_ ) VULKAN_HPP_NOEXCEPT
    {
      pipelineLayoutRequestCount = pipelineLayoutRequestCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceObjectReservationCreateInfo & setRenderPassRequestCount( uint32_t renderPassRequestCount_ ) VULKAN_HPP_NOEXCEPT
    {
      renderPassRequestCount = renderPassRequestCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceObjectReservationCreateInfo & setGraphicsPipelineRequestCount( uint32_t graphicsPipelineRequestCount_ ) VULKAN_HPP_NOEXCEPT
    {
      graphicsPipelineRequestCount = graphicsPipelineRequestCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceObjectReservationCreateInfo & setComputePipelineRequestCount( uint32_t computePipelineRequestCount_ ) VULKAN_HPP_NOEXCEPT
    {
      computePipelineRequestCount = computePipelineRequestCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceObjectReservationCreateInfo &
      setDescriptorSetLayoutRequestCount( uint32_t descriptorSetLayoutRequestCount_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorSetLayoutRequestCount = descriptorSetLayoutRequestCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceObjectReservationCreateInfo & setSamplerRequestCount( uint32_t samplerRequestCount_ ) VULKAN_HPP_NOEXCEPT
    {
      samplerRequestCount = samplerRequestCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceObjectReservationCreateInfo & setDescriptorPoolRequestCount( uint32_t descriptorPoolRequestCount_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorPoolRequestCount = descriptorPoolRequestCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceObjectReservationCreateInfo & setDescriptorSetRequestCount( uint32_t descriptorSetRequestCount_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorSetRequestCount = descriptorSetRequestCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceObjectReservationCreateInfo & setFramebufferRequestCount( uint32_t framebufferRequestCount_ ) VULKAN_HPP_NOEXCEPT
    {
      framebufferRequestCount = framebufferRequestCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceObjectReservationCreateInfo & setCommandPoolRequestCount( uint32_t commandPoolRequestCount_ ) VULKAN_HPP_NOEXCEPT
    {
      commandPoolRequestCount = commandPoolRequestCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceObjectReservationCreateInfo &
      setSamplerYcbcrConversionRequestCount( uint32_t samplerYcbcrConversionRequestCount_ ) VULKAN_HPP_NOEXCEPT
    {
      samplerYcbcrConversionRequestCount = samplerYcbcrConversionRequestCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceObjectReservationCreateInfo & setSurfaceRequestCount( uint32_t surfaceRequestCount_ ) VULKAN_HPP_NOEXCEPT
    {
      surfaceRequestCount = surfaceRequestCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceObjectReservationCreateInfo & setSwapchainRequestCount( uint32_t swapchainRequestCount_ ) VULKAN_HPP_NOEXCEPT
    {
      swapchainRequestCount = swapchainRequestCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceObjectReservationCreateInfo & setDisplayModeRequestCount( uint32_t displayModeRequestCount_ ) VULKAN_HPP_NOEXCEPT
    {
      displayModeRequestCount = displayModeRequestCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceObjectReservationCreateInfo &
      setSubpassDescriptionRequestCount( uint32_t subpassDescriptionRequestCount_ ) VULKAN_HPP_NOEXCEPT
    {
      subpassDescriptionRequestCount = subpassDescriptionRequestCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceObjectReservationCreateInfo &
      setAttachmentDescriptionRequestCount( uint32_t attachmentDescriptionRequestCount_ ) VULKAN_HPP_NOEXCEPT
    {
      attachmentDescriptionRequestCount = attachmentDescriptionRequestCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceObjectReservationCreateInfo &
      setDescriptorSetLayoutBindingRequestCount( uint32_t descriptorSetLayoutBindingRequestCount_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorSetLayoutBindingRequestCount = descriptorSetLayoutBindingRequestCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceObjectReservationCreateInfo &
      setDescriptorSetLayoutBindingLimit( uint32_t descriptorSetLayoutBindingLimit_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorSetLayoutBindingLimit = descriptorSetLayoutBindingLimit_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceObjectReservationCreateInfo & setMaxImageViewMipLevels( uint32_t maxImageViewMipLevels_ ) VULKAN_HPP_NOEXCEPT
    {
      maxImageViewMipLevels = maxImageViewMipLevels_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceObjectReservationCreateInfo & setMaxImageViewArrayLayers( uint32_t maxImageViewArrayLayers_ ) VULKAN_HPP_NOEXCEPT
    {
      maxImageViewArrayLayers = maxImageViewArrayLayers_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceObjectReservationCreateInfo & setMaxLayeredImageViewMipLevels( uint32_t maxLayeredImageViewMipLevels_ ) VULKAN_HPP_NOEXCEPT
    {
      maxLayeredImageViewMipLevels = maxLayeredImageViewMipLevels_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceObjectReservationCreateInfo & setMaxOcclusionQueriesPerPool( uint32_t maxOcclusionQueriesPerPool_ ) VULKAN_HPP_NOEXCEPT
    {
      maxOcclusionQueriesPerPool = maxOcclusionQueriesPerPool_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceObjectReservationCreateInfo &
      setMaxPipelineStatisticsQueriesPerPool( uint32_t maxPipelineStatisticsQueriesPerPool_ ) VULKAN_HPP_NOEXCEPT
    {
      maxPipelineStatisticsQueriesPerPool = maxPipelineStatisticsQueriesPerPool_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceObjectReservationCreateInfo & setMaxTimestampQueriesPerPool( uint32_t maxTimestampQueriesPerPool_ ) VULKAN_HPP_NOEXCEPT
    {
      maxTimestampQueriesPerPool = maxTimestampQueriesPerPool_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceObjectReservationCreateInfo &
      setMaxImmutableSamplersPerDescriptorSetLayout( uint32_t maxImmutableSamplersPerDescriptorSetLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      maxImmutableSamplersPerDescriptorSetLayout = maxImmutableSamplersPerDescriptorSetLayout_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDeviceObjectReservationCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDeviceObjectReservationCreateInfo *>( this );
    }

    operator VkDeviceObjectReservationCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDeviceObjectReservationCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::PipelineCacheCreateInfo * const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::PipelinePoolSize * const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType,
                       pNext,
                       pipelineCacheCreateInfoCount,
                       pPipelineCacheCreateInfos,
                       pipelinePoolSizeCount,
                       pPipelinePoolSizes,
                       semaphoreRequestCount,
                       commandBufferRequestCount,
                       fenceRequestCount,
                       deviceMemoryRequestCount,
                       bufferRequestCount,
                       imageRequestCount,
                       eventRequestCount,
                       queryPoolRequestCount,
                       bufferViewRequestCount,
                       imageViewRequestCount,
                       layeredImageViewRequestCount,
                       pipelineCacheRequestCount,
                       pipelineLayoutRequestCount,
                       renderPassRequestCount,
                       graphicsPipelineRequestCount,
                       computePipelineRequestCount,
                       descriptorSetLayoutRequestCount,
                       samplerRequestCount,
                       descriptorPoolRequestCount,
                       descriptorSetRequestCount,
                       framebufferRequestCount,
                       commandPoolRequestCount,
                       samplerYcbcrConversionRequestCount,
                       surfaceRequestCount,
                       swapchainRequestCount,
                       displayModeRequestCount,
                       subpassDescriptionRequestCount,
                       attachmentDescriptionRequestCount,
                       descriptorSetLayoutBindingRequestCount,
                       descriptorSetLayoutBindingLimit,
                       maxImageViewMipLevels,
                       maxImageViewArrayLayers,
                       maxLayeredImageViewMipLevels,
                       maxOcclusionQueriesPerPool,
                       maxPipelineStatisticsQueriesPerPool,
                       maxTimestampQueriesPerPool,
                       maxImmutableSamplersPerDescriptorSetLayout );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DeviceObjectReservationCreateInfo const & ) const = default;
#else
    bool operator==( DeviceObjectReservationCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( pipelineCacheCreateInfoCount == rhs.pipelineCacheCreateInfoCount ) &&
             ( pPipelineCacheCreateInfos == rhs.pPipelineCacheCreateInfos ) && ( pipelinePoolSizeCount == rhs.pipelinePoolSizeCount ) &&
             ( pPipelinePoolSizes == rhs.pPipelinePoolSizes ) && ( semaphoreRequestCount == rhs.semaphoreRequestCount ) &&
             ( commandBufferRequestCount == rhs.commandBufferRequestCount ) && ( fenceRequestCount == rhs.fenceRequestCount ) &&
             ( deviceMemoryRequestCount == rhs.deviceMemoryRequestCount ) && ( bufferRequestCount == rhs.bufferRequestCount ) &&
             ( imageRequestCount == rhs.imageRequestCount ) && ( eventRequestCount == rhs.eventRequestCount ) &&
             ( queryPoolRequestCount == rhs.queryPoolRequestCount ) && ( bufferViewRequestCount == rhs.bufferViewRequestCount ) &&
             ( imageViewRequestCount == rhs.imageViewRequestCount ) && ( layeredImageViewRequestCount == rhs.layeredImageViewRequestCount ) &&
             ( pipelineCacheRequestCount == rhs.pipelineCacheRequestCount ) && ( pipelineLayoutRequestCount == rhs.pipelineLayoutRequestCount ) &&
             ( renderPassRequestCount == rhs.renderPassRequestCount ) && ( graphicsPipelineRequestCount == rhs.graphicsPipelineRequestCount ) &&
             ( computePipelineRequestCount == rhs.computePipelineRequestCount ) && ( descriptorSetLayoutRequestCount == rhs.descriptorSetLayoutRequestCount ) &&
             ( samplerRequestCount == rhs.samplerRequestCount ) && ( descriptorPoolRequestCount == rhs.descriptorPoolRequestCount ) &&
             ( descriptorSetRequestCount == rhs.descriptorSetRequestCount ) && ( framebufferRequestCount == rhs.framebufferRequestCount ) &&
             ( commandPoolRequestCount == rhs.commandPoolRequestCount ) && ( samplerYcbcrConversionRequestCount == rhs.samplerYcbcrConversionRequestCount ) &&
             ( surfaceRequestCount == rhs.surfaceRequestCount ) && ( swapchainRequestCount == rhs.swapchainRequestCount ) &&
             ( displayModeRequestCount == rhs.displayModeRequestCount ) && ( subpassDescriptionRequestCount == rhs.subpassDescriptionRequestCount ) &&
             ( attachmentDescriptionRequestCount == rhs.attachmentDescriptionRequestCount ) &&
             ( descriptorSetLayoutBindingRequestCount == rhs.descriptorSetLayoutBindingRequestCount ) &&
             ( descriptorSetLayoutBindingLimit == rhs.descriptorSetLayoutBindingLimit ) && ( maxImageViewMipLevels == rhs.maxImageViewMipLevels ) &&
             ( maxImageViewArrayLayers == rhs.maxImageViewArrayLayers ) && ( maxLayeredImageViewMipLevels == rhs.maxLayeredImageViewMipLevels ) &&
             ( maxOcclusionQueriesPerPool == rhs.maxOcclusionQueriesPerPool ) &&
             ( maxPipelineStatisticsQueriesPerPool == rhs.maxPipelineStatisticsQueriesPerPool ) &&
             ( maxTimestampQueriesPerPool == rhs.maxTimestampQueriesPerPool ) &&
             ( maxImmutableSamplersPerDescriptorSetLayout == rhs.maxImmutableSamplersPerDescriptorSetLayout );
#  endif
    }

    bool operator!=( DeviceObjectReservationCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                   sType                                      = StructureType::eDeviceObjectReservationCreateInfo;
    const void *                                          pNext                                      = {};
    uint32_t                                              pipelineCacheCreateInfoCount               = {};
    const VULKAN_HPP_NAMESPACE::PipelineCacheCreateInfo * pPipelineCacheCreateInfos                  = {};
    uint32_t                                              pipelinePoolSizeCount                      = {};
    const VULKAN_HPP_NAMESPACE::PipelinePoolSize *        pPipelinePoolSizes                         = {};
    uint32_t                                              semaphoreRequestCount                      = {};
    uint32_t                                              commandBufferRequestCount                  = {};
    uint32_t                                              fenceRequestCount                          = {};
    uint32_t                                              deviceMemoryRequestCount                   = {};
    uint32_t                                              bufferRequestCount                         = {};
    uint32_t                                              imageRequestCount                          = {};
    uint32_t                                              eventRequestCount                          = {};
    uint32_t                                              queryPoolRequestCount                      = {};
    uint32_t                                              bufferViewRequestCount                     = {};
    uint32_t                                              imageViewRequestCount                      = {};
    uint32_t                                              layeredImageViewRequestCount               = {};
    uint32_t                                              pipelineCacheRequestCount                  = {};
    uint32_t                                              pipelineLayoutRequestCount                 = {};
    uint32_t                                              renderPassRequestCount                     = {};
    uint32_t                                              graphicsPipelineRequestCount               = {};
    uint32_t                                              computePipelineRequestCount                = {};
    uint32_t                                              descriptorSetLayoutRequestCount            = {};
    uint32_t                                              samplerRequestCount                        = {};
    uint32_t                                              descriptorPoolRequestCount                 = {};
    uint32_t                                              descriptorSetRequestCount                  = {};
    uint32_t                                              framebufferRequestCount                    = {};
    uint32_t                                              commandPoolRequestCount                    = {};
    uint32_t                                              samplerYcbcrConversionRequestCount         = {};
    uint32_t                                              surfaceRequestCount                        = {};
    uint32_t                                              swapchainRequestCount                      = {};
    uint32_t                                              displayModeRequestCount                    = {};
    uint32_t                                              subpassDescriptionRequestCount             = {};
    uint32_t                                              attachmentDescriptionRequestCount          = {};
    uint32_t                                              descriptorSetLayoutBindingRequestCount     = {};
    uint32_t                                              descriptorSetLayoutBindingLimit            = {};
    uint32_t                                              maxImageViewMipLevels                      = {};
    uint32_t                                              maxImageViewArrayLayers                    = {};
    uint32_t                                              maxLayeredImageViewMipLevels               = {};
    uint32_t                                              maxOcclusionQueriesPerPool                 = {};
    uint32_t                                              maxPipelineStatisticsQueriesPerPool        = {};
    uint32_t                                              maxTimestampQueriesPerPool                 = {};
    uint32_t                                              maxImmutableSamplersPerDescriptorSetLayout = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eDeviceObjectReservationCreateInfo>
  {
    using Type = DeviceObjectReservationCreateInfo;
  };

  struct DevicePrivateDataCreateInfo
  {
    using NativeType = VkDevicePrivateDataCreateInfo;

    static const bool                                  allowDuplicate = true;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDevicePrivateDataCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DevicePrivateDataCreateInfo( uint32_t privateDataSlotRequestCount_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , privateDataSlotRequestCount{ privateDataSlotRequestCount_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DevicePrivateDataCreateInfo( DevicePrivateDataCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DevicePrivateDataCreateInfo( VkDevicePrivateDataCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : DevicePrivateDataCreateInfo( *reinterpret_cast<DevicePrivateDataCreateInfo const *>( &rhs ) )
    {
    }

    DevicePrivateDataCreateInfo & operator=( DevicePrivateDataCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DevicePrivateDataCreateInfo & operator=( VkDevicePrivateDataCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DevicePrivateDataCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DevicePrivateDataCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DevicePrivateDataCreateInfo & setPrivateDataSlotRequestCount( uint32_t privateDataSlotRequestCount_ ) VULKAN_HPP_NOEXCEPT
    {
      privateDataSlotRequestCount = privateDataSlotRequestCount_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDevicePrivateDataCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDevicePrivateDataCreateInfo *>( this );
    }

    operator VkDevicePrivateDataCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDevicePrivateDataCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, privateDataSlotRequestCount );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DevicePrivateDataCreateInfo const & ) const = default;
#else
    bool operator==( DevicePrivateDataCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( privateDataSlotRequestCount == rhs.privateDataSlotRequestCount );
#  endif
    }

    bool operator!=( DevicePrivateDataCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType                       = StructureType::eDevicePrivateDataCreateInfo;
    const void *                        pNext                       = {};
    uint32_t                            privateDataSlotRequestCount = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eDevicePrivateDataCreateInfo>
  {
    using Type = DevicePrivateDataCreateInfo;
  };

  using DevicePrivateDataCreateInfoEXT = DevicePrivateDataCreateInfo;

  struct DeviceQueueGlobalPriorityCreateInfoKHR
  {
    using NativeType = VkDeviceQueueGlobalPriorityCreateInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDeviceQueueGlobalPriorityCreateInfoKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      DeviceQueueGlobalPriorityCreateInfoKHR( VULKAN_HPP_NAMESPACE::QueueGlobalPriorityKHR globalPriority_ = VULKAN_HPP_NAMESPACE::QueueGlobalPriorityKHR::eLow,
                                              const void *                                 pNext_          = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , globalPriority{ globalPriority_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DeviceQueueGlobalPriorityCreateInfoKHR( DeviceQueueGlobalPriorityCreateInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DeviceQueueGlobalPriorityCreateInfoKHR( VkDeviceQueueGlobalPriorityCreateInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : DeviceQueueGlobalPriorityCreateInfoKHR( *reinterpret_cast<DeviceQueueGlobalPriorityCreateInfoKHR const *>( &rhs ) )
    {
    }

    DeviceQueueGlobalPriorityCreateInfoKHR & operator=( DeviceQueueGlobalPriorityCreateInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DeviceQueueGlobalPriorityCreateInfoKHR & operator=( VkDeviceQueueGlobalPriorityCreateInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DeviceQueueGlobalPriorityCreateInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DeviceQueueGlobalPriorityCreateInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceQueueGlobalPriorityCreateInfoKHR &
      setGlobalPriority( VULKAN_HPP_NAMESPACE::QueueGlobalPriorityKHR globalPriority_ ) VULKAN_HPP_NOEXCEPT
    {
      globalPriority = globalPriority_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDeviceQueueGlobalPriorityCreateInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDeviceQueueGlobalPriorityCreateInfoKHR *>( this );
    }

    operator VkDeviceQueueGlobalPriorityCreateInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDeviceQueueGlobalPriorityCreateInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::QueueGlobalPriorityKHR const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, globalPriority );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DeviceQueueGlobalPriorityCreateInfoKHR const & ) const = default;
#else
    bool operator==( DeviceQueueGlobalPriorityCreateInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( globalPriority == rhs.globalPriority );
#  endif
    }

    bool operator!=( DeviceQueueGlobalPriorityCreateInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType          sType          = StructureType::eDeviceQueueGlobalPriorityCreateInfoKHR;
    const void *                                 pNext          = {};
    VULKAN_HPP_NAMESPACE::QueueGlobalPriorityKHR globalPriority = VULKAN_HPP_NAMESPACE::QueueGlobalPriorityKHR::eLow;
  };

  template <>
  struct CppType<StructureType, StructureType::eDeviceQueueGlobalPriorityCreateInfoKHR>
  {
    using Type = DeviceQueueGlobalPriorityCreateInfoKHR;
  };

  using DeviceQueueGlobalPriorityCreateInfoEXT = DeviceQueueGlobalPriorityCreateInfoKHR;

  struct DeviceQueueInfo2
  {
    using NativeType = VkDeviceQueueInfo2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDeviceQueueInfo2;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DeviceQueueInfo2( VULKAN_HPP_NAMESPACE::DeviceQueueCreateFlags flags_            = {},
                                           uint32_t                                     queueFamilyIndex_ = {},
                                           uint32_t                                     queueIndex_       = {},
                                           const void *                                 pNext_            = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , queueFamilyIndex{ queueFamilyIndex_ }
      , queueIndex{ queueIndex_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DeviceQueueInfo2( DeviceQueueInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DeviceQueueInfo2( VkDeviceQueueInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT : DeviceQueueInfo2( *reinterpret_cast<DeviceQueueInfo2 const *>( &rhs ) ) {}

    DeviceQueueInfo2 & operator=( DeviceQueueInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DeviceQueueInfo2 & operator=( VkDeviceQueueInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DeviceQueueInfo2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DeviceQueueInfo2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceQueueInfo2 & setFlags( VULKAN_HPP_NAMESPACE::DeviceQueueCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceQueueInfo2 & setQueueFamilyIndex( uint32_t queueFamilyIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      queueFamilyIndex = queueFamilyIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceQueueInfo2 & setQueueIndex( uint32_t queueIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      queueIndex = queueIndex_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDeviceQueueInfo2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDeviceQueueInfo2 *>( this );
    }

    operator VkDeviceQueueInfo2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDeviceQueueInfo2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::DeviceQueueCreateFlags const &,
               uint32_t const &,
               uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, queueFamilyIndex, queueIndex );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DeviceQueueInfo2 const & ) const = default;
#else
    bool operator==( DeviceQueueInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( queueFamilyIndex == rhs.queueFamilyIndex ) &&
             ( queueIndex == rhs.queueIndex );
#  endif
    }

    bool operator!=( DeviceQueueInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType          sType            = StructureType::eDeviceQueueInfo2;
    const void *                                 pNext            = {};
    VULKAN_HPP_NAMESPACE::DeviceQueueCreateFlags flags            = {};
    uint32_t                                     queueFamilyIndex = {};
    uint32_t                                     queueIndex       = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eDeviceQueueInfo2>
  {
    using Type = DeviceQueueInfo2;
  };

#if defined( VK_USE_PLATFORM_SCI )
  struct DeviceSemaphoreSciSyncPoolReservationCreateInfoNV
  {
    using NativeType = VkDeviceSemaphoreSciSyncPoolReservationCreateInfoNV;

    static const bool                                  allowDuplicate = true;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDeviceSemaphoreSciSyncPoolReservationCreateInfoNV;

#  if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DeviceSemaphoreSciSyncPoolReservationCreateInfoNV( uint32_t     semaphoreSciSyncPoolRequestCount_ = {},
                                                                            const void * pNext_                            = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , semaphoreSciSyncPoolRequestCount{ semaphoreSciSyncPoolRequestCount_ }
    {
    }

    VULKAN_HPP_CONSTEXPR
      DeviceSemaphoreSciSyncPoolReservationCreateInfoNV( DeviceSemaphoreSciSyncPoolReservationCreateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DeviceSemaphoreSciSyncPoolReservationCreateInfoNV( VkDeviceSemaphoreSciSyncPoolReservationCreateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : DeviceSemaphoreSciSyncPoolReservationCreateInfoNV( *reinterpret_cast<DeviceSemaphoreSciSyncPoolReservationCreateInfoNV const *>( &rhs ) )
    {
    }

    DeviceSemaphoreSciSyncPoolReservationCreateInfoNV &
      operator=( DeviceSemaphoreSciSyncPoolReservationCreateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#  endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DeviceSemaphoreSciSyncPoolReservationCreateInfoNV & operator=( VkDeviceSemaphoreSciSyncPoolReservationCreateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DeviceSemaphoreSciSyncPoolReservationCreateInfoNV const *>( &rhs );
      return *this;
    }

#  if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DeviceSemaphoreSciSyncPoolReservationCreateInfoNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceSemaphoreSciSyncPoolReservationCreateInfoNV &
      setSemaphoreSciSyncPoolRequestCount( uint32_t semaphoreSciSyncPoolRequestCount_ ) VULKAN_HPP_NOEXCEPT
    {
      semaphoreSciSyncPoolRequestCount = semaphoreSciSyncPoolRequestCount_;
      return *this;
    }
#  endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDeviceSemaphoreSciSyncPoolReservationCreateInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDeviceSemaphoreSciSyncPoolReservationCreateInfoNV *>( this );
    }

    operator VkDeviceSemaphoreSciSyncPoolReservationCreateInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDeviceSemaphoreSciSyncPoolReservationCreateInfoNV *>( this );
    }

#  if defined( VULKAN_HPP_USE_REFLECT )
#    if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#    else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, uint32_t const &>
#    endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, semaphoreSciSyncPoolRequestCount );
    }
#  endif

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DeviceSemaphoreSciSyncPoolReservationCreateInfoNV const & ) const = default;
#  else
    bool operator==( DeviceSemaphoreSciSyncPoolReservationCreateInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#    if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#    else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( semaphoreSciSyncPoolRequestCount == rhs.semaphoreSciSyncPoolRequestCount );
#    endif
    }

    bool operator!=( DeviceSemaphoreSciSyncPoolReservationCreateInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType                            = StructureType::eDeviceSemaphoreSciSyncPoolReservationCreateInfoNV;
    const void *                        pNext                            = {};
    uint32_t                            semaphoreSciSyncPoolRequestCount = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eDeviceSemaphoreSciSyncPoolReservationCreateInfoNV>
  {
    using Type = DeviceSemaphoreSciSyncPoolReservationCreateInfoNV;
  };
#endif /*VK_USE_PLATFORM_SCI*/

  struct DispatchIndirectCommand
  {
    using NativeType = VkDispatchIndirectCommand;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DispatchIndirectCommand( uint32_t x_ = {}, uint32_t y_ = {}, uint32_t z_ = {} ) VULKAN_HPP_NOEXCEPT
      : x{ x_ }
      , y{ y_ }
      , z{ z_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DispatchIndirectCommand( DispatchIndirectCommand const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DispatchIndirectCommand( VkDispatchIndirectCommand const & rhs ) VULKAN_HPP_NOEXCEPT
      : DispatchIndirectCommand( *reinterpret_cast<DispatchIndirectCommand const *>( &rhs ) )
    {
    }

    DispatchIndirectCommand & operator=( DispatchIndirectCommand const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DispatchIndirectCommand & operator=( VkDispatchIndirectCommand const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DispatchIndirectCommand const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DispatchIndirectCommand & setX( uint32_t x_ ) VULKAN_HPP_NOEXCEPT
    {
      x = x_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DispatchIndirectCommand & setY( uint32_t y_ ) VULKAN_HPP_NOEXCEPT
    {
      y = y_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DispatchIndirectCommand & setZ( uint32_t z_ ) VULKAN_HPP_NOEXCEPT
    {
      z = z_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDispatchIndirectCommand const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDispatchIndirectCommand *>( this );
    }

    operator VkDispatchIndirectCommand &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDispatchIndirectCommand *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &, uint32_t const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( x, y, z );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DispatchIndirectCommand const & ) const = default;
#else
    bool operator==( DispatchIndirectCommand const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( x == rhs.x ) && ( y == rhs.y ) && ( z == rhs.z );
#  endif
    }

    bool operator!=( DispatchIndirectCommand const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t x = {};
    uint32_t y = {};
    uint32_t z = {};
  };

  struct DisplayEventInfoEXT
  {
    using NativeType = VkDisplayEventInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDisplayEventInfoEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      DisplayEventInfoEXT( VULKAN_HPP_NAMESPACE::DisplayEventTypeEXT displayEvent_ = VULKAN_HPP_NAMESPACE::DisplayEventTypeEXT::eFirstPixelOut,
                           const void *                              pNext_        = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , displayEvent{ displayEvent_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DisplayEventInfoEXT( DisplayEventInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DisplayEventInfoEXT( VkDisplayEventInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT : DisplayEventInfoEXT( *reinterpret_cast<DisplayEventInfoEXT const *>( &rhs ) )
    {
    }

    DisplayEventInfoEXT & operator=( DisplayEventInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DisplayEventInfoEXT & operator=( VkDisplayEventInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DisplayEventInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DisplayEventInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DisplayEventInfoEXT & setDisplayEvent( VULKAN_HPP_NAMESPACE::DisplayEventTypeEXT displayEvent_ ) VULKAN_HPP_NOEXCEPT
    {
      displayEvent = displayEvent_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDisplayEventInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDisplayEventInfoEXT *>( this );
    }

    operator VkDisplayEventInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDisplayEventInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::DisplayEventTypeEXT const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, displayEvent );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DisplayEventInfoEXT const & ) const = default;
#else
    bool operator==( DisplayEventInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( displayEvent == rhs.displayEvent );
#  endif
    }

    bool operator!=( DisplayEventInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType       sType        = StructureType::eDisplayEventInfoEXT;
    const void *                              pNext        = {};
    VULKAN_HPP_NAMESPACE::DisplayEventTypeEXT displayEvent = VULKAN_HPP_NAMESPACE::DisplayEventTypeEXT::eFirstPixelOut;
  };

  template <>
  struct CppType<StructureType, StructureType::eDisplayEventInfoEXT>
  {
    using Type = DisplayEventInfoEXT;
  };

  struct DisplayModeParametersKHR
  {
    using NativeType = VkDisplayModeParametersKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DisplayModeParametersKHR( VULKAN_HPP_NAMESPACE::Extent2D visibleRegion_ = {}, uint32_t refreshRate_ = {} ) VULKAN_HPP_NOEXCEPT
      : visibleRegion{ visibleRegion_ }
      , refreshRate{ refreshRate_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DisplayModeParametersKHR( DisplayModeParametersKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DisplayModeParametersKHR( VkDisplayModeParametersKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : DisplayModeParametersKHR( *reinterpret_cast<DisplayModeParametersKHR const *>( &rhs ) )
    {
    }

    DisplayModeParametersKHR & operator=( DisplayModeParametersKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DisplayModeParametersKHR & operator=( VkDisplayModeParametersKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DisplayModeParametersKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DisplayModeParametersKHR & setVisibleRegion( VULKAN_HPP_NAMESPACE::Extent2D const & visibleRegion_ ) VULKAN_HPP_NOEXCEPT
    {
      visibleRegion = visibleRegion_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DisplayModeParametersKHR & setRefreshRate( uint32_t refreshRate_ ) VULKAN_HPP_NOEXCEPT
    {
      refreshRate = refreshRate_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDisplayModeParametersKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDisplayModeParametersKHR *>( this );
    }

    operator VkDisplayModeParametersKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDisplayModeParametersKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::Extent2D const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( visibleRegion, refreshRate );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DisplayModeParametersKHR const & ) const = default;
#else
    bool operator==( DisplayModeParametersKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( visibleRegion == rhs.visibleRegion ) && ( refreshRate == rhs.refreshRate );
#  endif
    }

    bool operator!=( DisplayModeParametersKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::Extent2D visibleRegion = {};
    uint32_t                       refreshRate   = {};
  };

  struct DisplayModeCreateInfoKHR
  {
    using NativeType = VkDisplayModeCreateInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDisplayModeCreateInfoKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DisplayModeCreateInfoKHR( VULKAN_HPP_NAMESPACE::DisplayModeCreateFlagsKHR flags_      = {},
                                                   VULKAN_HPP_NAMESPACE::DisplayModeParametersKHR  parameters_ = {},
                                                   const void *                                    pNext_      = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , parameters{ parameters_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DisplayModeCreateInfoKHR( DisplayModeCreateInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DisplayModeCreateInfoKHR( VkDisplayModeCreateInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : DisplayModeCreateInfoKHR( *reinterpret_cast<DisplayModeCreateInfoKHR const *>( &rhs ) )
    {
    }

    DisplayModeCreateInfoKHR & operator=( DisplayModeCreateInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DisplayModeCreateInfoKHR & operator=( VkDisplayModeCreateInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DisplayModeCreateInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DisplayModeCreateInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DisplayModeCreateInfoKHR & setFlags( VULKAN_HPP_NAMESPACE::DisplayModeCreateFlagsKHR flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DisplayModeCreateInfoKHR & setParameters( VULKAN_HPP_NAMESPACE::DisplayModeParametersKHR const & parameters_ ) VULKAN_HPP_NOEXCEPT
    {
      parameters = parameters_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDisplayModeCreateInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDisplayModeCreateInfoKHR *>( this );
    }

    operator VkDisplayModeCreateInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDisplayModeCreateInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::DisplayModeCreateFlagsKHR const &,
               VULKAN_HPP_NAMESPACE::DisplayModeParametersKHR const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, parameters );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DisplayModeCreateInfoKHR const & ) const = default;
#else
    bool operator==( DisplayModeCreateInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( parameters == rhs.parameters );
#  endif
    }

    bool operator!=( DisplayModeCreateInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType             sType      = StructureType::eDisplayModeCreateInfoKHR;
    const void *                                    pNext      = {};
    VULKAN_HPP_NAMESPACE::DisplayModeCreateFlagsKHR flags      = {};
    VULKAN_HPP_NAMESPACE::DisplayModeParametersKHR  parameters = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eDisplayModeCreateInfoKHR>
  {
    using Type = DisplayModeCreateInfoKHR;
  };

  struct DisplayModePropertiesKHR
  {
    using NativeType = VkDisplayModePropertiesKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DisplayModePropertiesKHR( VULKAN_HPP_NAMESPACE::DisplayModeKHR           displayMode_ = {},
                                                   VULKAN_HPP_NAMESPACE::DisplayModeParametersKHR parameters_  = {} ) VULKAN_HPP_NOEXCEPT
      : displayMode{ displayMode_ }
      , parameters{ parameters_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DisplayModePropertiesKHR( DisplayModePropertiesKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DisplayModePropertiesKHR( VkDisplayModePropertiesKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : DisplayModePropertiesKHR( *reinterpret_cast<DisplayModePropertiesKHR const *>( &rhs ) )
    {
    }

    DisplayModePropertiesKHR & operator=( DisplayModePropertiesKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DisplayModePropertiesKHR & operator=( VkDisplayModePropertiesKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DisplayModePropertiesKHR const *>( &rhs );
      return *this;
    }

    operator VkDisplayModePropertiesKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDisplayModePropertiesKHR *>( this );
    }

    operator VkDisplayModePropertiesKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDisplayModePropertiesKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::DisplayModeKHR const &, VULKAN_HPP_NAMESPACE::DisplayModeParametersKHR const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( displayMode, parameters );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DisplayModePropertiesKHR const & ) const = default;
#else
    bool operator==( DisplayModePropertiesKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( displayMode == rhs.displayMode ) && ( parameters == rhs.parameters );
#  endif
    }

    bool operator!=( DisplayModePropertiesKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::DisplayModeKHR           displayMode = {};
    VULKAN_HPP_NAMESPACE::DisplayModeParametersKHR parameters  = {};
  };

  struct DisplayModeProperties2KHR
  {
    using NativeType = VkDisplayModeProperties2KHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDisplayModeProperties2KHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DisplayModeProperties2KHR( VULKAN_HPP_NAMESPACE::DisplayModePropertiesKHR displayModeProperties_ = {},
                                                    void *                                         pNext_                 = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , displayModeProperties{ displayModeProperties_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DisplayModeProperties2KHR( DisplayModeProperties2KHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DisplayModeProperties2KHR( VkDisplayModeProperties2KHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : DisplayModeProperties2KHR( *reinterpret_cast<DisplayModeProperties2KHR const *>( &rhs ) )
    {
    }

    DisplayModeProperties2KHR & operator=( DisplayModeProperties2KHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DisplayModeProperties2KHR & operator=( VkDisplayModeProperties2KHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DisplayModeProperties2KHR const *>( &rhs );
      return *this;
    }

    operator VkDisplayModeProperties2KHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDisplayModeProperties2KHR *>( this );
    }

    operator VkDisplayModeProperties2KHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDisplayModeProperties2KHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, void * const &, VULKAN_HPP_NAMESPACE::DisplayModePropertiesKHR const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, displayModeProperties );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DisplayModeProperties2KHR const & ) const = default;
#else
    bool operator==( DisplayModeProperties2KHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( displayModeProperties == rhs.displayModeProperties );
#  endif
    }

    bool operator!=( DisplayModeProperties2KHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType            sType                 = StructureType::eDisplayModeProperties2KHR;
    void *                                         pNext                 = {};
    VULKAN_HPP_NAMESPACE::DisplayModePropertiesKHR displayModeProperties = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eDisplayModeProperties2KHR>
  {
    using Type = DisplayModeProperties2KHR;
  };

  struct DisplayPlaneCapabilitiesKHR
  {
    using NativeType = VkDisplayPlaneCapabilitiesKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DisplayPlaneCapabilitiesKHR( VULKAN_HPP_NAMESPACE::DisplayPlaneAlphaFlagsKHR supportedAlpha_ = {},
                                                      VULKAN_HPP_NAMESPACE::Offset2D                  minSrcPosition_ = {},
                                                      VULKAN_HPP_NAMESPACE::Offset2D                  maxSrcPosition_ = {},
                                                      VULKAN_HPP_NAMESPACE::Extent2D                  minSrcExtent_   = {},
                                                      VULKAN_HPP_NAMESPACE::Extent2D                  maxSrcExtent_   = {},
                                                      VULKAN_HPP_NAMESPACE::Offset2D                  minDstPosition_ = {},
                                                      VULKAN_HPP_NAMESPACE::Offset2D                  maxDstPosition_ = {},
                                                      VULKAN_HPP_NAMESPACE::Extent2D                  minDstExtent_   = {},
                                                      VULKAN_HPP_NAMESPACE::Extent2D                  maxDstExtent_   = {} ) VULKAN_HPP_NOEXCEPT
      : supportedAlpha{ supportedAlpha_ }
      , minSrcPosition{ minSrcPosition_ }
      , maxSrcPosition{ maxSrcPosition_ }
      , minSrcExtent{ minSrcExtent_ }
      , maxSrcExtent{ maxSrcExtent_ }
      , minDstPosition{ minDstPosition_ }
      , maxDstPosition{ maxDstPosition_ }
      , minDstExtent{ minDstExtent_ }
      , maxDstExtent{ maxDstExtent_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DisplayPlaneCapabilitiesKHR( DisplayPlaneCapabilitiesKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DisplayPlaneCapabilitiesKHR( VkDisplayPlaneCapabilitiesKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : DisplayPlaneCapabilitiesKHR( *reinterpret_cast<DisplayPlaneCapabilitiesKHR const *>( &rhs ) )
    {
    }

    DisplayPlaneCapabilitiesKHR & operator=( DisplayPlaneCapabilitiesKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DisplayPlaneCapabilitiesKHR & operator=( VkDisplayPlaneCapabilitiesKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DisplayPlaneCapabilitiesKHR const *>( &rhs );
      return *this;
    }

    operator VkDisplayPlaneCapabilitiesKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDisplayPlaneCapabilitiesKHR *>( this );
    }

    operator VkDisplayPlaneCapabilitiesKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDisplayPlaneCapabilitiesKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::DisplayPlaneAlphaFlagsKHR const &,
               VULKAN_HPP_NAMESPACE::Offset2D const &,
               VULKAN_HPP_NAMESPACE::Offset2D const &,
               VULKAN_HPP_NAMESPACE::Extent2D const &,
               VULKAN_HPP_NAMESPACE::Extent2D const &,
               VULKAN_HPP_NAMESPACE::Offset2D const &,
               VULKAN_HPP_NAMESPACE::Offset2D const &,
               VULKAN_HPP_NAMESPACE::Extent2D const &,
               VULKAN_HPP_NAMESPACE::Extent2D const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( supportedAlpha, minSrcPosition, maxSrcPosition, minSrcExtent, maxSrcExtent, minDstPosition, maxDstPosition, minDstExtent, maxDstExtent );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DisplayPlaneCapabilitiesKHR const & ) const = default;
#else
    bool operator==( DisplayPlaneCapabilitiesKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( supportedAlpha == rhs.supportedAlpha ) && ( minSrcPosition == rhs.minSrcPosition ) && ( maxSrcPosition == rhs.maxSrcPosition ) &&
             ( minSrcExtent == rhs.minSrcExtent ) && ( maxSrcExtent == rhs.maxSrcExtent ) && ( minDstPosition == rhs.minDstPosition ) &&
             ( maxDstPosition == rhs.maxDstPosition ) && ( minDstExtent == rhs.minDstExtent ) && ( maxDstExtent == rhs.maxDstExtent );
#  endif
    }

    bool operator!=( DisplayPlaneCapabilitiesKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::DisplayPlaneAlphaFlagsKHR supportedAlpha = {};
    VULKAN_HPP_NAMESPACE::Offset2D                  minSrcPosition = {};
    VULKAN_HPP_NAMESPACE::Offset2D                  maxSrcPosition = {};
    VULKAN_HPP_NAMESPACE::Extent2D                  minSrcExtent   = {};
    VULKAN_HPP_NAMESPACE::Extent2D                  maxSrcExtent   = {};
    VULKAN_HPP_NAMESPACE::Offset2D                  minDstPosition = {};
    VULKAN_HPP_NAMESPACE::Offset2D                  maxDstPosition = {};
    VULKAN_HPP_NAMESPACE::Extent2D                  minDstExtent   = {};
    VULKAN_HPP_NAMESPACE::Extent2D                  maxDstExtent   = {};
  };

  struct DisplayPlaneCapabilities2KHR
  {
    using NativeType = VkDisplayPlaneCapabilities2KHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDisplayPlaneCapabilities2KHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DisplayPlaneCapabilities2KHR( VULKAN_HPP_NAMESPACE::DisplayPlaneCapabilitiesKHR capabilities_ = {},
                                                       void *                                            pNext_        = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , capabilities{ capabilities_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DisplayPlaneCapabilities2KHR( DisplayPlaneCapabilities2KHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DisplayPlaneCapabilities2KHR( VkDisplayPlaneCapabilities2KHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : DisplayPlaneCapabilities2KHR( *reinterpret_cast<DisplayPlaneCapabilities2KHR const *>( &rhs ) )
    {
    }

    DisplayPlaneCapabilities2KHR & operator=( DisplayPlaneCapabilities2KHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DisplayPlaneCapabilities2KHR & operator=( VkDisplayPlaneCapabilities2KHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DisplayPlaneCapabilities2KHR const *>( &rhs );
      return *this;
    }

    operator VkDisplayPlaneCapabilities2KHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDisplayPlaneCapabilities2KHR *>( this );
    }

    operator VkDisplayPlaneCapabilities2KHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDisplayPlaneCapabilities2KHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, void * const &, VULKAN_HPP_NAMESPACE::DisplayPlaneCapabilitiesKHR const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, capabilities );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DisplayPlaneCapabilities2KHR const & ) const = default;
#else
    bool operator==( DisplayPlaneCapabilities2KHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( capabilities == rhs.capabilities );
#  endif
    }

    bool operator!=( DisplayPlaneCapabilities2KHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType               sType        = StructureType::eDisplayPlaneCapabilities2KHR;
    void *                                            pNext        = {};
    VULKAN_HPP_NAMESPACE::DisplayPlaneCapabilitiesKHR capabilities = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eDisplayPlaneCapabilities2KHR>
  {
    using Type = DisplayPlaneCapabilities2KHR;
  };

  struct DisplayPlaneInfo2KHR
  {
    using NativeType = VkDisplayPlaneInfo2KHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDisplayPlaneInfo2KHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      DisplayPlaneInfo2KHR( VULKAN_HPP_NAMESPACE::DisplayModeKHR mode_ = {}, uint32_t planeIndex_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , mode{ mode_ }
      , planeIndex{ planeIndex_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DisplayPlaneInfo2KHR( DisplayPlaneInfo2KHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DisplayPlaneInfo2KHR( VkDisplayPlaneInfo2KHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : DisplayPlaneInfo2KHR( *reinterpret_cast<DisplayPlaneInfo2KHR const *>( &rhs ) )
    {
    }

    DisplayPlaneInfo2KHR & operator=( DisplayPlaneInfo2KHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DisplayPlaneInfo2KHR & operator=( VkDisplayPlaneInfo2KHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DisplayPlaneInfo2KHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DisplayPlaneInfo2KHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DisplayPlaneInfo2KHR & setMode( VULKAN_HPP_NAMESPACE::DisplayModeKHR mode_ ) VULKAN_HPP_NOEXCEPT
    {
      mode = mode_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DisplayPlaneInfo2KHR & setPlaneIndex( uint32_t planeIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      planeIndex = planeIndex_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDisplayPlaneInfo2KHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDisplayPlaneInfo2KHR *>( this );
    }

    operator VkDisplayPlaneInfo2KHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDisplayPlaneInfo2KHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::DisplayModeKHR const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, mode, planeIndex );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DisplayPlaneInfo2KHR const & ) const = default;
#else
    bool operator==( DisplayPlaneInfo2KHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( mode == rhs.mode ) && ( planeIndex == rhs.planeIndex );
#  endif
    }

    bool operator!=( DisplayPlaneInfo2KHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType  sType      = StructureType::eDisplayPlaneInfo2KHR;
    const void *                         pNext      = {};
    VULKAN_HPP_NAMESPACE::DisplayModeKHR mode       = {};
    uint32_t                             planeIndex = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eDisplayPlaneInfo2KHR>
  {
    using Type = DisplayPlaneInfo2KHR;
  };

  struct DisplayPlanePropertiesKHR
  {
    using NativeType = VkDisplayPlanePropertiesKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DisplayPlanePropertiesKHR( VULKAN_HPP_NAMESPACE::DisplayKHR currentDisplay_    = {},
                                                    uint32_t                         currentStackIndex_ = {} ) VULKAN_HPP_NOEXCEPT
      : currentDisplay{ currentDisplay_ }
      , currentStackIndex{ currentStackIndex_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DisplayPlanePropertiesKHR( DisplayPlanePropertiesKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DisplayPlanePropertiesKHR( VkDisplayPlanePropertiesKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : DisplayPlanePropertiesKHR( *reinterpret_cast<DisplayPlanePropertiesKHR const *>( &rhs ) )
    {
    }

    DisplayPlanePropertiesKHR & operator=( DisplayPlanePropertiesKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DisplayPlanePropertiesKHR & operator=( VkDisplayPlanePropertiesKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DisplayPlanePropertiesKHR const *>( &rhs );
      return *this;
    }

    operator VkDisplayPlanePropertiesKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDisplayPlanePropertiesKHR *>( this );
    }

    operator VkDisplayPlanePropertiesKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDisplayPlanePropertiesKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::DisplayKHR const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( currentDisplay, currentStackIndex );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DisplayPlanePropertiesKHR const & ) const = default;
#else
    bool operator==( DisplayPlanePropertiesKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( currentDisplay == rhs.currentDisplay ) && ( currentStackIndex == rhs.currentStackIndex );
#  endif
    }

    bool operator!=( DisplayPlanePropertiesKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::DisplayKHR currentDisplay    = {};
    uint32_t                         currentStackIndex = {};
  };

  struct DisplayPlaneProperties2KHR
  {
    using NativeType = VkDisplayPlaneProperties2KHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDisplayPlaneProperties2KHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DisplayPlaneProperties2KHR( VULKAN_HPP_NAMESPACE::DisplayPlanePropertiesKHR displayPlaneProperties_ = {},
                                                     void *                                          pNext_                  = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , displayPlaneProperties{ displayPlaneProperties_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DisplayPlaneProperties2KHR( DisplayPlaneProperties2KHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DisplayPlaneProperties2KHR( VkDisplayPlaneProperties2KHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : DisplayPlaneProperties2KHR( *reinterpret_cast<DisplayPlaneProperties2KHR const *>( &rhs ) )
    {
    }

    DisplayPlaneProperties2KHR & operator=( DisplayPlaneProperties2KHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DisplayPlaneProperties2KHR & operator=( VkDisplayPlaneProperties2KHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DisplayPlaneProperties2KHR const *>( &rhs );
      return *this;
    }

    operator VkDisplayPlaneProperties2KHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDisplayPlaneProperties2KHR *>( this );
    }

    operator VkDisplayPlaneProperties2KHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDisplayPlaneProperties2KHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, void * const &, VULKAN_HPP_NAMESPACE::DisplayPlanePropertiesKHR const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, displayPlaneProperties );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DisplayPlaneProperties2KHR const & ) const = default;
#else
    bool operator==( DisplayPlaneProperties2KHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( displayPlaneProperties == rhs.displayPlaneProperties );
#  endif
    }

    bool operator!=( DisplayPlaneProperties2KHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType             sType                  = StructureType::eDisplayPlaneProperties2KHR;
    void *                                          pNext                  = {};
    VULKAN_HPP_NAMESPACE::DisplayPlanePropertiesKHR displayPlaneProperties = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eDisplayPlaneProperties2KHR>
  {
    using Type = DisplayPlaneProperties2KHR;
  };

  struct DisplayPowerInfoEXT
  {
    using NativeType = VkDisplayPowerInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDisplayPowerInfoEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DisplayPowerInfoEXT( VULKAN_HPP_NAMESPACE::DisplayPowerStateEXT powerState_ = VULKAN_HPP_NAMESPACE::DisplayPowerStateEXT::eOff,
                                              const void *                               pNext_      = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , powerState{ powerState_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DisplayPowerInfoEXT( DisplayPowerInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DisplayPowerInfoEXT( VkDisplayPowerInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT : DisplayPowerInfoEXT( *reinterpret_cast<DisplayPowerInfoEXT const *>( &rhs ) )
    {
    }

    DisplayPowerInfoEXT & operator=( DisplayPowerInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DisplayPowerInfoEXT & operator=( VkDisplayPowerInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DisplayPowerInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DisplayPowerInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DisplayPowerInfoEXT & setPowerState( VULKAN_HPP_NAMESPACE::DisplayPowerStateEXT powerState_ ) VULKAN_HPP_NOEXCEPT
    {
      powerState = powerState_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDisplayPowerInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDisplayPowerInfoEXT *>( this );
    }

    operator VkDisplayPowerInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDisplayPowerInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::DisplayPowerStateEXT const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, powerState );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DisplayPowerInfoEXT const & ) const = default;
#else
    bool operator==( DisplayPowerInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( powerState == rhs.powerState );
#  endif
    }

    bool operator!=( DisplayPowerInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType        sType      = StructureType::eDisplayPowerInfoEXT;
    const void *                               pNext      = {};
    VULKAN_HPP_NAMESPACE::DisplayPowerStateEXT powerState = VULKAN_HPP_NAMESPACE::DisplayPowerStateEXT::eOff;
  };

  template <>
  struct CppType<StructureType, StructureType::eDisplayPowerInfoEXT>
  {
    using Type = DisplayPowerInfoEXT;
  };

  struct DisplayPresentInfoKHR
  {
    using NativeType = VkDisplayPresentInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDisplayPresentInfoKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DisplayPresentInfoKHR( VULKAN_HPP_NAMESPACE::Rect2D srcRect_    = {},
                                                VULKAN_HPP_NAMESPACE::Rect2D dstRect_    = {},
                                                VULKAN_HPP_NAMESPACE::Bool32 persistent_ = {},
                                                const void *                 pNext_      = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , srcRect{ srcRect_ }
      , dstRect{ dstRect_ }
      , persistent{ persistent_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DisplayPresentInfoKHR( DisplayPresentInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DisplayPresentInfoKHR( VkDisplayPresentInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : DisplayPresentInfoKHR( *reinterpret_cast<DisplayPresentInfoKHR const *>( &rhs ) )
    {
    }

    DisplayPresentInfoKHR & operator=( DisplayPresentInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DisplayPresentInfoKHR & operator=( VkDisplayPresentInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DisplayPresentInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DisplayPresentInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DisplayPresentInfoKHR & setSrcRect( VULKAN_HPP_NAMESPACE::Rect2D const & srcRect_ ) VULKAN_HPP_NOEXCEPT
    {
      srcRect = srcRect_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DisplayPresentInfoKHR & setDstRect( VULKAN_HPP_NAMESPACE::Rect2D const & dstRect_ ) VULKAN_HPP_NOEXCEPT
    {
      dstRect = dstRect_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DisplayPresentInfoKHR & setPersistent( VULKAN_HPP_NAMESPACE::Bool32 persistent_ ) VULKAN_HPP_NOEXCEPT
    {
      persistent = persistent_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDisplayPresentInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDisplayPresentInfoKHR *>( this );
    }

    operator VkDisplayPresentInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDisplayPresentInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::Rect2D const &,
               VULKAN_HPP_NAMESPACE::Rect2D const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, srcRect, dstRect, persistent );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DisplayPresentInfoKHR const & ) const = default;
#else
    bool operator==( DisplayPresentInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcRect == rhs.srcRect ) && ( dstRect == rhs.dstRect ) && ( persistent == rhs.persistent );
#  endif
    }

    bool operator!=( DisplayPresentInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType      = StructureType::eDisplayPresentInfoKHR;
    const void *                        pNext      = {};
    VULKAN_HPP_NAMESPACE::Rect2D        srcRect    = {};
    VULKAN_HPP_NAMESPACE::Rect2D        dstRect    = {};
    VULKAN_HPP_NAMESPACE::Bool32        persistent = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eDisplayPresentInfoKHR>
  {
    using Type = DisplayPresentInfoKHR;
  };

  struct DisplayPropertiesKHR
  {
    using NativeType = VkDisplayPropertiesKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DisplayPropertiesKHR( VULKAN_HPP_NAMESPACE::DisplayKHR               display_              = {},
                                               const char *                                   displayName_          = {},
                                               VULKAN_HPP_NAMESPACE::Extent2D                 physicalDimensions_   = {},
                                               VULKAN_HPP_NAMESPACE::Extent2D                 physicalResolution_   = {},
                                               VULKAN_HPP_NAMESPACE::SurfaceTransformFlagsKHR supportedTransforms_  = {},
                                               VULKAN_HPP_NAMESPACE::Bool32                   planeReorderPossible_ = {},
                                               VULKAN_HPP_NAMESPACE::Bool32                   persistentContent_    = {} ) VULKAN_HPP_NOEXCEPT
      : display{ display_ }
      , displayName{ displayName_ }
      , physicalDimensions{ physicalDimensions_ }
      , physicalResolution{ physicalResolution_ }
      , supportedTransforms{ supportedTransforms_ }
      , planeReorderPossible{ planeReorderPossible_ }
      , persistentContent{ persistentContent_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DisplayPropertiesKHR( DisplayPropertiesKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DisplayPropertiesKHR( VkDisplayPropertiesKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : DisplayPropertiesKHR( *reinterpret_cast<DisplayPropertiesKHR const *>( &rhs ) )
    {
    }

    DisplayPropertiesKHR & operator=( DisplayPropertiesKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DisplayPropertiesKHR & operator=( VkDisplayPropertiesKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DisplayPropertiesKHR const *>( &rhs );
      return *this;
    }

    operator VkDisplayPropertiesKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDisplayPropertiesKHR *>( this );
    }

    operator VkDisplayPropertiesKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDisplayPropertiesKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::DisplayKHR const &,
               const char * const &,
               VULKAN_HPP_NAMESPACE::Extent2D const &,
               VULKAN_HPP_NAMESPACE::Extent2D const &,
               VULKAN_HPP_NAMESPACE::SurfaceTransformFlagsKHR const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( display, displayName, physicalDimensions, physicalResolution, supportedTransforms, planeReorderPossible, persistentContent );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    std::strong_ordering operator<=>( DisplayPropertiesKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      if ( auto cmp = display <=> rhs.display; cmp != 0 )
        return cmp;
      if ( displayName != rhs.displayName )
        if ( auto cmp = strcmp( displayName, rhs.displayName ); cmp != 0 )
          return ( cmp < 0 ) ? std::strong_ordering::less : std::strong_ordering::greater;
      if ( auto cmp = physicalDimensions <=> rhs.physicalDimensions; cmp != 0 )
        return cmp;
      if ( auto cmp = physicalResolution <=> rhs.physicalResolution; cmp != 0 )
        return cmp;
      if ( auto cmp = supportedTransforms <=> rhs.supportedTransforms; cmp != 0 )
        return cmp;
      if ( auto cmp = planeReorderPossible <=> rhs.planeReorderPossible; cmp != 0 )
        return cmp;
      if ( auto cmp = persistentContent <=> rhs.persistentContent; cmp != 0 )
        return cmp;

      return std::strong_ordering::equivalent;
    }
#endif

    bool operator==( DisplayPropertiesKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( display == rhs.display ) && ( ( displayName == rhs.displayName ) || ( strcmp( displayName, rhs.displayName ) == 0 ) ) &&
             ( physicalDimensions == rhs.physicalDimensions ) && ( physicalResolution == rhs.physicalResolution ) &&
             ( supportedTransforms == rhs.supportedTransforms ) && ( planeReorderPossible == rhs.planeReorderPossible ) &&
             ( persistentContent == rhs.persistentContent );
    }

    bool operator!=( DisplayPropertiesKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }

  public:
    VULKAN_HPP_NAMESPACE::DisplayKHR               display              = {};
    const char *                                   displayName          = {};
    VULKAN_HPP_NAMESPACE::Extent2D                 physicalDimensions   = {};
    VULKAN_HPP_NAMESPACE::Extent2D                 physicalResolution   = {};
    VULKAN_HPP_NAMESPACE::SurfaceTransformFlagsKHR supportedTransforms  = {};
    VULKAN_HPP_NAMESPACE::Bool32                   planeReorderPossible = {};
    VULKAN_HPP_NAMESPACE::Bool32                   persistentContent    = {};
  };

  struct DisplayProperties2KHR
  {
    using NativeType = VkDisplayProperties2KHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDisplayProperties2KHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DisplayProperties2KHR( VULKAN_HPP_NAMESPACE::DisplayPropertiesKHR displayProperties_ = {},
                                                void *                                     pNext_             = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , displayProperties{ displayProperties_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DisplayProperties2KHR( DisplayProperties2KHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DisplayProperties2KHR( VkDisplayProperties2KHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : DisplayProperties2KHR( *reinterpret_cast<DisplayProperties2KHR const *>( &rhs ) )
    {
    }

    DisplayProperties2KHR & operator=( DisplayProperties2KHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DisplayProperties2KHR & operator=( VkDisplayProperties2KHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DisplayProperties2KHR const *>( &rhs );
      return *this;
    }

    operator VkDisplayProperties2KHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDisplayProperties2KHR *>( this );
    }

    operator VkDisplayProperties2KHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDisplayProperties2KHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, void * const &, VULKAN_HPP_NAMESPACE::DisplayPropertiesKHR const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, displayProperties );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DisplayProperties2KHR const & ) const = default;
#else
    bool operator==( DisplayProperties2KHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( displayProperties == rhs.displayProperties );
#  endif
    }

    bool operator!=( DisplayProperties2KHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType        sType             = StructureType::eDisplayProperties2KHR;
    void *                                     pNext             = {};
    VULKAN_HPP_NAMESPACE::DisplayPropertiesKHR displayProperties = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eDisplayProperties2KHR>
  {
    using Type = DisplayProperties2KHR;
  };

  struct DisplaySurfaceCreateInfoKHR
  {
    using NativeType = VkDisplaySurfaceCreateInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDisplaySurfaceCreateInfoKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      DisplaySurfaceCreateInfoKHR( VULKAN_HPP_NAMESPACE::DisplaySurfaceCreateFlagsKHR flags_           = {},
                                   VULKAN_HPP_NAMESPACE::DisplayModeKHR               displayMode_     = {},
                                   uint32_t                                           planeIndex_      = {},
                                   uint32_t                                           planeStackIndex_ = {},
                                   VULKAN_HPP_NAMESPACE::SurfaceTransformFlagBitsKHR  transform_ = VULKAN_HPP_NAMESPACE::SurfaceTransformFlagBitsKHR::eIdentity,
                                   float                                              globalAlpha_ = {},
                                   VULKAN_HPP_NAMESPACE::DisplayPlaneAlphaFlagBitsKHR alphaMode_ = VULKAN_HPP_NAMESPACE::DisplayPlaneAlphaFlagBitsKHR::eOpaque,
                                   VULKAN_HPP_NAMESPACE::Extent2D                     imageExtent_ = {},
                                   const void *                                       pNext_       = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , displayMode{ displayMode_ }
      , planeIndex{ planeIndex_ }
      , planeStackIndex{ planeStackIndex_ }
      , transform{ transform_ }
      , globalAlpha{ globalAlpha_ }
      , alphaMode{ alphaMode_ }
      , imageExtent{ imageExtent_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DisplaySurfaceCreateInfoKHR( DisplaySurfaceCreateInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DisplaySurfaceCreateInfoKHR( VkDisplaySurfaceCreateInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : DisplaySurfaceCreateInfoKHR( *reinterpret_cast<DisplaySurfaceCreateInfoKHR const *>( &rhs ) )
    {
    }

    DisplaySurfaceCreateInfoKHR & operator=( DisplaySurfaceCreateInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DisplaySurfaceCreateInfoKHR & operator=( VkDisplaySurfaceCreateInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DisplaySurfaceCreateInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DisplaySurfaceCreateInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DisplaySurfaceCreateInfoKHR & setFlags( VULKAN_HPP_NAMESPACE::DisplaySurfaceCreateFlagsKHR flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DisplaySurfaceCreateInfoKHR & setDisplayMode( VULKAN_HPP_NAMESPACE::DisplayModeKHR displayMode_ ) VULKAN_HPP_NOEXCEPT
    {
      displayMode = displayMode_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DisplaySurfaceCreateInfoKHR & setPlaneIndex( uint32_t planeIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      planeIndex = planeIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DisplaySurfaceCreateInfoKHR & setPlaneStackIndex( uint32_t planeStackIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      planeStackIndex = planeStackIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DisplaySurfaceCreateInfoKHR & setTransform( VULKAN_HPP_NAMESPACE::SurfaceTransformFlagBitsKHR transform_ ) VULKAN_HPP_NOEXCEPT
    {
      transform = transform_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DisplaySurfaceCreateInfoKHR & setGlobalAlpha( float globalAlpha_ ) VULKAN_HPP_NOEXCEPT
    {
      globalAlpha = globalAlpha_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DisplaySurfaceCreateInfoKHR & setAlphaMode( VULKAN_HPP_NAMESPACE::DisplayPlaneAlphaFlagBitsKHR alphaMode_ ) VULKAN_HPP_NOEXCEPT
    {
      alphaMode = alphaMode_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DisplaySurfaceCreateInfoKHR & setImageExtent( VULKAN_HPP_NAMESPACE::Extent2D const & imageExtent_ ) VULKAN_HPP_NOEXCEPT
    {
      imageExtent = imageExtent_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDisplaySurfaceCreateInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDisplaySurfaceCreateInfoKHR *>( this );
    }

    operator VkDisplaySurfaceCreateInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDisplaySurfaceCreateInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::DisplaySurfaceCreateFlagsKHR const &,
               VULKAN_HPP_NAMESPACE::DisplayModeKHR const &,
               uint32_t const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::SurfaceTransformFlagBitsKHR const &,
               float const &,
               VULKAN_HPP_NAMESPACE::DisplayPlaneAlphaFlagBitsKHR const &,
               VULKAN_HPP_NAMESPACE::Extent2D const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, displayMode, planeIndex, planeStackIndex, transform, globalAlpha, alphaMode, imageExtent );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DisplaySurfaceCreateInfoKHR const & ) const = default;
#else
    bool operator==( DisplaySurfaceCreateInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( displayMode == rhs.displayMode ) &&
             ( planeIndex == rhs.planeIndex ) && ( planeStackIndex == rhs.planeStackIndex ) && ( transform == rhs.transform ) &&
             ( globalAlpha == rhs.globalAlpha ) && ( alphaMode == rhs.alphaMode ) && ( imageExtent == rhs.imageExtent );
#  endif
    }

    bool operator!=( DisplaySurfaceCreateInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                sType           = StructureType::eDisplaySurfaceCreateInfoKHR;
    const void *                                       pNext           = {};
    VULKAN_HPP_NAMESPACE::DisplaySurfaceCreateFlagsKHR flags           = {};
    VULKAN_HPP_NAMESPACE::DisplayModeKHR               displayMode     = {};
    uint32_t                                           planeIndex      = {};
    uint32_t                                           planeStackIndex = {};
    VULKAN_HPP_NAMESPACE::SurfaceTransformFlagBitsKHR  transform       = VULKAN_HPP_NAMESPACE::SurfaceTransformFlagBitsKHR::eIdentity;
    float                                              globalAlpha     = {};
    VULKAN_HPP_NAMESPACE::DisplayPlaneAlphaFlagBitsKHR alphaMode       = VULKAN_HPP_NAMESPACE::DisplayPlaneAlphaFlagBitsKHR::eOpaque;
    VULKAN_HPP_NAMESPACE::Extent2D                     imageExtent     = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eDisplaySurfaceCreateInfoKHR>
  {
    using Type = DisplaySurfaceCreateInfoKHR;
  };

  struct DrawIndexedIndirectCommand
  {
    using NativeType = VkDrawIndexedIndirectCommand;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DrawIndexedIndirectCommand( uint32_t indexCount_    = {},
                                                     uint32_t instanceCount_ = {},
                                                     uint32_t firstIndex_    = {},
                                                     int32_t  vertexOffset_  = {},
                                                     uint32_t firstInstance_ = {} ) VULKAN_HPP_NOEXCEPT
      : indexCount{ indexCount_ }
      , instanceCount{ instanceCount_ }
      , firstIndex{ firstIndex_ }
      , vertexOffset{ vertexOffset_ }
      , firstInstance{ firstInstance_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DrawIndexedIndirectCommand( DrawIndexedIndirectCommand const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DrawIndexedIndirectCommand( VkDrawIndexedIndirectCommand const & rhs ) VULKAN_HPP_NOEXCEPT
      : DrawIndexedIndirectCommand( *reinterpret_cast<DrawIndexedIndirectCommand const *>( &rhs ) )
    {
    }

    DrawIndexedIndirectCommand & operator=( DrawIndexedIndirectCommand const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DrawIndexedIndirectCommand & operator=( VkDrawIndexedIndirectCommand const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DrawIndexedIndirectCommand const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DrawIndexedIndirectCommand & setIndexCount( uint32_t indexCount_ ) VULKAN_HPP_NOEXCEPT
    {
      indexCount = indexCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DrawIndexedIndirectCommand & setInstanceCount( uint32_t instanceCount_ ) VULKAN_HPP_NOEXCEPT
    {
      instanceCount = instanceCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DrawIndexedIndirectCommand & setFirstIndex( uint32_t firstIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      firstIndex = firstIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DrawIndexedIndirectCommand & setVertexOffset( int32_t vertexOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexOffset = vertexOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DrawIndexedIndirectCommand & setFirstInstance( uint32_t firstInstance_ ) VULKAN_HPP_NOEXCEPT
    {
      firstInstance = firstInstance_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDrawIndexedIndirectCommand const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDrawIndexedIndirectCommand *>( this );
    }

    operator VkDrawIndexedIndirectCommand &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDrawIndexedIndirectCommand *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &, uint32_t const &, uint32_t const &, int32_t const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( indexCount, instanceCount, firstIndex, vertexOffset, firstInstance );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DrawIndexedIndirectCommand const & ) const = default;
#else
    bool operator==( DrawIndexedIndirectCommand const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( indexCount == rhs.indexCount ) && ( instanceCount == rhs.instanceCount ) && ( firstIndex == rhs.firstIndex ) &&
             ( vertexOffset == rhs.vertexOffset ) && ( firstInstance == rhs.firstInstance );
#  endif
    }

    bool operator!=( DrawIndexedIndirectCommand const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t indexCount    = {};
    uint32_t instanceCount = {};
    uint32_t firstIndex    = {};
    int32_t  vertexOffset  = {};
    uint32_t firstInstance = {};
  };

  struct DrawIndirectCommand
  {
    using NativeType = VkDrawIndirectCommand;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DrawIndirectCommand( uint32_t vertexCount_   = {},
                                              uint32_t instanceCount_ = {},
                                              uint32_t firstVertex_   = {},
                                              uint32_t firstInstance_ = {} ) VULKAN_HPP_NOEXCEPT
      : vertexCount{ vertexCount_ }
      , instanceCount{ instanceCount_ }
      , firstVertex{ firstVertex_ }
      , firstInstance{ firstInstance_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DrawIndirectCommand( DrawIndirectCommand const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DrawIndirectCommand( VkDrawIndirectCommand const & rhs ) VULKAN_HPP_NOEXCEPT : DrawIndirectCommand( *reinterpret_cast<DrawIndirectCommand const *>( &rhs ) )
    {
    }

    DrawIndirectCommand & operator=( DrawIndirectCommand const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DrawIndirectCommand & operator=( VkDrawIndirectCommand const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DrawIndirectCommand const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DrawIndirectCommand & setVertexCount( uint32_t vertexCount_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexCount = vertexCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DrawIndirectCommand & setInstanceCount( uint32_t instanceCount_ ) VULKAN_HPP_NOEXCEPT
    {
      instanceCount = instanceCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DrawIndirectCommand & setFirstVertex( uint32_t firstVertex_ ) VULKAN_HPP_NOEXCEPT
    {
      firstVertex = firstVertex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DrawIndirectCommand & setFirstInstance( uint32_t firstInstance_ ) VULKAN_HPP_NOEXCEPT
    {
      firstInstance = firstInstance_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDrawIndirectCommand const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDrawIndirectCommand *>( this );
    }

    operator VkDrawIndirectCommand &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDrawIndirectCommand *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &, uint32_t const &, uint32_t const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( vertexCount, instanceCount, firstVertex, firstInstance );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DrawIndirectCommand const & ) const = default;
#else
    bool operator==( DrawIndirectCommand const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( vertexCount == rhs.vertexCount ) && ( instanceCount == rhs.instanceCount ) && ( firstVertex == rhs.firstVertex ) &&
             ( firstInstance == rhs.firstInstance );
#  endif
    }

    bool operator!=( DrawIndirectCommand const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t vertexCount   = {};
    uint32_t instanceCount = {};
    uint32_t firstVertex   = {};
    uint32_t firstInstance = {};
  };

  struct DrmFormatModifierProperties2EXT
  {
    using NativeType = VkDrmFormatModifierProperties2EXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DrmFormatModifierProperties2EXT( uint64_t                                  drmFormatModifier_               = {},
                                                          uint32_t                                  drmFormatModifierPlaneCount_     = {},
                                                          VULKAN_HPP_NAMESPACE::FormatFeatureFlags2 drmFormatModifierTilingFeatures_ = {} ) VULKAN_HPP_NOEXCEPT
      : drmFormatModifier{ drmFormatModifier_ }
      , drmFormatModifierPlaneCount{ drmFormatModifierPlaneCount_ }
      , drmFormatModifierTilingFeatures{ drmFormatModifierTilingFeatures_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DrmFormatModifierProperties2EXT( DrmFormatModifierProperties2EXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DrmFormatModifierProperties2EXT( VkDrmFormatModifierProperties2EXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : DrmFormatModifierProperties2EXT( *reinterpret_cast<DrmFormatModifierProperties2EXT const *>( &rhs ) )
    {
    }

    DrmFormatModifierProperties2EXT & operator=( DrmFormatModifierProperties2EXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DrmFormatModifierProperties2EXT & operator=( VkDrmFormatModifierProperties2EXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DrmFormatModifierProperties2EXT const *>( &rhs );
      return *this;
    }

    operator VkDrmFormatModifierProperties2EXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDrmFormatModifierProperties2EXT *>( this );
    }

    operator VkDrmFormatModifierProperties2EXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDrmFormatModifierProperties2EXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint64_t const &, uint32_t const &, VULKAN_HPP_NAMESPACE::FormatFeatureFlags2 const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( drmFormatModifier, drmFormatModifierPlaneCount, drmFormatModifierTilingFeatures );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DrmFormatModifierProperties2EXT const & ) const = default;
#else
    bool operator==( DrmFormatModifierProperties2EXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( drmFormatModifier == rhs.drmFormatModifier ) && ( drmFormatModifierPlaneCount == rhs.drmFormatModifierPlaneCount ) &&
             ( drmFormatModifierTilingFeatures == rhs.drmFormatModifierTilingFeatures );
#  endif
    }

    bool operator!=( DrmFormatModifierProperties2EXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint64_t                                  drmFormatModifier               = {};
    uint32_t                                  drmFormatModifierPlaneCount     = {};
    VULKAN_HPP_NAMESPACE::FormatFeatureFlags2 drmFormatModifierTilingFeatures = {};
  };

  struct DrmFormatModifierPropertiesEXT
  {
    using NativeType = VkDrmFormatModifierPropertiesEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DrmFormatModifierPropertiesEXT( uint64_t                                 drmFormatModifier_               = {},
                                                         uint32_t                                 drmFormatModifierPlaneCount_     = {},
                                                         VULKAN_HPP_NAMESPACE::FormatFeatureFlags drmFormatModifierTilingFeatures_ = {} ) VULKAN_HPP_NOEXCEPT
      : drmFormatModifier{ drmFormatModifier_ }
      , drmFormatModifierPlaneCount{ drmFormatModifierPlaneCount_ }
      , drmFormatModifierTilingFeatures{ drmFormatModifierTilingFeatures_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DrmFormatModifierPropertiesEXT( DrmFormatModifierPropertiesEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DrmFormatModifierPropertiesEXT( VkDrmFormatModifierPropertiesEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : DrmFormatModifierPropertiesEXT( *reinterpret_cast<DrmFormatModifierPropertiesEXT const *>( &rhs ) )
    {
    }

    DrmFormatModifierPropertiesEXT & operator=( DrmFormatModifierPropertiesEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DrmFormatModifierPropertiesEXT & operator=( VkDrmFormatModifierPropertiesEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DrmFormatModifierPropertiesEXT const *>( &rhs );
      return *this;
    }

    operator VkDrmFormatModifierPropertiesEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDrmFormatModifierPropertiesEXT *>( this );
    }

    operator VkDrmFormatModifierPropertiesEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDrmFormatModifierPropertiesEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint64_t const &, uint32_t const &, VULKAN_HPP_NAMESPACE::FormatFeatureFlags const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( drmFormatModifier, drmFormatModifierPlaneCount, drmFormatModifierTilingFeatures );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DrmFormatModifierPropertiesEXT const & ) const = default;
#else
    bool operator==( DrmFormatModifierPropertiesEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( drmFormatModifier == rhs.drmFormatModifier ) && ( drmFormatModifierPlaneCount == rhs.drmFormatModifierPlaneCount ) &&
             ( drmFormatModifierTilingFeatures == rhs.drmFormatModifierTilingFeatures );
#  endif
    }

    bool operator!=( DrmFormatModifierPropertiesEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint64_t                                 drmFormatModifier               = {};
    uint32_t                                 drmFormatModifierPlaneCount     = {};
    VULKAN_HPP_NAMESPACE::FormatFeatureFlags drmFormatModifierTilingFeatures = {};
  };

  struct DrmFormatModifierPropertiesList2EXT
  {
    using NativeType = VkDrmFormatModifierPropertiesList2EXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDrmFormatModifierPropertiesList2EXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DrmFormatModifierPropertiesList2EXT( uint32_t                                                drmFormatModifierCount_       = {},
                                                              VULKAN_HPP_NAMESPACE::DrmFormatModifierProperties2EXT * pDrmFormatModifierProperties_ = {},
                                                              void *                                                  pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , drmFormatModifierCount{ drmFormatModifierCount_ }
      , pDrmFormatModifierProperties{ pDrmFormatModifierProperties_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DrmFormatModifierPropertiesList2EXT( DrmFormatModifierPropertiesList2EXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DrmFormatModifierPropertiesList2EXT( VkDrmFormatModifierPropertiesList2EXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : DrmFormatModifierPropertiesList2EXT( *reinterpret_cast<DrmFormatModifierPropertiesList2EXT const *>( &rhs ) )
    {
    }

    DrmFormatModifierPropertiesList2EXT & operator=( DrmFormatModifierPropertiesList2EXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DrmFormatModifierPropertiesList2EXT & operator=( VkDrmFormatModifierPropertiesList2EXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DrmFormatModifierPropertiesList2EXT const *>( &rhs );
      return *this;
    }

    operator VkDrmFormatModifierPropertiesList2EXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDrmFormatModifierPropertiesList2EXT *>( this );
    }

    operator VkDrmFormatModifierPropertiesList2EXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDrmFormatModifierPropertiesList2EXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, void * const &, uint32_t const &, VULKAN_HPP_NAMESPACE::DrmFormatModifierProperties2EXT * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, drmFormatModifierCount, pDrmFormatModifierProperties );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DrmFormatModifierPropertiesList2EXT const & ) const = default;
#else
    bool operator==( DrmFormatModifierPropertiesList2EXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( drmFormatModifierCount == rhs.drmFormatModifierCount ) &&
             ( pDrmFormatModifierProperties == rhs.pDrmFormatModifierProperties );
#  endif
    }

    bool operator!=( DrmFormatModifierPropertiesList2EXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                     sType                        = StructureType::eDrmFormatModifierPropertiesList2EXT;
    void *                                                  pNext                        = {};
    uint32_t                                                drmFormatModifierCount       = {};
    VULKAN_HPP_NAMESPACE::DrmFormatModifierProperties2EXT * pDrmFormatModifierProperties = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eDrmFormatModifierPropertiesList2EXT>
  {
    using Type = DrmFormatModifierPropertiesList2EXT;
  };

  struct DrmFormatModifierPropertiesListEXT
  {
    using NativeType = VkDrmFormatModifierPropertiesListEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDrmFormatModifierPropertiesListEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DrmFormatModifierPropertiesListEXT( uint32_t                                               drmFormatModifierCount_       = {},
                                                             VULKAN_HPP_NAMESPACE::DrmFormatModifierPropertiesEXT * pDrmFormatModifierProperties_ = {},
                                                             void *                                                 pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , drmFormatModifierCount{ drmFormatModifierCount_ }
      , pDrmFormatModifierProperties{ pDrmFormatModifierProperties_ }
    {
    }

    VULKAN_HPP_CONSTEXPR DrmFormatModifierPropertiesListEXT( DrmFormatModifierPropertiesListEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DrmFormatModifierPropertiesListEXT( VkDrmFormatModifierPropertiesListEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : DrmFormatModifierPropertiesListEXT( *reinterpret_cast<DrmFormatModifierPropertiesListEXT const *>( &rhs ) )
    {
    }

    DrmFormatModifierPropertiesListEXT & operator=( DrmFormatModifierPropertiesListEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DrmFormatModifierPropertiesListEXT & operator=( VkDrmFormatModifierPropertiesListEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DrmFormatModifierPropertiesListEXT const *>( &rhs );
      return *this;
    }

    operator VkDrmFormatModifierPropertiesListEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDrmFormatModifierPropertiesListEXT *>( this );
    }

    operator VkDrmFormatModifierPropertiesListEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDrmFormatModifierPropertiesListEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, void * const &, uint32_t const &, VULKAN_HPP_NAMESPACE::DrmFormatModifierPropertiesEXT * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, drmFormatModifierCount, pDrmFormatModifierProperties );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DrmFormatModifierPropertiesListEXT const & ) const = default;
#else
    bool operator==( DrmFormatModifierPropertiesListEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( drmFormatModifierCount == rhs.drmFormatModifierCount ) &&
             ( pDrmFormatModifierProperties == rhs.pDrmFormatModifierProperties );
#  endif
    }

    bool operator!=( DrmFormatModifierPropertiesListEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                    sType                        = StructureType::eDrmFormatModifierPropertiesListEXT;
    void *                                                 pNext                        = {};
    uint32_t                                               drmFormatModifierCount       = {};
    VULKAN_HPP_NAMESPACE::DrmFormatModifierPropertiesEXT * pDrmFormatModifierProperties = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eDrmFormatModifierPropertiesListEXT>
  {
    using Type = DrmFormatModifierPropertiesListEXT;
  };

  struct EventCreateInfo
  {
    using NativeType = VkEventCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eEventCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR EventCreateInfo( VULKAN_HPP_NAMESPACE::EventCreateFlags flags_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
    {
    }

    VULKAN_HPP_CONSTEXPR EventCreateInfo( EventCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    EventCreateInfo( VkEventCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT : EventCreateInfo( *reinterpret_cast<EventCreateInfo const *>( &rhs ) ) {}

    EventCreateInfo & operator=( EventCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    EventCreateInfo & operator=( VkEventCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::EventCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 EventCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 EventCreateInfo & setFlags( VULKAN_HPP_NAMESPACE::EventCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkEventCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkEventCreateInfo *>( this );
    }

    operator VkEventCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkEventCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::EventCreateFlags const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( EventCreateInfo const & ) const = default;
#else
    bool operator==( EventCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags );
#  endif
    }

    bool operator!=( EventCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType    sType = StructureType::eEventCreateInfo;
    const void *                           pNext = {};
    VULKAN_HPP_NAMESPACE::EventCreateFlags flags = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eEventCreateInfo>
  {
    using Type = EventCreateInfo;
  };

  struct ExportFenceCreateInfo
  {
    using NativeType = VkExportFenceCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eExportFenceCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ExportFenceCreateInfo( VULKAN_HPP_NAMESPACE::ExternalFenceHandleTypeFlags handleTypes_ = {},
                                                const void *                                       pNext_       = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , handleTypes{ handleTypes_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ExportFenceCreateInfo( ExportFenceCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ExportFenceCreateInfo( VkExportFenceCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : ExportFenceCreateInfo( *reinterpret_cast<ExportFenceCreateInfo const *>( &rhs ) )
    {
    }

    ExportFenceCreateInfo & operator=( ExportFenceCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ExportFenceCreateInfo & operator=( VkExportFenceCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ExportFenceCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ExportFenceCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ExportFenceCreateInfo & setHandleTypes( VULKAN_HPP_NAMESPACE::ExternalFenceHandleTypeFlags handleTypes_ ) VULKAN_HPP_NOEXCEPT
    {
      handleTypes = handleTypes_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkExportFenceCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkExportFenceCreateInfo *>( this );
    }

    operator VkExportFenceCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkExportFenceCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::ExternalFenceHandleTypeFlags const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, handleTypes );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ExportFenceCreateInfo const & ) const = default;
#else
    bool operator==( ExportFenceCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( handleTypes == rhs.handleTypes );
#  endif
    }

    bool operator!=( ExportFenceCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                sType       = StructureType::eExportFenceCreateInfo;
    const void *                                       pNext       = {};
    VULKAN_HPP_NAMESPACE::ExternalFenceHandleTypeFlags handleTypes = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eExportFenceCreateInfo>
  {
    using Type = ExportFenceCreateInfo;
  };

  using ExportFenceCreateInfoKHR = ExportFenceCreateInfo;

#if defined( VK_USE_PLATFORM_SCI )
  struct ExportFenceSciSyncInfoNV
  {
    using NativeType = VkExportFenceSciSyncInfoNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eExportFenceSciSyncInfoNV;

#  if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ExportFenceSciSyncInfoNV( NvSciSyncAttrList pAttributes_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , pAttributes{ pAttributes_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ExportFenceSciSyncInfoNV( ExportFenceSciSyncInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ExportFenceSciSyncInfoNV( VkExportFenceSciSyncInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : ExportFenceSciSyncInfoNV( *reinterpret_cast<ExportFenceSciSyncInfoNV const *>( &rhs ) )
    {
    }

    ExportFenceSciSyncInfoNV & operator=( ExportFenceSciSyncInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#  endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ExportFenceSciSyncInfoNV & operator=( VkExportFenceSciSyncInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ExportFenceSciSyncInfoNV const *>( &rhs );
      return *this;
    }

#  if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ExportFenceSciSyncInfoNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ExportFenceSciSyncInfoNV & setPAttributes( NvSciSyncAttrList pAttributes_ ) VULKAN_HPP_NOEXCEPT
    {
      pAttributes = pAttributes_;
      return *this;
    }
#  endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkExportFenceSciSyncInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkExportFenceSciSyncInfoNV *>( this );
    }

    operator VkExportFenceSciSyncInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkExportFenceSciSyncInfoNV *>( this );
    }

#  if defined( VULKAN_HPP_USE_REFLECT )
#    if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#    else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, NvSciSyncAttrList const &>
#    endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, pAttributes );
    }
#  endif

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    std::strong_ordering operator<=>( ExportFenceSciSyncInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      if ( auto cmp = sType <=> rhs.sType; cmp != 0 )
        return cmp;
      if ( auto cmp = pNext <=> rhs.pNext; cmp != 0 )
        return cmp;
      if ( auto cmp = memcmp( &pAttributes, &rhs.pAttributes, sizeof( NvSciSyncAttrList ) ); cmp != 0 )
        return ( cmp < 0 ) ? std::strong_ordering::less : std::strong_ordering::greater;

      return std::strong_ordering::equivalent;
    }
#  endif

    bool operator==( ExportFenceSciSyncInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( memcmp( &pAttributes, &rhs.pAttributes, sizeof( NvSciSyncAttrList ) ) == 0 );
    }

    bool operator!=( ExportFenceSciSyncInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType       = StructureType::eExportFenceSciSyncInfoNV;
    const void *                        pNext       = {};
    NvSciSyncAttrList                   pAttributes = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eExportFenceSciSyncInfoNV>
  {
    using Type = ExportFenceSciSyncInfoNV;
  };
#endif /*VK_USE_PLATFORM_SCI*/

  struct ExportMemoryAllocateInfo
  {
    using NativeType = VkExportMemoryAllocateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eExportMemoryAllocateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ExportMemoryAllocateInfo( VULKAN_HPP_NAMESPACE::ExternalMemoryHandleTypeFlags handleTypes_ = {},
                                                   const void *                                        pNext_       = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , handleTypes{ handleTypes_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ExportMemoryAllocateInfo( ExportMemoryAllocateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ExportMemoryAllocateInfo( VkExportMemoryAllocateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : ExportMemoryAllocateInfo( *reinterpret_cast<ExportMemoryAllocateInfo const *>( &rhs ) )
    {
    }

    ExportMemoryAllocateInfo & operator=( ExportMemoryAllocateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ExportMemoryAllocateInfo & operator=( VkExportMemoryAllocateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ExportMemoryAllocateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ExportMemoryAllocateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ExportMemoryAllocateInfo & setHandleTypes( VULKAN_HPP_NAMESPACE::ExternalMemoryHandleTypeFlags handleTypes_ ) VULKAN_HPP_NOEXCEPT
    {
      handleTypes = handleTypes_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkExportMemoryAllocateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkExportMemoryAllocateInfo *>( this );
    }

    operator VkExportMemoryAllocateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkExportMemoryAllocateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::ExternalMemoryHandleTypeFlags const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, handleTypes );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ExportMemoryAllocateInfo const & ) const = default;
#else
    bool operator==( ExportMemoryAllocateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( handleTypes == rhs.handleTypes );
#  endif
    }

    bool operator!=( ExportMemoryAllocateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                 sType       = StructureType::eExportMemoryAllocateInfo;
    const void *                                        pNext       = {};
    VULKAN_HPP_NAMESPACE::ExternalMemoryHandleTypeFlags handleTypes = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eExportMemoryAllocateInfo>
  {
    using Type = ExportMemoryAllocateInfo;
  };

  using ExportMemoryAllocateInfoKHR = ExportMemoryAllocateInfo;

#if defined( VK_USE_PLATFORM_SCI )
  struct ExportMemorySciBufInfoNV
  {
    using NativeType = VkExportMemorySciBufInfoNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eExportMemorySciBufInfoNV;

#  if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ExportMemorySciBufInfoNV( NvSciBufAttrList pAttributes_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , pAttributes{ pAttributes_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ExportMemorySciBufInfoNV( ExportMemorySciBufInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ExportMemorySciBufInfoNV( VkExportMemorySciBufInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : ExportMemorySciBufInfoNV( *reinterpret_cast<ExportMemorySciBufInfoNV const *>( &rhs ) )
    {
    }

    ExportMemorySciBufInfoNV & operator=( ExportMemorySciBufInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#  endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ExportMemorySciBufInfoNV & operator=( VkExportMemorySciBufInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ExportMemorySciBufInfoNV const *>( &rhs );
      return *this;
    }

#  if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ExportMemorySciBufInfoNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ExportMemorySciBufInfoNV & setPAttributes( NvSciBufAttrList pAttributes_ ) VULKAN_HPP_NOEXCEPT
    {
      pAttributes = pAttributes_;
      return *this;
    }
#  endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkExportMemorySciBufInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkExportMemorySciBufInfoNV *>( this );
    }

    operator VkExportMemorySciBufInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkExportMemorySciBufInfoNV *>( this );
    }

#  if defined( VULKAN_HPP_USE_REFLECT )
#    if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#    else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, NvSciBufAttrList const &>
#    endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, pAttributes );
    }
#  endif

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    std::strong_ordering operator<=>( ExportMemorySciBufInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      if ( auto cmp = sType <=> rhs.sType; cmp != 0 )
        return cmp;
      if ( auto cmp = pNext <=> rhs.pNext; cmp != 0 )
        return cmp;
      if ( auto cmp = memcmp( &pAttributes, &rhs.pAttributes, sizeof( NvSciBufAttrList ) ); cmp != 0 )
        return ( cmp < 0 ) ? std::strong_ordering::less : std::strong_ordering::greater;

      return std::strong_ordering::equivalent;
    }
#  endif

    bool operator==( ExportMemorySciBufInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( memcmp( &pAttributes, &rhs.pAttributes, sizeof( NvSciBufAttrList ) ) == 0 );
    }

    bool operator!=( ExportMemorySciBufInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType       = StructureType::eExportMemorySciBufInfoNV;
    const void *                        pNext       = {};
    NvSciBufAttrList                    pAttributes = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eExportMemorySciBufInfoNV>
  {
    using Type = ExportMemorySciBufInfoNV;
  };
#endif /*VK_USE_PLATFORM_SCI*/

  struct ExportSemaphoreCreateInfo
  {
    using NativeType = VkExportSemaphoreCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eExportSemaphoreCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ExportSemaphoreCreateInfo( VULKAN_HPP_NAMESPACE::ExternalSemaphoreHandleTypeFlags handleTypes_ = {},
                                                    const void *                                           pNext_       = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , handleTypes{ handleTypes_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ExportSemaphoreCreateInfo( ExportSemaphoreCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ExportSemaphoreCreateInfo( VkExportSemaphoreCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : ExportSemaphoreCreateInfo( *reinterpret_cast<ExportSemaphoreCreateInfo const *>( &rhs ) )
    {
    }

    ExportSemaphoreCreateInfo & operator=( ExportSemaphoreCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ExportSemaphoreCreateInfo & operator=( VkExportSemaphoreCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ExportSemaphoreCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ExportSemaphoreCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ExportSemaphoreCreateInfo &
      setHandleTypes( VULKAN_HPP_NAMESPACE::ExternalSemaphoreHandleTypeFlags handleTypes_ ) VULKAN_HPP_NOEXCEPT
    {
      handleTypes = handleTypes_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkExportSemaphoreCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkExportSemaphoreCreateInfo *>( this );
    }

    operator VkExportSemaphoreCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkExportSemaphoreCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::ExternalSemaphoreHandleTypeFlags const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, handleTypes );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ExportSemaphoreCreateInfo const & ) const = default;
#else
    bool operator==( ExportSemaphoreCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( handleTypes == rhs.handleTypes );
#  endif
    }

    bool operator!=( ExportSemaphoreCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                    sType       = StructureType::eExportSemaphoreCreateInfo;
    const void *                                           pNext       = {};
    VULKAN_HPP_NAMESPACE::ExternalSemaphoreHandleTypeFlags handleTypes = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eExportSemaphoreCreateInfo>
  {
    using Type = ExportSemaphoreCreateInfo;
  };

  using ExportSemaphoreCreateInfoKHR = ExportSemaphoreCreateInfo;

#if defined( VK_USE_PLATFORM_SCI )
  struct ExportSemaphoreSciSyncInfoNV
  {
    using NativeType = VkExportSemaphoreSciSyncInfoNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eExportSemaphoreSciSyncInfoNV;

#  if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ExportSemaphoreSciSyncInfoNV( NvSciSyncAttrList pAttributes_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , pAttributes{ pAttributes_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ExportSemaphoreSciSyncInfoNV( ExportSemaphoreSciSyncInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ExportSemaphoreSciSyncInfoNV( VkExportSemaphoreSciSyncInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : ExportSemaphoreSciSyncInfoNV( *reinterpret_cast<ExportSemaphoreSciSyncInfoNV const *>( &rhs ) )
    {
    }

    ExportSemaphoreSciSyncInfoNV & operator=( ExportSemaphoreSciSyncInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#  endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ExportSemaphoreSciSyncInfoNV & operator=( VkExportSemaphoreSciSyncInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ExportSemaphoreSciSyncInfoNV const *>( &rhs );
      return *this;
    }

#  if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ExportSemaphoreSciSyncInfoNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ExportSemaphoreSciSyncInfoNV & setPAttributes( NvSciSyncAttrList pAttributes_ ) VULKAN_HPP_NOEXCEPT
    {
      pAttributes = pAttributes_;
      return *this;
    }
#  endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkExportSemaphoreSciSyncInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkExportSemaphoreSciSyncInfoNV *>( this );
    }

    operator VkExportSemaphoreSciSyncInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkExportSemaphoreSciSyncInfoNV *>( this );
    }

#  if defined( VULKAN_HPP_USE_REFLECT )
#    if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#    else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, NvSciSyncAttrList const &>
#    endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, pAttributes );
    }
#  endif

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    std::strong_ordering operator<=>( ExportSemaphoreSciSyncInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      if ( auto cmp = sType <=> rhs.sType; cmp != 0 )
        return cmp;
      if ( auto cmp = pNext <=> rhs.pNext; cmp != 0 )
        return cmp;
      if ( auto cmp = memcmp( &pAttributes, &rhs.pAttributes, sizeof( NvSciSyncAttrList ) ); cmp != 0 )
        return ( cmp < 0 ) ? std::strong_ordering::less : std::strong_ordering::greater;

      return std::strong_ordering::equivalent;
    }
#  endif

    bool operator==( ExportSemaphoreSciSyncInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( memcmp( &pAttributes, &rhs.pAttributes, sizeof( NvSciSyncAttrList ) ) == 0 );
    }

    bool operator!=( ExportSemaphoreSciSyncInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType       = StructureType::eExportSemaphoreSciSyncInfoNV;
    const void *                        pNext       = {};
    NvSciSyncAttrList                   pAttributes = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eExportSemaphoreSciSyncInfoNV>
  {
    using Type = ExportSemaphoreSciSyncInfoNV;
  };
#endif /*VK_USE_PLATFORM_SCI*/

  struct ExtensionProperties
  {
    using NativeType = VkExtensionProperties;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 ExtensionProperties( std::array<char, VK_MAX_EXTENSION_NAME_SIZE> const & extensionName_ = {},
                                                 uint32_t                                             specVersion_   = {} ) VULKAN_HPP_NOEXCEPT
      : extensionName{ extensionName_ }
      , specVersion{ specVersion_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14 ExtensionProperties( ExtensionProperties const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ExtensionProperties( VkExtensionProperties const & rhs ) VULKAN_HPP_NOEXCEPT : ExtensionProperties( *reinterpret_cast<ExtensionProperties const *>( &rhs ) )
    {
    }

    ExtensionProperties & operator=( ExtensionProperties const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ExtensionProperties & operator=( VkExtensionProperties const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ExtensionProperties const *>( &rhs );
      return *this;
    }

    operator VkExtensionProperties const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkExtensionProperties *>( this );
    }

    operator VkExtensionProperties &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkExtensionProperties *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::ArrayWrapper1D<char, VK_MAX_EXTENSION_NAME_SIZE> const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( extensionName, specVersion );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    std::strong_ordering operator<=>( ExtensionProperties const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      if ( auto cmp = strcmp( extensionName, rhs.extensionName ); cmp != 0 )
        return ( cmp < 0 ) ? std::strong_ordering::less : std::strong_ordering::greater;
      if ( auto cmp = specVersion <=> rhs.specVersion; cmp != 0 )
        return cmp;

      return std::strong_ordering::equivalent;
    }
#endif

    bool operator==( ExtensionProperties const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( strcmp( extensionName, rhs.extensionName ) == 0 ) && ( specVersion == rhs.specVersion );
    }

    bool operator!=( ExtensionProperties const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }

  public:
    VULKAN_HPP_NAMESPACE::ArrayWrapper1D<char, VK_MAX_EXTENSION_NAME_SIZE> extensionName = {};
    uint32_t                                                               specVersion   = {};
  };

  struct ExternalMemoryProperties
  {
    using NativeType = VkExternalMemoryProperties;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ExternalMemoryProperties( VULKAN_HPP_NAMESPACE::ExternalMemoryFeatureFlags    externalMemoryFeatures_        = {},
                                                   VULKAN_HPP_NAMESPACE::ExternalMemoryHandleTypeFlags exportFromImportedHandleTypes_ = {},
                                                   VULKAN_HPP_NAMESPACE::ExternalMemoryHandleTypeFlags compatibleHandleTypes_         = {} ) VULKAN_HPP_NOEXCEPT
      : externalMemoryFeatures{ externalMemoryFeatures_ }
      , exportFromImportedHandleTypes{ exportFromImportedHandleTypes_ }
      , compatibleHandleTypes{ compatibleHandleTypes_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ExternalMemoryProperties( ExternalMemoryProperties const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ExternalMemoryProperties( VkExternalMemoryProperties const & rhs ) VULKAN_HPP_NOEXCEPT
      : ExternalMemoryProperties( *reinterpret_cast<ExternalMemoryProperties const *>( &rhs ) )
    {
    }

    ExternalMemoryProperties & operator=( ExternalMemoryProperties const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ExternalMemoryProperties & operator=( VkExternalMemoryProperties const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ExternalMemoryProperties const *>( &rhs );
      return *this;
    }

    operator VkExternalMemoryProperties const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkExternalMemoryProperties *>( this );
    }

    operator VkExternalMemoryProperties &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkExternalMemoryProperties *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::ExternalMemoryFeatureFlags const &,
               VULKAN_HPP_NAMESPACE::ExternalMemoryHandleTypeFlags const &,
               VULKAN_HPP_NAMESPACE::ExternalMemoryHandleTypeFlags const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( externalMemoryFeatures, exportFromImportedHandleTypes, compatibleHandleTypes );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ExternalMemoryProperties const & ) const = default;
#else
    bool operator==( ExternalMemoryProperties const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( externalMemoryFeatures == rhs.externalMemoryFeatures ) && ( exportFromImportedHandleTypes == rhs.exportFromImportedHandleTypes ) &&
             ( compatibleHandleTypes == rhs.compatibleHandleTypes );
#  endif
    }

    bool operator!=( ExternalMemoryProperties const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::ExternalMemoryFeatureFlags    externalMemoryFeatures        = {};
    VULKAN_HPP_NAMESPACE::ExternalMemoryHandleTypeFlags exportFromImportedHandleTypes = {};
    VULKAN_HPP_NAMESPACE::ExternalMemoryHandleTypeFlags compatibleHandleTypes         = {};
  };

  using ExternalMemoryPropertiesKHR = ExternalMemoryProperties;

  struct ExternalBufferProperties
  {
    using NativeType = VkExternalBufferProperties;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eExternalBufferProperties;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ExternalBufferProperties( VULKAN_HPP_NAMESPACE::ExternalMemoryProperties externalMemoryProperties_ = {},
                                                   void *                                         pNext_                    = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , externalMemoryProperties{ externalMemoryProperties_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ExternalBufferProperties( ExternalBufferProperties const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ExternalBufferProperties( VkExternalBufferProperties const & rhs ) VULKAN_HPP_NOEXCEPT
      : ExternalBufferProperties( *reinterpret_cast<ExternalBufferProperties const *>( &rhs ) )
    {
    }

    ExternalBufferProperties & operator=( ExternalBufferProperties const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ExternalBufferProperties & operator=( VkExternalBufferProperties const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ExternalBufferProperties const *>( &rhs );
      return *this;
    }

    operator VkExternalBufferProperties const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkExternalBufferProperties *>( this );
    }

    operator VkExternalBufferProperties &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkExternalBufferProperties *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, void * const &, VULKAN_HPP_NAMESPACE::ExternalMemoryProperties const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, externalMemoryProperties );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ExternalBufferProperties const & ) const = default;
#else
    bool operator==( ExternalBufferProperties const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( externalMemoryProperties == rhs.externalMemoryProperties );
#  endif
    }

    bool operator!=( ExternalBufferProperties const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType            sType                    = StructureType::eExternalBufferProperties;
    void *                                         pNext                    = {};
    VULKAN_HPP_NAMESPACE::ExternalMemoryProperties externalMemoryProperties = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eExternalBufferProperties>
  {
    using Type = ExternalBufferProperties;
  };

  using ExternalBufferPropertiesKHR = ExternalBufferProperties;

  struct ExternalFenceProperties
  {
    using NativeType = VkExternalFenceProperties;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eExternalFenceProperties;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ExternalFenceProperties( VULKAN_HPP_NAMESPACE::ExternalFenceHandleTypeFlags exportFromImportedHandleTypes_ = {},
                                                  VULKAN_HPP_NAMESPACE::ExternalFenceHandleTypeFlags compatibleHandleTypes_         = {},
                                                  VULKAN_HPP_NAMESPACE::ExternalFenceFeatureFlags    externalFenceFeatures_         = {},
                                                  void *                                             pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , exportFromImportedHandleTypes{ exportFromImportedHandleTypes_ }
      , compatibleHandleTypes{ compatibleHandleTypes_ }
      , externalFenceFeatures{ externalFenceFeatures_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ExternalFenceProperties( ExternalFenceProperties const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ExternalFenceProperties( VkExternalFenceProperties const & rhs ) VULKAN_HPP_NOEXCEPT
      : ExternalFenceProperties( *reinterpret_cast<ExternalFenceProperties const *>( &rhs ) )
    {
    }

    ExternalFenceProperties & operator=( ExternalFenceProperties const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ExternalFenceProperties & operator=( VkExternalFenceProperties const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ExternalFenceProperties const *>( &rhs );
      return *this;
    }

    operator VkExternalFenceProperties const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkExternalFenceProperties *>( this );
    }

    operator VkExternalFenceProperties &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkExternalFenceProperties *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               void * const &,
               VULKAN_HPP_NAMESPACE::ExternalFenceHandleTypeFlags const &,
               VULKAN_HPP_NAMESPACE::ExternalFenceHandleTypeFlags const &,
               VULKAN_HPP_NAMESPACE::ExternalFenceFeatureFlags const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, exportFromImportedHandleTypes, compatibleHandleTypes, externalFenceFeatures );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ExternalFenceProperties const & ) const = default;
#else
    bool operator==( ExternalFenceProperties const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( exportFromImportedHandleTypes == rhs.exportFromImportedHandleTypes ) &&
             ( compatibleHandleTypes == rhs.compatibleHandleTypes ) && ( externalFenceFeatures == rhs.externalFenceFeatures );
#  endif
    }

    bool operator!=( ExternalFenceProperties const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                sType                         = StructureType::eExternalFenceProperties;
    void *                                             pNext                         = {};
    VULKAN_HPP_NAMESPACE::ExternalFenceHandleTypeFlags exportFromImportedHandleTypes = {};
    VULKAN_HPP_NAMESPACE::ExternalFenceHandleTypeFlags compatibleHandleTypes         = {};
    VULKAN_HPP_NAMESPACE::ExternalFenceFeatureFlags    externalFenceFeatures         = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eExternalFenceProperties>
  {
    using Type = ExternalFenceProperties;
  };

  using ExternalFencePropertiesKHR = ExternalFenceProperties;

#if defined( VK_USE_PLATFORM_SCREEN_QNX )
  struct ExternalFormatQNX
  {
    using NativeType = VkExternalFormatQNX;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eExternalFormatQNX;

#  if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ExternalFormatQNX( uint64_t externalFormat_ = {}, void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , externalFormat{ externalFormat_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ExternalFormatQNX( ExternalFormatQNX const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ExternalFormatQNX( VkExternalFormatQNX const & rhs ) VULKAN_HPP_NOEXCEPT : ExternalFormatQNX( *reinterpret_cast<ExternalFormatQNX const *>( &rhs ) ) {}

    ExternalFormatQNX & operator=( ExternalFormatQNX const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#  endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ExternalFormatQNX & operator=( VkExternalFormatQNX const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ExternalFormatQNX const *>( &rhs );
      return *this;
    }

#  if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ExternalFormatQNX & setPNext( void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ExternalFormatQNX & setExternalFormat( uint64_t externalFormat_ ) VULKAN_HPP_NOEXCEPT
    {
      externalFormat = externalFormat_;
      return *this;
    }
#  endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkExternalFormatQNX const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkExternalFormatQNX *>( this );
    }

    operator VkExternalFormatQNX &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkExternalFormatQNX *>( this );
    }

#  if defined( VULKAN_HPP_USE_REFLECT )
#    if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#    else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, void * const &, uint64_t const &>
#    endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, externalFormat );
    }
#  endif

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ExternalFormatQNX const & ) const = default;
#  else
    bool operator==( ExternalFormatQNX const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#    if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#    else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( externalFormat == rhs.externalFormat );
#    endif
    }

    bool operator!=( ExternalFormatQNX const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType          = StructureType::eExternalFormatQNX;
    void *                              pNext          = {};
    uint64_t                            externalFormat = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eExternalFormatQNX>
  {
    using Type = ExternalFormatQNX;
  };
#endif /*VK_USE_PLATFORM_SCREEN_QNX*/

  struct ExternalImageFormatProperties
  {
    using NativeType = VkExternalImageFormatProperties;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eExternalImageFormatProperties;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ExternalImageFormatProperties( VULKAN_HPP_NAMESPACE::ExternalMemoryProperties externalMemoryProperties_ = {},
                                                        void *                                         pNext_                    = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , externalMemoryProperties{ externalMemoryProperties_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ExternalImageFormatProperties( ExternalImageFormatProperties const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ExternalImageFormatProperties( VkExternalImageFormatProperties const & rhs ) VULKAN_HPP_NOEXCEPT
      : ExternalImageFormatProperties( *reinterpret_cast<ExternalImageFormatProperties const *>( &rhs ) )
    {
    }

    ExternalImageFormatProperties & operator=( ExternalImageFormatProperties const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ExternalImageFormatProperties & operator=( VkExternalImageFormatProperties const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ExternalImageFormatProperties const *>( &rhs );
      return *this;
    }

    operator VkExternalImageFormatProperties const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkExternalImageFormatProperties *>( this );
    }

    operator VkExternalImageFormatProperties &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkExternalImageFormatProperties *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, void * const &, VULKAN_HPP_NAMESPACE::ExternalMemoryProperties const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, externalMemoryProperties );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ExternalImageFormatProperties const & ) const = default;
#else
    bool operator==( ExternalImageFormatProperties const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( externalMemoryProperties == rhs.externalMemoryProperties );
#  endif
    }

    bool operator!=( ExternalImageFormatProperties const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType            sType                    = StructureType::eExternalImageFormatProperties;
    void *                                         pNext                    = {};
    VULKAN_HPP_NAMESPACE::ExternalMemoryProperties externalMemoryProperties = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eExternalImageFormatProperties>
  {
    using Type = ExternalImageFormatProperties;
  };

  using ExternalImageFormatPropertiesKHR = ExternalImageFormatProperties;

  struct ExternalMemoryBufferCreateInfo
  {
    using NativeType = VkExternalMemoryBufferCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eExternalMemoryBufferCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ExternalMemoryBufferCreateInfo( VULKAN_HPP_NAMESPACE::ExternalMemoryHandleTypeFlags handleTypes_ = {},
                                                         const void *                                        pNext_       = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , handleTypes{ handleTypes_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ExternalMemoryBufferCreateInfo( ExternalMemoryBufferCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ExternalMemoryBufferCreateInfo( VkExternalMemoryBufferCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : ExternalMemoryBufferCreateInfo( *reinterpret_cast<ExternalMemoryBufferCreateInfo const *>( &rhs ) )
    {
    }

    ExternalMemoryBufferCreateInfo & operator=( ExternalMemoryBufferCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ExternalMemoryBufferCreateInfo & operator=( VkExternalMemoryBufferCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ExternalMemoryBufferCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ExternalMemoryBufferCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ExternalMemoryBufferCreateInfo &
      setHandleTypes( VULKAN_HPP_NAMESPACE::ExternalMemoryHandleTypeFlags handleTypes_ ) VULKAN_HPP_NOEXCEPT
    {
      handleTypes = handleTypes_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkExternalMemoryBufferCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkExternalMemoryBufferCreateInfo *>( this );
    }

    operator VkExternalMemoryBufferCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkExternalMemoryBufferCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::ExternalMemoryHandleTypeFlags const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, handleTypes );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ExternalMemoryBufferCreateInfo const & ) const = default;
#else
    bool operator==( ExternalMemoryBufferCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( handleTypes == rhs.handleTypes );
#  endif
    }

    bool operator!=( ExternalMemoryBufferCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                 sType       = StructureType::eExternalMemoryBufferCreateInfo;
    const void *                                        pNext       = {};
    VULKAN_HPP_NAMESPACE::ExternalMemoryHandleTypeFlags handleTypes = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eExternalMemoryBufferCreateInfo>
  {
    using Type = ExternalMemoryBufferCreateInfo;
  };

  using ExternalMemoryBufferCreateInfoKHR = ExternalMemoryBufferCreateInfo;

  struct ExternalMemoryImageCreateInfo
  {
    using NativeType = VkExternalMemoryImageCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eExternalMemoryImageCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ExternalMemoryImageCreateInfo( VULKAN_HPP_NAMESPACE::ExternalMemoryHandleTypeFlags handleTypes_ = {},
                                                        const void *                                        pNext_       = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , handleTypes{ handleTypes_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ExternalMemoryImageCreateInfo( ExternalMemoryImageCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ExternalMemoryImageCreateInfo( VkExternalMemoryImageCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : ExternalMemoryImageCreateInfo( *reinterpret_cast<ExternalMemoryImageCreateInfo const *>( &rhs ) )
    {
    }

    ExternalMemoryImageCreateInfo & operator=( ExternalMemoryImageCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ExternalMemoryImageCreateInfo & operator=( VkExternalMemoryImageCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ExternalMemoryImageCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ExternalMemoryImageCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ExternalMemoryImageCreateInfo &
      setHandleTypes( VULKAN_HPP_NAMESPACE::ExternalMemoryHandleTypeFlags handleTypes_ ) VULKAN_HPP_NOEXCEPT
    {
      handleTypes = handleTypes_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkExternalMemoryImageCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkExternalMemoryImageCreateInfo *>( this );
    }

    operator VkExternalMemoryImageCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkExternalMemoryImageCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::ExternalMemoryHandleTypeFlags const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, handleTypes );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ExternalMemoryImageCreateInfo const & ) const = default;
#else
    bool operator==( ExternalMemoryImageCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( handleTypes == rhs.handleTypes );
#  endif
    }

    bool operator!=( ExternalMemoryImageCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                 sType       = StructureType::eExternalMemoryImageCreateInfo;
    const void *                                        pNext       = {};
    VULKAN_HPP_NAMESPACE::ExternalMemoryHandleTypeFlags handleTypes = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eExternalMemoryImageCreateInfo>
  {
    using Type = ExternalMemoryImageCreateInfo;
  };

  using ExternalMemoryImageCreateInfoKHR = ExternalMemoryImageCreateInfo;

  struct ExternalSemaphoreProperties
  {
    using NativeType = VkExternalSemaphoreProperties;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eExternalSemaphoreProperties;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ExternalSemaphoreProperties( VULKAN_HPP_NAMESPACE::ExternalSemaphoreHandleTypeFlags exportFromImportedHandleTypes_ = {},
                                                      VULKAN_HPP_NAMESPACE::ExternalSemaphoreHandleTypeFlags compatibleHandleTypes_         = {},
                                                      VULKAN_HPP_NAMESPACE::ExternalSemaphoreFeatureFlags    externalSemaphoreFeatures_     = {},
                                                      void *                                                 pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , exportFromImportedHandleTypes{ exportFromImportedHandleTypes_ }
      , compatibleHandleTypes{ compatibleHandleTypes_ }
      , externalSemaphoreFeatures{ externalSemaphoreFeatures_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ExternalSemaphoreProperties( ExternalSemaphoreProperties const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ExternalSemaphoreProperties( VkExternalSemaphoreProperties const & rhs ) VULKAN_HPP_NOEXCEPT
      : ExternalSemaphoreProperties( *reinterpret_cast<ExternalSemaphoreProperties const *>( &rhs ) )
    {
    }

    ExternalSemaphoreProperties & operator=( ExternalSemaphoreProperties const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ExternalSemaphoreProperties & operator=( VkExternalSemaphoreProperties const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ExternalSemaphoreProperties const *>( &rhs );
      return *this;
    }

    operator VkExternalSemaphoreProperties const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkExternalSemaphoreProperties *>( this );
    }

    operator VkExternalSemaphoreProperties &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkExternalSemaphoreProperties *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               void * const &,
               VULKAN_HPP_NAMESPACE::ExternalSemaphoreHandleTypeFlags const &,
               VULKAN_HPP_NAMESPACE::ExternalSemaphoreHandleTypeFlags const &,
               VULKAN_HPP_NAMESPACE::ExternalSemaphoreFeatureFlags const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, exportFromImportedHandleTypes, compatibleHandleTypes, externalSemaphoreFeatures );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ExternalSemaphoreProperties const & ) const = default;
#else
    bool operator==( ExternalSemaphoreProperties const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( exportFromImportedHandleTypes == rhs.exportFromImportedHandleTypes ) &&
             ( compatibleHandleTypes == rhs.compatibleHandleTypes ) && ( externalSemaphoreFeatures == rhs.externalSemaphoreFeatures );
#  endif
    }

    bool operator!=( ExternalSemaphoreProperties const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                    sType                         = StructureType::eExternalSemaphoreProperties;
    void *                                                 pNext                         = {};
    VULKAN_HPP_NAMESPACE::ExternalSemaphoreHandleTypeFlags exportFromImportedHandleTypes = {};
    VULKAN_HPP_NAMESPACE::ExternalSemaphoreHandleTypeFlags compatibleHandleTypes         = {};
    VULKAN_HPP_NAMESPACE::ExternalSemaphoreFeatureFlags    externalSemaphoreFeatures     = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eExternalSemaphoreProperties>
  {
    using Type = ExternalSemaphoreProperties;
  };

  using ExternalSemaphorePropertiesKHR = ExternalSemaphoreProperties;

  struct FaultData
  {
    using NativeType = VkFaultData;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eFaultData;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR FaultData( VULKAN_HPP_NAMESPACE::FaultLevel faultLevel_ = VULKAN_HPP_NAMESPACE::FaultLevel::eUnassigned,
                                    VULKAN_HPP_NAMESPACE::FaultType  faultType_  = VULKAN_HPP_NAMESPACE::FaultType::eInvalid,
                                    void *                           pNext_      = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , faultLevel{ faultLevel_ }
      , faultType{ faultType_ }
    {
    }

    VULKAN_HPP_CONSTEXPR FaultData( FaultData const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    FaultData( VkFaultData const & rhs ) VULKAN_HPP_NOEXCEPT : FaultData( *reinterpret_cast<FaultData const *>( &rhs ) ) {}

    FaultData & operator=( FaultData const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    FaultData & operator=( VkFaultData const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::FaultData const *>( &rhs );
      return *this;
    }

    operator VkFaultData const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkFaultData *>( this );
    }

    operator VkFaultData &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkFaultData *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, void * const &, VULKAN_HPP_NAMESPACE::FaultLevel const &, VULKAN_HPP_NAMESPACE::FaultType const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, faultLevel, faultType );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( FaultData const & ) const = default;
#else
    bool operator==( FaultData const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( faultLevel == rhs.faultLevel ) && ( faultType == rhs.faultType );
#  endif
    }

    bool operator!=( FaultData const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType      = StructureType::eFaultData;
    void *                              pNext      = {};
    VULKAN_HPP_NAMESPACE::FaultLevel    faultLevel = VULKAN_HPP_NAMESPACE::FaultLevel::eUnassigned;
    VULKAN_HPP_NAMESPACE::FaultType     faultType  = VULKAN_HPP_NAMESPACE::FaultType::eInvalid;
  };

  template <>
  struct CppType<StructureType, StructureType::eFaultData>
  {
    using Type = FaultData;
  };

  struct FaultCallbackInfo
  {
    using NativeType = VkFaultCallbackInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eFaultCallbackInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR FaultCallbackInfo( uint32_t                          faultCount_       = {},
                                            VULKAN_HPP_NAMESPACE::FaultData * pFaults_          = {},
                                            PFN_vkFaultCallbackFunction       pfnFaultCallback_ = {},
                                            const void *                      pNext_            = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , faultCount{ faultCount_ }
      , pFaults{ pFaults_ }
      , pfnFaultCallback{ pfnFaultCallback_ }
    {
    }

    VULKAN_HPP_CONSTEXPR FaultCallbackInfo( FaultCallbackInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    FaultCallbackInfo( VkFaultCallbackInfo const & rhs ) VULKAN_HPP_NOEXCEPT : FaultCallbackInfo( *reinterpret_cast<FaultCallbackInfo const *>( &rhs ) ) {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    FaultCallbackInfo( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<VULKAN_HPP_NAMESPACE::FaultData> const & faults_,
                       PFN_vkFaultCallbackFunction                                                            pfnFaultCallback_ = {},
                       const void *                                                                           pNext_            = nullptr )
      : pNext( pNext_ ), faultCount( static_cast<uint32_t>( faults_.size() ) ), pFaults( faults_.data() ), pfnFaultCallback( pfnFaultCallback_ )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    FaultCallbackInfo & operator=( FaultCallbackInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    FaultCallbackInfo & operator=( VkFaultCallbackInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::FaultCallbackInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 FaultCallbackInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 FaultCallbackInfo & setFaultCount( uint32_t faultCount_ ) VULKAN_HPP_NOEXCEPT
    {
      faultCount = faultCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 FaultCallbackInfo & setPFaults( VULKAN_HPP_NAMESPACE::FaultData * pFaults_ ) VULKAN_HPP_NOEXCEPT
    {
      pFaults = pFaults_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    FaultCallbackInfo & setFaults( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<VULKAN_HPP_NAMESPACE::FaultData> const & faults_ ) VULKAN_HPP_NOEXCEPT
    {
      faultCount = static_cast<uint32_t>( faults_.size() );
      pFaults    = faults_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 FaultCallbackInfo & setPfnFaultCallback( PFN_vkFaultCallbackFunction pfnFaultCallback_ ) VULKAN_HPP_NOEXCEPT
    {
      pfnFaultCallback = pfnFaultCallback_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkFaultCallbackInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkFaultCallbackInfo *>( this );
    }

    operator VkFaultCallbackInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkFaultCallbackInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::FaultData * const &,
               PFN_vkFaultCallbackFunction const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, faultCount, pFaults, pfnFaultCallback );
    }
#endif

    bool operator==( FaultCallbackInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( faultCount == rhs.faultCount ) && ( pFaults == rhs.pFaults ) &&
             ( pfnFaultCallback == rhs.pfnFaultCallback );
#endif
    }

    bool operator!=( FaultCallbackInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType            = StructureType::eFaultCallbackInfo;
    const void *                        pNext            = {};
    uint32_t                            faultCount       = {};
    VULKAN_HPP_NAMESPACE::FaultData *   pFaults          = {};
    PFN_vkFaultCallbackFunction         pfnFaultCallback = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eFaultCallbackInfo>
  {
    using Type = FaultCallbackInfo;
  };

  struct FenceCreateInfo
  {
    using NativeType = VkFenceCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eFenceCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR FenceCreateInfo( VULKAN_HPP_NAMESPACE::FenceCreateFlags flags_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
    {
    }

    VULKAN_HPP_CONSTEXPR FenceCreateInfo( FenceCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    FenceCreateInfo( VkFenceCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT : FenceCreateInfo( *reinterpret_cast<FenceCreateInfo const *>( &rhs ) ) {}

    FenceCreateInfo & operator=( FenceCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    FenceCreateInfo & operator=( VkFenceCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::FenceCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 FenceCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 FenceCreateInfo & setFlags( VULKAN_HPP_NAMESPACE::FenceCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkFenceCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkFenceCreateInfo *>( this );
    }

    operator VkFenceCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkFenceCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::FenceCreateFlags const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( FenceCreateInfo const & ) const = default;
#else
    bool operator==( FenceCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags );
#  endif
    }

    bool operator!=( FenceCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType    sType = StructureType::eFenceCreateInfo;
    const void *                           pNext = {};
    VULKAN_HPP_NAMESPACE::FenceCreateFlags flags = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eFenceCreateInfo>
  {
    using Type = FenceCreateInfo;
  };

  struct FenceGetFdInfoKHR
  {
    using NativeType = VkFenceGetFdInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eFenceGetFdInfoKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      FenceGetFdInfoKHR( VULKAN_HPP_NAMESPACE::Fence                           fence_      = {},
                         VULKAN_HPP_NAMESPACE::ExternalFenceHandleTypeFlagBits handleType_ = VULKAN_HPP_NAMESPACE::ExternalFenceHandleTypeFlagBits::eOpaqueFd,
                         const void *                                          pNext_      = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , fence{ fence_ }
      , handleType{ handleType_ }
    {
    }

    VULKAN_HPP_CONSTEXPR FenceGetFdInfoKHR( FenceGetFdInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    FenceGetFdInfoKHR( VkFenceGetFdInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT : FenceGetFdInfoKHR( *reinterpret_cast<FenceGetFdInfoKHR const *>( &rhs ) ) {}

    FenceGetFdInfoKHR & operator=( FenceGetFdInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    FenceGetFdInfoKHR & operator=( VkFenceGetFdInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::FenceGetFdInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 FenceGetFdInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 FenceGetFdInfoKHR & setFence( VULKAN_HPP_NAMESPACE::Fence fence_ ) VULKAN_HPP_NOEXCEPT
    {
      fence = fence_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 FenceGetFdInfoKHR & setHandleType( VULKAN_HPP_NAMESPACE::ExternalFenceHandleTypeFlagBits handleType_ ) VULKAN_HPP_NOEXCEPT
    {
      handleType = handleType_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkFenceGetFdInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkFenceGetFdInfoKHR *>( this );
    }

    operator VkFenceGetFdInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkFenceGetFdInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::Fence const &,
               VULKAN_HPP_NAMESPACE::ExternalFenceHandleTypeFlagBits const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, fence, handleType );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( FenceGetFdInfoKHR const & ) const = default;
#else
    bool operator==( FenceGetFdInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( fence == rhs.fence ) && ( handleType == rhs.handleType );
#  endif
    }

    bool operator!=( FenceGetFdInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                   sType      = StructureType::eFenceGetFdInfoKHR;
    const void *                                          pNext      = {};
    VULKAN_HPP_NAMESPACE::Fence                           fence      = {};
    VULKAN_HPP_NAMESPACE::ExternalFenceHandleTypeFlagBits handleType = VULKAN_HPP_NAMESPACE::ExternalFenceHandleTypeFlagBits::eOpaqueFd;
  };

  template <>
  struct CppType<StructureType, StructureType::eFenceGetFdInfoKHR>
  {
    using Type = FenceGetFdInfoKHR;
  };

#if defined( VK_USE_PLATFORM_SCI )
  struct FenceGetSciSyncInfoNV
  {
    using NativeType = VkFenceGetSciSyncInfoNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eFenceGetSciSyncInfoNV;

#  if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR FenceGetSciSyncInfoNV(
      VULKAN_HPP_NAMESPACE::Fence                           fence_      = {},
      VULKAN_HPP_NAMESPACE::ExternalFenceHandleTypeFlagBits handleType_ = VULKAN_HPP_NAMESPACE::ExternalFenceHandleTypeFlagBits::eOpaqueFd,
      const void *                                          pNext_      = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , fence{ fence_ }
      , handleType{ handleType_ }
    {
    }

    VULKAN_HPP_CONSTEXPR FenceGetSciSyncInfoNV( FenceGetSciSyncInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    FenceGetSciSyncInfoNV( VkFenceGetSciSyncInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : FenceGetSciSyncInfoNV( *reinterpret_cast<FenceGetSciSyncInfoNV const *>( &rhs ) )
    {
    }

    FenceGetSciSyncInfoNV & operator=( FenceGetSciSyncInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#  endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    FenceGetSciSyncInfoNV & operator=( VkFenceGetSciSyncInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::FenceGetSciSyncInfoNV const *>( &rhs );
      return *this;
    }

#  if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 FenceGetSciSyncInfoNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 FenceGetSciSyncInfoNV & setFence( VULKAN_HPP_NAMESPACE::Fence fence_ ) VULKAN_HPP_NOEXCEPT
    {
      fence = fence_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 FenceGetSciSyncInfoNV & setHandleType( VULKAN_HPP_NAMESPACE::ExternalFenceHandleTypeFlagBits handleType_ ) VULKAN_HPP_NOEXCEPT
    {
      handleType = handleType_;
      return *this;
    }
#  endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkFenceGetSciSyncInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkFenceGetSciSyncInfoNV *>( this );
    }

    operator VkFenceGetSciSyncInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkFenceGetSciSyncInfoNV *>( this );
    }

#  if defined( VULKAN_HPP_USE_REFLECT )
#    if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#    else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::Fence const &,
               VULKAN_HPP_NAMESPACE::ExternalFenceHandleTypeFlagBits const &>
#    endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, fence, handleType );
    }
#  endif

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( FenceGetSciSyncInfoNV const & ) const = default;
#  else
    bool operator==( FenceGetSciSyncInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#    if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#    else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( fence == rhs.fence ) && ( handleType == rhs.handleType );
#    endif
    }

    bool operator!=( FenceGetSciSyncInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                   sType      = StructureType::eFenceGetSciSyncInfoNV;
    const void *                                          pNext      = {};
    VULKAN_HPP_NAMESPACE::Fence                           fence      = {};
    VULKAN_HPP_NAMESPACE::ExternalFenceHandleTypeFlagBits handleType = VULKAN_HPP_NAMESPACE::ExternalFenceHandleTypeFlagBits::eOpaqueFd;
  };

  template <>
  struct CppType<StructureType, StructureType::eFenceGetSciSyncInfoNV>
  {
    using Type = FenceGetSciSyncInfoNV;
  };
#endif /*VK_USE_PLATFORM_SCI*/

  struct FilterCubicImageViewImageFormatPropertiesEXT
  {
    using NativeType = VkFilterCubicImageViewImageFormatPropertiesEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eFilterCubicImageViewImageFormatPropertiesEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR FilterCubicImageViewImageFormatPropertiesEXT( VULKAN_HPP_NAMESPACE::Bool32 filterCubic_       = {},
                                                                       VULKAN_HPP_NAMESPACE::Bool32 filterCubicMinmax_ = {},
                                                                       void *                       pNext_             = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , filterCubic{ filterCubic_ }
      , filterCubicMinmax{ filterCubicMinmax_ }
    {
    }

    VULKAN_HPP_CONSTEXPR FilterCubicImageViewImageFormatPropertiesEXT( FilterCubicImageViewImageFormatPropertiesEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    FilterCubicImageViewImageFormatPropertiesEXT( VkFilterCubicImageViewImageFormatPropertiesEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : FilterCubicImageViewImageFormatPropertiesEXT( *reinterpret_cast<FilterCubicImageViewImageFormatPropertiesEXT const *>( &rhs ) )
    {
    }

    FilterCubicImageViewImageFormatPropertiesEXT & operator=( FilterCubicImageViewImageFormatPropertiesEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    FilterCubicImageViewImageFormatPropertiesEXT & operator=( VkFilterCubicImageViewImageFormatPropertiesEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::FilterCubicImageViewImageFormatPropertiesEXT const *>( &rhs );
      return *this;
    }

    operator VkFilterCubicImageViewImageFormatPropertiesEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkFilterCubicImageViewImageFormatPropertiesEXT *>( this );
    }

    operator VkFilterCubicImageViewImageFormatPropertiesEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkFilterCubicImageViewImageFormatPropertiesEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, void * const &, VULKAN_HPP_NAMESPACE::Bool32 const &, VULKAN_HPP_NAMESPACE::Bool32 const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, filterCubic, filterCubicMinmax );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( FilterCubicImageViewImageFormatPropertiesEXT const & ) const = default;
#else
    bool operator==( FilterCubicImageViewImageFormatPropertiesEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( filterCubic == rhs.filterCubic ) && ( filterCubicMinmax == rhs.filterCubicMinmax );
#  endif
    }

    bool operator!=( FilterCubicImageViewImageFormatPropertiesEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType             = StructureType::eFilterCubicImageViewImageFormatPropertiesEXT;
    void *                              pNext             = {};
    VULKAN_HPP_NAMESPACE::Bool32        filterCubic       = {};
    VULKAN_HPP_NAMESPACE::Bool32        filterCubicMinmax = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eFilterCubicImageViewImageFormatPropertiesEXT>
  {
    using Type = FilterCubicImageViewImageFormatPropertiesEXT;
  };

  struct FormatProperties
  {
    using NativeType = VkFormatProperties;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR FormatProperties( VULKAN_HPP_NAMESPACE::FormatFeatureFlags linearTilingFeatures_  = {},
                                           VULKAN_HPP_NAMESPACE::FormatFeatureFlags optimalTilingFeatures_ = {},
                                           VULKAN_HPP_NAMESPACE::FormatFeatureFlags bufferFeatures_        = {} ) VULKAN_HPP_NOEXCEPT
      : linearTilingFeatures{ linearTilingFeatures_ }
      , optimalTilingFeatures{ optimalTilingFeatures_ }
      , bufferFeatures{ bufferFeatures_ }
    {
    }

    VULKAN_HPP_CONSTEXPR FormatProperties( FormatProperties const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    FormatProperties( VkFormatProperties const & rhs ) VULKAN_HPP_NOEXCEPT : FormatProperties( *reinterpret_cast<FormatProperties const *>( &rhs ) ) {}

    FormatProperties & operator=( FormatProperties const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    FormatProperties & operator=( VkFormatProperties const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::FormatProperties const *>( &rhs );
      return *this;
    }

    operator VkFormatProperties const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkFormatProperties *>( this );
    }

    operator VkFormatProperties &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkFormatProperties *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::FormatFeatureFlags const &,
               VULKAN_HPP_NAMESPACE::FormatFeatureFlags const &,
               VULKAN_HPP_NAMESPACE::FormatFeatureFlags const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( linearTilingFeatures, optimalTilingFeatures, bufferFeatures );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( FormatProperties const & ) const = default;
#else
    bool operator==( FormatProperties const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( linearTilingFeatures == rhs.linearTilingFeatures ) && ( optimalTilingFeatures == rhs.optimalTilingFeatures ) &&
             ( bufferFeatures == rhs.bufferFeatures );
#  endif
    }

    bool operator!=( FormatProperties const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::FormatFeatureFlags linearTilingFeatures  = {};
    VULKAN_HPP_NAMESPACE::FormatFeatureFlags optimalTilingFeatures = {};
    VULKAN_HPP_NAMESPACE::FormatFeatureFlags bufferFeatures        = {};
  };

  struct FormatProperties2
  {
    using NativeType = VkFormatProperties2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eFormatProperties2;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR FormatProperties2( VULKAN_HPP_NAMESPACE::FormatProperties formatProperties_ = {}, void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , formatProperties{ formatProperties_ }
    {
    }

    VULKAN_HPP_CONSTEXPR FormatProperties2( FormatProperties2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    FormatProperties2( VkFormatProperties2 const & rhs ) VULKAN_HPP_NOEXCEPT : FormatProperties2( *reinterpret_cast<FormatProperties2 const *>( &rhs ) ) {}

    FormatProperties2 & operator=( FormatProperties2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    FormatProperties2 & operator=( VkFormatProperties2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::FormatProperties2 const *>( &rhs );
      return *this;
    }

    operator VkFormatProperties2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkFormatProperties2 *>( this );
    }

    operator VkFormatProperties2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkFormatProperties2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, void * const &, VULKAN_HPP_NAMESPACE::FormatProperties const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, formatProperties );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( FormatProperties2 const & ) const = default;
#else
    bool operator==( FormatProperties2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( formatProperties == rhs.formatProperties );
#  endif
    }

    bool operator!=( FormatProperties2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType    sType            = StructureType::eFormatProperties2;
    void *                                 pNext            = {};
    VULKAN_HPP_NAMESPACE::FormatProperties formatProperties = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eFormatProperties2>
  {
    using Type = FormatProperties2;
  };

  using FormatProperties2KHR = FormatProperties2;

  struct FormatProperties3
  {
    using NativeType = VkFormatProperties3;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eFormatProperties3;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR FormatProperties3( VULKAN_HPP_NAMESPACE::FormatFeatureFlags2 linearTilingFeatures_  = {},
                                            VULKAN_HPP_NAMESPACE::FormatFeatureFlags2 optimalTilingFeatures_ = {},
                                            VULKAN_HPP_NAMESPACE::FormatFeatureFlags2 bufferFeatures_        = {},
                                            void *                                    pNext_                 = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , linearTilingFeatures{ linearTilingFeatures_ }
      , optimalTilingFeatures{ optimalTilingFeatures_ }
      , bufferFeatures{ bufferFeatures_ }
    {
    }

    VULKAN_HPP_CONSTEXPR FormatProperties3( FormatProperties3 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    FormatProperties3( VkFormatProperties3 const & rhs ) VULKAN_HPP_NOEXCEPT : FormatProperties3( *reinterpret_cast<FormatProperties3 const *>( &rhs ) ) {}

    FormatProperties3 & operator=( FormatProperties3 const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    FormatProperties3 & operator=( VkFormatProperties3 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::FormatProperties3 const *>( &rhs );
      return *this;
    }

    operator VkFormatProperties3 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkFormatProperties3 *>( this );
    }

    operator VkFormatProperties3 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkFormatProperties3 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               void * const &,
               VULKAN_HPP_NAMESPACE::FormatFeatureFlags2 const &,
               VULKAN_HPP_NAMESPACE::FormatFeatureFlags2 const &,
               VULKAN_HPP_NAMESPACE::FormatFeatureFlags2 const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, linearTilingFeatures, optimalTilingFeatures, bufferFeatures );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( FormatProperties3 const & ) const = default;
#else
    bool operator==( FormatProperties3 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( linearTilingFeatures == rhs.linearTilingFeatures ) &&
             ( optimalTilingFeatures == rhs.optimalTilingFeatures ) && ( bufferFeatures == rhs.bufferFeatures );
#  endif
    }

    bool operator!=( FormatProperties3 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType       sType                 = StructureType::eFormatProperties3;
    void *                                    pNext                 = {};
    VULKAN_HPP_NAMESPACE::FormatFeatureFlags2 linearTilingFeatures  = {};
    VULKAN_HPP_NAMESPACE::FormatFeatureFlags2 optimalTilingFeatures = {};
    VULKAN_HPP_NAMESPACE::FormatFeatureFlags2 bufferFeatures        = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eFormatProperties3>
  {
    using Type = FormatProperties3;
  };

  using FormatProperties3KHR = FormatProperties3;

  struct FragmentShadingRateAttachmentInfoKHR
  {
    using NativeType = VkFragmentShadingRateAttachmentInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eFragmentShadingRateAttachmentInfoKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR FragmentShadingRateAttachmentInfoKHR( const VULKAN_HPP_NAMESPACE::AttachmentReference2 * pFragmentShadingRateAttachment_ = {},
                                                               VULKAN_HPP_NAMESPACE::Extent2D                     shadingRateAttachmentTexelSize_ = {},
                                                               const void *                                       pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , pFragmentShadingRateAttachment{ pFragmentShadingRateAttachment_ }
      , shadingRateAttachmentTexelSize{ shadingRateAttachmentTexelSize_ }
    {
    }

    VULKAN_HPP_CONSTEXPR FragmentShadingRateAttachmentInfoKHR( FragmentShadingRateAttachmentInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    FragmentShadingRateAttachmentInfoKHR( VkFragmentShadingRateAttachmentInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : FragmentShadingRateAttachmentInfoKHR( *reinterpret_cast<FragmentShadingRateAttachmentInfoKHR const *>( &rhs ) )
    {
    }

    FragmentShadingRateAttachmentInfoKHR & operator=( FragmentShadingRateAttachmentInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    FragmentShadingRateAttachmentInfoKHR & operator=( VkFragmentShadingRateAttachmentInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::FragmentShadingRateAttachmentInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 FragmentShadingRateAttachmentInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 FragmentShadingRateAttachmentInfoKHR &
      setPFragmentShadingRateAttachment( const VULKAN_HPP_NAMESPACE::AttachmentReference2 * pFragmentShadingRateAttachment_ ) VULKAN_HPP_NOEXCEPT
    {
      pFragmentShadingRateAttachment = pFragmentShadingRateAttachment_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 FragmentShadingRateAttachmentInfoKHR &
      setShadingRateAttachmentTexelSize( VULKAN_HPP_NAMESPACE::Extent2D const & shadingRateAttachmentTexelSize_ ) VULKAN_HPP_NOEXCEPT
    {
      shadingRateAttachmentTexelSize = shadingRateAttachmentTexelSize_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkFragmentShadingRateAttachmentInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkFragmentShadingRateAttachmentInfoKHR *>( this );
    }

    operator VkFragmentShadingRateAttachmentInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkFragmentShadingRateAttachmentInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               const VULKAN_HPP_NAMESPACE::AttachmentReference2 * const &,
               VULKAN_HPP_NAMESPACE::Extent2D const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, pFragmentShadingRateAttachment, shadingRateAttachmentTexelSize );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( FragmentShadingRateAttachmentInfoKHR const & ) const = default;
#else
    bool operator==( FragmentShadingRateAttachmentInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( pFragmentShadingRateAttachment == rhs.pFragmentShadingRateAttachment ) &&
             ( shadingRateAttachmentTexelSize == rhs.shadingRateAttachmentTexelSize );
#  endif
    }

    bool operator!=( FragmentShadingRateAttachmentInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                sType                          = StructureType::eFragmentShadingRateAttachmentInfoKHR;
    const void *                                       pNext                          = {};
    const VULKAN_HPP_NAMESPACE::AttachmentReference2 * pFragmentShadingRateAttachment = {};
    VULKAN_HPP_NAMESPACE::Extent2D                     shadingRateAttachmentTexelSize = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eFragmentShadingRateAttachmentInfoKHR>
  {
    using Type = FragmentShadingRateAttachmentInfoKHR;
  };

  struct FramebufferAttachmentImageInfo
  {
    using NativeType = VkFramebufferAttachmentImageInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eFramebufferAttachmentImageInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR FramebufferAttachmentImageInfo( VULKAN_HPP_NAMESPACE::ImageCreateFlags flags_           = {},
                                                         VULKAN_HPP_NAMESPACE::ImageUsageFlags  usage_           = {},
                                                         uint32_t                               width_           = {},
                                                         uint32_t                               height_          = {},
                                                         uint32_t                               layerCount_      = {},
                                                         uint32_t                               viewFormatCount_ = {},
                                                         const VULKAN_HPP_NAMESPACE::Format *   pViewFormats_    = {},
                                                         const void *                           pNext_           = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , usage{ usage_ }
      , width{ width_ }
      , height{ height_ }
      , layerCount{ layerCount_ }
      , viewFormatCount{ viewFormatCount_ }
      , pViewFormats{ pViewFormats_ }
    {
    }

    VULKAN_HPP_CONSTEXPR FramebufferAttachmentImageInfo( FramebufferAttachmentImageInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    FramebufferAttachmentImageInfo( VkFramebufferAttachmentImageInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : FramebufferAttachmentImageInfo( *reinterpret_cast<FramebufferAttachmentImageInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    FramebufferAttachmentImageInfo( VULKAN_HPP_NAMESPACE::ImageCreateFlags                                                    flags_,
                                    VULKAN_HPP_NAMESPACE::ImageUsageFlags                                                     usage_,
                                    uint32_t                                                                                  width_,
                                    uint32_t                                                                                  height_,
                                    uint32_t                                                                                  layerCount_,
                                    VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::Format> const & viewFormats_,
                                    const void *                                                                              pNext_ = nullptr )
      : pNext( pNext_ )
      , flags( flags_ )
      , usage( usage_ )
      , width( width_ )
      , height( height_ )
      , layerCount( layerCount_ )
      , viewFormatCount( static_cast<uint32_t>( viewFormats_.size() ) )
      , pViewFormats( viewFormats_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    FramebufferAttachmentImageInfo & operator=( FramebufferAttachmentImageInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    FramebufferAttachmentImageInfo & operator=( VkFramebufferAttachmentImageInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::FramebufferAttachmentImageInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 FramebufferAttachmentImageInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 FramebufferAttachmentImageInfo & setFlags( VULKAN_HPP_NAMESPACE::ImageCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 FramebufferAttachmentImageInfo & setUsage( VULKAN_HPP_NAMESPACE::ImageUsageFlags usage_ ) VULKAN_HPP_NOEXCEPT
    {
      usage = usage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 FramebufferAttachmentImageInfo & setWidth( uint32_t width_ ) VULKAN_HPP_NOEXCEPT
    {
      width = width_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 FramebufferAttachmentImageInfo & setHeight( uint32_t height_ ) VULKAN_HPP_NOEXCEPT
    {
      height = height_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 FramebufferAttachmentImageInfo & setLayerCount( uint32_t layerCount_ ) VULKAN_HPP_NOEXCEPT
    {
      layerCount = layerCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 FramebufferAttachmentImageInfo & setViewFormatCount( uint32_t viewFormatCount_ ) VULKAN_HPP_NOEXCEPT
    {
      viewFormatCount = viewFormatCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 FramebufferAttachmentImageInfo & setPViewFormats( const VULKAN_HPP_NAMESPACE::Format * pViewFormats_ ) VULKAN_HPP_NOEXCEPT
    {
      pViewFormats = pViewFormats_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    FramebufferAttachmentImageInfo &
      setViewFormats( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::Format> const & viewFormats_ ) VULKAN_HPP_NOEXCEPT
    {
      viewFormatCount = static_cast<uint32_t>( viewFormats_.size() );
      pViewFormats    = viewFormats_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkFramebufferAttachmentImageInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkFramebufferAttachmentImageInfo *>( this );
    }

    operator VkFramebufferAttachmentImageInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkFramebufferAttachmentImageInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::ImageCreateFlags const &,
               VULKAN_HPP_NAMESPACE::ImageUsageFlags const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::Format * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, usage, width, height, layerCount, viewFormatCount, pViewFormats );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( FramebufferAttachmentImageInfo const & ) const = default;
#else
    bool operator==( FramebufferAttachmentImageInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( usage == rhs.usage ) && ( width == rhs.width ) &&
             ( height == rhs.height ) && ( layerCount == rhs.layerCount ) && ( viewFormatCount == rhs.viewFormatCount ) && ( pViewFormats == rhs.pViewFormats );
#  endif
    }

    bool operator!=( FramebufferAttachmentImageInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType    sType           = StructureType::eFramebufferAttachmentImageInfo;
    const void *                           pNext           = {};
    VULKAN_HPP_NAMESPACE::ImageCreateFlags flags           = {};
    VULKAN_HPP_NAMESPACE::ImageUsageFlags  usage           = {};
    uint32_t                               width           = {};
    uint32_t                               height          = {};
    uint32_t                               layerCount      = {};
    uint32_t                               viewFormatCount = {};
    const VULKAN_HPP_NAMESPACE::Format *   pViewFormats    = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eFramebufferAttachmentImageInfo>
  {
    using Type = FramebufferAttachmentImageInfo;
  };

  using FramebufferAttachmentImageInfoKHR = FramebufferAttachmentImageInfo;

  struct FramebufferAttachmentsCreateInfo
  {
    using NativeType = VkFramebufferAttachmentsCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eFramebufferAttachmentsCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR FramebufferAttachmentsCreateInfo( uint32_t                                                     attachmentImageInfoCount_ = {},
                                                           const VULKAN_HPP_NAMESPACE::FramebufferAttachmentImageInfo * pAttachmentImageInfos_    = {},
                                                           const void *                                                 pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , attachmentImageInfoCount{ attachmentImageInfoCount_ }
      , pAttachmentImageInfos{ pAttachmentImageInfos_ }
    {
    }

    VULKAN_HPP_CONSTEXPR FramebufferAttachmentsCreateInfo( FramebufferAttachmentsCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    FramebufferAttachmentsCreateInfo( VkFramebufferAttachmentsCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : FramebufferAttachmentsCreateInfo( *reinterpret_cast<FramebufferAttachmentsCreateInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    FramebufferAttachmentsCreateInfo(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::FramebufferAttachmentImageInfo> const & attachmentImageInfos_,
      const void *                                                                                                      pNext_ = nullptr )
      : pNext( pNext_ )
      , attachmentImageInfoCount( static_cast<uint32_t>( attachmentImageInfos_.size() ) )
      , pAttachmentImageInfos( attachmentImageInfos_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    FramebufferAttachmentsCreateInfo & operator=( FramebufferAttachmentsCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    FramebufferAttachmentsCreateInfo & operator=( VkFramebufferAttachmentsCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::FramebufferAttachmentsCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 FramebufferAttachmentsCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 FramebufferAttachmentsCreateInfo & setAttachmentImageInfoCount( uint32_t attachmentImageInfoCount_ ) VULKAN_HPP_NOEXCEPT
    {
      attachmentImageInfoCount = attachmentImageInfoCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 FramebufferAttachmentsCreateInfo &
      setPAttachmentImageInfos( const VULKAN_HPP_NAMESPACE::FramebufferAttachmentImageInfo * pAttachmentImageInfos_ ) VULKAN_HPP_NOEXCEPT
    {
      pAttachmentImageInfos = pAttachmentImageInfos_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    FramebufferAttachmentsCreateInfo & setAttachmentImageInfos(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::FramebufferAttachmentImageInfo> const & attachmentImageInfos_ )
      VULKAN_HPP_NOEXCEPT
    {
      attachmentImageInfoCount = static_cast<uint32_t>( attachmentImageInfos_.size() );
      pAttachmentImageInfos    = attachmentImageInfos_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkFramebufferAttachmentsCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkFramebufferAttachmentsCreateInfo *>( this );
    }

    operator VkFramebufferAttachmentsCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkFramebufferAttachmentsCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::FramebufferAttachmentImageInfo * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, attachmentImageInfoCount, pAttachmentImageInfos );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( FramebufferAttachmentsCreateInfo const & ) const = default;
#else
    bool operator==( FramebufferAttachmentsCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( attachmentImageInfoCount == rhs.attachmentImageInfoCount ) &&
             ( pAttachmentImageInfos == rhs.pAttachmentImageInfos );
#  endif
    }

    bool operator!=( FramebufferAttachmentsCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                          sType                    = StructureType::eFramebufferAttachmentsCreateInfo;
    const void *                                                 pNext                    = {};
    uint32_t                                                     attachmentImageInfoCount = {};
    const VULKAN_HPP_NAMESPACE::FramebufferAttachmentImageInfo * pAttachmentImageInfos    = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eFramebufferAttachmentsCreateInfo>
  {
    using Type = FramebufferAttachmentsCreateInfo;
  };

  using FramebufferAttachmentsCreateInfoKHR = FramebufferAttachmentsCreateInfo;

  struct FramebufferCreateInfo
  {
    using NativeType = VkFramebufferCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eFramebufferCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR FramebufferCreateInfo( VULKAN_HPP_NAMESPACE::FramebufferCreateFlags flags_           = {},
                                                VULKAN_HPP_NAMESPACE::RenderPass             renderPass_      = {},
                                                uint32_t                                     attachmentCount_ = {},
                                                const VULKAN_HPP_NAMESPACE::ImageView *      pAttachments_    = {},
                                                uint32_t                                     width_           = {},
                                                uint32_t                                     height_          = {},
                                                uint32_t                                     layers_          = {},
                                                const void *                                 pNext_           = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , renderPass{ renderPass_ }
      , attachmentCount{ attachmentCount_ }
      , pAttachments{ pAttachments_ }
      , width{ width_ }
      , height{ height_ }
      , layers{ layers_ }
    {
    }

    VULKAN_HPP_CONSTEXPR FramebufferCreateInfo( FramebufferCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    FramebufferCreateInfo( VkFramebufferCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : FramebufferCreateInfo( *reinterpret_cast<FramebufferCreateInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    FramebufferCreateInfo( VULKAN_HPP_NAMESPACE::FramebufferCreateFlags                                                 flags_,
                           VULKAN_HPP_NAMESPACE::RenderPass                                                             renderPass_,
                           VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::ImageView> const & attachments_,
                           uint32_t                                                                                     width_  = {},
                           uint32_t                                                                                     height_ = {},
                           uint32_t                                                                                     layers_ = {},
                           const void *                                                                                 pNext_  = nullptr )
      : pNext( pNext_ )
      , flags( flags_ )
      , renderPass( renderPass_ )
      , attachmentCount( static_cast<uint32_t>( attachments_.size() ) )
      , pAttachments( attachments_.data() )
      , width( width_ )
      , height( height_ )
      , layers( layers_ )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    FramebufferCreateInfo & operator=( FramebufferCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    FramebufferCreateInfo & operator=( VkFramebufferCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::FramebufferCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 FramebufferCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 FramebufferCreateInfo & setFlags( VULKAN_HPP_NAMESPACE::FramebufferCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 FramebufferCreateInfo & setRenderPass( VULKAN_HPP_NAMESPACE::RenderPass renderPass_ ) VULKAN_HPP_NOEXCEPT
    {
      renderPass = renderPass_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 FramebufferCreateInfo & setAttachmentCount( uint32_t attachmentCount_ ) VULKAN_HPP_NOEXCEPT
    {
      attachmentCount = attachmentCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 FramebufferCreateInfo & setPAttachments( const VULKAN_HPP_NAMESPACE::ImageView * pAttachments_ ) VULKAN_HPP_NOEXCEPT
    {
      pAttachments = pAttachments_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    FramebufferCreateInfo &
      setAttachments( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::ImageView> const & attachments_ ) VULKAN_HPP_NOEXCEPT
    {
      attachmentCount = static_cast<uint32_t>( attachments_.size() );
      pAttachments    = attachments_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 FramebufferCreateInfo & setWidth( uint32_t width_ ) VULKAN_HPP_NOEXCEPT
    {
      width = width_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 FramebufferCreateInfo & setHeight( uint32_t height_ ) VULKAN_HPP_NOEXCEPT
    {
      height = height_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 FramebufferCreateInfo & setLayers( uint32_t layers_ ) VULKAN_HPP_NOEXCEPT
    {
      layers = layers_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkFramebufferCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkFramebufferCreateInfo *>( this );
    }

    operator VkFramebufferCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkFramebufferCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::FramebufferCreateFlags const &,
               VULKAN_HPP_NAMESPACE::RenderPass const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::ImageView * const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, renderPass, attachmentCount, pAttachments, width, height, layers );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( FramebufferCreateInfo const & ) const = default;
#else
    bool operator==( FramebufferCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( renderPass == rhs.renderPass ) &&
             ( attachmentCount == rhs.attachmentCount ) && ( pAttachments == rhs.pAttachments ) && ( width == rhs.width ) && ( height == rhs.height ) &&
             ( layers == rhs.layers );
#  endif
    }

    bool operator!=( FramebufferCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType          sType           = StructureType::eFramebufferCreateInfo;
    const void *                                 pNext           = {};
    VULKAN_HPP_NAMESPACE::FramebufferCreateFlags flags           = {};
    VULKAN_HPP_NAMESPACE::RenderPass             renderPass      = {};
    uint32_t                                     attachmentCount = {};
    const VULKAN_HPP_NAMESPACE::ImageView *      pAttachments    = {};
    uint32_t                                     width           = {};
    uint32_t                                     height          = {};
    uint32_t                                     layers          = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eFramebufferCreateInfo>
  {
    using Type = FramebufferCreateInfo;
  };

  struct VertexInputBindingDescription
  {
    using NativeType = VkVertexInputBindingDescription;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      VertexInputBindingDescription( uint32_t                              binding_   = {},
                                     uint32_t                              stride_    = {},
                                     VULKAN_HPP_NAMESPACE::VertexInputRate inputRate_ = VULKAN_HPP_NAMESPACE::VertexInputRate::eVertex ) VULKAN_HPP_NOEXCEPT
      : binding{ binding_ }
      , stride{ stride_ }
      , inputRate{ inputRate_ }
    {
    }

    VULKAN_HPP_CONSTEXPR VertexInputBindingDescription( VertexInputBindingDescription const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    VertexInputBindingDescription( VkVertexInputBindingDescription const & rhs ) VULKAN_HPP_NOEXCEPT
      : VertexInputBindingDescription( *reinterpret_cast<VertexInputBindingDescription const *>( &rhs ) )
    {
    }

    VertexInputBindingDescription & operator=( VertexInputBindingDescription const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    VertexInputBindingDescription & operator=( VkVertexInputBindingDescription const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::VertexInputBindingDescription const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 VertexInputBindingDescription & setBinding( uint32_t binding_ ) VULKAN_HPP_NOEXCEPT
    {
      binding = binding_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 VertexInputBindingDescription & setStride( uint32_t stride_ ) VULKAN_HPP_NOEXCEPT
    {
      stride = stride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 VertexInputBindingDescription & setInputRate( VULKAN_HPP_NAMESPACE::VertexInputRate inputRate_ ) VULKAN_HPP_NOEXCEPT
    {
      inputRate = inputRate_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkVertexInputBindingDescription const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkVertexInputBindingDescription *>( this );
    }

    operator VkVertexInputBindingDescription &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkVertexInputBindingDescription *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &, uint32_t const &, VULKAN_HPP_NAMESPACE::VertexInputRate const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( binding, stride, inputRate );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( VertexInputBindingDescription const & ) const = default;
#else
    bool operator==( VertexInputBindingDescription const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( binding == rhs.binding ) && ( stride == rhs.stride ) && ( inputRate == rhs.inputRate );
#  endif
    }

    bool operator!=( VertexInputBindingDescription const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t                              binding   = {};
    uint32_t                              stride    = {};
    VULKAN_HPP_NAMESPACE::VertexInputRate inputRate = VULKAN_HPP_NAMESPACE::VertexInputRate::eVertex;
  };

  struct VertexInputAttributeDescription
  {
    using NativeType = VkVertexInputAttributeDescription;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR VertexInputAttributeDescription( uint32_t                     location_ = {},
                                                          uint32_t                     binding_  = {},
                                                          VULKAN_HPP_NAMESPACE::Format format_   = VULKAN_HPP_NAMESPACE::Format::eUndefined,
                                                          uint32_t                     offset_   = {} ) VULKAN_HPP_NOEXCEPT
      : location{ location_ }
      , binding{ binding_ }
      , format{ format_ }
      , offset{ offset_ }
    {
    }

    VULKAN_HPP_CONSTEXPR VertexInputAttributeDescription( VertexInputAttributeDescription const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    VertexInputAttributeDescription( VkVertexInputAttributeDescription const & rhs ) VULKAN_HPP_NOEXCEPT
      : VertexInputAttributeDescription( *reinterpret_cast<VertexInputAttributeDescription const *>( &rhs ) )
    {
    }

    VertexInputAttributeDescription & operator=( VertexInputAttributeDescription const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    VertexInputAttributeDescription & operator=( VkVertexInputAttributeDescription const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::VertexInputAttributeDescription const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 VertexInputAttributeDescription & setLocation( uint32_t location_ ) VULKAN_HPP_NOEXCEPT
    {
      location = location_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 VertexInputAttributeDescription & setBinding( uint32_t binding_ ) VULKAN_HPP_NOEXCEPT
    {
      binding = binding_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 VertexInputAttributeDescription & setFormat( VULKAN_HPP_NAMESPACE::Format format_ ) VULKAN_HPP_NOEXCEPT
    {
      format = format_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 VertexInputAttributeDescription & setOffset( uint32_t offset_ ) VULKAN_HPP_NOEXCEPT
    {
      offset = offset_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkVertexInputAttributeDescription const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkVertexInputAttributeDescription *>( this );
    }

    operator VkVertexInputAttributeDescription &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkVertexInputAttributeDescription *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &, uint32_t const &, VULKAN_HPP_NAMESPACE::Format const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( location, binding, format, offset );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( VertexInputAttributeDescription const & ) const = default;
#else
    bool operator==( VertexInputAttributeDescription const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( location == rhs.location ) && ( binding == rhs.binding ) && ( format == rhs.format ) && ( offset == rhs.offset );
#  endif
    }

    bool operator!=( VertexInputAttributeDescription const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t                     location = {};
    uint32_t                     binding  = {};
    VULKAN_HPP_NAMESPACE::Format format   = VULKAN_HPP_NAMESPACE::Format::eUndefined;
    uint32_t                     offset   = {};
  };

  struct PipelineVertexInputStateCreateInfo
  {
    using NativeType = VkPipelineVertexInputStateCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::ePipelineVertexInputStateCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR PipelineVertexInputStateCreateInfo( VULKAN_HPP_NAMESPACE::PipelineVertexInputStateCreateFlags   flags_                           = {},
                                                             uint32_t                                                    vertexBindingDescriptionCount_   = {},
                                                             const VULKAN_HPP_NAMESPACE::VertexInputBindingDescription * pVertexBindingDescriptions_      = {},
                                                             uint32_t                                                    vertexAttributeDescriptionCount_ = {},
                                                             const VULKAN_HPP_NAMESPACE::VertexInputAttributeDescription * pVertexAttributeDescriptions_  = {},
                                                             const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , vertexBindingDescriptionCount{ vertexBindingDescriptionCount_ }
      , pVertexBindingDescriptions{ pVertexBindingDescriptions_ }
      , vertexAttributeDescriptionCount{ vertexAttributeDescriptionCount_ }
      , pVertexAttributeDescriptions{ pVertexAttributeDescriptions_ }
    {
    }

    VULKAN_HPP_CONSTEXPR PipelineVertexInputStateCreateInfo( PipelineVertexInputStateCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    PipelineVertexInputStateCreateInfo( VkPipelineVertexInputStateCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : PipelineVertexInputStateCreateInfo( *reinterpret_cast<PipelineVertexInputStateCreateInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    PipelineVertexInputStateCreateInfo(
      VULKAN_HPP_NAMESPACE::PipelineVertexInputStateCreateFlags                                                          flags_,
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::VertexInputBindingDescription> const &   vertexBindingDescriptions_,
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::VertexInputAttributeDescription> const & vertexAttributeDescriptions_ = {},
      const void *                                                                                                       pNext_ = nullptr )
      : pNext( pNext_ )
      , flags( flags_ )
      , vertexBindingDescriptionCount( static_cast<uint32_t>( vertexBindingDescriptions_.size() ) )
      , pVertexBindingDescriptions( vertexBindingDescriptions_.data() )
      , vertexAttributeDescriptionCount( static_cast<uint32_t>( vertexAttributeDescriptions_.size() ) )
      , pVertexAttributeDescriptions( vertexAttributeDescriptions_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    PipelineVertexInputStateCreateInfo & operator=( PipelineVertexInputStateCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    PipelineVertexInputStateCreateInfo & operator=( VkPipelineVertexInputStateCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::PipelineVertexInputStateCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 PipelineVertexInputStateCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineVertexInputStateCreateInfo &
      setFlags( VULKAN_HPP_NAMESPACE::PipelineVertexInputStateCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineVertexInputStateCreateInfo & setVertexBindingDescriptionCount( uint32_t vertexBindingDescriptionCount_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexBindingDescriptionCount = vertexBindingDescriptionCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineVertexInputStateCreateInfo &
      setPVertexBindingDescriptions( const VULKAN_HPP_NAMESPACE::VertexInputBindingDescription * pVertexBindingDescriptions_ ) VULKAN_HPP_NOEXCEPT
    {
      pVertexBindingDescriptions = pVertexBindingDescriptions_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    PipelineVertexInputStateCreateInfo & setVertexBindingDescriptions(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::VertexInputBindingDescription> const & vertexBindingDescriptions_ )
      VULKAN_HPP_NOEXCEPT
    {
      vertexBindingDescriptionCount = static_cast<uint32_t>( vertexBindingDescriptions_.size() );
      pVertexBindingDescriptions    = vertexBindingDescriptions_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 PipelineVertexInputStateCreateInfo &
      setVertexAttributeDescriptionCount( uint32_t vertexAttributeDescriptionCount_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexAttributeDescriptionCount = vertexAttributeDescriptionCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineVertexInputStateCreateInfo &
      setPVertexAttributeDescriptions( const VULKAN_HPP_NAMESPACE::VertexInputAttributeDescription * pVertexAttributeDescriptions_ ) VULKAN_HPP_NOEXCEPT
    {
      pVertexAttributeDescriptions = pVertexAttributeDescriptions_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    PipelineVertexInputStateCreateInfo & setVertexAttributeDescriptions(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::VertexInputAttributeDescription> const & vertexAttributeDescriptions_ )
      VULKAN_HPP_NOEXCEPT
    {
      vertexAttributeDescriptionCount = static_cast<uint32_t>( vertexAttributeDescriptions_.size() );
      pVertexAttributeDescriptions    = vertexAttributeDescriptions_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkPipelineVertexInputStateCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkPipelineVertexInputStateCreateInfo *>( this );
    }

    operator VkPipelineVertexInputStateCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkPipelineVertexInputStateCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::PipelineVertexInputStateCreateFlags const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::VertexInputBindingDescription * const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::VertexInputAttributeDescription * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie(
        sType, pNext, flags, vertexBindingDescriptionCount, pVertexBindingDescriptions, vertexAttributeDescriptionCount, pVertexAttributeDescriptions );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( PipelineVertexInputStateCreateInfo const & ) const = default;
#else
    bool operator==( PipelineVertexInputStateCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) &&
             ( vertexBindingDescriptionCount == rhs.vertexBindingDescriptionCount ) && ( pVertexBindingDescriptions == rhs.pVertexBindingDescriptions ) &&
             ( vertexAttributeDescriptionCount == rhs.vertexAttributeDescriptionCount ) && ( pVertexAttributeDescriptions == rhs.pVertexAttributeDescriptions );
#  endif
    }

    bool operator!=( PipelineVertexInputStateCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                           sType                           = StructureType::ePipelineVertexInputStateCreateInfo;
    const void *                                                  pNext                           = {};
    VULKAN_HPP_NAMESPACE::PipelineVertexInputStateCreateFlags     flags                           = {};
    uint32_t                                                      vertexBindingDescriptionCount   = {};
    const VULKAN_HPP_NAMESPACE::VertexInputBindingDescription *   pVertexBindingDescriptions      = {};
    uint32_t                                                      vertexAttributeDescriptionCount = {};
    const VULKAN_HPP_NAMESPACE::VertexInputAttributeDescription * pVertexAttributeDescriptions    = {};
  };

  template <>
  struct CppType<StructureType, StructureType::ePipelineVertexInputStateCreateInfo>
  {
    using Type = PipelineVertexInputStateCreateInfo;
  };

  struct PipelineInputAssemblyStateCreateInfo
  {
    using NativeType = VkPipelineInputAssemblyStateCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::ePipelineInputAssemblyStateCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      PipelineInputAssemblyStateCreateInfo( VULKAN_HPP_NAMESPACE::PipelineInputAssemblyStateCreateFlags flags_ = {},
                                            VULKAN_HPP_NAMESPACE::PrimitiveTopology topology_ = VULKAN_HPP_NAMESPACE::PrimitiveTopology::ePointList,
                                            VULKAN_HPP_NAMESPACE::Bool32            primitiveRestartEnable_ = {},
                                            const void *                            pNext_                  = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , topology{ topology_ }
      , primitiveRestartEnable{ primitiveRestartEnable_ }
    {
    }

    VULKAN_HPP_CONSTEXPR PipelineInputAssemblyStateCreateInfo( PipelineInputAssemblyStateCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    PipelineInputAssemblyStateCreateInfo( VkPipelineInputAssemblyStateCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : PipelineInputAssemblyStateCreateInfo( *reinterpret_cast<PipelineInputAssemblyStateCreateInfo const *>( &rhs ) )
    {
    }

    PipelineInputAssemblyStateCreateInfo & operator=( PipelineInputAssemblyStateCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    PipelineInputAssemblyStateCreateInfo & operator=( VkPipelineInputAssemblyStateCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::PipelineInputAssemblyStateCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 PipelineInputAssemblyStateCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineInputAssemblyStateCreateInfo &
      setFlags( VULKAN_HPP_NAMESPACE::PipelineInputAssemblyStateCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineInputAssemblyStateCreateInfo & setTopology( VULKAN_HPP_NAMESPACE::PrimitiveTopology topology_ ) VULKAN_HPP_NOEXCEPT
    {
      topology = topology_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineInputAssemblyStateCreateInfo &
      setPrimitiveRestartEnable( VULKAN_HPP_NAMESPACE::Bool32 primitiveRestartEnable_ ) VULKAN_HPP_NOEXCEPT
    {
      primitiveRestartEnable = primitiveRestartEnable_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkPipelineInputAssemblyStateCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkPipelineInputAssemblyStateCreateInfo *>( this );
    }

    operator VkPipelineInputAssemblyStateCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkPipelineInputAssemblyStateCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::PipelineInputAssemblyStateCreateFlags const &,
               VULKAN_HPP_NAMESPACE::PrimitiveTopology const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, topology, primitiveRestartEnable );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( PipelineInputAssemblyStateCreateInfo const & ) const = default;
#else
    bool operator==( PipelineInputAssemblyStateCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( topology == rhs.topology ) &&
             ( primitiveRestartEnable == rhs.primitiveRestartEnable );
#  endif
    }

    bool operator!=( PipelineInputAssemblyStateCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                         sType                  = StructureType::ePipelineInputAssemblyStateCreateInfo;
    const void *                                                pNext                  = {};
    VULKAN_HPP_NAMESPACE::PipelineInputAssemblyStateCreateFlags flags                  = {};
    VULKAN_HPP_NAMESPACE::PrimitiveTopology                     topology               = VULKAN_HPP_NAMESPACE::PrimitiveTopology::ePointList;
    VULKAN_HPP_NAMESPACE::Bool32                                primitiveRestartEnable = {};
  };

  template <>
  struct CppType<StructureType, StructureType::ePipelineInputAssemblyStateCreateInfo>
  {
    using Type = PipelineInputAssemblyStateCreateInfo;
  };

  struct PipelineTessellationStateCreateInfo
  {
    using NativeType = VkPipelineTessellationStateCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::ePipelineTessellationStateCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR PipelineTessellationStateCreateInfo( VULKAN_HPP_NAMESPACE::PipelineTessellationStateCreateFlags flags_              = {},
                                                              uint32_t                                                   patchControlPoints_ = {},
                                                              const void *                                               pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , patchControlPoints{ patchControlPoints_ }
    {
    }

    VULKAN_HPP_CONSTEXPR PipelineTessellationStateCreateInfo( PipelineTessellationStateCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    PipelineTessellationStateCreateInfo( VkPipelineTessellationStateCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : PipelineTessellationStateCreateInfo( *reinterpret_cast<PipelineTessellationStateCreateInfo const *>( &rhs ) )
    {
    }

    PipelineTessellationStateCreateInfo & operator=( PipelineTessellationStateCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    PipelineTessellationStateCreateInfo & operator=( VkPipelineTessellationStateCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::PipelineTessellationStateCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 PipelineTessellationStateCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineTessellationStateCreateInfo &
      setFlags( VULKAN_HPP_NAMESPACE::PipelineTessellationStateCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineTessellationStateCreateInfo & setPatchControlPoints( uint32_t patchControlPoints_ ) VULKAN_HPP_NOEXCEPT
    {
      patchControlPoints = patchControlPoints_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkPipelineTessellationStateCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkPipelineTessellationStateCreateInfo *>( this );
    }

    operator VkPipelineTessellationStateCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkPipelineTessellationStateCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::PipelineTessellationStateCreateFlags const &,
               uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, patchControlPoints );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( PipelineTessellationStateCreateInfo const & ) const = default;
#else
    bool operator==( PipelineTessellationStateCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( patchControlPoints == rhs.patchControlPoints );
#  endif
    }

    bool operator!=( PipelineTessellationStateCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                        sType              = StructureType::ePipelineTessellationStateCreateInfo;
    const void *                                               pNext              = {};
    VULKAN_HPP_NAMESPACE::PipelineTessellationStateCreateFlags flags              = {};
    uint32_t                                                   patchControlPoints = {};
  };

  template <>
  struct CppType<StructureType, StructureType::ePipelineTessellationStateCreateInfo>
  {
    using Type = PipelineTessellationStateCreateInfo;
  };

  struct Viewport
  {
    using NativeType = VkViewport;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      Viewport( float x_ = {}, float y_ = {}, float width_ = {}, float height_ = {}, float minDepth_ = {}, float maxDepth_ = {} ) VULKAN_HPP_NOEXCEPT
      : x{ x_ }
      , y{ y_ }
      , width{ width_ }
      , height{ height_ }
      , minDepth{ minDepth_ }
      , maxDepth{ maxDepth_ }
    {
    }

    VULKAN_HPP_CONSTEXPR Viewport( Viewport const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    Viewport( VkViewport const & rhs ) VULKAN_HPP_NOEXCEPT : Viewport( *reinterpret_cast<Viewport const *>( &rhs ) ) {}

    Viewport & operator=( Viewport const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    Viewport & operator=( VkViewport const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::Viewport const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 Viewport & setX( float x_ ) VULKAN_HPP_NOEXCEPT
    {
      x = x_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Viewport & setY( float y_ ) VULKAN_HPP_NOEXCEPT
    {
      y = y_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Viewport & setWidth( float width_ ) VULKAN_HPP_NOEXCEPT
    {
      width = width_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Viewport & setHeight( float height_ ) VULKAN_HPP_NOEXCEPT
    {
      height = height_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Viewport & setMinDepth( float minDepth_ ) VULKAN_HPP_NOEXCEPT
    {
      minDepth = minDepth_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Viewport & setMaxDepth( float maxDepth_ ) VULKAN_HPP_NOEXCEPT
    {
      maxDepth = maxDepth_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkViewport const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkViewport *>( this );
    }

    operator VkViewport &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkViewport *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<float const &, float const &, float const &, float const &, float const &, float const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( x, y, width, height, minDepth, maxDepth );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( Viewport const & ) const = default;
#else
    bool operator==( Viewport const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( x == rhs.x ) && ( y == rhs.y ) && ( width == rhs.width ) && ( height == rhs.height ) && ( minDepth == rhs.minDepth ) &&
             ( maxDepth == rhs.maxDepth );
#  endif
    }

    bool operator!=( Viewport const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    float x        = {};
    float y        = {};
    float width    = {};
    float height   = {};
    float minDepth = {};
    float maxDepth = {};
  };

  struct PipelineViewportStateCreateInfo
  {
    using NativeType = VkPipelineViewportStateCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::ePipelineViewportStateCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR PipelineViewportStateCreateInfo( VULKAN_HPP_NAMESPACE::PipelineViewportStateCreateFlags flags_         = {},
                                                          uint32_t                                               viewportCount_ = {},
                                                          const VULKAN_HPP_NAMESPACE::Viewport *                 pViewports_    = {},
                                                          uint32_t                                               scissorCount_  = {},
                                                          const VULKAN_HPP_NAMESPACE::Rect2D *                   pScissors_     = {},
                                                          const void *                                           pNext_         = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , viewportCount{ viewportCount_ }
      , pViewports{ pViewports_ }
      , scissorCount{ scissorCount_ }
      , pScissors{ pScissors_ }
    {
    }

    VULKAN_HPP_CONSTEXPR PipelineViewportStateCreateInfo( PipelineViewportStateCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    PipelineViewportStateCreateInfo( VkPipelineViewportStateCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : PipelineViewportStateCreateInfo( *reinterpret_cast<PipelineViewportStateCreateInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    PipelineViewportStateCreateInfo( VULKAN_HPP_NAMESPACE::PipelineViewportStateCreateFlags                                      flags_,
                                     VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::Viewport> const & viewports_,
                                     VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::Rect2D> const &   scissors_ = {},
                                     const void *                                                                                pNext_    = nullptr )
      : pNext( pNext_ )
      , flags( flags_ )
      , viewportCount( static_cast<uint32_t>( viewports_.size() ) )
      , pViewports( viewports_.data() )
      , scissorCount( static_cast<uint32_t>( scissors_.size() ) )
      , pScissors( scissors_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    PipelineViewportStateCreateInfo & operator=( PipelineViewportStateCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    PipelineViewportStateCreateInfo & operator=( VkPipelineViewportStateCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::PipelineViewportStateCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 PipelineViewportStateCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineViewportStateCreateInfo & setFlags( VULKAN_HPP_NAMESPACE::PipelineViewportStateCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineViewportStateCreateInfo & setViewportCount( uint32_t viewportCount_ ) VULKAN_HPP_NOEXCEPT
    {
      viewportCount = viewportCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineViewportStateCreateInfo & setPViewports( const VULKAN_HPP_NAMESPACE::Viewport * pViewports_ ) VULKAN_HPP_NOEXCEPT
    {
      pViewports = pViewports_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    PipelineViewportStateCreateInfo &
      setViewports( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::Viewport> const & viewports_ ) VULKAN_HPP_NOEXCEPT
    {
      viewportCount = static_cast<uint32_t>( viewports_.size() );
      pViewports    = viewports_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 PipelineViewportStateCreateInfo & setScissorCount( uint32_t scissorCount_ ) VULKAN_HPP_NOEXCEPT
    {
      scissorCount = scissorCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineViewportStateCreateInfo & setPScissors( const VULKAN_HPP_NAMESPACE::Rect2D * pScissors_ ) VULKAN_HPP_NOEXCEPT
    {
      pScissors = pScissors_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    PipelineViewportStateCreateInfo &
      setScissors( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::Rect2D> const & scissors_ ) VULKAN_HPP_NOEXCEPT
    {
      scissorCount = static_cast<uint32_t>( scissors_.size() );
      pScissors    = scissors_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkPipelineViewportStateCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkPipelineViewportStateCreateInfo *>( this );
    }

    operator VkPipelineViewportStateCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkPipelineViewportStateCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::PipelineViewportStateCreateFlags const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::Viewport * const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::Rect2D * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, viewportCount, pViewports, scissorCount, pScissors );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( PipelineViewportStateCreateInfo const & ) const = default;
#else
    bool operator==( PipelineViewportStateCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( viewportCount == rhs.viewportCount ) &&
             ( pViewports == rhs.pViewports ) && ( scissorCount == rhs.scissorCount ) && ( pScissors == rhs.pScissors );
#  endif
    }

    bool operator!=( PipelineViewportStateCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                    sType         = StructureType::ePipelineViewportStateCreateInfo;
    const void *                                           pNext         = {};
    VULKAN_HPP_NAMESPACE::PipelineViewportStateCreateFlags flags         = {};
    uint32_t                                               viewportCount = {};
    const VULKAN_HPP_NAMESPACE::Viewport *                 pViewports    = {};
    uint32_t                                               scissorCount  = {};
    const VULKAN_HPP_NAMESPACE::Rect2D *                   pScissors     = {};
  };

  template <>
  struct CppType<StructureType, StructureType::ePipelineViewportStateCreateInfo>
  {
    using Type = PipelineViewportStateCreateInfo;
  };

  struct PipelineRasterizationStateCreateInfo
  {
    using NativeType = VkPipelineRasterizationStateCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::ePipelineRasterizationStateCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR PipelineRasterizationStateCreateInfo( VULKAN_HPP_NAMESPACE::PipelineRasterizationStateCreateFlags flags_                   = {},
                                                               VULKAN_HPP_NAMESPACE::Bool32                                depthClampEnable_        = {},
                                                               VULKAN_HPP_NAMESPACE::Bool32                                rasterizerDiscardEnable_ = {},
                                                               VULKAN_HPP_NAMESPACE::PolygonMode   polygonMode_ = VULKAN_HPP_NAMESPACE::PolygonMode::eFill,
                                                               VULKAN_HPP_NAMESPACE::CullModeFlags cullMode_    = {},
                                                               VULKAN_HPP_NAMESPACE::FrontFace frontFace_ = VULKAN_HPP_NAMESPACE::FrontFace::eCounterClockwise,
                                                               VULKAN_HPP_NAMESPACE::Bool32    depthBiasEnable_         = {},
                                                               float                           depthBiasConstantFactor_ = {},
                                                               float                           depthBiasClamp_          = {},
                                                               float                           depthBiasSlopeFactor_    = {},
                                                               float                           lineWidth_               = {},
                                                               const void *                    pNext_                   = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , depthClampEnable{ depthClampEnable_ }
      , rasterizerDiscardEnable{ rasterizerDiscardEnable_ }
      , polygonMode{ polygonMode_ }
      , cullMode{ cullMode_ }
      , frontFace{ frontFace_ }
      , depthBiasEnable{ depthBiasEnable_ }
      , depthBiasConstantFactor{ depthBiasConstantFactor_ }
      , depthBiasClamp{ depthBiasClamp_ }
      , depthBiasSlopeFactor{ depthBiasSlopeFactor_ }
      , lineWidth{ lineWidth_ }
    {
    }

    VULKAN_HPP_CONSTEXPR PipelineRasterizationStateCreateInfo( PipelineRasterizationStateCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    PipelineRasterizationStateCreateInfo( VkPipelineRasterizationStateCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : PipelineRasterizationStateCreateInfo( *reinterpret_cast<PipelineRasterizationStateCreateInfo const *>( &rhs ) )
    {
    }

    PipelineRasterizationStateCreateInfo & operator=( PipelineRasterizationStateCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    PipelineRasterizationStateCreateInfo & operator=( VkPipelineRasterizationStateCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::PipelineRasterizationStateCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 PipelineRasterizationStateCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineRasterizationStateCreateInfo &
      setFlags( VULKAN_HPP_NAMESPACE::PipelineRasterizationStateCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineRasterizationStateCreateInfo & setDepthClampEnable( VULKAN_HPP_NAMESPACE::Bool32 depthClampEnable_ ) VULKAN_HPP_NOEXCEPT
    {
      depthClampEnable = depthClampEnable_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineRasterizationStateCreateInfo &
      setRasterizerDiscardEnable( VULKAN_HPP_NAMESPACE::Bool32 rasterizerDiscardEnable_ ) VULKAN_HPP_NOEXCEPT
    {
      rasterizerDiscardEnable = rasterizerDiscardEnable_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineRasterizationStateCreateInfo & setPolygonMode( VULKAN_HPP_NAMESPACE::PolygonMode polygonMode_ ) VULKAN_HPP_NOEXCEPT
    {
      polygonMode = polygonMode_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineRasterizationStateCreateInfo & setCullMode( VULKAN_HPP_NAMESPACE::CullModeFlags cullMode_ ) VULKAN_HPP_NOEXCEPT
    {
      cullMode = cullMode_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineRasterizationStateCreateInfo & setFrontFace( VULKAN_HPP_NAMESPACE::FrontFace frontFace_ ) VULKAN_HPP_NOEXCEPT
    {
      frontFace = frontFace_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineRasterizationStateCreateInfo & setDepthBiasEnable( VULKAN_HPP_NAMESPACE::Bool32 depthBiasEnable_ ) VULKAN_HPP_NOEXCEPT
    {
      depthBiasEnable = depthBiasEnable_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineRasterizationStateCreateInfo & setDepthBiasConstantFactor( float depthBiasConstantFactor_ ) VULKAN_HPP_NOEXCEPT
    {
      depthBiasConstantFactor = depthBiasConstantFactor_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineRasterizationStateCreateInfo & setDepthBiasClamp( float depthBiasClamp_ ) VULKAN_HPP_NOEXCEPT
    {
      depthBiasClamp = depthBiasClamp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineRasterizationStateCreateInfo & setDepthBiasSlopeFactor( float depthBiasSlopeFactor_ ) VULKAN_HPP_NOEXCEPT
    {
      depthBiasSlopeFactor = depthBiasSlopeFactor_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineRasterizationStateCreateInfo & setLineWidth( float lineWidth_ ) VULKAN_HPP_NOEXCEPT
    {
      lineWidth = lineWidth_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkPipelineRasterizationStateCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkPipelineRasterizationStateCreateInfo *>( this );
    }

    operator VkPipelineRasterizationStateCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkPipelineRasterizationStateCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::PipelineRasterizationStateCreateFlags const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::PolygonMode const &,
               VULKAN_HPP_NAMESPACE::CullModeFlags const &,
               VULKAN_HPP_NAMESPACE::FrontFace const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               float const &,
               float const &,
               float const &,
               float const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType,
                       pNext,
                       flags,
                       depthClampEnable,
                       rasterizerDiscardEnable,
                       polygonMode,
                       cullMode,
                       frontFace,
                       depthBiasEnable,
                       depthBiasConstantFactor,
                       depthBiasClamp,
                       depthBiasSlopeFactor,
                       lineWidth );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( PipelineRasterizationStateCreateInfo const & ) const = default;
#else
    bool operator==( PipelineRasterizationStateCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( depthClampEnable == rhs.depthClampEnable ) &&
             ( rasterizerDiscardEnable == rhs.rasterizerDiscardEnable ) && ( polygonMode == rhs.polygonMode ) && ( cullMode == rhs.cullMode ) &&
             ( frontFace == rhs.frontFace ) && ( depthBiasEnable == rhs.depthBiasEnable ) && ( depthBiasConstantFactor == rhs.depthBiasConstantFactor ) &&
             ( depthBiasClamp == rhs.depthBiasClamp ) && ( depthBiasSlopeFactor == rhs.depthBiasSlopeFactor ) && ( lineWidth == rhs.lineWidth );
#  endif
    }

    bool operator!=( PipelineRasterizationStateCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                         sType                   = StructureType::ePipelineRasterizationStateCreateInfo;
    const void *                                                pNext                   = {};
    VULKAN_HPP_NAMESPACE::PipelineRasterizationStateCreateFlags flags                   = {};
    VULKAN_HPP_NAMESPACE::Bool32                                depthClampEnable        = {};
    VULKAN_HPP_NAMESPACE::Bool32                                rasterizerDiscardEnable = {};
    VULKAN_HPP_NAMESPACE::PolygonMode                           polygonMode             = VULKAN_HPP_NAMESPACE::PolygonMode::eFill;
    VULKAN_HPP_NAMESPACE::CullModeFlags                         cullMode                = {};
    VULKAN_HPP_NAMESPACE::FrontFace                             frontFace               = VULKAN_HPP_NAMESPACE::FrontFace::eCounterClockwise;
    VULKAN_HPP_NAMESPACE::Bool32                                depthBiasEnable         = {};
    float                                                       depthBiasConstantFactor = {};
    float                                                       depthBiasClamp          = {};
    float                                                       depthBiasSlopeFactor    = {};
    float                                                       lineWidth               = {};
  };

  template <>
  struct CppType<StructureType, StructureType::ePipelineRasterizationStateCreateInfo>
  {
    using Type = PipelineRasterizationStateCreateInfo;
  };

  struct PipelineMultisampleStateCreateInfo
  {
    using NativeType = VkPipelineMultisampleStateCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::ePipelineMultisampleStateCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      PipelineMultisampleStateCreateInfo( VULKAN_HPP_NAMESPACE::PipelineMultisampleStateCreateFlags flags_ = {},
                                          VULKAN_HPP_NAMESPACE::SampleCountFlagBits rasterizationSamples_  = VULKAN_HPP_NAMESPACE::SampleCountFlagBits::e1,
                                          VULKAN_HPP_NAMESPACE::Bool32              sampleShadingEnable_   = {},
                                          float                                     minSampleShading_      = {},
                                          const VULKAN_HPP_NAMESPACE::SampleMask *  pSampleMask_           = {},
                                          VULKAN_HPP_NAMESPACE::Bool32              alphaToCoverageEnable_ = {},
                                          VULKAN_HPP_NAMESPACE::Bool32              alphaToOneEnable_      = {},
                                          const void *                              pNext_                 = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , rasterizationSamples{ rasterizationSamples_ }
      , sampleShadingEnable{ sampleShadingEnable_ }
      , minSampleShading{ minSampleShading_ }
      , pSampleMask{ pSampleMask_ }
      , alphaToCoverageEnable{ alphaToCoverageEnable_ }
      , alphaToOneEnable{ alphaToOneEnable_ }
    {
    }

    VULKAN_HPP_CONSTEXPR PipelineMultisampleStateCreateInfo( PipelineMultisampleStateCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    PipelineMultisampleStateCreateInfo( VkPipelineMultisampleStateCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : PipelineMultisampleStateCreateInfo( *reinterpret_cast<PipelineMultisampleStateCreateInfo const *>( &rhs ) )
    {
    }

    PipelineMultisampleStateCreateInfo & operator=( PipelineMultisampleStateCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    PipelineMultisampleStateCreateInfo & operator=( VkPipelineMultisampleStateCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::PipelineMultisampleStateCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 PipelineMultisampleStateCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineMultisampleStateCreateInfo &
      setFlags( VULKAN_HPP_NAMESPACE::PipelineMultisampleStateCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineMultisampleStateCreateInfo &
      setRasterizationSamples( VULKAN_HPP_NAMESPACE::SampleCountFlagBits rasterizationSamples_ ) VULKAN_HPP_NOEXCEPT
    {
      rasterizationSamples = rasterizationSamples_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineMultisampleStateCreateInfo & setSampleShadingEnable( VULKAN_HPP_NAMESPACE::Bool32 sampleShadingEnable_ ) VULKAN_HPP_NOEXCEPT
    {
      sampleShadingEnable = sampleShadingEnable_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineMultisampleStateCreateInfo & setMinSampleShading( float minSampleShading_ ) VULKAN_HPP_NOEXCEPT
    {
      minSampleShading = minSampleShading_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineMultisampleStateCreateInfo & setPSampleMask( const VULKAN_HPP_NAMESPACE::SampleMask * pSampleMask_ ) VULKAN_HPP_NOEXCEPT
    {
      pSampleMask = pSampleMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineMultisampleStateCreateInfo &
      setAlphaToCoverageEnable( VULKAN_HPP_NAMESPACE::Bool32 alphaToCoverageEnable_ ) VULKAN_HPP_NOEXCEPT
    {
      alphaToCoverageEnable = alphaToCoverageEnable_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineMultisampleStateCreateInfo & setAlphaToOneEnable( VULKAN_HPP_NAMESPACE::Bool32 alphaToOneEnable_ ) VULKAN_HPP_NOEXCEPT
    {
      alphaToOneEnable = alphaToOneEnable_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkPipelineMultisampleStateCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkPipelineMultisampleStateCreateInfo *>( this );
    }

    operator VkPipelineMultisampleStateCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkPipelineMultisampleStateCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::PipelineMultisampleStateCreateFlags const &,
               VULKAN_HPP_NAMESPACE::SampleCountFlagBits const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               float const &,
               const VULKAN_HPP_NAMESPACE::SampleMask * const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, rasterizationSamples, sampleShadingEnable, minSampleShading, pSampleMask, alphaToCoverageEnable, alphaToOneEnable );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( PipelineMultisampleStateCreateInfo const & ) const = default;
#else
    bool operator==( PipelineMultisampleStateCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( rasterizationSamples == rhs.rasterizationSamples ) &&
             ( sampleShadingEnable == rhs.sampleShadingEnable ) && ( minSampleShading == rhs.minSampleShading ) && ( pSampleMask == rhs.pSampleMask ) &&
             ( alphaToCoverageEnable == rhs.alphaToCoverageEnable ) && ( alphaToOneEnable == rhs.alphaToOneEnable );
#  endif
    }

    bool operator!=( PipelineMultisampleStateCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                       sType                 = StructureType::ePipelineMultisampleStateCreateInfo;
    const void *                                              pNext                 = {};
    VULKAN_HPP_NAMESPACE::PipelineMultisampleStateCreateFlags flags                 = {};
    VULKAN_HPP_NAMESPACE::SampleCountFlagBits                 rasterizationSamples  = VULKAN_HPP_NAMESPACE::SampleCountFlagBits::e1;
    VULKAN_HPP_NAMESPACE::Bool32                              sampleShadingEnable   = {};
    float                                                     minSampleShading      = {};
    const VULKAN_HPP_NAMESPACE::SampleMask *                  pSampleMask           = {};
    VULKAN_HPP_NAMESPACE::Bool32                              alphaToCoverageEnable = {};
    VULKAN_HPP_NAMESPACE::Bool32                              alphaToOneEnable      = {};
  };

  template <>
  struct CppType<StructureType, StructureType::ePipelineMultisampleStateCreateInfo>
  {
    using Type = PipelineMultisampleStateCreateInfo;
  };

  struct StencilOpState
  {
    using NativeType = VkStencilOpState;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR StencilOpState( VULKAN_HPP_NAMESPACE::StencilOp failOp_      = VULKAN_HPP_NAMESPACE::StencilOp::eKeep,
                                         VULKAN_HPP_NAMESPACE::StencilOp passOp_      = VULKAN_HPP_NAMESPACE::StencilOp::eKeep,
                                         VULKAN_HPP_NAMESPACE::StencilOp depthFailOp_ = VULKAN_HPP_NAMESPACE::StencilOp::eKeep,
                                         VULKAN_HPP_NAMESPACE::CompareOp compareOp_   = VULKAN_HPP_NAMESPACE::CompareOp::eNever,
                                         uint32_t                        compareMask_ = {},
                                         uint32_t                        writeMask_   = {},
                                         uint32_t                        reference_   = {} ) VULKAN_HPP_NOEXCEPT
      : failOp{ failOp_ }
      , passOp{ passOp_ }
      , depthFailOp{ depthFailOp_ }
      , compareOp{ compareOp_ }
      , compareMask{ compareMask_ }
      , writeMask{ writeMask_ }
      , reference{ reference_ }
    {
    }

    VULKAN_HPP_CONSTEXPR StencilOpState( StencilOpState const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    StencilOpState( VkStencilOpState const & rhs ) VULKAN_HPP_NOEXCEPT : StencilOpState( *reinterpret_cast<StencilOpState const *>( &rhs ) ) {}

    StencilOpState & operator=( StencilOpState const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    StencilOpState & operator=( VkStencilOpState const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::StencilOpState const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 StencilOpState & setFailOp( VULKAN_HPP_NAMESPACE::StencilOp failOp_ ) VULKAN_HPP_NOEXCEPT
    {
      failOp = failOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 StencilOpState & setPassOp( VULKAN_HPP_NAMESPACE::StencilOp passOp_ ) VULKAN_HPP_NOEXCEPT
    {
      passOp = passOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 StencilOpState & setDepthFailOp( VULKAN_HPP_NAMESPACE::StencilOp depthFailOp_ ) VULKAN_HPP_NOEXCEPT
    {
      depthFailOp = depthFailOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 StencilOpState & setCompareOp( VULKAN_HPP_NAMESPACE::CompareOp compareOp_ ) VULKAN_HPP_NOEXCEPT
    {
      compareOp = compareOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 StencilOpState & setCompareMask( uint32_t compareMask_ ) VULKAN_HPP_NOEXCEPT
    {
      compareMask = compareMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 StencilOpState & setWriteMask( uint32_t writeMask_ ) VULKAN_HPP_NOEXCEPT
    {
      writeMask = writeMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 StencilOpState & setReference( uint32_t reference_ ) VULKAN_HPP_NOEXCEPT
    {
      reference = reference_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkStencilOpState const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkStencilOpState *>( this );
    }

    operator VkStencilOpState &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkStencilOpState *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StencilOp const &,
               VULKAN_HPP_NAMESPACE::StencilOp const &,
               VULKAN_HPP_NAMESPACE::StencilOp const &,
               VULKAN_HPP_NAMESPACE::CompareOp const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( failOp, passOp, depthFailOp, compareOp, compareMask, writeMask, reference );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( StencilOpState const & ) const = default;
#else
    bool operator==( StencilOpState const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( failOp == rhs.failOp ) && ( passOp == rhs.passOp ) && ( depthFailOp == rhs.depthFailOp ) && ( compareOp == rhs.compareOp ) &&
             ( compareMask == rhs.compareMask ) && ( writeMask == rhs.writeMask ) && ( reference == rhs.reference );
#  endif
    }

    bool operator!=( StencilOpState const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StencilOp failOp      = VULKAN_HPP_NAMESPACE::StencilOp::eKeep;
    VULKAN_HPP_NAMESPACE::StencilOp passOp      = VULKAN_HPP_NAMESPACE::StencilOp::eKeep;
    VULKAN_HPP_NAMESPACE::StencilOp depthFailOp = VULKAN_HPP_NAMESPACE::StencilOp::eKeep;
    VULKAN_HPP_NAMESPACE::CompareOp compareOp   = VULKAN_HPP_NAMESPACE::CompareOp::eNever;
    uint32_t                        compareMask = {};
    uint32_t                        writeMask   = {};
    uint32_t                        reference   = {};
  };

  struct PipelineDepthStencilStateCreateInfo
  {
    using NativeType = VkPipelineDepthStencilStateCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::ePipelineDepthStencilStateCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR PipelineDepthStencilStateCreateInfo( VULKAN_HPP_NAMESPACE::PipelineDepthStencilStateCreateFlags flags_            = {},
                                                              VULKAN_HPP_NAMESPACE::Bool32                               depthTestEnable_  = {},
                                                              VULKAN_HPP_NAMESPACE::Bool32                               depthWriteEnable_ = {},
                                                              VULKAN_HPP_NAMESPACE::CompareOp      depthCompareOp_ = VULKAN_HPP_NAMESPACE::CompareOp::eNever,
                                                              VULKAN_HPP_NAMESPACE::Bool32         depthBoundsTestEnable_ = {},
                                                              VULKAN_HPP_NAMESPACE::Bool32         stencilTestEnable_     = {},
                                                              VULKAN_HPP_NAMESPACE::StencilOpState front_                 = {},
                                                              VULKAN_HPP_NAMESPACE::StencilOpState back_                  = {},
                                                              float                                minDepthBounds_        = {},
                                                              float                                maxDepthBounds_        = {},
                                                              const void *                         pNext_                 = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , depthTestEnable{ depthTestEnable_ }
      , depthWriteEnable{ depthWriteEnable_ }
      , depthCompareOp{ depthCompareOp_ }
      , depthBoundsTestEnable{ depthBoundsTestEnable_ }
      , stencilTestEnable{ stencilTestEnable_ }
      , front{ front_ }
      , back{ back_ }
      , minDepthBounds{ minDepthBounds_ }
      , maxDepthBounds{ maxDepthBounds_ }
    {
    }

    VULKAN_HPP_CONSTEXPR PipelineDepthStencilStateCreateInfo( PipelineDepthStencilStateCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    PipelineDepthStencilStateCreateInfo( VkPipelineDepthStencilStateCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : PipelineDepthStencilStateCreateInfo( *reinterpret_cast<PipelineDepthStencilStateCreateInfo const *>( &rhs ) )
    {
    }

    PipelineDepthStencilStateCreateInfo & operator=( PipelineDepthStencilStateCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    PipelineDepthStencilStateCreateInfo & operator=( VkPipelineDepthStencilStateCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::PipelineDepthStencilStateCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 PipelineDepthStencilStateCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineDepthStencilStateCreateInfo &
      setFlags( VULKAN_HPP_NAMESPACE::PipelineDepthStencilStateCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineDepthStencilStateCreateInfo & setDepthTestEnable( VULKAN_HPP_NAMESPACE::Bool32 depthTestEnable_ ) VULKAN_HPP_NOEXCEPT
    {
      depthTestEnable = depthTestEnable_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineDepthStencilStateCreateInfo & setDepthWriteEnable( VULKAN_HPP_NAMESPACE::Bool32 depthWriteEnable_ ) VULKAN_HPP_NOEXCEPT
    {
      depthWriteEnable = depthWriteEnable_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineDepthStencilStateCreateInfo & setDepthCompareOp( VULKAN_HPP_NAMESPACE::CompareOp depthCompareOp_ ) VULKAN_HPP_NOEXCEPT
    {
      depthCompareOp = depthCompareOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineDepthStencilStateCreateInfo &
      setDepthBoundsTestEnable( VULKAN_HPP_NAMESPACE::Bool32 depthBoundsTestEnable_ ) VULKAN_HPP_NOEXCEPT
    {
      depthBoundsTestEnable = depthBoundsTestEnable_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineDepthStencilStateCreateInfo & setStencilTestEnable( VULKAN_HPP_NAMESPACE::Bool32 stencilTestEnable_ ) VULKAN_HPP_NOEXCEPT
    {
      stencilTestEnable = stencilTestEnable_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineDepthStencilStateCreateInfo & setFront( VULKAN_HPP_NAMESPACE::StencilOpState const & front_ ) VULKAN_HPP_NOEXCEPT
    {
      front = front_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineDepthStencilStateCreateInfo & setBack( VULKAN_HPP_NAMESPACE::StencilOpState const & back_ ) VULKAN_HPP_NOEXCEPT
    {
      back = back_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineDepthStencilStateCreateInfo & setMinDepthBounds( float minDepthBounds_ ) VULKAN_HPP_NOEXCEPT
    {
      minDepthBounds = minDepthBounds_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineDepthStencilStateCreateInfo & setMaxDepthBounds( float maxDepthBounds_ ) VULKAN_HPP_NOEXCEPT
    {
      maxDepthBounds = maxDepthBounds_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkPipelineDepthStencilStateCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkPipelineDepthStencilStateCreateInfo *>( this );
    }

    operator VkPipelineDepthStencilStateCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkPipelineDepthStencilStateCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::PipelineDepthStencilStateCreateFlags const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::CompareOp const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::StencilOpState const &,
               VULKAN_HPP_NAMESPACE::StencilOpState const &,
               float const &,
               float const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType,
                       pNext,
                       flags,
                       depthTestEnable,
                       depthWriteEnable,
                       depthCompareOp,
                       depthBoundsTestEnable,
                       stencilTestEnable,
                       front,
                       back,
                       minDepthBounds,
                       maxDepthBounds );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( PipelineDepthStencilStateCreateInfo const & ) const = default;
#else
    bool operator==( PipelineDepthStencilStateCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( depthTestEnable == rhs.depthTestEnable ) &&
             ( depthWriteEnable == rhs.depthWriteEnable ) && ( depthCompareOp == rhs.depthCompareOp ) &&
             ( depthBoundsTestEnable == rhs.depthBoundsTestEnable ) && ( stencilTestEnable == rhs.stencilTestEnable ) && ( front == rhs.front ) &&
             ( back == rhs.back ) && ( minDepthBounds == rhs.minDepthBounds ) && ( maxDepthBounds == rhs.maxDepthBounds );
#  endif
    }

    bool operator!=( PipelineDepthStencilStateCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                        sType                 = StructureType::ePipelineDepthStencilStateCreateInfo;
    const void *                                               pNext                 = {};
    VULKAN_HPP_NAMESPACE::PipelineDepthStencilStateCreateFlags flags                 = {};
    VULKAN_HPP_NAMESPACE::Bool32                               depthTestEnable       = {};
    VULKAN_HPP_NAMESPACE::Bool32                               depthWriteEnable      = {};
    VULKAN_HPP_NAMESPACE::CompareOp                            depthCompareOp        = VULKAN_HPP_NAMESPACE::CompareOp::eNever;
    VULKAN_HPP_NAMESPACE::Bool32                               depthBoundsTestEnable = {};
    VULKAN_HPP_NAMESPACE::Bool32                               stencilTestEnable     = {};
    VULKAN_HPP_NAMESPACE::StencilOpState                       front                 = {};
    VULKAN_HPP_NAMESPACE::StencilOpState                       back                  = {};
    float                                                      minDepthBounds        = {};
    float                                                      maxDepthBounds        = {};
  };

  template <>
  struct CppType<StructureType, StructureType::ePipelineDepthStencilStateCreateInfo>
  {
    using Type = PipelineDepthStencilStateCreateInfo;
  };

  struct PipelineColorBlendAttachmentState
  {
    using NativeType = VkPipelineColorBlendAttachmentState;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR PipelineColorBlendAttachmentState( VULKAN_HPP_NAMESPACE::Bool32      blendEnable_         = {},
                                                            VULKAN_HPP_NAMESPACE::BlendFactor srcColorBlendFactor_ = VULKAN_HPP_NAMESPACE::BlendFactor::eZero,
                                                            VULKAN_HPP_NAMESPACE::BlendFactor dstColorBlendFactor_ = VULKAN_HPP_NAMESPACE::BlendFactor::eZero,
                                                            VULKAN_HPP_NAMESPACE::BlendOp     colorBlendOp_        = VULKAN_HPP_NAMESPACE::BlendOp::eAdd,
                                                            VULKAN_HPP_NAMESPACE::BlendFactor srcAlphaBlendFactor_ = VULKAN_HPP_NAMESPACE::BlendFactor::eZero,
                                                            VULKAN_HPP_NAMESPACE::BlendFactor dstAlphaBlendFactor_ = VULKAN_HPP_NAMESPACE::BlendFactor::eZero,
                                                            VULKAN_HPP_NAMESPACE::BlendOp     alphaBlendOp_        = VULKAN_HPP_NAMESPACE::BlendOp::eAdd,
                                                            VULKAN_HPP_NAMESPACE::ColorComponentFlags colorWriteMask_ = {} ) VULKAN_HPP_NOEXCEPT
      : blendEnable{ blendEnable_ }
      , srcColorBlendFactor{ srcColorBlendFactor_ }
      , dstColorBlendFactor{ dstColorBlendFactor_ }
      , colorBlendOp{ colorBlendOp_ }
      , srcAlphaBlendFactor{ srcAlphaBlendFactor_ }
      , dstAlphaBlendFactor{ dstAlphaBlendFactor_ }
      , alphaBlendOp{ alphaBlendOp_ }
      , colorWriteMask{ colorWriteMask_ }
    {
    }

    VULKAN_HPP_CONSTEXPR PipelineColorBlendAttachmentState( PipelineColorBlendAttachmentState const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    PipelineColorBlendAttachmentState( VkPipelineColorBlendAttachmentState const & rhs ) VULKAN_HPP_NOEXCEPT
      : PipelineColorBlendAttachmentState( *reinterpret_cast<PipelineColorBlendAttachmentState const *>( &rhs ) )
    {
    }

    PipelineColorBlendAttachmentState & operator=( PipelineColorBlendAttachmentState const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    PipelineColorBlendAttachmentState & operator=( VkPipelineColorBlendAttachmentState const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::PipelineColorBlendAttachmentState const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 PipelineColorBlendAttachmentState & setBlendEnable( VULKAN_HPP_NAMESPACE::Bool32 blendEnable_ ) VULKAN_HPP_NOEXCEPT
    {
      blendEnable = blendEnable_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineColorBlendAttachmentState &
      setSrcColorBlendFactor( VULKAN_HPP_NAMESPACE::BlendFactor srcColorBlendFactor_ ) VULKAN_HPP_NOEXCEPT
    {
      srcColorBlendFactor = srcColorBlendFactor_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineColorBlendAttachmentState &
      setDstColorBlendFactor( VULKAN_HPP_NAMESPACE::BlendFactor dstColorBlendFactor_ ) VULKAN_HPP_NOEXCEPT
    {
      dstColorBlendFactor = dstColorBlendFactor_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineColorBlendAttachmentState & setColorBlendOp( VULKAN_HPP_NAMESPACE::BlendOp colorBlendOp_ ) VULKAN_HPP_NOEXCEPT
    {
      colorBlendOp = colorBlendOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineColorBlendAttachmentState &
      setSrcAlphaBlendFactor( VULKAN_HPP_NAMESPACE::BlendFactor srcAlphaBlendFactor_ ) VULKAN_HPP_NOEXCEPT
    {
      srcAlphaBlendFactor = srcAlphaBlendFactor_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineColorBlendAttachmentState &
      setDstAlphaBlendFactor( VULKAN_HPP_NAMESPACE::BlendFactor dstAlphaBlendFactor_ ) VULKAN_HPP_NOEXCEPT
    {
      dstAlphaBlendFactor = dstAlphaBlendFactor_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineColorBlendAttachmentState & setAlphaBlendOp( VULKAN_HPP_NAMESPACE::BlendOp alphaBlendOp_ ) VULKAN_HPP_NOEXCEPT
    {
      alphaBlendOp = alphaBlendOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineColorBlendAttachmentState &
      setColorWriteMask( VULKAN_HPP_NAMESPACE::ColorComponentFlags colorWriteMask_ ) VULKAN_HPP_NOEXCEPT
    {
      colorWriteMask = colorWriteMask_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkPipelineColorBlendAttachmentState const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkPipelineColorBlendAttachmentState *>( this );
    }

    operator VkPipelineColorBlendAttachmentState &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkPipelineColorBlendAttachmentState *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::BlendFactor const &,
               VULKAN_HPP_NAMESPACE::BlendFactor const &,
               VULKAN_HPP_NAMESPACE::BlendOp const &,
               VULKAN_HPP_NAMESPACE::BlendFactor const &,
               VULKAN_HPP_NAMESPACE::BlendFactor const &,
               VULKAN_HPP_NAMESPACE::BlendOp const &,
               VULKAN_HPP_NAMESPACE::ColorComponentFlags const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie(
        blendEnable, srcColorBlendFactor, dstColorBlendFactor, colorBlendOp, srcAlphaBlendFactor, dstAlphaBlendFactor, alphaBlendOp, colorWriteMask );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( PipelineColorBlendAttachmentState const & ) const = default;
#else
    bool operator==( PipelineColorBlendAttachmentState const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( blendEnable == rhs.blendEnable ) && ( srcColorBlendFactor == rhs.srcColorBlendFactor ) && ( dstColorBlendFactor == rhs.dstColorBlendFactor ) &&
             ( colorBlendOp == rhs.colorBlendOp ) && ( srcAlphaBlendFactor == rhs.srcAlphaBlendFactor ) && ( dstAlphaBlendFactor == rhs.dstAlphaBlendFactor ) &&
             ( alphaBlendOp == rhs.alphaBlendOp ) && ( colorWriteMask == rhs.colorWriteMask );
#  endif
    }

    bool operator!=( PipelineColorBlendAttachmentState const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::Bool32              blendEnable         = {};
    VULKAN_HPP_NAMESPACE::BlendFactor         srcColorBlendFactor = VULKAN_HPP_NAMESPACE::BlendFactor::eZero;
    VULKAN_HPP_NAMESPACE::BlendFactor         dstColorBlendFactor = VULKAN_HPP_NAMESPACE::BlendFactor::eZero;
    VULKAN_HPP_NAMESPACE::BlendOp             colorBlendOp        = VULKAN_HPP_NAMESPACE::BlendOp::eAdd;
    VULKAN_HPP_NAMESPACE::BlendFactor         srcAlphaBlendFactor = VULKAN_HPP_NAMESPACE::BlendFactor::eZero;
    VULKAN_HPP_NAMESPACE::BlendFactor         dstAlphaBlendFactor = VULKAN_HPP_NAMESPACE::BlendFactor::eZero;
    VULKAN_HPP_NAMESPACE::BlendOp             alphaBlendOp        = VULKAN_HPP_NAMESPACE::BlendOp::eAdd;
    VULKAN_HPP_NAMESPACE::ColorComponentFlags colorWriteMask      = {};
  };

  struct PipelineColorBlendStateCreateInfo
  {
    using NativeType = VkPipelineColorBlendStateCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::ePipelineColorBlendStateCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 PipelineColorBlendStateCreateInfo( VULKAN_HPP_NAMESPACE::PipelineColorBlendStateCreateFlags flags_         = {},
                                                               VULKAN_HPP_NAMESPACE::Bool32                             logicOpEnable_ = {},
                                                               VULKAN_HPP_NAMESPACE::LogicOp logicOp_         = VULKAN_HPP_NAMESPACE::LogicOp::eClear,
                                                               uint32_t                      attachmentCount_ = {},
                                                               const VULKAN_HPP_NAMESPACE::PipelineColorBlendAttachmentState * pAttachments_   = {},
                                                               std::array<float, 4> const &                                    blendConstants_ = {},
                                                               const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , logicOpEnable{ logicOpEnable_ }
      , logicOp{ logicOp_ }
      , attachmentCount{ attachmentCount_ }
      , pAttachments{ pAttachments_ }
      , blendConstants{ blendConstants_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineColorBlendStateCreateInfo( PipelineColorBlendStateCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    PipelineColorBlendStateCreateInfo( VkPipelineColorBlendStateCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : PipelineColorBlendStateCreateInfo( *reinterpret_cast<PipelineColorBlendStateCreateInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    PipelineColorBlendStateCreateInfo(
      VULKAN_HPP_NAMESPACE::PipelineColorBlendStateCreateFlags                                                             flags_,
      VULKAN_HPP_NAMESPACE::Bool32                                                                                         logicOpEnable_,
      VULKAN_HPP_NAMESPACE::LogicOp                                                                                        logicOp_,
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::PipelineColorBlendAttachmentState> const & attachments_,
      std::array<float, 4> const &                                                                                         blendConstants_ = {},
      const void *                                                                                                         pNext_          = nullptr )
      : pNext( pNext_ )
      , flags( flags_ )
      , logicOpEnable( logicOpEnable_ )
      , logicOp( logicOp_ )
      , attachmentCount( static_cast<uint32_t>( attachments_.size() ) )
      , pAttachments( attachments_.data() )
      , blendConstants( blendConstants_ )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    PipelineColorBlendStateCreateInfo & operator=( PipelineColorBlendStateCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    PipelineColorBlendStateCreateInfo & operator=( VkPipelineColorBlendStateCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::PipelineColorBlendStateCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 PipelineColorBlendStateCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineColorBlendStateCreateInfo & setFlags( VULKAN_HPP_NAMESPACE::PipelineColorBlendStateCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineColorBlendStateCreateInfo & setLogicOpEnable( VULKAN_HPP_NAMESPACE::Bool32 logicOpEnable_ ) VULKAN_HPP_NOEXCEPT
    {
      logicOpEnable = logicOpEnable_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineColorBlendStateCreateInfo & setLogicOp( VULKAN_HPP_NAMESPACE::LogicOp logicOp_ ) VULKAN_HPP_NOEXCEPT
    {
      logicOp = logicOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineColorBlendStateCreateInfo & setAttachmentCount( uint32_t attachmentCount_ ) VULKAN_HPP_NOEXCEPT
    {
      attachmentCount = attachmentCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineColorBlendStateCreateInfo &
      setPAttachments( const VULKAN_HPP_NAMESPACE::PipelineColorBlendAttachmentState * pAttachments_ ) VULKAN_HPP_NOEXCEPT
    {
      pAttachments = pAttachments_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    PipelineColorBlendStateCreateInfo & setAttachments(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::PipelineColorBlendAttachmentState> const & attachments_ ) VULKAN_HPP_NOEXCEPT
    {
      attachmentCount = static_cast<uint32_t>( attachments_.size() );
      pAttachments    = attachments_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 PipelineColorBlendStateCreateInfo & setBlendConstants( std::array<float, 4> blendConstants_ ) VULKAN_HPP_NOEXCEPT
    {
      blendConstants = blendConstants_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkPipelineColorBlendStateCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkPipelineColorBlendStateCreateInfo *>( this );
    }

    operator VkPipelineColorBlendStateCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkPipelineColorBlendStateCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::PipelineColorBlendStateCreateFlags const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::LogicOp const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::PipelineColorBlendAttachmentState * const &,
               VULKAN_HPP_NAMESPACE::ArrayWrapper1D<float, 4> const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, logicOpEnable, logicOp, attachmentCount, pAttachments, blendConstants );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( PipelineColorBlendStateCreateInfo const & ) const = default;
#else
    bool operator==( PipelineColorBlendStateCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( logicOpEnable == rhs.logicOpEnable ) &&
             ( logicOp == rhs.logicOp ) && ( attachmentCount == rhs.attachmentCount ) && ( pAttachments == rhs.pAttachments ) &&
             ( blendConstants == rhs.blendConstants );
#  endif
    }

    bool operator!=( PipelineColorBlendStateCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                             sType           = StructureType::ePipelineColorBlendStateCreateInfo;
    const void *                                                    pNext           = {};
    VULKAN_HPP_NAMESPACE::PipelineColorBlendStateCreateFlags        flags           = {};
    VULKAN_HPP_NAMESPACE::Bool32                                    logicOpEnable   = {};
    VULKAN_HPP_NAMESPACE::LogicOp                                   logicOp         = VULKAN_HPP_NAMESPACE::LogicOp::eClear;
    uint32_t                                                        attachmentCount = {};
    const VULKAN_HPP_NAMESPACE::PipelineColorBlendAttachmentState * pAttachments    = {};
    VULKAN_HPP_NAMESPACE::ArrayWrapper1D<float, 4>                  blendConstants  = {};
  };

  template <>
  struct CppType<StructureType, StructureType::ePipelineColorBlendStateCreateInfo>
  {
    using Type = PipelineColorBlendStateCreateInfo;
  };

  struct PipelineDynamicStateCreateInfo
  {
    using NativeType = VkPipelineDynamicStateCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::ePipelineDynamicStateCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR PipelineDynamicStateCreateInfo( VULKAN_HPP_NAMESPACE::PipelineDynamicStateCreateFlags flags_             = {},
                                                         uint32_t                                              dynamicStateCount_ = {},
                                                         const VULKAN_HPP_NAMESPACE::DynamicState *            pDynamicStates_    = {},
                                                         const void *                                          pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , dynamicStateCount{ dynamicStateCount_ }
      , pDynamicStates{ pDynamicStates_ }
    {
    }

    VULKAN_HPP_CONSTEXPR PipelineDynamicStateCreateInfo( PipelineDynamicStateCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    PipelineDynamicStateCreateInfo( VkPipelineDynamicStateCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : PipelineDynamicStateCreateInfo( *reinterpret_cast<PipelineDynamicStateCreateInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    PipelineDynamicStateCreateInfo( VULKAN_HPP_NAMESPACE::PipelineDynamicStateCreateFlags                                           flags_,
                                    VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DynamicState> const & dynamicStates_,
                                    const void *                                                                                    pNext_ = nullptr )
      : pNext( pNext_ ), flags( flags_ ), dynamicStateCount( static_cast<uint32_t>( dynamicStates_.size() ) ), pDynamicStates( dynamicStates_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    PipelineDynamicStateCreateInfo & operator=( PipelineDynamicStateCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    PipelineDynamicStateCreateInfo & operator=( VkPipelineDynamicStateCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::PipelineDynamicStateCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 PipelineDynamicStateCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineDynamicStateCreateInfo & setFlags( VULKAN_HPP_NAMESPACE::PipelineDynamicStateCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineDynamicStateCreateInfo & setDynamicStateCount( uint32_t dynamicStateCount_ ) VULKAN_HPP_NOEXCEPT
    {
      dynamicStateCount = dynamicStateCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineDynamicStateCreateInfo & setPDynamicStates( const VULKAN_HPP_NAMESPACE::DynamicState * pDynamicStates_ ) VULKAN_HPP_NOEXCEPT
    {
      pDynamicStates = pDynamicStates_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    PipelineDynamicStateCreateInfo &
      setDynamicStates( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DynamicState> const & dynamicStates_ ) VULKAN_HPP_NOEXCEPT
    {
      dynamicStateCount = static_cast<uint32_t>( dynamicStates_.size() );
      pDynamicStates    = dynamicStates_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkPipelineDynamicStateCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkPipelineDynamicStateCreateInfo *>( this );
    }

    operator VkPipelineDynamicStateCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkPipelineDynamicStateCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::PipelineDynamicStateCreateFlags const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::DynamicState * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, dynamicStateCount, pDynamicStates );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( PipelineDynamicStateCreateInfo const & ) const = default;
#else
    bool operator==( PipelineDynamicStateCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( dynamicStateCount == rhs.dynamicStateCount ) &&
             ( pDynamicStates == rhs.pDynamicStates );
#  endif
    }

    bool operator!=( PipelineDynamicStateCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                   sType             = StructureType::ePipelineDynamicStateCreateInfo;
    const void *                                          pNext             = {};
    VULKAN_HPP_NAMESPACE::PipelineDynamicStateCreateFlags flags             = {};
    uint32_t                                              dynamicStateCount = {};
    const VULKAN_HPP_NAMESPACE::DynamicState *            pDynamicStates    = {};
  };

  template <>
  struct CppType<StructureType, StructureType::ePipelineDynamicStateCreateInfo>
  {
    using Type = PipelineDynamicStateCreateInfo;
  };

  struct GraphicsPipelineCreateInfo
  {
    using NativeType = VkGraphicsPipelineCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eGraphicsPipelineCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 GraphicsPipelineCreateInfo( VULKAN_HPP_NAMESPACE::PipelineCreateFlags                          flags_               = {},
                                                        uint32_t                                                           stageCount_          = {},
                                                        const VULKAN_HPP_NAMESPACE::PipelineShaderStageCreateInfo *        pStages_             = {},
                                                        const VULKAN_HPP_NAMESPACE::PipelineVertexInputStateCreateInfo *   pVertexInputState_   = {},
                                                        const VULKAN_HPP_NAMESPACE::PipelineInputAssemblyStateCreateInfo * pInputAssemblyState_ = {},
                                                        const VULKAN_HPP_NAMESPACE::PipelineTessellationStateCreateInfo *  pTessellationState_  = {},
                                                        const VULKAN_HPP_NAMESPACE::PipelineViewportStateCreateInfo *      pViewportState_      = {},
                                                        const VULKAN_HPP_NAMESPACE::PipelineRasterizationStateCreateInfo * pRasterizationState_ = {},
                                                        const VULKAN_HPP_NAMESPACE::PipelineMultisampleStateCreateInfo *   pMultisampleState_   = {},
                                                        const VULKAN_HPP_NAMESPACE::PipelineDepthStencilStateCreateInfo *  pDepthStencilState_  = {},
                                                        const VULKAN_HPP_NAMESPACE::PipelineColorBlendStateCreateInfo *    pColorBlendState_    = {},
                                                        const VULKAN_HPP_NAMESPACE::PipelineDynamicStateCreateInfo *       pDynamicState_       = {},
                                                        VULKAN_HPP_NAMESPACE::PipelineLayout                               layout_              = {},
                                                        VULKAN_HPP_NAMESPACE::RenderPass                                   renderPass_          = {},
                                                        uint32_t                                                           subpass_             = {},
                                                        VULKAN_HPP_NAMESPACE::Pipeline                                     basePipelineHandle_  = {},
                                                        int32_t                                                            basePipelineIndex_   = {},
                                                        const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , stageCount{ stageCount_ }
      , pStages{ pStages_ }
      , pVertexInputState{ pVertexInputState_ }
      , pInputAssemblyState{ pInputAssemblyState_ }
      , pTessellationState{ pTessellationState_ }
      , pViewportState{ pViewportState_ }
      , pRasterizationState{ pRasterizationState_ }
      , pMultisampleState{ pMultisampleState_ }
      , pDepthStencilState{ pDepthStencilState_ }
      , pColorBlendState{ pColorBlendState_ }
      , pDynamicState{ pDynamicState_ }
      , layout{ layout_ }
      , renderPass{ renderPass_ }
      , subpass{ subpass_ }
      , basePipelineHandle{ basePipelineHandle_ }
      , basePipelineIndex{ basePipelineIndex_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14 GraphicsPipelineCreateInfo( GraphicsPipelineCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    GraphicsPipelineCreateInfo( VkGraphicsPipelineCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : GraphicsPipelineCreateInfo( *reinterpret_cast<GraphicsPipelineCreateInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    GraphicsPipelineCreateInfo( VULKAN_HPP_NAMESPACE::PipelineCreateFlags                                                                        flags_,
                                VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::PipelineShaderStageCreateInfo> const & stages_,
                                const VULKAN_HPP_NAMESPACE::PipelineVertexInputStateCreateInfo *   pVertexInputState_   = {},
                                const VULKAN_HPP_NAMESPACE::PipelineInputAssemblyStateCreateInfo * pInputAssemblyState_ = {},
                                const VULKAN_HPP_NAMESPACE::PipelineTessellationStateCreateInfo *  pTessellationState_  = {},
                                const VULKAN_HPP_NAMESPACE::PipelineViewportStateCreateInfo *      pViewportState_      = {},
                                const VULKAN_HPP_NAMESPACE::PipelineRasterizationStateCreateInfo * pRasterizationState_ = {},
                                const VULKAN_HPP_NAMESPACE::PipelineMultisampleStateCreateInfo *   pMultisampleState_   = {},
                                const VULKAN_HPP_NAMESPACE::PipelineDepthStencilStateCreateInfo *  pDepthStencilState_  = {},
                                const VULKAN_HPP_NAMESPACE::PipelineColorBlendStateCreateInfo *    pColorBlendState_    = {},
                                const VULKAN_HPP_NAMESPACE::PipelineDynamicStateCreateInfo *       pDynamicState_       = {},
                                VULKAN_HPP_NAMESPACE::PipelineLayout                               layout_              = {},
                                VULKAN_HPP_NAMESPACE::RenderPass                                   renderPass_          = {},
                                uint32_t                                                           subpass_             = {},
                                VULKAN_HPP_NAMESPACE::Pipeline                                     basePipelineHandle_  = {},
                                int32_t                                                            basePipelineIndex_   = {},
                                const void *                                                       pNext_               = nullptr )
      : pNext( pNext_ )
      , flags( flags_ )
      , stageCount( static_cast<uint32_t>( stages_.size() ) )
      , pStages( stages_.data() )
      , pVertexInputState( pVertexInputState_ )
      , pInputAssemblyState( pInputAssemblyState_ )
      , pTessellationState( pTessellationState_ )
      , pViewportState( pViewportState_ )
      , pRasterizationState( pRasterizationState_ )
      , pMultisampleState( pMultisampleState_ )
      , pDepthStencilState( pDepthStencilState_ )
      , pColorBlendState( pColorBlendState_ )
      , pDynamicState( pDynamicState_ )
      , layout( layout_ )
      , renderPass( renderPass_ )
      , subpass( subpass_ )
      , basePipelineHandle( basePipelineHandle_ )
      , basePipelineIndex( basePipelineIndex_ )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    GraphicsPipelineCreateInfo & operator=( GraphicsPipelineCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    GraphicsPipelineCreateInfo & operator=( VkGraphicsPipelineCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::GraphicsPipelineCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 GraphicsPipelineCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GraphicsPipelineCreateInfo & setFlags( VULKAN_HPP_NAMESPACE::PipelineCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GraphicsPipelineCreateInfo & setStageCount( uint32_t stageCount_ ) VULKAN_HPP_NOEXCEPT
    {
      stageCount = stageCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GraphicsPipelineCreateInfo & setPStages( const VULKAN_HPP_NAMESPACE::PipelineShaderStageCreateInfo * pStages_ ) VULKAN_HPP_NOEXCEPT
    {
      pStages = pStages_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    GraphicsPipelineCreateInfo &
      setStages( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::PipelineShaderStageCreateInfo> const & stages_ ) VULKAN_HPP_NOEXCEPT
    {
      stageCount = static_cast<uint32_t>( stages_.size() );
      pStages    = stages_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 GraphicsPipelineCreateInfo &
      setPVertexInputState( const VULKAN_HPP_NAMESPACE::PipelineVertexInputStateCreateInfo * pVertexInputState_ ) VULKAN_HPP_NOEXCEPT
    {
      pVertexInputState = pVertexInputState_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GraphicsPipelineCreateInfo &
      setPInputAssemblyState( const VULKAN_HPP_NAMESPACE::PipelineInputAssemblyStateCreateInfo * pInputAssemblyState_ ) VULKAN_HPP_NOEXCEPT
    {
      pInputAssemblyState = pInputAssemblyState_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GraphicsPipelineCreateInfo &
      setPTessellationState( const VULKAN_HPP_NAMESPACE::PipelineTessellationStateCreateInfo * pTessellationState_ ) VULKAN_HPP_NOEXCEPT
    {
      pTessellationState = pTessellationState_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GraphicsPipelineCreateInfo &
      setPViewportState( const VULKAN_HPP_NAMESPACE::PipelineViewportStateCreateInfo * pViewportState_ ) VULKAN_HPP_NOEXCEPT
    {
      pViewportState = pViewportState_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GraphicsPipelineCreateInfo &
      setPRasterizationState( const VULKAN_HPP_NAMESPACE::PipelineRasterizationStateCreateInfo * pRasterizationState_ ) VULKAN_HPP_NOEXCEPT
    {
      pRasterizationState = pRasterizationState_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GraphicsPipelineCreateInfo &
      setPMultisampleState( const VULKAN_HPP_NAMESPACE::PipelineMultisampleStateCreateInfo * pMultisampleState_ ) VULKAN_HPP_NOEXCEPT
    {
      pMultisampleState = pMultisampleState_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GraphicsPipelineCreateInfo &
      setPDepthStencilState( const VULKAN_HPP_NAMESPACE::PipelineDepthStencilStateCreateInfo * pDepthStencilState_ ) VULKAN_HPP_NOEXCEPT
    {
      pDepthStencilState = pDepthStencilState_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GraphicsPipelineCreateInfo &
      setPColorBlendState( const VULKAN_HPP_NAMESPACE::PipelineColorBlendStateCreateInfo * pColorBlendState_ ) VULKAN_HPP_NOEXCEPT
    {
      pColorBlendState = pColorBlendState_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GraphicsPipelineCreateInfo &
      setPDynamicState( const VULKAN_HPP_NAMESPACE::PipelineDynamicStateCreateInfo * pDynamicState_ ) VULKAN_HPP_NOEXCEPT
    {
      pDynamicState = pDynamicState_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GraphicsPipelineCreateInfo & setLayout( VULKAN_HPP_NAMESPACE::PipelineLayout layout_ ) VULKAN_HPP_NOEXCEPT
    {
      layout = layout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GraphicsPipelineCreateInfo & setRenderPass( VULKAN_HPP_NAMESPACE::RenderPass renderPass_ ) VULKAN_HPP_NOEXCEPT
    {
      renderPass = renderPass_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GraphicsPipelineCreateInfo & setSubpass( uint32_t subpass_ ) VULKAN_HPP_NOEXCEPT
    {
      subpass = subpass_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GraphicsPipelineCreateInfo & setBasePipelineHandle( VULKAN_HPP_NAMESPACE::Pipeline basePipelineHandle_ ) VULKAN_HPP_NOEXCEPT
    {
      basePipelineHandle = basePipelineHandle_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GraphicsPipelineCreateInfo & setBasePipelineIndex( int32_t basePipelineIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      basePipelineIndex = basePipelineIndex_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkGraphicsPipelineCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkGraphicsPipelineCreateInfo *>( this );
    }

    operator VkGraphicsPipelineCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkGraphicsPipelineCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::PipelineCreateFlags const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::PipelineShaderStageCreateInfo * const &,
               const VULKAN_HPP_NAMESPACE::PipelineVertexInputStateCreateInfo * const &,
               const VULKAN_HPP_NAMESPACE::PipelineInputAssemblyStateCreateInfo * const &,
               const VULKAN_HPP_NAMESPACE::PipelineTessellationStateCreateInfo * const &,
               const VULKAN_HPP_NAMESPACE::PipelineViewportStateCreateInfo * const &,
               const VULKAN_HPP_NAMESPACE::PipelineRasterizationStateCreateInfo * const &,
               const VULKAN_HPP_NAMESPACE::PipelineMultisampleStateCreateInfo * const &,
               const VULKAN_HPP_NAMESPACE::PipelineDepthStencilStateCreateInfo * const &,
               const VULKAN_HPP_NAMESPACE::PipelineColorBlendStateCreateInfo * const &,
               const VULKAN_HPP_NAMESPACE::PipelineDynamicStateCreateInfo * const &,
               VULKAN_HPP_NAMESPACE::PipelineLayout const &,
               VULKAN_HPP_NAMESPACE::RenderPass const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::Pipeline const &,
               int32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType,
                       pNext,
                       flags,
                       stageCount,
                       pStages,
                       pVertexInputState,
                       pInputAssemblyState,
                       pTessellationState,
                       pViewportState,
                       pRasterizationState,
                       pMultisampleState,
                       pDepthStencilState,
                       pColorBlendState,
                       pDynamicState,
                       layout,
                       renderPass,
                       subpass,
                       basePipelineHandle,
                       basePipelineIndex );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( GraphicsPipelineCreateInfo const & ) const = default;
#else
    bool operator==( GraphicsPipelineCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( stageCount == rhs.stageCount ) && ( pStages == rhs.pStages ) &&
             ( pVertexInputState == rhs.pVertexInputState ) && ( pInputAssemblyState == rhs.pInputAssemblyState ) &&
             ( pTessellationState == rhs.pTessellationState ) && ( pViewportState == rhs.pViewportState ) &&
             ( pRasterizationState == rhs.pRasterizationState ) && ( pMultisampleState == rhs.pMultisampleState ) &&
             ( pDepthStencilState == rhs.pDepthStencilState ) && ( pColorBlendState == rhs.pColorBlendState ) && ( pDynamicState == rhs.pDynamicState ) &&
             ( layout == rhs.layout ) && ( renderPass == rhs.renderPass ) && ( subpass == rhs.subpass ) && ( basePipelineHandle == rhs.basePipelineHandle ) &&
             ( basePipelineIndex == rhs.basePipelineIndex );
#  endif
    }

    bool operator!=( GraphicsPipelineCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                                sType               = StructureType::eGraphicsPipelineCreateInfo;
    const void *                                                       pNext               = {};
    VULKAN_HPP_NAMESPACE::PipelineCreateFlags                          flags               = {};
    uint32_t                                                           stageCount          = {};
    const VULKAN_HPP_NAMESPACE::PipelineShaderStageCreateInfo *        pStages             = {};
    const VULKAN_HPP_NAMESPACE::PipelineVertexInputStateCreateInfo *   pVertexInputState   = {};
    const VULKAN_HPP_NAMESPACE::PipelineInputAssemblyStateCreateInfo * pInputAssemblyState = {};
    const VULKAN_HPP_NAMESPACE::PipelineTessellationStateCreateInfo *  pTessellationState  = {};
    const VULKAN_HPP_NAMESPACE::PipelineViewportStateCreateInfo *      pViewportState      = {};
    const VULKAN_HPP_NAMESPACE::PipelineRasterizationStateCreateInfo * pRasterizationState = {};
    const VULKAN_HPP_NAMESPACE::PipelineMultisampleStateCreateInfo *   pMultisampleState   = {};
    const VULKAN_HPP_NAMESPACE::PipelineDepthStencilStateCreateInfo *  pDepthStencilState  = {};
    const VULKAN_HPP_NAMESPACE::PipelineColorBlendStateCreateInfo *    pColorBlendState    = {};
    const VULKAN_HPP_NAMESPACE::PipelineDynamicStateCreateInfo *       pDynamicState       = {};
    VULKAN_HPP_NAMESPACE::PipelineLayout                               layout              = {};
    VULKAN_HPP_NAMESPACE::RenderPass                                   renderPass          = {};
    uint32_t                                                           subpass             = {};
    VULKAN_HPP_NAMESPACE::Pipeline                                     basePipelineHandle  = {};
    int32_t                                                            basePipelineIndex   = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eGraphicsPipelineCreateInfo>
  {
    using Type = GraphicsPipelineCreateInfo;
  };

  struct XYColorEXT
  {
    using NativeType = VkXYColorEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR XYColorEXT( float x_ = {}, float y_ = {} ) VULKAN_HPP_NOEXCEPT
      : x{ x_ }
      , y{ y_ }
    {
    }

    VULKAN_HPP_CONSTEXPR XYColorEXT( XYColorEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    XYColorEXT( VkXYColorEXT const & rhs ) VULKAN_HPP_NOEXCEPT : XYColorEXT( *reinterpret_cast<XYColorEXT const *>( &rhs ) ) {}

    XYColorEXT & operator=( XYColorEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    XYColorEXT & operator=( VkXYColorEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::XYColorEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 XYColorEXT & setX( float x_ ) VULKAN_HPP_NOEXCEPT
    {
      x = x_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 XYColorEXT & setY( float y_ ) VULKAN_HPP_NOEXCEPT
    {
      y = y_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkXYColorEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkXYColorEXT *>( this );
    }

    operator VkXYColorEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkXYColorEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<float const &, float const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( x, y );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( XYColorEXT const & ) const = default;
#else
    bool operator==( XYColorEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( x == rhs.x ) && ( y == rhs.y );
#  endif
    }

    bool operator!=( XYColorEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    float x = {};
    float y = {};
  };

  struct HdrMetadataEXT
  {
    using NativeType = VkHdrMetadataEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eHdrMetadataEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR HdrMetadataEXT( VULKAN_HPP_NAMESPACE::XYColorEXT displayPrimaryRed_         = {},
                                         VULKAN_HPP_NAMESPACE::XYColorEXT displayPrimaryGreen_       = {},
                                         VULKAN_HPP_NAMESPACE::XYColorEXT displayPrimaryBlue_        = {},
                                         VULKAN_HPP_NAMESPACE::XYColorEXT whitePoint_                = {},
                                         float                            maxLuminance_              = {},
                                         float                            minLuminance_              = {},
                                         float                            maxContentLightLevel_      = {},
                                         float                            maxFrameAverageLightLevel_ = {},
                                         const void *                     pNext_                     = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , displayPrimaryRed{ displayPrimaryRed_ }
      , displayPrimaryGreen{ displayPrimaryGreen_ }
      , displayPrimaryBlue{ displayPrimaryBlue_ }
      , whitePoint{ whitePoint_ }
      , maxLuminance{ maxLuminance_ }
      , minLuminance{ minLuminance_ }
      , maxContentLightLevel{ maxContentLightLevel_ }
      , maxFrameAverageLightLevel{ maxFrameAverageLightLevel_ }
    {
    }

    VULKAN_HPP_CONSTEXPR HdrMetadataEXT( HdrMetadataEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    HdrMetadataEXT( VkHdrMetadataEXT const & rhs ) VULKAN_HPP_NOEXCEPT : HdrMetadataEXT( *reinterpret_cast<HdrMetadataEXT const *>( &rhs ) ) {}

    HdrMetadataEXT & operator=( HdrMetadataEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    HdrMetadataEXT & operator=( VkHdrMetadataEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::HdrMetadataEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 HdrMetadataEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 HdrMetadataEXT & setDisplayPrimaryRed( VULKAN_HPP_NAMESPACE::XYColorEXT const & displayPrimaryRed_ ) VULKAN_HPP_NOEXCEPT
    {
      displayPrimaryRed = displayPrimaryRed_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 HdrMetadataEXT & setDisplayPrimaryGreen( VULKAN_HPP_NAMESPACE::XYColorEXT const & displayPrimaryGreen_ ) VULKAN_HPP_NOEXCEPT
    {
      displayPrimaryGreen = displayPrimaryGreen_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 HdrMetadataEXT & setDisplayPrimaryBlue( VULKAN_HPP_NAMESPACE::XYColorEXT const & displayPrimaryBlue_ ) VULKAN_HPP_NOEXCEPT
    {
      displayPrimaryBlue = displayPrimaryBlue_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 HdrMetadataEXT & setWhitePoint( VULKAN_HPP_NAMESPACE::XYColorEXT const & whitePoint_ ) VULKAN_HPP_NOEXCEPT
    {
      whitePoint = whitePoint_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 HdrMetadataEXT & setMaxLuminance( float maxLuminance_ ) VULKAN_HPP_NOEXCEPT
    {
      maxLuminance = maxLuminance_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 HdrMetadataEXT & setMinLuminance( float minLuminance_ ) VULKAN_HPP_NOEXCEPT
    {
      minLuminance = minLuminance_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 HdrMetadataEXT & setMaxContentLightLevel( float maxContentLightLevel_ ) VULKAN_HPP_NOEXCEPT
    {
      maxContentLightLevel = maxContentLightLevel_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 HdrMetadataEXT & setMaxFrameAverageLightLevel( float maxFrameAverageLightLevel_ ) VULKAN_HPP_NOEXCEPT
    {
      maxFrameAverageLightLevel = maxFrameAverageLightLevel_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkHdrMetadataEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkHdrMetadataEXT *>( this );
    }

    operator VkHdrMetadataEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkHdrMetadataEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::XYColorEXT const &,
               VULKAN_HPP_NAMESPACE::XYColorEXT const &,
               VULKAN_HPP_NAMESPACE::XYColorEXT const &,
               VULKAN_HPP_NAMESPACE::XYColorEXT const &,
               float const &,
               float const &,
               float const &,
               float const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType,
                       pNext,
                       displayPrimaryRed,
                       displayPrimaryGreen,
                       displayPrimaryBlue,
                       whitePoint,
                       maxLuminance,
                       minLuminance,
                       maxContentLightLevel,
                       maxFrameAverageLightLevel );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( HdrMetadataEXT const & ) const = default;
#else
    bool operator==( HdrMetadataEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( displayPrimaryRed == rhs.displayPrimaryRed ) &&
             ( displayPrimaryGreen == rhs.displayPrimaryGreen ) && ( displayPrimaryBlue == rhs.displayPrimaryBlue ) && ( whitePoint == rhs.whitePoint ) &&
             ( maxLuminance == rhs.maxLuminance ) && ( minLuminance == rhs.minLuminance ) && ( maxContentLightLevel == rhs.maxContentLightLevel ) &&
             ( maxFrameAverageLightLevel == rhs.maxFrameAverageLightLevel );
#  endif
    }

    bool operator!=( HdrMetadataEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType                     = StructureType::eHdrMetadataEXT;
    const void *                        pNext                     = {};
    VULKAN_HPP_NAMESPACE::XYColorEXT    displayPrimaryRed         = {};
    VULKAN_HPP_NAMESPACE::XYColorEXT    displayPrimaryGreen       = {};
    VULKAN_HPP_NAMESPACE::XYColorEXT    displayPrimaryBlue        = {};
    VULKAN_HPP_NAMESPACE::XYColorEXT    whitePoint                = {};
    float                               maxLuminance              = {};
    float                               minLuminance              = {};
    float                               maxContentLightLevel      = {};
    float                               maxFrameAverageLightLevel = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eHdrMetadataEXT>
  {
    using Type = HdrMetadataEXT;
  };

  struct HeadlessSurfaceCreateInfoEXT
  {
    using NativeType = VkHeadlessSurfaceCreateInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eHeadlessSurfaceCreateInfoEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR HeadlessSurfaceCreateInfoEXT( VULKAN_HPP_NAMESPACE::HeadlessSurfaceCreateFlagsEXT flags_ = {},
                                                       const void *                                        pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
    {
    }

    VULKAN_HPP_CONSTEXPR HeadlessSurfaceCreateInfoEXT( HeadlessSurfaceCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    HeadlessSurfaceCreateInfoEXT( VkHeadlessSurfaceCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : HeadlessSurfaceCreateInfoEXT( *reinterpret_cast<HeadlessSurfaceCreateInfoEXT const *>( &rhs ) )
    {
    }

    HeadlessSurfaceCreateInfoEXT & operator=( HeadlessSurfaceCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    HeadlessSurfaceCreateInfoEXT & operator=( VkHeadlessSurfaceCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::HeadlessSurfaceCreateInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 HeadlessSurfaceCreateInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 HeadlessSurfaceCreateInfoEXT & setFlags( VULKAN_HPP_NAMESPACE::HeadlessSurfaceCreateFlagsEXT flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkHeadlessSurfaceCreateInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkHeadlessSurfaceCreateInfoEXT *>( this );
    }

    operator VkHeadlessSurfaceCreateInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkHeadlessSurfaceCreateInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::HeadlessSurfaceCreateFlagsEXT const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( HeadlessSurfaceCreateInfoEXT const & ) const = default;
#else
    bool operator==( HeadlessSurfaceCreateInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags );
#  endif
    }

    bool operator!=( HeadlessSurfaceCreateInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                 sType = StructureType::eHeadlessSurfaceCreateInfoEXT;
    const void *                                        pNext = {};
    VULKAN_HPP_NAMESPACE::HeadlessSurfaceCreateFlagsEXT flags = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eHeadlessSurfaceCreateInfoEXT>
  {
    using Type = HeadlessSurfaceCreateInfoEXT;
  };

  struct ImageBlit
  {
    using NativeType = VkImageBlit;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 ImageBlit( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers          srcSubresource_ = {},
                                       std::array<VULKAN_HPP_NAMESPACE::Offset3D, 2> const & srcOffsets_     = {},
                                       VULKAN_HPP_NAMESPACE::ImageSubresourceLayers          dstSubresource_ = {},
                                       std::array<VULKAN_HPP_NAMESPACE::Offset3D, 2> const & dstOffsets_     = {} ) VULKAN_HPP_NOEXCEPT
      : srcSubresource{ srcSubresource_ }
      , srcOffsets{ srcOffsets_ }
      , dstSubresource{ dstSubresource_ }
      , dstOffsets{ dstOffsets_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14 ImageBlit( ImageBlit const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageBlit( VkImageBlit const & rhs ) VULKAN_HPP_NOEXCEPT : ImageBlit( *reinterpret_cast<ImageBlit const *>( &rhs ) ) {}

    ImageBlit & operator=( ImageBlit const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ImageBlit & operator=( VkImageBlit const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ImageBlit const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ImageBlit & setSrcSubresource( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const & srcSubresource_ ) VULKAN_HPP_NOEXCEPT
    {
      srcSubresource = srcSubresource_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageBlit & setSrcOffsets( std::array<VULKAN_HPP_NAMESPACE::Offset3D, 2> const & srcOffsets_ ) VULKAN_HPP_NOEXCEPT
    {
      srcOffsets = srcOffsets_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageBlit & setDstSubresource( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const & dstSubresource_ ) VULKAN_HPP_NOEXCEPT
    {
      dstSubresource = dstSubresource_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageBlit & setDstOffsets( std::array<VULKAN_HPP_NAMESPACE::Offset3D, 2> const & dstOffsets_ ) VULKAN_HPP_NOEXCEPT
    {
      dstOffsets = dstOffsets_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkImageBlit const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkImageBlit *>( this );
    }

    operator VkImageBlit &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkImageBlit *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const &,
               VULKAN_HPP_NAMESPACE::ArrayWrapper1D<VULKAN_HPP_NAMESPACE::Offset3D, 2> const &,
               VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const &,
               VULKAN_HPP_NAMESPACE::ArrayWrapper1D<VULKAN_HPP_NAMESPACE::Offset3D, 2> const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( srcSubresource, srcOffsets, dstSubresource, dstOffsets );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ImageBlit const & ) const = default;
#else
    bool operator==( ImageBlit const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( srcSubresource == rhs.srcSubresource ) && ( srcOffsets == rhs.srcOffsets ) && ( dstSubresource == rhs.dstSubresource ) &&
             ( dstOffsets == rhs.dstOffsets );
#  endif
    }

    bool operator!=( ImageBlit const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::ImageSubresourceLayers                            srcSubresource = {};
    VULKAN_HPP_NAMESPACE::ArrayWrapper1D<VULKAN_HPP_NAMESPACE::Offset3D, 2> srcOffsets     = {};
    VULKAN_HPP_NAMESPACE::ImageSubresourceLayers                            dstSubresource = {};
    VULKAN_HPP_NAMESPACE::ArrayWrapper1D<VULKAN_HPP_NAMESPACE::Offset3D, 2> dstOffsets     = {};
  };

  struct ImageCopy
  {
    using NativeType = VkImageCopy;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ImageCopy( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers srcSubresource_ = {},
                                    VULKAN_HPP_NAMESPACE::Offset3D               srcOffset_      = {},
                                    VULKAN_HPP_NAMESPACE::ImageSubresourceLayers dstSubresource_ = {},
                                    VULKAN_HPP_NAMESPACE::Offset3D               dstOffset_      = {},
                                    VULKAN_HPP_NAMESPACE::Extent3D               extent_         = {} ) VULKAN_HPP_NOEXCEPT
      : srcSubresource{ srcSubresource_ }
      , srcOffset{ srcOffset_ }
      , dstSubresource{ dstSubresource_ }
      , dstOffset{ dstOffset_ }
      , extent{ extent_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ImageCopy( ImageCopy const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageCopy( VkImageCopy const & rhs ) VULKAN_HPP_NOEXCEPT : ImageCopy( *reinterpret_cast<ImageCopy const *>( &rhs ) ) {}

    ImageCopy & operator=( ImageCopy const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ImageCopy & operator=( VkImageCopy const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ImageCopy const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ImageCopy & setSrcSubresource( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const & srcSubresource_ ) VULKAN_HPP_NOEXCEPT
    {
      srcSubresource = srcSubresource_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageCopy & setSrcOffset( VULKAN_HPP_NAMESPACE::Offset3D const & srcOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      srcOffset = srcOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageCopy & setDstSubresource( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const & dstSubresource_ ) VULKAN_HPP_NOEXCEPT
    {
      dstSubresource = dstSubresource_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageCopy & setDstOffset( VULKAN_HPP_NAMESPACE::Offset3D const & dstOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      dstOffset = dstOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageCopy & setExtent( VULKAN_HPP_NAMESPACE::Extent3D const & extent_ ) VULKAN_HPP_NOEXCEPT
    {
      extent = extent_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkImageCopy const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkImageCopy *>( this );
    }

    operator VkImageCopy &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkImageCopy *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const &,
               VULKAN_HPP_NAMESPACE::Offset3D const &,
               VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const &,
               VULKAN_HPP_NAMESPACE::Offset3D const &,
               VULKAN_HPP_NAMESPACE::Extent3D const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( srcSubresource, srcOffset, dstSubresource, dstOffset, extent );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ImageCopy const & ) const = default;
#else
    bool operator==( ImageCopy const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( srcSubresource == rhs.srcSubresource ) && ( srcOffset == rhs.srcOffset ) && ( dstSubresource == rhs.dstSubresource ) &&
             ( dstOffset == rhs.dstOffset ) && ( extent == rhs.extent );
#  endif
    }

    bool operator!=( ImageCopy const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::ImageSubresourceLayers srcSubresource = {};
    VULKAN_HPP_NAMESPACE::Offset3D               srcOffset      = {};
    VULKAN_HPP_NAMESPACE::ImageSubresourceLayers dstSubresource = {};
    VULKAN_HPP_NAMESPACE::Offset3D               dstOffset      = {};
    VULKAN_HPP_NAMESPACE::Extent3D               extent         = {};
  };

  struct SubresourceLayout
  {
    using NativeType = VkSubresourceLayout;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR SubresourceLayout( VULKAN_HPP_NAMESPACE::DeviceSize offset_     = {},
                                            VULKAN_HPP_NAMESPACE::DeviceSize size_       = {},
                                            VULKAN_HPP_NAMESPACE::DeviceSize rowPitch_   = {},
                                            VULKAN_HPP_NAMESPACE::DeviceSize arrayPitch_ = {},
                                            VULKAN_HPP_NAMESPACE::DeviceSize depthPitch_ = {} ) VULKAN_HPP_NOEXCEPT
      : offset{ offset_ }
      , size{ size_ }
      , rowPitch{ rowPitch_ }
      , arrayPitch{ arrayPitch_ }
      , depthPitch{ depthPitch_ }
    {
    }

    VULKAN_HPP_CONSTEXPR SubresourceLayout( SubresourceLayout const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SubresourceLayout( VkSubresourceLayout const & rhs ) VULKAN_HPP_NOEXCEPT : SubresourceLayout( *reinterpret_cast<SubresourceLayout const *>( &rhs ) ) {}

    SubresourceLayout & operator=( SubresourceLayout const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    SubresourceLayout & operator=( VkSubresourceLayout const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::SubresourceLayout const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 SubresourceLayout & setOffset( VULKAN_HPP_NAMESPACE::DeviceSize offset_ ) VULKAN_HPP_NOEXCEPT
    {
      offset = offset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SubresourceLayout & setSize( VULKAN_HPP_NAMESPACE::DeviceSize size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SubresourceLayout & setRowPitch( VULKAN_HPP_NAMESPACE::DeviceSize rowPitch_ ) VULKAN_HPP_NOEXCEPT
    {
      rowPitch = rowPitch_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SubresourceLayout & setArrayPitch( VULKAN_HPP_NAMESPACE::DeviceSize arrayPitch_ ) VULKAN_HPP_NOEXCEPT
    {
      arrayPitch = arrayPitch_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SubresourceLayout & setDepthPitch( VULKAN_HPP_NAMESPACE::DeviceSize depthPitch_ ) VULKAN_HPP_NOEXCEPT
    {
      depthPitch = depthPitch_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkSubresourceLayout const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkSubresourceLayout *>( this );
    }

    operator VkSubresourceLayout &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkSubresourceLayout *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( offset, size, rowPitch, arrayPitch, depthPitch );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( SubresourceLayout const & ) const = default;
#else
    bool operator==( SubresourceLayout const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( offset == rhs.offset ) && ( size == rhs.size ) && ( rowPitch == rhs.rowPitch ) && ( arrayPitch == rhs.arrayPitch ) &&
             ( depthPitch == rhs.depthPitch );
#  endif
    }

    bool operator!=( SubresourceLayout const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::DeviceSize offset     = {};
    VULKAN_HPP_NAMESPACE::DeviceSize size       = {};
    VULKAN_HPP_NAMESPACE::DeviceSize rowPitch   = {};
    VULKAN_HPP_NAMESPACE::DeviceSize arrayPitch = {};
    VULKAN_HPP_NAMESPACE::DeviceSize depthPitch = {};
  };

  struct ImageDrmFormatModifierExplicitCreateInfoEXT
  {
    using NativeType = VkImageDrmFormatModifierExplicitCreateInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eImageDrmFormatModifierExplicitCreateInfoEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ImageDrmFormatModifierExplicitCreateInfoEXT( uint64_t                                        drmFormatModifier_           = {},
                                                                      uint32_t                                        drmFormatModifierPlaneCount_ = {},
                                                                      const VULKAN_HPP_NAMESPACE::SubresourceLayout * pPlaneLayouts_               = {},
                                                                      const void *                                    pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , drmFormatModifier{ drmFormatModifier_ }
      , drmFormatModifierPlaneCount{ drmFormatModifierPlaneCount_ }
      , pPlaneLayouts{ pPlaneLayouts_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ImageDrmFormatModifierExplicitCreateInfoEXT( ImageDrmFormatModifierExplicitCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageDrmFormatModifierExplicitCreateInfoEXT( VkImageDrmFormatModifierExplicitCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : ImageDrmFormatModifierExplicitCreateInfoEXT( *reinterpret_cast<ImageDrmFormatModifierExplicitCreateInfoEXT const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    ImageDrmFormatModifierExplicitCreateInfoEXT(
      uint64_t                                                                                             drmFormatModifier_,
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SubresourceLayout> const & planeLayouts_,
      const void *                                                                                         pNext_ = nullptr )
      : pNext( pNext_ )
      , drmFormatModifier( drmFormatModifier_ )
      , drmFormatModifierPlaneCount( static_cast<uint32_t>( planeLayouts_.size() ) )
      , pPlaneLayouts( planeLayouts_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    ImageDrmFormatModifierExplicitCreateInfoEXT & operator=( ImageDrmFormatModifierExplicitCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ImageDrmFormatModifierExplicitCreateInfoEXT & operator=( VkImageDrmFormatModifierExplicitCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ImageDrmFormatModifierExplicitCreateInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ImageDrmFormatModifierExplicitCreateInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageDrmFormatModifierExplicitCreateInfoEXT & setDrmFormatModifier( uint64_t drmFormatModifier_ ) VULKAN_HPP_NOEXCEPT
    {
      drmFormatModifier = drmFormatModifier_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageDrmFormatModifierExplicitCreateInfoEXT &
      setDrmFormatModifierPlaneCount( uint32_t drmFormatModifierPlaneCount_ ) VULKAN_HPP_NOEXCEPT
    {
      drmFormatModifierPlaneCount = drmFormatModifierPlaneCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageDrmFormatModifierExplicitCreateInfoEXT &
      setPPlaneLayouts( const VULKAN_HPP_NAMESPACE::SubresourceLayout * pPlaneLayouts_ ) VULKAN_HPP_NOEXCEPT
    {
      pPlaneLayouts = pPlaneLayouts_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    ImageDrmFormatModifierExplicitCreateInfoEXT &
      setPlaneLayouts( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SubresourceLayout> const & planeLayouts_ ) VULKAN_HPP_NOEXCEPT
    {
      drmFormatModifierPlaneCount = static_cast<uint32_t>( planeLayouts_.size() );
      pPlaneLayouts               = planeLayouts_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkImageDrmFormatModifierExplicitCreateInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkImageDrmFormatModifierExplicitCreateInfoEXT *>( this );
    }

    operator VkImageDrmFormatModifierExplicitCreateInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkImageDrmFormatModifierExplicitCreateInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               uint64_t const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::SubresourceLayout * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, drmFormatModifier, drmFormatModifierPlaneCount, pPlaneLayouts );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ImageDrmFormatModifierExplicitCreateInfoEXT const & ) const = default;
#else
    bool operator==( ImageDrmFormatModifierExplicitCreateInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( drmFormatModifier == rhs.drmFormatModifier ) &&
             ( drmFormatModifierPlaneCount == rhs.drmFormatModifierPlaneCount ) && ( pPlaneLayouts == rhs.pPlaneLayouts );
#  endif
    }

    bool operator!=( ImageDrmFormatModifierExplicitCreateInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType             sType                       = StructureType::eImageDrmFormatModifierExplicitCreateInfoEXT;
    const void *                                    pNext                       = {};
    uint64_t                                        drmFormatModifier           = {};
    uint32_t                                        drmFormatModifierPlaneCount = {};
    const VULKAN_HPP_NAMESPACE::SubresourceLayout * pPlaneLayouts               = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eImageDrmFormatModifierExplicitCreateInfoEXT>
  {
    using Type = ImageDrmFormatModifierExplicitCreateInfoEXT;
  };

  struct ImageDrmFormatModifierListCreateInfoEXT
  {
    using NativeType = VkImageDrmFormatModifierListCreateInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eImageDrmFormatModifierListCreateInfoEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ImageDrmFormatModifierListCreateInfoEXT( uint32_t         drmFormatModifierCount_ = {},
                                                                  const uint64_t * pDrmFormatModifiers_    = {},
                                                                  const void *     pNext_                  = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , drmFormatModifierCount{ drmFormatModifierCount_ }
      , pDrmFormatModifiers{ pDrmFormatModifiers_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ImageDrmFormatModifierListCreateInfoEXT( ImageDrmFormatModifierListCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageDrmFormatModifierListCreateInfoEXT( VkImageDrmFormatModifierListCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : ImageDrmFormatModifierListCreateInfoEXT( *reinterpret_cast<ImageDrmFormatModifierListCreateInfoEXT const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    ImageDrmFormatModifierListCreateInfoEXT( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint64_t> const & drmFormatModifiers_,
                                             const void *                                                          pNext_ = nullptr )
      : pNext( pNext_ ), drmFormatModifierCount( static_cast<uint32_t>( drmFormatModifiers_.size() ) ), pDrmFormatModifiers( drmFormatModifiers_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    ImageDrmFormatModifierListCreateInfoEXT & operator=( ImageDrmFormatModifierListCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ImageDrmFormatModifierListCreateInfoEXT & operator=( VkImageDrmFormatModifierListCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ImageDrmFormatModifierListCreateInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ImageDrmFormatModifierListCreateInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageDrmFormatModifierListCreateInfoEXT & setDrmFormatModifierCount( uint32_t drmFormatModifierCount_ ) VULKAN_HPP_NOEXCEPT
    {
      drmFormatModifierCount = drmFormatModifierCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageDrmFormatModifierListCreateInfoEXT & setPDrmFormatModifiers( const uint64_t * pDrmFormatModifiers_ ) VULKAN_HPP_NOEXCEPT
    {
      pDrmFormatModifiers = pDrmFormatModifiers_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    ImageDrmFormatModifierListCreateInfoEXT &
      setDrmFormatModifiers( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint64_t> const & drmFormatModifiers_ ) VULKAN_HPP_NOEXCEPT
    {
      drmFormatModifierCount = static_cast<uint32_t>( drmFormatModifiers_.size() );
      pDrmFormatModifiers    = drmFormatModifiers_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkImageDrmFormatModifierListCreateInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkImageDrmFormatModifierListCreateInfoEXT *>( this );
    }

    operator VkImageDrmFormatModifierListCreateInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkImageDrmFormatModifierListCreateInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, uint32_t const &, const uint64_t * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, drmFormatModifierCount, pDrmFormatModifiers );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ImageDrmFormatModifierListCreateInfoEXT const & ) const = default;
#else
    bool operator==( ImageDrmFormatModifierListCreateInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( drmFormatModifierCount == rhs.drmFormatModifierCount ) &&
             ( pDrmFormatModifiers == rhs.pDrmFormatModifiers );
#  endif
    }

    bool operator!=( ImageDrmFormatModifierListCreateInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType                  = StructureType::eImageDrmFormatModifierListCreateInfoEXT;
    const void *                        pNext                  = {};
    uint32_t                            drmFormatModifierCount = {};
    const uint64_t *                    pDrmFormatModifiers    = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eImageDrmFormatModifierListCreateInfoEXT>
  {
    using Type = ImageDrmFormatModifierListCreateInfoEXT;
  };

  struct ImageDrmFormatModifierPropertiesEXT
  {
    using NativeType = VkImageDrmFormatModifierPropertiesEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eImageDrmFormatModifierPropertiesEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ImageDrmFormatModifierPropertiesEXT( uint64_t drmFormatModifier_ = {}, void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , drmFormatModifier{ drmFormatModifier_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ImageDrmFormatModifierPropertiesEXT( ImageDrmFormatModifierPropertiesEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageDrmFormatModifierPropertiesEXT( VkImageDrmFormatModifierPropertiesEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : ImageDrmFormatModifierPropertiesEXT( *reinterpret_cast<ImageDrmFormatModifierPropertiesEXT const *>( &rhs ) )
    {
    }

    ImageDrmFormatModifierPropertiesEXT & operator=( ImageDrmFormatModifierPropertiesEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ImageDrmFormatModifierPropertiesEXT & operator=( VkImageDrmFormatModifierPropertiesEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ImageDrmFormatModifierPropertiesEXT const *>( &rhs );
      return *this;
    }

    operator VkImageDrmFormatModifierPropertiesEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkImageDrmFormatModifierPropertiesEXT *>( this );
    }

    operator VkImageDrmFormatModifierPropertiesEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkImageDrmFormatModifierPropertiesEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, void * const &, uint64_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, drmFormatModifier );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ImageDrmFormatModifierPropertiesEXT const & ) const = default;
#else
    bool operator==( ImageDrmFormatModifierPropertiesEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( drmFormatModifier == rhs.drmFormatModifier );
#  endif
    }

    bool operator!=( ImageDrmFormatModifierPropertiesEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType             = StructureType::eImageDrmFormatModifierPropertiesEXT;
    void *                              pNext             = {};
    uint64_t                            drmFormatModifier = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eImageDrmFormatModifierPropertiesEXT>
  {
    using Type = ImageDrmFormatModifierPropertiesEXT;
  };

  struct ImageFormatListCreateInfo
  {
    using NativeType = VkImageFormatListCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eImageFormatListCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ImageFormatListCreateInfo( uint32_t                             viewFormatCount_ = {},
                                                    const VULKAN_HPP_NAMESPACE::Format * pViewFormats_    = {},
                                                    const void *                         pNext_           = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , viewFormatCount{ viewFormatCount_ }
      , pViewFormats{ pViewFormats_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ImageFormatListCreateInfo( ImageFormatListCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageFormatListCreateInfo( VkImageFormatListCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : ImageFormatListCreateInfo( *reinterpret_cast<ImageFormatListCreateInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    ImageFormatListCreateInfo( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::Format> const & viewFormats_,
                               const void *                                                                              pNext_ = nullptr )
      : pNext( pNext_ ), viewFormatCount( static_cast<uint32_t>( viewFormats_.size() ) ), pViewFormats( viewFormats_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    ImageFormatListCreateInfo & operator=( ImageFormatListCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ImageFormatListCreateInfo & operator=( VkImageFormatListCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ImageFormatListCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ImageFormatListCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageFormatListCreateInfo & setViewFormatCount( uint32_t viewFormatCount_ ) VULKAN_HPP_NOEXCEPT
    {
      viewFormatCount = viewFormatCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageFormatListCreateInfo & setPViewFormats( const VULKAN_HPP_NAMESPACE::Format * pViewFormats_ ) VULKAN_HPP_NOEXCEPT
    {
      pViewFormats = pViewFormats_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    ImageFormatListCreateInfo &
      setViewFormats( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::Format> const & viewFormats_ ) VULKAN_HPP_NOEXCEPT
    {
      viewFormatCount = static_cast<uint32_t>( viewFormats_.size() );
      pViewFormats    = viewFormats_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkImageFormatListCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkImageFormatListCreateInfo *>( this );
    }

    operator VkImageFormatListCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkImageFormatListCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, uint32_t const &, const VULKAN_HPP_NAMESPACE::Format * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, viewFormatCount, pViewFormats );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ImageFormatListCreateInfo const & ) const = default;
#else
    bool operator==( ImageFormatListCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( viewFormatCount == rhs.viewFormatCount ) && ( pViewFormats == rhs.pViewFormats );
#  endif
    }

    bool operator!=( ImageFormatListCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType  sType           = StructureType::eImageFormatListCreateInfo;
    const void *                         pNext           = {};
    uint32_t                             viewFormatCount = {};
    const VULKAN_HPP_NAMESPACE::Format * pViewFormats    = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eImageFormatListCreateInfo>
  {
    using Type = ImageFormatListCreateInfo;
  };

  using ImageFormatListCreateInfoKHR = ImageFormatListCreateInfo;

  struct ImageFormatProperties
  {
    using NativeType = VkImageFormatProperties;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ImageFormatProperties( VULKAN_HPP_NAMESPACE::Extent3D         maxExtent_       = {},
                                                uint32_t                               maxMipLevels_    = {},
                                                uint32_t                               maxArrayLayers_  = {},
                                                VULKAN_HPP_NAMESPACE::SampleCountFlags sampleCounts_    = {},
                                                VULKAN_HPP_NAMESPACE::DeviceSize       maxResourceSize_ = {} ) VULKAN_HPP_NOEXCEPT
      : maxExtent{ maxExtent_ }
      , maxMipLevels{ maxMipLevels_ }
      , maxArrayLayers{ maxArrayLayers_ }
      , sampleCounts{ sampleCounts_ }
      , maxResourceSize{ maxResourceSize_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ImageFormatProperties( ImageFormatProperties const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageFormatProperties( VkImageFormatProperties const & rhs ) VULKAN_HPP_NOEXCEPT
      : ImageFormatProperties( *reinterpret_cast<ImageFormatProperties const *>( &rhs ) )
    {
    }

    ImageFormatProperties & operator=( ImageFormatProperties const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ImageFormatProperties & operator=( VkImageFormatProperties const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ImageFormatProperties const *>( &rhs );
      return *this;
    }

    operator VkImageFormatProperties const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkImageFormatProperties *>( this );
    }

    operator VkImageFormatProperties &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkImageFormatProperties *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::Extent3D const &,
               uint32_t const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::SampleCountFlags const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( maxExtent, maxMipLevels, maxArrayLayers, sampleCounts, maxResourceSize );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ImageFormatProperties const & ) const = default;
#else
    bool operator==( ImageFormatProperties const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( maxExtent == rhs.maxExtent ) && ( maxMipLevels == rhs.maxMipLevels ) && ( maxArrayLayers == rhs.maxArrayLayers ) &&
             ( sampleCounts == rhs.sampleCounts ) && ( maxResourceSize == rhs.maxResourceSize );
#  endif
    }

    bool operator!=( ImageFormatProperties const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::Extent3D         maxExtent       = {};
    uint32_t                               maxMipLevels    = {};
    uint32_t                               maxArrayLayers  = {};
    VULKAN_HPP_NAMESPACE::SampleCountFlags sampleCounts    = {};
    VULKAN_HPP_NAMESPACE::DeviceSize       maxResourceSize = {};
  };

  struct ImageFormatProperties2
  {
    using NativeType = VkImageFormatProperties2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eImageFormatProperties2;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ImageFormatProperties2( VULKAN_HPP_NAMESPACE::ImageFormatProperties imageFormatProperties_ = {},
                                                 void *                                      pNext_                 = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , imageFormatProperties{ imageFormatProperties_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ImageFormatProperties2( ImageFormatProperties2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageFormatProperties2( VkImageFormatProperties2 const & rhs ) VULKAN_HPP_NOEXCEPT
      : ImageFormatProperties2( *reinterpret_cast<ImageFormatProperties2 const *>( &rhs ) )
    {
    }

    ImageFormatProperties2 & operator=( ImageFormatProperties2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ImageFormatProperties2 & operator=( VkImageFormatProperties2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ImageFormatProperties2 const *>( &rhs );
      return *this;
    }

    operator VkImageFormatProperties2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkImageFormatProperties2 *>( this );
    }

    operator VkImageFormatProperties2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkImageFormatProperties2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, void * const &, VULKAN_HPP_NAMESPACE::ImageFormatProperties const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, imageFormatProperties );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ImageFormatProperties2 const & ) const = default;
#else
    bool operator==( ImageFormatProperties2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( imageFormatProperties == rhs.imageFormatProperties );
#  endif
    }

    bool operator!=( ImageFormatProperties2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType         sType                 = StructureType::eImageFormatProperties2;
    void *                                      pNext                 = {};
    VULKAN_HPP_NAMESPACE::ImageFormatProperties imageFormatProperties = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eImageFormatProperties2>
  {
    using Type = ImageFormatProperties2;
  };

  using ImageFormatProperties2KHR = ImageFormatProperties2;

  struct ImageMemoryBarrier
  {
    using NativeType = VkImageMemoryBarrier;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eImageMemoryBarrier;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ImageMemoryBarrier( VULKAN_HPP_NAMESPACE::AccessFlags           srcAccessMask_       = {},
                                             VULKAN_HPP_NAMESPACE::AccessFlags           dstAccessMask_       = {},
                                             VULKAN_HPP_NAMESPACE::ImageLayout           oldLayout_           = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                                             VULKAN_HPP_NAMESPACE::ImageLayout           newLayout_           = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                                             uint32_t                                    srcQueueFamilyIndex_ = {},
                                             uint32_t                                    dstQueueFamilyIndex_ = {},
                                             VULKAN_HPP_NAMESPACE::Image                 image_               = {},
                                             VULKAN_HPP_NAMESPACE::ImageSubresourceRange subresourceRange_    = {},
                                             const void *                                pNext_               = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , srcAccessMask{ srcAccessMask_ }
      , dstAccessMask{ dstAccessMask_ }
      , oldLayout{ oldLayout_ }
      , newLayout{ newLayout_ }
      , srcQueueFamilyIndex{ srcQueueFamilyIndex_ }
      , dstQueueFamilyIndex{ dstQueueFamilyIndex_ }
      , image{ image_ }
      , subresourceRange{ subresourceRange_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ImageMemoryBarrier( ImageMemoryBarrier const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageMemoryBarrier( VkImageMemoryBarrier const & rhs ) VULKAN_HPP_NOEXCEPT : ImageMemoryBarrier( *reinterpret_cast<ImageMemoryBarrier const *>( &rhs ) ) {}

    ImageMemoryBarrier & operator=( ImageMemoryBarrier const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ImageMemoryBarrier & operator=( VkImageMemoryBarrier const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ImageMemoryBarrier const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ImageMemoryBarrier & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageMemoryBarrier & setSrcAccessMask( VULKAN_HPP_NAMESPACE::AccessFlags srcAccessMask_ ) VULKAN_HPP_NOEXCEPT
    {
      srcAccessMask = srcAccessMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageMemoryBarrier & setDstAccessMask( VULKAN_HPP_NAMESPACE::AccessFlags dstAccessMask_ ) VULKAN_HPP_NOEXCEPT
    {
      dstAccessMask = dstAccessMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageMemoryBarrier & setOldLayout( VULKAN_HPP_NAMESPACE::ImageLayout oldLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      oldLayout = oldLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageMemoryBarrier & setNewLayout( VULKAN_HPP_NAMESPACE::ImageLayout newLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      newLayout = newLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageMemoryBarrier & setSrcQueueFamilyIndex( uint32_t srcQueueFamilyIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      srcQueueFamilyIndex = srcQueueFamilyIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageMemoryBarrier & setDstQueueFamilyIndex( uint32_t dstQueueFamilyIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      dstQueueFamilyIndex = dstQueueFamilyIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageMemoryBarrier & setImage( VULKAN_HPP_NAMESPACE::Image image_ ) VULKAN_HPP_NOEXCEPT
    {
      image = image_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageMemoryBarrier &
      setSubresourceRange( VULKAN_HPP_NAMESPACE::ImageSubresourceRange const & subresourceRange_ ) VULKAN_HPP_NOEXCEPT
    {
      subresourceRange = subresourceRange_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkImageMemoryBarrier const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkImageMemoryBarrier *>( this );
    }

    operator VkImageMemoryBarrier &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkImageMemoryBarrier *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::AccessFlags const &,
               VULKAN_HPP_NAMESPACE::AccessFlags const &,
               VULKAN_HPP_NAMESPACE::ImageLayout const &,
               VULKAN_HPP_NAMESPACE::ImageLayout const &,
               uint32_t const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::Image const &,
               VULKAN_HPP_NAMESPACE::ImageSubresourceRange const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, srcAccessMask, dstAccessMask, oldLayout, newLayout, srcQueueFamilyIndex, dstQueueFamilyIndex, image, subresourceRange );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ImageMemoryBarrier const & ) const = default;
#else
    bool operator==( ImageMemoryBarrier const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcAccessMask == rhs.srcAccessMask ) && ( dstAccessMask == rhs.dstAccessMask ) &&
             ( oldLayout == rhs.oldLayout ) && ( newLayout == rhs.newLayout ) && ( srcQueueFamilyIndex == rhs.srcQueueFamilyIndex ) &&
             ( dstQueueFamilyIndex == rhs.dstQueueFamilyIndex ) && ( image == rhs.image ) && ( subresourceRange == rhs.subresourceRange );
#  endif
    }

    bool operator!=( ImageMemoryBarrier const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType         sType               = StructureType::eImageMemoryBarrier;
    const void *                                pNext               = {};
    VULKAN_HPP_NAMESPACE::AccessFlags           srcAccessMask       = {};
    VULKAN_HPP_NAMESPACE::AccessFlags           dstAccessMask       = {};
    VULKAN_HPP_NAMESPACE::ImageLayout           oldLayout           = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    VULKAN_HPP_NAMESPACE::ImageLayout           newLayout           = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    uint32_t                                    srcQueueFamilyIndex = {};
    uint32_t                                    dstQueueFamilyIndex = {};
    VULKAN_HPP_NAMESPACE::Image                 image               = {};
    VULKAN_HPP_NAMESPACE::ImageSubresourceRange subresourceRange    = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eImageMemoryBarrier>
  {
    using Type = ImageMemoryBarrier;
  };

  struct ImageMemoryRequirementsInfo2
  {
    using NativeType = VkImageMemoryRequirementsInfo2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eImageMemoryRequirementsInfo2;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ImageMemoryRequirementsInfo2( VULKAN_HPP_NAMESPACE::Image image_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , image{ image_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ImageMemoryRequirementsInfo2( ImageMemoryRequirementsInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageMemoryRequirementsInfo2( VkImageMemoryRequirementsInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT
      : ImageMemoryRequirementsInfo2( *reinterpret_cast<ImageMemoryRequirementsInfo2 const *>( &rhs ) )
    {
    }

    ImageMemoryRequirementsInfo2 & operator=( ImageMemoryRequirementsInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ImageMemoryRequirementsInfo2 & operator=( VkImageMemoryRequirementsInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ImageMemoryRequirementsInfo2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ImageMemoryRequirementsInfo2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageMemoryRequirementsInfo2 & setImage( VULKAN_HPP_NAMESPACE::Image image_ ) VULKAN_HPP_NOEXCEPT
    {
      image = image_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkImageMemoryRequirementsInfo2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkImageMemoryRequirementsInfo2 *>( this );
    }

    operator VkImageMemoryRequirementsInfo2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkImageMemoryRequirementsInfo2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::Image const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, image );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ImageMemoryRequirementsInfo2 const & ) const = default;
#else
    bool operator==( ImageMemoryRequirementsInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( image == rhs.image );
#  endif
    }

    bool operator!=( ImageMemoryRequirementsInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType = StructureType::eImageMemoryRequirementsInfo2;
    const void *                        pNext = {};
    VULKAN_HPP_NAMESPACE::Image         image = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eImageMemoryRequirementsInfo2>
  {
    using Type = ImageMemoryRequirementsInfo2;
  };

  using ImageMemoryRequirementsInfo2KHR = ImageMemoryRequirementsInfo2;

  struct ImagePlaneMemoryRequirementsInfo
  {
    using NativeType = VkImagePlaneMemoryRequirementsInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eImagePlaneMemoryRequirementsInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      ImagePlaneMemoryRequirementsInfo( VULKAN_HPP_NAMESPACE::ImageAspectFlagBits planeAspect_ = VULKAN_HPP_NAMESPACE::ImageAspectFlagBits::eColor,
                                        const void *                              pNext_       = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , planeAspect{ planeAspect_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ImagePlaneMemoryRequirementsInfo( ImagePlaneMemoryRequirementsInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImagePlaneMemoryRequirementsInfo( VkImagePlaneMemoryRequirementsInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : ImagePlaneMemoryRequirementsInfo( *reinterpret_cast<ImagePlaneMemoryRequirementsInfo const *>( &rhs ) )
    {
    }

    ImagePlaneMemoryRequirementsInfo & operator=( ImagePlaneMemoryRequirementsInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ImagePlaneMemoryRequirementsInfo & operator=( VkImagePlaneMemoryRequirementsInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ImagePlaneMemoryRequirementsInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ImagePlaneMemoryRequirementsInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImagePlaneMemoryRequirementsInfo & setPlaneAspect( VULKAN_HPP_NAMESPACE::ImageAspectFlagBits planeAspect_ ) VULKAN_HPP_NOEXCEPT
    {
      planeAspect = planeAspect_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkImagePlaneMemoryRequirementsInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkImagePlaneMemoryRequirementsInfo *>( this );
    }

    operator VkImagePlaneMemoryRequirementsInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkImagePlaneMemoryRequirementsInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::ImageAspectFlagBits const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, planeAspect );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ImagePlaneMemoryRequirementsInfo const & ) const = default;
#else
    bool operator==( ImagePlaneMemoryRequirementsInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( planeAspect == rhs.planeAspect );
#  endif
    }

    bool operator!=( ImagePlaneMemoryRequirementsInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType       sType       = StructureType::eImagePlaneMemoryRequirementsInfo;
    const void *                              pNext       = {};
    VULKAN_HPP_NAMESPACE::ImageAspectFlagBits planeAspect = VULKAN_HPP_NAMESPACE::ImageAspectFlagBits::eColor;
  };

  template <>
  struct CppType<StructureType, StructureType::eImagePlaneMemoryRequirementsInfo>
  {
    using Type = ImagePlaneMemoryRequirementsInfo;
  };

  using ImagePlaneMemoryRequirementsInfoKHR = ImagePlaneMemoryRequirementsInfo;

  struct ImageResolve
  {
    using NativeType = VkImageResolve;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ImageResolve( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers srcSubresource_ = {},
                                       VULKAN_HPP_NAMESPACE::Offset3D               srcOffset_      = {},
                                       VULKAN_HPP_NAMESPACE::ImageSubresourceLayers dstSubresource_ = {},
                                       VULKAN_HPP_NAMESPACE::Offset3D               dstOffset_      = {},
                                       VULKAN_HPP_NAMESPACE::Extent3D               extent_         = {} ) VULKAN_HPP_NOEXCEPT
      : srcSubresource{ srcSubresource_ }
      , srcOffset{ srcOffset_ }
      , dstSubresource{ dstSubresource_ }
      , dstOffset{ dstOffset_ }
      , extent{ extent_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ImageResolve( ImageResolve const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageResolve( VkImageResolve const & rhs ) VULKAN_HPP_NOEXCEPT : ImageResolve( *reinterpret_cast<ImageResolve const *>( &rhs ) ) {}

    ImageResolve & operator=( ImageResolve const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ImageResolve & operator=( VkImageResolve const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ImageResolve const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ImageResolve & setSrcSubresource( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const & srcSubresource_ ) VULKAN_HPP_NOEXCEPT
    {
      srcSubresource = srcSubresource_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageResolve & setSrcOffset( VULKAN_HPP_NAMESPACE::Offset3D const & srcOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      srcOffset = srcOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageResolve & setDstSubresource( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const & dstSubresource_ ) VULKAN_HPP_NOEXCEPT
    {
      dstSubresource = dstSubresource_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageResolve & setDstOffset( VULKAN_HPP_NAMESPACE::Offset3D const & dstOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      dstOffset = dstOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageResolve & setExtent( VULKAN_HPP_NAMESPACE::Extent3D const & extent_ ) VULKAN_HPP_NOEXCEPT
    {
      extent = extent_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkImageResolve const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkImageResolve *>( this );
    }

    operator VkImageResolve &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkImageResolve *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const &,
               VULKAN_HPP_NAMESPACE::Offset3D const &,
               VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const &,
               VULKAN_HPP_NAMESPACE::Offset3D const &,
               VULKAN_HPP_NAMESPACE::Extent3D const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( srcSubresource, srcOffset, dstSubresource, dstOffset, extent );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ImageResolve const & ) const = default;
#else
    bool operator==( ImageResolve const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( srcSubresource == rhs.srcSubresource ) && ( srcOffset == rhs.srcOffset ) && ( dstSubresource == rhs.dstSubresource ) &&
             ( dstOffset == rhs.dstOffset ) && ( extent == rhs.extent );
#  endif
    }

    bool operator!=( ImageResolve const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::ImageSubresourceLayers srcSubresource = {};
    VULKAN_HPP_NAMESPACE::Offset3D               srcOffset      = {};
    VULKAN_HPP_NAMESPACE::ImageSubresourceLayers dstSubresource = {};
    VULKAN_HPP_NAMESPACE::Offset3D               dstOffset      = {};
    VULKAN_HPP_NAMESPACE::Extent3D               extent         = {};
  };

  struct ImageResolve2
  {
    using NativeType = VkImageResolve2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eImageResolve2;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ImageResolve2( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers srcSubresource_ = {},
                                        VULKAN_HPP_NAMESPACE::Offset3D           