# KallistiOS Examples
This page serves as an index for all KallistiOS examples.

- [**2ndmix**](2ndmix/): The flagship KallistiOS demo. It is a remixed version of _Stars_, the first publicly available homebrew Dreamcast demo!
- basic
  - asserthnd
  - exec
  - fpu
  - memtest32
  - mmu
  - stackprotector
  - stacktrace
  - threading
  - watchdog
- conio
  - adventure
  - basic
  - kosh
  - wump
- cpp
  - clock
  - concurrency
  - dcplib
  - gltest
  - modplug_test
  - out_of_memory
- dreameye
  - basic
  - sd
- g1ata
  - atatest
- gldc
  - basic
  - benchmarks
  - nehe
- [**hello**](hello/): demonstrates printing text to the console
- keyboard
  - keytest
- kgl
  - basic
  - benchmarks
  - demos
  - nehe
- libdream
  - 320x240
  - 640x480
  - cdfs
  - keyboard
  - lcd
  - mouse
  - rgb888
  - spu
  - ta
  - vmu
- lightgun
  - basic
- lua
  - basic
- [**micropython**](micropython/): Demonstrates basic usage of the MicroPython kos-port
- modem
  - basic
  - ppp
- mruby
  - dreampresent
  - mrbtris
- network
  - basic
  - dns-client
  - httpd
  - isp-settings
  - ntp
  - ping
  - ping6
  - udpecho6
- objc
  - runtime
- parallax
  - bubbles
  - delay_cube
  - font
  - raster_melt
  - rotocube
  - serpent_dma
  - sinus
- [**png**](png/): - Demonstrates the use of PNG textures, gzip decompression, and drawing text
- pvr
  - bumpmap
  - cheap_shadow
  - modifier_volume
  - modifier_volume_tex
  - plasma
  - pvrmark
  - pvrmark_strips
  - pvrmark_strips_direct
  - texture_render
  - yuv_converter
  - palette
- [**random**](random/): Demonstrates generating random numbers using /dev/urandom
- [**rumble**](rumble/): Demonstrates sending raw commands to the purupuru/jump pack
- sd
- sdl
  -sound
- sound
  - cdda
  - ghettoplay-vorbis
  - hello-mp3
  - hello-ogg
  - hello-opus
  - multi-stream
  - sfx
- tsunami
  - banner
  - font
  - genmenu
- video
  - bfont
  - minifont
  - multibuffer
  - palmenu
- vmu
  - vmu_beep
  - vmu_game
  - vmu_lcd
  - vmu_pkg
