# Changelog

Platform-specific changes are prefixed with the platform name, otherwise the change is platform-independent. The name/initials of the person who is responsible for the change are listed in [square brackets] for most versions (where they are missing from early versions, assume that they should be attributed to Megan Potter).

## KallistiOS version 2.2.0
- Added pvrtex utility by TapamN to utils [DF == Daniel Fairchild]
- Added . & .. directories to filesystems that lack it [AB]
- Replaced previous implementation of realpath() to remove license from AUTHORS [AB]
- Enabled hybrid PVR DR/DMA vertex submission in driver + sped up pvr_prim() [FG]
- Add thread priority boosting system [Paul Cercueil = PC]
- Add performance monitor API [PC]
- Add/Fixed stat() implementations for all filesystems [AB]
- **Dreamcast**: Add network speedtest and pvr palette examples [AB]
- **Dreamcast**: Cleaned up, documented, and enhanced BIOS font API [FG]
- Rework PVR hybrid mode + IRQ handling [PC]

## KallistiOS version 2.1.0
- Cleaned up generated stubs files on a make clean [Lawrence Sebald == LS]
- **Dreamcast**: Added a function to detect if the program is being run on a retail Dreamcast or a Set5.xx device [LS]
- **Dreamcast**: Fixed an issue with the SIP driver that would cause programs to freeze if a microphone was connected at program startup [LS]
- **Dreamcast**: Rearranged the SIP driver to get rid of the internal buffer [LS]
- Removed the GBA, ia32, and ps2 ports. If someone really wants them back and wants to maintain them, let me know. [LS]
- **Dreamcast**: Fixed fmath functions so they compile in C99 mode [LS]
- Cleaned up warnings with -std=gnu99 for C code [LS]
- Cleaned up warnings with -std=c99 for C code [LS]
- **Dreamcast**: Changed the PVR render-to-texture support to allow for two render-to-texture passes without an intervening render-to-screen pass [LS]
- Fixed an issue in fs_ext2 that would allow you to rename a directory to be a child of itself, thus chopping it off from the rest of the directory tree [LS]
- Added a fs_readlink() function to resolve symlinks [LS]
- Fixed the vqenc and kmgenc utilities for compilation on a 64-bit OS [LS]
- **Dreamcast**: Corrected an issue with video cable detection with GCC 4.8.x [LS]
- **Dreamcast**: Added support for ATA devices on the G1 bus [LS]
- **Dreamcast**: Fixed an infinite loop in ATA initialization if nothing except the GD-ROM drive is connected [LS]
- Added documentation for the addons tree [LS]
- **Dreamcast**: Made the hardware auto-initialization/shutdown functions weakly linked so that they can be overridden without modifying KOS [LS]
- **Dreamcast**: Corrected render-to-texture mode so that you don't have to wait for a vblank to actually render to the texture [LS]
- Modified fs_stat to conform (mostly) to the POSIX standard for the stat function [LS]
- **Dreamcast**: Modified the cdrom driver so that it will set itself as the active ATA device before trying to do any CD related reading [LS]
- **Dreamcast**: Fixed potential race conditions between the cdrom code and g1ata [LS]
- **Dreamcast**: Fixed full sector reading of non-data CDs (thanks to SWAT for pointing out that it needed fixing) [LS]
- **Dreamcast**: Added many new matrix/vector math-related macros [Josh Pearson == JP]
- Added libppp for dialup internet access to the addons tree [LS]
- Added DNS resolver functions getaddrinfo() and gethostbyname() [LS]
- Fixed a problem where poll() would deadlock if the timeout expired [LS]
- Modified getaddrinfo() so that it would try multiple times to contact the DNS server with a timeout between messages [LS]
- **Dreamcast**: Various cleanups and modifications to the cdrom code, including subcode reading functionality, DMA-based sector reads, and using a recursive mutex for the G1 lock [Donald Haase == DH]
- **Dreamcast**: Fixed pvr_mem_available() to report all available texture memory, not just what was available in the pvr_malloc() arena [LS]
- **Dreamcast**: Added a utility function to the PVR code for controlling the cheap shadow scale register [LS]
- **Dreamcast**: Added an example of the PVR's cheap shadow functionality [LS]
- **Dreamcast**: Added a tool for generation of bumpmaps that was sent to the mailing list all the way back in 2005 [Fredrik Ehnbom == FE]
- Added the fs_path_append() function to append path components [LS]
- Added a nanosleep() function to koslib by request [LS]
- Added rewinddir() support to the VFS and several filesystems [LS]
- Added in C11 threading support [LS]
- Added UDP Lite support to the network stack [LS]
- **Dreamcast**: Adjust sq_cpy() to use a const pointer for the source [JP]
- **Dreamcast**: Retrieve the IP address from dcload-ip when we can [LS]
- Added the mutex_unlock_as_thread() function to allow an IRQ handler to unlock a mutex as if it were a specified thread [LS]
- **Dreamcast**: Fixed a deadlock issue in the G1ATA code related to the use of a recursive mutex for locking -- Thanks to SWAT for noticing the issue [LS]
- **Dreamcast**: Added support for German (DE) and UK keyboards [Christian Groessler == CG]
- **Dreamcast**: Minor cleanups to the flashrom code [DH && LS]
- **Dreamcast**: Added light gun support roughly based on how it is done in libronin [LS]
- **Dreamcast**: Added a very simple light gun example [LS]
- **Dreamcast**: Added support for Spanish keyboards [Xavier Vallejo == XV]
- **Dreamcast**: Added rudimentary support for OCRAM in linker script [CG]
- Added the C11 aligned_alloc() function [LS]
- Added fs_fstat and modified the fstat function in the newlib handlers to use that or fake it for filesystems that don't support fstat [LS]
- **Dreamcast**: Added fstat support to fs_iso9660 and fs_vmu [LS]
- Added fstat support to fs_ext2, fs_ramdisk, fs_romdisk, and fs_pty [LS]
- Changed libc/koslib/byteorder.c functions to use the <arch/byteorder.h> macros, instead of being hard-coded as little-endian [LS]
- **Dreamcast**: Added Opus decoding example using libopusplay [LS]
- Removed jiffy "counter" that wasn't actually counting anything [LS]
- Added the thd_create_ex() function to create a thread with a given set of attributes set at thread creation (allowing us to expand that list of attributes a bit more easily than what we would have to do otherwise) [LS]
- Made thd_mode local to the threading code (if you need to get the mode at runtime, for some reason, use the new thd_get_mode() function) [LS]
- **Dreamcast**: Patched the GCC patch so that GCC 4.7.x compiles cleanly with a newer host GCC version [Luke Benstead == LB]
- Fixed GCC version detection in the environ script for some locales [LS]
- **Dreamcast**: Made it so that PVR register access is done through a volatile pointer, as it should be to ensure GCC doesn't mess with it any [LS]
- **Dreamcast**: Copy function data from maple device during hot-swap poll if already attached [Joe Fenton == JF]
- **Dreamcast**: Fixed the clobber list of several matrix-related assembly blobs. Thanks to kazade at DCEmulation for pointing out the issue [LS]
- Added the uname() function to retrieve the current kernel version [LS]
- Added fs_fat for SD cards and g1ata devices [LS]
- Added thd_each() function to iterate over all current threads [LB]
- Added dirname() and basename() functions to koslib [LS]
- **Dreamcast**: Clean up strict aliasing rule violations and remove -fno-strict-aliasing from the KOS_CFLAGS [mrneo240 && LS]
- **NAOMI**: Added preliminary support for compiling to target the NAOMI and NAOMI 2 arcade systems with a NetDIMM board attached [LS]
- **NAOMI**: Added a simple utility to parse NetDIMM binary header data [LS]
- **Dreamcast**: Fixed AICA crash when volume is set to 255 [Andress Barajas == AB]
- **Dreamcast**: Placed a cap on the amount of samples requested by AICA so we don't get a Buffer overflow [AB]
- **Dreamcast**: Added a very simple minifont and an example of its use [LS]
- **NAOMI**: Added a NAOMI-specific version of fb_console using minifont [LS]
- **NAOMI**: Cleaned up the build process to not build certain parts of the DC hardware support that are either not useful or not (yet?) functional on NAOMI [LS]
- **Dreamcast**: Fixed fs_path_append unsafe pointer arithmetic and made it smarter [AB]
- **Dreamcast**: Fixed fs_ramdisk_attach so it does not cut off the first character of filename when attaching [AB]
- **Dreamcast**: Moved max open file constants for CD, Ramdisk, Romdisk to opts.h [AB]
- **Dreamcast**: Removed stale lwIP examples [LS]
- **Dreamcast**: Removed fs_dclnative declarations from opts.h [LS]
- **Dreamcast**: Ported lwIP/httpd example to the built-in network stack [LS]
- **Dreamcast**: Added functions to set the icon and color of a VMU that is shown in the BIOS menu, as well as functionality to read the VMU icons from the BIOS font [AB]
- **Dreamcast**: Added a function to draw an XBM image on a single VMU screen [AB]
- Fixed issues with erasing long file name entries and empty files in libkosfat [Thomas Sowell == TS]
- Updated time_t to be 64-bits on Newlib 3.0 and later and fixed Newlib's type for ino_t to be sensible in Newlib 3.3.0 patch [TS, LS]
- Fixed argument check in sem_init. Thanks to TapamN at DCEmulation for noticing the issue and proposing the fix [LS]
- **NAOMI**: Updated the NAOMI header parsing tool to also support creating NAOMI binaries and renamed it to naomibintool [LS]
- **NAOMI**: Added naominetboot - a tool to upload NAOMI formatted binaries to a NetDIMM board for executing on the NAOMI [LS]
- **Dreamcast**: Prevent double-initialization of Maple devices from breaking things [LS]
- **Dreamcast**: Added a user data pointer to snd_stream [LS]
- **Dreamcast**: Added support for -fstack-protector to Newlib 3.3 patch [LS]
- **Dreamcast**: Fixed wasted PVR ram in buffer allocation code [LB]
- Added getsockopt to TCP and UDP [LB]
- **Dreamcast**: Corrected sizeof in fs_dclsocket that referenced wrong struct [LB]
- Fixed spinlock that was left locked on key error in the kthread_getspecific function [LS]
- **Dreamcast**: Added a modem PPP example [LB]
- **Dreamcast**: Fixed register usage and counter in modem driver [LB]
- Fixed invalid read when closing UDP socket [LB]
- Fixed sending packets with an IP address of 0.0.0.0 [LB]
- Added code to attempt to lease the specified address via DHCP, if set [LB]
- **Dreamcast**: Fixed controller capability masks [Artemio Urbina == AU]
- Added simple _times_r syscall for Newlib [LS]
- Fixed length of DHCP options area to always be at least 64 [LB]
- Fixed DHCP retransmit timeout to 4 seconds, per spec [LB]
- **Dreamcast**: Added code to (partially) read DreamKey ISP information [LB]
- **Dreamcast**: Fixed G1 reactivation code for modified BIOSes [Eric Fradella == EF]
- **Dreamcast**: Added support for consoles modded with 32MiB of RAM [TS && EF]
- **Dreamcast**: Fixed wildly out of range start for pvrmark benchmark [Falco Girgis == FG]
- **Dreamcast**: Removed "navi" subarch, moved code to addons/libnavi [LS]
- Removed (completely unsupported) support for GCC 3.x and older [LS]
- **Dreamcast**: Add GCC 12 Toolchain support [FG && EF && Colton Pawielski == CP]
- **Dreamcast**: Update GCC 12.2.0 toolchain support for macOS [EF]
- **Dreamcast**: Add support for GDB 13.1 [EF]
- Add timespec_get C11 function to koslib's libc [LS]
- **Dreamcast**: Added timer_ns_gettime64() and performance counters [AB]
- Added check to allow strict C++17+ to use timespec_get [FG]
- Cleaned up all compiler warnings for all toolchains for KOS [FG]
- Add support for compiling with LTO [Paul Cercueil == PC]
- **Dreamcast**: Fixed calling newlib's exit after returning from main so functions registered with atexit() are called [CP]
- **Dreamcast**: Add GCC 8.5.0 support for ARM toolchain [EF]
- Cleaned up + documented RTC driver, added support for setting time [FG]
- **Dreamcast**: Cleaned up the register access in video to match pvr [DH]
- **Dreamcast**: Fixed various shutdown functions to be safer to call in an interrupt [DH]
- **Dreamcast**: Cleaned up asic functions and corrected potential bugs [DH]
- **Dreamcast**: Removed cooperative threading mode -- threading is always preemptive [DH]
- **Dreamcast**: Added early user init function [PC]
- **Dreamcast**: Fix libobjc not building [EF]
- Added Objective-C example testing/demonstrating C Runtime [FG]
- Updated Objective-C examples to include more thorough testing of the runtime aspects of the language [Andrew Apperley == AA]
- **Dreamcast**: Improve fipr() and fipr_magnitude_sqr() functions [PC]
- **Dreamcast**: Add optimized bit-reverse function && vmu_draw_lcd_rotated() [PC]
- **Dreamcast**: Update bfont example for Dreamcast-specific characters [DH]
- **Dreamcast**: Add example for VMU speaker use [DH && FG]
- **Dreamcast**: Add example for rumble accessory use [DH]
- Split init flags from <arch/arch.h> into <kos/init.h> [LS]
- **Dreamcast**: Revise environ.sh to help prevent issues after multiple sourcing [EF]
- **Dreamcast**: Fixed video/bfont example text encoding issues [EF]
- **Dreamcast**: Revise GCC patch to copy fake-kos, gthr-kos, and startup.s from file tree [EF]
- Fix to only send ARP reply packets if we are the intended recipient [EF]
- **Dreamcast**: Add GCC 13.2.0 and GDB 13.2 support [EF]
- **Dreamcast**: Stabilize 13.2.0, update binutils to 2.41, update dc-chain documentation, upgrade Dockerfile [EF]
- Implemented posix_memalign() from stdlib.h [FG]
- Added clock_gettime(), clock_settime(), clock_getres() [FG]
- **Dreamcast**: Refactored controller API, added capability groups and types [FG]
- **Dreamcast**: VMU driver update for date/time, buttons, buzzer, and docs [FG]
- **Dreamcast**: Add spinlock_trylock macro [LS]
- Simplify kthread_once_t into a simple variable rather than a struct [LS]
- Simplify sync primitive structures to remove initialized member [LS]
- Move definition of __RESTRICT from <sys/_types.h> to <kos/cdefs.h> [LS]
- **Dreamcast**: Added DMA YUV converter path. Adjust some name of related #defines. Added yuv examples [AB]
- Added GCC builtin functions for supporting all of C11 atomics [FG]
- Added toolchain and KOS support for C/C++ compiler-level TLS [CP && FG]
- **Dreamcast**: Added GCC 9.5.0 support for WinXP users [EF]
- **Dreamcast**: Added vmu functions to check/enable/disable the extra 41 blocks [AB]
- **Dreamcast**: Added driver for the SH4's Watchdog Timer peripheral [FG]
- **Dreamcast**: Added Moop powered fast path to sq_cpy, added TapamN pvr related sq functions [AB]
- **Dreamcast**: Garbage-collect network stack [PC]
- **Dreamcast**: Rework romdisks [PC]
- **Dreamcast**: Refactored g2bus API, converted magic values to macros, added dc/fifo.h, dc/dmac.h file [AB]
- **Dreamcast**: Fixes and improvements for G1 ATA devices [Ruslan Rostovtsev == RR]
- **Dreamcast**: Fixed and improved SCIF SPI reading for use with SD [RR]
- **Dreamcast**: SH4 cache improvements [RR]
- **Dreamcast**: Optimized separating stereo PCM [RR]
- **Dreamcast**: Refactored sfx and streaming to add SQ fast path [RR]
- **Dreamcast**: Added 4/8-bit wav support to sfx and streaming [RR]
- Implement SO_RCVBUF and SO_SNDBUF for setsockopt() [EF]
- Added <netinet/tcp.h> header file and required option [LS]
- Added <netinet/udp.h> and <netinet/udplite.h> headers and move the related content from <netinet/in.h> [LS]
- Added __weak, __used, likely() and unlikely() [FG]
- **Dreamcast**: Added Maple-specific KOS_INIT_FLAGS() which allow for GC-ing unused drivers [FG]
- **Dreamcast**: Added basic example for micropython KOS port [Aaron Glazer == AG]
- **Dreamcast**: Added network example for setting system clock via NTP [EF]
- **Dreamcast**: Add support for GDB 14.1 [EF]
- **Dreamcast**: Improved performance of IRQ context save / restore [PC]
- **Dreamcast**: Increased resolution of TMU timers + date/time functions [FG && PC]
- **Dreamcast**: Adapt old KGL examples into GLdc examples for new GLdc kos-port [EF]
- **Dreamcast**: Increased resolution of C's clock() and CLOCKS_PERS_SEC to microseconds [FG]
- **Dreamcast**: Update dc-chain configurations with wide char support [EF]
- **Dreamcast**: Add support for Newlib 4.4.0 in newer toolchain configurations [EF]
- Increased resolution of clock() and CLOCKS_PER_SEC to microseconds [FG]
- **Dreamcast**: Added centralized header for Dreamcast Memory map (arch/memory.h) [DH]
- **Dreamcast**: Refactored multibuffer video modes and added example of their use [DH]
- **Dreamcast**: Created separate performance counter driver and enhanced API [FG]
- Implemented _POSIX_CPUTIME in clock_gettime() using perf counter timer [FG]
- **Dreamcast**: Allow adjusting floating point precision mode in dc-chain [EF]
- **Dreamcast**: Add environment variable to define floating point precision mode [EF]
- Implemented scandir() and alphasort() POSIX functions from dirent.h [FG]
- **Dreamcast**: Added new driver for the SH4's UBC + high-level breakpoint API [FG]
- **Dreamcast**: Update binutils version to 2.42 in newer toolchain configurations [EF]
- **Dreamcast**: Allow option to pass --enable-host-shared to GCC configuration [EF]
- **Dreamcast**: Patch Newlib libm/complex functions to eliminate implicit function
      declarations in preparation for GCC 14 [EF]
- **Dreamcast**: Update GDB 14.1 configurations to GDB 14.2 [EF]
- **Dreamcast**: Adjust GCC 14 patch to fix libstdc++ compilation with m4-single-only [EF]
- **Dreamcast**: Add support for French AZERTY keyboards [PC]
- **Dreamcast**: Increased the resolution of pvr_stats_t from milli to nanoseconds [FG]
- Added support for modifying scheduler frequency at runtime [FG]
- **Dreamcast**: Use treeless clone when git repo is used as source for dc-chain [EF]
- **Dreamcast**: Update GCC configurations and patches for new separate GCC 15 and 14
      branches, D support, and building m4-single support [EF]
- **Dreamcast**: Fix 'parameter name omitted' errors on older compilers [EF]
- Add support for worker threads [PC]
- **Dreamcast**: Many minor updates to dc-chain (see #533) [EF]
- **Dreamcast**: Added new System Calls module [AB]
- **Dreamcast**: Add option to enable Local Register Allocation for GCC in environ.sh [EF]
- **Dreamcast**: Add timer_spin_delay_{us,ns} and use them in scif-spi [PC]
- **Dreamcast**: Dockerfile: Fix flex errors building GCC, dependency issues with GDB,
      and disable ARM build [EF]
- **Dreamcast**: Rename gnu_wrappers dir to build_wrappers [EF]
- **Dreamcast**: dc-chain improvements for gccjit, D, and Ada [EF]
- **Dreamcast**: Add GCC 13.3.0 toolchain profile [EF]
- **Dreamcast**: Add Makefile rule to check minimum GCC version [EF]
- **Dreamcast**: Improve environ.sh handling of built-in flag for fast math [EF]
- **Dreamcast**: Add DC_TOOLS_BASE environment variable for external tools [EF]
- Added thread support for tracking CPU time + updated clock_gettime() [FG]
- Added support for one-shot timers [PC]
- **Dreamcast**: Use one-shot timers for timeout and a proper polling mechanism in modem [PC]
- **Dreamcast**: Update GCC 12.x toolchain profile to 12.4 [EF]
- **Dreamcast**: Update toolchain profiles using GDB 14.2 to the latest GDB 15.1 [EF]
- **Dreamcast**: Update GCC 14.x toolchain profile to 14.2 [EF]
- **Dreamcast**: Update GCC 11.x toolchain profile to 11.5, update Binutils to 2.43 [EF]
- **Dreamcast**: Fix ARM toolchain build error when JIT is enabled for SH toolchain [EF]
- **Dreamcast**: Added a set of known working purupuru bit patterns and a browsing mechanism to the rumble example [DF == Daniel Fairchild]
- Added full support for <time.h> additions from C23 standard. [FG]
- Fixes mutexes not working properly [PC]
- **Dreamcast**: fs_dcload: Set errno on error in dcload_stat() [PC]
- Create romdisks with bin2c instead of bin2o [PC]
- Implemented versioning scheme for KOS API [FG && DH && LB]

## KallistiOS version 2.0.0
- **Dreamcast**: Broadband Adapter driver fixes [Megan Potter == MP]
- Imported a new version of lwIP, with proper sockets lib [MP]
- **Dreamcast**: Added new httpd example for lwIP [MP]
- **x86**: Added incomplete ia32 port [MP]
- **Dreamcast**: Added new DC examples for Parallax (raster_melt, sinus, delay_cube, rotocube) [MP]
- Added svnpush.py script for pushing repositories on the web [MP]
- **Dreamcast**: Added genmenu module and example in Tsunami [Megan Potter == MP]
- **Dreamcast**: Added hello-mp3 example [MP]
- **Dreamcast**: 320x240 PAL mode [mekanaizer == MK]
- Fixed vqenc and kmgenc headers to be ANSI compliant [MP]
- New addons/ports build system [MP]
- Moved most addons/ports into their own tree/distribution [MP]
- Moved several incorrectly placed pieces into libkosutils [MP]
- Imported port of Lua 5.0 [MP]
- **Dreamcast**: Added Tsunami Matrix class [MP]
- **Dreamcast**: Various improvements to Tsunami classes [MP]
- Major build system overhaul (see RELNOTES) [MP]
- **Dreamcast**: Improved MII/link status handling for BBA driver [MP]
- Added NONE thread mode [MP]
- lwIP select fixes [Walter van Niftrik == WvN]
- **Dreamcast**: GDB stub fixes [Richard Moats == RM]
- New bin2c [Gil Megidish == GM]
- Updated genromfs [MP]
- **Dreamcast**: Fixed and re-enabled SPU DMA module [MP]
- **Dreamcast**: Cleaned up PVR DMA functions, adding support for different DMA targets [MP]
- **Dreamcast**: Floating point register support for the GDB stub [RM]
- **Dreamcast**: Added G2 DMA pausing for G2 bus read/write calls [MP]
- Added UDP sendto/recvfrom calls in lwIP [MP]
- **Dreamcast**: Added DNS client lwIP example [MP]
- **Dreamcast**: Added ISP settings code to flashrom module [Sam Steele == SS, DP]
- **Dreamcast**: Added ISP settings example [MP]
- Added gethostbyname support to lwIP port [MP]
- **Dreamcast**: Updated netcfg to load settings from flashrom [MP]
- **Dreamcast**: Cleaned up DC modem code and added new dialing functions [MP]
- **Dreamcast**: Store Queue and Matrix translation speed ups [Jim Ursetto = JU]
- **Dreamcast**: Support for DMAed vertex buffers in PVR [MP]
- **Dreamcast**: Added mat_transform_sq function [JU]
- **Dreamcast**: Added modified version of Jim Ursetto's serpent example [DP, JU]
- **Dreamcast**: New sound stream manager, sound effect channel addressing support [MP]
- Threading fixes for libmp3/liboggvorbisplay/libtremor [Viktor, Heinrich Tillack == HT]
- Added New dbgio system [MP]
- **Dreamcast**: Various fixes to support new dbgio system [MP]
- **Dreamcast**: Made fsqrt specify fr0 as dirtied [JU]
- Updated bin2o to produce properly aligned files [MP]
- **Dreamcast**: Added support for setting fsaa at PVR init [MP]
- **Dreamcast**: Added mat_trans_nodiv, fipr_magnitude_sqr, and fipr [JU]
- Added WORLDVIEW matrix, plx_vert_inpm3, and case-insensitive texture loading to libparallax [MP]
- Added gnu_wrappers (KOS wrappers for GNU tools) [MP]
- **Dreamcast**: Fixed enabling of incorrect ASIC event for SPU DMA [Vincent Penne == VP]
- Converted everything to use Newlib as libc/libm rather than the old built-in libc/libm [MP]
- Added byte ordering functions to koslib [MP]
- **Dreamcast**: Added timer_us_gettime64 function [MP]
- Patched things for multi-threaded libstdc++ compilation [JU]
- Fixed free(NULL) in debug mode [MP]
- **Dreamcast**: Fixed issues with scif_init and dcload-serial support [MP]
- **Dreamcast**: Added user-entered date support in syscfg_t [Thierry Vermeylen == TV]
- **Dreamcast**: Cleaned up thread usage in libkosh [MP]
- **Dreamcast**: Added new kosh example program using conio [MP]
- **Dreamcast**: Fixed adventure example for new compilers/newlib [MP]
- **Dreamcast**: Added New modem driver (version 1.2) [Nick Kochakian == NK]
- **Dreamcast**: Fixed AICA volume setting [JU]
- **Dreamcast**: Fixed RLE in gdb_stub [RM]
- **Dreamcast**: Fixed an image-garbling bug in vqenc [RM]
- **Dreamcast**: Fixed vqenc mipmap generation [RM]
- **Dreamcast**: Added support for BBA DMA, Improved SPU DMA support, added generic G2 DMA functions [VP]
- **Dreamcast**: Updated netcfg to support adding a VMU icon [SS]
- **Dreamcast**: Added GDB-over-dcload support [RM]
- **Dreamcast**: Added support for hard breakpoints/watchpoints using UBC [RM]
- Fixed libmp3 sndstream callback's incorrect shifting of the output buffer [RM]
- **Dreamcast**: Added synchronized start command for sound [RM]
- Fixed Tsunami genmenu's incorrect device ID in debug output [Atani]
- **Dreamcast**: Added partial VMUFS fixes [Tursi]
- **Dreamcast**: Added block write retrying to VMU driver [Tursi, DP]
- **Dreamcast**: Added a fix for issues with inserting/removing purupuru packs [Tursi]
- **Dreamcast**: Added support for PVR sprites [Lawrence Sebald == LS]
- Added new internal network system (alternative to lwIP) [LS]
- **Dreamcast**: Added automatic configuration of the BBA/Lan Adapter from flashrom [LS]
- **Dreamcast**: Added support for the maple Microphone peripheral [LS]
- **Dreamcast**: Added a purupuru driver that has rumble support [LS]
- **Dreamcast**: Added a skeleton Dreameye driver (doesn't do anything useful but it does make detection work) [LS]
- Fixed the newlib patch [WvN]
- Added/fixed various addons headers [SS]
- **Dreamcast**: Added support for GL_TRIANGLE_FAN in KGL [SS]
- Added support for antialiased fonts in libparallax [JU]
- Adjusted makejitter makefile to use kos-ports headers [SS]
- **Dreamcast**: Fill in dirent.attr for directories in is9660 [SS]
- **Dreamcast**: Applied patch for opening correct iso9660 filenames [Christian Groessler == CG]
- **Dreamcast**: Fixed bitmask for mouse buttons (makes 3rd button usable) [Fragger]
- **Dreamcast**: Added experimental (read: partially working) render to texture support in the PVR module [LS]
- **Dreamcast**: Added example program for render-to-texture [LS]
- Made thd_sleep(0) work properly [MP]
- Added a fix to ARP handling code so that an error is returned rather than an incomplete mac address [LS]
- Added standard network headers (arpa/inet.h, netinet/in.h, sys/socket.h) [LS]
- Added inet_addr function [LS]
- Added fs_socket, which implements the standard socket functionality using the built-in networking code (only UDP supported though) [LS]
- **Dreamcast**: Correctly set attr member of dirent_t from dcload_readdir [Anonymous]
- Added libmp3 volume control function [Atani]
- Added support for '.' and '..' in path names [WvN]
- **Dreamcast**: Added in AICA channel position patch [WvN]
- Added simple Blender model export plugin [Christian Henz == CH]
- Added newlib execve stub [MP]
- Made ARP code garbage collection run on each ARP query [LS]
- Removed unused net_ntohl/net_ntohs functions [LS]
- **Dreamcast**: Added support for polling for packets on the BBA [LS]
- **Dreamcast**: Added a short delay after init on the LAN adapter, since mine seems to crap out if you try to access it too quickly after init [LS]
- Made net_ipv4 layer not pass around ethernet headers [LS]
- Made net_ipv4 checksum work right for odd byte count messages [LS]
- Modify networking code to work properly in an IRQ [LS]
- **Dreamcast**: Added glVertex2f support to KGL [Atani]
- Added inet_aton, inet_ntoa, inet_ntop, inet_pton functions and made inet_addr use inet_aton [LS]
- **Dreamcast**: Fixed code that did lvalue casts [LS]
- **Dreamcast**: Added in sector size patch [Donald Haase == DH]
- Use genwait rather than the condvar in the UDP code [LS]
- **Dreamcast**: Patched SDL with a patch that was quite old to fix audio and controllers [Bero]
- **Dreamcast**: Fixed the SDL timer [OneThirty8 == 138]
- Made net_ipv4_send function accept arguments that represent the fields of the IPv4 header, rather than a structure of the IPv4 header [LS]
- Fixed odd-sized messages in the UDP code [LS]
- Removed useless debug messages in UDP code [LS]
- **Dreamcast**: Added support for rates less than 9600 in SCIF driver [CG]
- Handle loopback sends more sanely in net_ipv4 [LS]
- Change behavior when a send is attempted to a host that does not have a cached ARP entry, making sends to new hosts actually work most of the time on the first try [LS]
- Fixed recv/recvfrom in the UDP code to actually unlock the UDP mutex if they have to wait [LS]
- **Dreamcast**: Added fs_dclsocket (dcload over fs_sockets) [LS]
- **Dreamcast**: Fixed SDL to not return incorrect mouse buttons [Cyle Terry == CT]
- Added implementations of read/write/seek in fs_socket [LS]
- **Dreamcast**: Fixed readdir on VMUS when the VMU is empty [CG]
- Removed useless getAlpha argument in Tsunami's drawable class [CT]
- Added reader/writer semaphores [LS]
- **Dreamcast**: Added example program for reader/writer semaphores [LS]
- Made Lua use fmodf rather than fmod [Harley Laue == HL]
- Fixed memory leak in UDP socket code when the mutex cannot be acquired and the code is being executed inside an IRQ [LS]
- **Dreamcast**: Added support for VMU beeping [DH]
- Added support for upgrading a read lock on a reader/writer semaphore to a write lock [LS]
- Added a recursive lock synchronization primitive [LS]
- Moved checking for free(NULL) up in code to avoid potential problems [HL]
- **Dreamcast**: fs_ramdisk.c: Don't allow opening a file with O_DIR [CG]
- Removed legacy libc and libm [HL]
- **Dreamcast**: Handle potentially misaligned outgoing packets in the BBA driver [LS]
- **Dreamcast**: Added g2_memset_8 function for doing a memset over G2 with locking [LS]
- **Dreamcast**: If a packet is < 60 bytes, pad it with null bytes for clarity, rather than just transmitting whatever random junk was in the transmit buffer from previous sends [LS]
- **Dreamcast**: Rewrote microphone driver to make it support the different encodings available to the hardware [LS]
- **Dreamcast**: Add maple_enum_type_ex function to return the nth device that is of the requested type and supports the list of capabilities listed (i.e, the function_data of devinfo for that function has all the bits set that are set in the cap parameter [LS]
- **Dreamcast**: Made vid_screen_shot support any of the video modes [DH]
- Fixes to the network stack to support sending/receiving broadcast packets properly [LS]
- **Game Boy Advance**: Fixed arch/types.h so the toolchain can compile. [HL]
- **Dreamcast**: Adjusted the flashrom_ispcfg_t structure to account for differences between PlanetWeb and DreamPassport [LS]
- **Dreamcast**: Added reading of the ISP settings from PlanetWeb to the flashrom code [LS]
- **Dreamcast**: Fixed various pieces of code that rely on flashrom_ispcfg_t [LS]
- Added an implementation of DHCP to the network stack [LS]
- **Dreamcast**: Added Dreameye driver that is capable of fetching stored images from the device. [LS]
- Added kthread_once function (think pthread_once) [LS]
- Added pthreads-like thread-local storage [LS]
- **Dreamcast**: Added in support for untextured PVR sprites and added support for the more correct polygon header to be sent for sprites [LS]
- **Dreamcast**: Added in some support functions for PVR modifier volumes (and an example program that uses them) [LS]
- **Dreamcast**: Added a modifier volume example using textures [LS]
- Added a simple statistics system to the IPv4 and UDP layers of the network stack [LS]
- Added a MTU value to the netif structure for maintaining the maximum transfer size of the adapter [LS]
- Added the ability to fragment IP packets, and made fragmenting respect the MTU [LS]
- Added a primary network thread that can be used for timer-based, repetitive network tasks (like DHCP renewals), and made the DHCP code utilize it [LS]
- Added rudimentary IP reassembly support [LS]
- Added support for IPv6 in the network stack [LS]
- Added support for TCP in the network stack [LS]
- Added setsockopt(), getsockopt(), and fcntl() functions, mainly for dealing with sockets. Removed the (now useless) fs_socket_setflags() function [LS]
- Updated patches to use GCC 4.7.0 and Newlib 1.12.0 [LS]
- Added initializers for transient semaphores, condvars, and mutexes and changed the way that they should be initialized in general [LS]
- Added a poll() function, as well as select() [LS]
- Added the ability to wake a certain thread with genwait and to specify an error code to wake them with [LS]
- **Dreamcast**: Use the fsca and fsrra asm mnemonics in the fmath code since they've been supported by binutils since 2004 [LS]
- **Dreamcast**: Detect the region/type of keyboard on attach and map keys in an appropriate manner [LS]
- **Dreamcast**: Give each keyboard its own queue of keys [LS]
- **Dreamcast**: Added low-level SPI support on the serial port as well as a block device interface for using an SD card with the homebrew adapter [LS]
- Added a CRC16-CCITT function [LS]
- Added dontwait, waitall, and peek flags for use with sending and receiving data on sockets [LS]
- Added fs_ext2 to be used with the SD card code (and fixed a lot of bugs with it along the way) [LS]
- **Dreamcast**: Added missing txrenv stuff to PVR sprites (thanks to Tvspelsfreak at the DCEmulation forums for pointing out it was missing) [LS]
- Change how threads are swapped to prevent a high priority thread from starving everyone else [LS]
- **Dreamcast**: Create a map file for the ARM code during compilation [CG]
- **Dreamcast**: Return the old border color from vid_border_color() [CG]
- Return status codes from fs_close() as is expected in POSIX [CG]
- **Dreamcast**: Actually support 2352 byte sector reads in the cdrom code (thanks to Multimedia Mike for noticing it was broken) [LS]
- Added fs_symlink() and fs_link() functions to the VFS [LS]
- **Dreamcast**: Fixed a delay loop in aica_get_pos() that was optimized away [CG]
- **Dreamcast**: Added -N to the ARM linker switches to prevent .data from being padded to a 32KiB boundary [CG]
- Use the O_CREAT flag in fs_copy() on the destination file [LS]
- **Dreamcast**: Added fs_ext2/SD examples sd/ext2fs (basic example showing mounting and file I/O) and sd/mke2fs (create a new ext2 filesystem on the SD card) [LS]

## KallistiOS version 1.2.0
- **Dreamcast**: Fix to use DCARM7_CFLAGS when compiling ARM driver [Christian Groessler == CG]
- **Dreamcast**: Fix for typo in vmu_pkg_crc() (submitted by anonymous)
- **Dreamcast**: Fix for incorrect source address in maple packets [Jim Ursetto == JU]
- Fix fputs() to not put an extra "\n" [Walter van Niftrik == WvN]
- **Dreamcast**: Fix Makefile for vqenc to work in more cases [Megan Potter == MP]
- **Dreamcast**: Integrated irq_disable() and irq_enable_exc() so that exceptions are always enabled. [MP]
- **Dreamcast**: Added pvr_mem_stats() (like malloc_stats but for PVR) [MP]
- Removed SYSCALL() usage in favor of thd_block_now() [MP]
- Primary timers switched to wakeup interval rather than periodic. [MP]
- Fix uninitialized mutex in semaphores [MP]
- Added generic waits, and changed semaphores/mutexes to use them [MP]
- **Dreamcast**: Added timer_ms_gettime64() [MP]
- **Dreamcast**: Fix for potential incorrectness in NDEBUG mode in pvr_txr_load_ex [MP]
- **Dreamcast**: Remove float usage in timer_ms_gettime() [MP]
- More proper condvar impl using genwaits [MP]
- **Dreamcast**: Strip trailing dots on extensionless ISO filenames (thanks waltervn for pointing this out) [MP]
- Fix file descriptor owner bug in fdopen [Bero]
- Zlib workaround for KOS file descriptors being non-POSIX [Bero]
- Added more proper (mutex-paired) condvars, and tests [MP]
- **Dreamcast**: Tremor: bug fix for mono playback, guaranteed thread exit timing, added thd_sleep() to make threading more efficient [MP]
- Use dbgio_printk instead of dbgio_printf in printf [Bero]
- **Dreamcast**: System ASIC module now supports IRQ priority levels [MP]
- **Dreamcast**: CD-Rom driver much more thread-friendly [MP]
- 'struct netif' renamed to 'struct knetif' to avoid conflicts with lwIP [MP]
- Fix for initial '/' in fs_builtin pathnames [Bero]
- Moved addons' includes and output libs to under addons/ [MP]
- **Dreamcast**: Updated liboggvorbisplay to use vorbisfile funcs like libtremor [MP]
- **Dreamcast**: Set size to -1 while readdir'ing on /vmu so they appear as dirs [MP]
- **Dreamcast**: Filter chain support for snd_stream [MP]
- **Dreamcast**: Basic flashrom BIOS support [MP]
- **Dreamcast**: Improved PVR statistics reporting [MP]
- **Dreamcast**: Misc improvements to Parallax and Tsunami [MP]
- **Dreamcast**: Add Joliet support to iso9660 and fix a big huge bug in directory scanning [Bero, DP]
- **Dreamcast**: Support for alpha channels, PNG input, and KMG output in vqenc [MP]
- **Dreamcast**: New libkmg for loading KMG files output by vqenc [MP]
- Added byte_count field to kos_img_t for paletted and VQ'd data [MP]
- **Dreamcast**: Typo in broadband adapter driver flags [Wayne Moorefield == WM]
- **Dreamcast**: Switch to genwaits and remove extra timing in maple VMU module [MP]
- **Dreamcast**: Added skeleton PuruPuru/Jump Pack driver [MP]
- **Dreamcast**: New vmufs middle-layer driver and new fs_vmu that uses it [MP]
- Fixed thread non-safety in readpng [MP]
- **Dreamcast**: SPU module wasn't clearing all of sound ram on startup/shutdown [MP]
- **Dreamcast**: New libkmg for loading "KOS image" files from disk [MP]
- **Dreamcast**: Support for opening a stream from a descriptor in liboggvorbisplay [MP]
- **Dreamcast**: Parent-relative colorization and positioning in libtsunami [MP]
- **Dreamcast**: Misc bug fixes and improvements in libtsunami [MP]
- **Dreamcast**: Multi-format texture loading support, getpos() for fonts in plx [MP]
- fs_ramdisk attach/detach support [MP]
- Added a NOT_OWNER flag for kos_img_t for ROM images, etc [MP]
- **Dreamcast**: Added WIP native dc-load client [MP]
- **Dreamcast**: Added generic vblank hooking system [MP]
- **Dreamcast**: KM_DBG_VERBOSE support for PVR malloc [MP]
- **Dreamcast**: Improved texture memory size detection for debug messages in PVR [MP]
- **Dreamcast**: Switch to vblank for page flipping, stats on vertex buffer usage in PVR [MP]
- **Dreamcast**: Add support for load method flags in pvr_load_texture_ex [MP]
- **Dreamcast**: Add snd_sfx_stop_all() and mmap support for loading samples [MP]
- **Dreamcast**: Improved debug output for sound malloc [MP]
- Removed x86-specific code in endian.h [MP]
- **Dreamcast**: New kmgenc utility for pre-twiddling textures [MP]
- **Dreamcast**: Inside-int usability for cdrom_get_status() [MP]
- **Dreamcast**: Tray-open detection using vblank, improved fd invalidation support for fs_iso9660 [MP]
- **Dreamcast**: Persistent volume support for liboggvorbis [MP]
- **Dreamcast**: Font fuzziness cleanup and pseudo-newline support in Parallax [MP]
- **Dreamcast**: Added modem driver from Nick Kochakian [NK]
- **Dreamcast**: Added a bunch of fun Kosh builtins [MP]
- **Dreamcast**: Slightly more verbose death message for out-of-mem panic [MP]
- Added pure virtual function support in libk++ [MP]

## KallistiOS version 1.1.9
- Added private data field, async and stat to VFS [Megan Potter == MP]
- **Dreamcast**: Fix for opening VMU files as dirs [Christian Groessler == CG]
- Added fs_mkdir and fs_rmdir [MP]
- Added fs_ramdisk (on /ram) [MP]
- Added mutex as a wrapper to semaphores [MP]
- Switched VFS to use real mutex support [MP]
- Added vfs_handler_t parameter to some VFS calls for private data usage [MP]
- Changed fs_romdisk to allow multiple romdisk mounts [MP]
- Added fs_copy and fs_load util functions [MP]
- Changed sem_wait() and sem_wait_timed() so it doesn't assert() if called from an interrupt [MP]
- Added the dlmalloc debugger [MP]
- **Dreamcast**: Fixed bug with samples >64k looping accidentally [MP]
- **Dreamcast**: Added stereo sample support [MP]
- **Dreamcast**: Fixed some alignment issues in 3dutils in libdcutils [MP]
- Replace slightly broken atoi/atol with BSD versions [MP]
- Added endian.h from BSD [MP]
- **Dreamcast**: Port of OggVorbis "Tremor" lib [MP]
- **Dreamcast**: Added leak checker for PVR malloc [MP]
- **Dreamcast**: NULL parameters are allowed to timer_ms_gettime now [MP]
- malloc_debug is now platform independent [MP]
- **Dreamcast**: libdcutils has been removed; most pieces moved elsewhere in KOS [MP]
- **Dreamcast**: Adventure example should compile more places now [MP]
- **Dreamcast**: Added mat_trans_single3() [MP]
- **Dreamcast**: Calling pvr_list_begin() when a list is opened closes the old one first [MP]
- **Dreamcast**: Added wav2adpcm utility [Bero, DP]
- **Dreamcast**: ADPCM samples support in sfxmgr [MP]
- **Dreamcast**: Added 2D PVR util library Parallax [MP]
- **Dreamcast**: Added C++ scene graph lib Tsunami [MP]
- **Dreamcast**: Added frame pointer macros [MP]
- **Dreamcast**: Ability to hook into "double faults" [MP]
- **Dreamcast**: Stack tracing functions for FRAME_POINTERS mode [MP]
- Assert hooking capabilities, stack trace from assert when possible [MP]
- libtga wasn't setting format of kimg's (thanks dvanbler)
- **Dreamcast**: snd_init() called more than once would freeze (thanks anonymous)
- **Dreamcast**: Fixed "dunno" field in cdrom TOC structure (thanks bjonte)
- **Dreamcast**: Added GDB stub support [Jason Fritcher == JKF]
- **Dreamcast**: Fix for libconio to remove some duplicated code [Jim Ursetto == JU]
- **Dreamcast**: Timing test code for tremor and sndoggvorbis, and race condition fix for quick starting/stopping of songs. [MP]
- **Dreamcast**: Fix for loading 3-channel PNGs into an alpha-enabled buffer [MP]
- **Dreamcast**: Fix in libconio for incorrect output target when using dc-load-ip console [MP]
- **Game Boy Advance**: Code sync with Gil Megidish's GBA code base [Gil Megidish == GM]
- **Dreamcast**: Updates to the AICA driver due to Yamato's new docs [MP]
- **Dreamcast**: PVR texture DMA support [Roger Cattermole == RC]
- **Dreamcast**: sfxmgr changed to allow unlimited sound effects [MP]
- fread() fix if nmemb < size [GM]
- new and delete in libk++ accept size_ instead of unsigned int [GM]
- Fixed many warnings in the build [GM]
- **Dreamcast**: Disable IRQs during screen shots to make sure you get a coherent pic [MP]
- **Dreamcast**: Added plasma example [MP]
- **Dreamcast**: Some efficiency fixes in the thread scheduler [MP]
- **Dreamcast**: Some init/shutdown cleanups for libconio [MP]
- **Dreamcast**: Added libkosh, a library version of Kosh for debug purposes [MP]
- **Dreamcast**: Generic mode system for vid_set_mode, fixed centering on VGA [MP]
- **Dreamcast**: Cleaned up MMU support, added some MMU examples [MP]
- **Dreamcast**: Maple only queries U0 for each port for attach/detach now [MP]
- **Dreamcast**: Added a rudimentary (and slightly abusive :) stat call to fs_vmu [MP]
- **Dreamcast**: Added spu_master_mixer() to control the master mixer [MP]
- **Dreamcast**: Added irq_get_handler and irq_get_global_handler [MP]
- **PlayStation 2**: Initial skeleton port for PS2 RTE added [MP]
- **Dreamcast**: Misc cleanup in dcplib [MP]
- **Dreamcast**: Added INIT_QUIET and INIT_NO_DCLOAD for "production" versions [MP]
- Fix a startup error when booting the original kernel thread [MP]
- dbglog short-circuits to dbgio_printk to save some time [MP]
- **Dreamcast**: Fixed up SYSCALL macro to be much less broken [MP]
- Added sem_trywait() as a non-blocking semaphore wait [Bero]
- Added thd_wait() to wait for thread death [MP]
- Double-advancing gettimeofday() fixed [MP]
- **Dreamcast**: Added some consts in the oggvorbis libs [MP]
- **Dreamcast**: Added a VQ encoder and a VQ example [GM]
- **Dreamcast**: Added SDL port from Bero and Lawrence Sebald [Lawrence Sebald == LS]

## KallistiOS version 1.1.8 
- **Dreamcast**: Fixed two more memory free problems in OggVorbis [Megan Potter == MP]
- **Dreamcast**: Fixed GL_POINTS [Paul Boese == PB]
- **Dreamcast**: Fixed problem with setting gl_cur_texture to gl_null_texture in glmisc.c [PB]
- **Dreamcast**: Added "navi" subarch for my hardware experimenting work [MP]
- **Dreamcast**: Fixed a bug in the cdrom drive which caused a lockup if the tray was open during startup, and fixes compatibility with navi [MP]
- **Dreamcast**: Added GL_POLYGON and GL_QUAD_STRIP to gldraw.c. Thanks to Jesse Ruffin :) [Jesse Ruffin == JR]
- **Dreamcast**: Various fs_vmu fixes: properly zero out directory entries on unlink, confine user writes to user data area, file blocks no longer cleared on unlink, allow writing to existing files, implement seek/mmap, O_TRUNC support, case-insensitive port in path, improved error checking and various cleanups [Jim Ursetto = JU]
- **Dreamcast**: New "public" maple API (maple_enum_*) [MP]
- **Dreamcast**: Prevent FPU exception on underflow (DN=1, thanks Andrew!) [MP]
- **Dreamcast**: Fix for non-square PNG loading [Fredrik Ehnbom = FE]
- **Dreamcast**: Fixed race condition in snd_stream for multi-threaded operation [MP]
- **Dreamcast**: Stack underrun check for threads, fixed thread pwd inheritance [MP]
- Changed gentexfont to include more glyphs by default [MP]
- **Dreamcast**: lwIP support for dcload-ip [Andrew Kieschnick == ADK]
- **Dreamcast**: irq.h fixes and generic trapa handler support [Jason Fritcher == JKF]
- **Dreamcast**: Added vmu_parse function [JU]
- **Dreamcast**: Changed snd_stream callback to return an actual "got" value, added a timeout for kick_aica(), added checks so that re-initting the snd_stream lib won't stop currently running sound effects [MP]
- **Dreamcast**: Added seamless looping support for OggVorbis [MP]
- **Dreamcast**: Fix for "adventure" conio example under Cygwin [MP]
- Added "imageload" library [Jeffrey McBeth == JBM]
- **Dreamcast**: Added arch_exec_at [Scott Robinson == SR]
- Fix ar->$(KOS_AR) in lwIP Makefile [JKF]
- **Dreamcast**: Fix potential crash in vmu_close [JU]
- **Dreamcast**: New more generic sound driver [MP]
- Ported strtod and strtoul from BSD [MP]
- Include stddef.h in stdlib.h for offsetof() among other things [MP]
- Port of the Lua scripting language [MP]
- Added rule for 'S' (preprocessed assembly) to 'o' [MP]
- **Dreamcast**: Trilinears Z-Clipper for GL_TRIANGLES. Includes demo [Marc Hall MH]
- **Dreamcast**: Added Experimental volume modifier stuff to pvr and kgl [PB]
- Added PCX loader for libimageload [JBM]
- Fix for BMP loader in libimageload [JBM]
- **Dreamcast**: Japanese support for biosfont [Kazuaki Matsumoto == KM] [MP]
- **Dreamcast**: Fix a NEARZ clipper bug in KGL. Misc Fixes. Added storage for frustum attributes [PB]
- **Dreamcast**: Change for fs_dcload that lets console output keep going out over dcload-ip up to the last second [MP]
- **Dreamcast**: Removed some assert_msg's in KGL to make threaded programming with these more usable [MP]
- **Dreamcast**: Replaced cheesoid sound allocator with a real best-fit one [MP]
- **Dreamcast**: Fixed error handling for out-of-texture-ram so it doesn't crash the entire program [MP]
- **Dreamcast**: Left out some "break" statements in pvr_texture.c (thanks Mike Z) [MP]
- **Dreamcast**: Palette format support for PVR (thanks Mike Z) [MP]
- Fixed dirent_t to also be "struct dirent" [Christian Groessler == CG]
- **Dreamcast**: Added "volatile" in counters in maple [CG]
- **Dreamcast**: Fix for CDDA volume/panning [Fredrik Ehnbom == FE]
- **Dreamcast**: Improvement for randnum() [JU]
- **Dreamcast**: Added FASTSOUNDLIB to libmodplug flags [JU]
- **Dreamcast**: Enable OCRAM on init with INIT_OCRAM init flags [JKF]
- **Dreamcast**: Allow exceptions during G2 operations to catch bugs [MP]
- **Dreamcast**: Added arch_get_ret_addr to allow getting the return address from a func [MP]
- **Dreamcast**: Added channel inits on init for SPU, to fix CDDA [MP]
- **Dreamcast**: Changed spu_cdda_* functions to be a bit more sane [MP]
- **Dreamcast**: Added CDDA example [MP]
- **Dreamcast**: Added MAPLE_FOREACH macros [MP]
- **Dreamcast**: Changed libdcutils funcs to take pvr_ptr_t's instead of uint32's [MP]
- **Dreamcast**: Removed deprecated TA compat API, and kos_init_all/kos_shutdown_all [MP]
- **Dreamcast**: Removed deprecated init macros (BASIC_ENABLE, etc) [MP]
- **Dreamcast**: Updated libjpeg and libpng to use pvr_ptr_t's and PVR API [MP]
- **Dreamcast**: Updated Kosh to PVR API [MP]
- **Dreamcast**: Removed GhettoPlay/S3M in favor of GhettoPlay/Vorbis for a sample [MP]
- **Dreamcast**: Changed VMU low-level API to use maple_device_t [MP]
- **Dreamcast**: vmu_icon_init in libdcutils changed to vmu_set_icon, and it now sets the icon on all VMUs [MP]
- **Dreamcast**: readdir support in fs_vmu for "/vmu" [CG]
- Added strtol and _strupr [Brian Peek == BP]
- **Dreamcast**: Fixed theme support in libconio, and other misc cleanup [MP]
- **Dreamcast**: Moved Kosh to "conio" and ported to libconio [MP]
- **Dreamcast**: Added serial console support for libconio [MP]
- **Dreamcast**: Updated liboggvorbisplay to 1.0 Final [Thorsten Titze == TT]

## KallistiOS version 1.1.7
- **Dreamcast**: Fix for 320x240 on NTSC TVs [Jim Ursetto == JU]
- **Dreamcast**: Fix for readdir in fs_dcload [Bero]
- **Dreamcast**: Fix for libjpeg's jpeg_to_texture [Bero]
- Added assert(), assert_msg(), and assert.h [Megan Potter == MP]
- Fix for feof()/ferror() in stdio.c [Brian Peek == BP]
- **Dreamcast**: Added gluLookAt() [James Susinno == JS]
- **Dreamcast**: New PVR API added to replace old "ta" API [MP]
- New network API started [MP]
- **Dreamcast**: Experimental SPU DMA usage has been removed for now (it was causing issues with CD access) [MP]
- **Dreamcast**: Added DC port of PLIB [Peter Hatch == PH]
- **Dreamcast**: Fixed IRQ bug for non-threaded mode [Roger Cattermole == RC]
- Added support for PWD in non-threaded mode [MP]
- **Dreamcast**: Ported 2ndmix example to PVR API [MP]
- Added conditional compilation for addons and examples in C++ [MP]
- **Dreamcast**: Added pauses to some more libdream examples [MP]
- Port of libbz2 [Sven Oliver Moll == SOM]
- Changed around build process a bit check the README for more info [MP]
- Libc split into separate directory [MP]
- **Dreamcast**: Renamed current g2_* stuff to asic_* [MP]
- **Dreamcast**: Added new "g2bus" module to handle writing to the G2 bus [MP]
- **Dreamcast**: Fixed default AICA program [RC]
- **Dreamcast**: New streaming sound / sound effects library [MP]
- Changed dbgio_printf -> printf and added NDEBUG in thread.c [MP]
- **Dreamcast**: Fixed include arm/aica_cmd_iface.h to mp3/arm/aica_cmd_iface.h [BP]
- Cygwin fix for genromfs [Florian Schulze == FS]
- **Dreamcast**: Rockridge fix for iso9660 [Takayama Fumihiko == TF]
- **Dreamcast**: Port of XMMS' modplug [FS]
- **Dreamcast**: Fix for store queue alignment [Andrew Kieschnick == ADK]
- **Dreamcast**: Fix for stricmp/strnicmp problem with different length strings [ADK]
- **Dreamcast**: More complete AICA driver [FS]
- **Dreamcast**: atexit() support [FS]
- **Dreamcast**: Circular buffering support for sndstream [FS]
- Added atol() to libc [BP]
- Added IRQ safety primitives to spinlock and malloc [MP]
- **Dreamcast**: Double fault patches for better error handling [MP]
- **Dreamcast**: Fixes for moved files, and texture allocation support for libpng [Jeffrey McBeth == JBM]
- **Dreamcast**: New maple system [MP]
- **Dreamcast**: Added first working version of Table Fog to PVR API stubs [Paul Boese PB]
- **Dreamcast**: Ported KGL to new PVR API and Merged in Benoit Millers Changes. NOTE: glRotatef now takes angle in degrees; Maths in gltrans is completely rewritten and should be more GL compatible. [PB]
- **Dreamcast**: Created new KGL demo/example subdirectory /examples/dreamcast/kgl. Moved gl under kgl/basic/gl. Added Benoit Millers nehe02-nehe09 ports to kgl/nehe and texenv example under /kgl/basic. [PB]
- **Dreamcast**: A couple of OggVorbis fixes [Thorsten Titze == TT]
- **Dreamcast**: Added _start to work with sh-sega-dreamcast GCC / GCC 3.0.4 [MP]
- **Dreamcast**: Added timer_ms_gettime() for the number of milliseconds since startup [MP]
- Added gettimeofday(), mktime(), and localtime_r(); fixed time() [MP]
- **Dreamcast**: Fixed clash with newlib's time.h [MP]
- **Dreamcast**: Fixed rtc_unix_secs() [MP]
- **Dreamcast**: Added clock example [MP]
- **Dreamcast**: Added pvr_set_bg_color to glClearColor in glmisc.c [PB]
- **Dreamcast**: Added texture wrapping enums and functionality to KGL. Cleaned up glTexParameteri in gltex.c in the process. [PB]
- **Dreamcast**: Added texwrap example [PB]
- **Dreamcast**: Fixed some locking issues, added real date/time support to fs_vmu [MP]
- **Dreamcast**: Added vmu_pkg_* for handling VMU file headers [MP]
- **Dreamcast**: Added fs_vmu unlink() [BP]
- **Dreamcast**: Added glKosMatrixIdent() and glKosMatrixApply() to allow for optimized direct-rendering access, along with mat_trans_single() [MP]
- **Dreamcast**: added tunnel demo [PB]
- Newlib libm now included with main distro (though still a bit DC specific) [MP]
- **Dreamcast**: Created KGL programming reference in LyX [PB]
- Implement fputc and O_TRUNC [JU]
- **Dreamcast**: Fix for modesize.y % 32 != 0 [MP]
- **Dreamcast**: Fix for compilation on NetBSD [Christian Groessler = CG]
- **Dreamcast**: Patch to make adding builtins easier in Kosh [SOM]
- Updated zlib [JBM]
- **Dreamcast**: Fix glViewport to correct location of origin [PB]
- **Dreamcast**: Added glScissor function to KGL [PB]
- **Dreamcast**: Added scissor test under kgl basic examples [PB]
- **Dreamcast**: Queueing support for OggVorbis and snd_stream [MP]
- clock_t/clock()/BUFSIZ for ANSI C [JBM]
- **Dreamcast**: KGL now uses pvr_poly_cxt_t structs and pvr_poly_compile. Also resolves some blending problems [PB]
- **Dreamcast**: Added basic UBC support [MP]
- **Dreamcast**: Configurable exit support (return, menu, reboot) [MP]
- **Dreamcast**: KGL now uses pvr_poly_cxt_t structs and pvr_poly_compile. Also resolves some blending problems [PB]
- **Dreamcast**: Enabled glDepthFunc() and remapped GL to PVR depth functions so they work as expected (the ones I could test anyway) [PB]
- **Dreamcast**: PNG loader cleanups, removed O'Reilly code [JBM]
- **Dreamcast**: Fixed vid_empty() to make it actually start at VRAM base [MP]
- **Dreamcast**: Changed init process and threading (see release notes) [MP]
- **Dreamcast**: Added screen-shot facility [MP]
- Added png_write [JBM]
- Added timeout-capable semaphores [MP]
- **Dreamcast**: Fixed a bug in syscall.c which probably didn't affect anything yet [MP]
- New (slightly kludgy for now) port of lwIP to KOS NetCore API [MP]
- **Dreamcast**: Fixed memory leak in libjpeg (thanks Jacob) [MP]
- Fixed a big in gettimeofday() [CG]
- malloc_debug added calloc() [MP]
- **Dreamcast**: Double-free fix for fs_dcload [DP/BP]
- **Dreamcast**: Cleaned up a massive memory leak in liboggvorbisplay [MP]
- Added readdir support for fs_romdisk [MP]
- **Dreamcast**: Now use assert/assert_mesg to carp on user programming errors in KGL [PB]
- **Dreamcast**: Use direct render API in gldraw to submit vertices to TA [PB]
- Platform independent image functions [MP]
- Added vcheck.py script for CVS assistance [MP]
- Split pcx functions into libpcx, adapted to PII funcs [MP]
- Split tga functions into libtga, adapted to PII funcs [MP]
- **Dreamcast**: Added POSIX-style arch_exec() function [MP]
- Fix for zlib compression [JU]
- **Dreamcast**: Added kgl benchmarks directory with trimark and quadmark [PB]
- **Dreamcast**: Fix for 320x240 on VGA box [CG/DP]
- **Dreamcast**: Updated examples to latest API changes [MP]
- **Dreamcast**: Added controller button combo callback [MP]
- **Dreamcast**: Fix all examples makefiles to use $KOS_STRIP environment variable [PB]
- Added beginnings of libk++ (tiny libstdc++ replacement) [Gil Megidish/DP]
- **Dreamcast**: Adapted C++ examples to use libk++ [MP]
- **Dreamcast**: Added libconio (adapted from Kosh) for "console" programs [MP]
- **Dreamcast**: Added wump and adventure examples for libconio [MP]

## KallistiOS version 1.1.6
- **Dreamcast**: Fix for using resolutions other than 640x480 with TA [David Kuder == DCG]
- New version of dlmalloc with better thread safety [Megan Potter == MP]
- Misc fixes for the build process [Benoit Miller == BM]
- C++ compilation rules for cpp->o [BM]
- Beginnings of BSD-style C++ header support [MP]
- **Dreamcast**: G2 DMA locking for maple and SPU DMA [MP]
- **Dreamcast**: Fixes to SPU DMA to make it behave with maple and other DMAs [MP]
- **Dreamcast**: Default to initting SPU DMA during initall() [MP]
- ANSI stdio wrappers [Tobias Gloth == TG]
- **Dreamcast**: Experimental SPU DMU usage in mp3lib [MP]
- **Dreamcast**: GCC 2.x compliance fixes (var decls inside functions) [BM]
- Import of BSD ctype [BM *]
- wchar support and other ANSI fixes [BM]
- Lots of headers now have DECLS for C++, more on the way [MP]
- **Dreamcast**: Added -fno-exceptions to the default CPPFLAGS in environ.* [MP]
- Added C++ low-level memory primitives (__builtin_new, etc) [MP]
- **Dreamcast**: Added a C++ version of gltest to the examples tree [MP]
- **Dreamcast**: Added new 768xXXX modes [DCG]
- Misc source cleanups [MP]
- **Dreamcast**: ctor/dtor support [MP]
- zlib port [Jeffrey McBeth == JBM]
- **Dreamcast**: pnglib port plus DC texture loader [JBM]
- **Dreamcast**: Added cdrom_get_status() to check GD-Rom drive status [MP]
- **Dreamcast**: Updated liboggvorbis from RC3 [Thorsten Titze]
- Fixed a problem with VFS when threads weren't enabled [MP]
- **Dreamcast**: Cleaned up cruft in DC spinlock.h [MP]
- **Dreamcast**: Pre-bundled libm.a updated to latest newlib release [MP]

* Xavier Bouchoux sent this to me earlier, but I was too lazy to get
  it integrated ^_^;

## KallistiOS version 1.1.5
- **Dreamcast**: Fix for spu_write_wait() -- it was doing the opposite of what it was supposed to! (oops!) [Anders Clerwall == Scav]
- **Dreamcast**: New matrix.s [Mathieu Legris] -- note that there are now some alignment constraints on the usage of the matrix functions.. please see matrix.s for the comments if you use it!
- **Dreamcast**: KGL support for the new matrix.s [Andrew Kieschnick == ADK]
- **Dreamcast**: New video.c / video.h with a real mode table, and support for some PAL modes and 256x256! 800x608 is apparently still a bit broken in this one, so if anyone is actually using it you might have to tweak just a bit. [Scav]
- **Dreamcast**: Fixed a potential race condition in kernel/main.c [Megan Potter == MP]
- Added some new libc stuff from BSD (abs, labs, strdup, qsort, and some misc is/to upper/lower funcs)
- **Dreamcast**: Added an early implementation of alpha-blended polys to KGL [MP]
- Semaphores and condition variables weren't getting initialized [MP]
- **Dreamcast**: First pass at SPU DMA [MP]
- New isdigit() and [DC] a biosfont patch [Warren Moore]
- **Dreamcast**: New more general twiddle function [Vincent Penne == VP]
- **Dreamcast**: TA frame counter, paletted texture type defines [VP]
- abort() function [VP/DP]
- atoi, dtoa, and floating point printf support [VP]
- **Dreamcast**: randnum() fix [VP]
- **Dreamcast**: Ported over the simple serial console from KOS-MMU [MP]
- **Dreamcast**: Inline TA commit functions [VP]
- **Dreamcast**: Updated gl example to show translucency [MP]
- Added architecture checks in header files
- Fixed some prototype errors with index, rindex [?]
- **Dreamcast**: Fixed turning off vertical smoothing on VGA [MP]
- **Dreamcast**: Added polygon culling controls for KGL [ADK]
- **Dreamcast**: Ported up MMU functions from KOS-MMU [MP]
- **Dreamcast**: Imported liboggvorbisplay and GhettoPlay adapted to OGG [Thorsten Titze]

## KallistiOS version 1.1.4
- **Dreamcast**: Store queue support [Andrew Kieschnick == ADK]
- **Dreamcast**: New and improved matrix math routines [ADK]
- **Dreamcast**: Patch to KGL to clip polygons with bad w value [ADK]
- **Dreamcast**: Patch for serial I/O that does not reset the baud rate if it's already been set. This should eliminate a lot of problems with mismatched serial baud in dcload [ADK]
- **Dreamcast**: Patch to fix GL_QUADS constant [Greg Cooksey]
- **Dreamcast**: ftan support, plus KGL usage [Andrew Kieschnick == ADK]
- **Dreamcast**: Fix for iso_ioctl
- **Dreamcast**: New spinlock code works a lot better [ADK]
- **Dreamcast**: Fixed a bug where thd_enabled wasn't being set to 1 [ADK]
- **Dreamcast**: Render done seems to work again, so it's now re-enabled [ADK]
- **Dreamcast**: Added 'menu' command in KOSH to exit to the DC menus [Megan Potter == MP]
- **Dreamcast**: Added rtc_unix_secs() support for reading the current date/time [MP]
- **Dreamcast**: Fixed some problems in VMU writing related to timing and a mystery command (thanks to an oooold message from Nagra) and also did some fixes to fs_vmu. Please see the notes in README, this code still isn't really stable. [MP]
- **Dreamcast**: Added a new 'hello' example in the DC examples tree which shows a basic project skeleton which you can start with. [MP]

## KallistiOS version 1.1.3
- **Dreamcast**: Included initial test version of KallistiGL (addons/libgl)
- strstr.c was not getting included in the compile for some reason [Regex]
- **Dreamcast**: Fixed bug that could cause fs_iso9660 to run out of handles [James Surine]
- **Dreamcast**: New inline math functions [Andrew Kieschnick]
- **Dreamcast**: Added (currently non-working) MPGLIB sources
- **Dreamcast**: Some more Makefile build fixes
- **Dreamcast**: Still yet more joy of ISO fncompare() fixes [Brian Peek]
- **Dreamcast**: Changed TA far Z clipping plane to be out even farther
- **Dreamcast**: Fixes for matrix.s to make it use W properly [Andrew Kieschnick]
- **Dreamcast**: libos wasn't being built; fixed

## KallistiOS version 1.1.2
- **Dreamcast**: Fixed over-initialization of VRAM (sorry, didn't realize it was wrong)
- **Dreamcast**: Fixed some dc-load init/shutdown bugs (adk)
- Fixed a bug in the global Makefiles that made it not process the "SUBDIRS" entries normally
- **Dreamcast**: PVR functionality ("ta" module) has been separated into its own subdir, where it will eventually gain more functionality and be reorganized.
- **Dreamcast**: As part of the above reorganization, TA initialization is no longer done automatically; you can do this by adding TA_ENABLE to the call to kos_init_all (see below).
- **Dreamcast**: vid_set_mode() has been simplified to take only two arguments; a new function vid_set_mode_and_cable() is now there if you want to change cable types manually for some reason.
- **Dreamcast**: kos_init_all() has changed to a more flexible format; PLEASE LOOK at the examples to see how!
- **Dreamcast**: Fixed a bug in fs_dcload that made a listing of /pc not work

## KallistiOS version 1.1.1
- Per-thread path functions are back now, if threads are enabled.
- **Dreamcast**: dc-load console and file system support is now integrated
- **Dreamcast**: The startup procedure has changed (i.e., how you initialize the library mode). Please see the dreamcast "2ndmix" example for details.
- **Dreamcast**: MP3 player lib and S3M player lib have been integrated (though the S3M lib is a bit incomplete as of yet)
- **Dreamcast**: JPEG lib, PVR and other utils from DC Tonic's libdemocd now included
- **Dreamcast**: More OS-mode support
- **Dreamcast**: Semaphore and Condition Variable sync primitives re-imported from KOS-MMU
- **Dreamcast**: Updated the FAQ for 1.1.x
- **Dreamcast**: Included the Newlib libm in binary distributions
- **Dreamcast**: Added functions for DC's "hidden" sin/cos/sqrt functions (dc/fmath.h)
- **Dreamcast**: Added CDDA functionality in the cdrom and spu modules; also added a new "cdrom_spin_down" call to manually spin down the CD (thanks maiwe!).
- **Dreamcast**: Fixed a problem where some things (hardware, irq) might be de-initted even though they weren't initted (and cause strange problems)
- **Dreamcast**: Libdream examples now ported and included in the DC examples dir

## KallistiOS version 1.1.0
- Complete rework of the entire OS structure. Many of the incorporated changes and cleanups were ported over from the ill-fated KOS-MMU project.
- KallistiOS is now primarily built as a library. It has always worked this way in the past, but now the focus is on the library version rather than the OS version. All non-library-essential items have been moved out of the kernel tree and are currently somewhat broken. These will be fixed over the next couple of releases.
- KOS goes multi-platform! All architecture specific pieces are now moved into the 'kernel/arch' directory.
- A new GBA port was added for Nintendo(tm)'s Gameboy Advance(tm). Not much there yet for GBA, but that will change shortly.
- Everything is now compiled with -Wall and all warnings as of GCC-20010507 are cleaned up.
- New threading module, including proper condition variables, semaphores, and microkernel-style message passing.
- Tiny PCX loading function now included for GBA
- New FS call fs_mmap() added to support using ROM files as const arrays.
- arch_exit() and arch_reboot() added for escape-hatch functionality (if your program is hosed and you know it, call one of these to bail in a nice manner)
- Threading should no longer be essential in any part of the system that does not explicitly depend on it (e.g., semaphores).
- Mutexes have been renamed to spinlocks (which is what they were anyway) and moved into a header file for inlining.
- Serial I/O on DC now times out after a second or so and disables itself
- Lots more that I can't remember!

## KallistiOS version 1.0.0
- Turn off Y scaling on VGA box
- Added render-done interrupt support, to support lower frame rates
- Added rudimentary render-to-texture support
- Added semaphore and mailbox primitives to thread ABI
- Added thd_schedule_next, which the TA routines now use to reduce TA thread overhead to almost nothing
- Added fs_getwd() and fs->getwd()
- fs_romdisk is now case-insensitive
- init.klf now takes an optional command line parameter of the rc.boot name
- Added serial ABI (thanks Brian Peek)
- fs_iso9660 has improved caching now; a separate data and inode cache is kept so that directory info doesn't have to be re-fetched after loading a large file. Also increased the number of cache buffers and got rid of the moronic init_percd() on every file open behavior.
- Fixed bug in fs_iso9660 that caused Rockridge file names to be case sensitive
- Added sprintf in libc
- Kludged around a bug in maple (for now) that would trash thread structures at random (buffer overrun in DMA)
- Added malloc() debugger malloc_debug.c in the 'mm' directory. See that file for usage notes.
- Fixed some (probably irrelevant) memory leaks in startup/shutdown code for KOS
- Added an extra serial_init() call in startup/main.c so that serial output works from the very beginning.
- SVCMPX now fails (correctly) if it hasn't been initialized yet.
- Fix for Gameshark and other 3rd party VMUs that don't properly return an error code when trying to write to the VMU LCD screen (thanks Andrew Kieschnick)

## KallistiOS version 0.90
- Fixed a bug in svcmpx that would return a fake service if you didn't have the named service (thanks to Andrew Kieschnick for finding that one).
- Fixed build on Cygwin for genromfs (thanks Florian Schulze and Brian Peek)
- Fixed bug in bin2o on the cmdline help (I dunno why it worked at all!)
- Updated "goals.txt" document to reflect the changes since before KOS was started. It was still amazingly on-track but there are a few things that have changed since then.
- Inclusion of new "configure" utility for setting up compilation defaults.
- Added new G2 bus module that handles G2 interrupts; will add more later
- Fixed a bug in TA that caused problems with large scenes (thanks Andrew K. again)
- Updated TA to use new G2 module
- Fixed some build things that I found when switching to BSD (this ought to help everyone building).
- Mutexes are now inactive inside interrupts, to avoid a double-fault that causes a reset of the DC. One result of this is...
- BSOD is back (finally), though it only works over the serial port as a general rule.
- Imported BSD's sys/queue.h as bsd/queue.h
- New thread scheduler that uses priority queues and an idle task (so the real thd_sleep ought to work again).
- Fix for trailing '.' in fs_iso9660: some CD burning software adds a dot if there isn't one elsewhere in the filename (thanks Brian Peek).
- Added semaphores to the thread manager.
- Added mboxes to the thread manager.
- Added labels and pwds for threads; labels will be for eventual process listing facilities. VFS uses pwd to resolve relative paths (somewhat). Kosh also now supports this facility.
- Imported lwIP BSD-licensed TCP/IP stack; it's still pretty broken
- Fixes to the RockRidge code (AndrewK)
- load_and_fork() now takes argc,argv also
- Added new userland utility, "init" (see docs/FAQ).
- fs_romdisk now supports directories
- Although this doesn't really affect anything in the code, the naming convention for KOS executables is now to make their extension '.klf' instead of '.elf'.
- Default 'zclip' in TA module is now 0.01

## KallistiOS version 0.80
- Changed the licensing terms to full BSD-style.
- Fixed the "VGA tearing" bug for real this time (scanline int); TA should now be active and work in all video modes (in theory). 800x608 remains "experimental".
- Fixed the "tile 0 bug", which was really stupid: it was just clipping tile 0 as I had requested in the polygon header.
- Added new bin2o util that converts a binary into an object file for inclusion in the link process.
- Tightened thread locking code and irq disable code: there are still some situations where two threads can enter a critical section, but doing it "right" put an incredible load on the CPU. Thus, I just tried to minimize the possibility.
- Fixed a bug in 320x240 setup for RGB cables and VGA offset for 640x480 so it's the same as official games.
- Fixed frame buffer size in 640x480; this prevents the first bits of your texture from showing up on the bottom of the screen.
- Added a new ta_set_buffer_config() so that you can set the TA parameters like active lists and buffer sizes before calling init.
- Integrated Andrew Kieschnick's RockRidge NM extension patches for the ISO9660 file system.
- Added new romdisk file system. This is intended as a general replacement for the old "builtin" file system, though builtin still has its uses too.
- Added conio->check_getch() in Kosh and added support for that to Streamtest; also added conio->freeze() and conio->thaw() so that you can run compliant apps from Kosh now. This is just a temporary hack and will be changed later, but it works for now.
- New upstream version of Streamtest code (from our game).
- Increased default thread stack space again, this time to 64k. Tune to your liking in include/kallisti/config.h.
- Simplistic TA texture allocation system; names of texture_* funcs have changed; please see ta.c or ta.h.
- BIOS font API now supports opaque or not; the bfont_* functions have changed; please see biosfont.c or biosfont.h.
- Added default disclaimer screen for use in bootable KOS applications.
- Included new version of 2ndmix intro/demo and the original song with the romdisk image.
- Added the beginnings of a FAQ.

## KallistiOS version 0.7
- Added some "const" keywords here and there, and made an effort to remove most of the in-block stack variables and in-var initializations. There are still a few in userland programs (jam notably).
- Most things now work with default optimizations (-O1 plus some other things). -O2 seems to work for that matter, but I'm not pushing it yet =)
- Increased max simultaneous open files on /bi to 8
- Fixed iso_seek() for /cd
- Added some thread safety stuff in /pc (serconsole) and fixed some memory leaks in there. It still doesn't work right with threads. Some reciprocal fixes in konsole.
- Added some DMA-safety things in maple (timeouts, etc)
- Added mutex init in maple (oops!!)
- TA has a completely new buffer allocator now that takes texture memory into account. Also texture_map() has changed, all texture offsets should start at zero and will be mapped by TA automatically.
- TA now does almost everything relevant inside its interrupt for improved rendering response time. It also resets after each frame in case the last one didn't finish (this is an improvement from locking up the TA =). The next version ought to properly wait until the render is done.
- Moved several config options (like thread stack size, etc) into config.h
- Fixed a lot of pointer/heap corruption bugs and memory leaks in elf.c
- Fixed memory leak in process.c (ps_load_and_fork wasn't freeing the image)
- Added 'LIBS' var in userland's Makefile.prefab
- Cleaned up a few things in JAM (including removing "required" mouse support)
- Changed Kosh's \r and \n handling to be more Unix-like
- Removed a few debug lines in libk
- New userland program "streamtest" demonstrates the beta streaming AICA driver, and includes a DC/KOS port of XingMP3 from FreeAmp. Note that compiling this program from scratch requires the ARM compiler and a working libm from newlib.

## KallistiOS version 0.6
- First release
