/* ANSI C namespace clean utility typedefs */

/* This file defines various typedefs needed by the system calls that support
   the C library.  Basically, they're just the POSIX versions with an '_'
   prepended.  This file lives in the `sys' directory so targets can provide
   their own if desired (or they can put target dependant conditionals here).
*/

#ifndef _SYS__TYPES_H
#define _SYS__TYPES_H

#ifndef __off_t_defined
typedef long _off_t;
#endif

#if defined(__INT_MAX__) && __INT_MAX__ == 2147483647
typedef int _ssize_t;
#else
typedef long _ssize_t;
#endif

#define __need_wint_t
#include <stddef.h>

/* Conversion state information.  */
#ifndef __mbstate_t_defined
#define __mbstate_t_defined
typedef struct
{
    int __count;
    union
    {
        wint_t __wch;
        unsigned char __wchb[4];
    } __value;      /* Value so far.  */
} _mbstate_t;
#endif

/* Iconv descriptor type */
#ifndef __iconv_t_defined
#define __iconv_t_defined
typedef void *_iconv_t;
#endif

#endif  /* _SYS__TYPES_H */
