/*
 * INET     An implementation of the TCP/IP protocol suite for the LINUX
 *      operating system.  INET is implemented using the  BSD Socket
 *      interface as the means of communication with the user level.
 *
 *      Definitions of the Internet Protocol.
 *
 * Version: @(#)in.h    1.0.1   04/21/93
 *
 * Authors: Original taken from the GNU Project <netinet/in.h> file.
 *      Fred N. van Kempen, <waltje@uWalt.NL.Mugnet.ORG>
 *
 *      This program is free software; you can redistribute it and/or
 *      modify it under the terms of the GNU General Public License
 *      as published by the Free Software Foundation; either version
 *      2 of the License, or (at your option) any later version.
 */
#ifndef _CYGWIN_IN_H
#define _CYGWIN_IN_H

#include <stdint.h>

/* Standard well-defined IP protocols.  If you ever add one here, don't
   forget to define it below. */
enum
{
    IPPROTO_IP = 0,     /* Dummy protocol for TCP       */
    IPPROTO_ICMP = 1,       /* Internet Control Message Protocol    */
    IPPROTO_IGMP = 2,       /* Internet Gateway Management Protocol */
    IPPROTO_IPIP = 4,       /* IPIP tunnels (older KA9Q tunnels use 94) */
    IPPROTO_TCP = 6,        /* Transmission Control Protocol    */
    IPPROTO_EGP = 8,        /* Exterior Gateway Protocol        */
    IPPROTO_PUP = 12,       /* PUP protocol             */
    IPPROTO_UDP = 17,       /* User Datagram Protocol       */
    IPPROTO_IDP = 22,       /* XNS IDP protocol         */
    IPPROTO_RAW = 255,      /* Raw IP packets           */
    IPPROTO_MAX
};

/* Define IPPROTO_xxx values to accomodate SUSv3 */
#define IPPROTO_IP IPPROTO_IP
#define IPPROTO_ICMP IPPROTO_ICMP
#define IPPROTO_IGMP IPPROTO_IGMP
#define IPPROTO_IPIP IPPROTO_IPIP
#define IPPROTO_TCP IPPROTO_TCP
#define IPPROTO_EGP IPPROTO_EGP
#define IPPROTO_PUP IPPROTO_PUP
#define IPPROTO_UDP IPPROTO_UDP
#define IPPROTO_IDP IPPROTO_IDP
#define IPPROTO_RAW IPPROTO_RAW

typedef uint16_t in_port_t;
/* Standard well-known ports.  *//* from winsup/include/netinet/in.h */
enum
{
    IPPORT_ECHO = 7,        /* Echo service.  */
    IPPORT_DISCARD = 9,     /* Discard transmissions service.  */
    IPPORT_SYSTAT = 11,     /* System status service.  */
    IPPORT_DAYTIME = 13,    /* Time of day service.  */
    IPPORT_NETSTAT = 15,    /* Network status service.  */
    IPPORT_FTP = 21,        /* File Transfer Protocol.  */
    IPPORT_TELNET = 23,     /* Telnet protocol.  */
    IPPORT_SMTP = 25,       /* Simple Mail Transfer Protocol.  */
    IPPORT_TIMESERVER = 37, /* Timeserver service.  */
    IPPORT_NAMESERVER = 42, /* Domain Name Service.  */
    IPPORT_WHOIS = 43,      /* Internet Whois service.  */
    IPPORT_MTP = 57,

    IPPORT_TFTP = 69,       /* Trivial File Transfer Protocol.  */
    IPPORT_RJE = 77,
    IPPORT_FINGER = 79,     /* Finger service.  */
    IPPORT_TTYLINK = 87,
    IPPORT_SUPDUP = 95,     /* SUPDUP protocol.  */


    IPPORT_EXECSERVER = 512,    /* execd service.  */
    IPPORT_LOGINSERVER = 513,   /* rlogind service.  */
    IPPORT_CMDSERVER = 514,
    IPPORT_EFSSERVER = 520,

    /* UDP ports.  */
    IPPORT_BIFFUDP = 512,
    IPPORT_WHOSERVER = 513,
    IPPORT_ROUTESERVER = 520,

    /* Ports less than this value are reserved for privileged processes.  */
    IPPORT_RESERVED = 1024,

    /* Ports greater this value are reserved for (non-privileged) servers.  */
    IPPORT_USERRESERVED = 5000
};

typedef uint32_t in_addr_t;
/* Internet address. */
struct in_addr
{
    unsigned int s_addr;
};

/* Request struct for multicast socket ops */

struct ip_mreq
{
    struct in_addr imr_multiaddr;   /* IP multicast address of group */
    struct in_addr imr_interface;   /* local IP address of interface */
};


/* Structure describing an Internet (IP) socket address. */
#define __SOCK_SIZE__   16      /* sizeof(struct sockaddr)  */
struct sockaddr_in
{
    short int sin_family;   /* Address family       */
    unsigned short int sin_port;    /* Port number          */
    struct in_addr sin_addr;    /* Internet address     */

    /* Pad to size of `struct sockaddr'. */
    unsigned char  __pad[__SOCK_SIZE__ - sizeof(short int)
                         - sizeof(unsigned short int) - sizeof(struct in_addr)];
};
#define sin_zero    __pad       /* for BSD UNIX comp. -FvK  */

/*
 * Definitions of the bits in an Internet address integer.
 * On subnets, host and network parts are found according
 * to the subnet mask, not these masks.
 */
#define IN_CLASSA(a)        ((((long int) (a)) & 0x80000000) == 0)
#define IN_CLASSA_NET       0xff000000
#define IN_CLASSA_NSHIFT    24
#define IN_CLASSA_HOST      (0xffffffff & ~IN_CLASSA_NET)
#define IN_CLASSA_MAX       128

#define IN_CLASSB(a)        ((((long int) (a)) & 0xc0000000) == 0x80000000)
#define IN_CLASSB_NET       0xffff0000
#define IN_CLASSB_NSHIFT    16
#define IN_CLASSB_HOST      (0xffffffff & ~IN_CLASSB_NET)
#define IN_CLASSB_MAX       65536

#define IN_CLASSC(a)        ((((long int) (a)) & 0xe0000000) == 0xc0000000)
#define IN_CLASSC_NET       0xffffff00
#define IN_CLASSC_NSHIFT    8
#define IN_CLASSC_HOST      (0xffffffff & ~IN_CLASSC_NET)

#define IN_CLASSD(a)        ((((long int) (a)) & 0xf0000000) == 0xe0000000)
#define IN_MULTICAST(a)     IN_CLASSD(a)
#define IN_MULTICAST_NET    0xF0000000

#define IN_EXPERIMENTAL(a)  ((((long int) (a)) & 0xe0000000) == 0xe0000000)
#define IN_BADCLASS(a)      ((((long int) (a)) & 0xf0000000) == 0xf0000000)

/* Address to accept any incoming messages. */
#define INADDR_ANY      ((unsigned long int) 0x00000000)

/* Address to send to all hosts. */
#define INADDR_BROADCAST    ((unsigned long int) 0xffffffff)

/* Address indicating an error return. */
#define INADDR_NONE     0xffffffff

/* Network number for local host loopback. */
#define IN_LOOPBACKNET      127

/* Address to loopback in software to local host.  */
#define INADDR_LOOPBACK     0x7f000001  /* 127.0.0.1   */
#define IN_LOOPBACK(a)      ((((long int) (a)) & 0xff000000) == 0x7f000000)

/* Defines for Multicast INADDR */
#define INADDR_UNSPEC_GROUP 0xe0000000      /* 224.0.0.0   */
#define INADDR_ALLHOSTS_GROUP   0xe0000001      /* 224.0.0.1   */
#define INADDR_MAX_LOCAL_GROUP  0xe00000ff      /* 224.0.0.255 */

/* <asm/byteorder.h> contains the htonl type stuff.. */

#include <asm/byteorder.h>

/* Some random defines to make it easier in the kernel.. */
#ifdef __KERNEL__

#define LOOPBACK(x) (((x) & htonl(0xff000000)) == htonl(0x7f000000))
#define MULTICAST(x)    (((x) & htonl(0xf0000000)) == htonl(0xe0000000))

#endif

#ifdef USE_IPV6
/* IPv6 definitions as we start to include them. This is just
   a beginning dont get excited 8) */
struct in6_addr
{
    unsigned char s6_addr[16];
};

struct sockaddr_in6
{
    unsigned short sin6_family;
    unsigned short sin6_port;
    unsigned long sin6_flowinfo;
    struct in6_addr sin6_addr;
};
#endif
#endif  /* _CYGWIN_IN_H */
