# Generated by Django 4.1.10 on 2023-10-10 06:57

from django.db import migrations

import common.db.fields

users_bulked = []


def get_encrypt_fields_value(apps, *args):
    global users_bulked
    user_model = apps.get_model('users', 'User')
    bulk_size = 2000
    users = user_model.objects.all()
    users_bulked = [
        users[i:i + bulk_size]
        for i in range(0, users.count(), bulk_size)
    ]


def migrate_encrypt_fields(apps, *args):
    user_model = apps.get_model('users', 'User')
    for _users in users_bulked:
        user_model.objects.bulk_update(_users, ['phone', 'wechat'])


class Migration(migrations.Migration):
    dependencies = [
        ('users', '0047_user_date_api_key_last_used'),
    ]

    operations = [
        migrations.RunPython(get_encrypt_fields_value),
        migrations.AlterField(
            model_name='user',
            name='wechat',
            field=common.db.fields.EncryptCharField(blank=True, max_length=128, verbose_name='Wechat'),
        ),
        migrations.AlterField(
            model_name='user',
            name='phone',
            field=common.db.fields.EncryptCharField(blank=True, max_length=128, null=True, verbose_name='Phone'),
        ),
        migrations.RunPython(migrate_encrypt_fields),
    ]
