# Generated by Django 3.1.13 on 2021-12-29 10:52

from django.db import migrations, models


def migrate_app_users(apps, schema_editor):
    user_model = apps.get_model('users', 'User')
    app_users = user_model.objects.filter(role='App')
    app_users.update(is_service_account=True)


class Migration(migrations.Migration):

    dependencies = [
        ('users', '0038_auto_20211209_1140'),
    ]

    operations = [
        migrations.AddField(
            model_name='user',
            name='is_service_account',
            field=models.BooleanField(default=False, verbose_name='Is service account'),
        ),
        migrations.RunPython(migrate_app_users),
        migrations.AlterModelOptions(
            name='user',
            options={'ordering': ['username'], 'permissions': [('invite', 'Can invite user'), ('remove', 'Can remove user')], 'verbose_name': 'User'},
        ),
        migrations.AlterModelOptions(
            name='userpasswordhistory',
            options={'verbose_name': 'User password history'},
        ),
        migrations.AlterField(
            model_name='user',
            name='role',
            field=models.CharField(blank=True, default='User', max_length=10, verbose_name='Role'),
        ),
        migrations.AlterModelOptions(
            name='user',
            options={'ordering': ['username'], 'permissions': [('invite_user', 'Can invite user'), ('remove_user', 'Can remove user'), ('match_user', 'Can match user')], 'verbose_name': 'User'},
        ),
    ]
