# Generated by Django 3.1.14 on 2022-04-12 07:39

import common.db.fields
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import uuid
from django.conf import settings


def migrate_endpoints(apps, schema_editor):
    Endpoint = apps.get_model("terminal", "Endpoint")
    # migrate default
    default_data = {
        'id': '00000000-0000-0000-0000-000000000001',
        'name': 'Default',
        'host': '',
        'https_port': 0,
        'http_port': 0,
        'created_by': 'System'
    }
    Endpoint.objects.create(**default_data)

    if not settings.TERMINAL_RAZOR_ENABLED:
        return
    # migrate xrdp
    xrdp_addr = settings.TERMINAL_RDP_ADDR
    if ':' in xrdp_addr:
        host, rdp_port = xrdp_addr.strip().split(':')
    else:
        host, rdp_port = xrdp_addr, 3389
    host = host.strip()
    if host in ['localhost', '127.0.0.1']:
        host = ''
    if not host:
        return
    if isinstance(rdp_port, str) and rdp_port.isdigit():
        rdp_port = int(rdp_port)
    elif isinstance(rdp_port, int) and (0 <= rdp_port <= 65535):
        rdp_port = rdp_port
    else:
        rdp_port = 3389
    xrdp_data = {
        'name': 'Razor',
        'host': host,
        'https_port': 0,
        'http_port': 0,
        'ssh_port': 0,
        'rdp_port': rdp_port,
        'mysql_port': 0,
        'mariadb_port': 0,
        'postgresql_port': 0,
        'created_by': 'System'
    }
    xrdp_endpoint = Endpoint.objects.create(**xrdp_data)

    EndpointRule = apps.get_model("terminal", "EndpointRule")
    xrdp_rule_data = {
        'name': 'Razor',
        'ip_group': ['*'],
        'priority': 20,
        'endpoint': xrdp_endpoint,
        'created_by': 'System'
    }
    EndpointRule.objects.create(**xrdp_rule_data)


class Migration(migrations.Migration):

    dependencies = [
        ('terminal', '0047_auto_20220302_1951'),
    ]

    operations = [
        migrations.CreateModel(
            name='Endpoint',
            fields=[
                ('created_by', models.CharField(blank=True, max_length=32, null=True, verbose_name='Created by')),
                ('updated_by', models.CharField(blank=True, max_length=32, null=True, verbose_name='Updated by')),
                ('date_created', models.DateTimeField(auto_now_add=True, null=True, verbose_name='Date created')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='Date updated')),
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=128, unique=True, verbose_name='Name')),
                ('host', models.CharField(max_length=256, verbose_name='Host', blank=True)),
                ('https_port', common.db.fields.PortField(default=443, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(65535)], verbose_name='HTTPS port')),
                ('http_port', common.db.fields.PortField(default=80, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(65535)], verbose_name='HTTP port')),
                ('ssh_port', common.db.fields.PortField(default=2222, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(65535)], verbose_name='SSH port')),
                ('rdp_port', common.db.fields.PortField(default=3389, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(65535)], verbose_name='RDP port')),
                ('mysql_port', common.db.fields.PortField(default=33061, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(65535)], verbose_name='MySQL port')),
                ('mariadb_port', common.db.fields.PortField(default=33062, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(65535)], verbose_name='MariaDB port')),
                ('postgresql_port', common.db.fields.PortField(default=54320, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(65535)], verbose_name='PostgreSQL port')),
                ('comment', models.TextField(blank=True, default='', verbose_name='Comment')),
            ],
            options={
                'verbose_name': 'Endpoint',
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='EndpointRule',
            fields=[
                ('created_by', models.CharField(blank=True, max_length=32, null=True, verbose_name='Created by')),
                ('updated_by', models.CharField(blank=True, max_length=32, null=True, verbose_name='Updated by')),
                ('date_created', models.DateTimeField(auto_now_add=True, null=True, verbose_name='Date created')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='Date updated')),
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=128, unique=True, verbose_name='Name')),
                ('ip_group', models.JSONField(default=list, verbose_name='IP group')),
                ('priority', models.IntegerField(help_text='1-100, the lower the value will be match first', unique=True, validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(100)], verbose_name='Priority')),
                ('comment', models.TextField(blank=True, default='', verbose_name='Comment')),
                ('endpoint', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='rules', to='terminal.endpoint', verbose_name='Endpoint')),
            ],
            options={
                'verbose_name': 'Endpoint rule',
                'ordering': ('priority', 'name'),
            },
        ),
        migrations.RunPython(migrate_endpoints),
    ]
