# -*- coding: utf-8 -*-
# Generated by Django 1.11 on 2017-12-24 15:21
from __future__ import unicode_literals

import uuid

from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Command',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('user', models.CharField(max_length=64, verbose_name='User')),
                ('asset', models.CharField(max_length=128, verbose_name='Asset')),
                ('system_user', models.CharField(max_length=64, verbose_name='System user')),
                ('input', models.CharField(db_index=True, max_length=128, verbose_name='Input')),
                ('output', models.CharField(blank=True, max_length=1024, verbose_name='Output')),
                ('session', models.CharField(db_index=True, max_length=36, verbose_name='Session')),
                ('timestamp', models.IntegerField(db_index=True)),
            ],
            options={
                'db_table': 'terminal_command',
                'ordering': ('-timestamp',),
            },
        ),
        migrations.CreateModel(
            name='Session',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('user', models.CharField(max_length=128, verbose_name='User')),
                ('asset', models.CharField(max_length=1024, verbose_name='Asset')),
                ('system_user', models.CharField(max_length=128, verbose_name='System user')),
                ('login_from', models.CharField(choices=[('ST', 'SSH Terminal'), ('WT', 'Web Terminal')], default='ST',
                                                max_length=2)),
                ('is_finished', models.BooleanField(default=False)),
                ('has_replay', models.BooleanField(default=False, verbose_name='Replay')),
                ('has_command', models.BooleanField(default=False, verbose_name='Command')),
                ('date_start', models.DateTimeField(verbose_name='Date start')),
                ('date_end', models.DateTimeField(null=True, verbose_name='Date end')),
            ],
            options={
                'db_table': 'terminal_session',
                'ordering': ['-date_start'],
            },
        ),
        migrations.CreateModel(
            name='Status',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('session_online', models.IntegerField(default=0, verbose_name='Session Online')),
                ('cpu_used', models.FloatField(verbose_name='CPU Usage')),
                ('memory_used', models.FloatField(verbose_name='Memory Used')),
                ('connections', models.IntegerField(verbose_name='Connections')),
                ('threads', models.IntegerField(verbose_name='Threads')),
                ('boot_time', models.FloatField(verbose_name='Boot Time')),
                ('date_created', models.DateTimeField(auto_now_add=True)),
            ],
            options={
                'db_table': 'terminal_status',
                'get_latest_by': 'date_created',
            },
        ),
        migrations.CreateModel(
            name='Task',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('name',
                 models.CharField(choices=[('kill_session', 'Kill Session')], max_length=128, verbose_name='Name')),
                ('args', models.CharField(max_length=1024, verbose_name='Args')),
                ('is_finished', models.BooleanField(default=False)),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('date_finished', models.DateTimeField(null=True)),
            ],
            options={
                'db_table': 'terminal_task',
            },
        ),
        migrations.CreateModel(
            name='Terminal',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=32, unique=True, verbose_name='Name')),
                ('remote_addr', models.CharField(max_length=128, verbose_name='Remote Address')),
                ('ssh_port', models.IntegerField(default=2222, verbose_name='SSH port')),
                ('http_port', models.IntegerField(default=5000, verbose_name='HTTP port')),
                ('is_accepted', models.BooleanField(default=False, verbose_name='Is Accepted')),
                ('is_deleted', models.BooleanField(default=False)),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('comment', models.TextField(blank=True, verbose_name='Comment')),
            ],
            options={
                'db_table': 'terminal',
                'ordering': ('is_accepted',),
            },
        ),
    ]
