# Generated by Django 3.2.14 on 2022-10-26 09:07

from django.db import migrations, models


def update_builtin_org(apps, schema_editor):
    org_model = apps.get_model('orgs', 'Organization')
    org_model.objects.create(
        id='00000000-0000-0000-0000-000000000004',
        name='SYSTEM', builtin=True
    )

    # 更新 Default
    org_model.objects.filter(name='DEFAULT').update(builtin=True)


class Migration(migrations.Migration):

    dependencies = [
        ('orgs', '0013_alter_organization_options'),
    ]

    operations = [
        migrations.AddField(
            model_name='organization',
            name='builtin',
            field=models.BooleanField(default=False, verbose_name='Builtin'),
        ),
        migrations.RunPython(update_builtin_org),
        migrations.DeleteModel(
            name='OrganizationMember',
        ),
    ]
