# Generated by Django 3.2.14 on 2022-12-28 10:03

import uuid

import django.db.models.deletion
import private_storage.fields
import private_storage.storage.files
import simple_history.models
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ('assets', '0105_auto_20221220_1956'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('ops', '0022_auto_20220817_1346'),
    ]

    operations = [
        migrations.CreateModel(
            name='CeleryTask',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=1024, verbose_name='Name')),
                ('date_last_publish', models.DateTimeField(null=True, verbose_name='Date last publish')),
            ],
            options={
                'verbose_name': 'Celery Task',
                'ordering': ('name',),
                'permissions': [('view_taskmonitor', 'Can view task monitor')],
            },
        ),
        migrations.CreateModel(
            name='CeleryTaskExecution',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=1024)),
                ('args', models.JSONField(verbose_name='Args')),
                ('kwargs', models.JSONField(verbose_name='Kwargs')),
                ('state', models.CharField(max_length=16, verbose_name='State')),
                ('is_finished', models.BooleanField(default=False, verbose_name='Finished')),
                ('date_published', models.DateTimeField(auto_now_add=True, verbose_name='Date published')),
                ('date_start', models.DateTimeField(null=True, verbose_name='Date start')),
                ('date_finished', models.DateTimeField(null=True, verbose_name='Date finished')),
            ],
            options={
                'verbose_name': 'Celery Task Execution',
            },
        ),
        migrations.CreateModel(
            name='Job',
            fields=[
                ('created_by', models.CharField(blank=True, max_length=128, null=True, verbose_name='Created by')),
                ('updated_by', models.CharField(blank=True, max_length=128, null=True, verbose_name='Updated by')),
                ('date_created', models.DateTimeField(auto_now_add=True, null=True, verbose_name='Date created')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='Date updated')),
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('org_id',
                 models.CharField(blank=True, db_index=True, default='', max_length=36, verbose_name='Organization')),
                ('is_periodic', models.BooleanField(default=False, verbose_name='Periodic perform')),
                ('interval', models.IntegerField(blank=True, default=24, null=True, verbose_name='Cycle perform')),
                ('crontab', models.CharField(blank=True, max_length=128, null=True, verbose_name='Regularly perform')),
                ('name', models.CharField(max_length=128, null=True, verbose_name='Name')),
                ('instant', models.BooleanField(default=False)),
                ('args', models.CharField(blank=True, default='', max_length=1024, null=True, verbose_name='Args')),
                ('module',
                 models.CharField(choices=[('shell', 'Shell'), ('win_shell', 'Powershell'), ('python', 'Python')],
                                  default='shell', max_length=128, null=True, verbose_name='Module')),
                ('chdir', models.CharField(blank=True, default='', max_length=1024, null=True, verbose_name='Chdir')),
                ('timeout', models.IntegerField(default=-1, verbose_name='Timeout (Seconds)')),
                ('type', models.CharField(
                    choices=[('adhoc', 'Adhoc'), ('playbook', 'Playbook'), ('upload_file', 'Upload File')],
                    default='adhoc', max_length=128, verbose_name='Type')),
                ('runas', models.CharField(default='root', max_length=128, verbose_name='Runas')),
                ('runas_policy', models.CharField(
                    choices=[('privileged_only', 'Privileged Only'), ('privileged_first', 'Privileged First'),
                             ('skip', 'Skip')], default='skip', max_length=128, verbose_name='Runas policy')),
                ('use_parameter_define', models.BooleanField(default=False, verbose_name='Use Parameter Define')),
                ('parameters_define', models.JSONField(default=dict, verbose_name='Parameters define')),
                ('comment',
                 models.CharField(blank=True, default='', max_length=1024, null=True, verbose_name='Comment')),
                ('version', models.IntegerField(default=0)),
                ('assets', models.ManyToManyField(to='assets.Asset', verbose_name='Assets')),
                ('creator',
                 models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL,
                                   verbose_name='Creator')),
            ],
            options={
                'verbose_name': 'Job',
                'ordering': ['date_created'],
            },
        ),
        migrations.CreateModel(
            name='Playbook',
            fields=[
                ('created_by', models.CharField(blank=True, max_length=128, null=True, verbose_name='Created by')),
                ('updated_by', models.CharField(blank=True, max_length=128, null=True, verbose_name='Updated by')),
                ('date_created', models.DateTimeField(auto_now_add=True, null=True, verbose_name='Date created')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='Date updated')),
                ('org_id',
                 models.CharField(blank=True, db_index=True, default='', max_length=36, verbose_name='Organization')),
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=128, null=True, verbose_name='Name')),
                ('path', private_storage.fields.PrivateFileField(storage=private_storage.storage.files.PrivateFileSystemStorage(), upload_to='playbooks/')),
                ('comment',
                 models.CharField(blank=True, default='', max_length=1024, null=True, verbose_name='Comment')),
                ('creator',
                 models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL,
                                   verbose_name='Creator')),
            ],
            options={
                'abstract': False,
                'ordering': ['date_created']
            },
        ),
        migrations.CreateModel(
            name='JobExecution',
            fields=[
                ('created_by', models.CharField(blank=True, max_length=128, null=True, verbose_name='Created by')),
                ('updated_by', models.CharField(blank=True, max_length=128, null=True, verbose_name='Updated by')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='Date updated')),
                ('comment', models.TextField(blank=True, default='', verbose_name='Comment')),
                ('org_id',
                 models.CharField(blank=True, db_index=True, default='', max_length=36, verbose_name='Organization')),
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('task_id', models.UUIDField(null=True)),
                ('status', models.CharField(default='running', max_length=16, verbose_name='Status')),
                ('job_version', models.IntegerField(default=0)),
                ('parameters', models.JSONField(default=dict, verbose_name='Parameters')),
                ('result', models.JSONField(blank=True, null=True, verbose_name='Result')),
                ('summary', models.JSONField(default=dict, verbose_name='Summary')),
                ('date_created', models.DateTimeField(auto_now_add=True, verbose_name='Date created')),
                ('date_start', models.DateTimeField(db_index=True, null=True, verbose_name='Date start')),
                ('date_finished', models.DateTimeField(null=True, verbose_name='Date finished')),
                ('creator',
                 models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL,
                                   verbose_name='Creator')),
                ('job',
                 models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='executions',
                                   to='ops.job')),
            ],
            options={
                'verbose_name': 'Job Execution',
                'ordering': ['-date_created'],
            },
        ),
        migrations.AddField(
            model_name='job',
            name='playbook',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='ops.playbook',
                                    verbose_name='Playbook'),
        ),
        migrations.CreateModel(
            name='HistoricalJob',
            fields=[
                ('created_by', models.CharField(blank=True, max_length=128, null=True, verbose_name='Created by')),
                ('updated_by', models.CharField(blank=True, max_length=128, null=True, verbose_name='Updated by')),
                ('date_created',
                 models.DateTimeField(blank=True, editable=False, null=True, verbose_name='Date created')),
                ('date_updated', models.DateTimeField(blank=True, editable=False, verbose_name='Date updated')),
                ('id', models.UUIDField(db_index=True, default=uuid.uuid4)),
                ('org_id',
                 models.CharField(blank=True, db_index=True, default='', max_length=36, verbose_name='Organization')),
                ('is_periodic', models.BooleanField(default=False, verbose_name='Periodic perform')),
                ('interval', models.IntegerField(blank=True, default=24, null=True, verbose_name='Cycle perform')),
                ('crontab', models.CharField(blank=True, max_length=128, null=True, verbose_name='Regularly perform')),
                ('name', models.CharField(max_length=128, null=True, verbose_name='Name')),
                ('instant', models.BooleanField(default=False)),
                ('args', models.CharField(blank=True, default='', max_length=1024, null=True, verbose_name='Args')),
                ('module',
                 models.CharField(choices=[('shell', 'Shell'), ('win_shell', 'Powershell'), ('python', 'Python')],
                                  default='shell', max_length=128, null=True, verbose_name='Module')),
                ('chdir', models.CharField(blank=True, default='', max_length=1024, null=True, verbose_name='Chdir')),
                ('timeout', models.IntegerField(default=-1, verbose_name='Timeout (Seconds)')),
                ('type', models.CharField(
                    choices=[('adhoc', 'Adhoc'), ('playbook', 'Playbook'), ('upload_file', 'Upload File')],
                    default='adhoc', max_length=128, verbose_name='Type')),
                ('runas', models.CharField(default='root', max_length=128, verbose_name='Runas')),
                ('runas_policy', models.CharField(
                    choices=[('privileged_only', 'Privileged Only'), ('privileged_first', 'Privileged First'),
                             ('skip', 'Skip')], default='skip', max_length=128, verbose_name='Runas policy')),
                ('use_parameter_define', models.BooleanField(default=False, verbose_name='Use Parameter Define')),
                ('parameters_define', models.JSONField(default=dict, verbose_name='Parameters define')),
                ('comment',
                 models.CharField(blank=True, default='', max_length=1024, null=True, verbose_name='Comment')),
                ('version', models.IntegerField(default=0)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField(db_index=True)),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type',
                 models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('creator', models.ForeignKey(blank=True, db_constraint=False, null=True,
                                              on_delete=django.db.models.deletion.DO_NOTHING, related_name='+',
                                              to=settings.AUTH_USER_MODEL, verbose_name='Creator')),
                ('history_user',
                 models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+',
                                   to=settings.AUTH_USER_MODEL)),
                ('playbook', models.ForeignKey(blank=True, db_constraint=False, null=True,
                                               on_delete=django.db.models.deletion.DO_NOTHING, related_name='+',
                                               to='ops.playbook', verbose_name='Playbook')),
            ],
            options={
                'verbose_name': 'historical Job',
                'verbose_name_plural': 'historical Jobs',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': ('history_date', 'history_id'),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='AdHoc',
            fields=[
                ('created_by', models.CharField(blank=True, max_length=128, null=True, verbose_name='Created by')),
                ('updated_by', models.CharField(blank=True, max_length=128, null=True, verbose_name='Updated by')),
                ('date_created', models.DateTimeField(auto_now_add=True, null=True, verbose_name='Date created')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='Date updated')),
                ('org_id',
                 models.CharField(blank=True, db_index=True, default='', max_length=36, verbose_name='Organization')),
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=128, verbose_name='Name')),
                ('pattern', models.CharField(default='all', max_length=1024, verbose_name='Pattern')),
                ('module',
                 models.CharField(choices=[('shell', 'Shell'), ('win_shell', 'Powershell'), ('python', 'Python')],
                                  default='shell', max_length=128, verbose_name='Module')),
                ('args', models.CharField(default='', max_length=1024, verbose_name='Args')),
                ('comment',
                 models.CharField(blank=True, default='', max_length=1024, null=True, verbose_name='Comment')),
                ('creator',
                 models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL,
                                   verbose_name='Creator')),
            ],
            options={
                'verbose_name': 'Adhoc',
            },
        ),
        migrations.CreateModel(
            name='JobAuditLog',
            fields=[
            ],
            options={
                'verbose_name': 'Job audit log',
                'proxy': True,
                'indexes': [],
                'constraints': [],
            },
            bases=('ops.jobexecution',),
        ),
        migrations.AlterUniqueTogether(
            name='adhoc',
            unique_together={('name', 'org_id', 'creator')},
        ),
        migrations.AlterUniqueTogether(
            name='job',
            unique_together={('name', 'org_id', 'creator')},
        ),
        migrations.AlterUniqueTogether(
            name='playbook',
            unique_together={('name', 'org_id', 'creator')},
        ),
    ]
