# Generated by Django 4.1.10 on 2023-11-03 08:59

from django.db import migrations


def migrate_assets_labels(apps, schema_editor):
    old_label_model = apps.get_model('assets', 'Label')
    new_label_model = apps.get_model('labels', 'Label')
    asset_model = apps.get_model('assets', 'Asset')
    labeled_item_model = apps.get_model('labels', 'LabeledResource')

    old_labels = old_label_model.objects.all()
    new_labels = []
    old_new_label_map = {}
    for label in old_labels:
        new_label = new_label_model(name=label.name, value=label.value, org_id=label.org_id, id=label.id)
        old_new_label_map[label.id] = new_label
        new_labels.append(new_label)
    new_label_model.objects.bulk_create(new_labels, ignore_conflicts=True)

    label_relations = asset_model.labels.through.objects.all()
    bulk_size = 1000
    count = 0
    content_type = apps.get_model('contenttypes', 'contenttype').objects.get_for_model(asset_model)

    while True:
        relations = label_relations[count:count + bulk_size]
        if not relations:
            break
        count += bulk_size

        tagged_items = []
        for relation in relations:
            new_label = old_new_label_map[relation.label_id]
            tagged_item = labeled_item_model(
                label_id=new_label.id, res_type=content_type,
                res_id=relation.asset_id, org_id=new_label.org_id
            )
            tagged_items.append(tagged_item)
        labeled_item_model.objects.bulk_create(tagged_items, ignore_conflicts=True)


class Migration(migrations.Migration):

    dependencies = [
        ('labels', '0001_initial'),
        ('assets', '0125_auto_20231011_1053')
    ]

    operations = [
        migrations.RunPython(migrate_assets_labels),
    ]
