# Generated by Django 3.2.12 on 2022-07-05 11:40

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models

import authentication.models


class Migration(migrations.Migration):
    dependencies = [
        ('applications', '0021_auto_20220629_1826'),
        ('assets', '0091_auto_20220629_1826'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('authentication', '0010_temptoken'),
    ]

    operations = [
        migrations.AddField(
            model_name='connectiontoken',
            name='application',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL,
                                    related_name='connection_tokens', to='applications.application',
                                    verbose_name='Application'),
        ),
        migrations.AddField(
            model_name='connectiontoken',
            name='application_display',
            field=models.CharField(default='', max_length=128, verbose_name='Application display'),
        ),
        migrations.AddField(
            model_name='connectiontoken',
            name='asset',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL,
                                    related_name='connection_tokens', to='assets.asset', verbose_name='Asset'),
        ),
        migrations.AddField(
            model_name='connectiontoken',
            name='asset_display',
            field=models.CharField(default='', max_length=128, verbose_name='Asset display'),
        ),
        migrations.AddField(
            model_name='connectiontoken',
            name='date_expired',
            field=models.DateTimeField(default=authentication.models.date_expired_default, verbose_name='Date expired'),
        ),
        migrations.AddField(
            model_name='connectiontoken',
            name='org_id',
            field=models.CharField(blank=True, db_index=True, default='', max_length=36, verbose_name='Organization'),
        ),
        migrations.AddField(
            model_name='connectiontoken',
            name='secret',
            field=models.CharField(default='', max_length=64, verbose_name='Secret'),
        ),
        migrations.AddField(
            model_name='connectiontoken',
            name='system_user',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL,
                                    related_name='connection_tokens', to='assets.systemuser',
                                    verbose_name='System user'),
        ),
        migrations.AddField(
            model_name='connectiontoken',
            name='system_user_display',
            field=models.CharField(default='', max_length=128, verbose_name='System user display'),
        ),
        migrations.AddField(
            model_name='connectiontoken',
            name='type',
            field=models.CharField(choices=[('asset', 'Asset'), ('application', 'Application')], default='asset',
                                   max_length=16, verbose_name='Type'),
        ),
        migrations.AddField(
            model_name='connectiontoken',
            name='user',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL,
                                    related_name='connection_tokens', to=settings.AUTH_USER_MODEL, verbose_name='User'),
        ),
        migrations.AddField(
            model_name='connectiontoken',
            name='user_display',
            field=models.CharField(default='', max_length=128, verbose_name='User display'),
        ),
        migrations.AlterModelOptions(
            name='connectiontoken',
            options={'ordering': ('-date_expired',),
                     'permissions': [('view_connectiontokensecret', 'Can view connection token secret')],
                     'verbose_name': 'Connection token'},
        ),
    ]
