# Generated by Django 4.1.10 on 2023-10-07 06:37

from django.db import migrations


def add_dameng_platform(apps, schema_editor):
    platform_cls = apps.get_model('assets', 'Platform')
    automation_cls = apps.get_model('assets', 'PlatformAutomation')
    platform, _ = platform_cls.objects.update_or_create(
        name='Dameng', defaults={
            'name': 'Dameng', 'category': 'database',
            'internal': True, 'type': 'dameng',
            'domain_enabled': True, 'su_enabled': False,
            'su_method': None, 'comment': 'Dameng', 'created_by': 'System',
            'updated_by': 'System', 'custom_fields': []
        }
    )
    platform.protocols.update_or_create(name='dameng', defaults={
        'name': 'dameng', 'port': 5236, 'primary': True, 'setting': {}
    })
    automation_cls.objects.update_or_create(platform=platform, defaults={'ansible_enabled': False})


class Migration(migrations.Migration):
    dependencies = [
        ('assets', '0127_automation_remove_account'),
    ]

    operations = [
        migrations.RunPython(add_dameng_platform)
    ]
