# Generated by Django 4.1.10 on 2023-08-03 07:53

from django.db import migrations


def migrate_web_setting_safe_mode(apps, schema_editor):
    platform_protocol_cls = apps.get_model('assets', 'PlatformProtocol')
    protocols = platform_protocol_cls.objects.filter(name='http')
    for protocol in protocols:
        setting = protocol.setting or {}
        setting['safe_mode'] = False
        protocol.setting = setting
        protocol.save(update_fields=['setting'])


class Migration(migrations.Migration):

    dependencies = [
        ('assets', '0121_auto_20230725_1458'),
    ]

    operations = [
        migrations.RunPython(migrate_web_setting_safe_mode),
    ]
