# Generated by Django 3.2.17 on 2023-03-21 08:33

from django.db import migrations, models


def migrate_platform_charset(apps, schema_editor):
    platform_model = apps.get_model('assets', 'Platform')
    platform_model.objects.filter(charset='utf8').update(charset='utf-8')


def migrate_platform_protocol_primary(apps, schema_editor):
    platform_model = apps.get_model('assets', 'Platform')
    platforms = platform_model.objects.all()

    for platform in platforms:
        p = platform.protocols.filter(primary=True).first()
        if p:
            continue
        p = platform.protocols.first()
        if not p:
            continue
        p.primary = True
        p.save()


def migrate_winrm_for_win(apps, *args):
    platform_cls = apps.get_model('assets', 'Platform')
    windows_name = ['Windows', 'Windows-TLS', 'Windows-RDP']
    windows = platform_cls.objects.filter(name__in=windows_name)
    for platform in windows:
        if platform.protocols.filter(name='winrm').exists():
            continue
        data = {
            'name': 'winrm',
            'port': 5985,
            'primary': False,
            'public': False,
            'required': False,
            'default': False,
            'setting': {"use_ssl": False}
        }
        platform.protocols.create(**data)


def migrate_device_platform_automation(apps, *args):
    platform_cls = apps.get_model('assets', 'Platform')
    names = ['General', 'Cisco', 'H3C', 'Huawei']
    platforms = platform_cls.objects.filter(name__in=names, category='device')

    for platform in platforms:
        automation = getattr(platform, 'automation', None)
        if not automation:
            continue
        automation.ansible_config = {
            "ansible_connection": "local",
            "first_connect_delay": 0.5,
        }
        automation.ansible_enabled = True
        automation.change_secret_enabled = True
        automation.change_secret_method = "change_secret_by_ssh"
        automation.ping_enabled = True
        automation.ping_method = "ping_by_ssh"
        automation.verify_account_enabled = True
        automation.verify_account_method = "verify_account_by_ssh"
        automation.save()


def migrate_web_login_button_error(apps, *args):
    protocol_cls = apps.get_model('assets', 'PlatformProtocol')
    protocols = protocol_cls.objects.filter(name='http')

    for protocol in protocols:
        submit_selector = protocol.setting.get('submit_selector', '')
        submit_selector = submit_selector.replace('id=longin_button', 'id=login_button')
        protocol.setting['submit_selector'] = submit_selector
        protocol.save()


class Migration(migrations.Migration):
    dependencies = [
        ('assets', '0110_auto_20230315_1741'),
    ]

    operations = [
        migrations.AddField(
            model_name='platformprotocol',
            name='primary',
            field=models.BooleanField(default=False, verbose_name='Primary'),
        ),
        migrations.AddField(
            model_name='platformprotocol',
            name='public',
            field=models.BooleanField(default=True, verbose_name='Public'),
        ),
        migrations.RunPython(migrate_platform_charset),
        migrations.RunPython(migrate_platform_protocol_primary),
        migrations.RunPython(migrate_winrm_for_win),
        migrations.RunPython(migrate_device_platform_automation),
        migrations.RunPython(migrate_web_login_button_error),
    ]
