# Generated by Django 3.2.17 on 2023-03-15 09:41

from django.db import migrations


def set_windows_platform_non_console(apps, schema_editor):
    Platform = apps.get_model('assets', 'Platform')
    names = ['Windows', 'Windows-RDP', 'Windows-TLS', 'RemoteAppHost']
    windows = Platform.objects.filter(name__in=names)
    if not windows:
        return

    for p in windows:
        rdp = p.protocols.filter(name='rdp').first()
        if not rdp:
            continue
        rdp.setting['console'] = False
        rdp.save()


class Migration(migrations.Migration):

    dependencies = [
        ('assets', '0109_alter_asset_options'),
    ]

    operations = [
        migrations.RunPython(set_windows_platform_non_console)
    ]
