# -*- coding: utf-8 -*-
# Generated by Django 1.11 on 2018-01-26 08:37
from __future__ import unicode_literals

from django.db import migrations, models
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ('assets', '0004_auto_20180125_1218'),
    ]

    operations = [
        migrations.CreateModel(
            name='Label',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=128, verbose_name='Name')),
                ('value', models.CharField(max_length=128, verbose_name='Value')),
                ('category', models.CharField(choices=[('S', 'System'), ('U', 'User')], default='U', max_length=128, verbose_name='Category')),
                ('is_active', models.BooleanField(default=True, verbose_name='Is active')),
                ('comment', models.TextField(blank=True, null=True, verbose_name='Comment')),
                ('date_created', models.DateTimeField(auto_now_add=True, null=True, verbose_name='Date created')),
            ],
            options={
                'db_table': 'assets_label',
            },
        ),
        migrations.AlterUniqueTogether(
            name='label',
            unique_together=set([('name', 'value')]),
        ),
        migrations.AddField(
            model_name='asset',
            name='labels',
            field=models.ManyToManyField(blank=True, related_name='assets', to='assets.Label', verbose_name='Labels'),
        ),
    ]
