# -*- coding: utf-8 -*-
# Generated by Django 1.11 on 2017-12-21 16:06
from __future__ import unicode_literals

import assets.models.utils
from django.db import migrations, models
import django.db.models.deletion
import uuid


def add_default_group(apps, schema_editor):
    group_model = apps.get_model("assets", "AssetGroup")
    db_alias = schema_editor.connection.alias
    group_model.objects.using(db_alias).create(
        name="Default"
    )


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='AdminUser',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=128, unique=True, verbose_name='Name')),
                ('username', models.CharField(max_length=16, verbose_name='Username')),
                ('_password', models.CharField(blank=True, max_length=256, null=True, verbose_name='Password')),
                ('_private_key', models.TextField(blank=True, max_length=4096, null=True, validators=[assets.models.utils.private_key_validator], verbose_name='SSH private key')),
                ('_public_key', models.TextField(blank=True, max_length=4096, verbose_name='SSH public key')),
                ('comment', models.TextField(blank=True, verbose_name='Comment')),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('date_updated', models.DateTimeField(auto_now=True)),
                ('created_by', models.CharField(max_length=32, null=True, verbose_name='Created by')),
                ('become', models.BooleanField(default=True)),
                ('become_method', models.CharField(choices=[('sudo', 'sudo'), ('su', 'su')], default='sudo', max_length=4)),
                ('become_user', models.CharField(default='root', max_length=64)),
                ('_become_pass', models.CharField(default='', max_length=128)),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='Asset',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('ip', models.GenericIPAddressField(db_index=True, verbose_name='IP')),
                ('hostname', models.CharField(max_length=128, unique=True, verbose_name='Hostname')),
                ('port', models.IntegerField(default=22, verbose_name='Port')),
                ('is_active', models.BooleanField(default=True, verbose_name='Is active')),
                ('type', models.CharField(blank=True, choices=[('Server', 'Server'), ('VM', 'VM'), ('Switch', 'Switch'), ('Router', 'Router'), ('Firewall', 'Firewall'), ('Storage', 'Storage')], default='Server', max_length=16, null=True, verbose_name='Asset type')),
                ('env', models.CharField(blank=True, choices=[('Prod', 'Production'), ('Dev', 'Development'), ('Test', 'Testing')], default='Prod', max_length=8, null=True, verbose_name='Asset environment')),
                ('status', models.CharField(blank=True, choices=[('In use', 'In use'), ('Out of use', 'Out of use')], default='In use', max_length=12, null=True, verbose_name='Asset status')),
                ('public_ip', models.GenericIPAddressField(blank=True, null=True, verbose_name='Public IP')),
                ('remote_card_ip', models.CharField(blank=True, max_length=16, null=True, verbose_name='Remote control card IP')),
                ('cabinet_no', models.CharField(blank=True, max_length=32, null=True, verbose_name='Cabinet number')),
                ('cabinet_pos', models.IntegerField(blank=True, null=True, verbose_name='Cabinet position')),
                ('number', models.CharField(blank=True, max_length=32, null=True, verbose_name='Asset number')),
                ('vendor', models.CharField(blank=True, max_length=64, null=True, verbose_name='Vendor')),
                ('model', models.CharField(blank=True, max_length=54, null=True, verbose_name='Model')),
                ('sn', models.CharField(blank=True, max_length=128, null=True, verbose_name='Serial number')),
                ('cpu_model', models.CharField(blank=True, max_length=64, null=True, verbose_name='CPU model')),
                ('cpu_count', models.IntegerField(null=True, verbose_name='CPU count')),
                ('cpu_cores', models.IntegerField(null=True, verbose_name='CPU cores')),
                ('memory', models.CharField(blank=True, max_length=64, null=True, verbose_name='Memory')),
                ('disk_total', models.CharField(blank=True, max_length=1024, null=True, verbose_name='Disk total')),
                ('disk_info', models.CharField(blank=True, max_length=1024, null=True, verbose_name='Disk info')),
                ('platform', models.CharField(blank=True, max_length=128, null=True, verbose_name='Platform')),
                ('os', models.CharField(blank=True, max_length=128, null=True, verbose_name='OS')),
                ('os_version', models.CharField(blank=True, max_length=16, null=True, verbose_name='OS version')),
                ('os_arch', models.CharField(blank=True, max_length=16, null=True, verbose_name='OS arch')),
                ('hostname_raw', models.CharField(blank=True, max_length=128, null=True, verbose_name='Hostname raw')),
                ('created_by', models.CharField(blank=True, max_length=32, null=True, verbose_name='Created by')),
                ('date_created', models.DateTimeField(auto_now_add=True, null=True, verbose_name='Date created')),
                ('comment', models.TextField(blank=True, default='', max_length=128, verbose_name='Comment')),
                ('admin_user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='assets.AdminUser', verbose_name='Admin user')),
            ],
        ),
        migrations.CreateModel(
            name='AssetGroup',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=64, unique=True, verbose_name='Name')),
                ('created_by', models.CharField(blank=True, max_length=32, verbose_name='Created by')),
                ('date_created', models.DateTimeField(auto_now_add=True, null=True, verbose_name='Date created')),
                ('comment', models.TextField(blank=True, verbose_name='Comment')),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='Cluster',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=32, verbose_name='Name')),
                ('bandwidth', models.CharField(blank=True, max_length=32, verbose_name='Bandwidth')),
                ('contact', models.CharField(blank=True, max_length=128, verbose_name='Contact')),
                ('phone', models.CharField(blank=True, max_length=32, verbose_name='Phone')),
                ('address', models.CharField(blank=True, max_length=128, verbose_name='Address')),
                ('intranet', models.TextField(blank=True, verbose_name='Intranet')),
                ('extranet', models.TextField(blank=True, verbose_name='Extranet')),
                ('date_created', models.DateTimeField(auto_now_add=True, null=True, verbose_name='Date created')),
                ('operator', models.CharField(blank=True, max_length=32, verbose_name='Operator')),
                ('created_by', models.CharField(blank=True, max_length=32, verbose_name='Created by')),
                ('comment', models.TextField(blank=True, verbose_name='Comment')),
                ('admin_user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='assets.AdminUser', verbose_name='Admin user')),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='SystemUser',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=128, unique=True, verbose_name='Name')),
                ('username', models.CharField(max_length=16, verbose_name='Username')),
                ('_password', models.CharField(blank=True, max_length=256, null=True, verbose_name='Password')),
                ('_private_key', models.TextField(blank=True, max_length=4096, null=True, validators=[assets.models.utils.private_key_validator], verbose_name='SSH private key')),
                ('_public_key', models.TextField(blank=True, max_length=4096, verbose_name='SSH public key')),
                ('comment', models.TextField(blank=True, verbose_name='Comment')),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('date_updated', models.DateTimeField(auto_now=True)),
                ('created_by', models.CharField(max_length=32, null=True, verbose_name='Created by')),
                ('priority', models.IntegerField(default=10, verbose_name='Priority')),
                ('protocol', models.CharField(choices=[('ssh', 'ssh')], default='ssh', max_length=16, verbose_name='Protocol')),
                ('auto_push', models.BooleanField(default=True, verbose_name='Auto push')),
                ('sudo', models.TextField(default='/sbin/ifconfig', verbose_name='Sudo')),
                ('shell', models.CharField(default='/bin/bash', max_length=64, verbose_name='Shell')),
                ('cluster', models.ManyToManyField(blank=True, to='assets.Cluster', verbose_name='Cluster')),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.AddField(
            model_name='asset',
            name='cluster',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='assets', to='assets.Cluster', verbose_name='Cluster'),
        ),
        migrations.AddField(
            model_name='asset',
            name='groups',
            field=models.ManyToManyField(blank=True, related_name='assets', to='assets.AssetGroup', verbose_name='Asset groups'),
        ),
        migrations.AlterUniqueTogether(
            name='asset',
            unique_together=set([('ip', 'port')]),
        ),

        migrations.RunPython(add_default_group),
    ]
