# Generated by Django 3.1 on 2021-03-11 09:53

import uuid

import django.core.validators
import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='LoginACL',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('created_by', models.CharField(blank=True, max_length=32, null=True, verbose_name='Created by')),
                ('date_created', models.DateTimeField(auto_now_add=True, null=True, verbose_name='Date created')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='Date updated')),
                ('name', models.CharField(max_length=128, verbose_name='Name')),
                ('priority', models.IntegerField(default=50, help_text='1-100, the lower the value will be match first',
                                                 validators=[django.core.validators.MinValueValidator(1),
                                                             django.core.validators.MaxValueValidator(100)],
                                                 verbose_name='Priority')),
                ('is_active', models.BooleanField(default=True, verbose_name='Active')),
                ('comment', models.TextField(blank=True, default='', verbose_name='Comment')),
                ('ip_group', models.JSONField(default=list, verbose_name='Login IP')),
                ('action',
                 models.CharField(choices=[('reject', 'Reject'), ('allow', 'Allow')], default='reject', max_length=64,
                                  verbose_name='Action')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='login_acls',
                                           to=settings.AUTH_USER_MODEL, verbose_name='User')),
            ],
            options={
                'ordering': ('priority', '-is_active', 'name'),
            },
        ),
        migrations.CreateModel(
            name='LoginAssetACL',
            fields=[
                ('org_id',
                 models.CharField(blank=True, db_index=True, default='', max_length=36, verbose_name='Organization')),
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('created_by', models.CharField(blank=True, max_length=32, null=True, verbose_name='Created by')),
                ('date_created', models.DateTimeField(auto_now_add=True, null=True, verbose_name='Date created')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='Date updated')),
                ('name', models.CharField(max_length=128, verbose_name='Name')),
                ('priority', models.IntegerField(default=50, help_text='1-100, the lower the value will be match first',
                                                 validators=[django.core.validators.MinValueValidator(1),
                                                             django.core.validators.MaxValueValidator(100)],
                                                 verbose_name='Priority')),
                ('is_active', models.BooleanField(default=True, verbose_name='Active')),
                ('comment', models.TextField(blank=True, default='', verbose_name='Comment')),
                ('users', models.JSONField(verbose_name='User')),
                ('system_users', models.JSONField(verbose_name='System User')),
                ('assets', models.JSONField(verbose_name='Asset')),
                ('action',
                 models.CharField(choices=[('login_confirm', 'Login confirm')], default='login_confirm', max_length=64,
                                  verbose_name='Action')),
                ('reviewers',
                 models.ManyToManyField(blank=True, related_name='review_login_asset_acls', to=settings.AUTH_USER_MODEL,
                                        verbose_name='Reviewers')),
            ],
            options={
                'ordering': ('priority', '-is_active', 'name'),
                'unique_together': {('name', 'org_id')},
            },
        ),
    ]
