# Generated by Django 4.1.10 on 2023-08-03 08:28
from django.conf import settings
from django.db import migrations, models

import common.db.encoder


def migrate_recipients(apps, schema_editor):
    account_backup_model = apps.get_model('accounts', 'AccountBackupAutomation')
    execution_model = apps.get_model('accounts', 'AccountBackupExecution')
    for account_backup in account_backup_model.objects.all():
        recipients = list(account_backup.recipients.all())
        if not recipients:
            continue
        account_backup.recipients_part_one.set(recipients)

    objs = []
    for execution in execution_model.objects.all():
        snapshot = execution.snapshot
        recipients = snapshot.pop('recipients', {})
        snapshot.update({'recipients_part_one': recipients, 'recipients_part_two': {}})
        objs.append(execution)
    execution_model.objects.bulk_update(objs, ['snapshot'])


def migrate_snapshot(apps, schema_editor):
    model = apps.get_model('accounts', 'AccountBackupExecution')
    objs = []
    for execution in model.objects.all():
        execution.snapshot = execution.plan_snapshot
        objs.append(execution)
    model.objects.bulk_update(objs, ['snapshot'])


class Migration(migrations.Migration):
    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('accounts', '0012_auto_20230621_1456'),
    ]

    operations = [
        migrations.AddField(
            model_name='accountbackupautomation',
            name='recipients_part_one',
            field=models.ManyToManyField(
                blank=True, related_name='recipient_part_one_plans',
                to=settings.AUTH_USER_MODEL, verbose_name='Recipient part one'
            ),
        ),
        migrations.AddField(
            model_name='accountbackupautomation',
            name='recipients_part_two',
            field=models.ManyToManyField(
                blank=True, related_name='recipient_part_two_plans',
                to=settings.AUTH_USER_MODEL, verbose_name='Recipient part two'
            ),
        ),
        migrations.AddField(
            model_name='accountbackupexecution',
            name='snapshot',
            field=models.JSONField(
                default=dict, encoder=common.db.encoder.ModelJSONFieldEncoder,
                null=True, blank=True, verbose_name='Account backup snapshot'
            ),
        ),
        migrations.RunPython(migrate_snapshot),
        migrations.RunPython(migrate_recipients),
        migrations.RemoveField(
            model_name='accountbackupexecution',
            name='plan_snapshot',
        ),
        migrations.RemoveField(
            model_name='accountbackupautomation',
            name='recipients',
        ),

    ]
