# Generated by Django 3.2.16 on 2022-12-30 08:08

import uuid

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models

import common.db.encoder
import common.db.fields


class Migration(migrations.Migration):
    dependencies = [
        ('assets', '0107_automation'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('accounts', '0002_auto_20220616_0021'),
    ]

    operations = [
        migrations.CreateModel(
            name='AccountBaseAutomation',
            fields=[
            ],
            options={
                'verbose_name': 'Account automation task',
                'proxy': True,
                'indexes': [],
                'constraints': [],
            },
            bases=('assets.baseautomation',),
        ),
        migrations.CreateModel(
            name='AutomationExecution',
            fields=[
            ],
            options={
                'verbose_name': 'Automation execution',
                'verbose_name_plural': 'Automation executions',
                'permissions': [('view_changesecretexecution', 'Can view change secret execution'),
                                ('add_changesecretexecution', 'Can add change secret execution'),
                                ('view_gatheraccountsexecution', 'Can view gather accounts execution'),
                                ('add_gatheraccountsexecution', 'Can add gather accounts execution')],
                'proxy': True,
                'indexes': [],
                'constraints': [],
            },
            bases=('assets.automationexecution',),
        ),
        migrations.CreateModel(
            name='PushAccountAutomation',
            fields=[
                ('baseautomation_ptr',
                 models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True,
                                      primary_key=True, serialize=False, to='assets.baseautomation')),
                ('secret_type', models.CharField(
                    choices=[('password', 'Password'), ('ssh_key', 'SSH key'), ('access_key', 'Access key'),
                             ('token', 'Token'), ('api_key', 'API key')], default='password', max_length=16,
                    verbose_name='Secret type')),
                ('secret_strategy', models.CharField(choices=[('specific', 'Specific password'),
                                                              ('random_one', 'All assets use the same random password'),
                                                              ('random_all',
                                                               'All assets use different random password')],
                                                     default='specific', max_length=16,
                                                     verbose_name='Secret strategy')),
                ('secret', common.db.fields.EncryptTextField(blank=True, null=True, verbose_name='Secret')),
                ('password_rules', models.JSONField(default=dict, verbose_name='Password rules')),
                ('ssh_key_change_strategy', models.CharField(
                    choices=[('add', 'Append SSH KEY'), ('set', 'Empty and append SSH KEY'),
                             ('set_jms', 'Replace (The key generated by JumpServer) ')], default='add', max_length=16,
                    verbose_name='SSH key change strategy')),
                ('triggers', models.JSONField(default=list, max_length=16, verbose_name='Triggers')),
                ('username', models.CharField(max_length=128, verbose_name='Username')),
                ('action', models.CharField(max_length=16, verbose_name='Action')),
            ],
            options={
                'verbose_name': 'Push asset account',
            },
            bases=('accounts.accountbaseautomation', models.Model),
        ),

        migrations.CreateModel(
            name='GatherAccountsAutomation',
            fields=[
                ('baseautomation_ptr',
                 models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True,
                                      primary_key=True, serialize=False, to='assets.baseautomation')),
            ],
            options={
                'verbose_name': 'Gather asset accounts',
            },
            bases=('accounts.accountbaseautomation',),
        ),
        migrations.CreateModel(
            name='VerifyAccountAutomation',
            fields=[
                ('baseautomation_ptr',
                 models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True,
                                      primary_key=True, serialize=False, to='assets.baseautomation')),
            ],
            options={
                'verbose_name': 'Verify asset account',
            },
            bases=('accounts.accountbaseautomation',),
        ),
        migrations.CreateModel(
            name='ChangeSecretRecord',
            fields=[
                ('created_by', models.CharField(blank=True, max_length=128, null=True, verbose_name='Created by')),
                ('updated_by', models.CharField(blank=True, max_length=128, null=True, verbose_name='Updated by')),
                ('date_created', models.DateTimeField(auto_now_add=True, null=True, verbose_name='Date created')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='Date updated')),
                ('comment', models.TextField(blank=True, default='', verbose_name='Comment')),
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('old_secret', common.db.fields.EncryptTextField(blank=True, null=True, verbose_name='Old secret')),
                ('new_secret', common.db.fields.EncryptTextField(blank=True, null=True, verbose_name='New secret')),
                ('date_started', models.DateTimeField(blank=True, null=True, verbose_name='Date started')),
                ('date_finished', models.DateTimeField(blank=True, null=True, verbose_name='Date finished')),
                ('status', models.CharField(default='pending', max_length=16, verbose_name='Status')),
                ('error', models.TextField(blank=True, null=True, verbose_name='Error')),
                ('account',
                 models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='accounts.account')),
                ('asset', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='assets.asset')),
                ('execution',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='accounts.automationexecution')),
            ],
            options={
                'verbose_name': 'Change secret record',
            },
        ),
        migrations.CreateModel(
            name='AccountBackupExecution',
            fields=[
                ('org_id',
                 models.CharField(blank=True, db_index=True, default='', max_length=36, verbose_name='Organization')),
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('date_start', models.DateTimeField(auto_now_add=True, verbose_name='Date start')),
                ('timedelta', models.FloatField(default=0.0, null=True, verbose_name='Time')),
                ('plan_snapshot',
                 models.JSONField(blank=True, default=dict, encoder=common.db.encoder.ModelJSONFieldEncoder, null=True,
                                  verbose_name='Account backup snapshot')),
                ('trigger', models.CharField(choices=[('manual', 'Manual trigger'), ('timing', 'Timing trigger')],
                                             default='manual', max_length=128, verbose_name='Trigger mode')),
                ('reason', models.CharField(blank=True, max_length=1024, null=True, verbose_name='Reason')),
                ('is_success', models.BooleanField(default=False, verbose_name='Is success')),
                ('plan', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='execution',
                                           to='accounts.accountbackupautomation', verbose_name='Account backup plan')),
            ],
            options={
                'verbose_name': 'Account backup execution',
                'ordering': ('-date_start',),
            },
        ),
        migrations.CreateModel(
            name='ChangeSecretAutomation',
            fields=[
                ('baseautomation_ptr',
                 models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True,
                                      primary_key=True, serialize=False, to='assets.baseautomation')),
                ('secret_type', models.CharField(
                    choices=[('password', 'Password'), ('ssh_key', 'SSH key'), ('access_key', 'Access key'),
                             ('token', 'Token'), ('api_key', 'API key')], default='password', max_length=16,
                    verbose_name='Secret type')),
                ('secret_strategy', models.CharField(choices=[('specific', 'Specific password'),
                                                              ('random_one', 'All assets use the same random password'),
                                                              ('random_all',
                                                               'All assets use different random password')],
                                                     default='specific', max_length=16,
                                                     verbose_name='Secret strategy')),
                ('secret', common.db.fields.EncryptTextField(blank=True, null=True, verbose_name='Secret')),
                ('password_rules', models.JSONField(default=dict, verbose_name='Password rules')),
                ('ssh_key_change_strategy', models.CharField(
                    choices=[('add', 'Append SSH KEY'), ('set', 'Empty and append SSH KEY'),
                             ('set_jms', 'Replace (The key generated by JumpServer) ')], default='add', max_length=16,
                    verbose_name='SSH key change strategy')),
                ('recipients',
                 models.ManyToManyField(blank=True, to=settings.AUTH_USER_MODEL, verbose_name='Recipient')),
            ],
            options={
                'verbose_name': 'Change secret automation',
            },
            bases=('accounts.accountbaseautomation', models.Model),
        ),
        migrations.AlterModelOptions(
            name='automationexecution',
            options={'permissions': [('view_changesecretexecution', 'Can view change secret execution'),
                                     ('add_changesecretexecution', 'Can add change secret execution'),
                                     ('view_gatheraccountsexecution', 'Can view gather accounts execution'),
                                     ('add_gatheraccountsexecution', 'Can add gather accounts execution'),
                                     ('view_pushaccountexecution', 'Can view push account execution'),
                                     ('add_pushaccountexecution', 'Can add push account execution')],
                     'verbose_name': 'Automation execution', 'verbose_name_plural': 'Automation executions'},
        ),
        migrations.AlterModelOptions(
            name='changesecretrecord',
            options={'ordering': ('-date_started',), 'verbose_name': 'Change secret record'},
        ),
    ]
