# Contributing

Thanks for taking the time to contribute!

The easiest way to contribute to this project is by creating an issue marked as either 'Bug' or 'Feature request'. This way, we can discuss any changes and make sure they are in line with the project. In case of a requested feature that is intended for the project and reviewed positively, I usually prefer to implement the code myself, but I am open to reviewing any code you provide through a pull request.

I may sometimes add the code as a commit directly through my account instead of actually merging the pull request, but I always try to give credit to the author of the code and update the related issue with a message explaining that the functionality has been added.

I do this to make sure all new code follows guidelines such as:
- Autopep8 formatting.
- General pylint compliance, with some exceptions such as C0114, C0116, W0603, R0912, R0915, W0718, W0707, W1514, W0621, C0115, R0914, R0902, R0903, C0302.
- Docstrings with the same style as the rest of the project.
- No trailing whitespace except for a single empty line at the end of the file.
- Intelligent naming of variables and functions.
- Performance orientation.
- Extended readability and maintainability through methods described [here](https://gist.github.com/Julynx/dd500d8ae7e335c3c84684ede2293e1f).

If you follow this yourself, you will save me a lot of time, which is something I really appreciate.

> And if you like the project, but just don't have time to contribute, that's fine. There are other easy ways to support the project and show your appreciation, which I would also be very happy about:
> - ⭐ Star the project.
> - 🐦 Tweet about it.
> - 📖 Refer to this project in your project's readme.
> - 💬 Mention the project at local meetups and tell your friends/colleagues.


## Code of Conduct

This project and everyone participating in it is governed by the
[Code of Conduct](https://github.com/Julynx/string_grab/blob/main/CODE_OF_CONDUCT.md).
By participating, you are expected to uphold this code.
