
package GUI;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.swing.JOptionPane;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import DB.DBConnection;
import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class voucherPago extends javax.swing.JFrame {

    public voucherPago(String idTransaccion) {
        initComponents();
        this.setTitle("Boleta");
        setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        ImageIcon icon = new ImageIcon(getClass().getResource("/img/logo.png"));
        Image logo = icon.getImage();
        setIconImage(logo);
        cargarBoleta(idTransaccion);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        jPanel2 = new javax.swing.JPanel();
        btninprimir = new javax.swing.JButton();
        lblBoleta = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

        jPanel1.setBackground(new java.awt.Color(0, 53, 102));

        jPanel2.setBackground(new java.awt.Color(230, 230, 230));

        btninprimir.setBackground(new java.awt.Color(230, 230, 230));
        btninprimir.setFont(new java.awt.Font("Serif", 1, 18)); // NOI18N
        btninprimir.setForeground(new java.awt.Color(0, 53, 102));
        btninprimir.setIcon(new javax.swing.ImageIcon(getClass().getResource("/img/inprimir.png"))); // NOI18N
        btninprimir.setText("Inprimir");
        btninprimir.setBorder(javax.swing.BorderFactory.createMatteBorder(1, 3, 1, 3, new java.awt.Color(0, 53, 102)));
        btninprimir.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        btninprimir.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btninprimirActionPerformed(evt);
            }
        });

        lblBoleta.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 53, 102), 2));
        lblBoleta.setFocusCycleRoot(true);

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(lblBoleta, javax.swing.GroupLayout.PREFERRED_SIZE, 500, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(btninprimir, javax.swing.GroupLayout.PREFERRED_SIZE, 248, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(128, 128, 128))
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(lblBoleta, javax.swing.GroupLayout.DEFAULT_SIZE, 600, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(btninprimir, javax.swing.GroupLayout.PREFERRED_SIZE, 42, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(21, 21, 21))
        );

        jLabel3.setFont(new java.awt.Font("Serif", 1, 48)); // NOI18N
        jLabel3.setForeground(new java.awt.Color(212, 175, 55));
        jLabel3.setIcon(new javax.swing.ImageIcon(getClass().getResource("/img/logo02.png"))); // NOI18N
        jLabel3.setText("Nueva Banco Perú  ");
        jLabel3.setBorder(javax.swing.BorderFactory.createMatteBorder(0, 3, 1, 3, new java.awt.Color(212, 175, 55)));

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                .addGap(0, 20, Short.MAX_VALUE)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(jPanel2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jLabel3, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addGap(20, 20, 20))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel3)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(28, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(0, 0, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGap(0, 0, 0))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void btninprimirActionPerformed(java.awt.event.ActionEvent evt) {// GEN-FIRST:event_btninprimirActionPerformed
        // Metodo para imprimir
        try {
            // Obtiene un objeto PrinterJob para gestionar la impresión
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            printerJob.setPrintable(new Printable() {
                @Override
                public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
                    if (pageIndex > 0) {
                        return NO_SUCH_PAGE;// Retorna que no nada para imprimir
                    }
                    Graphics2D g2d = (Graphics2D) graphics;
                    g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
                    // Ajustar escala si es necesario
                    g2d.scale(0.8, 0.8);
                    lblBoleta.printAll(graphics);
                    return PAGE_EXISTS;// Retorna que si hay para imprimir
                }
            });
            // Muestra el diálogo de impresión para que el usuario pueda aceptar o cancelar
            // la impresión
            boolean printAccepted = printerJob.printDialog();
            if (printAccepted) {
                printerJob.print(); // Si el usuario acepta, procede a imprimir
            }
        } catch (PrinterException e) {
            JOptionPane.showMessageDialog(this, "Error al imprimir: " + e.getMessage(), "Error",
                    JOptionPane.ERROR_MESSAGE);
            e.printStackTrace();
        }
    }// GEN-LAST:event_btninprimirActionPerformed
private void cargarBoleta(String idTransaccion){
    try (Connection conn = DBConnection.getConnection()) {
        String sql = "SELECT * FROM TRANSACCION WHERE IDTRANSACCION = ?";
        PreparedStatement ps = conn.prepareStatement(sql);
        ps.setString(1, idTransaccion);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            String idCuenta = rs.getString("IDCUENTA");
            String idEmpleado = rs.getString("IDEMPLEADO");
            String tipoTransaccion = rs.getString("TIPOTRANSACCION");
            String descripcion = rs.getString("DESCRIPCION");
            double monto = rs.getDouble("MONTO");
            Timestamp fechaTransaccion = rs.getTimestamp("FECHATRANSACCION");
            String cuentaRecibe = rs.getString("CUENTARECIBE");
            String txtboleta = "<html>" +
                    "<div style='border: 3px solid rgb(0, 53, 102); border-radius: 10px; padding: 15px;'>" +
                    "<h1 style='color: rgb(212, 175, 55); font-family: serif; text-align: center; margin-bottom: 20px; font-size: 32px;'>Nuevo Banco Perú</h1>"
                    +
                    "<table style='width: 100%; color: rgb(0, 53, 102); font-family: serif; font-size: 14px;'>" +
                    "<tr><td><b>N° Transacción:</b></td><td>" + idTransaccion + "</td></tr>" +
                    "<tr><td><b>N° Cuenta:</b></td><td>" + idCuenta + "</td></tr>" +
                    "<tr><td><b>N° Empleado:</b></td><td>" + idEmpleado + "</td></tr>" +
                    "<tr><td><b>Tipo de Transacción:</b></td><td>" + tipoTransaccion + "</td></tr>" +
                    "<tr><td><b>Descripción:</b></td><td>" + descripcion + "</td></tr>" +
                    "<tr><td><b>Monto:</b></td><td>S/ " + String.format("%.2f", monto) + "</td></tr>" +
                    "<tr><td><b>Fecha Transacción:</b></td><td>" + fechaTransaccion + "</td></tr>" +
                    "<tr><td><b>Cuenta que Recibe:</b></td><td>" + cuentaRecibe + "</td></tr>" +
                    "</table>" +
                    "</div>" +
                    "</html>";
            lblBoleta.setText(txtboleta);
        } else {
            JOptionPane.showMessageDialog(null, "No se encontro ninguna boleta", "Error",
                    JOptionPane.WARNING_MESSAGE);
        }
    } catch (SQLException e) {
        JOptionPane.showMessageDialog(null, "Ocurrio un error", "Error", JOptionPane.WARNING_MESSAGE);
    }
}
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btninprimir;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JLabel lblBoleta;
    // End of variables declaration//GEN-END:variables
}
