/*
 * Copyright (c) 2019 Of Him Code Technology Studio
 * Jpom is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 * 			http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.PatternPool;
import cn.hutool.core.lang.RegexPool;
import cn.hutool.core.net.url.UrlBuilder;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson2.JSONObject;
import org.junit.Test;

import java.util.TimeZone;
import java.util.regex.Pattern;

/**
 * @author bwcx_jzy
 * @since Created Time 2021/8/4
 */
public class TestStr {

    @Test
    public void test() {
        System.out.println(ReUtil.get(RegexPool.NUMBERS, "7499.1 total", 0));
    }

    @Test
    public void testJsonByte() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("byte", new byte[]{1});
        System.out.println(jsonObject);
    }

    @Test
    public void testFile() {
//		String path = "/www/server/panel/"
        Pattern pattern = PatternPool.get("1", Pattern.DOTALL);
        System.out.println(ReUtil.isMatch(".end", "123end"));
        System.out.println(ReUtil.isMatch("^.+\\.(?i)(txt)$", "a.txt"));
    }

    @Test
    public void test2() {
        System.out.printf("%.2f%n", (float) 1 / (float) 2 * 100);
        System.out.println(NumberUtil.div(1, 2));
    }

    @Test
    public void testParse() {
        //String linuxCpu = LinuxSystemCommander.getLinuxCpu("%Cpu(s):  0.0 us,  0.0 sy,  0.0 ni,100.0 id,  0.0 wa,  0.0 hi,  0.0 si,  0.0 st\n");
        //System.out.println(linuxCpu);
    }

    @Test
    public void testHttp() {
        String url = "http://127.0.0.1:3000/api/node/receive_push?token=67a8777929598040444f89bd6ab6938721d84f03&workspaceId=DEFAULT";
        UrlBuilder urlBuilder = UrlBuilder.ofHttp(url);
        String build = urlBuilder.build();
        System.out.println(build);
        HttpRequest httpRequest = HttpUtil.createGet(build);
        System.out.println(httpRequest.form());
    }

    @Test
    public void testNum() {
        System.out.println(Convert.toInt("122+"));
        System.out.println(NumberUtil.parseInt("1122+"));
    }

    @Test
    public void testTimeZone() {
        System.out.println(TimeZone.getDefault().getID());
    }

    @Test
    public void testList() {
        System.out.println(CollUtil.addAll(null, CollUtil.newArrayList("")));
    }
}
