#include <stdio.h>

#include "ui-common.h"
#include "ctimeline.h"

void print_http_headers()
{
	printf("Content-type: text/html\n");
	printf("\n");
}

void print_document_start()
{
	printf("<html>\n");
	printf("<head>\n");
	printf("<title>%s</title>\n", ctx.head_title->s);
	printf("<link rel='stylesheet' href='%s'>\n", ctx.css->s);
	printf("</head>\n");
	printf("</body>\n");
}

void print_document_header()
{
	printf("<div id='ctimeline'>\n");
	printf("<header>\n");
	printf("<table>\n");

	printf("<tr>\n");
	printf(
		"<td><p class='header'>%s</p></td>\n", ctx.header_title->s);
	printf("</tr>\n");

	printf("<tr class='sub_text'>\n");
	printf(
		"<td>%s</td>\n", ctx.header_desc->s);
	printf("</tr>\n");

	printf("</table>\n");
	printf("</header>\n");
}

void print_timelines()
{
	if(ctx.branches.count <= 0)
		return;
	
	int i;
	struct ctimeline_branch *br;

	printf("<ul class='timeline'>\n");

	for(i = 0; i < ctx.branches.count; i++) {
		br = &ctx.branches.list[i];
		printf(
		"<li>\n"
		"	<div class='direction-%s'>\n"
		"		<div class='flag-wrapper'>\n"
		"			<span class='flag'>%s</span>\n"
		"			<span class='time-wrapper'><span class='time'>%d-%d</span></span>\n"
		"		</div>\n"
		"		<div class='desc'>%s</div>\n"
		"	</div>\n"
		"</li>\n",
			(i % 2) ? "left" : "right", br->name->s,
			br->age_from, br->age_to, br->desc->s);
	}

	printf("</ul>\n");
}

void print_document_end()
{
	printf("<footer class='footer'>\n");
	printf(
		"<p>generated by <a href='http://git.joursoir.net/ctimeline'>"
		"ctimeline v%s</a></p>\n", CTIMELINE_VERSION);
	printf("</footer>\n");
	printf("</div>\n"); // <!-- id='ctimeline' -->
	printf("</body>\n");
	printf("</html>\n");
}
