# Collaborator team rules and guidelines for community moderation

**As a contributor/member of the community, remember that you can always open issues about moderation and problems with how community moderation is done. We are always open to constructive criticism and feedback!**

## Responsibilities of a collaborator

As a member of the team that manages **30 seconds of C#**, you have the following responsibilities:

- **Be part of the conversation in the issue tracker.** That includes (but is not limited to) helping out new members, discussing new features and explaining decisions to people.
- **Review pull requests.** You do not have to read through all of the pull requests and review them, but taking the time each day to review a few can help a great deal.
- **Be civil and polite.** If you are about to lose your temper, take a step back and do something else. We want our interactions with the community to be polite so that more people can join the project and contribute in any way they can. Remember to always thank contributors for their help, even if it's minor changes or changes that did not make it into the project. This way we can reward and encourage people to keep being part of the community.
- **Contribute when you want, moderate when you can.** If you have a lot on your plate outside of this project, it's alright. It's better to take a break for a few days rather than hastily deal with issues and pull requests that might break things.

## Guidelines for merging pull requests and making changes to the project

- **[Usual guidelines](CONTRIBUTING.md) apply.** Make sure to follow them, like everybody else.
- **For a pull request to be considered ready to merge, there should be at least 1 (preferably 2) reviews approving it for merge.** There are, however, certain exceptions:
  - **If a pull request only fixes typos**, there is no need to wait for a second reviewer (unless you are not certain these were not typos in the first place).
  - **If a pull request only clarifies a description or enforces the style guide**, you might be able to merge it without getting a second reviewer to review it, but only if you are certain about it.
- **Changes to build scripts, guidelines and things that might break the processes we have in place need to be reviewed by [@JonasSchubert](https://github.com/JonasSchubert)** (this is temporary, but we need a baseline to make sure we break as few things as possible in the beginning).
- **If you make changes or additions, you will go through the pull request process that everyone else goes.** Exceptions apply similarly to the ones mentioned above about merging pull requests (i.e. typos, description clarification and the way script and build process changes are handled). Pull requests suggested by collaborators should be reviewed by at least two other collaborators to be considered ready to merge.
- **Pull requests that are inactive for over a week should be closed or put on hold.**