# Security Policy for HacktoberWall

## Reporting Vulnerabilities

If you discover any security vulnerabilities in **HacktoberWall**, we kindly ask you to disclose them responsibly. To report a security issue, please follow these steps:

1. **Do not create a public issue**: If you find a security vulnerability, please **do not create a public GitHub issue** as this could make the vulnerability visible to others before it's resolved.
   
2. **Contact me directly**: Send an message in X (formaly Twitter) to [**kuikilod**] with the details of the vulnerability, including:
   - A description of the issue
   - Steps to reproduce it
   - Any potential impact

3. **Expected response time**: We will do our best to respond to your report within 5 business days. Once we have confirmed the vulnerability, we will take steps to address it and keep you updated on the status.

## Supported Versions

| Version   | Supported          |
| --------- | ------------------ |
| all    | :white_check_mark:  |

## Security Best Practices

While using **HacktoberWall**, please ensure that you:

- Regularly update the dependencies to the latest versions.
- Avoid sharing sensitive data through public contributions.
- Follow common web security guidelines (e.g., use HTTPS, sanitize user inputs).

We appreciate your help in keeping **HacktoberWall** secure for everyone!
