# HacktoberWall

## 🌟 Overview

**HacktoberWall** is a simple yet engaging web app designed to celebrate Hacktoberfest! It allows participants to contribute their names to a virtual mural by editing a JSON file, making it easy for everyone to join in the fun and showcase their participation in this global event.

## 🚀 Features

- **Dynamic Mural**: View all contributors on a visually appealing grid-style wall.
- **Easy Contribution**: Simply edit the `src/data/contributors.json` file to add your name.
- **Responsive Design**: Optimized for various screen sizes, ensuring a great experience on both desktop and mobile.
- **Interactive Hover Effects**: Each participant card scales slightly on hover for a more engaging experience.

## 🛠️ Technologies Used

- **HTML**: Structure of the web app.
- **CSS**: Styling for a beautiful and responsive design.
- **JavaScript**: Fetching and displaying participant data dynamically.
- **JSON**: Storing contributor names in a structured format.


## 📈 HacktoberWall Repo Stats
| 🌟 *Stars* | 🍴 *Forks* | 🐛 *Issues* | 🔔 *Open PRs* | 🔕 *Closed PRs* | 🛠 *Languages* | ✅ *Contributors* |
|--------------|--------------|---------------|-----------------|------------------|------------------|------------------|
| ![GitHub stars](https://img.shields.io/github/stars/JollyJolli/HacktoberWall) | ![forks](https://img.shields.io/github/forks/JollyJolli/HacktoberWall) | ![issues](https://img.shields.io/github/issues/JollyJolli/HacktoberWall?color=32CD32) | ![pull requests](https://img.shields.io/github/issues-pr/JollyJolli/HacktoberWall?color=FFFF8F) | ![Closed PRs](https://img.shields.io/github/issues-pr-closed/JollyJolli/HacktoberWall?color=20B2AA) | ![Languages](https://img.shields.io/github/languages/count/JollyJolli/HacktoberWall?color=20B2AA) | ![Contributors](https://img.shields.io/github/contributors/JollyJolli/HacktoberWall?color=00FA9A) |

## ⭐️ Star History

[![Star History Chart](https://api.star-history.com/svg?repos=JollyJolli/HacktoberWall&type=Timeline)](https://star-history.com/#JollyJolli/HacktoberWall&Timeline)

## 🎁 Contributors

<a href="https://github.com/jollyjolli/hacktoberwall/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=jollyjolli/hacktoberwall&max=1000" />
</a>

## 📦 Getting Started

### 1. Clone the Repository

```bash
git clone https://github.com/JollyJolli/HacktoberWall.git
cd HacktoberWall
```

### 2. Open in Browser

Open the `index.html` file in your preferred web browser to see **HacktoberWall** in action!

### 3. Contribute

- To add your name, simply edit the `src/data/contributors.json` file in data folder:

```json
[
  {
    "name": "YourName"
  }
]
```

- Refresh the page to see your contribution reflected on the wall!

## 🤝 Contributions

We would love for you to join us! If you want to contribute to the project, please check the [CONTRIBUTING.md](CONTRIBUTING.md) file for more information on how to do so. Any contributions are welcome and appreciated. Thank you for being a part of HacktoberWall!

## 🔗 Links

- [Live Demo](https://hacktoberwall.formen.cc)

## 🛠️ ISSUES

In this section, I will list a couple of things in case anyone wants to help out. They won't be too difficult, so any contributions will be greatly appreciated!
