﻿<%@ Page Language="C#" Inherits="System.Web.Mvc.ViewPage<Jokul.Forum.MvcApp.Home.Models.OnlineUserPageModel>" MasterPageFile="../Shared/home.master" %>

<asp:Content ContentPlaceHolderID="TitleContent" runat="server">在线用户</asp:Content>

<asp:Content ContentPlaceHolderID="MainContent" runat="server">

    
    <div class="box_panel list_panel sp">
        <div class="box_panel_title">
           会员列表
        </div>
        <div class="box_panel_context">
            <div class="list_panel_cut">
                    <table>
	                    <thead>
                            <tr>
                                <td style="width:30px;">-</td>
                                <td style="width:120px;">
                                    <a href="#">用户名</a></td>
                                <td>动作</td>
                            </tr>
	                    </thead>
                        <tbody>
                            <%foreach (var User in Model.OnlineUserItems){ %>
                                <tr>
                                    <td>
                                        <%if (string.IsNullOrEmpty(User.Image)) {%>
                                            &nbsp;
                                        <%}else{ %>
                                            <img src="<%=User.Image.StartsWith("http://", StringComparison.OrdinalIgnoreCase) ? User.Image : ResolveUrl("../../../../static/images/online/" + User.Image)%>" alt="分组" />
                                        <%} %>
                                        </td>
                                    <td>
                                    <% if (User.UserId > 0){ %>
                                        <a href="<%=Url.SiteAction("Show","User",new{uid=User.UserId}) %>"><%=User.Username%></a>
                                    <%}
					                   else
					                   { %>
                                        <%=User.Username%>
                                        <%} %>
                                        </td>
                                    <td>
                                        <%=User.Description %></td>
                                </tr>
                            <%} %>
                        </tbody>
                    </table>
            </div>
        </div>
    </div>
    
    <div class="sp clearfix">
        <div class="page_panel fr">
            <%=Html.PagePartial(Model.PageIndex, Model.PageCount)%>
        </div>
    </div>



</asp:Content>