﻿<%@ Page Language="C#" Inherits="System.Web.Mvc.ViewPage<Jokul.Forum.MvcApp.Home.Models.TopicRateModel>" MasterPageFile="../Shared/home.master" %>

<asp:Content ContentPlaceHolderID="TitleContent" runat="server">主题评分</asp:Content>
<asp:Content ContentPlaceHolderID="HeadContent" runat="server">
    <link href="<%=this.ResolveUrl ("../../scripts/easydialog/easydialog.css") %>" rel="stylesheet" type="text/css" />
</asp:Content>
<asp:Content ContentPlaceHolderID="FootContent" runat="server">
    <script src="<%=this.ResolveUrl ("../../scripts/easydialog/easydialog.js") %>" type="text/javascript"></script>
    <script src="<%=this.ResolveUrl ("../../scripts/jquery.form.js") %>" type="text/javascript"></script>
    <script type="text/javascript">
        $(document).ready(function () {
            $("#reson").change(function () {
                var me = $(this);
                var c = $("form textarea");
                c.val(me.val())
                c.text(me.val());
            });

            var options = {
                beforeSubmit: function(formData, jqForm, options) {
                    easyDialog.open({container : {content : '正在提交。。。'}});
                    return true;
                },
                success: function(responseText, statusText) {
                    if (!responseText.error)
                    {
                        top.location.href=responseText.url;
                        return;
                    }
                    easyDialog.open({container : {header : '提示',content : responseText.description,noFn : true}});

                },
                error: function() {
                    easyDialog.open({container : {header : '提示',content : "服务器通讯失败",noFn : true}});
                },
                complete:function(){
                },
                url: "<%=Url.Action("Topic_Rate","Handler") %>",
                type: 'post',
                dataType: 'json'
            };
            $("#post").ajaxForm(options);
        });
    </script>
</asp:Content>
<asp:Content ContentPlaceHolderID="MainContent" runat="server">

    <div class="box_panel manage_panel">
        <div class="box_panel_title">主题评分</div>
        <div class="box_panel_context form_panel_b">
            <form id="post" method="post" action="<%=Html.Encode(Request.Url.AbsoluteUri) %>">
                <input name="url" type="hidden" value="<%=Model.ResultUrl %>" />
                <input name="bid" type="hidden" value="<%=Model.BId%>" />
                <input name="tid" type="hidden" value="<%=Model.TId%>" />
                <input name="pid" type="hidden" value="<%=Model.PId%>" />
                
                <dl>
                    <dt>
                        积分
                    </dt>
                    <dd>
                        <table>
                            <%for(int i=0;i<Model.Score.Length;i++){ %>
                                <%ExtendInfo ex = Model.Score[i]; %>
                                <%BoardRateEntity gr = Model.Grade[i]; %>
                                <%if (!ex.Enabled) continue; %>
                                <%if (gr.Inherit<=0) continue; %>
                                <tr>
                                    <td><%=ex.Name %></td>
                                    <td><input name="credit_<%=i+1 %>" type="text" value="0" class="text" /></td>
                                    <td>(<%=gr.MinValue.ToString("0.##") %> 至 <%=gr.MaxValue.ToString("0.##") %>)</td>
                                </tr>
                            <%} %>
                        </table>
                    </dd>
                </dl>
                <dl>
                    <dt>
                        评分理由
                    </dt>
                    <dd>
                        <%if (Model.ManageReason.Length > 0){ %>
                            <div>
                            快捷原因：
                            <select id="reson">
                                <option value="">自定义</option>
                                <option value="">-----</option>
                                <%foreach (var reason in Model.ManageReason){ %>
                                    <option value="<%=Server.HtmlEncode(reason) %>"><%=string.IsNullOrEmpty(reason)?"-----":reason %></option>
                                <%} %>
                            </select>
                            </div>
                        <%} %>
                        <div class="text_area">
                            <textarea cols="50" rows="5" name="reason"></textarea>
                        </div>
                    </dd>
                </dl>
                <%if(Model.CanReply){ %>
                <dl>
                    <dt>回复</dt>
                    <dd>
                        <input id="send_reply" type="checkbox" name="send_reply" value="1" checked="checked" />
                        <label for="send_reply">同时将评分理由作为回复内容进行回复</label>
                    </dd>
                </dl>
                <%} %>
                <dl>
                    <dt>通知</dt>
                    <dd>
                        <input id="send_short_message" type="checkbox" name="send_message" value="1" checked="checked" />
                        <label for="send_short_message">操作后将以站内信方式通知作者</label>
                    </dd>
                </dl>
                <div class="control button_bar clearfix">
                    <ul>
                        <li>
                            <button type="submit" name="ok" value="ok" class="button skyblue">确认</button>
                        </li>
                        <li>
                            <button type="button" name="cancel" value="cancel" onclick="javascript: history.go(-1);" class="button">返回</button>
                        </li>
                    </ul>
                </div>
            </form>
        </div>
    </div>


</asp:Content>