﻿<%@ Control Language="C#" Inherits="Jokul.Forum.MvcApp.Pages.HomeViewUserControl<Jokul.Forum.MvcApp.Home.Models.BoardCategoryModel>" %>

<%var MainBoard = Model; %>
    <%if (MainBoard.Boards.Count>0){ %>
                <%if (MainBoard.ChildCol > 1){%>
                    <table>
                        <tbody>
                            <%int currentBoardIndex = 0; %>
                            <%foreach (var childBoard in MainBoard.Boards) { %>
                                <%currentBoardIndex++; %>
                                <%if (currentBoardIndex==1){ %>
                                    <tr class="info">
                                <%} %>
                                
                                <td style="width:<%=100/MainBoard.ChildCol%>%;" class="info board">
                                    <div class="single_board clearfix">
                                        <div class="icon">
                                            <a href="<%=Url.SiteAction("Show", "Board", new { bid=childBoard.Id })%>"<%if (childBoard.Redirect) { %> target="_blank"<%}%>>
                                                <%if (childBoard.IconKey.Equals("custom", StringComparison.OrdinalIgnoreCase)) { %>
                                                    <img src="<%=childBoard.Icon %>" alt="<%=Html.Encode( childBoard.Name) %>" />
                                                <%}else{ %>
                                                    <img src="<%=ResolveUrl("../../images/board_state_"+childBoard.IconKey+".gif")%>" alt="<%=Html.Encode( childBoard.Name) %>" />
                                                <%} %>
                                            </a>
                                        </div>
                                        <div class="sbc clearfix">
                                            <strong>
                                                <a href="<%=Url.SiteAction("Show", "Board", new { bid=childBoard.Id })%>"<%if (childBoard.Redirect) { %> target="_blank"<%}%>><%=childBoard.Name %></a>
                                            </strong>
                                            <%if (ViewData.ContainsKey("main_key_index")){ %>
                                                <%=RenderPluginPoint((string)ViewData["main_key"], (int)ViewData["main_key_index"] , currentBoardIndex-1)%>
                                            <%}else{ %>
                                                <%=RenderPluginPoint((string)ViewData["main_key"] , currentBoardIndex-1)%>
                                            <%} %>
                                            <%if (childBoard.TodayTopicCount > 0) { %>
                                                <em>(<%=childBoard.TodayTopicCount%>)</em>
                                            <%} %>
                                            <%if (childBoard.IsPrivate) { %>
                                                <p><%=Html.Lang("main.board_list.private")%></p>
                                            <%} else { %>
                                                <%if (childBoard.Redirect) { %>
                                                    <p>
                                                    <a href="<%=Url.SiteAction("Show", "Board", new { bid=childBoard.Id })%>"<%if (childBoard.Redirect) { %> target="_blank"<%}%>>
                                                        链接到外部地址
                                                    </a>
                                                    </p>
                                                <%}else{ %>
                                                    <p>
                                                        <%=Html.Lang("main.board_list.topic")%>:<%=childBoard.TopicCount %>, <%=Html.Lang("main.board_list.post")%>:<%=childBoard.PostCount %>
                                                    </p>
                                                    <%if (childBoard.LastPostUserId > 0){ %>
                                                        <p>
                                                            <%=Html.Lang("main.board_list.last")%>:
                                                            <a href="<%=Url.SiteAction("Show","Topic",new{tid=childBoard.LastTopicId}) %>" title="<%=Html.Encode(Html.InterceptStr(childBoard.LastTopicTitle,30,"...")) + " By:"+Html.Encode(childBoard.LastPostUsername) %>">
                                                                <%=Html.FriendlyTime(childBoard.UpdateDatetime, "yyyy-MM-dd HH:mm") %>
                                                            </a>
                                                        </p>
                                                    <%} %>
                                                <%} %>
                                            <%} %>
                                        </div>
                                    </div>
                                </td>
                                <%if (currentBoardIndex == MainBoard.ChildCol) { %>
                                    </tr>
                                    <%currentBoardIndex = 0; %>
                                <%} %>
                            <%} %>
                            <%if (currentBoardIndex>0 && currentBoardIndex<MainBoard.ChildCol){ %>
                                <%for (int i = currentBoardIndex; i < MainBoard.ChildCol;i++ ){ %>
                                    <td style="width:<%=100/MainBoard.ChildCol%>%;" class="info">&nbsp;</td>
                                <%} %>
                                </tr>
                            <%} %>
                        </tbody>
                    </table>
                <%}else{ %>
                    <table>
                        <thead>
                            <tr>
                                <td class="board"><%=Html.Lang("main.board_list.title")%></td>
                                <td class="topic_reply">
                                    <%=Html.Lang("main.board_list.topic")%>
                                    /
                                    <%=Html.Lang("main.board_list.post")%>
                                </td>
                                <td class="last"><%=Html.Lang("main.board_list.last")%></td>
                            </tr>
                        </thead>
                        <tbody>
                            <%for (int clientIndex = 0; clientIndex < MainBoard.Boards.Count;clientIndex++ ){%>
                                <%var childBoard = MainBoard.Boards[clientIndex]; %>
                                <tr>
                                    <td class="board">
                                        <div class="single_board clearfix">
                                            <div class="icon">
                                                <a href="<%=Url.SiteAction("Show", "Board", new { bid = childBoard.Id })%>"<%if (childBoard.Redirect){ %> target="_blank"<%}%>>
                                                    <%if (childBoard.IconKey.Equals("custom", StringComparison.OrdinalIgnoreCase)){ %>
                                                        <img src="<%=childBoard.Icon%>" alt="<%=Html.Encode(childBoard.Name)%>" />
                                                    <%}else{ %>
                                                        <img src="<%=ResolveUrl("../../images/board_state_" + childBoard.IconKey + ".gif")%>" alt="<%=Html.Encode(childBoard.Name)%>"" />
                                                    <%} %>
                                                </a>
                                            </div>
                                            <div class="sbc clearfix">
                                                <strong>
                                                    <a href="<%=Url.SiteAction("Show", "Board", new { bid = childBoard.Id })%>"<%if (childBoard.Redirect){ %> target="_blank"<%}%>><%=childBoard.Name%></a>
                                                </strong>
                                                <%if (ViewData.ContainsKey("main_key_index")){ %>
                                                    <%=RenderPluginPoint((string)ViewData["main_key"], (int)ViewData["main_key_index"] , clientIndex)%>
                                                <%}else{ %>
                                                    <%=RenderPluginPoint((string)ViewData["main_key"] , clientIndex)%>
                                                <%} %>
                                                <%if (childBoard.TodayTopicCount > 0){ %>
                                                <em>(<%=childBoard.TodayTopicCount%>)</em>
                                                <%} %>
                                                <%if (!Html.IsHtmlNullOrEmpty(childBoard.Description)){ %>
                                                    <div class="description"><%=childBoard.Description%></div>
                                                <%} %>
                                                <%if (childBoard.Moderators.Any()){ %>
                                                    <p class="master">
                                                        <%=Html.Lang("main.board_list.moderator")%>:
                                                        <%for (int i = 0; i < childBoard.Moderators.Count; i++){ %>
                                                            <%if (i > 0){ %>,<%} %>
                                                            <a href="<%=Url.SiteAction("Show", "User", new { uid = childBoard.Moderators[i].UserId })%>"><%=childBoard.Moderators[i].Username%></a>
                                                        <%} %>
                                                    </p>
                                                <%} %>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="topic_reply">
                                        <%=childBoard.IsPrivate || childBoard.Redirect ? "-" : Html.FriendlyNumber(childBoard.TopicCount).ToString()%>
                                        /
                                        <i><%=childBoard.IsPrivate || childBoard.Redirect ? "-" : Html.FriendlyNumber(childBoard.PostCount).ToString()%></i>
                                    </td>
                                    <td class="last">
                                        <%if (childBoard.IsPrivate){ %>
                                            <%=Html.Lang("main.board_list.private")%>
                                        <%}else{ %>
                                            <%if (childBoard.Redirect){ %>
                                                <a href="<%=Url.SiteAction("Show", "Board", new { bid = childBoard.Id })%>"<%if (childBoard.Redirect){ %> target="_blank"<%}%>>
                                                    链接到外部地址
                                                </a>
                                            <%}else{ %>
                                                <%if (childBoard.LastTopicId > 0){ %>
												    <ul>
												    <li>
                                                        <a href="<%=Url.SiteAction("Show", "Topic", new { tid = childBoard.LastTopicId })%>" title="<%=Html.Encode(Html.Encode(childBoard.LastTopicTitle))%>"><%=Html.Encode(Html.InterceptStr(childBoard.LastTopicTitle, 80, "..."))%></a>
                                                    </li>
												    <li>By:
                                                        <a href="<%=Url.SiteAction( "Show", "User", new { uid = childBoard.LastPostUserId })%>"><%=Html.InterceptStr(childBoard.LastPostUsername, 30, "...") %></a>
                                                        ,
                                                        <a href="<%=Url.SiteAction("Show","Topic",new{tid=childBoard.LastTopicId}) %>" title="<%=Html.Encode(Html.InterceptStr(childBoard.LastTopicTitle,30,"...")) + " By:"+Html.Encode(childBoard.LastPostUsername) %>">
                                                            <span title="<%=Html.ForumTime(childBoard.UpdateDatetime).ToString("yyyy-MM-dd HH:mm")%>"><%=Html.FriendlyTime(childBoard.UpdateDatetime, "yyyy-MM-dd HH:mm")%></span>
                                                        </a>
                                                    </li>
												    </ul>
                                                <%}else{ %>
                                                    -
                                                <%} %>
                                            <%} %>
                                        <%} %>
                                    </td>
                                </tr>
                            <%} %>
                        </tbody>
                    </table>
                <%} %>
    <%}else{ %>

                <%var childBoard = MainBoard; %>
        <table>
            <tbody>
                    <tr>
                        <td class="info board">
                            <div class="single_board clearfix">
                                <div class="icon">
                                    <a href="<%=Url.SiteAction("Show", "Board", new { bid=childBoard.Id })%>"<%if (childBoard.Redirect) { %> target="_blank"<%}%>>
                                        <%if (childBoard.IconKey.Equals("custom", StringComparison.OrdinalIgnoreCase)) { %>
                                            <img src="<%=childBoard.Icon %>" alt="<%=Html.Encode( childBoard.Name) %>" />
                                        <%}else{ %>
                                            <img src="<%=ResolveUrl("../../images/board_state_"+childBoard.IconKey+".gif")%>" alt="<%=Html.Encode( childBoard.Name) %>" />
                                        <%} %>
                                    </a>
                                </div>
                                <div class="sbc clearfix">
                                    <%if (!Html.IsHtmlNullOrEmpty(childBoard.Description)){ %>
                                        <div class="description"><%=childBoard.Description%></div>
                                    <%} %>
                                    <%if (childBoard.IsPrivate) { %>
                                        <p><%=Html.Lang("main.board_list.private")%></p>
                                    <%} else { %>
                                        <%if (childBoard.Redirect) { %>
                                            <p>
                                            <a href="<%=Url.SiteAction("Show", "Board", new { bid=childBoard.Id })%>"<%if (childBoard.Redirect) { %> target="_blank"<%}%>>
                                                链接到外部地址
                                            </a>
                                            </p>
                                        <%}else{ %>
                                            <p>
                                                <%if (childBoard.TodayTopicCount > 0) { %>
                                                    <em><%=Html.Lang("ui.main.today_post_count")%>:<%=childBoard.TodayTopicCount%></em>,
                                                <%} %>
                                                <%=Html.Lang("main.board_list.topic")%>:<%=Html.FriendlyNumber(childBoard.TopicCount) %>,
                                                <%=Html.Lang("main.board_list.post")%>:<%=Html.FriendlyNumber(childBoard.PostCount) %>
                                            </p>
                                            <%if (childBoard.LastPostUserId > 0){ %>
                                                <p>
                                                    <%=Html.Lang("main.board_list.last")%>:
                                                    <a href="<%=Url.SiteAction("Show","Topic",new{tid=childBoard.LastTopicId}) %>" data-pop="<%=Html.Encode(Html.InterceptStr(childBoard.LastTopicTitle,30,"...")) + " By:"+Html.Encode(childBoard.LastPostUsername) %>">
                                                        <%=Html.FriendlyTime(childBoard.UpdateDatetime, "yyyy-MM-dd HH:mm") %>
                                                    </a>
                                                </p>
                                            <%} %>
                                        <%} %>
                                    <%} %>
                                    <%if (childBoard.Moderators.Any()){ %>
                                        <p class="master">
                                            <%=Html.Lang("main.board_list.moderator")%>:
                                            <%for (int i = 0; i < childBoard.Moderators.Count; i++){ %>
                                                <%if (i > 0){ %>,<%} %>
                                                <a href="<%=Url.SiteAction("Show", "User", new { uid = childBoard.Moderators[i].UserId })%>"><%=childBoard.Moderators[i].Username%></a>
                                            <%} %>
                                        </p>
                                    <%} %>
                                </div>
                            </div>
                        </td>
                    </tr>
            </tbody>
        </table>
    <%} %>